/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.it;

import org.apache.log4j.Logger;
import simpack.api.impl.AbstractSimilarityMeasure;
import simpack.util.conversion.CommonDistanceConversion;

public class JensenShannon
extends AbstractSimilarityMeasure {
    private static Logger logger = Logger.getLogger(JensenShannon.class);
    private static final double log2 = Math.log(2.0);
    private double[] a;
    private double[] b;

    public JensenShannon(double[] dArray, double[] dArray2) {
        this.a = dArray;
        this.b = dArray2;
    }

    public boolean calculate() {
        this.setCalculated(false);
        double d = this.jensenShannonDivergence(this.a, this.b);
        this.similarity = new CommonDistanceConversion().convert(d);
        this.setCalculated(true);
        return true;
    }

    private double jensenShannonDivergence(double[] dArray, double[] dArray2) {
        double[] dArray3 = this.average(dArray, dArray2);
        double d = this.klDivergence(dArray, dArray3);
        double d2 = this.klDivergence(dArray2, dArray3);
        return (d + d2) / 2.0;
    }

    private double[] average(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = (dArray[i] + dArray2[i]) * 0.5;
        }
        return dArray3;
    }

    private double klDivergence(double[] dArray, double[] dArray2) {
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            double d2 = dArray[i];
            if (d2 == 0.0) continue;
            double d3 = dArray2[i];
            double d4 = Math.log(d2 / d3);
            if (d4 == Double.NEGATIVE_INFINITY) {
                return Double.NEGATIVE_INFINITY;
            }
            d += d2 * (d4 / log2);
        }
        return d;
    }
}

