/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractSimilarityMeasure;
import simpack.exception.InvalidElementException;

public class ScaledShortestPath
extends AbstractSimilarityMeasure {
    static Logger logger = Logger.getLogger(ScaledShortestPath.class);
    private IGraphAccessor graphAccessor;
    private IGraphNode nodeA;
    private IGraphNode nodeB;

    public ScaledShortestPath(IGraphAccessor iGraphAccessor, IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        this.graphAccessor = iGraphAccessor;
        this.nodeA = iGraphNode;
        this.nodeB = iGraphNode2;
        if (!iGraphAccessor.contains(iGraphNode)) {
            throw new InvalidElementException(((Object)iGraphNode).toString() + " not in graph");
        }
        if (!iGraphAccessor.contains(iGraphNode2)) {
            throw new InvalidElementException(((Object)iGraphNode2).toString() + " not in graph");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        try {
            double d = this.graphAccessor.getShortestPath(this.nodeA, this.nodeB);
            double d2 = this.graphAccessor.getMaxDepth();
            this.similarity = d == 0.0 ? new Double(0.0) : new Double(-1.0 * Math.log(d / (2.0 * d2)));
            this.setCalculated(true);
            return true;
        }
        catch (InvalidElementException invalidElementException) {
            invalidElementException.printStackTrace();
            return false;
        }
    }
}

