/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.measure.graph.MaxCommonSubgraphIsoValiente;
import simpack.util.graph.Clique;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxGraphIsoCoveringValiente
extends MaxCommonSubgraphIsoValiente {
    public static Logger logger = Logger.getLogger(MaxGraphIsoCoveringValiente.class);
    public static String DEFAULT_GRAPH_TO_COVER = "larger";
    public static boolean DEFAULT_COVERAGE_STYLE = false;
    private String graphToCover = DEFAULT_GRAPH_TO_COVER;
    private boolean bothDisjointCoverage = DEFAULT_COVERAGE_STYLE;
    private TreeMap<Integer, ArrayList<Clique>> iso;
    private ArrayList<Clique> covering;

    public MaxGraphIsoCoveringValiente(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2) {
        super(iGraphAccessor, iGraphAccessor2, MaxCommonSubgraphIsoValiente.DEFAULT_MIN_CLIQUE_SIZE, MaxCommonSubgraphIsoValiente.DEFAULT_STRUCTURE_WEIGHT, MaxCommonSubgraphIsoValiente.DEFAULT_LABEL_WEIGHT, MaxCommonSubgraphIsoValiente.DEFAULT_DENOMINATOR);
        this.iso = new TreeMap();
    }

    public MaxGraphIsoCoveringValiente(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2, int n, double d, double d2, String string, String string2, boolean bl) {
        super(iGraphAccessor, iGraphAccessor2, n, d, d2, string);
        this.graphToCover = string2;
        this.bothDisjointCoverage = bl;
        this.iso = new TreeMap();
    }

    @Override
    public void nextMaximalClique(TreeSet<MappedVertex> treeSet, TreeSet<MappedVertex> treeSet2, TreeSet<MappedVertex> treeSet3, int n) {
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        TreeSet<MappedVertex> treeSet4 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex serializable : treeSet3) {
            treeSet4.add(serializable);
        }
        if (treeSet.isEmpty()) {
            if (treeSet2.isEmpty() && treeSet4.size() >= n) {
                double d;
                Clique clique;
                int mappedVertex2;
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + treeSet4));
                }
                if (this.iso.containsKey(mappedVertex2 = (clique = new Clique(treeSet4, d = this.getCliqueSimilarity(treeSet4), true)).getClique().size())) {
                    ArrayList<Clique> arrayList = this.iso.get(clique.getClique().size());
                    arrayList.add(clique);
                } else {
                    ArrayList<Clique> arrayList = new ArrayList<Clique>();
                    arrayList.add(clique);
                    this.iso.put(mappedVertex2, arrayList);
                }
            }
        } else {
            if (treeSet4.size() >= n) {
                ArrayList<Object> arrayList;
                double d = this.getCliqueSimilarity(treeSet4);
                Clique clique = new Clique(treeSet4, d, false);
                int n2 = clique.getClique().size();
                if (this.iso.containsKey(n2)) {
                    arrayList = this.iso.get(n2);
                    if (!arrayList.contains(clique)) {
                        arrayList.add(clique);
                    }
                } else {
                    arrayList = new ArrayList<Clique>();
                    arrayList.add(clique);
                    this.iso.put(n2, arrayList);
                }
            }
            while (!treeSet.isEmpty()) {
                MappedVertex mappedVertex = treeSet.first();
                treeSet.remove(mappedVertex);
                TreeSet<MappedVertex> treeSet5 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<MappedVertex> treeSet6 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + mappedVertex);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : (TreeSet)this.adjacentMap.get(mappedVertex)) {
                    if (treeSet.contains(mappedVertex2)) {
                        treeSet5.add(mappedVertex2);
                    }
                    if (!treeSet2.contains(mappedVertex2)) continue;
                    treeSet6.add(mappedVertex2);
                }
                treeSet3.add(mappedVertex);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + treeSet3);
                    System.out.println("new candidates: " + treeSet5);
                }
                this.nextMaximalClique(treeSet5, treeSet6, treeSet3, n);
                treeSet3.remove(mappedVertex);
                treeSet2.add(mappedVertex);
            }
        }
    }

    public void findDisjointCliques(ArrayList<Clique> arrayList) {
        ArrayList<Clique> arrayList2 = this.iso.get(this.iso.lastKey());
        Collections.sort(arrayList2);
        Clique clique = arrayList2.get(0);
        logger.debug((Object)("Max clique found " + clique.getClique().toString()));
        arrayList.add(clique);
        TreeSet<IGraphNode> treeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (MappedVertex object2 : clique.getClique()) {
            if (this.graphToCover.equals("smaller")) {
                if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                    treeSet.add(object2.getLeftNode());
                    continue;
                }
                treeSet.add(object2.getRightNode());
                continue;
            }
            if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                treeSet.add(object2.getRightNode());
                continue;
            }
            treeSet.add(object2.getLeftNode());
        }
        Set<Map.Entry<Integer, ArrayList<Clique>>> set = this.iso.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            int n = (Integer)entry.getKey();
            ArrayList arrayList3 = (ArrayList)entry.getValue();
            Iterator iterator2 = arrayList3.iterator();
            block2: while (iterator2.hasNext()) {
                Clique clique2 = (Clique)iterator2.next();
                for (MappedVertex mappedVertex : clique2.getClique()) {
                    if (this.graphToCover.equals("smaller")) {
                        if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                            if (!treeSet.contains(mappedVertex.getLeftNode())) continue;
                            iterator2.remove();
                            continue block2;
                        }
                        if (!treeSet.contains(mappedVertex.getRightNode())) continue;
                        iterator2.remove();
                        continue block2;
                    }
                    if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                        if (!treeSet.contains(mappedVertex.getRightNode())) continue;
                        iterator2.remove();
                        continue block2;
                    }
                    if (!treeSet.contains(mappedVertex.getLeftNode())) continue;
                    iterator2.remove();
                    continue block2;
                }
            }
            if (!arrayList3.isEmpty()) continue;
            iterator.remove();
        }
        if (!this.iso.isEmpty()) {
            this.findDisjointCliques(arrayList);
        }
    }

    public void findBothDisjointCliques(ArrayList<Clique> arrayList) {
        ArrayList<Clique> arrayList2 = this.iso.get(this.iso.lastKey());
        Collections.sort(arrayList2);
        Clique clique = arrayList2.get(0);
        logger.debug((Object)("Max clique found " + clique.getClique().toString()));
        arrayList.add(clique);
        TreeSet<IGraphNode> treeSet = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        TreeSet<IGraphNode> treeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (MappedVertex object2 : clique.getClique()) {
            treeSet.add(object2.getLeftNode());
            treeSet2.add(object2.getRightNode());
        }
        Set<Map.Entry<Integer, ArrayList<Clique>>> set = this.iso.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            int n = (Integer)entry.getKey();
            ArrayList arrayList3 = (ArrayList)entry.getValue();
            Iterator iterator2 = arrayList3.iterator();
            block2: while (iterator2.hasNext()) {
                Clique clique2 = (Clique)iterator2.next();
                for (MappedVertex mappedVertex : clique2.getClique()) {
                    if (treeSet.contains(mappedVertex.getLeftNode())) {
                        iterator2.remove();
                        continue block2;
                    }
                    if (!treeSet2.contains(mappedVertex.getRightNode())) continue;
                    iterator2.remove();
                    continue block2;
                }
            }
            if (!arrayList3.isEmpty()) continue;
            iterator.remove();
        }
        if (!this.iso.isEmpty()) {
            this.findBothDisjointCliques(arrayList);
        }
    }

    public TreeMap<Integer, ArrayList<Clique>> getAllIsomorphisms() {
        return this.iso;
    }

    public ArrayList<Clique> getCovering() {
        return this.covering;
    }

    @Override
    public boolean calculate() {
        if (super.calculate()) {
            this.setCalculated(true);
            this.covering = new ArrayList();
            if (this.bothDisjointCoverage) {
                this.findBothDisjointCliques(this.covering);
            } else {
                this.findDisjointCliques(this.covering);
            }
            double d = this.covering.size();
            double d2 = 0.0;
            d2 = this.graphToCover.equals("larger") ? (this.graphAccessor1.size() >= this.graphAccessor2.size() ? -d / (double)this.graphAccessor1.size() + 1.0 : -d / (double)this.graphAccessor2.size() + 1.0) : (this.graphAccessor1.size() <= this.graphAccessor2.size() ? -d / (double)this.graphAccessor1.size() + 1.0 : -d / (double)this.graphAccessor2.size() + 1.0);
            this.similarity = new Double(d2);
            this.setCalculated(true);
            return true;
        }
        this.setCalculated(false);
        return false;
    }

    private double getCliqueSimilarity(TreeSet<MappedVertex> treeSet) {
        logger.debug((Object)("clique: " + treeSet));
        double d = 0.0;
        for (MappedVertex mappedVertex : treeSet) {
            d += mappedVertex.calculateLabelSimilarity();
        }
        double d2 = (double)treeSet.size() / this.graphsSize;
        double d3 = this.labelWeight * (d /= this.graphsSize) + this.structureWeight * d2;
        return d3;
    }
}

