/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.measure.graph.SubgraphIsomorphism;
import simpack.util.DeepCopy;
import simpack.util.graph.Clique;
import simpack.util.graph.MappedVertex;
import simpack.util.graph.comparator.MappedVertexComparator;
import simpack.util.graph.comparator.NamedGraphNodeComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxGraphIsoCovering
extends SubgraphIsomorphism {
    public static Logger logger = Logger.getLogger(MaxGraphIsoCovering.class);
    public static String DEFAULT_COVERING = "smaller";
    private String graphToCover = DEFAULT_COVERING;
    private TreeMap<Integer, ArrayList<Clique>> iso;
    private ArrayList<Clique> covering;

    public MaxGraphIsoCovering(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2) {
        super(iGraphAccessor, iGraphAccessor2, DEFAULT_NODE_LABEL_SIMILARITY_MEASURE, DEFAULT_MIN_CLIQUE_SIZE, DEFAULT_LABEL_WEIGHT, DEFAULT_STRUCTURE_WEIGHT, DEFAULT_DENOMINATOR, NODE_GROUPING);
        this.iso = new TreeMap();
    }

    public MaxGraphIsoCovering(IGraphAccessor iGraphAccessor, IGraphAccessor iGraphAccessor2, String string, int n, double d, double d2, String string2, boolean bl, String string3) {
        super(iGraphAccessor, iGraphAccessor2, string, n, d, d2, string2, bl);
        this.graphToCover = string3;
        this.iso = new TreeMap();
    }

    @Override
    public void nextMaximalClique(TreeSet<MappedVertex> treeSet, TreeSet<IGraphNode> treeSet2, TreeSet<IGraphNode> treeSet3, TreeSet<MappedVertex> treeSet4, int n) {
        TreeSet<IGraphNode> treeSet5;
        ++this.countLoop;
        if (Math.IEEEremainder(this.countLoop, 2000000.0) == 0.0) {
            logger.debug((Object)("countLoop: " + this.countLoop));
        }
        int n2 = 0;
        TreeSet<MappedVertex> treeSet6 = new TreeSet<MappedVertex>(new MappedVertexComparator());
        for (MappedVertex serializable : treeSet4) {
            treeSet5 = (MappedVertex)DeepCopy.copy(serializable);
            treeSet6.add((MappedVertex)((Object)treeSet5));
        }
        for (MappedVertex mappedVertex : treeSet6) {
            if (mappedVertex.isGroup()) {
                n2 += mappedVertex.getGroupSize();
                continue;
            }
            ++n2;
        }
        if (treeSet.isEmpty()) {
            if (n2 >= n) {
                ++this.countCliq;
                if (Math.IEEEremainder(this.countCliq, 200000.0) == 0.0) {
                    logger.debug((Object)("Cliq: " + this.countCliq + " " + treeSet6));
                }
                double d = this.getCliqueSimilarity(treeSet6);
                treeSet5 = new Clique(treeSet6, d, true);
                int n3 = n2;
                if (this.iso.containsKey(n3)) {
                    ArrayList<Clique> arrayList = this.iso.get(n3);
                    if (!arrayList.contains(treeSet5)) {
                        arrayList.add((Clique)((Object)treeSet5));
                    }
                } else {
                    ArrayList<TreeSet<IGraphNode>> arrayList = new ArrayList<TreeSet<IGraphNode>>();
                    arrayList.add(treeSet5);
                    this.iso.put(n3, arrayList);
                }
            }
        } else {
            if (treeSet6.size() >= n) {
                double d = this.getCliqueSimilarity(treeSet6);
                treeSet5 = new Clique(treeSet6, d, false);
                int n4 = n2;
                if (this.iso.containsKey(n4)) {
                    ArrayList<Clique> arrayList = this.iso.get(n4);
                    if (!arrayList.contains(treeSet5)) {
                        arrayList.add((Clique)((Object)treeSet5));
                    }
                } else {
                    ArrayList<TreeSet<IGraphNode>> arrayList = new ArrayList<TreeSet<IGraphNode>>();
                    arrayList.add(treeSet5);
                    this.iso.put(n4, arrayList);
                }
            }
            while (!treeSet.isEmpty()) {
                MappedVertex mappedVertex = treeSet.first();
                treeSet.remove(mappedVertex);
                this.node1 = mappedVertex.getLeftNode();
                this.node2 = mappedVertex.getRightNode();
                TreeSet<MappedVertex> treeSet7 = new TreeSet<MappedVertex>(new MappedVertexComparator());
                TreeSet<IGraphNode> treeSet8 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                treeSet5 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
                if (logger.isDebugEnabled()) {
                    System.out.println("mappedVertex: " + mappedVertex);
                    System.out.println("impossible before l: " + treeSet2);
                    System.out.println("impossible before r: " + treeSet3);
                    System.out.println("adjacent for mappedVertex: " + this.adjacentMap.get(mappedVertex));
                }
                for (MappedVertex mappedVertex2 : (TreeSet)this.adjacentMap.get(mappedVertex)) {
                    if (!(treeSet2.contains(mappedVertex2.getLeftNode()) || treeSet3.contains(mappedVertex2.getRightNode()) || treeSet4.contains(mappedVertex2))) {
                        treeSet7.add(mappedVertex2);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    System.out.println("new candidate not added: " + mappedVertex2);
                    System.out.println(!treeSet2.contains(this.node1) + " " + !treeSet3.contains(this.node2) + " " + !treeSet4.contains(mappedVertex2));
                }
                logger.debug((Object)("only new candidates: " + treeSet7));
                for (MappedVertex mappedVertex3 : treeSet) {
                    if (logger.isDebugEnabled()) {
                        System.out.println("old candidate: " + mappedVertex3);
                        System.out.println(((TreeSet)this.adjacentMap.get(mappedVertex)).contains(mappedVertex3) + " " + !mappedVertex3.getLeftNode().equals(this.node1) + " " + !mappedVertex3.getRightNode().equals(this.node2) + " " + !this.node1.getAdjacentSet().contains(mappedVertex3.getLeftNode()) + " " + !this.node2.getAdjacentSet().contains(mappedVertex3.getRightNode()));
                    }
                    if (!((TreeSet)this.adjacentMap.get(mappedVertex)).contains(mappedVertex3) && (mappedVertex3.getLeftNode().equals(this.node1) || mappedVertex3.getRightNode().equals(this.node2) || this.node1.getAdjacentSet().contains(mappedVertex3.getLeftNode()) || this.node2.getAdjacentSet().contains(mappedVertex3.getRightNode()))) continue;
                    treeSet7.add(mappedVertex3);
                }
                for (IGraphNode iGraphNode : treeSet2) {
                    treeSet8.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : treeSet3) {
                    treeSet5.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : this.node1.getAdjacentSet()) {
                    treeSet8.add(iGraphNode);
                }
                for (IGraphNode iGraphNode : this.node2.getAdjacentSet()) {
                    treeSet5.add(iGraphNode);
                }
                treeSet8.add(this.node1);
                treeSet5.add(this.node2);
                treeSet4.add(mappedVertex);
                if (logger.isDebugEnabled()) {
                    System.out.println("clique: " + treeSet4);
                    System.out.println("all candidates: " + treeSet7);
                    System.out.println("impossible after l: " + treeSet8);
                    System.out.println("impossible after r: " + treeSet5);
                }
                this.nextMaximalClique(treeSet7, treeSet8, treeSet5, treeSet4, n);
                treeSet4.remove(mappedVertex);
            }
        }
    }

    public void findDisjointCliques(ArrayList<Clique> arrayList) {
        TreeSet<MappedVertex> treeSet;
        ArrayList<Clique> arrayList2 = this.iso.get(this.iso.lastKey());
        Collections.sort(arrayList2);
        Clique clique = arrayList2.get(0);
        logger.debug((Object)("Max clique found " + clique.getClique().toString()));
        arrayList.add(clique);
        TreeSet<IGraphNode> treeSet2 = new TreeSet<IGraphNode>(new NamedGraphNodeComparator());
        for (MappedVertex object2 : clique.getClique()) {
            if (this.graphToCover.equals("smaller")) {
                if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                    if (object2.isGroup()) {
                        treeSet = object2.getGroupMembers();
                        for (MappedVertex mappedVertex : treeSet) {
                            treeSet2.add(mappedVertex.getLeftNode());
                        }
                        continue;
                    }
                    treeSet2.add(object2.getLeftNode());
                    continue;
                }
                if (object2.isGroup()) {
                    treeSet = object2.getGroupMembers();
                    for (MappedVertex mappedVertex : treeSet) {
                        treeSet2.add(mappedVertex.getRightNode());
                    }
                    continue;
                }
                treeSet2.add(object2.getRightNode());
                continue;
            }
            if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                if (object2.isGroup()) {
                    System.out.println("Adding group nodes" + object2.toString());
                    treeSet = object2.getGroupMembers();
                    for (MappedVertex mappedVertex : treeSet) {
                        treeSet2.add(mappedVertex.getRightNode());
                    }
                    continue;
                }
                treeSet2.add(object2.getRightNode());
                continue;
            }
            if (object2.isGroup()) {
                System.out.println("Adding group nodes" + object2.toString());
                treeSet = object2.getGroupMembers();
                for (MappedVertex mappedVertex : treeSet) {
                    treeSet2.add(mappedVertex.getLeftNode());
                }
                continue;
            }
            treeSet2.add(object2.getLeftNode());
        }
        Set<Map.Entry<Integer, ArrayList<Clique>>> set = this.iso.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            treeSet = (Map.Entry)iterator.next();
            int n = (Integer)treeSet.getKey();
            ArrayList arrayList3 = (ArrayList)treeSet.getValue();
            Iterator iterator2 = arrayList3.iterator();
            block6: while (iterator2.hasNext()) {
                Clique clique2 = (Clique)iterator2.next();
                for (MappedVertex mappedVertex : clique2.getClique()) {
                    boolean bl;
                    TreeSet<MappedVertex> treeSet3;
                    if (this.graphToCover.equals("smaller")) {
                        if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                            if (mappedVertex.isGroup()) {
                                treeSet3 = mappedVertex.getGroupMembers();
                                bl = false;
                                for (MappedVertex mappedVertex2 : treeSet3) {
                                    if (!treeSet2.contains(mappedVertex2.getLeftNode())) continue;
                                    bl = true;
                                    break;
                                }
                                if (!bl) continue;
                                iterator2.remove();
                                continue block6;
                            }
                            if (!treeSet2.contains(mappedVertex.getLeftNode())) continue;
                            iterator2.remove();
                            continue block6;
                        }
                        if (mappedVertex.isGroup()) {
                            treeSet3 = mappedVertex.getGroupMembers();
                            bl = false;
                            for (MappedVertex mappedVertex2 : treeSet3) {
                                if (!treeSet2.contains(mappedVertex2.getRightNode())) continue;
                                bl = true;
                                break;
                            }
                            if (!bl) continue;
                            iterator2.remove();
                            continue block6;
                        }
                        if (!treeSet2.contains(mappedVertex.getRightNode())) continue;
                        iterator2.remove();
                        continue block6;
                    }
                    if (this.graphAccessor1.size() < this.graphAccessor2.size()) {
                        if (mappedVertex.isGroup()) {
                            treeSet3 = mappedVertex.getGroupMembers();
                            bl = false;
                            for (MappedVertex mappedVertex2 : treeSet3) {
                                if (!treeSet2.contains(mappedVertex2.getRightNode())) continue;
                                bl = true;
                                System.out.println("Group found: " + mappedVertex.toString());
                                break;
                            }
                            if (!bl) continue;
                            System.out.println("Removing group node: " + mappedVertex.toString());
                            iterator2.remove();
                            continue block6;
                        }
                        if (!treeSet2.contains(mappedVertex.getRightNode())) continue;
                        iterator2.remove();
                        continue block6;
                    }
                    if (mappedVertex.isGroup()) {
                        treeSet3 = mappedVertex.getGroupMembers();
                        bl = false;
                        for (MappedVertex mappedVertex2 : treeSet3) {
                            if (!treeSet2.contains(mappedVertex2.getLeftNode())) continue;
                            bl = true;
                            System.out.println("Group found: " + mappedVertex.toString());
                            break;
                        }
                        if (!bl) continue;
                        System.out.println("Removing group node: " + mappedVertex.toString());
                        iterator2.remove();
                        continue block6;
                    }
                    if (!treeSet2.contains(mappedVertex.getLeftNode())) continue;
                    iterator2.remove();
                    continue block6;
                }
            }
            if (!arrayList3.isEmpty()) continue;
            iterator.remove();
        }
        if (!this.iso.isEmpty()) {
            this.findDisjointCliques(arrayList);
        }
    }

    @Override
    public boolean calculate() {
        if (super.calculate()) {
            this.setCalculated(false);
            if (this.graphAccessor1.getNodeSet().isEmpty() || this.graphAccessor2.getNodeSet().isEmpty()) {
                this.similarity = new Double(0.0);
                this.setCalculated(true);
                return true;
            }
            if (this.groupNodes) {
                TreeMap<Integer, ArrayList<Clique>> treeMap = this.getAllIsomorphisms();
                ArrayList<Clique> arrayList = treeMap.get(1);
                for (IGraphNode iGraphNode : this.graphAccessor1.getNodeSet()) {
                    if (iGraphNode.getIsGroup()) continue;
                    for (IGraphNode iGraphNode2 : this.graphAccessor2.getNodeSet()) {
                        if (iGraphNode2.getIsGroup()) continue;
                        MappedVertex mappedVertex = new MappedVertex(iGraphNode, iGraphNode2);
                        TreeSet<MappedVertex> treeSet = new TreeSet<MappedVertex>();
                        treeSet.add(mappedVertex);
                        double d = (mappedVertex.calculateLabelSimilarity() + 1.0) / this.getGraphsSize() * 0.5;
                        Clique clique = new Clique(treeSet, d, false);
                        if (arrayList.contains(clique)) continue;
                        arrayList.add(clique);
                        logger.debug((Object)("Adding clique " + clique.toString()));
                    }
                }
            }
            this.covering = new ArrayList();
            this.findDisjointCliques(this.covering);
            double d = this.covering.size();
            double d2 = this.graphToCover.equals("larger") ? (this.graphAccessor1.size() >= this.graphAccessor2.size() ? new Double(-d / (double)this.graphAccessor1.size() + 1.0).doubleValue() : new Double(-d / (double)this.graphAccessor2.size() + 1.0).doubleValue()) : (this.graphAccessor1.size() <= this.graphAccessor2.size() ? new Double(-d / (double)this.graphAccessor1.size() + 1.0).doubleValue() : new Double(-d / (double)this.graphAccessor2.size() + 1.0).doubleValue());
            this.similarity = new Double(d2);
            this.setCalculated(true);
            return true;
        }
        this.setCalculated(false);
        logger.error((Object)"Error");
        return false;
    }

    public TreeMap<Integer, ArrayList<Clique>> getAllIsomorphisms() {
        return this.iso;
    }

    public ArrayList<Clique> getCovering() {
        return this.covering;
    }

    private double getCliqueSimilarity(TreeSet<MappedVertex> treeSet) {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (MappedVertex mappedVertex : treeSet) {
            if (mappedVertex.isGroup()) {
                d += mappedVertex.getGroupSimilarity();
                n = n + mappedVertex.getGroupSize() - 1;
                continue;
            }
            d += mappedVertex.getLabelSimilarity();
        }
        d2 = (double)(treeSet.size() + n) / this.graphsSize;
        d3 = this.labelWeight * (d /= this.graphsSize) + this.structureWeight * d2;
        return d3;
    }
}

