/*
 * Decompiled with CFR 0.152.
 */
package simpack.measure.graph;

import org.apache.log4j.Logger;
import simpack.api.IGraphAccessor;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractSimilarityMeasure;
import simpack.exception.InvalidElementException;

public class ConceptualSimilarity
extends AbstractSimilarityMeasure {
    static Logger logger = Logger.getLogger(ConceptualSimilarity.class);
    private double N1;
    private double N2;
    private double N3;
    private IGraphAccessor graphAccessor;
    private IGraphNode nodeN1;
    private IGraphNode nodeN2;

    public ConceptualSimilarity(double d, double d2, double d3) {
        this.N1 = d;
        this.N2 = d2;
        this.N3 = d3;
    }

    public ConceptualSimilarity(IGraphAccessor iGraphAccessor, IGraphNode iGraphNode, IGraphNode iGraphNode2) throws InvalidElementException {
        this.graphAccessor = iGraphAccessor;
        this.nodeN1 = iGraphNode;
        this.nodeN2 = iGraphNode2;
        if (!iGraphAccessor.contains(iGraphNode)) {
            throw new InvalidElementException(((Object)iGraphNode).toString() + " not in graph");
        }
        if (!iGraphAccessor.contains(iGraphNode2)) {
            throw new InvalidElementException(((Object)iGraphNode2).toString() + " not in graph");
        }
    }

    public boolean calculate() {
        this.setCalculated(false);
        if (this.nodeN1 != null) {
            IGraphNode iGraphNode = null;
            try {
                iGraphNode = this.graphAccessor.getMostRecentCommonAncestor(this.nodeN1, this.nodeN2);
                IGraphNode iGraphNode2 = this.graphAccessor.getRoot();
                this.N3 = this.graphAccessor.getShortestPath(iGraphNode, iGraphNode2);
                logger.debug((Object)("N3 = " + this.N3));
                double d = this.graphAccessor.getShortestPath(this.nodeN1, this.nodeN2);
                logger.debug((Object)("Shortest Path = " + d));
                this.similarity = this.N3 == 0.0 ? new Double(1.0 / (d + 1.0)) : new Double(2.0 * this.N3 / (d + 2.0 * this.N3));
                this.setCalculated(true);
                return true;
            }
            catch (InvalidElementException invalidElementException) {
                invalidElementException.printStackTrace();
                return false;
            }
        }
        this.similarity = new Double(2.0 * this.N3 / (this.N1 + this.N2 + 2.0 * this.N3));
        this.setCalculated(true);
        return true;
    }
}

