/*
 * Decompiled with CFR 0.152.
 */
package simpack.accessor.graph;

import ch.unibern.graphmatching2.Graph;
import ch.unibern.graphmatching2.Vertex;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;
import org.apache.log4j.Logger;
import org.embl.ebi.escience.scufl.DataConstraint;
import org.embl.ebi.escience.scufl.InputPort;
import org.embl.ebi.escience.scufl.OutputPort;
import org.embl.ebi.escience.scufl.Processor;
import org.embl.ebi.escience.scufl.ScuflModel;
import org.embl.ebi.escience.scufl.parser.XScuflParser;
import simpack.api.IGraphNode;
import simpack.api.impl.AbstractGraphAccessor;
import simpack.util.graph.GraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScuflXMLGraphAccessor
extends AbstractGraphAccessor {
    public static Logger logger = Logger.getLogger(ScuflXMLGraphAccessor.class);

    public ScuflXMLGraphAccessor(String string) {
        this.BuildServiceGraph(string);
    }

    public ScuflModel loadScufl(String string) {
        ScuflModel scuflModel = new ScuflModel();
        scuflModel.setEventStatus(false);
        try {
            scuflModel.setOffline(true);
            URL uRL = new URL(string);
            logger.debug((Object)("Loading definition from : " + uRL.toString()));
            XScuflParser.populate((InputStream)uRL.openStream(), (ScuflModel)scuflModel, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return scuflModel;
    }

    /*
     * WARNING - void declaration
     */
    public Graph BuildServiceGraph(String string) {
        Graph graph = new Graph();
        try {
            int n;
            ScuflModel scuflModel = this.loadScufl(string);
            logger.debug((Object)"\nNodes\n");
            Processor[] processorArray = scuflModel.getProcessors();
            Processor processor = scuflModel.getWorkflowSourceProcessor();
            OutputPort[] outputPortArray = processor.getOutputPorts();
            Processor processor2 = scuflModel.getWorkflowSinkProcessor();
            InputPort[] inputPortArray = processor2.getInputPorts();
            int n2 = processorArray.length + outputPortArray.length + inputPortArray.length;
            Vertex[] vertexArray = new Vertex[n2];
            for (n = 0; n < processorArray.length; ++n) {
                logger.debug((Object)processorArray[n].getName().toString().toLowerCase());
                vertexArray[n] = new Vertex((Object)processorArray[n].getName().toString().toLowerCase());
            }
            for (n = 0; n < outputPortArray.length; ++n) {
                logger.debug((Object)outputPortArray[n].toString().toLowerCase());
                vertexArray[processorArray.length + n] = new Vertex((Object)outputPortArray[n].getName().toString().toLowerCase());
            }
            for (n = 0; n < inputPortArray.length; ++n) {
                logger.debug((Object)inputPortArray[n].toString().toLowerCase());
                vertexArray[processorArray.length + outputPortArray.length + n] = new Vertex((Object)inputPortArray[n].getName().toString().toLowerCase());
            }
            for (n = 0; n < n2; ++n) {
                graph.addVertex(vertexArray[n]);
            }
            if (logger.isDebugEnabled()) {
                for (n = 0; n < n2; ++n) {
                    System.out.println("v[" + n + "].getLabel()");
                    System.out.println(vertexArray[n].getLabel());
                }
            }
            logger.debug((Object)"\nLinks\n");
            DataConstraint[] dataConstraintArray = scuflModel.getDataConstraints();
            for (int i = 0; i < dataConstraintArray.length; ++i) {
                void object;
                if (logger.isDebugEnabled()) {
                    System.out.println("\n link = " + i);
                    if (dataConstraintArray[i].getSource().getProcessor().getName() == "SCUFL_INTERNAL_SOURCEPORTS") {
                        System.out.println("mylinks[" + i + "].getSource().getName()");
                        System.out.println(dataConstraintArray[i].getSource().getName());
                    } else {
                        System.out.println("mylinks[" + i + "].getSource().getProcessor().toString()");
                        System.out.println(dataConstraintArray[i].getSource().getProcessor().getName());
                    }
                }
                String string2 = "";
                if (dataConstraintArray[i].getSource().getProcessor().getName() == "SCUFL_INTERNAL_SOURCEPORTS") {
                    String string3 = dataConstraintArray[i].getSource().getName();
                } else {
                    String string4 = dataConstraintArray[i].getSource().getProcessor().getName();
                }
                for (int j = 0; j < n2; ++j) {
                    logger.debug((Object)("j = " + j));
                    if (dataConstraintArray[i].getSource().getProcessor().getName() == "SCUFL_INTERNAL_SOURCEPORTS") {
                        logger.debug((Object)("mylinks[" + i + "].getSource().getProcessor().toString() == SCUFL_INTERNAL_SOURCEPORTS"));
                        logger.debug((Object)("l = " + i));
                        if (vertexArray[j].getLabel() == dataConstraintArray[i].getSource().getName()) {
                            logger.debug((Object)("v[" + j + "].getLabel() == mylinks[" + i + "].getSource().getName()"));
                            this.assignEdge(n2, vertexArray, dataConstraintArray, i, j);
                        }
                    }
                    if (dataConstraintArray[i].getSource().getProcessor().getName() != vertexArray[j].getLabel()) continue;
                    logger.debug((Object)("mylinks[" + i + "].getSource().getProcessor().toString() == v[" + j + "].getLabel()"));
                    logger.debug((Object)("l = " + i));
                    if (vertexArray[j].getLabel() != dataConstraintArray[i].getSource().getProcessor().getName()) continue;
                    logger.debug((Object)("v[" + j + "].getLabel() == mylinks[" + i + "].getSource().toString()"));
                    this.assignEdge(n2, vertexArray, dataConstraintArray, i, j);
                }
                if (logger.isDebugEnabled()) {
                    if (dataConstraintArray[i].getSink().getProcessor().toString() == "SCUFL_INTERNAL_SINKPORTS") {
                        System.out.println("mylinks[" + i + "].getSink().toString()");
                        System.out.println(dataConstraintArray[i].getSink().toString());
                    } else {
                        System.out.println("mylinks[" + i + "].getSink().getProcessor().toString()");
                        System.out.println(dataConstraintArray[i].getSink().getProcessor().toString());
                    }
                }
                String string5 = "";
                string5 = dataConstraintArray[i].getSink().getProcessor().toString() == "SCUFL_INTERNAL_SINKPORTS" ? dataConstraintArray[i].getSink().toString() : dataConstraintArray[i].getSink().getProcessor().toString();
                this.setEdge(new GraphNode(object), new GraphNode(string5));
            }
            if (logger.isDebugEnabled()) {
                System.out.println("************all nodes**************");
                for (IGraphNode iGraphNode : this.getNodeSet()) {
                    System.out.println("node: " + iGraphNode);
                    System.out.println("pre: " + iGraphNode.getPredecessorSet());
                    System.out.println("suc: " + iGraphNode.getSuccessorSet());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return graph;
    }

    public Vertex[] assignEdge(int n, Vertex[] vertexArray, DataConstraint[] dataConstraintArray, int n2, int n3) {
        for (int i = 0; i < n; ++i) {
            if (logger.isDebugEnabled()) {
                System.out.println("v[z].getLabel()");
                System.out.println(vertexArray[i].getLabel());
                System.out.println("mylinks[link].getSink().getProcessor().getName()");
                System.out.println(dataConstraintArray[n2].getSink().getProcessor().getName());
            }
            if (vertexArray[i].getLabel() == dataConstraintArray[n2].getSink().getProcessor().getName()) {
                vertexArray[n3].addEdge(vertexArray[i]);
            } else if (dataConstraintArray[n2].getSink().getProcessor().toString() == "SCUFL_INTERNAL_SINKPORTS" && vertexArray[i].getLabel() == dataConstraintArray[n2].getSink().toString()) {
                vertexArray[n3].addEdge(vertexArray[i]);
            }
            logger.debug((Object)("z = " + i));
        }
        return vertexArray;
    }

    @Override
    public double getShortestPath(IGraphNode iGraphNode, IGraphNode iGraphNode2) {
        return 0.0;
    }

    @Override
    public double getMaximumDirectedPathLength() {
        return 0.0;
    }

    @Override
    public Set<IGraphNode> getPredecessors(IGraphNode iGraphNode, boolean bl) {
        return null;
    }

    @Override
    public Set<IGraphNode> getSuccessors(IGraphNode iGraphNode, boolean bl) {
        return null;
    }

    @Override
    public IGraphNode getMostRecentCommonAncestor(IGraphNode iGraphNode, IGraphNode iGraphNode2) {
        return null;
    }

    @Override
    public double getMaxDepth() {
        return 0.0;
    }
}

