/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Utils;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.Utils.Fact;
import gr.aueb.cs.nlg.Utils.OrderComparatorImpl;
import gr.aueb.cs.nlg.Utils.XmlUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlMsgs
extends XmlUtils {
    private Document doc;
    private Element MsgsElement;
    public static final String INTERSECTION_OF_TAG = "intersectionOf";
    public static final String SUBCLASS_OF_TAG = "subclassOf";
    public static final String UNION_OF_TAG = "unionOf";
    public static final String COMPLEMENT_OF_TAG = "complementOf";
    public static final String CLASS_TAG = "cls";
    public static final String HAS_VALUE_RESTRICTION_TAG = "hasValueRestriction";
    public static final String SOME_VALUES_FROM_RESTRICTION_TAG = "someValuesFromRestriction";
    public static final String ALL_VALUES_FROM_RESTRICTION_TAG = "allValuesFromRestriction";
    public static final String EXACT_CARDINALITY_RESTRICTION_TAG = "exactCardRestriction";
    public static final String MIN_CARDINALITY_RESTRICTION_TAG = "minCardRestriction";
    public static final String MAX_CARDINALITY_RESTRICTION_TAG = "maxCardRestriction";
    public static final String ENUMERATION_OF_TAG = "enumerationOf";
    public static final String EQUIVALENT_CLASS_TAG = "equivalentClass";
    public static final String DISJOINT_WITH_TAG = "disjointWith";
    public static final String INSTANCE_TAG = "Instance";
    public static final String DIFFERENT_FROM_TAG = "differentFrom";
    public static final String SAME_AS_TAG = "sameAs";
    public static final String NOT_MODIFIER = "not";
    public static final String NLNAME_TAG = "NLName";
    public static final String SUB_NLNAME_TAG = "subjectNLName";
    public static final String OBJ_NLNAME_TAG = "objectNLName";
    public static final String COMPARATOR_NLNAME_TAG = "comparatorNLName";
    public static final String COMPARATOR_FILLER_NLNAME_TAG = "comparatorFillerNLName";
    public static final String SENTENCE_PLAN_TAG = "sentencePlan";
    public static final String ORDER_TAG = "order";
    public static final String SECTION_TAG = "section";
    public static final String SECTION_NAME = "sectionName";
    public static final int CLS_TYPE = 0;
    public static final int INST_TYPE = 1;
    public static final String VERB_TAG = "verb";
    public static final String ADJECTIVE_TAG = "adjective";
    public static final String NOUN_TAG = "noun";
    public static final String singular_VERB_TAG = "singularVerb";
    public static final String plural_VERB_TAG = "pluralVerb";
    public static final String FILLER_TAG = "filler";
    public static final String OWNER_TAG = "owner";
    public static final String PREPOSITION_TAG = "preposition";
    public static final String TEXT_TAG = "text";
    public static final String CONCAT_TAG = "concatenation";
    public static final String COMPARATOR_TAG = "comparator";
    public static final String COMPARATOR_FILLER_TAG = "comparatorFiller";
    public static final String CLSDESC_TAG = "clsDesc";
    public static final String DISJUNCTION_TAG = "disjunction";
    public static final String RETYPE = "RE_TYPE";
    public static final String REF_AUTO = "auto";
    public static final String REF_PRONOUN = "pronoun";
    public static final String REF_DEMONSTRATIVE = "demonstrative";
    public static final String IS_A_TAG = "isA";
    public static final String A_TAG = "aOrAn";
    public static final String CASE_TAG = "case";
    public static final String TENSE_TAG = "tense";
    public static final String VOICE_TAG = "voice";
    public static final String GENDER_TAG = "gender";
    public static final String PERSON_TAG = "person";
    public static final String NUMBER_TAG = "number";
    public static final String AGREE_TAG = "agree";
    public static final String PASSIVE_VOICE = "passive";
    public static final String ACTIVE_VOICE = "active";
    public static final String TENSE_SIMPLE_PRESENT = "simple present";
    public static final String TENSE_PRESENT_CONTINUOUS = "present continuous";
    public static final String TENSE_PRESENT_PERFECT = "present perfect";
    public static final String TENSE_SIMPLE_PAST = "simple past";
    public static final String TENSE_PAST_CONTINUOUS = "past continuous";
    public static final String TENSE_PAST_PERFECT = "past perfect";
    public static final String TENSE_PAST_PERFECT_CONTINUOUS = "past perfect continuous";
    public static final String TENSE_SIMPLE_FUTURE = "simple future";
    public static final String TENSE_FUTURE_CONTINUOUS = "future continuous";
    public static final String TENSE_FUTURE_PERFECT = "future perfect";
    public static final String TENSE_FUTURE_PERFECT_CONTINUOUS = "future perfect continuous";
    public static final String TENSE_INFINITIVE = "infinitive";
    public static final String TENSE_PARTICIPLE = "participle";
    public static final String PERSON_1ST = "1st";
    public static final String PERSON_2ND = "2nd";
    public static final String PERSON_3RD = "3rd";
    public static final String NOMINATIVE_TAG = "nominative";
    public static final String GENITIVE_TAG = "genitive";
    public static final String ACCUSATIVE_TAG = "accusative";
    public static final String GENDER_MASCULINE = "masculine";
    public static final String GENDER_FEMININE = "feminine";
    public static final String GENDER_MASCULINE_OR_FEMININE = "masculineOrFeminine";
    public static final String GENDER_NEUTER = "neuter";
    public static final String SINGULAR = "singular";
    public static final String PLURAL = "plural";
    public static final String type = "type";
    public static final String PRONOUN_TAG = "Pronoun";
    public static final String REF = "ref";
    public static final String VALUE = "value";
    public static final String COMPARE_TO = "compareTo";
    public static final String COMPARE_TO_FILLER = "compareToFiller";
    public static final String INTEREST = "interest";
    public static final String ASSIMIL_SCORE = "AssimilationScore";
    public static final String TYPE_OF = "typeOf";
    public static final String AGGREG_ALLOWED = "AGGREG_ALLOWED";
    public static final String LEVEL = "LEVEL";
    public static final String RE_FOCUS = "RE_FOCUS";
    public static final String FOCUSLevel4 = "FOCUSLevel4";
    public static final String FOCUSLevel3 = "FOCUSLevel3";
    public static final String FOCUSLevel2 = "FOCUSLevel2";
    public static final String FOCUSLevel1 = "FOCUSLevel1";
    public static final String FOCUS_LOST = "FOCUS_LOST";
    public static final String prpType = "prpType";
    public static final String ObjectProperty = "objPrp";
    public static final String DatatypeProperty = "dPrp";
    public static final String forProperty = "forProperty";
    public static final String forSubject = "forSubject";
    public static final String forObject = "forObject";
    public static final String forDomainIndependentProperty = "forDomainIndependentProperty";
    public static final String concatIndividual = "concatenateIndividual";
    public static final String useAuxiliaryVerb = "useAuxiliaryVerb";
    public static final String useBullets = "useBullets";
    public static final String articleUse = "articleUse";
    public static final String polarity = "polarity";
    public static final String modifier = "modifier";
    public static final String cardinality = "cardinality";
    public static final String factsContained = "factsContained";
    public static final String ID = "ID";
    public static final String lexiconEntryIRI = "lexiconEntryIRI";
    public static final String ILPSentence = "ILPSentence";
    public static final String appendAdjective = "appendAdjective";
    public static final String countAppends = "countAppends";
    public static final String isConnective = "isConnective";
    public static final String CONNECTIVE = "&&";
    public static final String CONNECTIVE_2ND_LEVEL = "&&&";
    public static final String NOT_CONNECTIVE = "!&&";
    public static final String NOT_CONNECTIVE_2ND_LEVEL = "!&&&";
    public static final String DISJUNCTIVE = "||";
    public static final String DISJUNCTIVE_2ND_LEVEL = "|||";
    public static String prefix = "nlowl";

    public XmlMsgs(String idName, int type, Document d) {
        this.doc = d;
        this.MsgsElement = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + "owlMsgs");
        if (type == 0) {
            this.setAttr(this.MsgsElement, NLResourceManager.nlowlNS, prefix, "CLS-Name", idName);
        } else if (type == 1) {
            this.setAttr(this.MsgsElement, NLResourceManager.nlowlNS, prefix, "INST-Name", idName);
        }
        this.doc.appendChild(this.MsgsElement);
        this.setNamespace(NLResourceManager.nlowlNS, prefix);
    }

    public final void setNamespace(String ns, String myprefix) {
        NodeList AllNodesList = this.doc.getElementsByTagName(String.valueOf(prefix) + ":" + "owlMsgs");
        ((Element)AllNodesList.item(0)).setAttribute("xmlns:" + myprefix, ns);
    }

    public void setDefaultNamespace() {
        NodeList AllNodesList = this.doc.getElementsByTagName(String.valueOf(prefix) + ":" + "owlMsgs");
        ((Element)AllNodesList.item(0)).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", NLResourceManager.nlowlNS);
    }

    public int getType() {
        NodeList AllNodesList = this.doc.getElementsByTagName(String.valueOf(prefix) + ":" + "owlMsgs");
        if (XmlMsgs.getAttribute(AllNodesList.item(0), prefix, "CLS-Name").compareTo("") != 0) {
            return 1;
        }
        if (XmlMsgs.getAttribute(AllNodesList.item(0), prefix, "INST-Name").compareTo("") != 0) {
            return 2;
        }
        return 0;
    }

    public String getOwner() {
        Node root = this.getRoot();
        if (this.getType() == 1) {
            return XmlMsgs.getAttribute(root, prefix, "CLS-Name");
        }
        if (this.getType() == 2) {
            return XmlMsgs.getAttribute(root, prefix, "INST-Name");
        }
        return "";
    }

    public Node getRoot() {
        return this.doc.getElementsByTagName(String.valueOf(prefix) + ":" + "owlMsgs").item(0);
    }

    public ArrayList<Node> getMessages() {
        Node root = this.getRoot();
        return XmlMsgs.returnChildNodes(root);
    }

    public void removeMsgs(ArrayList<Node> msgs) {
        Node root = this.getRoot();
        int i = 0;
        while (i < msgs.size()) {
            root.removeChild(msgs.get(i));
            ++i;
        }
    }

    public static boolean compare(Node currNode, String pref, String tag) {
        String prefixedName;
        String NodeName = currNode.getNodeName();
        String string = prefixedName = pref.compareTo("") == 0 ? tag : String.valueOf(pref) + ":" + tag;
        return NodeName.compareTo(prefixedName) == 0;
    }

    public Document getXMLTree() {
        return this.doc;
    }

    public void setXMLTree(Document d) {
        this.doc = d;
    }

    public Element createNewMsg() {
        if (this.getType() == 1) {
            Element MsgElement = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + "owlMsg");
            this.MsgsElement.appendChild(MsgElement);
            return MsgElement;
        }
        if (this.getType() == 2) {
            return (Element)this.doc.getElementsByTagNameNS(NLResourceManager.nlowlNS, "owlMsgs").item(0);
        }
        return null;
    }

    public Element createNewMsg(Element parentMsg) {
        if (this.getType() == 1) {
            Element MsgElement = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + "owlMsg");
            parentMsg.appendChild(MsgElement);
            return MsgElement;
        }
        if (this.getType() == 2) {
            return (Element)this.doc.getElementsByTagNameNS(NLResourceManager.nlowlNS, "owlMsgs").item(0);
        }
        return null;
    }

    public Element addNewElement(Element Elem, String ns, String prefix, String tag) {
        if (prefix.compareTo("") != 0) {
            Element NewElement = this.doc.createElementNS(ns, String.valueOf(prefix) + ":" + tag);
            Elem.appendChild(NewElement);
            return NewElement;
        }
        Element NewElement = this.doc.createElement(tag);
        Elem.appendChild(NewElement);
        return NewElement;
    }

    public final void setAttr(Element Elem, String ns, String pref, String Attr2, String value) {
        Elem.setAttributeNS(ns, String.valueOf(pref) + ":" + Attr2, value);
    }

    public void setText(Element Elem, String text) {
        Elem.setTextContent(text);
    }

    public void addOwnerSlot(Node root, String propertyIRI, String caseType, String refType, NodeID ID) {
        Element ownerNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + OWNER_TAG);
        if (ID != null) {
            this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
        }
        this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, NLNAME_TAG, XmlMsgs.getAttribute(root, prefix, SUB_NLNAME_TAG));
        this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
        this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, RETYPE, refType);
        this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(ownerNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(ownerNode);
    }

    public void addFillerSlot(Node root, String propertyIRI, String caseType, String forceNumber, boolean useBullets, int articleUse, NodeID ID) {
        boolean isSlotConnective = false;
        ArrayList<Object> values = new ArrayList();
        if (XmlMsgs.getAttribute(root, prefix, VALUE).startsWith("and(")) {
            isSlotConnective = true;
            values = Fact.parseModifier(XmlMsgs.getAttribute(root, prefix, VALUE));
        } else if (XmlMsgs.getAttribute(root, prefix, VALUE).startsWith("or(")) {
            isSlotConnective = false;
            values = Fact.parseModifier(XmlMsgs.getAttribute(root, prefix, VALUE));
        } else {
            values.add(XmlMsgs.getAttribute(root, prefix, VALUE));
        }
        ArrayList<Object> NLNames = new ArrayList();
        if (XmlMsgs.getAttribute(root, prefix, OBJ_NLNAME_TAG).startsWith("and(")) {
            NLNames = Fact.parseModifier(XmlMsgs.getAttribute(root, prefix, OBJ_NLNAME_TAG));
        } else if (XmlMsgs.getAttribute(root, prefix, OBJ_NLNAME_TAG).startsWith("or(")) {
            NLNames = Fact.parseModifier(XmlMsgs.getAttribute(root, prefix, OBJ_NLNAME_TAG));
        } else {
            NLNames.add(XmlMsgs.getAttribute(root, prefix, OBJ_NLNAME_TAG));
        }
        int i = 0;
        while (i < values.size()) {
            Element fillerNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + FILLER_TAG);
            this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
            this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
            if (XmlMsgs.getAttribute(root, prefix, prpType).equals(ObjectProperty)) {
                this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, NLNAME_TAG, (String)NLNames.get(i));
                this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
            }
            this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, articleUse, String.valueOf(articleUse));
            if (forceNumber.equals(SINGULAR)) {
                this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, SINGULAR);
            } else if (forceNumber.equals(PLURAL)) {
                this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, PLURAL);
            }
            if (useBullets) {
                this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, useBullets, "true");
            } else {
                this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, useBullets, "false");
            }
            fillerNode.setTextContent((String)values.get(i));
            this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
            this.setAttr(fillerNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
            root.appendChild(fillerNode);
            if (i != values.size() - 1) {
                Element textNode = XmlMsgs.createTextNode(this.doc);
                if (isSlotConnective) {
                    textNode.setTextContent(CONNECTIVE_2ND_LEVEL);
                } else {
                    textNode.setTextContent(DISJUNCTIVE_2ND_LEVEL);
                }
                root.appendChild(textNode);
            }
            ++i;
        }
        if (values.isEmpty()) {
            root.getParentNode().removeChild(root);
        }
    }

    public Node addVerbSlot(Node root, String propertyIRI, IRI verbIRI, String voice, String tense, String number, String person, NodeID agreeID, boolean polarity, NodeID ID) {
        Element verbNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + VERB_TAG);
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, lexiconEntryIRI, verbIRI.toString());
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, VOICE_TAG, voice);
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, TENSE_TAG, tense);
        if (agreeID == null) {
            this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, number);
            this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, PERSON_TAG, person);
        } else {
            this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, AGREE_TAG, agreeID.toString());
        }
        if (polarity) {
            this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, polarity, "true");
        } else {
            this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, polarity, "false");
        }
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(verbNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(verbNode);
        return verbNode;
    }

    public void addAdjectiveSlot(Node root, String propertyIRI, IRI adjectiveIRI, String caseType, String gender, String number, NodeID agreeID, NodeID ID) {
        Element adjectiveNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + ADJECTIVE_TAG);
        this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
        this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, lexiconEntryIRI, adjectiveIRI.toString());
        if (agreeID == null) {
            this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, number);
            this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
            this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, GENDER_TAG, gender);
        } else {
            this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, AGREE_TAG, agreeID.toString());
        }
        this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(adjectiveNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(adjectiveNode);
    }

    public void addNounSlot(Node root, String propertyIRI, IRI nounIRI, String caseType, String number, NodeID agreeID, NodeID ID) {
        Element nounNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + NOUN_TAG);
        this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
        this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, lexiconEntryIRI, nounIRI.toString());
        if (agreeID == null) {
            this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, number);
            this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
        } else {
            this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, AGREE_TAG, agreeID.toString());
        }
        this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(nounNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(nounNode);
    }

    public Node addPrepositionSlot(Node root, String propertyIRI, String text) {
        Element textNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + PREPOSITION_TAG);
        textNode.setTextContent(text);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(textNode);
        return textNode;
    }

    public void addStringSlot(Node root, String propertyIRI, String text) {
        Element textNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + TEXT_TAG);
        textNode.setTextContent(text);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(textNode);
    }

    public void addStringSlot(Node root, String propertyIRI, String text, Node before) {
        Element textNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + TEXT_TAG);
        textNode.setTextContent(text);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.insertBefore(textNode, before.getNextSibling());
    }

    public void addConcatenationIndividualSlot(Node root, String propertyIRI, IRI concatenationIndividual, String caseType) {
        Element textNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + CONCAT_TAG);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, concatIndividual, concatenationIndividual.toString());
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(textNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(textNode);
    }

    public void addComparatorSlot(Node root, String propertyIRI, String caseType, boolean isMany, int articleUse, NodeID ID) {
        Element comparatorNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + COMPARATOR_TAG);
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, NLNAME_TAG, XmlMsgs.getAttribute(root, prefix, COMPARATOR_NLNAME_TAG));
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, articleUse, String.valueOf(articleUse));
        if (!isMany) {
            this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, SINGULAR);
        } else {
            this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, PLURAL);
        }
        comparatorNode.setTextContent(XmlMsgs.getAttribute(root, prefix, COMPARE_TO));
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(comparatorNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(comparatorNode);
    }

    public void addComparatorFillerSlot(Node root, String propertyIRI, String caseType, boolean isMany, int articleUse, NodeID ID) {
        Element comparatorFillerNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + COMPARATOR_FILLER_TAG);
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, ID, ID.toString());
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, NLNAME_TAG, XmlMsgs.getAttribute(root, prefix, COMPARATOR_FILLER_NLNAME_TAG));
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, CASE_TAG, caseType);
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, articleUse, String.valueOf(articleUse));
        if (!isMany) {
            this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, SINGULAR);
        } else {
            this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, NUMBER_TAG, PLURAL);
        }
        comparatorFillerNode.setTextContent(XmlMsgs.getAttribute(root, prefix, COMPARE_TO_FILLER));
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(comparatorFillerNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(comparatorFillerNode);
    }

    public void addISASlot(Node root, String propertyIRI) {
        Element isaNode = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + IS_A_TAG);
        this.setAttr(isaNode, NLResourceManager.nlowlNS, prefix, forProperty, propertyIRI);
        this.setAttr(isaNode, NLResourceManager.nlowlNS, prefix, NLNAME_TAG, XmlMsgs.getAttribute(root, prefix, OBJ_NLNAME_TAG));
        this.setAttr(isaNode, NLResourceManager.nlowlNS, prefix, INTEREST, XmlMsgs.getAttribute(root, prefix, INTEREST));
        this.setAttr(isaNode, NLResourceManager.nlowlNS, prefix, ASSIMIL_SCORE, XmlMsgs.getAttribute(root, prefix, ASSIMIL_SCORE));
        root.appendChild(isaNode);
    }

    public String getStringDescription(boolean indent) {
        try {
            OutputFormat OutFrmt = null;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutFrmt = new OutputFormat(this.doc);
            OutFrmt.setIndenting(indent);
            OutFrmt.setEncoding("UTF-8");
            XMLSerializer xmlsrz = new XMLSerializer((OutputStream)os, OutFrmt);
            xmlsrz.serialize(this.doc);
            return new String(os.toByteArray(), Charset.forName("UTF-8"));
        }
        catch (UnsupportedCharsetException e) {
            return "ERRoR: UnsupportedCharsetException";
        }
        catch (Exception e) {
            return "ERRoR";
        }
    }

    public void sortByOrder() {
        Node root = this.getRoot();
        ArrayList<Node> messages = this.getMessages();
        Object[] T = messages.toArray();
        Arrays.sort(T, new OrderComparatorImpl(true));
        int i = 0;
        while (i < T.length) {
            Node curr = (Node)T[i];
            root.appendChild(curr);
            this.sortChildMessages(curr);
            ++i;
        }
        this.groupSameProperties();
    }

    private void sortChildMessages(Node n) {
        ArrayList<Node> messageNodes = XmlMsgs.returnChildNodes(n);
        if (messageNodes.size() >= 1) {
            int j = 0;
            while (j < messageNodes.size()) {
                Node curr = messageNodes.get(j);
                if (curr.getNodeName().equals(String.valueOf(prefix) + ":" + OWNER_TAG) || curr.getNodeName().equals(String.valueOf(prefix) + ":" + FILLER_TAG) || curr.getNodeName().equals(String.valueOf(prefix) + ":" + VERB_TAG) || curr.getNodeName().equals(String.valueOf(prefix) + ":" + TEXT_TAG)) {
                    messageNodes.remove(curr);
                    continue;
                }
                ++j;
            }
            Object[] T = messageNodes.toArray();
            Arrays.sort(T, new OrderComparatorImpl(true));
            int i = 0;
            while (i < T.length) {
                Node curr = (Node)T[i];
                n.getParentNode().appendChild(curr);
                this.sortChildMessages(curr);
                ++i;
            }
        }
    }

    private void groupSameProperties() {
        HashMap<String, Node> subjectPredicateSet = new HashMap<String, Node>();
        ArrayList<Node> Msgs = this.getMessages();
        int i = 0;
        while (i < Msgs.size()) {
            Node currNode = Msgs.get(i);
            String ref = XmlMsgs.getAttribute(currNode, prefix, REF);
            String predicate = currNode.getNodeName();
            String key = String.valueOf(ref) + "," + predicate;
            if (subjectPredicateSet.containsKey(key)) {
                Node ParentNode;
                Node refChild = ((Node)subjectPredicateSet.get(key)).getNextSibling();
                if (refChild != null) {
                    ParentNode = refChild.getParentNode();
                    ParentNode.insertBefore(currNode, refChild);
                } else {
                    ParentNode = currNode.getParentNode();
                    ParentNode.appendChild(currNode);
                }
            } else {
                subjectPredicateSet.put(key, currNode);
            }
            ++i;
        }
    }

    public static String getAttribute(Node node, String prefix, String AttributeName) {
        String prefixedAttrName = "";
        prefixedAttrName = prefix.compareTo("") == 0 ? AttributeName : String.valueOf(prefix) + ":" + AttributeName;
        String ret = "";
        NamedNodeMap NMM = node.getAttributes();
        if (NMM != null) {
            if (NMM.getNamedItem(prefixedAttrName) != null) {
                ret = NMM.getNamedItem(prefixedAttrName).getTextContent();
                return ret;
            }
            return ret;
        }
        return ret;
    }

    public static String getChild(Node node, String prefix, String ChildName) {
        String prefixedChildName = "";
        prefixedChildName = prefix == null ? ChildName : String.valueOf(prefix) + ":" + ChildName;
        Node n = null;
        NodeList list_of_templ_childs = node.getChildNodes();
        int i = 0;
        while (i < list_of_templ_childs.getLength()) {
            n = list_of_templ_childs.item(i);
            if (n.getNodeName().compareTo(prefixedChildName) == 0) {
                return n.getTextContent();
            }
            ++i;
        }
        return "";
    }

    public static Node getNodeChild(Node node, String prefix, String ChildName) {
        String prefixedChildName = "";
        prefixedChildName = prefix == null ? ChildName : String.valueOf(prefix) + ":" + ChildName;
        Node n = null;
        NodeList list_of_templ_childs = node.getChildNodes();
        int i = 0;
        while (i < list_of_templ_childs.getLength()) {
            n = list_of_templ_childs.item(i);
            if (n.getNodeName().compareTo(prefixedChildName) == 0) {
                return n;
            }
            ++i;
        }
        return null;
    }

    public boolean findInNodeMap(NamedNodeMap nnm, String name) {
        int i = 0;
        while (i < nnm.getLength()) {
            if (nnm.item(i).getLocalName().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public ArrayList<Node> returnMatchedNodes(String pref, String tag) {
        NodeList Match_List = null;
        Match_List = pref.compareTo("") == 0 ? this.doc.getElementsByTagName(tag) : this.doc.getElementsByTagName(String.valueOf(prefix) + ":" + tag);
        ArrayList<Node> Match_List_vec = new ArrayList<Node>();
        int i = 0;
        while (i < Match_List.getLength()) {
            Match_List_vec.add(Match_List.item(i));
            ++i;
        }
        return Match_List_vec;
    }

    public static ArrayList<Node> returnChildNodes(Node current) {
        NodeList Child_List = current.getChildNodes();
        ArrayList<Node> Child_List_vec = new ArrayList<Node>();
        int i = 0;
        while (i < Child_List.getLength()) {
            Child_List_vec.add(Child_List.item(i));
            ++i;
        }
        return Child_List_vec;
    }

    public static Node getFirstNonTextChild(Node parent) {
        NodeList childs = parent.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            if (childs.item(i).getNodeType() != 3) {
                return childs.item(i);
            }
            ++i;
        }
        return null;
    }

    public void removeNode(Node node) {
        node.getParentNode().removeChild(node);
    }

    public void replaceWithPronoun(Node node, String Case) {
        Element elmnt = this.doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + PRONOUN_TAG);
        elmnt.setAttributeNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + CASE_TAG, Case);
        Node parent = node.getParentNode();
        parent.replaceChild(elmnt, node);
    }

    public static Element createTextNode(Document doc) {
        return doc.createElementNS(NLResourceManager.nlowlNS, String.valueOf(prefix) + ":" + TEXT_TAG);
    }
}

