/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Utils;

import gr.aueb.cs.nlg.NLFiles.UserModel;
import gr.aueb.cs.nlg.Utils.Fact;
import java.util.HashMap;
import org.semanticweb.owlapi.model.IRI;

public class NLGUser {
    String id;
    UserModel UM;
    private HashMap<IRI, Integer> entitiesMentionedCount;
    private HashMap<Fact, Integer> factMentionedCount;
    private HashMap<IRI, Integer> sentencePlansUseCount;
    private HashMap<IRI, Integer> NLNameUseCount;

    public NLGUser(String id, UserModel UM) {
        this.id = id;
        this.UM = UM;
        this.entitiesMentionedCount = new HashMap();
        this.factMentionedCount = new HashMap();
        this.sentencePlansUseCount = new HashMap();
        this.NLNameUseCount = new HashMap();
    }

    public int getEntityMentionedCount(IRI entityIRI) {
        if (this.entitiesMentionedCount.containsKey(entityIRI)) {
            return this.entitiesMentionedCount.get(entityIRI);
        }
        return 0;
    }

    public int getFactMentionedCount(Fact factID) {
        if (this.factMentionedCount.keySet().contains(factID)) {
            return this.factMentionedCount.get(factID);
        }
        return 0;
    }

    public int getSentencePlanUseCount(IRI sentencePlanIRI) {
        if (this.sentencePlansUseCount.containsKey(sentencePlanIRI)) {
            return this.sentencePlansUseCount.get(sentencePlanIRI);
        }
        return 0;
    }

    public int getNLNameUseCount(IRI NLNameIRI) {
        if (this.NLNameUseCount.containsKey(NLNameIRI)) {
            return this.NLNameUseCount.get(NLNameIRI);
        }
        return 0;
    }

    public void increaseEntityMentionedCount(IRI entityIRI) {
        if (this.entitiesMentionedCount.containsKey(entityIRI)) {
            int value = this.entitiesMentionedCount.get(entityIRI);
            this.entitiesMentionedCount.put(entityIRI, value + 1);
        } else {
            this.entitiesMentionedCount.put(entityIRI, 1);
        }
    }

    public void increaseFactMentionedCount(Fact factID) {
        if (this.factMentionedCount.containsKey(factID)) {
            int value = this.factMentionedCount.get(factID);
            this.factMentionedCount.put(factID, value + 1);
        } else {
            this.factMentionedCount.put(factID, 1);
        }
    }

    public void increaseSentencePlanUseCount(IRI sentencePlanIRI) {
        if (this.sentencePlansUseCount.containsKey(sentencePlanIRI)) {
            int value = this.sentencePlansUseCount.get(sentencePlanIRI);
            this.sentencePlansUseCount.put(sentencePlanIRI, value + 1);
        } else {
            this.sentencePlansUseCount.put(sentencePlanIRI, 1);
        }
    }

    public void increaseNLNameUseCount(IRI NLNameIRI) {
        if (this.NLNameUseCount.containsKey(NLNameIRI)) {
            int value = this.NLNameUseCount.get(NLNameIRI);
            this.NLNameUseCount.put(NLNameIRI, value + 1);
        } else {
            this.NLNameUseCount.put(NLNameIRI, 1);
        }
    }

    public void resetCounters() {
        this.entitiesMentionedCount = new HashMap();
        this.factMentionedCount = new HashMap();
        this.sentencePlansUseCount = new HashMap();
        this.NLNameUseCount = new HashMap();
    }

    public UserModel getUserModel() {
        return this.UM;
    }

    public void setUserModel(UserModel UM) {
        this.UM = UM;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

