/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Utils;

import java.util.ArrayList;
import org.semanticweb.owlapi.model.IRI;

public class Fact {
    private IRI sub;
    private IRI predicate;
    private String obj;
    private ArrayList<String> modifiers;
    private int cardinality = -1;
    private boolean polarity = true;

    public Fact(IRI s, IRI p, String o) {
        this.sub = s;
        this.predicate = p;
        this.obj = o;
        this.modifiers = new ArrayList();
    }

    public Fact(String fact) {
        int index1 = fact.indexOf(44, 0);
        int index2 = fact.indexOf(44, index1 + 2);
        this.sub = IRI.create((String)fact.substring(1, index1));
        this.predicate = IRI.create((String)fact.substring(index1 + 2, index2));
        this.obj = fact.substring(index2 + 2, fact.length() - 1);
        this.modifiers = new ArrayList();
    }

    public String getFact() {
        return this.toString();
    }

    public IRI getSubject() {
        return this.sub;
    }

    public IRI getPredicate() {
        return this.predicate;
    }

    public String getObject() {
        return this.obj;
    }

    public static IRI getSubject(String fact) {
        Fact fct = new Fact(fact);
        return fct.getSubject();
    }

    public static IRI getPredicate(String fact) {
        Fact fct = new Fact(fact);
        return fct.getPredicate();
    }

    public static String getObject(String fact) {
        Fact fct = new Fact(fact);
        return fct.getObject();
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public boolean isPolarity() {
        return this.polarity;
    }

    public void setPolarity(boolean polarity) {
        this.polarity = polarity;
    }

    public ArrayList<String> getModifiers() {
        return this.modifiers;
    }

    public void addModifier(String modifier) {
        this.modifiers.add(modifier);
    }

    public boolean hasModifier(String modifier) {
        return this.modifiers.contains(modifier);
    }

    public static ArrayList<String> parseModifier(String modifier) {
        ArrayList<String> parsed = new ArrayList<String>();
        int start = modifier.indexOf(40);
        int end = modifier.indexOf(44);
        if (end == -1) {
            end = modifier.length() - 1;
        }
        while (start != -1 && end != -1 && start < modifier.length()) {
            parsed.add(modifier.substring(start + 1, end));
            start = end + 1;
            end = modifier.indexOf(44, end + 1);
            if (end != -1) continue;
            end = modifier.length() - 1;
        }
        return parsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Fact f = (Fact)o;
        if (this.sub.equals((Object)f.sub) && this.predicate.equals((Object)f.predicate)) {
            ArrayList<Object> thisValues = new ArrayList();
            if (this.obj.startsWith("and(")) {
                thisValues = Fact.parseModifier(this.obj);
            } else if (this.obj.startsWith("or(")) {
                thisValues = Fact.parseModifier(this.obj);
            } else {
                thisValues.add(this.obj);
            }
            ArrayList<Object> oValues = new ArrayList();
            if (f.obj.startsWith("and(")) {
                oValues = Fact.parseModifier(f.obj);
            } else if (f.obj.startsWith("or(")) {
                oValues = Fact.parseModifier(f.obj);
            } else {
                oValues.add(f.obj);
            }
            if (thisValues.size() == oValues.size()) {
                for (String string : thisValues) {
                    if (oValues.contains(string)) continue;
                    return false;
                }
                for (String string : oValues) {
                    if (thisValues.contains(string)) continue;
                    return false;
                }
                if (this.cardinality == f.cardinality && this.polarity == f.polarity) {
                    for (String string : this.modifiers) {
                        if (string.equals("not") || f.modifiers.contains(string)) continue;
                        return false;
                    }
                    for (String string : f.modifiers) {
                        if (string.equals("not") || this.modifiers.contains(string)) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + (this.sub != null ? this.sub.hashCode() : 0);
        hash = 29 * hash + (this.predicate != null ? this.predicate.hashCode() : 0);
        hash = 29 * hash + (this.obj != null ? this.obj.hashCode() : 0);
        hash = 29 * hash + (this.modifiers != null ? this.modifiers.hashCode() : 0);
        hash = 29 * hash + this.cardinality;
        hash = 29 * hash + (this.polarity ? 1 : 0);
        return hash;
    }

    public String toString() {
        return "[" + this.sub.toString() + ", " + this.predicate.toString() + ", " + this.obj.toString() + "]";
    }
}

