/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.UserModel;
import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTab;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelImpl;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class UserModellingTable
extends NaturalOWLTab
implements TableModelListener {
    Logger log = Logger.getLogger(LexiconTab.class);
    private OWLModelManagerListener modelListener;
    private JPanel globalPanel;
    private JPanel userTypePanel;
    private JTable globalTable;
    private JTable table;
    private JScrollPane scrollTable;
    private JPanel panelButtons;
    private JPanel panelExtra;
    private JLabel previewLabel;
    private JButton addUT;
    private JButton removeUT;
    private JButton duplicateUT;
    private ListIRI selectedProperty = null;
    private ListIRI selectedClass = null;
    private ListIRI selectedIndiv = null;
    private ListIRI selectedModifier = null;
    private final String userTypeColumn = "User Type";
    private final String maxMessagesPerPageColumn = "Max Messages per Page";
    private final String maxMessagesPerSentenceColumn = "Max Messages per Sentence";
    private final String globalInterestColumn = "Global Interest";
    private final String globalRepetitionsColumn = "Global Repetitions";
    private final String setInterestColumn = "Set Interest";
    private final String setRepetitionsColumn = "Set Repetitions";
    private final String effectiveInterestColumn = "Effective Interest";
    private final String effectiveRepetitionsColumn = "Effective Repetitions";
    private ArrayList<ListIRI> userTypes;

    protected void initialiseOWLView() throws Exception {
        this.initialiseNaturalOWL();
        refresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                UserModellingTable.this.refresh();
            }
        });
        userModelTableModifierSelectionModel.addListener(this.getOWLModifierSelectionModelListener());
        userModelTablePropertySelectionModel.addListener(this.getOWLPropertySelectionModelListener());
        userModelTableClassSelectionModel.addListener(this.getOWLClassSelectionModelListener());
        userModelTableIndivSelectionModel.addListener(this.getOWLIndividualSelectionModelListener());
        this.globalPanel = new JPanel();
        this.globalPanel.setLayout(new BorderLayout());
        this.userTypePanel = new JPanel();
        this.userTypePanel.setLayout(new BorderLayout());
        this.globalTable = this.fillGlobalTable();
        this.table = this.fillUserTypeTable();
        this.setLayout(new BorderLayout());
        this.globalPanel.add((Component)this.globalTable.getTableHeader(), "First");
        this.globalPanel.add((Component)this.globalTable, "Center");
        this.userTypePanel.add((Component)this.table.getTableHeader(), "First");
        this.scrollTable = new JScrollPane(this.table);
        this.userTypePanel.add((Component)this.scrollTable, "Center");
        this.add(this.globalPanel, "First");
        this.add(this.userTypePanel, "Center");
        this.panelExtra = new JPanel();
        this.panelExtra.setLayout(new BoxLayout(this.panelExtra, 3));
        this.panelButtons = new JPanel();
        this.panelButtons.setLayout(new FlowLayout());
        this.addUT = new JButton("Add user type");
        this.removeUT = new JButton("Remove user type");
        this.duplicateUT = new JButton("Duplicate user type");
        this.addUT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModellingTable.this.table = UserModellingTable.this.addRow();
            }
        });
        this.removeUT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModellingTable.this.table = UserModellingTable.this.removeRow();
            }
        });
        this.duplicateUT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModellingTable.this.table = UserModellingTable.this.duplicateRow();
            }
        });
        this.panelButtons.add(this.addUT);
        this.panelButtons.add(this.removeUT);
        this.panelButtons.add(this.duplicateUT);
        this.panelExtra.add(this.panelButtons);
        JPanel panelLabel = new JPanel();
        this.previewLabel = new JLabel("Set User Type properties.");
        panelLabel.add(this.previewLabel);
        this.panelExtra.add(panelLabel);
        this.add(this.panelExtra, "South");
    }

    private void refresh() {
        if (this.table.getTableHeader() != null) {
            this.remove(this.table.getTableHeader());
        }
        if (this.scrollTable != null) {
            this.remove(this.scrollTable);
        }
        if (this.panelExtra != null) {
            this.remove(this.panelExtra);
        }
        this.globalPanel = new JPanel();
        this.globalPanel.setLayout(new BorderLayout());
        this.userTypePanel = new JPanel();
        this.userTypePanel.setLayout(new BorderLayout());
        this.globalTable = this.fillGlobalTable();
        this.table = this.fillUserTypeTable();
        this.setLayout(new BorderLayout());
        this.globalPanel.add((Component)this.globalTable.getTableHeader(), "First");
        this.globalPanel.add((Component)this.globalTable, "Center");
        this.userTypePanel.add((Component)this.table.getTableHeader(), "First");
        this.scrollTable = new JScrollPane(this.table);
        this.userTypePanel.add((Component)this.scrollTable, "Center");
        this.add(this.globalPanel, "First");
        this.add(this.userTypePanel, "Center");
        this.panelExtra = new JPanel();
        this.panelExtra.setLayout(new BoxLayout(this.panelExtra, 3));
        this.panelButtons = new JPanel();
        this.panelButtons.setLayout(new FlowLayout());
        this.addUT = new JButton("Add user type");
        this.removeUT = new JButton("Remove user type");
        this.duplicateUT = new JButton("Duplicate user type");
        this.addUT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModellingTable.this.table = UserModellingTable.this.addRow();
            }
        });
        this.removeUT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModellingTable.this.table = UserModellingTable.this.removeRow();
            }
        });
        this.duplicateUT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserModellingTable.this.table = UserModellingTable.this.duplicateRow();
            }
        });
        this.panelButtons.add(this.addUT);
        this.panelButtons.add(this.removeUT);
        this.panelButtons.add(this.duplicateUT);
        this.panelExtra.add(this.panelButtons);
        JPanel panelLabel = new JPanel();
        this.previewLabel = new JLabel("Set User Type properties.");
        panelLabel.add(this.previewLabel);
        this.panelExtra.add(panelLabel);
        this.add(this.panelExtra, "South");
    }

    public JTable addRow() {
        DefaultTableModel defaultModel = (DefaultTableModel)this.table.getModel();
        IRI userTypeIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + "NewUser"));
        int n = 1;
        while (!this.isUniqueIRI(userTypeIRI)) {
            userTypeIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + "NewUser" + ++n));
        }
        UMQM.addUserModel(userTypeIRI);
        this.dirtenOntologies();
        UserModel UT = UMQM.getUserModel(userTypeIRI);
        defaultModel.addRow(new Object[]{new ListIRI(UT.getUMIRI()), UT.getMaxMessagesPerPage(), UT.getMaxMessagesPerSentence(), UT.getGlobalInterest(), UT.getGlobalRepetitions()});
        this.table.setModel(defaultModel);
        if (this.selectedProperty == null && this.selectedModifier == null) {
            this.updateUserTypeTable();
        } else {
            this.updateInterestTable();
        }
        return this.table;
    }

    public JTable removeRow() {
        DefaultTableModel defaultModel = (DefaultTableModel)this.table.getModel();
        int rowIndex = this.table.getSelectedRow();
        if (rowIndex != -1) {
            ListIRI userTypeIRI = (ListIRI)defaultModel.getValueAt(rowIndex, 0);
            if (!userTypeIRI.getEntryIRI().equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                int selection = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete " + userTypeIRI.getEntryIRI().getFragment() + " user type?");
                if (selection == 0) {
                    UMQM.deleteUserModel(userTypeIRI.getEntryIRI());
                    this.dirtenOntologies();
                    defaultModel.removeRow(rowIndex);
                    this.table.setModel(defaultModel);
                    if (this.selectedProperty == null && this.selectedModifier == null) {
                        this.updateUserTypeTable();
                    } else {
                        this.updateInterestTable();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(null, "You cannot delete the global user type.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Please select a row in the user type table.");
        }
        return this.table;
    }

    public JTable duplicateRow() {
        DefaultTableModel defaultModel = (DefaultTableModel)this.table.getModel();
        int rowIndex = this.table.getSelectedRow();
        if (rowIndex != -1) {
            ListIRI fromIRI = (ListIRI)defaultModel.getValueAt(rowIndex, 0);
            if (!fromIRI.getEntryIRI().equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                IRI toIRI = IRI.create((String)(String.valueOf(fromIRI.getEntryIRI().toString()) + "_copy"));
                int n = 1;
                while (!this.isUniqueIRI(toIRI)) {
                    toIRI = IRI.create((String)(String.valueOf(fromIRI.getEntryIRI().toString()) + "_copy" + ++n));
                }
                UMQM.duplicateUserModel(fromIRI.getEntryIRI(), toIRI);
                this.dirtenOntologies();
                UserModel UT = UMQM.getUserModel(toIRI);
                defaultModel.addRow(new Object[]{new ListIRI(UT.getUMIRI()), UT.getMaxMessagesPerPage(), UT.getMaxMessagesPerSentence(), UT.getGlobalInterest(), UT.getGlobalRepetitions()});
                this.table.setModel(defaultModel);
                if (this.selectedProperty == null && this.selectedModifier == null) {
                    this.updateUserTypeTable();
                } else {
                    this.updateInterestTable();
                }
            } else {
                JOptionPane.showMessageDialog(null, "You cannot duplicate the global user type.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "Please select a row in the user type table.");
        }
        return this.table;
    }

    public void updateUserTypeTable() {
        this.globalPanel.remove(this.globalTable.getTableHeader());
        this.globalPanel.remove(this.globalTable);
        this.globalTable = this.fillGlobalTable();
        this.globalPanel.add((Component)this.globalTable.getTableHeader(), "First");
        this.globalPanel.add((Component)this.globalTable, "Center");
        this.globalTable.validate();
        this.globalTable.repaint();
        this.userTypePanel.remove(this.table.getTableHeader());
        this.userTypePanel.remove(this.scrollTable);
        this.table = this.fillUserTypeTable();
        this.userTypePanel.add((Component)this.table.getTableHeader(), "First");
        this.scrollTable = new JScrollPane(this.table);
        this.userTypePanel.add((Component)this.scrollTable, "Center");
        this.table.validate();
        this.table.repaint();
        this.validate();
        this.repaint();
    }

    public void updateInterestTable() {
        this.globalPanel.remove(this.globalTable.getTableHeader());
        this.globalPanel.remove(this.globalTable);
        this.globalTable = this.fillGlobalInterestTable();
        this.globalPanel.add((Component)this.globalTable.getTableHeader(), "First");
        this.globalPanel.add((Component)this.globalTable, "Center");
        this.globalTable.validate();
        this.globalTable.repaint();
        this.userTypePanel.remove(this.table.getTableHeader());
        this.userTypePanel.remove(this.scrollTable);
        this.table = this.fillInterestTable();
        this.userTypePanel.add((Component)this.table.getTableHeader(), "First");
        this.scrollTable = new JScrollPane(this.table);
        this.userTypePanel.add((Component)this.scrollTable, "Center");
        this.table.validate();
        this.table.repaint();
        this.validate();
        this.repaint();
    }

    public JTable fillGlobalTable() {
        Object[] columnNames = new String[]{"User Type", "Global Interest", "Global Repetitions", "", ""};
        Object[][] data = new Object[1][3];
        UserModel UModel = NaturalOWLTab.UMQM.getUserModel(NLResourceManager.globalUserModel.getIRI());
        data[0][0] = new ListIRI(NLResourceManager.globalUserModel.getIRI());
        data[0][1] = UModel.getGlobalInterest();
        data[0][2] = UModel.getGlobalRepetitions();
        if (data[0][2].toString().equals("0")) {
            data[0][2] = "INFINITE";
        }
        this.globalTable = new JTable(new DefaultTableModel(data, columnNames)){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    if (column == 0) {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText("<html><b>This is a default resource of the system.</b> <br>" + ((ListIRI)this.getValueAt(row, column)).getToolTipText() + "</html>");
                    } else {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(null);
                    }
                }
                return c;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0 && col != 3 && col != 4;
            }
        };
        TableColumn column = null;
        int i = 0;
        while (i < this.globalTable.getColumnCount()) {
            column = this.globalTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            ++i;
        }
        this.globalTable.getTableHeader().setReorderingAllowed(false);
        this.globalTable.setCellSelectionEnabled(true);
        this.globalTable.getTableHeader().setResizingAllowed(false);
        this.globalTable.getModel().addTableModelListener(this);
        return this.globalTable;
    }

    public JTable fillGlobalInterestTable() {
        Object[] columnNames = new String[]{"User Type", "Set Interest", "Set Repetitions", "", ""};
        Object[][] data = new Object[1][5];
        UserModel UModel = NaturalOWLTab.UMQM.getUserModel(NLResourceManager.globalUserModel.getIRI());
        data[0][0] = new ListIRI(NLResourceManager.globalUserModel.getIRI());
        if (this.selectedIndiv != null) {
            if (this.selectedModifier != null) {
                data[0][1] = NaturalOWLTab.UMQM.getInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
                data[0][2] = NaturalOWLTab.UMQM.getInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
            } else {
                data[0][1] = NaturalOWLTab.UMQM.getInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, NLResourceManager.globalUserModel.getIRI());
                data[0][2] = NaturalOWLTab.UMQM.getInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, NLResourceManager.globalUserModel.getIRI());
            }
        } else if (this.selectedClass != null) {
            if (this.selectedModifier != null) {
                data[0][1] = NaturalOWLTab.UMQM.getClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
                data[0][2] = NaturalOWLTab.UMQM.getClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
            } else {
                data[0][1] = NaturalOWLTab.UMQM.getClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, NLResourceManager.globalUserModel.getIRI());
                data[0][2] = NaturalOWLTab.UMQM.getClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, NLResourceManager.globalUserModel.getIRI());
            }
        } else if (this.selectedProperty != null) {
            if (this.selectedModifier != null) {
                data[0][1] = NaturalOWLTab.UMQM.getPropertyLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
                data[0][2] = NaturalOWLTab.UMQM.getPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
            } else {
                data[0][1] = NaturalOWLTab.UMQM.getPropertyLevelInterest(this.selectedProperty.getEntryIRI(), null, NLResourceManager.globalUserModel.getIRI());
                data[0][2] = NaturalOWLTab.UMQM.getPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), null, NLResourceManager.globalUserModel.getIRI());
            }
        } else if (this.selectedModifier != null) {
            data[0][1] = NaturalOWLTab.UMQM.getPropertyLevelInterest(null, this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
            data[0][2] = NaturalOWLTab.UMQM.getPropertyLevelRepetitions(null, this.selectedModifier.getEntryIRI(), NLResourceManager.globalUserModel.getIRI());
        }
        if (data[0][2].toString().equals("0")) {
            data[0][2] = "INFINITE";
        }
        this.globalTable = new JTable(new DefaultTableModel(data, columnNames)){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    if (column == 0) {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(((ListIRI)this.getValueAt(row, column)).getToolTipText());
                    } else {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(null);
                    }
                }
                return c;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 0 && col != 3 && col != 4;
            }
        };
        TableColumn column = null;
        int i = 0;
        while (i < this.globalTable.getColumnCount()) {
            column = this.globalTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            ++i;
        }
        this.globalTable.getTableHeader().setReorderingAllowed(false);
        this.globalTable.setCellSelectionEnabled(true);
        this.globalTable.getTableHeader().setResizingAllowed(false);
        this.globalTable.getModel().addTableModelListener(this);
        return this.globalTable;
    }

    public JTable fillUserTypeTable() {
        Object[] columnNames = new String[]{"User Type", "Global Interest", "Global Repetitions", "Max Messages per Page", "Max Messages per Sentence"};
        this.userTypes = new ArrayList();
        Object[][] data = new Object[NaturalOWLTab.UMQM.getUserModels().size() - 1][5];
        int row = 0;
        for (IRI UMIRI : NaturalOWLTab.UMQM.getUserModels()) {
            if (UMIRI.equals((Object)NLResourceManager.globalUserModel.getIRI())) continue;
            UserModel UModel = NaturalOWLTab.UMQM.getUserModel(UMIRI);
            this.userTypes.add(new ListIRI(UMIRI));
            data[row][0] = new ListIRI(UMIRI);
            data[row][1] = UModel.getGlobalInterest();
            data[row][2] = UModel.getGlobalRepetitions();
            data[row][3] = UModel.getMaxMessagesPerPage();
            data[row][4] = UModel.getMaxMessagesPerSentence();
            if (data[row][2].toString().equals("0")) {
                data[row][2] = "INFINITE";
            }
            if (data[row][3].toString().equals("-1")) {
                data[row][3] = "ALL";
            }
            ++row;
        }
        this.table = new JTable(new DefaultTableModel(data, columnNames)){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    if (column == 0) {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(((ListIRI)this.getValueAt(row, column)).getToolTipText());
                    } else {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(null);
                    }
                }
                return c;
            }
        };
        TableColumn column = null;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            ++i;
        }
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getModel().addTableModelListener(this);
        return this.table;
    }

    public JTable fillInterestTable() {
        Object[] columnNames = new String[]{"User Type", "Set Interest", "Set Repetitions", "Effective Interest", "Effective Repetitions"};
        this.userTypes = new ArrayList();
        Object[][] data = new Object[NaturalOWLTab.UMQM.getUserModels().size() - 1][5];
        int row = 0;
        for (IRI UMIRI : NaturalOWLTab.UMQM.getUserModels()) {
            if (UMIRI.equals((Object)NLResourceManager.globalUserModel.getIRI())) continue;
            this.userTypes.add(new ListIRI(UMIRI));
            data[row][0] = new ListIRI(UMIRI);
            if (this.selectedIndiv != null) {
                if (this.selectedModifier != null) {
                    data[row][1] = NaturalOWLTab.UMQM.getInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][2] = NaturalOWLTab.UMQM.getInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][3] = NaturalOWLTab.UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][4] = NaturalOWLTab.UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                } else {
                    data[row][1] = NaturalOWLTab.UMQM.getInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, UMIRI);
                    data[row][2] = NaturalOWLTab.UMQM.getInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, UMIRI);
                    data[row][3] = NaturalOWLTab.UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, UMIRI);
                    data[row][4] = NaturalOWLTab.UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, UMIRI);
                }
            } else if (this.selectedClass != null) {
                if (this.selectedModifier != null) {
                    data[row][1] = NaturalOWLTab.UMQM.getClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][2] = NaturalOWLTab.UMQM.getClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][3] = NaturalOWLTab.UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][4] = NaturalOWLTab.UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                } else {
                    data[row][1] = NaturalOWLTab.UMQM.getClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, UMIRI);
                    data[row][2] = NaturalOWLTab.UMQM.getClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, UMIRI);
                    data[row][3] = NaturalOWLTab.UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, UMIRI);
                    data[row][4] = NaturalOWLTab.UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, UMIRI);
                }
            } else if (this.selectedProperty != null) {
                if (this.selectedModifier != null) {
                    data[row][1] = NaturalOWLTab.UMQM.getPropertyLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][2] = NaturalOWLTab.UMQM.getPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][3] = NaturalOWLTab.UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                    data[row][4] = NaturalOWLTab.UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                } else {
                    data[row][1] = NaturalOWLTab.UMQM.getPropertyLevelInterest(this.selectedProperty.getEntryIRI(), null, UMIRI);
                    data[row][2] = NaturalOWLTab.UMQM.getPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), null, UMIRI);
                    data[row][3] = NaturalOWLTab.UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), null, UMIRI);
                    data[row][4] = NaturalOWLTab.UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), null, UMIRI);
                }
            } else if (this.selectedModifier != null) {
                data[row][1] = NaturalOWLTab.UMQM.getPropertyLevelInterest(null, this.selectedModifier.getEntryIRI(), UMIRI);
                data[row][2] = NaturalOWLTab.UMQM.getPropertyLevelRepetitions(null, this.selectedModifier.getEntryIRI(), UMIRI);
                data[row][3] = NaturalOWLTab.UMQM.getInterest(null, this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
                data[row][4] = NaturalOWLTab.UMQM.getRepetitions(null, this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), UMIRI);
            }
            if (data[row][2].toString().equals("0")) {
                data[row][2] = "INFINITE";
            }
            if (data[row][4].toString().equals("0")) {
                data[row][4] = "INFINITE";
            }
            ++row;
        }
        this.table = new JTable(new DefaultTableModel(data, columnNames)){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    if (column == 0) {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(((ListIRI)this.getValueAt(row, column)).getToolTipText());
                    } else {
                        JComponent jc = (JComponent)c;
                        jc.setToolTipText(null);
                    }
                }
                return c;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 3 && col != 4;
            }
        };
        TableColumn column = null;
        int i = 0;
        while (i < this.table.getColumnCount()) {
            column = this.table.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            ++i;
        }
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.getTableHeader().setResizingAllowed(false);
        this.table.getModel().addTableModelListener(this);
        return this.table;
    }

    private void updatePreviewLabel() {
        if (this.selectedProperty == null && this.selectedClass == null && this.selectedIndiv == null && this.selectedModifier == null) {
            this.previewLabel.setText("Set User Type properties.");
        } else if (this.selectedProperty != null && this.selectedClass == null && this.selectedIndiv == null && this.selectedModifier == null) {
            this.previewLabel.setText("Set interest/repetitions for property " + this.selectedProperty.getEntryIRI().getFragment() + ".");
        } else if (this.selectedProperty != null && this.selectedClass == null && this.selectedIndiv == null && this.selectedModifier != null) {
            this.previewLabel.setText("Set interest/repetitions for property " + this.selectedProperty.getEntryIRI().getFragment() + " (" + this.selectedModifier.getEntryIRI().getFragment() + ")" + ".");
        } else if (this.selectedProperty != null && this.selectedClass != null && this.selectedIndiv == null && this.selectedModifier == null) {
            this.previewLabel.setText("Set interest/repetitions for property " + this.selectedProperty.getEntryIRI().getFragment() + " and class " + this.selectedClass.getEntryIRI().getFragment() + ".");
        } else if (this.selectedProperty != null && this.selectedClass != null && this.selectedIndiv == null && this.selectedModifier != null) {
            this.previewLabel.setText("Set interest/repetitions for property " + this.selectedProperty.getEntryIRI().getFragment() + " (" + this.selectedModifier.getEntryIRI().getFragment() + ")" + " and class " + this.selectedClass.getEntryIRI().getFragment() + ".");
        } else if (this.selectedProperty != null && this.selectedClass != null && this.selectedIndiv != null && this.selectedModifier == null) {
            this.previewLabel.setText("Set interest/repetitions for property " + this.selectedProperty.getEntryIRI().getFragment() + " and individual " + this.selectedIndiv.getEntryIRI().getFragment() + ".");
        } else if (this.selectedProperty != null && this.selectedClass != null && this.selectedIndiv != null && this.selectedModifier != null) {
            this.previewLabel.setText("Set interest/repetitions for property " + this.selectedProperty.getEntryIRI().getFragment() + " (" + this.selectedModifier.getEntryIRI().getFragment() + ")" + " and individual " + this.selectedIndiv.getEntryIRI().getFragment() + ".");
        } else if (this.selectedProperty == null && this.selectedClass == null && this.selectedIndiv == null && this.selectedModifier != null) {
            this.previewLabel.setText("Set interest/repetitions for property modifier " + this.selectedModifier.getEntryIRI().getFragment() + ".");
        }
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.getOWLModelManager().removeListener(this.modelListener);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        block99: {
            int row = e.getFirstRow();
            int column = e.getColumn();
            TableModel model = (TableModel)e.getSource();
            TableModel userTypeModel = this.table.getModel();
            String columnName = model.getColumnName(column);
            if (columnName.equals("User Type")) {
                ListIRI oldUserTypeIRI = this.userTypes.get(row);
                if (model.getValueAt(row, column) instanceof String) {
                    String newName = (String)model.getValueAt(row, column);
                    IRI newUserTypeIRI = IRI.create((String)(String.valueOf(oldUserTypeIRI.getEntryIRI().getStart()) + newName));
                    if (!newName.equals(oldUserTypeIRI.getEntryIRI().getFragment())) {
                        if (!newName.equals("") && UserModellingTable.isLegalIRI(newUserTypeIRI) && this.isUniqueIRI(newUserTypeIRI)) {
                            UMQM.renameUserModel(oldUserTypeIRI.getEntryIRI(), newUserTypeIRI);
                            model.setValueAt(new ListIRI(newUserTypeIRI), row, column);
                            this.dirtenOntologies();
                        } else {
                            JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.");
                            model.setValueAt(oldUserTypeIRI, row, column);
                        }
                    } else {
                        model.setValueAt(oldUserTypeIRI, row, column);
                    }
                }
            } else if (columnName.equals("Max Messages per Page")) {
                ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
                String number = "" + model.getValueAt(row, column);
                int oldNumber = UMQM.getMaxMessagesPerPage(userTypeIRI.getEntryIRI());
                if (number.equalsIgnoreCase("ALL")) {
                    int newNumber = -1;
                    if (newNumber != oldNumber) {
                        UMQM.setMaxMessagesPerPage(userTypeIRI.getEntryIRI(), newNumber);
                        model.setValueAt("ALL", row, column);
                        this.dirtenOntologies();
                    }
                } else {
                    try {
                        if (Integer.parseInt(number) == -1) {
                            int newNumber = -1;
                            if (newNumber != oldNumber) {
                                UMQM.setMaxMessagesPerPage(userTypeIRI.getEntryIRI(), newNumber);
                                model.setValueAt("ALL", row, column);
                                this.dirtenOntologies();
                            }
                            break block99;
                        }
                        if (UserModellingTable.isValidSize(number)) {
                            int newNumber = Integer.parseInt(number);
                            if (newNumber != oldNumber) {
                                UMQM.setMaxMessagesPerPage(userTypeIRI.getEntryIRI(), newNumber);
                                this.dirtenOntologies();
                            }
                            break block99;
                        }
                        model.setValueAt(oldNumber, row, column);
                    }
                    catch (NumberFormatException nfe) {
                        model.setValueAt(oldNumber, row, column);
                    }
                }
            } else if (columnName.equals("Max Messages per Sentence")) {
                ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
                String number = "" + model.getValueAt(row, column);
                int oldNumber = UMQM.getMaxMessagesPerSentence(userTypeIRI.getEntryIRI());
                try {
                    if (UserModellingTable.isValidSize(number)) {
                        int newNumber = Integer.parseInt(number);
                        if (newNumber != oldNumber) {
                            UMQM.setMaxMessagesPerSentence(userTypeIRI.getEntryIRI(), newNumber);
                            this.dirtenOntologies();
                        }
                        break block99;
                    }
                    if (Integer.parseInt(number) == -1) {
                        int newNumber = Integer.parseInt(number);
                        if (newNumber != oldNumber) {
                            UMQM.setMaxMessagesPerSentence(userTypeIRI.getEntryIRI(), newNumber);
                            model.setValueAt(oldNumber, row, column);
                            this.dirtenOntologies();
                        }
                        break block99;
                    }
                    model.setValueAt(oldNumber, row, column);
                }
                catch (NumberFormatException nfe) {
                    model.setValueAt(oldNumber, row, column);
                }
            } else if (columnName.equals("Global Interest")) {
                ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
                String number = "" + model.getValueAt(row, column);
                int oldNumber = UMQM.getGlobalInterest(userTypeIRI.getEntryIRI());
                try {
                    if (UserModellingTable.isValidInterest(number)) {
                        int newNumber = Integer.parseInt(number);
                        if (newNumber != oldNumber) {
                            UMQM.setGlobalInterest(userTypeIRI.getEntryIRI(), newNumber);
                            this.dirtenOntologies();
                        }
                        break block99;
                    }
                    model.setValueAt(oldNumber, row, column);
                }
                catch (NumberFormatException nfe) {
                    model.setValueAt(oldNumber, row, column);
                }
            } else if (columnName.equals("Global Repetitions")) {
                ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
                String number = "" + model.getValueAt(row, column);
                int oldNumber = UMQM.getGlobalRepetitions(userTypeIRI.getEntryIRI());
                if (number.equalsIgnoreCase("INFINITE")) {
                    int newNumber = 0;
                    if (newNumber != oldNumber) {
                        UMQM.setGlobalRepetitions(userTypeIRI.getEntryIRI(), newNumber);
                        model.setValueAt("INFINITE", row, column);
                        this.dirtenOntologies();
                    }
                } else {
                    try {
                        if (Integer.parseInt(number) == 0) {
                            int newNumber = 0;
                            if (newNumber != oldNumber) {
                                UMQM.setGlobalRepetitions(userTypeIRI.getEntryIRI(), newNumber);
                                model.setValueAt("INFINITE", row, column);
                                this.dirtenOntologies();
                            }
                            break block99;
                        }
                        if (UserModellingTable.isValidSize(number)) {
                            int newNumber = Integer.parseInt(number);
                            if (newNumber != oldNumber) {
                                UMQM.setGlobalRepetitions(userTypeIRI.getEntryIRI(), newNumber);
                                this.dirtenOntologies();
                            }
                            break block99;
                        }
                        model.setValueAt(oldNumber, row, column);
                    }
                    catch (NumberFormatException nfe) {
                        model.setValueAt(oldNumber, row, column);
                    }
                }
            } else if (columnName.equals("Set Interest")) {
                ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
                String number = "" + model.getValueAt(row, column);
                int oldNumber = -1;
                if (this.selectedIndiv != null) {
                    oldNumber = this.selectedModifier != null ? UMQM.getInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()) : UMQM.getInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, userTypeIRI.getEntryIRI());
                } else if (this.selectedClass != null) {
                    oldNumber = this.selectedModifier != null ? UMQM.getClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()) : UMQM.getClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, userTypeIRI.getEntryIRI());
                } else if (this.selectedProperty != null) {
                    oldNumber = this.selectedModifier != null ? UMQM.getPropertyLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()) : UMQM.getPropertyLevelInterest(this.selectedProperty.getEntryIRI(), null, userTypeIRI.getEntryIRI());
                } else if (this.selectedModifier != null) {
                    oldNumber = UMQM.getPropertyLevelInterest(null, this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI());
                }
                if (UserModellingTable.isValidInterest(number)) {
                    try {
                        int newNumber = Integer.parseInt(number);
                        if (newNumber != oldNumber) {
                            if (this.selectedIndiv != null) {
                                if (this.selectedModifier != null) {
                                    UMQM.setInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                    userTypeModel.setValueAt(UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 3);
                                } else {
                                    UMQM.setInstanceLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, userTypeIRI.getEntryIRI(), newNumber);
                                    userTypeModel.setValueAt(UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, userTypeIRI.getEntryIRI()), row, 3);
                                }
                            } else if (this.selectedClass != null) {
                                if (this.selectedModifier != null) {
                                    UMQM.setClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                    userTypeModel.setValueAt(UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 3);
                                } else {
                                    UMQM.setClassLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, userTypeIRI.getEntryIRI(), newNumber);
                                    userTypeModel.setValueAt(UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, userTypeIRI.getEntryIRI()), row, 3);
                                }
                            } else if (this.selectedProperty != null) {
                                if (this.selectedModifier != null) {
                                    UMQM.setPropertyLevelInterest(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                    userTypeModel.setValueAt(UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 3);
                                } else {
                                    UMQM.setPropertyLevelInterest(this.selectedProperty.getEntryIRI(), null, userTypeIRI.getEntryIRI(), newNumber);
                                    userTypeModel.setValueAt(UMQM.getInterest(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), null, userTypeIRI.getEntryIRI()), row, 3);
                                }
                            } else if (this.selectedModifier != null) {
                                UMQM.setPropertyLevelInterest(null, this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getInterest(null, this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 3);
                            }
                            this.dirtenOntologies();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        model.setValueAt(oldNumber, row, column);
                    }
                } else {
                    model.setValueAt(oldNumber, row, column);
                }
            } else if (columnName.equals("Set Repetitions")) {
                ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
                String number = "" + model.getValueAt(row, column);
                int oldNumber = -1;
                if (this.selectedIndiv != null) {
                    oldNumber = this.selectedModifier != null ? UMQM.getInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()) : UMQM.getInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, userTypeIRI.getEntryIRI());
                } else if (this.selectedClass != null) {
                    oldNumber = this.selectedModifier != null ? UMQM.getClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()) : UMQM.getClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, userTypeIRI.getEntryIRI());
                } else if (this.selectedProperty != null) {
                    oldNumber = this.selectedModifier != null ? UMQM.getPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()) : UMQM.getPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), null, userTypeIRI.getEntryIRI());
                } else if (this.selectedModifier != null) {
                    oldNumber = UMQM.getPropertyLevelRepetitions(null, this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI());
                }
                if (number.equalsIgnoreCase("INFINITE") || UserModellingTable.isValidInterest(number)) {
                    int newNumber;
                    if (number.equalsIgnoreCase("INFINITE")) {
                        newNumber = 0;
                    } else {
                        try {
                            newNumber = Integer.parseInt(number);
                        }
                        catch (NumberFormatException nfe) {
                            newNumber = oldNumber;
                            model.setValueAt(oldNumber, row, column);
                        }
                    }
                    if (newNumber != oldNumber) {
                        if (this.selectedIndiv != null) {
                            if (this.selectedModifier != null) {
                                UMQM.setInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 4);
                            } else {
                                UMQM.setInstanceLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedIndiv.getEntryIRI(), null, userTypeIRI.getEntryIRI()), row, 4);
                            }
                        } else if (this.selectedClass != null) {
                            if (this.selectedModifier != null) {
                                UMQM.setClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 4);
                            } else {
                                UMQM.setClassLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.selectedClass.getEntryIRI(), null, userTypeIRI.getEntryIRI()), row, 4);
                            }
                        } else if (this.selectedProperty != null) {
                            if (this.selectedModifier != null) {
                                UMQM.setPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 4);
                            } else {
                                UMQM.setPropertyLevelRepetitions(this.selectedProperty.getEntryIRI(), null, userTypeIRI.getEntryIRI(), newNumber);
                                userTypeModel.setValueAt(UMQM.getRepetitions(this.selectedProperty.getEntryIRI(), this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), null, userTypeIRI.getEntryIRI()), row, 4);
                            }
                        } else if (this.selectedModifier != null) {
                            UMQM.setPropertyLevelRepetitions(null, this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI(), newNumber);
                            userTypeModel.setValueAt(UMQM.getRepetitions(null, this.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI(), this.selectedModifier.getEntryIRI(), userTypeIRI.getEntryIRI()), row, 4);
                        }
                        if (newNumber == 0) {
                            model.setValueAt("INFINITE", row, column);
                            userTypeModel.setValueAt("INFINITE", row, 4);
                        }
                        this.dirtenOntologies();
                    }
                } else {
                    model.setValueAt(oldNumber, row, column);
                }
            }
        }
    }

    private OWLSelectionModelListener getOWLModifierSelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = userModelTableModifierSelectionModel.getSelectedEntity();
                if (selected != null) {
                    UserModellingTable.this.selectedModifier = new ListIRI(selected.getIRI());
                } else {
                    UserModellingTable.this.selectedModifier = null;
                    userModelTableModifierSelectionModel = new OWLSelectionModelImpl();
                    userModelTableModifierSelectionModel.addListener(UserModellingTable.this.getOWLModifierSelectionModelListener());
                }
                if (UserModellingTable.this.selectedProperty == null && UserModellingTable.this.selectedModifier == null) {
                    UserModellingTable.this.updateUserTypeTable();
                } else {
                    UserModellingTable.this.updateInterestTable();
                }
                UserModellingTable.this.updatePreviewLabel();
            }
        };
    }

    private OWLSelectionModelListener getOWLPropertySelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = userModelTablePropertySelectionModel.getSelectedEntity();
                if (selected != null) {
                    UserModellingTable.this.selectedProperty = new ListIRI(selected.getIRI());
                } else {
                    UserModellingTable.this.selectedProperty = null;
                    userModelTablePropertySelectionModel = new OWLSelectionModelImpl();
                    userModelTablePropertySelectionModel.addListener(UserModellingTable.this.getOWLPropertySelectionModelListener());
                }
                if (UserModellingTable.this.selectedProperty == null && UserModellingTable.this.selectedModifier == null) {
                    UserModellingTable.this.updateUserTypeTable();
                } else {
                    UserModellingTable.this.updateInterestTable();
                }
                UserModellingTable.this.updatePreviewLabel();
            }
        };
    }

    private OWLSelectionModelListener getOWLClassSelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = userModelTableClassSelectionModel.getSelectedEntity();
                if (selected != null) {
                    UserModellingTable.this.selectedClass = new ListIRI(selected.getIRI());
                } else {
                    UserModellingTable.this.selectedClass = null;
                    userModelTableClassSelectionModel = new OWLSelectionModelImpl();
                    userModelTableClassSelectionModel.addListener(UserModellingTable.this.getOWLClassSelectionModelListener());
                }
                if (UserModellingTable.this.selectedProperty != null) {
                    UserModellingTable.this.updateInterestTable();
                }
                UserModellingTable.this.updatePreviewLabel();
            }
        };
    }

    private OWLSelectionModelListener getOWLIndividualSelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = userModelTableIndivSelectionModel.getSelectedEntity();
                if (selected != null) {
                    UserModellingTable.this.selectedIndiv = new ListIRI(selected.getIRI());
                } else {
                    UserModellingTable.this.selectedIndiv = null;
                    userModelTableIndivSelectionModel = new OWLSelectionModelImpl();
                    userModelTableIndivSelectionModel.addListener(UserModellingTable.this.getOWLIndividualSelectionModelListener());
                }
                if (UserModellingTable.this.selectedProperty != null) {
                    UserModellingTable.this.updateInterestTable();
                }
                UserModellingTable.this.updatePreviewLabel();
            }
        };
    }

    public static boolean isValidInterest(String num) {
        int i;
        block3: {
            try {
                i = Integer.parseInt(num);
                if (i >= -1) break block3;
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return i <= 3;
    }

    public static boolean isValidSize(String num) {
        try {
            int i = Integer.parseInt(num);
            return i >= 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }
}

