/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.ListRenderer;
import gr.aueb.cs.nlg.NLOwlPlugin.MyJPanel;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.OrderPanel;
import gr.aueb.cs.nlg.NLOwlPlugin.OrderingTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.semanticweb.owlapi.model.IRI;

class UnsortedPanel {
    private JPanel unsortedPanel = new JPanel();
    private JLabel propertyName;
    private JButton sectionAdd;
    private OrderingTab father;
    private MyJPanel containingUnsortedPanel;
    private JComboBox sectionCombo;
    private DefaultComboBoxModel sectionsComboModel;
    private ListIRI unsortedProperty;

    UnsortedPanel(OrderingTab f, MyJPanel b) {
        this.unsortedPanel.setLayout(new FlowLayout(3));
        this.unsortedPanel.setPreferredSize(new Dimension(400, 50));
        this.father = f;
        this.containingUnsortedPanel = b;
    }

    void createPropertyName(ListIRI s) {
        this.propertyName = new JLabel();
        this.propertyName.setPreferredSize(new Dimension(160, 40));
        this.propertyName.setText(s.toString());
        if (!DefaultResourcesManager.isDefaultResource(s.getEntryIRI())) {
            this.propertyName.setToolTipText(s.getEntryIRI().toString());
        } else {
            this.propertyName.setToolTipText("<html><b>This is a default resource of the system.</b> <br>" + s.getEntryIRI().toString() + "</html>");
        }
        this.unsortedPanel.add((Component)this.propertyName, 0);
    }

    void createUnsortedPanel(ListIRI propertyIRI) {
        this.unsortedProperty = propertyIRI;
        this.createPropertyName(this.unsortedProperty);
        HashSet<ListIRI> availableSections = new HashSet<ListIRI>();
        for (IRI sectionIRI : NaturalOWLTab.OQM.getOrderedSections()) {
            availableSections.add(new ListIRI(sectionIRI));
        }
        ArrayList sortList = new ArrayList(availableSections);
        Collections.sort(sortList);
        this.sectionsComboModel = new DefaultComboBoxModel<Object>(sortList.toArray());
        this.sectionCombo = new JComboBox(this.sectionsComboModel);
        this.sectionCombo.setRenderer(new ListRenderer());
        this.sectionAdd = new JButton(">>");
        this.sectionAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListIRI selectedSection = (ListIRI)UnsortedPanel.this.sectionCombo.getSelectedItem();
                for (SectionPanel sPanel : OrderingTab.getSections()) {
                    if (!sPanel.getSectionIRI().equals(selectedSection)) continue;
                    OrderPanel oPanel = new OrderPanel(sPanel);
                    sPanel.addToOrderPanels(oPanel);
                    oPanel.createOrderPanel(UnsortedPanel.this.unsortedProperty, 100);
                    int i = 0;
                    while (i < sPanel.getOrderPanelsSize()) {
                        oPanel.updateUpDownArrows(sPanel.getOrderPanels().get(i));
                        ++i;
                    }
                    OrderingTab.getSectionsPanel().validate();
                    OrderingTab.getSectionsPanel().repaint();
                    OrderingTab.updateSectionScroll();
                    OrderingTab.getUnsortedPanels().remove(UnsortedPanel.this.getThis().unsortedPanel);
                    OrderingTab.getUnsortedPanels().decreaseHeight(55);
                    OrderingTab.getUnsortedPanels().validate();
                    OrderingTab.getUnsortedPanels().repaint();
                    OrderingTab.updateUnsortedScroll();
                    OrderingTab.removeFromUnsorted(UnsortedPanel.this.getThis());
                    NaturalOWLTab.OQM.setPropertySection(UnsortedPanel.this.unsortedProperty.getEntryIRI(), sPanel.getSectionIRI().getEntryIRI());
                    NaturalOWLTab.OQM.setPropertyOrder(UnsortedPanel.this.unsortedProperty.getEntryIRI(), 100);
                    UnsortedPanel.this.father.dirtenOntologies();
                }
            }
        });
        this.unsortedPanel.add(this.sectionCombo);
        this.unsortedPanel.add(this.sectionAdd);
        OrderingTab.getUnsortedPanels().increaseHeight(55);
        OrderingTab.getUnsortedPanels().add(this.unsortedPanel);
    }

    UnsortedPanel getThis() {
        return this;
    }

    public JPanel getUnsortedPanel() {
        return this.unsortedPanel;
    }

    public DefaultComboBoxModel getSectionsComboModel() {
        return this.sectionsComboModel;
    }

    public void setSectionsComboModel(DefaultComboBoxModel sectionsComboModel) {
        this.sectionsComboModel = sectionsComboModel;
    }

    public JComboBox getSectionCombo() {
        return this.sectionCombo;
    }

    public void setSectionCombo(JComboBox sectionCombo) {
        this.sectionCombo = sectionCombo;
    }
}

