/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNamesTab;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.NewResourceDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.SentencePlanTab;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeRenderer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class SentencePlanTreeComponent
extends TreeComponent {
    JPanel complete;
    DefaultMutableTreeNode parent;
    DefaultMutableTreeNode englishParent;
    DefaultMutableTreeNode greekParent;

    public SentencePlanTreeComponent(NaturalOWLTab fatherTab) {
        super(fatherTab);
    }

    @Override
    public void createTree() {
        DefaultMutableTreeNode node;
        this.parent = new DefaultMutableTreeNode("Sentence Plans", true);
        this.englishParent = new DefaultMutableTreeNode("English Sentence Plans", true);
        this.parent.add(this.englishParent);
        ArrayList<SentencePlan> sentencePlansList = NaturalOWLTab.SPQM.getSentencePlansList("en").getSentencePlansList();
        Collections.sort(sentencePlansList);
        for (SentencePlan plan : sentencePlansList) {
            if (plan.getSentencePlanIRI().toString().startsWith(NLResourceManager.nlowlNS) && (!DefaultResourcesManager.isDefaultResource(plan.getSentencePlanIRI()) || !plan.getSentencePlanIRI().toString().startsWith(NLResourceManager.nlowlNS))) continue;
            node = new DefaultMutableTreeNode(new ListIRI(plan.getSentencePlanIRI()), false);
            this.englishParent.add(node);
        }
        this.greekParent = new DefaultMutableTreeNode("Greek Sentence Plans", true);
        this.parent.add(this.greekParent);
        sentencePlansList = NaturalOWLTab.SPQM.getSentencePlansList("el").getSentencePlansList();
        Collections.sort(sentencePlansList);
        for (SentencePlan plan : sentencePlansList) {
            if (plan.getSentencePlanIRI().toString().startsWith(NLResourceManager.nlowlNS) && (!DefaultResourcesManager.isDefaultResource(plan.getSentencePlanIRI()) || !plan.getSentencePlanIRI().toString().startsWith(NLResourceManager.nlowlNS))) continue;
            node = new DefaultMutableTreeNode(new ListIRI(plan.getSentencePlanIRI()), false);
            this.greekParent.add(node);
        }
        this.tree = new JTree(this.parent);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    DefaultMutableTreeNode node;
                    if (evt.getButton() == 3 && !((ListIRI)(node = (DefaultMutableTreeNode)SentencePlanTreeComponent.this.tree.getLastSelectedPathComponent()).getUserObject()).toString().startsWith("<")) {
                        SentencePlanTreeComponent.this.treePopupMenu(evt);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void treePopupMenu(MouseEvent evt) {
        TreePath path = this.tree.getPathForLocation(evt.getX(), evt.getY());
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        JPopupMenu popup = new JPopupMenu();
        popup.setInvoker(this.tree);
        if (!node.equals(this.parent)) {
            if (!this.isEntry(node)) {
                JMenuItem newSP = new JMenuItem("Create new " + ((String)node.getUserObject()).substring(0, ((String)node.getUserObject()).length() - 1));
                newSP.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NewResourceDialog dlg = new NewResourceDialog("New Sentence Plan", SentencePlanTreeComponent.this.treeCmp, true, "");
                        if (dlg.getResponse()) {
                            String name = dlg.getName();
                            IRI entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
                            while (name.equals("") || !NaturalOWLTab.isLegalIRI(entryIRI) || !SentencePlanTreeComponent.this.father.isUniqueIRI(entryIRI)) {
                                JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.", "Invalid entity name", 0);
                                dlg = new NewResourceDialog("New Sentence Plan", SentencePlanTreeComponent.this.treeCmp, true, "");
                                if (dlg.getResponse()) {
                                    name = dlg.getName();
                                    entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
                                    continue;
                                }
                                return;
                            }
                            SentencePlanTreeComponent.this.createNewNode(node, entryIRI);
                        }
                    }
                });
                JMenuItem duplicateInOtherLanguage = null;
                if (node.equals(this.englishParent)) {
                    duplicateInOtherLanguage = new JMenuItem("Duplicate all in Greek");
                    duplicateInOtherLanguage.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            int i = 0;
                            while (i < SentencePlanTreeComponent.this.englishParent.getChildCount()) {
                                SentencePlanTreeComponent.this.duplicateNode((DefaultMutableTreeNode)SentencePlanTreeComponent.this.englishParent.getChildAt(i), "en", "el");
                                ++i;
                            }
                        }
                    });
                } else if (node.equals(this.greekParent)) {
                    duplicateInOtherLanguage = new JMenuItem("Duplicate all in English");
                    duplicateInOtherLanguage.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SentencePlanTreeComponent.this.duplicateNode(node, "el", "en");
                        }
                    });
                }
                popup.add(newSP);
                if (duplicateInOtherLanguage != null) {
                    popup.add(duplicateInOtherLanguage);
                }
            } else {
                JMenuItem rename = new JMenuItem("Rename");
                rename.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListIRI oldName = (ListIRI)node.getUserObject();
                        String startNS = oldName.getEntryIRI().getStart();
                        NewResourceDialog dlg = new NewResourceDialog("Rename Sentence Plan", SentencePlanTreeComponent.this.treeCmp, true, oldName.toString());
                        if (dlg.getResponse()) {
                            String name = dlg.getName();
                            IRI toIRI = IRI.create((String)(String.valueOf(startNS) + name));
                            while (name.equals("") || !NaturalOWLTab.isLegalIRI(toIRI) || !SentencePlanTreeComponent.this.father.isUniqueIRI(toIRI)) {
                                JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.", "Invalid entity name", 0);
                                dlg = new NewResourceDialog("Rename Sentence Plan", SentencePlanTreeComponent.this.treeCmp, true, name);
                                if (dlg.getResponse()) {
                                    name = dlg.getName();
                                    toIRI = IRI.create((String)(String.valueOf(startNS) + name));
                                    continue;
                                }
                                return;
                            }
                            if (NaturalOWLTab.SPQM.getSentencePlansList("en").containsSentencePlan(oldName.getEntryIRI())) {
                                NaturalOWLTab.SPQM.duplicateSentencePlanInLists(oldName.getEntryIRI(), toIRI, "en");
                            } else if (NaturalOWLTab.SPQM.getSentencePlansList("el").containsSentencePlan(oldName.getEntryIRI())) {
                                NaturalOWLTab.SPQM.duplicateSentencePlanInLists(oldName.getEntryIRI(), toIRI, "el");
                            }
                            NaturalOWLTab.SPQM.removeSentencePlan(oldName.getEntryIRI());
                            NaturalOWLTab.MQM.renameSentencePlan(oldName.getEntryIRI(), toIRI);
                            NaturalOWLTab.UMQM.renameSentencePlan(oldName.getEntryIRI(), toIRI);
                            DefaultMutableTreeNode nodeParent = (DefaultMutableTreeNode)node.getParent();
                            DefaultTreeModel model = (DefaultTreeModel)SentencePlanTreeComponent.this.tree.getModel();
                            model.removeNodeFromParent(node);
                            int pos = 0;
                            int i = 0;
                            while (i < model.getChildCount(nodeParent)) {
                                if (((ListIRI)((DefaultMutableTreeNode)model.getChild(nodeParent, i)).getUserObject()).getEntryIRI().compareTo((OWLObject)toIRI) < 0) {
                                    ++pos;
                                }
                                ++i;
                            }
                            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                            model.insertNodeInto(newNode, nodeParent, pos);
                            TreePath selectedPath = new TreePath(model.getPathToRoot(newNode));
                            SentencePlanTreeComponent.this.tree.setSelectionPath(selectedPath);
                            SentencePlanTreeComponent.this.tree.scrollPathToVisible(selectedPath);
                            SentencePlanTreeComponent.this.father.dirtenOntologies();
                        }
                    }
                });
                IRI entryIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
                JMenuItem duplicate = null;
                if (NaturalOWLTab.SPQM.getSentencePlansList("en").containsSentencePlan(entryIRI)) {
                    duplicate = new JMenuItem("Duplicate");
                    duplicate.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SentencePlanTreeComponent.this.duplicateNode(node, "en", "en");
                        }
                    });
                } else if (NaturalOWLTab.SPQM.getSentencePlansList("el").containsSentencePlan(entryIRI)) {
                    duplicate = new JMenuItem("Duplicate");
                    duplicate.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SentencePlanTreeComponent.this.duplicateNode(node, "el", "el");
                        }
                    });
                }
                JMenuItem duplicateInOtherLanguage = null;
                if (NaturalOWLTab.SPQM.getSentencePlansList("en").containsSentencePlan(entryIRI)) {
                    duplicateInOtherLanguage = new JMenuItem("Duplicate in Greek");
                    duplicateInOtherLanguage.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SentencePlanTreeComponent.this.duplicateNode(node, "en", "el");
                        }
                    });
                } else if (NaturalOWLTab.SPQM.getSentencePlansList("el").containsSentencePlan(entryIRI)) {
                    duplicateInOtherLanguage = new JMenuItem("Duplicate in English");
                    duplicateInOtherLanguage.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            SentencePlanTreeComponent.this.duplicateNode(node, "el", "en");
                        }
                    });
                }
                JMenuItem delete = new JMenuItem("Delete");
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selection = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this Sentence Plan?");
                        if (selection == 0) {
                            SentencePlanTreeComponent.this.deleteNode(node);
                        }
                    }
                });
                popup.add(rename);
                if (duplicate != null) {
                    popup.add(duplicate);
                }
                if (duplicateInOtherLanguage != null) {
                    popup.add(duplicateInOtherLanguage);
                }
                popup.add(delete);
            }
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    @Override
    public JPanel TP() {
        JPanel complete = new JPanel();
        JPanel jp = new JPanel();
        JPanel treepanel = new JPanel();
        jp.setLayout(new BoxLayout(jp, 0));
        complete.setLayout(new BoxLayout(complete, 1));
        JButton buttonNew = new JButton("New Sentence Plan");
        buttonNew.addActionListener(this);
        this.createTree();
        jp.add(buttonNew);
        jp.setBackground(new Color(255, 255, 255));
        treepanel.add(this.tree);
        treepanel.setBackground(new Color(255, 255, 255));
        treepanel.setLayout(new FlowLayout(0));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.addTreeSelectionListener(this);
        ClassLoader loader = SentencePlanTreeComponent.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/SentencePlanFolder.gif");
        ImageIcon folderIcon = new ImageIcon(imageURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(folderIcon);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(folderIcon);
        imageURL = loader.getResource("/icons/SentencePlan.png");
        ImageIcon leafIcon = new ImageIcon(imageURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(leafIcon);
        JScrollPane scrollPane = new JScrollPane(treepanel);
        complete.add(jp);
        complete.add(scrollPane);
        complete.setBackground(new Color(255, 255, 255));
        return complete;
    }

    @Override
    public void addNode() {
        NewResourceDialog dlg = new NewResourceDialog("New Sentence Plan", this.treeCmp, false, "");
        if (dlg.getResponse()) {
            String name = dlg.getName();
            String type = dlg.getSecondSelected();
            IRI entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
            while (name.equals("") || !NaturalOWLTab.isLegalIRI(entryIRI) || !this.father.isUniqueIRI(entryIRI)) {
                JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.", "Invalid entity name", 0);
                dlg = new NewResourceDialog("New Sentence Plan", this.treeCmp, false, name);
                if (dlg.getResponse()) {
                    name = dlg.getName();
                    type = dlg.getSecondSelected();
                    entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
                    continue;
                }
                return;
            }
            if (type.equals("English")) {
                this.createNewNode(this.englishParent, entryIRI);
            } else if (type.equals("Greek")) {
                this.createNewNode(this.greekParent, entryIRI);
            }
        }
    }

    public void createNewNode(DefaultMutableTreeNode nodeParent, IRI name) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(name), false);
        if (nodeParent.equals(this.englishParent)) {
            NaturalOWLTab.SPQM.addSentencePlan(name, "en");
        } else {
            NaturalOWLTab.SPQM.addSentencePlan(name, "el");
        }
        NaturalOWLTab.UMQM.addSentencePlan(name);
        int pos = 0;
        int i = 0;
        while (i < model.getChildCount(nodeParent)) {
            if (((ListIRI)((DefaultMutableTreeNode)model.getChild(nodeParent, i)).getUserObject()).getEntryIRI().compareTo((OWLObject)name) < 0) {
                ++pos;
            }
            ++i;
        }
        model.insertNodeInto(newNode, nodeParent, pos);
        TreePath selectedPath = new TreePath(model.getPathToRoot(newNode));
        this.tree.setSelectionPath(selectedPath);
        this.tree.scrollPathToVisible(selectedPath);
        this.father.dirtenOntologies();
    }

    @Override
    public void deleteNode(DefaultMutableTreeNode node) {
        if (this.isEntry(node)) {
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            NaturalOWLTab.SPQM.removeSentencePlan(((ListIRI)node.getUserObject()).getEntryIRI());
            NaturalOWLTab.MQM.deleteSentencePlan(((ListIRI)node.getUserObject()).getEntryIRI());
            NaturalOWLTab.UMQM.deleteSentencePlan(((ListIRI)node.getUserObject()).getEntryIRI());
            if (node.getParent().getIndex(node) + 1 < node.getParent().getChildCount()) {
                TreePath selectedPath = new TreePath(model.getPathToRoot(node.getParent().getChildAt(node.getParent().getIndex(node) + 1)));
                this.tree.setSelectionPath(selectedPath);
                this.tree.scrollPathToVisible(selectedPath);
            } else if (node.getParent().getIndex(node) - 1 < node.getParent().getChildCount() && node.getParent().getIndex(node) > 0) {
                TreePath selectedPath = new TreePath(model.getPathToRoot(node.getParent().getChildAt(node.getParent().getIndex(node) - 1)));
                this.tree.setSelectionPath(selectedPath);
                this.tree.scrollPathToVisible(selectedPath);
            }
            model.removeNodeFromParent(node);
            this.father.dirtenOntologies();
        }
    }

    @Override
    public void duplicateNode(DefaultMutableTreeNode node, String fromLanguage, String toLanguage) {
        if (this.isEntry(node)) {
            TreePath selectedPath;
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            IRI fromIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
            IRI toIRI = null;
            if (fromLanguage.equals("en") && toLanguage.equals("el")) {
                if (fromIRI.toString().endsWith("_EN")) {
                    toIRI = IRI.create((String)(String.valueOf(fromIRI.toString().substring(0, fromIRI.toString().length() - 2)) + "GR"));
                }
            } else if (fromLanguage.equals("el") && toLanguage.equals("en") && fromIRI.toString().endsWith("_GR")) {
                toIRI = IRI.create((String)(String.valueOf(fromIRI.toString().substring(0, fromIRI.toString().length() - 2)) + "EN"));
            }
            if (toIRI == null || !this.father.isUniqueIRI(toIRI)) {
                String toIRISuffix = "_copy";
                toIRI = IRI.create((String)(String.valueOf(fromIRI.toString()) + toIRISuffix));
                int i = 2;
                while (!this.father.isUniqueIRI(toIRI)) {
                    toIRISuffix = "_copy" + i;
                    toIRI = IRI.create((String)(String.valueOf(fromIRI.toString()) + toIRISuffix));
                    ++i;
                }
            }
            int pos = 0;
            NaturalOWLTab.SPQM.duplicateSentencePlanInLists(fromIRI, toIRI, toLanguage);
            if (toLanguage.equals("en")) {
                pos = this.englishParent.getIndex(node) + 1;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                model.insertNodeInto(newNode, this.englishParent, pos);
                selectedPath = new TreePath(model.getPathToRoot(newNode));
                this.tree.setSelectionPath(selectedPath);
                this.tree.scrollPathToVisible(selectedPath);
            } else if (toLanguage.equals("el")) {
                pos = this.greekParent.getIndex(node) + 1;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                model.insertNodeInto(newNode, this.greekParent, pos);
                selectedPath = new TreePath(model.getPathToRoot(newNode));
                this.tree.setSelectionPath(selectedPath);
                this.tree.scrollPathToVisible(selectedPath);
            }
            if (SentencePlanTab.MQM.getIndividualOrClassSet(fromIRI) != null) {
                for (IRI entryIRI : SentencePlanTab.MQM.getPropertiesSet(fromIRI)) {
                    SentencePlanTab.MQM.addSentencePlanMapping(entryIRI, toIRI);
                }
            }
            for (IRI userType : SentencePlanTab.UMQM.getUserModels()) {
                SentencePlanTab.UMQM.setSentencePlanAppropriateness(toIRI, userType, NLNamesTab.UMQM.getSentencePlanAppropriateness(fromIRI, userType));
            }
            this.father.dirtenOntologies();
        }
    }

    public boolean isEntry(DefaultMutableTreeNode node) {
        return node.isLeaf() && !node.equals(this.englishParent) && !node.equals(this.greekParent) && !node.equals(this.parent);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.isEntry(node)) {
            NaturalOWLTab.sentencePlanSelectionModel.setSelectedEntity((OWLEntity)NaturalOWLTab.SPQM.getNLResourcesManager().getDataFactory().getOWLNamedIndividual(((ListIRI)node.getUserObject()).getEntryIRI()));
        }
    }
}

