/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerb;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbGR;
import gr.aueb.cs.nlg.NLFiles.SPAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationPropertySlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationSlot;
import gr.aueb.cs.nlg.NLFiles.SPFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPNounSlot;
import gr.aueb.cs.nlg.NLFiles.SPOwnerSlot;
import gr.aueb.cs.nlg.NLFiles.SPPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SPStringSlot;
import gr.aueb.cs.nlg.NLFiles.SPVerbSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLOwlPlugin.AppropriatenessDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.ComparisonsAllowedDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.ConnectionDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.MyJPan;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SentencePlanBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLEntity;

public class SentencePlanTab
extends NaturalOWLTab {
    private static final long serialVersionUID = -7007128314799160146L;
    private ArrayList<SentencePlanBox> boxes = new ArrayList();
    private ArrayList<JPanel> pluses = new ArrayList();
    private MyJPan mainPanel;
    private JScrollPane scroll;
    private JCheckBox aggr;
    private JButton comparisonsAllowedButton;
    private JButton connectButton;
    private JButton appropButton;
    private static JPanel preview;
    private SentencePlan loadedPlan;
    Logger log = Logger.getLogger(SentencePlanTab.class);
    private OWLModelManagerListener modelListener;

    protected void initialiseOWLView() throws Exception {
        if (sentencePlanSelectionModel != null) {
            sentencePlanSelectionModel.addListener(new OWLSelectionModelListener(){

                public void selectionChanged() throws Exception {
                    OWLEntity selected = sentencePlanSelectionModel.getSelectedEntity();
                    SentencePlanTab.this.loadedPlan = SPQM.getSentencePlan(selected.getIRI());
                    if (SentencePlanTab.this.loadedPlan != null) {
                        SentencePlanTab.this.checkOrderConsistency(SentencePlanTab.this.loadedPlan);
                        SentencePlanTab.this.showSentencePlan(SentencePlanTab.this.loadedPlan);
                        if (DefaultResourcesManager.isDefaultResource(SentencePlanTab.this.loadedPlan.getSentencePlanIRI())) {
                            SentencePlanTab.this.connectButton.setVisible(false);
                            SentencePlanTab.this.appropButton.setVisible(false);
                            SentencePlanTab.this.aggr.setVisible(false);
                        } else {
                            SentencePlanTab.this.connectButton.setVisible(true);
                            SentencePlanTab.this.appropButton.setVisible(true);
                            SentencePlanTab.this.aggr.setVisible(true);
                        }
                    }
                    SentencePlanTab.this.validate();
                    SentencePlanTab.this.repaint();
                }
            });
        }
        this.setLayout(new BorderLayout(10, 10));
        JPanel previewPanel = new JPanel();
        previewPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        previewPanel.setPreferredSize(new Dimension(600, 100));
        previewPanel.setLayout(new BoxLayout(previewPanel, 3));
        JPanel previewLabelPanel = new JPanel(new FlowLayout());
        JLabel previewLabel = new JLabel("Sentence Plan Preview");
        previewLabelPanel.add(previewLabel);
        preview = new JPanel();
        JLabel blabel = new JLabel(" ");
        preview.add(blabel);
        JPanel previewButtonPanel = new JPanel(new FlowLayout());
        JButton previewRefreshButton = new JButton("Refresh preview");
        previewRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SentencePlanTab.this.getThis().repaintPreview();
            }
        });
        previewButtonPanel.add(previewRefreshButton);
        previewPanel.add(previewLabelPanel);
        previewPanel.add(preview);
        previewPanel.add(previewButtonPanel);
        this.mainPanel = new MyJPan(0, 320);
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        this.mainPanel.setLayout(new FlowLayout(0));
        this.scroll = new JScrollPane(this.mainPanel);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.scroll.setViewportView(this.mainPanel);
        this.scroll.setSize(new Dimension(800, 400));
        JPanel subPanel = new JPanel();
        subPanel.setPreferredSize(new Dimension(600, 30));
        subPanel.setLayout(new BorderLayout(50, 50));
        this.comparisonsAllowedButton = new JButton("Set properties that allow comparisons...");
        this.comparisonsAllowedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComparisonsAllowedDialog dlg = new ComparisonsAllowedDialog(SentencePlanTab.this.thisTab);
                dlg.getResponse();
            }
        });
        this.connectButton = new JButton("Connect current Sentence Plan with properties...");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog dlg = new ConnectionDialog(SentencePlanTab.this.thisTab, SentencePlanTab.this.loadedPlan.getSentencePlanIRI());
                dlg.getResponse();
            }
        });
        this.appropButton = new JButton("Set Sentence Plan appropriateness...");
        this.appropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppropriatenessDialog dlg = new AppropriatenessDialog(SentencePlanTab.this.thisTab, SentencePlanTab.this.loadedPlan.getSentencePlanIRI());
                dlg.getResponse();
            }
        });
        this.aggr = new JCheckBox("Allow the resulting sentence to be aggregated", true);
        this.aggr.addItemListener(this);
        this.connectButton.setVisible(false);
        this.appropButton.setVisible(false);
        this.aggr.setVisible(false);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.comparisonsAllowedButton);
        buttonsPanel.add(this.connectButton);
        buttonsPanel.add(this.appropButton);
        subPanel.add((Component)buttonsPanel, "Before");
        subPanel.add((Component)this.aggr, "After");
        this.add(previewPanel, "North");
        this.add(this.scroll, "Center");
        this.add(subPanel, "South");
        this.validate();
        this.repaint();
    }

    public MyJPan getMainPanel() {
        return this.mainPanel;
    }

    public static JPanel getPreview() {
        return preview;
    }

    public ArrayList<SentencePlanBox> getBoxes() {
        return this.boxes;
    }

    public ArrayList<SPSlot> getSlots() {
        return this.loadedPlan.getSlotsList();
    }

    public SentencePlanTab getThis() {
        return this;
    }

    public void addToBoxes(SentencePlanBox b) {
        this.boxes.add(b);
        this.repaintPreview();
    }

    public void addToBoxes(int pos, SentencePlanBox b) {
        this.boxes.add(pos, b);
        this.repaintPreview();
    }

    public void addToSlots(int pos, SPSlot slot) {
        if (pos < this.loadedPlan.getSlotsList().size()) {
            this.loadedPlan.getSlotsList().add(pos, slot);
        } else {
            this.loadedPlan.getSlotsList().add(slot);
        }
    }

    public void removeFromBoxes(SentencePlanBox b) {
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get(i).equals(b)) {
                this.boxes.remove(i);
            }
            ++i;
        }
        this.repaintPreview();
    }

    public void removeFromSlots(SPSlot slot) {
        this.loadedPlan.getSlotsList().remove(slot);
    }

    public void setSlot(SPSlot slot, int pos) {
        this.loadedPlan.getSlotsList().set(pos, slot);
    }

    public int getPositionInBoxes(SentencePlanBox b) {
        boolean flag = false;
        int i = 0;
        while (!flag && i < this.boxes.size()) {
            if (this.boxes.get(i).equals(b)) {
                flag = true;
                continue;
            }
            ++i;
        }
        if (flag) {
            return i;
        }
        return this.boxes.size() - 1;
    }

    public void repaintPreview() {
        SentencePlanTab.getPreview().removeAll();
        JLabel blabel = new JLabel(this.previewSentencePlan());
        SentencePlanTab.getPreview().add(blabel);
        SentencePlanTab.getPreview().validate();
        SentencePlanTab.getPreview().repaint();
    }

    public void updateScroll() {
        this.scroll.validate();
        this.scroll.updateUI();
    }

    public void addToPluses(int pos, JPanel pane) {
        this.pluses.add(pos, pane);
    }

    public void removeFromPluses(int pos) {
        this.pluses.remove(pos);
    }

    public int getPlusPosition(JPanel pane) {
        int i = 0;
        while (i < this.pluses.size()) {
            if (this.pluses.get(i).equals(pane)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.getOWLModelManager().removeListener(this.modelListener);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.aggr) {
            if (this.aggr.isSelected()) {
                this.loadedPlan.setAggAllowed(true);
            } else {
                this.loadedPlan.setAggAllowed(false);
            }
            this.dirtenOntologies();
        }
    }

    private void showSentencePlan(SentencePlan plan) {
        int i = 0;
        ArrayList<SPSlot> slots = plan.getSlotsList();
        Collections.sort(slots);
        this.clearAllBoxesFromUI();
        for (SPSlot slot : slots) {
            new SentencePlanBox(this, slot, plan.getLanguage(), i++);
        }
        if (this.loadedPlan.getAggAllowed()) {
            this.aggr.setSelected(true);
        } else {
            this.aggr.setSelected(false);
        }
    }

    private void checkOrderConsistency(SentencePlan plan) {
        ArrayList<SPSlot> slots = plan.getSlotsList();
        Collections.sort(slots);
        HashSet<Integer> orders = new HashSet<Integer>();
        for (SPSlot slot : slots) {
            while (orders.contains(slot.getOrder())) {
                slot.setOrder(slot.getOrder() + 1);
            }
            orders.add(slot.getOrder());
        }
    }

    public void clearAllBoxesFromUI() {
        ArrayList<SentencePlanBox> toBeRemoved = new ArrayList<SentencePlanBox>(this.boxes);
        for (SentencePlanBox box : toBeRemoved) {
            box.delete(box);
        }
        this.mainPanel.removeAll();
    }

    public SentencePlan getLoadedPlan() {
        return this.loadedPlan;
    }

    public String previewSentencePlan() {
        ArrayList<SPSlot> slots = new ArrayList<SPSlot>();
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get((int)i).select.getSelectedIndex() != -1) {
                slots.add(this.boxes.get(i).getSlot());
            }
            ++i;
        }
        Collections.sort(slots);
        ArrayList<String> realizedSlots = new ArrayList<String>();
        ArrayList<String> slotTypes = new ArrayList<String>();
        int j = 0;
        while (j < slots.size()) {
            block214: {
                SPSlot slot;
                block223: {
                    block227: {
                        block225: {
                            block226: {
                                block224: {
                                    block222: {
                                        String ret;
                                        block221: {
                                            block218: {
                                                block219: {
                                                    String caseType;
                                                    String number;
                                                    IRI lexiconEntryIRI;
                                                    block220: {
                                                        NodeID agreeWith;
                                                        block215: {
                                                            block216: {
                                                                String gender;
                                                                block217: {
                                                                    block213: {
                                                                        slot = (SPSlot)slots.get(j);
                                                                        if (!(slot instanceof SPVerbSlot)) break block213;
                                                                        slotTypes.add("VERB");
                                                                        lexiconEntryIRI = ((SPVerbSlot)slot).getLexiconEntryIRI();
                                                                        if (lexiconEntryIRI != null) {
                                                                            String ret2;
                                                                            String voice = ((SPVerbSlot)slot).getVoice();
                                                                            String tense = ((SPVerbSlot)slot).getTense();
                                                                            NodeID agreeWith2 = ((SPVerbSlot)slot).getAgreesWithID();
                                                                            String number2 = "singular";
                                                                            String person = "3rd";
                                                                            if (agreeWith2 == null) {
                                                                                number2 = ((SPVerbSlot)slot).getNumber();
                                                                                person = ((SPVerbSlot)slot).getPerson();
                                                                            } else {
                                                                                int k = 0;
                                                                                while (k < slots.size()) {
                                                                                    if (((SPSlot)slots.get(k)).getId().equals(agreeWith2) && slots.get(k) instanceof SPNounSlot) {
                                                                                        NodeID nounAgreeWith = ((SPNounSlot)slots.get(k)).getAgreesWithID();
                                                                                        if (nounAgreeWith == null) {
                                                                                            number2 = ((SPNounSlot)slots.get(k)).getNumber();
                                                                                        }
                                                                                        person = "3rd";
                                                                                    }
                                                                                    ++k;
                                                                                }
                                                                                person = "3rd";
                                                                            }
                                                                            LexEntryVerb verb = LQM.getVerbEntry(lexiconEntryIRI, this.loadedPlan.getLanguage());
                                                                            if (lexiconEntryIRI.equals((Object)DefaultResourcesManager.toBeVLE_IRI)) {
                                                                                ret2 = "";
                                                                                if (Languages.isEnglish(this.loadedPlan.getLanguage())) {
                                                                                    if (voice.equals("active")) {
                                                                                        if (tense.equals("simple present")) {
                                                                                            if (number2.equals("singular")) {
                                                                                                if (person.equals("1st")) {
                                                                                                    ret2 = String.valueOf(ret2) + "am";
                                                                                                } else if (person.equals("2nd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "are";
                                                                                                } else if (person.equals("3rd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "is";
                                                                                                }
                                                                                            } else if (number2.equals("plural")) {
                                                                                                ret2 = String.valueOf(ret2) + "are";
                                                                                            }
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("present continuous")) {
                                                                                            if (number2.equals("singular")) {
                                                                                                if (person.equals("1st")) {
                                                                                                    ret2 = String.valueOf(ret2) + "am";
                                                                                                } else if (person.equals("2nd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "are";
                                                                                                } else if (person.equals("3rd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "is";
                                                                                                }
                                                                                            } else if (number2.equals("plural")) {
                                                                                                ret2 = String.valueOf(ret2) + "are";
                                                                                            }
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        } else if (tense.equals("present perfect")) {
                                                                                            ret2 = number2.equals("singular") && person.equals("3rd") ? String.valueOf(ret2) + "has" : String.valueOf(ret2) + "have";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " been";
                                                                                        } else if (tense.equals("simple past")) {
                                                                                            ret2 = number2.equals("singular") && person.equals("3rd") ? String.valueOf(ret2) + "was" : String.valueOf(ret2) + "were";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("past continuous")) {
                                                                                            ret2 = number2.equals("singular") && person.equals("3rd") ? String.valueOf(ret2) + "was" : String.valueOf(ret2) + "were";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        } else if (tense.equals("past perfect continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "had not been" : String.valueOf(ret2) + "had been";
                                                                                        } else if (tense.equals("simple future")) {
                                                                                            ret2 = String.valueOf(ret2) + "will";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " be";
                                                                                        } else if (tense.equals("future continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not be" : String.valueOf(ret2) + "will be";
                                                                                        } else if (tense.equals("future perfect")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not have been" : String.valueOf(ret2) + "will have been";
                                                                                        } else if (tense.equals("future perfect continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not have been" : String.valueOf(ret2) + "will have been";
                                                                                        }
                                                                                    }
                                                                                } else if (Languages.isGreek(this.loadedPlan.getLanguage())) {
                                                                                    if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                        ret2 = String.valueOf(ret2) + "\u03b4\u03b5\u03bd ";
                                                                                    }
                                                                                    if (tense.equals("simple future")) {
                                                                                        ret2 = String.valueOf(ret2) + "\u03b8\u03b1";
                                                                                    }
                                                                                    ret2 = String.valueOf(ret2) + ((LexEntryVerbGR)verb).get(voice, tense, person, number2);
                                                                                }
                                                                                realizedSlots.add(ret2.trim());
                                                                            } else {
                                                                                ret2 = "";
                                                                                if (Languages.isEnglish(this.loadedPlan.getLanguage())) {
                                                                                    if (voice.equals("active")) {
                                                                                        if (tense.equals("present continuous")) {
                                                                                            if (number2.equals("singular")) {
                                                                                                if (person.equals("1st")) {
                                                                                                    ret2 = String.valueOf(ret2) + "am";
                                                                                                } else if (person.equals("2nd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "are";
                                                                                                } else if (person.equals("3rd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "is";
                                                                                                }
                                                                                            } else if (number2.equals("plural")) {
                                                                                                ret2 = String.valueOf(ret2) + "are";
                                                                                            }
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("present perfect")) {
                                                                                            ret2 = number2.equals("singular") && person.equals("3rd") ? String.valueOf(ret2) + "has" : String.valueOf(ret2) + "have";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("simple past")) {
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + "did not";
                                                                                            }
                                                                                        } else if (tense.equals("past continuous")) {
                                                                                            ret2 = number2.equals("singular") && (person.equals("1st") || person.equals("3rd")) ? String.valueOf(ret2) + "was" : String.valueOf(ret2) + "were";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("past perfect continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "had not been" : String.valueOf(ret2) + "had been";
                                                                                        } else if (tense.equals("simple future")) {
                                                                                            ret2 = String.valueOf(ret2) + "will";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("future continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not be" : String.valueOf(ret2) + "will be";
                                                                                        } else if (tense.equals("future perfect")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not have" : String.valueOf(ret2) + "will have";
                                                                                        } else if (tense.equals("future perfect continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not have been" : String.valueOf(ret2) + "will have been";
                                                                                        }
                                                                                    } else if (voice.equals("passive")) {
                                                                                        if (tense.equals("simple present")) {
                                                                                            if (number2.equals("singular")) {
                                                                                                if (person.equals("1st")) {
                                                                                                    ret2 = String.valueOf(ret2) + "am";
                                                                                                } else if (person.equals("2nd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "are";
                                                                                                } else if (person.equals("3rd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "is";
                                                                                                }
                                                                                            } else if (number2.equals("plural")) {
                                                                                                ret2 = String.valueOf(ret2) + "are";
                                                                                            }
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("present continuous")) {
                                                                                            if (number2.equals("singular")) {
                                                                                                if (person.equals("1st")) {
                                                                                                    ret2 = String.valueOf(ret2) + "am";
                                                                                                } else if (person.equals("2nd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "are";
                                                                                                } else if (person.equals("3rd")) {
                                                                                                    ret2 = String.valueOf(ret2) + "is";
                                                                                                }
                                                                                            } else if (number2.equals("plural")) {
                                                                                                ret2 = String.valueOf(ret2) + "are";
                                                                                            }
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        } else if (tense.equals("present perfect")) {
                                                                                            ret2 = number2.equals("singular") && person.equals("3rd") ? String.valueOf(ret2) + "has" : String.valueOf(ret2) + "have";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " been";
                                                                                        } else if (tense.equals("simple past")) {
                                                                                            ret2 = number2.equals("singular") && (person.equals("1st") || person.equals("3rd")) ? String.valueOf(ret2) + "was" : String.valueOf(ret2) + "were";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                        } else if (tense.equals("past continuous")) {
                                                                                            ret2 = number2.equals("singular") && (person.equals("1st") || person.equals("3rd")) ? String.valueOf(ret2) + "was" : String.valueOf(ret2) + "were";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        } else if (tense.equals("past perfect continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "has not been" : String.valueOf(ret2) + "has been";
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        } else if (tense.equals("simple future")) {
                                                                                            ret2 = String.valueOf(ret2) + "will";
                                                                                            if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                                ret2 = String.valueOf(ret2) + " not";
                                                                                            }
                                                                                            ret2 = String.valueOf(ret2) + " be";
                                                                                        } else if (tense.equals("future continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not be" : String.valueOf(ret2) + "will be";
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        } else if (tense.equals("future perfect")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not have" : String.valueOf(ret2) + "will have";
                                                                                            ret2 = String.valueOf(ret2) + " been";
                                                                                        } else if (tense.equals("future perfect continuous")) {
                                                                                            ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") ? String.valueOf(ret2) + "will not have been" : String.valueOf(ret2) + "will have been";
                                                                                            ret2 = String.valueOf(ret2) + " being";
                                                                                        }
                                                                                    }
                                                                                    ret2 = ((SPVerbSlot)slot).getPolarity().equals("false") && tense.equals("simple past") ? String.valueOf(ret2) + " " + ((LexEntryVerbEN)verb).get(voice, "simple present", person, number2) : String.valueOf(ret2) + " " + ((LexEntryVerbEN)verb).get(voice, tense, person, number2);
                                                                                    if (((SPVerbSlot)slot).getPolarity().equals("false") && !ret2.contains("not")) {
                                                                                        ret2 = String.valueOf(ret2) + " not";
                                                                                    }
                                                                                } else if (Languages.isGreek(this.loadedPlan.getLanguage())) {
                                                                                    if (((SPVerbSlot)slot).getPolarity().equals("false")) {
                                                                                        ret2 = String.valueOf(ret2) + "\u03b4\u03b5\u03bd ";
                                                                                    }
                                                                                    if (tense.equals("present perfect")) {
                                                                                        if (number2.equals("singular")) {
                                                                                            if (person.equals("1st")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03c9";
                                                                                            } else if (person.equals("2nd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03b5\u03b9\u03c2";
                                                                                            } else if (person.equals("3rd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03b5\u03b9";
                                                                                            }
                                                                                        } else if (number2.equals("plural")) {
                                                                                            if (person.equals("1st")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03bf\u03c5\u03bc\u03b5";
                                                                                            } else if (person.equals("2nd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03b5\u03c4\u03b5 ";
                                                                                            } else if (person.equals("3rd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03bf\u03c5\u03bd";
                                                                                            }
                                                                                        }
                                                                                    } else if (tense.equals("past perfect")) {
                                                                                        if (number2.equals("singular")) {
                                                                                            if (person.equals("1st")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03b5\u03af\u03c7\u03b1";
                                                                                            } else if (person.equals("2nd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03b5\u03af\u03c7\u03b5\u03c2";
                                                                                            } else if (person.equals("3rd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03b5\u03af\u03c7\u03b5";
                                                                                            }
                                                                                        } else if (number2.equals("plural")) {
                                                                                            if (person.equals("1st")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03b5\u03af\u03c7\u03b1\u03bc\u03b5";
                                                                                            } else if (person.equals("2nd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03b5\u03af\u03c7\u03b1\u03c4\u03b5";
                                                                                            } else if (person.equals("3rd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03b5\u03af\u03c7\u03b1\u03bd";
                                                                                            }
                                                                                        }
                                                                                    } else if (tense.equals("simple future")) {
                                                                                        ret2 = String.valueOf(ret2) + "\u03b8\u03b1";
                                                                                    } else if (tense.equals("future continuous")) {
                                                                                        ret2 = String.valueOf(ret2) + "\u03b8\u03b1";
                                                                                    } else if (tense.equals("future perfect")) {
                                                                                        ret2 = String.valueOf(ret2) + "\u03b8\u03b1 ";
                                                                                        if (number2.equals("singular")) {
                                                                                            if (person.equals("1st")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03c9";
                                                                                            } else if (person.equals("2nd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03b5\u03b9\u03c2";
                                                                                            } else if (person.equals("3rd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03b5\u03b9";
                                                                                            }
                                                                                        } else if (number2.equals("plural")) {
                                                                                            if (person.equals("1st")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03bf\u03c5\u03bc\u03b5";
                                                                                            } else if (person.equals("2nd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03b5\u03c4\u03b5";
                                                                                            } else if (person.equals("3rd")) {
                                                                                                ret2 = String.valueOf(ret2) + "\u03ad\u03c7\u03bf\u03c5\u03bd";
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                    ret2 = String.valueOf(ret2) + " " + ((LexEntryVerbGR)verb).get(voice, tense, person, number2);
                                                                                }
                                                                                realizedSlots.add(ret2.trim());
                                                                            }
                                                                        } else {
                                                                            realizedSlots.add("NULL");
                                                                        }
                                                                        break block214;
                                                                    }
                                                                    if (!(slot instanceof SPAdjectiveSlot)) break block215;
                                                                    slotTypes.add("ADJECTIVE");
                                                                    lexiconEntryIRI = ((SPAdjectiveSlot)slot).getLexiconEntryIRI();
                                                                    if (lexiconEntryIRI == null) break block216;
                                                                    agreeWith = ((SPAdjectiveSlot)slot).getAgreesWithID();
                                                                    number = "singular";
                                                                    caseType = "nominative";
                                                                    gender = "masculineOrFeminine";
                                                                    if (agreeWith == null) {
                                                                        number = ((SPAdjectiveSlot)slot).getNumber();
                                                                        if (Languages.isGreek(this.loadedPlan.getLanguage())) {
                                                                            caseType = ((SPAdjectiveSlot)slot).getCase();
                                                                            gender = ((SPAdjectiveSlot)slot).getGender();
                                                                        }
                                                                    } else {
                                                                        int k = 0;
                                                                        while (k < slots.size()) {
                                                                            if (slots.get(k) instanceof SPAdjectiveSlot && ((SPAdjectiveSlot)slots.get(k)).getAgreesWithID() != null && ((SPAdjectiveSlot)slots.get(k)).getAgreesWithID().equals(agreeWith)) {
                                                                                number = ((SPAdjectiveSlot)slots.get(k)).getNumber();
                                                                                if (Languages.isGreek(this.loadedPlan.getLanguage())) {
                                                                                    caseType = ((SPAdjectiveSlot)slots.get(k)).getCase();
                                                                                    gender = ((SPAdjectiveSlot)slots.get(k)).getGender();
                                                                                }
                                                                            }
                                                                            ++k;
                                                                        }
                                                                    }
                                                                    if (!Languages.isEnglish(this.loadedPlan.getLanguage())) break block217;
                                                                    LexEntryAdjectiveEN adjectiveEntry = (LexEntryAdjectiveEN)LQM.getAdjectiveEntry(lexiconEntryIRI, this.loadedPlan.getLanguage());
                                                                    realizedSlots.add(adjectiveEntry.get_form());
                                                                    break block214;
                                                                }
                                                                if (!Languages.isGreek(this.loadedPlan.getLanguage())) break block214;
                                                                LexEntryAdjectiveGR adjectiveEntry = (LexEntryAdjectiveGR)LQM.getAdjectiveEntry(lexiconEntryIRI, this.loadedPlan.getLanguage());
                                                                realizedSlots.add(adjectiveEntry.get(gender, number, caseType));
                                                                break block214;
                                                            }
                                                            realizedSlots.add("NULL");
                                                            break block214;
                                                        }
                                                        if (!(slot instanceof SPNounSlot)) break block218;
                                                        slotTypes.add("NOUN");
                                                        lexiconEntryIRI = ((SPNounSlot)slot).getLexiconEntryIRI();
                                                        if (lexiconEntryIRI == null) break block219;
                                                        agreeWith = ((SPNounSlot)slot).getAgreesWithID();
                                                        number = "singular";
                                                        caseType = "nominative";
                                                        if (agreeWith == null) {
                                                            number = ((SPNounSlot)slot).getNumber();
                                                            if (Languages.isGreek(this.loadedPlan.getLanguage())) {
                                                                caseType = ((SPNounSlot)slot).getCase();
                                                            }
                                                        } else {
                                                            int k = 0;
                                                            while (k < slots.size()) {
                                                                if (slots.get(k) instanceof SPNounSlot && ((SPNounSlot)slots.get(k)).getAgreesWithID() != null && ((SPNounSlot)slots.get(k)).getAgreesWithID().equals(agreeWith)) {
                                                                    number = ((SPNounSlot)slots.get(k)).getNumber();
                                                                    if (Languages.isGreek(this.loadedPlan.getLanguage())) {
                                                                        caseType = ((SPNounSlot)slots.get(k)).getCase();
                                                                    }
                                                                }
                                                                ++k;
                                                            }
                                                        }
                                                        if (!Languages.isEnglish(this.loadedPlan.getLanguage())) break block220;
                                                        LexEntryNounEN nounEntry = (LexEntryNounEN)LQM.getNounEntry(lexiconEntryIRI, this.loadedPlan.getLanguage());
                                                        realizedSlots.add(nounEntry.get("", number));
                                                        break block214;
                                                    }
                                                    if (!Languages.isGreek(this.loadedPlan.getLanguage())) break block214;
                                                    LexEntryNounGR nounEntry = (LexEntryNounGR)LQM.getNounEntry(lexiconEntryIRI, this.loadedPlan.getLanguage());
                                                    realizedSlots.add(nounEntry.get(caseType, number));
                                                    break block214;
                                                }
                                                realizedSlots.add("NULL");
                                                break block214;
                                            }
                                            if (!(slot instanceof SPStringSlot)) break block221;
                                            slotTypes.add("STRING");
                                            ret = ((SPStringSlot)slot).getText();
                                            realizedSlots.add(ret);
                                            break block214;
                                        }
                                        if (!(slot instanceof SPPrepositionSlot)) break block222;
                                        slotTypes.add("PREP");
                                        ret = ((SPPrepositionSlot)slot).getPrep();
                                        realizedSlots.add(ret);
                                        break block214;
                                    }
                                    if (!(slot instanceof SPOwnerSlot)) break block223;
                                    slotTypes.add("OWNER");
                                    if (!((SPOwnerSlot)slot).getRefType().equals("auto")) break block224;
                                    if (((SPOwnerSlot)slot).getCase().equals("genitive")) {
                                        realizedSlots.add("OWNER's");
                                    } else {
                                        realizedSlots.add("OWNER");
                                    }
                                    break block214;
                                }
                                if (!((SPOwnerSlot)slot).getRefType().equals("demonstrative")) break block225;
                                if (!Languages.isEnglish(this.loadedPlan.getLanguage())) break block226;
                                if (((SPOwnerSlot)slot).getCase().equals("genitive")) {
                                    realizedSlots.add("this OWNER_SUPERCLASS's");
                                } else {
                                    realizedSlots.add("this OWNER_SUPERCLASS");
                                }
                                break block214;
                            }
                            if (!Languages.isGreek(this.loadedPlan.getLanguage())) break block214;
                            if (((SPOwnerSlot)slot).getCase().equals("genitive")) {
                                realizedSlots.add("\u03b1\u03c5\u03c4\u03bf\u03cd \u03c4\u03bf\u03c5 OWNER_SUPERCLASS");
                            } else {
                                realizedSlots.add("\u03b1\u03c5\u03c4\u03cc\u03c2 \u03bf OWNER_SUPERCLASS");
                            }
                            break block214;
                        }
                        if (!((SPOwnerSlot)slot).getRefType().equals("pronoun")) break block214;
                        if (!Languages.isEnglish(this.loadedPlan.getLanguage())) break block227;
                        if (((SPOwnerSlot)slot).getCase().equals("genitive")) {
                            realizedSlots.add("his");
                        } else {
                            realizedSlots.add("he");
                        }
                        break block214;
                    }
                    if (!Languages.isGreek(this.loadedPlan.getLanguage())) break block214;
                    realizedSlots.add("");
                    break block214;
                }
                if (slot instanceof SPFillerSlot) {
                    slotTypes.add("FILLER");
                    if (((SPFillerSlot)slot).getCase().equals("genitive")) {
                        realizedSlots.add("FILLER's");
                    } else {
                        realizedSlots.add("FILLER");
                    }
                } else if (slot instanceof SPConcatenationSlot) {
                    for (SPConcatenationPropertySlot concat : ((SPConcatenationSlot)slot).getSortedPropertySlots()) {
                        slotTypes.add("CONCAT");
                        realizedSlots.add(concat.getPropertyIRI().getFragment());
                    }
                }
            }
            ++j;
        }
        String realizedPlan = "<html>";
        int i2 = 0;
        while (i2 < realizedSlots.size()) {
            realizedPlan = String.valueOf(realizedPlan) + " [ " + (String)realizedSlots.get(i2) + " <sub>" + (String)slotTypes.get(i2) + "</sub>" + " ] ";
            ++i2;
        }
        realizedPlan = String.valueOf(realizedPlan) + "</html>";
        return realizedPlan.trim();
    }
}

