/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.LexEntryNoun;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SPAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationPropertySlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationSlot;
import gr.aueb.cs.nlg.NLFiles.SPFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPNounSlot;
import gr.aueb.cs.nlg.NLFiles.SPOwnerSlot;
import gr.aueb.cs.nlg.NLFiles.SPPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SPStringSlot;
import gr.aueb.cs.nlg.NLFiles.SPVerbSlot;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.ListRenderer;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNamesTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SentencePlanTab;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

class SentencePlanBox
implements ItemListener,
FocusListener,
ActionListener,
ListSelectionListener,
DocumentListener {
    static final String ownerSlotStr = "Property Owner";
    static final String fillerSlotStr = "Property Filler";
    static final String adjectiveSlotStr = "Adjective";
    static final String nounSlotStr = "Noun";
    static final String verbSlotStr = "Verb";
    static final String concatenationSlotStr = "Concatenation";
    static final String stringSlotStr = "String";
    static final String prepositionSlotStr = "Preposition";
    String language;
    JPanel buttonsPanel;
    JPanel box;
    JPanel dynamicPanel;
    JPanel orderPanel;
    JButton del;
    JComboBox select;
    JButton left;
    JButton right;
    int pos;
    DefaultComboBoxModel<Object> verbAgreeWithSlotModel;
    DefaultComboBoxModel concatComboModel;
    DefaultListModel concatListModel;
    JComboBox exprCombo;
    JComboBox prepLECombo;
    JComboBox verbLECombo;
    JComboBox verbTenseCombo;
    JComboBox verbVoiceCombo;
    JComboBox verbNumCombo;
    JComboBox verbPerCombo;
    JComboBox indCaseCombo;
    JComboBox ownCaseCombo;
    JComboBox concatCombo;
    JComboBox verbAgreeWithCombo;
    JLabel exprLabel;
    JLabel indCaseLabel;
    JLabel ownCaseLabel;
    JLabel verbLELabel;
    JLabel tenseLabel;
    JLabel polarityLabel;
    JLabel voiceLabel;
    JLabel numberLabel;
    JLabel personLabel;
    JLabel agreeWithLabel;
    JLabel prepLELabel;
    JLabel concatLabel;
    JLabel concatListLabel;
    JLabel adjCaseLabel;
    JLabel adjGenderLabel;
    JLabel adjNumLabel;
    JComboBox adjCaseCombo;
    JComboBox adjGenderCombo;
    JComboBox adjNumCombo;
    JComboBox adjLECombo;
    JComboBox adjAgreeWithCombo;
    DefaultComboBoxModel<Object> adjAgreeWithSlotModel;
    JLabel nounCaseLabel;
    JLabel nounNumLabel;
    JComboBox nounCaseCombo;
    JComboBox nounNumCombo;
    JComboBox nounLECombo;
    JComboBox polarityCombo;
    JComboBox nounAgreeWithCombo;
    DefaultComboBoxModel<Object> nounAgreeWithSlotModel;
    JButton concatAdd = new JButton("+");
    JButton concatMinus = new JButton("-");
    JButton concatUp = new JButton("UP");
    JButton concatDown = new JButton("DOWN");
    JCheckBox bulletsCheck;
    JTextArea stringTextArea;
    JList concatList;
    JLabel orderLabel;
    String lastOpenSlotTab = "";
    SentencePlanTab father = null;
    SPSlot slot = null;

    SentencePlanBox(SentencePlanTab f, SPSlot slot, String lang, int pos) {
        this.box = new JPanel();
        this.father = f;
        this.slot = slot;
        this.pos = pos;
        this.language = lang;
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setPreferredSize(new Dimension(220, 30));
        this.buttonsPanel.setLayout(new FlowLayout(3, 0, 1));
        this.box.add(this.buttonsPanel);
        this.box.setPreferredSize(new Dimension(225, 330));
        this.box.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        String[] choices = new String[]{ownerSlotStr, fillerSlotStr, adjectiveSlotStr, nounSlotStr, verbSlotStr, prepositionSlotStr, stringSlotStr, concatenationSlotStr};
        this.select = new JComboBox<String>(choices);
        this.select.setEditable(false);
        this.select.setVisible(true);
        this.buttonsPanel.add(this.select);
        this.dynamicPanel = new JPanel();
        this.dynamicPanel.setLayout(new CardLayout());
        this.dynamicPanel.setPreferredSize(new Dimension(200, 250));
        this.box.add(this.dynamicPanel);
        this.orderPanel = new JPanel();
        this.orderPanel.setPreferredSize(new Dimension(220, 30));
        this.orderPanel.setLayout(new FlowLayout(3, 0, 1));
        this.box.add(this.orderPanel);
        this.orderLabel = new JLabel("Slot order: " + slot.getOrder());
        this.orderPanel.add(this.orderLabel);
        JLabel slotIDLab = new JLabel(slot.getId().toString());
        this.box.add(slotIDLab);
        this.father.addToBoxes(pos, this);
        this.dynamicPanels();
        this.addMoveArrows(this);
        this.addDeleteButton();
        this.father.getMainPanel().increaseWidth(225);
        this.father.updateScroll();
        this.father.getMainPanel().add((Component)this.box, pos * 2);
        this.loadSlotInBox(slot);
        this.createPlus();
        this.updateAll();
    }

    void createPlus() {
        final JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(40, 250));
        p.setLayout(new BoxLayout(p, 2));
        ClassLoader loader = SentencePlanTab.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/plusImg.png");
        ImageIcon plusIcon = new ImageIcon(imageURL);
        Image img = plusIcon.getImage();
        Image newimg = img.getScaledInstance(25, 25, 4);
        plusIcon = new ImageIcon(newimg);
        JButton plus = new JButton(plusIcon);
        plus.setOpaque(false);
        plus.setContentAreaFilled(false);
        plus.setBorderPainted(false);
        p.add(plus);
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = SentencePlanBox.this.father.getPlusPosition(p);
                SPOwnerSlot slot = new SPOwnerSlot("nominative", "auto", SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(SentencePlanBox.this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + (pos + 2)).getID(), pos + 2);
                SentencePlanBox.this.father.addToSlots(pos + 1, slot);
                int j = pos + 1;
                while (j < SentencePlanBox.this.father.getBoxes().size()) {
                    SentencePlanBox.this.father.getBoxes().get(j).getSlot().increaseOrder();
                    SentencePlanBox.this.father.getBoxes().get(j).getSlot().setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(SentencePlanBox.this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + SentencePlanBox.this.father.getBoxes().get(j).getSlot().getOrder()).getID());
                    ++j;
                }
                j = SentencePlanBox.this.father.getBoxes().size() - 1;
                while (j >= pos + 1) {
                    SPSlot incSlot = SentencePlanBox.this.father.getBoxes().get(j).getSlot();
                    if (incSlot instanceof SPOwnerSlot || incSlot instanceof SPFillerSlot || incSlot instanceof SPAdjectiveSlot || incSlot instanceof SPNounSlot) {
                        int f = 0;
                        while (f < SentencePlanBox.this.father.getBoxes().size()) {
                            ArrayList<DefaultComboBoxModel> mdls = SentencePlanBox.this.father.getBoxes().get(f).getAgreeWithSlotModels();
                            for (DefaultComboBoxModel mdl : mdls) {
                                if (mdl.getIndexOf(incSlot.getOrder() - 1) == -1) continue;
                                mdl.addElement(incSlot.getOrder());
                                if (!mdl.getSelectedItem().equals("none") && (Integer)mdl.getSelectedItem() == incSlot.getOrder() - 1) {
                                    mdl.setSelectedItem(incSlot.getOrder());
                                }
                                mdl.removeElement(incSlot.getOrder() - 1);
                            }
                            ++f;
                        }
                    }
                    SentencePlanBox.this.father.getBoxes().get(j).updateOrderLabel();
                    --j;
                }
                SentencePlanBox newBox = new SentencePlanBox(SentencePlanBox.this.father, slot, SentencePlanBox.this.language, pos + 1);
                SentencePlanBox.this.updatePositions();
                int j2 = 0;
                while (j2 < SentencePlanBox.this.father.getBoxes().size()) {
                    SentencePlanBox.this.addMoveArrows(SentencePlanBox.this.father.getBoxes().get(j2));
                    SentencePlanBox.this.father.getBoxes().get(j2).addDeleteButton();
                    ++j2;
                }
                SentencePlanBox.this.father.getMainPanel().validate();
                SentencePlanBox.this.father.updateScroll();
                SentencePlanBox.this.father.dirtenOntologies();
            }
        });
        this.father.getMainPanel().increaseWidth(70);
        this.father.updateScroll();
        this.updatePositions();
        this.father.addToPluses(this.getThis().pos, p);
        int position = this.father.getPositionInBoxes(this.getThis()) * 2 + 1;
        this.father.getMainPanel().add((Component)p, position);
        this.father.getMainPanel().validate();
    }

    void switchBoxes(int i) {
        SPConcatenationPropertySlot concat;
        int index;
        ArrayList<DefaultComboBoxModel> mdls;
        int f;
        SentencePlanBox a = this.father.getBoxes().get(i - 1);
        SentencePlanBox b = this.father.getBoxes().get(i);
        this.father.removeFromBoxes(a);
        this.father.removeFromBoxes(b);
        this.father.addToBoxes(i - 1, b);
        this.father.addToBoxes(i, a);
        SPSlot aSlot = a.getSlot();
        SPSlot bSlot = b.getSlot();
        this.father.removeFromSlots(aSlot);
        this.father.removeFromSlots(bSlot);
        int aOrder = aSlot.getOrder();
        int bOrder = bSlot.getOrder();
        if (aSlot instanceof SPOwnerSlot || aSlot instanceof SPFillerSlot || aSlot instanceof SPAdjectiveSlot || aSlot instanceof SPNounSlot) {
            f = 0;
            while (f < this.father.getBoxes().size()) {
                mdls = this.father.getBoxes().get(f).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(aSlot.getOrder()) == -1) continue;
                    mdl.addElement(bOrder);
                    if (!mdl.getSelectedItem().equals("none") && ((Integer)mdl.getSelectedItem()).intValue() == aSlot.getOrder()) {
                        mdl.setSelectedItem(bOrder);
                    }
                    mdl.removeElement(aSlot.getOrder());
                }
                ++f;
            }
        }
        if (bSlot instanceof SPOwnerSlot || bSlot instanceof SPFillerSlot || bSlot instanceof SPAdjectiveSlot || bSlot instanceof SPNounSlot) {
            f = 0;
            while (f < this.father.getBoxes().size()) {
                mdls = this.father.getBoxes().get(f).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(bSlot.getOrder()) == -1) continue;
                    mdl.addElement(aOrder);
                    if (!mdl.getSelectedItem().equals("none") && ((Integer)mdl.getSelectedItem()).intValue() == bSlot.getOrder()) {
                        mdl.setSelectedItem(aOrder);
                    }
                    mdl.removeElement(bSlot.getOrder());
                }
                ++f;
            }
        }
        aSlot.setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + bOrder).getID());
        aSlot.setOrder(bOrder);
        if (aSlot instanceof SPConcatenationSlot) {
            index = 0;
            while (index < ((SPConcatenationSlot)aSlot).getPropertySlots().size()) {
                concat = ((SPConcatenationSlot)aSlot).getPropertySlots().get(index);
                concat.setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "conslot" + aSlot.getOrder() + "_" + (index + 1)).getID());
                ++index;
            }
        }
        bSlot.setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + aOrder).getID());
        bSlot.setOrder(aOrder);
        if (bSlot instanceof SPConcatenationSlot) {
            index = 0;
            while (index < ((SPConcatenationSlot)bSlot).getPropertySlots().size()) {
                concat = ((SPConcatenationSlot)bSlot).getPropertySlots().get(index);
                concat.setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "conslot" + bSlot.getOrder() + "_" + (index + 1)).getID());
                ++index;
            }
        }
        this.father.addToSlots(i - 1, bSlot);
        this.father.addToSlots(i, aSlot);
        a.updateOrderLabel();
        b.updateOrderLabel();
        this.father.repaintPreview();
        this.father.dirtenOntologies();
    }

    void addDeleteButton() {
        if (this.del == null) {
            ClassLoader loader = SentencePlanTab.class.getClassLoader();
            URL imageURL = loader.getResource("/icons/deleteImg.png");
            ImageIcon delIcon = new ImageIcon(imageURL);
            Image img = delIcon.getImage();
            Image newimg = img.getScaledInstance(20, 20, 4);
            delIcon = new ImageIcon(newimg);
            this.del = new JButton(delIcon);
            this.del.setOpaque(false);
            this.del.setContentAreaFilled(false);
            this.del.setBorderPainted(false);
            String t = "Are you sure you want to delete this?";
            final String title = new String(t);
            this.del.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int ans = JOptionPane.showConfirmDialog(null, title, "Delete?", 2);
                    if (ans == 0) {
                        int position = SentencePlanBox.this.father.getPositionInBoxes(SentencePlanBox.this.getThis()) + 1;
                        SentencePlanBox.this.father.removeFromPluses(position - 1);
                        int j = position;
                        while (j < SentencePlanBox.this.father.getBoxes().size()) {
                            SentencePlanBox.this.father.getBoxes().get(j).getSlot().decreaseOrder();
                            SentencePlanBox.this.father.getBoxes().get(j).getSlot().setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(SentencePlanBox.this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + SentencePlanBox.this.father.getBoxes().get(j).getSlot().getOrder()).getID());
                            ++j;
                        }
                        if (SentencePlanBox.this.getThis().slot instanceof SPOwnerSlot || SentencePlanBox.this.getThis().slot instanceof SPFillerSlot || SentencePlanBox.this.getThis().slot instanceof SPAdjectiveSlot || SentencePlanBox.this.getThis().slot instanceof SPNounSlot) {
                            int f = 0;
                            while (f < SentencePlanBox.this.father.getBoxes().size()) {
                                ArrayList<DefaultComboBoxModel> mdls = SentencePlanBox.this.father.getBoxes().get(f).getAgreeWithSlotModels();
                                for (DefaultComboBoxModel mdl : mdls) {
                                    if (mdl.getIndexOf(SentencePlanBox.this.getThis().getSlot().getOrder()) == -1) continue;
                                    if (!mdl.getSelectedItem().equals("none") && ((Integer)mdl.getSelectedItem()).intValue() == SentencePlanBox.this.getThis().getSlot().getOrder()) {
                                        mdl.setSelectedItem("none");
                                    }
                                    mdl.removeElement(SentencePlanBox.this.getThis().getSlot().getOrder());
                                }
                                ++f;
                            }
                        }
                        SentencePlanBox.this.father.removeFromSlots(SentencePlanBox.this.getThis().slot);
                        SentencePlanBox.this.delete(SentencePlanBox.this.getThis());
                        j = position - 1;
                        while (j < SentencePlanBox.this.father.getBoxes().size()) {
                            SPSlot decSlot = SentencePlanBox.this.father.getBoxes().get(j).getSlot();
                            if (decSlot instanceof SPOwnerSlot || decSlot instanceof SPFillerSlot || decSlot instanceof SPAdjectiveSlot || decSlot instanceof SPNounSlot) {
                                int f = 0;
                                while (f < SentencePlanBox.this.father.getBoxes().size()) {
                                    ArrayList<DefaultComboBoxModel> mdls = SentencePlanBox.this.father.getBoxes().get(f).getAgreeWithSlotModels();
                                    for (DefaultComboBoxModel mdl : mdls) {
                                        if (mdl.getIndexOf(decSlot.getOrder() + 1) == -1) continue;
                                        mdl.addElement(decSlot.getOrder());
                                        if (!mdl.getSelectedItem().equals("none") && (Integer)mdl.getSelectedItem() == decSlot.getOrder() + 1) {
                                            mdl.setSelectedItem(decSlot.getOrder());
                                        }
                                        mdl.removeElement(decSlot.getOrder() + 1);
                                    }
                                    ++f;
                                }
                            }
                            SentencePlanBox.this.father.getBoxes().get(j).updateOrderLabel();
                            ++j;
                        }
                        SentencePlanBox.this.father.dirtenOntologies();
                    }
                }
            });
            this.buttonsPanel.add((Component)this.del, 0);
        }
        if (this.father.getBoxes().size() > 1) {
            this.del.setEnabled(true);
        } else {
            this.del.setEnabled(false);
        }
    }

    void addMoveArrows(SentencePlanBox b) {
        Image newimg;
        Image img;
        URL imageURL;
        ClassLoader loader;
        int pos;
        if (b.left != null) {
            b.buttonsPanel.remove(b.left);
        }
        if (b.right != null) {
            b.buttonsPanel.remove(b.right);
        }
        if ((pos = this.father.getPositionInBoxes(b)) > 0) {
            loader = SentencePlanTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/leftImg.png");
            ImageIcon leftIcon = new ImageIcon(imageURL);
            img = leftIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            leftIcon = new ImageIcon(newimg);
            b.left = new JButton(leftIcon);
            b.left.setOpaque(false);
            b.left.setContentAreaFilled(false);
            b.left.setBorderPainted(false);
            b.left.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SentencePlanBox leftBox = SentencePlanBox.this.father.getBoxes().get(pos - 1);
                    SentencePlanBox thisBox = SentencePlanBox.this.father.getBoxes().get(pos);
                    SentencePlanBox.this.father.getMainPanel().switchOrder(pos * 2);
                    SentencePlanBox.this.switchBoxes(pos);
                    SentencePlanBox.this.updatePositions();
                    SentencePlanBox.this.addMoveArrows(leftBox);
                    SentencePlanBox.this.addMoveArrows(thisBox);
                    leftBox.box.repaint();
                    thisBox.box.repaint();
                    SentencePlanBox.this.father.getMainPanel().validate();
                    SentencePlanBox.this.father.getMainPanel().repaint();
                }
            });
            b.left.setVisible(true);
            b.buttonsPanel.add(b.left);
        }
        if (pos < this.father.getBoxes().size() - 1) {
            loader = SentencePlanTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/rightImg.png");
            ImageIcon rightIcon = new ImageIcon(imageURL);
            img = rightIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            rightIcon = new ImageIcon(newimg);
            b.right = new JButton(rightIcon);
            b.right.setOpaque(false);
            b.right.setContentAreaFilled(false);
            b.right.setBorderPainted(false);
            b.right.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SentencePlanBox thisBox = SentencePlanBox.this.father.getBoxes().get(pos);
                    SentencePlanBox rightBox = SentencePlanBox.this.father.getBoxes().get(pos + 1);
                    SentencePlanBox.this.father.getMainPanel().switchOrder(pos * 2 + 2);
                    SentencePlanBox.this.switchBoxes(pos + 1);
                    SentencePlanBox.this.updatePositions();
                    SentencePlanBox.this.addMoveArrows(thisBox);
                    SentencePlanBox.this.addMoveArrows(rightBox);
                    thisBox.box.repaint();
                    rightBox.box.repaint();
                    SentencePlanBox.this.father.getMainPanel().validate();
                    SentencePlanBox.this.father.getMainPanel().repaint();
                }
            });
            b.right.setVisible(true);
            b.buttonsPanel.add(b.right);
        }
        b.buttonsPanel.validate();
        b.box.validate();
        b.box.repaint();
    }

    void delete(SentencePlanBox b) {
        this.father.getMainPanel().decreaseWidth(295);
        this.father.updateScroll();
        int pos = this.father.getPositionInBoxes(b);
        this.father.getMainPanel().remove(b.box);
        if (pos != 0 || this.father.getBoxes().size() != 1) {
            this.father.getMainPanel().remove(this.father.getMainPanel().getComponent(pos * 2));
        }
        this.father.getMainPanel().validate();
        this.father.getMainPanel().repaint();
        int i = 0;
        while (i < this.father.getBoxes().size()) {
            if (this.father.getBoxes().get(i).equals(b)) {
                this.father.removeFromBoxes(b);
            }
            ++i;
        }
        this.updatePositions();
        i = 0;
        while (i < this.father.getBoxes().size()) {
            this.addMoveArrows(this.father.getBoxes().get(i));
            this.father.getBoxes().get(i).addDeleteButton();
            ++i;
        }
    }

    void updatePositions() {
        int i = 0;
        while (i < this.father.getBoxes().size()) {
            this.father.getBoxes().get(i).setPosition(i);
            ++i;
        }
    }

    SentencePlanBox getThis() {
        return this;
    }

    void setPosition(int i) {
        this.pos = i;
    }

    void updateAll() {
        int i = 0;
        while (i < this.father.getBoxes().size()) {
            this.addMoveArrows(this.father.getBoxes().get(i));
            this.father.getBoxes().get(i).addDeleteButton();
            ++i;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.select) {
            String option = (String)evt.getItem();
            if (option.equals(ownerSlotStr)) {
                this.slot = new SPOwnerSlot("nominative", "auto", this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(fillerSlotStr)) {
                this.slot = new SPFillerSlot("nominative", false, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(adjectiveSlotStr)) {
                this.slot = new SPAdjectiveSlot(null, "nominative", "masculine", "singular", null, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(nounSlotStr)) {
                this.slot = new SPNounSlot(null, "nominative", "singular", null, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(verbSlotStr)) {
                this.slot = new SPVerbSlot(null, "simple present", "active", SPVerbSlot.POLARITY_POSITIVE, "singular", "1st", null, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(prepositionSlotStr)) {
                if (this.language.equals("en")) {
                    this.slot = new SPPrepositionSlot("after", this.slot.getId(), this.slot.getOrder());
                } else if (this.language.equals("el")) {
                    this.slot = new SPPrepositionSlot("\u03b1\u03c0\u03cc", this.slot.getId(), this.slot.getOrder());
                }
            } else if (option.equals(stringSlotStr)) {
                this.slot = new SPStringSlot("", this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(concatenationSlotStr)) {
                this.slot = new SPConcatenationSlot(this.slot.getId(), this.slot.getOrder());
            }
            this.father.setSlot(this.slot, this.pos);
            this.father.dirtenOntologies();
            this.loadSlotInBox(this.slot);
        } else if (evt.getSource() == this.exprCombo) {
            ((SPOwnerSlot)this.slot).setRefType(this.exprCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.ownCaseCombo) {
            ((SPOwnerSlot)this.slot).setCase(this.ownCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.indCaseCombo) {
            ((SPFillerSlot)this.slot).setCase(this.indCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.bulletsCheck) {
            if (this.bulletsCheck.isSelected()) {
                ((SPFillerSlot)this.slot).setBullets(true);
            } else {
                ((SPFillerSlot)this.slot).setBullets(false);
            }
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjLECombo) {
            ((SPAdjectiveSlot)this.slot).setLexiconEntryIRI(((ListIRI)this.adjLECombo.getSelectedItem()).getEntryIRI());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjCaseCombo) {
            ((SPAdjectiveSlot)this.slot).setCase(this.adjCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjGenderCombo) {
            ((SPAdjectiveSlot)this.slot).setGender(this.adjGenderCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjNumCombo) {
            ((SPAdjectiveSlot)this.slot).setNumber(this.adjNumCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjAgreeWithCombo) {
            if (this.adjAgreeWithCombo.getSelectedItem() != null) {
                if (this.adjAgreeWithCombo.getSelectedItem().equals("none")) {
                    ((SPAdjectiveSlot)this.slot).setAgreesWithID(null);
                    this.father.dirtenOntologies();
                    if (this.language.equals("el")) {
                        this.adjCaseCombo.setEnabled(true);
                        if (this.adjCaseCombo.getSelectedIndex() == -1) {
                            this.adjCaseCombo.setSelectedIndex(0);
                        }
                        this.adjCaseCombo.addItemListener(this);
                        this.adjGenderCombo.setEnabled(true);
                        if (this.adjGenderCombo.getSelectedIndex() == -1) {
                            this.adjGenderCombo.setSelectedIndex(0);
                        }
                        this.adjGenderCombo.addItemListener(this);
                    }
                    this.adjNumCombo.setEnabled(true);
                    if (this.adjNumCombo.getSelectedIndex() == -1) {
                        this.adjNumCombo.setSelectedIndex(0);
                    }
                    this.adjNumCombo.addItemListener(this);
                } else {
                    HashSet<SPSlot> slots = new HashSet<SPSlot>();
                    slots.add(this.slot);
                    if (this.agreeCycleExists(slots, Integer.parseInt(this.adjAgreeWithCombo.getSelectedItem().toString()))) {
                        this.adjAgreeWithCombo.setSelectedItem("none");
                        JOptionPane.showMessageDialog(null, "Cyclic agreement between slots.", "Error", 0);
                    } else {
                        ((SPAdjectiveSlot)this.slot).setAgreesWithID(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + this.adjAgreeWithCombo.getSelectedItem().toString()).getID());
                        this.father.dirtenOntologies();
                        if (this.language.equals("el")) {
                            this.adjCaseCombo.setEnabled(false);
                            this.adjCaseCombo.removeItemListener(this);
                            this.adjGenderCombo.setEnabled(false);
                            this.adjGenderCombo.removeItemListener(this);
                        }
                        this.adjNumCombo.setEnabled(false);
                        this.adjNumCombo.removeItemListener(this);
                    }
                }
            }
        } else if (evt.getSource() == this.nounLECombo) {
            ((SPNounSlot)this.slot).setLexiconEntryIRI(((ListIRI)this.nounLECombo.getSelectedItem()).getEntryIRI());
            LexEntryNoun entry = SentencePlanTab.LQM.getNounEntry(((SPNounSlot)this.slot).getLexiconEntryIRI(), this.language);
            this.nounNumCombo.setEnabled(true);
            if (entry.getNumber().equals("singular")) {
                this.nounNumCombo.setSelectedItem("singular");
                this.nounNumCombo.setEnabled(false);
            } else if (entry.getNumber().equals("plural")) {
                this.nounNumCombo.setSelectedItem("plural");
                this.nounNumCombo.setEnabled(false);
            }
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounCaseCombo) {
            ((SPNounSlot)this.slot).setCase(this.nounCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounNumCombo) {
            ((SPNounSlot)this.slot).setNumber(this.nounNumCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounAgreeWithCombo) {
            if (this.nounAgreeWithCombo.getSelectedItem() != null) {
                if (this.nounAgreeWithCombo.getSelectedItem().equals("none")) {
                    ((SPNounSlot)this.slot).setAgreesWithID(null);
                    this.father.dirtenOntologies();
                    if (this.language.equals("el")) {
                        this.nounCaseCombo.setEnabled(true);
                        if (this.nounCaseCombo.getSelectedIndex() == -1) {
                            this.nounCaseCombo.setSelectedIndex(0);
                        }
                        this.nounCaseCombo.addItemListener(this);
                    }
                    this.nounNumCombo.setEnabled(true);
                    if (this.nounNumCombo.getSelectedIndex() == -1) {
                        this.nounNumCombo.setSelectedIndex(0);
                    }
                    this.nounNumCombo.addItemListener(this);
                } else {
                    HashSet<SPSlot> slots = new HashSet<SPSlot>();
                    slots.add(this.slot);
                    if (this.agreeCycleExists(slots, Integer.parseInt(this.nounAgreeWithCombo.getSelectedItem().toString()))) {
                        this.nounAgreeWithCombo.setSelectedItem("none");
                        JOptionPane.showMessageDialog(null, "Cyclic agreement between slots.", "Error", 0);
                    } else {
                        ((SPNounSlot)this.slot).setAgreesWithID(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + this.nounAgreeWithCombo.getSelectedItem().toString()).getID());
                        this.father.dirtenOntologies();
                        if (this.language.equals("el")) {
                            this.nounCaseCombo.setEnabled(false);
                            this.nounCaseCombo.removeItemListener(this);
                        }
                        this.nounNumCombo.setEnabled(false);
                        this.nounNumCombo.removeItemListener(this);
                    }
                }
            }
        } else if (evt.getSource() == this.verbLECombo) {
            ((SPVerbSlot)this.slot).setLexiconEntryIRI(((ListIRI)this.verbLECombo.getSelectedItem()).getEntryIRI());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.polarityCombo) {
            ((SPVerbSlot)this.slot).setPolarity(this.polarityCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.verbTenseCombo) {
            ((SPVerbSlot)this.slot).setTense(this.verbTenseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.verbVoiceCombo) {
            ((SPVerbSlot)this.slot).setVoice(this.verbVoiceCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.verbNumCombo) {
            ((SPVerbSlot)this.slot).setNumber(this.verbNumCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.verbPerCombo) {
            ((SPVerbSlot)this.slot).setPerson(this.verbPerCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.verbAgreeWithCombo) {
            if (this.verbAgreeWithCombo.getSelectedItem().equals("none")) {
                ((SPVerbSlot)this.slot).setAgreesWithID(null);
                this.father.dirtenOntologies();
                this.verbNumCombo.setEnabled(true);
                if (this.verbNumCombo.getSelectedIndex() == -1) {
                    this.verbNumCombo.setSelectedIndex(0);
                }
                this.verbNumCombo.addItemListener(this);
                this.verbPerCombo.setEnabled(true);
                if (this.verbPerCombo.getSelectedIndex() == -1) {
                    this.verbPerCombo.setSelectedIndex(0);
                }
                this.verbPerCombo.addItemListener(this);
            } else {
                HashSet<SPSlot> slots = new HashSet<SPSlot>();
                slots.add(this.slot);
                if (this.agreeCycleExists(slots, Integer.parseInt(this.verbAgreeWithCombo.getSelectedItem().toString()))) {
                    this.verbAgreeWithCombo.setSelectedItem("none");
                    JOptionPane.showMessageDialog(null, "Cyclic agreement between slots.", "Error", 0);
                } else {
                    ((SPVerbSlot)this.slot).setAgreesWithID(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "slot" + this.verbAgreeWithCombo.getSelectedItem().toString()).getID());
                    this.father.dirtenOntologies();
                    this.verbNumCombo.setEnabled(false);
                    this.verbNumCombo.removeItemListener(this);
                    this.verbPerCombo.setEnabled(false);
                    this.verbPerCombo.removeItemListener(this);
                }
            }
        } else if (evt.getSource() == this.prepLECombo) {
            ((SPPrepositionSlot)this.slot).setPrep(this.prepLECombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        }
    }

    void dynamicPanels() {
        String[] tenses;
        String[] cases;
        JPanel ownerCard = new JPanel();
        JPanel ownerCardSub1 = new JPanel();
        JPanel ownerCardSub2 = new JPanel();
        JPanel fillerCard = new JPanel();
        JPanel fillerCardSub1 = new JPanel();
        JPanel fillerCardSub2 = new JPanel();
        JPanel adjectiveCard = new JPanel();
        JPanel adjectiveCardSub2 = new JPanel();
        JPanel adjectiveCardSub3 = new JPanel();
        JPanel adjectiveCardSub4 = new JPanel();
        JPanel adjectiveCardSub5 = new JPanel();
        JPanel adjectiveCardSub6 = new JPanel();
        JPanel nounCard = new JPanel();
        JPanel nounCardSub2 = new JPanel();
        JPanel nounCardSub3 = new JPanel();
        JPanel nounCardSub4 = new JPanel();
        JPanel nounCardSub5 = new JPanel();
        JPanel verbSlotCard = new JPanel();
        JPanel verbSlotCardSub1 = new JPanel();
        JPanel verbSlotCardSub2 = new JPanel();
        JPanel verbSlotCardSub3 = new JPanel();
        JPanel verbSlotCardSub4 = new JPanel();
        JPanel verbSlotCardSub5 = new JPanel();
        JPanel verbSlotCardSub6 = new JPanel();
        JPanel verbSlotCardSub7 = new JPanel();
        JPanel prepositionCard = new JPanel();
        JPanel prepositionCardSub1 = new JPanel();
        JPanel stringCard = new JPanel();
        JPanel stringCardSub1 = new JPanel();
        JPanel concatenationCard = new JPanel();
        JPanel concatenationCardSub1 = new JPanel();
        JPanel concatenationCardSub2 = new JPanel();
        JPanel concatenationCardSub3 = new JPanel();
        JPanel concatenationCardSub4 = new JPanel();
        JPanel concatenationCardSub5 = new JPanel();
        ownerCard.setLayout(new GridLayout(8, 0));
        ownerCardSub1.setLayout(new FlowLayout(0));
        fillerCard.setLayout(new GridLayout(8, 0));
        fillerCardSub1.setLayout(new FlowLayout(0));
        fillerCardSub2.setLayout(new FlowLayout(0));
        adjectiveCard.setLayout(new GridLayout(8, 0));
        adjectiveCardSub2.setLayout(new FlowLayout(0));
        adjectiveCardSub3.setLayout(new FlowLayout(0));
        adjectiveCardSub4.setLayout(new FlowLayout(0));
        adjectiveCardSub5.setLayout(new FlowLayout(0));
        adjectiveCardSub6.setLayout(new FlowLayout(0));
        nounCard.setLayout(new GridLayout(8, 0));
        nounCardSub2.setLayout(new FlowLayout(0));
        nounCardSub3.setLayout(new FlowLayout(0));
        nounCardSub4.setLayout(new FlowLayout(0));
        nounCardSub5.setLayout(new FlowLayout(0));
        verbSlotCard.setLayout(new GridLayout(8, 0));
        verbSlotCardSub1.setLayout(new FlowLayout(0));
        verbSlotCardSub2.setLayout(new FlowLayout(0));
        verbSlotCardSub3.setLayout(new FlowLayout(0));
        verbSlotCardSub4.setLayout(new FlowLayout(0));
        verbSlotCardSub5.setLayout(new FlowLayout(0));
        verbSlotCardSub6.setLayout(new FlowLayout(0));
        verbSlotCardSub7.setLayout(new FlowLayout(0));
        prepositionCard.setLayout(new GridLayout(8, 0));
        prepositionCardSub1.setLayout(new FlowLayout(0));
        stringCard.setLayout(new GridLayout(0, 1));
        stringCardSub1.setLayout(new BorderLayout());
        concatenationCard.setLayout(new BorderLayout());
        concatenationCardSub1.setLayout(new FlowLayout(0));
        concatenationCardSub2.setLayout(new FlowLayout(0));
        concatenationCardSub3.setLayout(new FlowLayout(0));
        concatenationCardSub4.setLayout(new FlowLayout(0));
        concatenationCardSub5.setLayout(new FlowLayout(0));
        this.exprLabel = new JLabel("Expression Type");
        String[] choices = new String[]{"auto", "pronoun", "demonstrative"};
        this.exprCombo = new JComboBox<String>(choices);
        ownerCardSub1.add(this.exprLabel);
        ownerCardSub1.add(this.exprCombo);
        ownerCard.add(ownerCardSub1);
        Dimension labelD = this.exprLabel.getPreferredSize();
        Dimension comboD = this.exprCombo.getPreferredSize();
        int boxLabelWidth = 85;
        int boxComboWidth = 105;
        this.exprLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.exprCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.ownCaseLabel = new JLabel("Case");
        if (this.language.equals("el")) {
            cases = new String[]{"nominative", "genitive", "accusative"};
            this.ownCaseCombo = new JComboBox<String>(cases);
        } else if (this.language.equals("en")) {
            cases = new String[]{"nominative", "genitive"};
            this.ownCaseCombo = new JComboBox<String>(cases);
        }
        this.ownCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.ownCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        ownerCardSub2.add(this.ownCaseLabel);
        ownerCardSub2.add(this.ownCaseCombo);
        ownerCard.add(ownerCardSub2);
        this.indCaseLabel = new JLabel("Case");
        if (this.language.equals("el")) {
            cases = new String[]{"nominative", "genitive", "accusative"};
            this.indCaseCombo = new JComboBox<String>(cases);
        } else if (this.language.equals("en")) {
            cases = new String[]{"nominative", "genitive"};
            this.indCaseCombo = new JComboBox<String>(cases);
        }
        fillerCardSub1.add(this.indCaseLabel);
        fillerCardSub1.add(this.indCaseCombo);
        fillerCard.add(fillerCardSub1);
        this.bulletsCheck = new JCheckBox("Use bullets", false);
        fillerCardSub2.add(this.bulletsCheck);
        fillerCard.add(fillerCardSub2);
        this.indCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.indCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        JLabel adjLELabel = new JLabel("Lexicon Entry");
        HashSet<ListIRI> adjLexiconEntries = new HashSet<ListIRI>();
        for (IRI iri : SentencePlanTab.LQM.getAdjectiveEntries()) {
            adjLexiconEntries.add(new ListIRI(iri));
        }
        ArrayList sortedList = new ArrayList(adjLexiconEntries);
        Collections.sort(sortedList);
        this.adjLECombo = new JComboBox<Object>(sortedList.toArray());
        this.adjLECombo.setRenderer(new ListRenderer());
        adjectiveCardSub2.add(adjLELabel);
        adjectiveCardSub2.add(this.adjLECombo);
        adjectiveCard.add(adjectiveCardSub2);
        if (this.language.equals("el")) {
            this.adjCaseLabel = new JLabel("Case");
            String[] cases2 = new String[]{"nominative", "genitive", "accusative"};
            this.adjCaseCombo = new JComboBox<String>(cases2);
            adjectiveCardSub3.add(this.adjCaseLabel);
            adjectiveCardSub3.add(this.adjCaseCombo);
            adjectiveCard.add(adjectiveCardSub3);
            this.adjGenderLabel = new JLabel("Gender");
            String[] genders = new String[]{"masculine", "feminine", "neuter"};
            this.adjGenderCombo = new JComboBox<String>(genders);
            adjectiveCardSub4.add(this.adjGenderLabel);
            adjectiveCardSub4.add(this.adjGenderCombo);
            adjectiveCard.add(adjectiveCardSub4);
        }
        this.adjNumLabel = new JLabel("Number");
        String[] numbers = new String[]{"singular", "plural"};
        this.adjNumCombo = new JComboBox<String>(numbers);
        adjectiveCardSub5.add(this.adjNumLabel);
        adjectiveCardSub5.add(this.adjNumCombo);
        adjectiveCard.add(adjectiveCardSub5);
        this.adjAgreeWithSlotModel = new DefaultComboBoxModel();
        this.adjAgreeWithSlotModel.addElement("none");
        int j = 0;
        while (j < this.father.getBoxes().size()) {
            SPSlot s = this.father.getBoxes().get(j).getSlot();
            if ((s instanceof SPOwnerSlot || s instanceof SPFillerSlot || s instanceof SPAdjectiveSlot || s instanceof SPNounSlot) && s.getOrder() != this.getSlot().getOrder()) {
                this.adjAgreeWithSlotModel.addElement(s.getOrder());
            }
            ++j;
        }
        JLabel adjAgreeWithLabel = new JLabel("Agree with slot ");
        this.adjAgreeWithCombo = new JComboBox<Object>(this.adjAgreeWithSlotModel);
        adjectiveCardSub6.add(adjAgreeWithLabel);
        adjectiveCardSub6.add(this.adjAgreeWithCombo);
        adjectiveCard.add(adjectiveCardSub6);
        adjLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        if (this.language.equals("el")) {
            this.adjCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
            this.adjGenderLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        }
        this.adjNumLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        adjAgreeWithLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.adjLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        if (this.language.equals("el")) {
            this.adjCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
            this.adjGenderCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        }
        this.adjNumCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.adjAgreeWithCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        JLabel nounLELabel = new JLabel("Lexicon Entry");
        HashSet<ListIRI> nounLexiconEntries = new HashSet<ListIRI>();
        for (IRI iri : SentencePlanTab.LQM.getNounEntries()) {
            nounLexiconEntries.add(new ListIRI(iri));
        }
        sortedList = new ArrayList(nounLexiconEntries);
        Collections.sort(sortedList);
        this.nounLECombo = new JComboBox<Object>(sortedList.toArray());
        this.nounLECombo.setRenderer(new ListRenderer());
        nounCardSub2.add(nounLELabel);
        nounCardSub2.add(this.nounLECombo);
        nounCard.add(nounCardSub2);
        if (this.language.equals("el")) {
            this.nounCaseLabel = new JLabel("Case");
            String[] cases3 = new String[]{"nominative", "genitive", "accusative"};
            this.nounCaseCombo = new JComboBox<String>(cases3);
            nounCardSub3.add(this.nounCaseLabel);
            nounCardSub3.add(this.nounCaseCombo);
            nounCard.add(nounCardSub3);
        }
        this.nounNumLabel = new JLabel("Number");
        this.nounNumCombo = new JComboBox<String>(numbers);
        nounCardSub4.add(this.nounNumLabel);
        nounCardSub4.add(this.nounNumCombo);
        nounCard.add(nounCardSub4);
        this.nounAgreeWithSlotModel = new DefaultComboBoxModel();
        this.nounAgreeWithSlotModel.addElement("none");
        int j2 = 0;
        while (j2 < this.father.getBoxes().size()) {
            SPSlot s = this.father.getBoxes().get(j2).getSlot();
            if ((s instanceof SPOwnerSlot || s instanceof SPFillerSlot || s instanceof SPAdjectiveSlot || s instanceof SPNounSlot) && s.getOrder() != this.getSlot().getOrder()) {
                this.nounAgreeWithSlotModel.addElement(s.getOrder());
            }
            ++j2;
        }
        JLabel nounAgreeWithLabel = new JLabel("Agree with slot ");
        this.nounAgreeWithCombo = new JComboBox<Object>(this.nounAgreeWithSlotModel);
        nounCardSub5.add(nounAgreeWithLabel);
        nounCardSub5.add(this.nounAgreeWithCombo);
        nounCard.add(nounCardSub5);
        nounLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        if (this.language.equals("el")) {
            this.nounCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        }
        this.nounNumLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        nounAgreeWithLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.nounLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        if (this.language.equals("el")) {
            this.nounCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        }
        this.nounNumCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.nounAgreeWithCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.verbLELabel = new JLabel("Lexicon Entry");
        HashSet<ListIRI> verbLexiconEntries = new HashSet<ListIRI>();
        for (IRI iri : SentencePlanTab.LQM.getVerbEntries()) {
            verbLexiconEntries.add(new ListIRI(iri));
        }
        sortedList = new ArrayList(verbLexiconEntries);
        Collections.sort(sortedList);
        this.verbLECombo = new JComboBox<Object>(sortedList.toArray());
        this.verbLECombo.setRenderer(new ListRenderer());
        verbSlotCardSub1.add(this.verbLELabel);
        verbSlotCardSub1.add(this.verbLECombo);
        verbSlotCard.add(verbSlotCardSub1);
        if (this.language.equals("en")) {
            this.tenseLabel = new JLabel("Tense/Aspect");
            tenses = new String[]{"simple present", "present continuous", "present perfect", "simple past", "past continuous", "past perfect continuous", "simple future", "future continuous", "future perfect", "future perfect continuous", "participle"};
            this.verbTenseCombo = new JComboBox<String>(tenses);
        } else if (this.language.equals("el")) {
            this.tenseLabel = new JLabel("Tense/Aspect");
            tenses = new String[]{"simple present", "present perfect", "simple past", "past continuous", "past perfect", "simple future", "future continuous", "future perfect", "participle"};
            this.verbTenseCombo = new JComboBox<String>(tenses);
        }
        verbSlotCardSub2.add(this.tenseLabel);
        verbSlotCardSub2.add(this.verbTenseCombo);
        verbSlotCard.add(verbSlotCardSub2);
        this.polarityLabel = new JLabel("Polarity");
        String[] polarities = new String[]{SPVerbSlot.POLARITY_POSITIVE, SPVerbSlot.POLARITY_NEGATIVE, SPVerbSlot.POLARITY_FILLER};
        this.polarityCombo = new JComboBox<String>(polarities);
        verbSlotCardSub3.add(this.polarityLabel);
        verbSlotCardSub3.add(this.polarityCombo);
        verbSlotCard.add(verbSlotCardSub3);
        this.voiceLabel = new JLabel("Voice");
        String[] voices = new String[]{"active", "passive"};
        this.verbVoiceCombo = new JComboBox<String>(voices);
        verbSlotCardSub4.add(this.voiceLabel);
        verbSlotCardSub4.add(this.verbVoiceCombo);
        verbSlotCard.add(verbSlotCardSub4);
        this.numberLabel = new JLabel("Number");
        this.verbNumCombo = new JComboBox<String>(numbers);
        verbSlotCardSub5.add(this.numberLabel);
        verbSlotCardSub5.add(this.verbNumCombo);
        verbSlotCard.add(verbSlotCardSub5);
        this.personLabel = new JLabel("Person");
        String[] persons = new String[]{"1st", "2nd", "3rd"};
        this.verbPerCombo = new JComboBox<String>(persons);
        verbSlotCardSub6.add(this.personLabel);
        verbSlotCardSub6.add(this.verbPerCombo);
        verbSlotCard.add(verbSlotCardSub6);
        this.verbAgreeWithSlotModel = new DefaultComboBoxModel();
        this.verbAgreeWithSlotModel.addElement("none");
        int j3 = 0;
        while (j3 < this.father.getBoxes().size()) {
            SPSlot s = this.father.getBoxes().get(j3).getSlot();
            if (s instanceof SPOwnerSlot || s instanceof SPFillerSlot || s instanceof SPNounSlot) {
                this.verbAgreeWithSlotModel.addElement(s.getOrder());
            }
            ++j3;
        }
        JLabel agreeWithLabel = new JLabel("Agree with slot ");
        this.verbAgreeWithCombo = new JComboBox<Object>(this.verbAgreeWithSlotModel);
        verbSlotCardSub7.add(agreeWithLabel);
        verbSlotCardSub7.add(this.verbAgreeWithCombo);
        verbSlotCard.add(verbSlotCardSub7);
        this.verbLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.tenseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.polarityLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.voiceLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.numberLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.personLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        agreeWithLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.verbLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.verbTenseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.polarityCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.verbVoiceCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.verbNumCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.verbPerCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.verbAgreeWithCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.prepLELabel = new JLabel(prepositionSlotStr);
        String[] preps = new String[]{};
        if (this.language.equals("en")) {
            preps = SPPrepositionSlot.getEnglishPrepositionList().toArray(preps);
        } else if (this.language.equals("el")) {
            preps = SPPrepositionSlot.getGreekPrepositionList().toArray(preps);
        }
        this.prepLECombo = new JComboBox<String>(preps);
        prepositionCardSub1.add(this.prepLELabel);
        prepositionCardSub1.add(this.prepLECombo);
        prepositionCard.add(prepositionCardSub1);
        this.prepLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.prepLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        JLabel stringLabel = new JLabel(stringSlotStr);
        this.stringTextArea = new JTextArea(8, 8);
        this.stringTextArea.setLineWrap(true);
        this.stringTextArea.getDocument().putProperty("name", "stringText");
        JScrollPane scroll = new JScrollPane(this.stringTextArea);
        stringCardSub1.add("North", stringLabel);
        stringCardSub1.add("Center", scroll);
        stringCard.add(stringCardSub1);
        this.concatLabel = new JLabel("Add filler properties to concatenate");
        HashSet<ListIRI> propertyEntries = new HashSet<ListIRI>();
        for (OWLOntology owl : this.father.getOWLModelManager().getActiveOntologies()) {
            for (OWLObjectProperty prop : owl.getObjectPropertiesInSignature()) {
                if (prop.getIRI().getStart().equals(NLResourceManager.nlowlNS)) continue;
                propertyEntries.add(new ListIRI(prop.getIRI()));
            }
            for (OWLObjectProperty prop : owl.getDataPropertiesInSignature()) {
                if (prop.getIRI().getStart().equals(NLResourceManager.nlowlNS)) continue;
                propertyEntries.add(new ListIRI(prop.getIRI()));
            }
        }
        ArrayList sortList = new ArrayList(propertyEntries);
        Collections.sort(sortList);
        this.concatComboModel = new DefaultComboBoxModel<Object>(sortList.toArray());
        this.concatCombo = new JComboBox(this.concatComboModel);
        this.concatCombo.setRenderer(new ListRenderer());
        this.concatAdd = new JButton("+");
        concatenationCardSub1.add(this.concatLabel);
        concatenationCardSub1.add(this.concatCombo);
        concatenationCardSub1.add(this.concatAdd);
        concatenationCardSub1.setPreferredSize(new Dimension(190, 50));
        concatenationCard.add("North", concatenationCardSub1);
        this.concatListLabel = new JLabel("Filler properties to concatenate");
        this.concatListModel = new DefaultListModel();
        this.concatList = new JList(this.concatListModel);
        this.concatList.setCellRenderer(new ListRenderer());
        this.concatList.setVisibleRowCount(10);
        JScrollPane concatListPane = new JScrollPane(this.concatList);
        concatListPane.setPreferredSize(new Dimension(190, 140));
        concatenationCardSub2.add(this.concatListLabel);
        concatenationCardSub2.add(concatListPane);
        concatenationCard.add("Center", concatenationCardSub2);
        this.concatMinus = new JButton("-");
        this.concatUp = new JButton("UP");
        this.concatDown = new JButton("DOWN");
        concatenationCardSub3.add(this.concatMinus);
        concatenationCardSub3.add(this.concatUp);
        concatenationCardSub3.add(this.concatDown);
        concatenationCard.add("South", concatenationCardSub3);
        this.dynamicPanel.add((Component)ownerCard, ownerSlotStr);
        this.dynamicPanel.add((Component)fillerCard, fillerSlotStr);
        this.dynamicPanel.add((Component)adjectiveCard, adjectiveSlotStr);
        this.dynamicPanel.add((Component)nounCard, nounSlotStr);
        this.dynamicPanel.add((Component)verbSlotCard, verbSlotStr);
        this.dynamicPanel.add((Component)prepositionCard, prepositionSlotStr);
        this.dynamicPanel.add((Component)stringCard, stringSlotStr);
        this.dynamicPanel.add((Component)concatenationCard, concatenationSlotStr);
    }

    void loadSlotInBox(SPSlot slot) {
        this.select.removeItemListener(this);
        this.removeListenersOfLastOpenSlotTab();
        CardLayout cl = (CardLayout)this.dynamicPanel.getLayout();
        if (slot instanceof SPOwnerSlot) {
            this.lastOpenSlotTab = ownerSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) != -1) continue;
                    mdl.addElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(ownerSlotStr);
            this.exprCombo.setSelectedItem(((SPOwnerSlot)slot).getRefType());
            this.exprCombo.addItemListener(this);
            this.ownCaseCombo.setSelectedItem(((SPOwnerSlot)slot).getCase());
            this.ownCaseCombo.addItemListener(this);
        } else if (slot instanceof SPFillerSlot) {
            this.lastOpenSlotTab = fillerSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) != -1) continue;
                    mdl.addElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(fillerSlotStr);
            this.indCaseCombo.setSelectedItem(((SPFillerSlot)slot).getCase());
            this.indCaseCombo.addItemListener(this);
            if (((SPFillerSlot)slot).getBullets()) {
                this.bulletsCheck.setSelected(true);
            } else {
                this.bulletsCheck.setSelected(false);
            }
            this.bulletsCheck.addItemListener(this);
        } else if (slot instanceof SPAdjectiveSlot) {
            this.lastOpenSlotTab = adjectiveSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) != -1 || this.father.getBoxes().get(j).getSlot().getOrder() == slot.getOrder()) continue;
                    mdl.addElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(adjectiveSlotStr);
            if (((SPAdjectiveSlot)slot).getLexiconEntryIRI() != null) {
                this.adjLECombo.setSelectedItem(new ListIRI(((SPAdjectiveSlot)slot).getLexiconEntryIRI()));
            } else if (this.adjLECombo.getSelectedItem() != null) {
                ((SPAdjectiveSlot)slot).setLexiconEntryIRI(((ListIRI)this.adjLECombo.getSelectedItem()).getEntryIRI());
            }
            this.adjLECombo.addItemListener(this);
            this.adjLECombo.addFocusListener(this);
            if (this.language.equals("el")) {
                this.adjCaseLabel.setText("Case");
                this.adjGenderLabel.setText("Gender");
            }
            this.adjNumLabel.setText("Number");
            if (((SPAdjectiveSlot)slot).getAgreesWithID() == null) {
                if (this.language.equals("el")) {
                    this.adjCaseCombo.setEnabled(true);
                    this.adjCaseCombo.setSelectedItem(((SPAdjectiveSlot)slot).getCase());
                    this.adjCaseCombo.addItemListener(this);
                    this.adjGenderCombo.setEnabled(true);
                    this.adjGenderCombo.setSelectedItem(((SPAdjectiveSlot)slot).getGender());
                    this.adjGenderCombo.addItemListener(this);
                }
                this.adjNumCombo.setEnabled(true);
                this.adjNumCombo.setSelectedItem(((SPAdjectiveSlot)slot).getNumber());
                this.adjNumCombo.addItemListener(this);
            } else {
                String agreeID = ((SPAdjectiveSlot)slot).getAgreesWithID().toString();
                int agreeSlot = -1;
                int i = 0;
                while (i < this.father.getSlots().size()) {
                    if (this.father.getSlots().get(i).getId().toString().equals(agreeID)) {
                        agreeSlot = i + 1;
                    }
                    ++i;
                }
                if (agreeSlot != -1) {
                    if (this.adjAgreeWithSlotModel.getIndexOf(agreeSlot) == -1) {
                        this.adjAgreeWithSlotModel.addElement(agreeSlot);
                    }
                    this.adjAgreeWithCombo.setSelectedItem(agreeSlot);
                    if (this.language.equals("el")) {
                        this.adjCaseCombo.setEnabled(false);
                        this.adjCaseCombo.setSelectedItem(null);
                        this.adjCaseCombo.removeItemListener(this);
                        this.adjGenderCombo.setEnabled(false);
                        this.adjGenderCombo.setSelectedItem(null);
                        this.adjGenderCombo.removeItemListener(this);
                    }
                    this.adjNumCombo.setEnabled(false);
                    this.adjNumCombo.setSelectedItem(null);
                    this.adjNumCombo.removeItemListener(this);
                } else {
                    System.err.println("Cannot find slot " + agreeID);
                    if (this.language.equals("el")) {
                        this.adjCaseCombo.setEnabled(true);
                        this.adjCaseCombo.setSelectedItem(((SPAdjectiveSlot)slot).getCase());
                        this.adjCaseCombo.addItemListener(this);
                        this.adjGenderCombo.setEnabled(true);
                        this.adjGenderCombo.setSelectedItem(((SPAdjectiveSlot)slot).getGender());
                        this.adjGenderCombo.addItemListener(this);
                    }
                    this.adjNumCombo.setEnabled(true);
                    this.adjNumCombo.setSelectedItem(((SPAdjectiveSlot)slot).getNumber());
                    this.adjNumCombo.addItemListener(this);
                }
            }
            this.adjAgreeWithCombo.addFocusListener(this);
            this.adjAgreeWithCombo.addItemListener(this);
        } else if (slot instanceof SPNounSlot) {
            this.lastOpenSlotTab = nounSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) != -1 || this.father.getBoxes().get(j).getSlot().getOrder() == slot.getOrder()) continue;
                    mdl.addElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(nounSlotStr);
            if (((SPNounSlot)slot).getLexiconEntryIRI() != null) {
                this.nounLECombo.setSelectedItem(new ListIRI(((SPNounSlot)slot).getLexiconEntryIRI()));
            } else if (this.nounLECombo.getSelectedItem() != null) {
                ((SPNounSlot)slot).setLexiconEntryIRI(((ListIRI)this.nounLECombo.getSelectedItem()).getEntryIRI());
            }
            this.nounLECombo.addItemListener(this);
            this.nounLECombo.addFocusListener(this);
            if (this.language.equals("el")) {
                this.nounCaseLabel.setText("Case");
            }
            this.nounNumLabel.setText("Number");
            if (((SPNounSlot)slot).getAgreesWithID() == null) {
                if (this.language.equals("el")) {
                    this.nounCaseCombo.setEnabled(true);
                    this.nounCaseCombo.setSelectedItem(((SPNounSlot)slot).getCase());
                    this.nounCaseCombo.addItemListener(this);
                }
                this.nounNumCombo.setEnabled(true);
                this.nounNumCombo.setSelectedItem(((SPNounSlot)slot).getNumber());
                if (((SPNounSlot)slot).getLexiconEntryIRI() != null) {
                    LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((SPNounSlot)slot).getLexiconEntryIRI(), this.language);
                    if (entry.getNumber().equals("singular")) {
                        this.nounNumCombo.setSelectedItem("singular");
                        this.nounNumCombo.setEnabled(false);
                        if (!((SPNounSlot)slot).getNumber().equals("singular")) {
                            ((SPNounSlot)slot).setNumber("singular");
                        }
                    } else if (entry.getNumber().equals("plural")) {
                        this.nounNumCombo.setSelectedItem("plural");
                        this.nounNumCombo.setEnabled(false);
                        if (!((SPNounSlot)slot).getNumber().equals("plural")) {
                            ((SPNounSlot)slot).setNumber("plural");
                        }
                    }
                }
                this.nounNumCombo.addItemListener(this);
            } else {
                String agreeID = ((SPNounSlot)slot).getAgreesWithID().toString();
                int agreeSlot = -1;
                int i = 0;
                while (i < this.father.getSlots().size()) {
                    if (this.father.getSlots().get(i).getId().toString().equals(agreeID)) {
                        agreeSlot = i + 1;
                    }
                    ++i;
                }
                if (agreeSlot != -1) {
                    if (this.nounAgreeWithSlotModel.getIndexOf(agreeSlot) == -1) {
                        System.err.println("Slot " + agreeID + " is neither an adjective nor a noun.");
                        this.nounAgreeWithSlotModel.addElement(agreeSlot);
                    }
                    this.nounAgreeWithCombo.setSelectedItem(agreeSlot);
                    if (this.language.equals("el")) {
                        this.nounCaseCombo.setEnabled(false);
                        this.nounCaseCombo.setSelectedItem(null);
                        this.nounCaseCombo.removeItemListener(this);
                    }
                    this.nounNumCombo.setEnabled(false);
                    this.nounNumCombo.setSelectedItem(null);
                    LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((SPNounSlot)slot).getLexiconEntryIRI(), this.language);
                    if (entry.getNumber().equals("singular")) {
                        this.nounNumCombo.setSelectedItem("singular");
                        this.nounNumCombo.setEnabled(false);
                        if (!((SPNounSlot)slot).getNumber().equals("singular")) {
                            ((SPNounSlot)slot).setNumber("singular");
                        }
                    } else if (entry.getNumber().equals("plural")) {
                        this.nounNumCombo.setSelectedItem("plural");
                        this.nounNumCombo.setEnabled(false);
                        if (!((SPNounSlot)slot).getNumber().equals("plural")) {
                            ((SPNounSlot)slot).setNumber("plural");
                        }
                    }
                    this.nounNumCombo.removeItemListener(this);
                } else {
                    System.err.println("Cannot find slot " + agreeID);
                    if (this.language.equals("el")) {
                        this.nounCaseCombo.setEnabled(true);
                        this.nounCaseCombo.setSelectedItem(((SPNounSlot)slot).getCase());
                        this.nounCaseCombo.addItemListener(this);
                    }
                    this.nounNumCombo.setEnabled(true);
                    this.nounNumCombo.setSelectedItem(((SPNounSlot)slot).getNumber());
                    if (((SPNounSlot)slot).getLexiconEntryIRI() != null) {
                        LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((SPNounSlot)slot).getLexiconEntryIRI(), this.language);
                        if (entry.getNumber().equals("singular")) {
                            this.nounNumCombo.setSelectedItem("singular");
                            this.nounNumCombo.setEnabled(false);
                            if (!((SPNounSlot)slot).getNumber().equals("singular")) {
                                ((SPNounSlot)slot).setNumber("singular");
                            }
                        } else if (entry.getNumber().equals("plural")) {
                            this.nounNumCombo.setSelectedItem("plural");
                            this.nounNumCombo.setEnabled(false);
                            if (!((SPNounSlot)slot).getNumber().equals("plural")) {
                                ((SPNounSlot)slot).setNumber("plural");
                            }
                        }
                    }
                }
            }
            this.nounAgreeWithCombo.addFocusListener(this);
            this.nounAgreeWithCombo.addItemListener(this);
        } else if (slot instanceof SPVerbSlot) {
            this.lastOpenSlotTab = verbSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(verbSlotStr);
            if (((SPVerbSlot)slot).getLexiconEntryIRI() != null) {
                this.verbLECombo.setSelectedItem(new ListIRI(((SPVerbSlot)slot).getLexiconEntryIRI()));
            } else {
                ((SPVerbSlot)slot).setLexiconEntryIRI(((ListIRI)this.verbLECombo.getSelectedItem()).getEntryIRI());
            }
            this.verbLECombo.addItemListener(this);
            this.verbLECombo.addFocusListener(this);
            this.verbTenseCombo.setSelectedItem(((SPVerbSlot)slot).getTense());
            this.verbTenseCombo.addItemListener(this);
            this.polarityCombo.setSelectedItem(((SPVerbSlot)slot).getPolarity());
            this.polarityCombo.addItemListener(this);
            this.verbVoiceCombo.setSelectedItem(((SPVerbSlot)slot).getVoice());
            this.verbVoiceCombo.addItemListener(this);
            if (((SPVerbSlot)slot).getAgreesWithID() == null) {
                this.verbNumCombo.setEnabled(true);
                this.verbNumCombo.setSelectedItem(((SPVerbSlot)slot).getNumber());
                this.verbNumCombo.addItemListener(this);
                this.verbPerCombo.setEnabled(true);
                this.verbPerCombo.setSelectedItem(((SPVerbSlot)slot).getPerson());
                this.verbPerCombo.addItemListener(this);
            } else {
                String agreeID = ((SPVerbSlot)slot).getAgreesWithID().toString();
                int agreeSlot = -1;
                int i = 0;
                while (i < this.father.getSlots().size()) {
                    if (this.father.getSlots().get(i).getId().toString().equals(agreeID)) {
                        agreeSlot = i + 1;
                    }
                    ++i;
                }
                if (agreeSlot != -1) {
                    if (this.verbAgreeWithSlotModel.getIndexOf(agreeSlot) == -1) {
                        System.err.println("Slot " + agreeID + " is neither an owner, a filler nor a noun.");
                        this.verbAgreeWithSlotModel.addElement(agreeSlot);
                    }
                    this.verbAgreeWithCombo.setSelectedItem(agreeSlot);
                    this.verbNumCombo.setEnabled(false);
                    this.verbNumCombo.setSelectedItem(null);
                    this.verbNumCombo.removeItemListener(this);
                    this.verbPerCombo.setEnabled(false);
                    this.verbPerCombo.setSelectedItem(null);
                    this.verbPerCombo.removeItemListener(this);
                } else {
                    System.err.println("Cannot find slot " + agreeID);
                    this.verbNumCombo.setEnabled(true);
                    this.verbNumCombo.setSelectedItem(((SPVerbSlot)slot).getNumber());
                    this.verbNumCombo.addItemListener(this);
                    this.verbPerCombo.setEnabled(true);
                    this.verbPerCombo.setSelectedItem(((SPVerbSlot)slot).getPerson());
                    this.verbPerCombo.addItemListener(this);
                }
            }
            this.verbAgreeWithCombo.addFocusListener(this);
            this.verbAgreeWithCombo.addItemListener(this);
        } else if (slot instanceof SPPrepositionSlot) {
            this.lastOpenSlotTab = prepositionSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(prepositionSlotStr);
            this.prepLECombo.setSelectedItem(((SPPrepositionSlot)slot).getPrep());
            this.prepLECombo.addItemListener(this);
        } else if (slot instanceof SPStringSlot) {
            this.lastOpenSlotTab = stringSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(stringSlotStr);
            this.stringTextArea.setText(((SPStringSlot)slot).getText());
            this.stringTextArea.getDocument().addDocumentListener(this);
        } else if (slot instanceof SPConcatenationSlot) {
            this.lastOpenSlotTab = concatenationSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(concatenationSlotStr);
            ArrayList<SPConcatenationPropertySlot> propertySlots = ((SPConcatenationSlot)slot).getPropertySlots();
            Collections.sort(propertySlots);
            for (SPConcatenationPropertySlot propSlot : propertySlots) {
                this.concatListModel.addElement(new ListIRI(propSlot.getPropertyIRI()));
            }
            this.concatMinus.setEnabled(false);
            this.concatUp.setEnabled(false);
            this.concatDown.setEnabled(false);
            this.concatList.addListSelectionListener(this);
            this.concatCombo.addFocusListener(this);
            this.concatAdd.addActionListener(this);
            this.concatMinus.addActionListener(this);
            this.concatUp.addActionListener(this);
            this.concatDown.addActionListener(this);
        }
        cl.show(this.dynamicPanel, this.lastOpenSlotTab);
        this.dynamicPanel.validate();
        this.select.addItemListener(this);
    }

    public void removeListenersOfLastOpenSlotTab() {
        if (this.lastOpenSlotTab == ownerSlotStr) {
            this.exprCombo.removeItemListener(this);
            this.ownCaseCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == fillerSlotStr) {
            this.indCaseCombo.removeItemListener(this);
            this.bulletsCheck.removeItemListener(this);
        } else if (this.lastOpenSlotTab == adjectiveSlotStr) {
            this.adjLECombo.removeItemListener(this);
            this.adjLECombo.removeFocusListener(this);
            if (this.language.equals("el")) {
                this.adjCaseCombo.removeItemListener(this);
                this.adjGenderCombo.removeItemListener(this);
            }
            this.adjNumCombo.removeItemListener(this);
            this.adjAgreeWithCombo.removeFocusListener(this);
            this.adjAgreeWithCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == nounSlotStr) {
            this.nounLECombo.removeItemListener(this);
            this.nounLECombo.removeFocusListener(this);
            if (this.language.equals("el")) {
                this.nounCaseCombo.removeItemListener(this);
            }
            this.nounNumCombo.removeItemListener(this);
            this.nounAgreeWithCombo.removeFocusListener(this);
            this.nounAgreeWithCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == verbSlotStr) {
            this.verbLECombo.removeItemListener(this);
            this.verbLECombo.removeFocusListener(this);
            this.verbTenseCombo.removeItemListener(this);
            this.polarityCombo.removeItemListener(this);
            this.verbVoiceCombo.removeItemListener(this);
            this.verbNumCombo.removeItemListener(this);
            this.verbPerCombo.removeItemListener(this);
            this.verbAgreeWithCombo.removeFocusListener(this);
            this.verbAgreeWithCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == prepositionSlotStr) {
            this.prepLECombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == stringSlotStr) {
            this.stringTextArea.getDocument().removeDocumentListener(this);
        } else if (this.lastOpenSlotTab == concatenationSlotStr) {
            this.concatCombo.removeFocusListener(this);
            this.concatAdd.removeActionListener(this);
            this.concatMinus.removeActionListener(this);
            this.concatUp.removeActionListener(this);
            this.concatDown.removeActionListener(this);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.concatCombo) {
            Object selected = this.concatCombo.getSelectedItem();
            HashSet<ListIRI> propertyEntries = new HashSet<ListIRI>();
            for (OWLOntology owl : this.father.getOWLModelManager().getOntologies()) {
                for (OWLObjectProperty prop : owl.getObjectPropertiesInSignature()) {
                    if (prop.getIRI().getStart().equals(NLResourceManager.nlowlNS)) continue;
                    propertyEntries.add(new ListIRI(prop.getIRI()));
                }
                for (OWLObjectProperty prop : owl.getDataPropertiesInSignature()) {
                    if (prop.getIRI().getStart().equals(NLResourceManager.nlowlNS)) continue;
                    propertyEntries.add(new ListIRI(prop.getIRI()));
                }
            }
            if (!this.areIdentical((DefaultComboBoxModel)this.concatCombo.getModel(), propertyEntries)) {
                ArrayList sortList = new ArrayList(propertyEntries);
                Collections.sort(sortList);
                this.concatComboModel = new DefaultComboBoxModel<Object>(sortList.toArray());
                this.concatCombo.setModel(this.concatComboModel);
                if (this.concatComboModel.getIndexOf(selected) != -1) {
                    this.concatCombo.setSelectedItem(selected);
                }
            }
        } else if (e.getSource() == this.adjLECombo) {
            Object selected = this.adjLECombo.getSelectedItem();
            HashSet<ListIRI> adjLexiconEntries = new HashSet<ListIRI>();
            for (IRI iri : SentencePlanTab.LQM.getAdjectiveEntries()) {
                adjLexiconEntries.add(new ListIRI(iri));
            }
            if (!this.areIdentical((DefaultComboBoxModel)this.adjLECombo.getModel(), adjLexiconEntries)) {
                ArrayList sortedList = new ArrayList(adjLexiconEntries);
                Collections.sort(sortedList);
                DefaultComboBoxModel<Object> adjComboModel = new DefaultComboBoxModel<Object>(sortedList.toArray());
                this.adjLECombo.setModel(adjComboModel);
                if (adjComboModel.getIndexOf(selected) != -1) {
                    this.adjLECombo.setSelectedItem(selected);
                }
            }
        } else if (e.getSource() == this.nounLECombo) {
            Object selected = this.nounLECombo.getSelectedItem();
            HashSet<ListIRI> nounLexiconEntries = new HashSet<ListIRI>();
            for (IRI iri : SentencePlanTab.LQM.getNounEntries()) {
                nounLexiconEntries.add(new ListIRI(iri));
            }
            if (!this.areIdentical((DefaultComboBoxModel)this.nounLECombo.getModel(), nounLexiconEntries)) {
                ArrayList sortedList = new ArrayList(nounLexiconEntries);
                Collections.sort(sortedList);
                DefaultComboBoxModel<Object> nounComboModel = new DefaultComboBoxModel<Object>(sortedList.toArray());
                this.nounLECombo.setModel(nounComboModel);
                if (nounComboModel.getIndexOf(selected) != -1) {
                    this.nounLECombo.setSelectedItem(selected);
                }
            }
        } else if (e.getSource() == this.verbLECombo) {
            Object selected = this.verbLECombo.getSelectedItem();
            HashSet<ListIRI> verbLexiconEntries = new HashSet<ListIRI>();
            for (IRI iri : SentencePlanTab.LQM.getVerbEntries()) {
                verbLexiconEntries.add(new ListIRI(iri));
            }
            if (!this.areIdentical((DefaultComboBoxModel)this.verbLECombo.getModel(), verbLexiconEntries)) {
                ArrayList sortedList = new ArrayList(verbLexiconEntries);
                Collections.sort(sortedList);
                DefaultComboBoxModel<Object> verbComboModel = new DefaultComboBoxModel<Object>(sortedList.toArray());
                this.verbLECombo.setModel(verbComboModel);
                if (verbComboModel.getIndexOf(selected) != -1) {
                    this.verbLECombo.setSelectedItem(selected);
                }
            }
        } else if (e.getSource() == this.adjAgreeWithCombo) {
            Object selected = this.adjAgreeWithCombo.getSelectedItem();
            DefaultComboBoxModel<Object> tempModel = this.adjAgreeWithSlotModel;
            tempModel.removeElement(this.getSlot().getOrder());
            this.adjAgreeWithCombo.setModel(tempModel);
            if (tempModel.getIndexOf(selected) != -1) {
                this.adjAgreeWithCombo.setSelectedItem(selected);
            }
        } else if (e.getSource() == this.nounAgreeWithCombo) {
            Object selected = this.nounAgreeWithCombo.getSelectedItem();
            DefaultComboBoxModel<Object> tempModel = this.nounAgreeWithSlotModel;
            tempModel.removeElement(this.getSlot().getOrder());
            this.nounAgreeWithCombo.setModel(tempModel);
            if (tempModel.getIndexOf(selected) != -1) {
                this.nounAgreeWithCombo.setSelectedItem(selected);
            }
        } else if (e.getSource() == this.verbAgreeWithCombo) {
            Object selected = this.verbAgreeWithCombo.getSelectedItem();
            this.verbAgreeWithCombo.setModel(this.verbAgreeWithSlotModel);
            if (this.verbAgreeWithSlotModel.getIndexOf(selected) != -1) {
                this.verbAgreeWithCombo.setSelectedItem(selected);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.concatAdd) {
            SPConcatenationPropertySlot prSlot = new SPConcatenationPropertySlot(((ListIRI)this.concatCombo.getSelectedItem()).getEntryIRI(), "nominative", SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "conslot" + this.slot.getOrder() + "_" + (((SPConcatenationSlot)this.slot).getPropertySlots().size() + 1)).getID(), ((SPConcatenationSlot)this.slot).getPropertySlots().size() + 1);
            ((SPConcatenationSlot)this.slot).concatenateProperty(prSlot);
            this.concatListModel.addElement((ListIRI)this.concatCombo.getSelectedItem());
            this.father.dirtenOntologies();
        } else if (e.getSource() == this.concatMinus) {
            ((SPConcatenationSlot)this.slot).removeProperty(this.concatList.getSelectedIndex());
            int i = this.concatList.getSelectedIndex();
            while (i < ((SPConcatenationSlot)this.slot).getPropertySlots().size()) {
                SPConcatenationPropertySlot concat = ((SPConcatenationSlot)this.slot).getPropertySlots().get(i);
                concat.setOrder(concat.getOrder() - 1);
                concat.setId(SentencePlanTab.SPQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedPlan().getSentencePlanIRI().getFragment()) + "_" + "conslot" + this.slot.getOrder() + "_" + concat.getOrder()).getID());
                ++i;
            }
            this.concatListModel.removeElementAt(this.concatList.getSelectedIndex());
            this.father.dirtenOntologies();
        } else if (e.getSource() == this.concatUp) {
            int index = this.concatList.getSelectedIndex();
            if (index != 0) {
                ListIRI moveUp = (ListIRI)this.concatListModel.get(index);
                ListIRI moveDown = (ListIRI)this.concatListModel.get(index - 1);
                this.concatListModel.setElementAt(moveUp, index - 1);
                this.concatListModel.setElementAt(moveDown, index);
                ((SPConcatenationSlot)this.slot).swapPropertyOrder(((SPConcatenationSlot)this.slot).getPropertySlots().get(index - 1), ((SPConcatenationSlot)this.slot).getPropertySlots().get(index));
            }
            this.concatList.setSelectedIndex(index - 1);
            this.father.dirtenOntologies();
        } else if (e.getSource() == this.concatDown) {
            int index = this.concatList.getSelectedIndex();
            if (index != this.concatListModel.getSize() - 1) {
                ListIRI moveDown = (ListIRI)this.concatListModel.get(index);
                ListIRI moveUp = (ListIRI)this.concatListModel.get(index + 1);
                this.concatListModel.setElementAt(moveUp, index);
                this.concatListModel.setElementAt(moveDown, index + 1);
                ((SPConcatenationSlot)this.slot).swapPropertyOrder(((SPConcatenationSlot)this.slot).getPropertySlots().get(index), ((SPConcatenationSlot)this.slot).getPropertySlots().get(index + 1));
            }
            this.concatList.setSelectedIndex(index + 1);
            this.father.dirtenOntologies();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.concatList) {
            int index = this.concatList.getSelectedIndex();
            if (index == -1) {
                this.concatMinus.setEnabled(false);
                this.concatUp.setEnabled(false);
                this.concatDown.setEnabled(false);
            } else if (index == 0) {
                this.concatMinus.setEnabled(true);
                this.concatUp.setEnabled(false);
                this.concatDown.setEnabled(true);
            } else if (index == this.concatListModel.getSize() - 1) {
                this.concatMinus.setEnabled(true);
                this.concatUp.setEnabled(true);
                this.concatDown.setEnabled(false);
            } else {
                this.concatMinus.setEnabled(true);
                this.concatUp.setEnabled(true);
                this.concatDown.setEnabled(true);
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    public void updateOrderLabel() {
        this.orderLabel.setText("Slot order: " + this.slot.getOrder());
    }

    public void updateEntry(DocumentEvent event) {
        String name = (String)event.getDocument().getProperty("name");
        if (name.equals("stringText")) {
            ((SPStringSlot)this.slot).setText(this.stringTextArea.getText());
            this.father.dirtenOntologies();
        }
    }

    public SPSlot getSlot() {
        return this.slot;
    }

    public ArrayList<DefaultComboBoxModel> getAgreeWithSlotModels() {
        ArrayList<DefaultComboBoxModel> agreeModels = new ArrayList<DefaultComboBoxModel>();
        agreeModels.add(this.verbAgreeWithSlotModel);
        agreeModels.add(this.adjAgreeWithSlotModel);
        agreeModels.add(this.nounAgreeWithSlotModel);
        return agreeModels;
    }

    private boolean agreeCycleExists(HashSet<SPSlot> slots, int agreeWithOrder) {
        int j = 0;
        while (j < this.father.getBoxes().size()) {
            SPSlot agreeSlot = this.father.getBoxes().get(j).getSlot();
            if (agreeSlot.getOrder() == agreeWithOrder) {
                if (agreeSlot instanceof SPOwnerSlot || agreeSlot instanceof SPFillerSlot) {
                    return false;
                }
                if (agreeSlot instanceof SPAdjectiveSlot) {
                    if (slots.contains(agreeSlot)) {
                        return true;
                    }
                    if (((SPAdjectiveSlot)agreeSlot).getAgreesWithID() == null) {
                        return false;
                    }
                    slots.add(agreeSlot);
                    agreeWithOrder = Integer.parseInt(((SPAdjectiveSlot)agreeSlot).getAgreesWithID().toString().substring(((SPAdjectiveSlot)agreeSlot).getAgreesWithID().toString().indexOf("slot") + "slot".length()));
                    return this.agreeCycleExists(slots, agreeWithOrder);
                }
                if (agreeSlot instanceof SPNounSlot) {
                    if (slots.contains(agreeSlot)) {
                        return true;
                    }
                    if (((SPNounSlot)agreeSlot).getAgreesWithID() == null) {
                        return false;
                    }
                    slots.add(agreeSlot);
                    agreeWithOrder = Integer.parseInt(((SPNounSlot)agreeSlot).getAgreesWithID().toString().substring(((SPNounSlot)agreeSlot).getAgreesWithID().toString().indexOf("slot") + "slot".length()));
                    return this.agreeCycleExists(slots, agreeWithOrder);
                }
            }
            ++j;
        }
        return false;
    }

    public boolean areIdentical(DefaultComboBoxModel a, HashSet b) {
        if (a.getSize() == b.size()) {
            HashSet checkSet = new HashSet(b);
            int i = 0;
            while (i < a.getSize()) {
                checkSet.add(a.getElementAt(i));
                ++i;
            }
            return checkSet.size() == b.size();
        }
        return false;
    }
}

