/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.MyJPanel;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.OrderPanel;
import gr.aueb.cs.nlg.NLOwlPlugin.OrderingTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.semanticweb.owlapi.model.IRI;

class SectionPanel {
    static boolean first = true;
    private OrderingTab father;
    private boolean firstInProp = true;
    private MyJPanel sectionPanel = new MyJPanel(430, 0);
    private MyJPanel buttonsPanel = new MyJPanel();
    private MyJPanel labelPanelEN = new MyJPanel();
    private MyJPanel labelPanelGR = new MyJPanel();
    private MyJPanel orderPanel;
    private ArrayList<OrderPanel> orderPanels = new ArrayList();
    private int sectionOrder;
    private String sectionLabelEN;
    private String sectionLabelGR;
    private JTextField sectionOrderTextField;
    private JTextField sectionLabelENTextField;
    private JTextField sectionLabelGRTextField;
    private JTextField sectionNameTextField;
    private JButton buttonNew;
    private JButton up;
    private JButton down;
    private ListIRI sectionIRI;

    SectionPanel(OrderingTab f) {
        this.father = f;
    }

    void createSectionTitle(ListIRI n) {
        this.sectionNameTextField = new JTextField(23);
        this.sectionNameTextField.setText(n.toString());
        this.sectionNameTextField.setToolTipText(n.getEntryIRI().toString());
        this.sectionNameTextField.setEditable(false);
        this.sectionNameTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    SectionPanel.this.getThis().sectionNameTextField.setEditable(false);
                    IRI newSectionIRI = IRI.create((String)(String.valueOf(SectionPanel.this.sectionIRI.getEntryIRI().getStart()) + SectionPanel.this.getThis().sectionNameTextField.getText()));
                    if (!SectionPanel.this.getThis().sectionNameTextField.getText().equals("") && OrderingTab.isLegalIRI(newSectionIRI) && SectionPanel.this.father.isUniqueIRI(newSectionIRI)) {
                        NaturalOWLTab.OQM.renameSection(SectionPanel.this.sectionIRI.getEntryIRI(), newSectionIRI);
                        SectionPanel.this.father.updateSectionComboBoxes();
                        SectionPanel.this.sectionIRI = new ListIRI(newSectionIRI);
                        SectionPanel.this.father.dirtenOntologies();
                    } else {
                        SectionPanel.this.getThis().sectionNameTextField.setText(SectionPanel.this.sectionIRI.toString());
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent key) {
            }

            @Override
            public void keyTyped(KeyEvent key) {
            }
        });
        this.buttonsPanel.add((Component)this.sectionNameTextField, 1);
    }

    void createSectionLabelEN(String sectionLabel) {
        this.sectionLabelEN = sectionLabel;
        this.sectionLabelENTextField = new JTextField(35);
        this.sectionLabelENTextField.setText(sectionLabel);
        this.sectionLabelENTextField.setEditable(false);
        this.sectionLabelENTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    SectionPanel.this.getThis().sectionLabelENTextField.setEditable(false);
                    NaturalOWLTab.OQM.setSectionLabel(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), SectionPanel.this.sectionLabelENTextField.getText(), "en");
                    SectionPanel.this.father.dirtenOntologies();
                }
            }

            @Override
            public void keyReleased(KeyEvent key) {
            }

            @Override
            public void keyTyped(KeyEvent key) {
            }
        });
        this.labelPanelEN.add((Component)this.sectionLabelENTextField, 1);
    }

    void createSectionLabelGR(String sectionLabel) {
        this.sectionLabelGR = sectionLabel;
        this.sectionLabelGRTextField = new JTextField(35);
        this.sectionLabelGRTextField.setText(sectionLabel);
        this.sectionLabelGRTextField.setEditable(false);
        this.sectionLabelGRTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    SectionPanel.this.getThis().sectionLabelGRTextField.setEditable(false);
                    NaturalOWLTab.OQM.setSectionLabel(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), SectionPanel.this.sectionLabelGRTextField.getText(), "el");
                    SectionPanel.this.father.dirtenOntologies();
                }
            }

            @Override
            public void keyReleased(KeyEvent key) {
            }

            @Override
            public void keyTyped(KeyEvent key) {
            }
        });
        this.labelPanelGR.add((Component)this.sectionLabelGRTextField, 1);
    }

    void createSectionOrder(int n) {
        this.sectionOrder = n;
        this.sectionOrderTextField = new JTextField(3);
        this.sectionOrderTextField.setText(String.valueOf(this.sectionOrder));
        this.sectionOrderTextField.setEditable(false);
        this.sectionOrderTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    if (OrderingTab.isValidOrder(SectionPanel.this.getThis().sectionOrderTextField.getText())) {
                        SectionPanel.this.updateOrder(Integer.parseInt(SectionPanel.this.getThis().sectionOrderTextField.getText()));
                        SectionPanel.this.getThis().sectionOrderTextField.setEditable(false);
                        NaturalOWLTab.OQM.setSectionOrder(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), Integer.parseInt(SectionPanel.this.getThis().sectionOrderTextField.getText()));
                        SectionPanel.this.father.dirtenOntologies();
                    } else {
                        SectionPanel.this.getThis().sectionOrderTextField.setText(String.valueOf(SectionPanel.this.sectionOrder));
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent key) {
            }

            @Override
            public void keyTyped(KeyEvent key) {
            }
        });
        this.buttonsPanel.add((Component)this.sectionOrderTextField, 2);
    }

    void loadOrderPanels(ArrayList<ListIRI> list) {
        int size = list.size();
        OrderPanel[] propertyArray = new OrderPanel[size];
        int i = 0;
        while (i < propertyArray.length) {
            propertyArray[i] = new OrderPanel(this);
            this.addToOrderPanels(propertyArray[i]);
            ++i;
        }
        i = 0;
        while (i < propertyArray.length) {
            propertyArray[i].createOrderPanel(list.get(i), NaturalOWLTab.OQM.getPropertyOrder(list.get(i).getEntryIRI()));
            ++i;
        }
        this.sectionPanel.validate();
        this.sectionPanel.repaint();
    }

    void movePanel(int start, int finish) {
        if (start <= finish) {
            int i = start + 1;
            while (i <= finish) {
                OrderingTab.getSectionsPanel().switchPanelOrder(i);
                this.switchSectionPanels(i);
                SectionPanel upperSectionPanel = OrderingTab.getSections().get(i - 1);
                SectionPanel thisSectionPanel = OrderingTab.getSections().get(i);
                this.updateUpDownArrows(upperSectionPanel);
                this.updateUpDownArrows(thisSectionPanel);
                upperSectionPanel.buttonsPanel.repaint();
                thisSectionPanel.buttonsPanel.repaint();
                ++i;
            }
        } else {
            int i = start;
            while (i > finish + 1) {
                OrderingTab.getSectionsPanel().switchPanelOrder(i);
                this.switchSectionPanels(i);
                SectionPanel upperSectionPanel = OrderingTab.getSections().get(i - 1);
                SectionPanel thisSectionPanel = OrderingTab.getSections().get(i);
                this.updateUpDownArrows(upperSectionPanel);
                this.updateUpDownArrows(thisSectionPanel);
                upperSectionPanel.buttonsPanel.repaint();
                thisSectionPanel.buttonsPanel.repaint();
                --i;
            }
        }
        OrderingTab.getSectionsPanel().repaint();
    }

    void switchSectionPanels(int i) {
        SectionPanel a = OrderingTab.getSections().get(i - 1);
        SectionPanel b = OrderingTab.getSections().get(i);
        OrderingTab.removeFromSections(a);
        OrderingTab.removeFromSections(b);
        OrderingTab.addToSections(i - 1, b);
        OrderingTab.addToSections(i, a);
    }

    void updateOrder(int newOrder) {
        int position = OrderingTab.getPositionInSections(this.getThis());
        SectionPanel thisSectionPanel = OrderingTab.getSections().get(position);
        int thisOrder = thisSectionPanel.getSectionOrder();
        int i = 0;
        while (i < OrderingTab.getSections().size()) {
            SectionPanel checkOrderPanel = OrderingTab.getSections().get(i);
            int checkOrder = checkOrderPanel.getSectionOrder();
            if (checkOrder > newOrder) {
                thisSectionPanel.setSectionOrder(newOrder);
                this.movePanel(position, i - 1);
                return;
            }
            ++i;
        }
        thisSectionPanel.setSectionOrder(newOrder);
        this.movePanel(position, OrderingTab.getSections().size() - 1);
    }

    void updateUpDownArrows(SectionPanel sectionPanel) {
        int position;
        Image newimg;
        Image img;
        URL imageURL;
        ClassLoader loader;
        if (sectionPanel.up == null) {
            loader = OrderingTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/upImg.png");
            ImageIcon upIcon = new ImageIcon(imageURL);
            img = upIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            upIcon = new ImageIcon(newimg);
            sectionPanel.up = new JButton(upIcon);
            sectionPanel.up.setOpaque(false);
            sectionPanel.up.setContentAreaFilled(false);
            sectionPanel.up.setBorderPainted(false);
            sectionPanel.up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int position = OrderingTab.getPositionInSections(SectionPanel.this.getThis());
                    SectionPanel upperSectionPanel = OrderingTab.getSections().get(position - 1);
                    SectionPanel thisSectionPanel = OrderingTab.getSections().get(position);
                    OrderingTab.getSectionsPanel().switchPanelOrder(position);
                    SectionPanel.this.switchSectionPanels(position);
                    int upperSectionOrder = upperSectionPanel.getSectionOrder();
                    int thisSectionOrder = thisSectionPanel.getSectionOrder();
                    if (upperSectionOrder != thisSectionOrder) {
                        upperSectionPanel.setSectionOrder(thisSectionOrder);
                        thisSectionPanel.setSectionOrder(upperSectionOrder);
                    } else if (upperSectionOrder > 1) {
                        if (position - 2 >= 0) {
                            int upperUpperSectionOrder = OrderingTab.getSections().get(position - 2).getSectionOrder();
                            if (upperUpperSectionOrder != upperSectionOrder) {
                                thisSectionPanel.setSectionOrder(upperSectionOrder - 1);
                            }
                        } else {
                            thisSectionPanel.setSectionOrder(upperSectionOrder - 1);
                        }
                    }
                    SectionPanel.this.updateUpDownArrows(upperSectionPanel);
                    SectionPanel.this.updateUpDownArrows(thisSectionPanel);
                    upperSectionPanel.buttonsPanel.repaint();
                    thisSectionPanel.buttonsPanel.repaint();
                    OrderingTab.getSectionsPanel().repaint();
                }
            });
            sectionPanel.up.setVisible(true);
            sectionPanel.buttonsPanel.add(sectionPanel.up);
        }
        if (sectionPanel.down == null) {
            loader = OrderingTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/downImg.png");
            ImageIcon downIcon = new ImageIcon(imageURL);
            img = downIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            downIcon = new ImageIcon(newimg);
            sectionPanel.down = new JButton(downIcon);
            sectionPanel.down.setOpaque(false);
            sectionPanel.down.setContentAreaFilled(false);
            sectionPanel.down.setBorderPainted(false);
            sectionPanel.down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int position = OrderingTab.getPositionInSections(SectionPanel.this.getThis());
                    SectionPanel thisSectionPanel = OrderingTab.getSections().get(position);
                    SectionPanel lowerSectionPanel = OrderingTab.getSections().get(position + 1);
                    OrderingTab.getSectionsPanel().switchPanelOrder(position + 1);
                    SectionPanel.this.switchSectionPanels(position + 1);
                    int thisSectionOrder = thisSectionPanel.getSectionOrder();
                    int lowerSectionOrder = lowerSectionPanel.getSectionOrder();
                    if (lowerSectionOrder != thisSectionOrder) {
                        thisSectionPanel.setSectionOrder(lowerSectionOrder);
                        lowerSectionPanel.setSectionOrder(thisSectionOrder);
                    } else if (lowerSectionOrder < 100) {
                        if (position + 2 < OrderingTab.getSections().size()) {
                            int lowerLowerSectionOrder = OrderingTab.getSections().get(position + 2).getSectionOrder();
                            if (lowerLowerSectionOrder != lowerSectionOrder) {
                                thisSectionPanel.setSectionOrder(lowerSectionOrder + 1);
                            }
                        } else {
                            thisSectionPanel.setSectionOrder(lowerSectionOrder + 1);
                        }
                    }
                    SectionPanel.this.updateUpDownArrows(thisSectionPanel);
                    SectionPanel.this.updateUpDownArrows(lowerSectionPanel);
                    thisSectionPanel.buttonsPanel.repaint();
                    lowerSectionPanel.buttonsPanel.repaint();
                    OrderingTab.getSectionsPanel().repaint();
                }
            });
            sectionPanel.down.setVisible(true);
            sectionPanel.buttonsPanel.add(sectionPanel.down);
        }
        if ((position = OrderingTab.getPositionInSections(sectionPanel)) == 0 && OrderingTab.getSectionsSize() == 1) {
            sectionPanel.up.setEnabled(false);
            sectionPanel.down.setEnabled(false);
        } else if (position == 0) {
            sectionPanel.up.setEnabled(false);
            sectionPanel.down.setEnabled(true);
        } else if (position > 0 && position < OrderingTab.getSectionsSize() - 1) {
            sectionPanel.down.setEnabled(true);
            sectionPanel.up.setEnabled(true);
        } else if (position == OrderingTab.getSectionsSize() - 1) {
            sectionPanel.up.setEnabled(true);
            sectionPanel.down.setEnabled(false);
        }
        sectionPanel.sectionPanel.repaint();
        sectionPanel.sectionPanel.validate();
    }

    void createSectionPanel(ListIRI sectionIRI, int sectionOrder, String sectionLabelEN, String sectionLabelGR, ArrayList<ListIRI> orderIRIs) {
        this.getThis().sectionIRI = sectionIRI;
        this.sectionPanel.add(this.buttonsPanel);
        this.buttonsPanel.setLayout(new FlowLayout(3));
        this.buttonsPanel.setPreferredSize(new Dimension(400, 130));
        this.buttonsPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        this.sectionPanel.add(this.labelPanelEN);
        this.labelPanelEN.setLayout(new FlowLayout(3));
        this.labelPanelEN.setPreferredSize(new Dimension(390, 40));
        this.sectionPanel.add(this.labelPanelGR);
        this.labelPanelGR.setLayout(new FlowLayout(3));
        this.labelPanelGR.setPreferredSize(new Dimension(390, 40));
        JLabel orderTitle = new JLabel("Included properties in this section:");
        this.sectionPanel.add(orderTitle);
        this.orderPanel = new MyJPanel(330, 0);
        this.orderPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        this.sectionPanel.add(this.orderPanel);
        this.sectionPanel.increaseHeight(160);
        OrderingTab.getSectionsPanel().increaseHeight(170);
        OrderingTab.updateSectionScroll();
        if (this.buttonNew != null) {
            this.buttonNew.setVisible(false);
        }
        JLabel titleLabel = new JLabel("Section:");
        titleLabel.setPreferredSize(new Dimension(40, titleLabel.getPreferredSize().height));
        this.buttonsPanel.add(titleLabel);
        this.createSectionTitle(sectionIRI);
        this.sectionNameTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!SectionPanel.this.getThis().sectionNameTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionNameTextField.setEditable(true);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (SectionPanel.this.getThis().sectionNameTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionNameTextField.setEditable(false);
                    IRI newSectionIRI = IRI.create((String)(String.valueOf(SectionPanel.this.getThis().sectionIRI.getEntryIRI().getStart()) + SectionPanel.this.getThis().sectionNameTextField.getText()));
                    if (!SectionPanel.this.getThis().sectionNameTextField.getText().equals("") && OrderingTab.isLegalIRI(newSectionIRI) && SectionPanel.this.father.isUniqueIRI(newSectionIRI)) {
                        NaturalOWLTab.OQM.renameSection(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), newSectionIRI);
                        SectionPanel.this.father.updateSectionComboBoxes();
                        SectionPanel.this.getThis().sectionIRI = new ListIRI(newSectionIRI);
                        SectionPanel.this.father.dirtenOntologies();
                    } else {
                        SectionPanel.this.getThis().sectionNameTextField.setText(SectionPanel.this.getThis().sectionIRI.toString());
                    }
                }
            }
        });
        this.createSectionOrder(sectionOrder);
        this.sectionOrderTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!SectionPanel.this.getThis().sectionOrderTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionOrderTextField.setEditable(true);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (SectionPanel.this.getThis().sectionOrderTextField.isEditable()) {
                    if (OrderingTab.isValidOrder(SectionPanel.this.getThis().sectionOrderTextField.getText())) {
                        SectionPanel.this.updateOrder(Integer.parseInt(SectionPanel.this.getThis().sectionOrderTextField.getText()));
                        SectionPanel.this.getThis().sectionOrderTextField.setEditable(false);
                        NaturalOWLTab.OQM.setSectionOrder(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), Integer.parseInt(SectionPanel.this.getThis().sectionOrderTextField.getText()));
                        SectionPanel.this.father.dirtenOntologies();
                    } else {
                        SectionPanel.this.getThis().sectionOrderTextField.setText(String.valueOf(SectionPanel.this.getThis().getSectionOrder()));
                    }
                }
            }
        });
        this.updateUpDownArrows(this);
        ClassLoader loader = OrderingTab.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/deleteImg.png");
        ImageIcon deleteIcon = new ImageIcon(imageURL);
        Image img = deleteIcon.getImage();
        Image newimg = img.getScaledInstance(20, 20, 4);
        deleteIcon = new ImageIcon(newimg);
        JButton deleteSectionBut = new JButton(deleteIcon);
        deleteSectionBut.setOpaque(false);
        deleteSectionBut.setContentAreaFilled(false);
        deleteSectionBut.setBorderPainted(false);
        String t = "Are you sure you want to delete this Section?";
        final String title = new String(t);
        deleteSectionBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ans = JOptionPane.showConfirmDialog(null, title, "Delete?", 2);
                if (ans == 0) {
                    SectionPanel.this.delete(SectionPanel.this.getThis());
                }
            }
        });
        this.buttonsPanel.add(deleteSectionBut);
        JLabel labelLabelEN = new JLabel("English label:");
        labelLabelEN.setPreferredSize(new Dimension(65, labelLabelEN.getPreferredSize().height));
        this.labelPanelEN.add(labelLabelEN);
        this.createSectionLabelEN(sectionLabelEN);
        this.sectionLabelENTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!SectionPanel.this.getThis().sectionLabelENTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionLabelENTextField.setEditable(true);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (SectionPanel.this.getThis().sectionLabelENTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionLabelENTextField.setEditable(false);
                    NaturalOWLTab.OQM.setSectionLabel(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), SectionPanel.this.getThis().sectionLabelENTextField.getText(), "en");
                    SectionPanel.this.father.dirtenOntologies();
                }
            }
        });
        this.buttonsPanel.add(this.labelPanelEN);
        JLabel labelLabelGR = new JLabel("Greek label:");
        labelLabelGR.setPreferredSize(new Dimension(65, labelLabelGR.getPreferredSize().height));
        this.labelPanelGR.add(labelLabelGR);
        this.createSectionLabelGR(sectionLabelGR);
        this.sectionLabelGRTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!SectionPanel.this.getThis().sectionLabelGRTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionLabelGRTextField.setEditable(true);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (SectionPanel.this.getThis().sectionLabelGRTextField.isEditable()) {
                    SectionPanel.this.getThis().sectionLabelGRTextField.setEditable(false);
                    NaturalOWLTab.OQM.setSectionLabel(SectionPanel.this.getThis().sectionIRI.getEntryIRI(), SectionPanel.this.getThis().sectionLabelGRTextField.getText(), "el");
                    SectionPanel.this.father.dirtenOntologies();
                }
            }
        });
        this.buttonsPanel.add(this.labelPanelGR);
        if (orderIRIs != null) {
            this.loadOrderPanels(orderIRIs);
        }
        OrderingTab.getSectionsPanel().add(this.sectionPanel);
        int i = 0;
        while (i < OrderingTab.getSectionsSize()) {
            this.updateUpDownArrows(OrderingTab.getSections().get(i));
            ++i;
        }
    }

    void delete(SectionPanel section) {
        OrderingTab.getSectionsPanel().decreaseHeight(this.sectionPanel.height + 30);
        OrderingTab.getSectionsPanel().remove(section.sectionPanel);
        OrderingTab.getSectionsPanel().validate();
        OrderingTab.getSectionsPanel().repaint();
        OrderingTab.updateSectionScroll();
        int i = 0;
        while (i < OrderingTab.getSectionsSize()) {
            if (OrderingTab.getSections().get(i).equals(section)) {
                OrderingTab.removeFromSections(section);
            }
            ++i;
        }
        i = 0;
        while (i < OrderingTab.getSectionsSize()) {
            this.updateUpDownArrows(OrderingTab.getSections().get(i));
            ++i;
        }
        NaturalOWLTab.OQM.deleteSection(this.sectionIRI.getEntryIRI());
        this.father.dirtenOntologies();
        this.father.refreshUnsorted();
    }

    SectionPanel getThis() {
        return this;
    }

    public MyJPanel getOrderPanel() {
        return this.orderPanel;
    }

    public MyJPanel getSectionPanel() {
        return this.sectionPanel;
    }

    public JTextField getSectionNameTextField() {
        return this.sectionNameTextField;
    }

    public ArrayList<OrderPanel> getOrderPanels() {
        return this.orderPanels;
    }

    public void addToOrderPanels(OrderPanel p) {
        this.orderPanels.add(p);
    }

    public void addToOrderPanels(int i, OrderPanel p) {
        this.orderPanels.add(i, p);
    }

    public int getOrderPanelsSize() {
        return this.orderPanels.size();
    }

    public void removeFromOrderPanels(OrderPanel p) {
        int i = 0;
        while (i < this.orderPanels.size()) {
            if (this.orderPanels.get(i).equals(p)) {
                this.orderPanels.remove(i);
            }
            ++i;
        }
    }

    public int getPositionInOrderPanels(OrderPanel p) {
        boolean flag = false;
        int i = 0;
        while (!flag && i < this.orderPanels.size()) {
            if (this.orderPanels.get(i).equals(p)) {
                flag = true;
                continue;
            }
            ++i;
        }
        return i;
    }

    public void updatePropertiesPanel() {
        this.orderPanel.updateUI();
    }

    public static boolean isFirst() {
        return first;
    }

    public static void setFirst(boolean first) {
        SectionPanel.first = first;
    }

    public boolean isFirstInProp() {
        return this.firstInProp;
    }

    public void setFirstInProp(boolean firstInProp) {
        this.firstInProp = firstInProp;
    }

    public MyJPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public int getSectionOrder() {
        return this.sectionOrder;
    }

    public void setSectionOrder(int section) {
        this.sectionOrder = section;
        this.sectionOrderTextField.setText(String.valueOf(this.sectionOrder));
    }

    public JTextField getSectionTextField() {
        return this.sectionNameTextField;
    }

    public ListIRI getSectionIRI() {
        return this.sectionIRI;
    }

    public OrderingTab getFather() {
        return this.father;
    }
}

