/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.MyJPanel;
import gr.aueb.cs.nlg.NLOwlPlugin.MyOwnFocusTraversalPolicy;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SectionPanel;
import gr.aueb.cs.nlg.NLOwlPlugin.UnsortedPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class OrderingTab
extends NaturalOWLTab {
    private OWLModelManagerListener listener;
    private JPanel orderingPanel = new JPanel();
    static MyJPanel sectionsPanel = new MyJPanel();
    static MyJPanel unsortedPanels = new MyJPanel();
    public static ArrayList<SectionPanel> sections = new ArrayList();
    public static ArrayList<UnsortedPanel> unsorted = new ArrayList();
    static JScrollPane sectionScroll;
    static JScrollPane unsortedScroll;

    protected void initialiseOWLView() throws Exception {
        this.initialiseNaturalOWL();
        refresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                OrderingTab.this.refresh();
            }
        });
        this.setLayout(new BorderLayout(10, 10));
        JPanel sectionSuperPanel = new JPanel();
        JPanel unsortedSuperPanel = new JPanel();
        this.orderingPanel = new JPanel();
        sectionsPanel = new MyJPanel(450, 0);
        sectionScroll = new JScrollPane();
        sectionScroll.setHorizontalScrollBarPolicy(31);
        sectionScroll.setVerticalScrollBarPolicy(20);
        sectionScroll.setViewportView(sectionsPanel);
        unsortedPanels = new MyJPanel(580, 0);
        unsortedScroll = new JScrollPane();
        unsortedScroll.setHorizontalScrollBarPolicy(31);
        unsortedScroll.setVerticalScrollBarPolicy(20);
        unsortedScroll.setViewportView(unsortedPanels);
        this.loadSectionsAndOrders();
        this.loadUnsortedProperties();
        JLabel sectionTitle = new JLabel("Sections and Order");
        sectionTitle.setFont(new Font("Serif", 1, 24));
        JButton newSectionButton = new JButton("Add new section");
        newSectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SectionPanel sectionPnl = new SectionPanel(OrderingTab.this.getThis());
                OrderingTab.addToSections(sectionPnl);
                IRI sectionIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + "NewSection"));
                int n = 1;
                while (!OrderingTab.this.isUniqueIRI(sectionIRI)) {
                    sectionIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + "NewSection" + ++n));
                }
                sectionPnl.createSectionPanel(new ListIRI(sectionIRI), 100, "", "", null);
                NaturalOWLTab.OQM.addSection(sectionIRI);
                OrderingTab.this.getThis().dirtenOntologies();
                OrderingTab.getSectionsPanel().validate();
                OrderingTab.updateSectionScroll();
                OrderingTab.this.updateSectionComboBoxes();
            }
        });
        sectionSuperPanel.add(sectionTitle);
        sectionSuperPanel.add(newSectionButton);
        sectionSuperPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        sectionSuperPanel.add(sectionScroll);
        sectionSuperPanel.setLayout(new BoxLayout(sectionSuperPanel, 3));
        JLabel unsortedTitle = new JLabel("Unsorted properties");
        unsortedTitle.setFont(new Font("Serif", 1, 24));
        JButton refreshUnsortedButton = new JButton("Refresh unsorted properties");
        refreshUnsortedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderingTab.this.refreshUnsorted();
            }
        });
        unsortedSuperPanel.add(unsortedTitle);
        unsortedSuperPanel.add(refreshUnsortedButton);
        unsortedSuperPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        unsortedSuperPanel.add(unsortedScroll);
        unsortedSuperPanel.setLayout(new BoxLayout(unsortedSuperPanel, 3));
        this.orderingPanel.add(sectionSuperPanel);
        this.orderingPanel.add(unsortedSuperPanel);
        this.orderingPanel.setLayout(new BoxLayout(this.orderingPanel, 2));
        this.add("West", this.orderingPanel);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyOwnFocusTraversalPolicy());
        this.repaint();
    }

    private void refresh() {
        if (this.orderingPanel != null) {
            this.remove(this.orderingPanel);
        }
        this.setLayout(new BorderLayout(10, 10));
        JPanel sectionSuperPanel = new JPanel();
        JPanel unsortedSuperPanel = new JPanel();
        this.orderingPanel = new JPanel();
        sectionsPanel = new MyJPanel(450, 0);
        sectionScroll = new JScrollPane();
        sectionScroll.setHorizontalScrollBarPolicy(31);
        sectionScroll.setVerticalScrollBarPolicy(20);
        sectionScroll.setViewportView(sectionsPanel);
        unsortedPanels = new MyJPanel(580, 0);
        unsortedScroll = new JScrollPane();
        unsortedScroll.setHorizontalScrollBarPolicy(31);
        unsortedScroll.setVerticalScrollBarPolicy(20);
        unsortedScroll.setViewportView(unsortedPanels);
        this.loadSectionsAndOrders();
        this.loadUnsortedProperties();
        JLabel sectionTitle = new JLabel("Sections and Orders");
        sectionTitle.setFont(new Font("Serif", 1, 24));
        JButton newSectionButton = new JButton("Add new section");
        newSectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SectionPanel sectionPnl = new SectionPanel(OrderingTab.this.getThis());
                OrderingTab.addToSections(sectionPnl);
                IRI sectionIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + "NewSection"));
                int n = 1;
                while (!OrderingTab.this.isUniqueIRI(sectionIRI)) {
                    sectionIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + "NewSection" + ++n));
                }
                sectionPnl.createSectionPanel(new ListIRI(sectionIRI), 100, "", "", null);
                NaturalOWLTab.OQM.addSection(sectionIRI);
                OrderingTab.this.getThis().dirtenOntologies();
                OrderingTab.getSectionsPanel().validate();
                OrderingTab.updateSectionScroll();
                OrderingTab.this.updateSectionComboBoxes();
            }
        });
        sectionSuperPanel.add(sectionTitle);
        sectionSuperPanel.add(newSectionButton);
        sectionSuperPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        sectionSuperPanel.add(sectionScroll);
        sectionSuperPanel.setLayout(new BoxLayout(sectionSuperPanel, 3));
        JLabel unsortedTitle = new JLabel("Unsorted properties");
        unsortedTitle.setFont(new Font("Serif", 1, 24));
        JButton refreshUnsortedButton = new JButton("Refresh unsorted properties");
        refreshUnsortedButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderingTab.this.refreshUnsorted();
            }
        });
        unsortedSuperPanel.add(unsortedTitle);
        unsortedSuperPanel.add(refreshUnsortedButton);
        unsortedSuperPanel.add(Box.createRigidArea(new Dimension(0, 20)));
        unsortedSuperPanel.add(unsortedScroll);
        unsortedSuperPanel.setLayout(new BoxLayout(unsortedSuperPanel, 3));
        this.orderingPanel.add(sectionSuperPanel);
        this.orderingPanel.add(unsortedSuperPanel);
        this.orderingPanel.setLayout(new BoxLayout(this.orderingPanel, 2));
        this.add("West", this.orderingPanel);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new MyOwnFocusTraversalPolicy());
        this.repaint();
    }

    public void updateSectionComboBoxes() {
        HashSet<ListIRI> availableSections = new HashSet<ListIRI>();
        for (IRI sectionIRI : NaturalOWLTab.OQM.getOrderedSections()) {
            availableSections.add(new ListIRI(sectionIRI));
        }
        ArrayList sortList = new ArrayList(availableSections);
        Collections.sort(sortList);
        for (UnsortedPanel uPanel : OrderingTab.getUnsorted()) {
            uPanel.setSectionsComboModel(new DefaultComboBoxModel<Object>(sortList.toArray()));
            Object selected = uPanel.getSectionCombo().getSelectedItem();
            uPanel.getSectionCombo().setModel(uPanel.getSectionsComboModel());
            if (uPanel.getSectionsComboModel().getIndexOf(selected) == -1) continue;
            uPanel.getSectionCombo().setSelectedItem(selected);
        }
    }

    public void loadSectionsAndOrders() {
        ArrayList<IRI> sectionIRIs = NaturalOWLTab.OQM.getOrderedSections();
        int i = 0;
        while (i < sectionIRIs.size()) {
            SectionPanel sectionPnl = new SectionPanel(this);
            OrderingTab.addToSections(sectionPnl);
            ArrayList<IRI> propertyIRIs = NaturalOWLTab.OQM.getPropertiesInSection(sectionIRIs.get(i));
            ArrayList<ListIRI> propertyListIRIs = new ArrayList<ListIRI>();
            int j = 0;
            while (j < propertyIRIs.size()) {
                propertyListIRIs.add(new ListIRI(propertyIRIs.get(j)));
                ++j;
            }
            sectionPnl.createSectionPanel(new ListIRI(sectionIRIs.get(i)), NaturalOWLTab.OQM.getSectionOrder(sectionIRIs.get(i)), NaturalOWLTab.OQM.getSectionLabel(sectionIRIs.get(i), "en"), NaturalOWLTab.OQM.getSectionLabel(sectionIRIs.get(i), "el"), propertyListIRIs);
            ++i;
        }
    }

    public void loadUnsortedProperties() {
        HashSet<ListIRI> propertyEntries = new HashSet<ListIRI>();
        for (OWLOntology owl : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLObjectProperty prop : owl.getObjectPropertiesInSignature()) {
                if (prop.getIRI().getStart().equals(NLResourceManager.nlowlNS) || !NaturalOWLTab.OQM.getPropertySection(prop.getIRI()).equals((Object)NLResourceManager.defaultSection.getIRI())) continue;
                propertyEntries.add(new ListIRI(prop.getIRI()));
            }
            for (OWLObjectProperty prop : owl.getDataPropertiesInSignature()) {
                if (prop.getIRI().getStart().equals(NLResourceManager.nlowlNS) || !NaturalOWLTab.OQM.getPropertySection(prop.getIRI()).equals((Object)NLResourceManager.defaultSection.getIRI())) continue;
                propertyEntries.add(new ListIRI(prop.getIRI()));
            }
        }
        for (OWLNamedIndividual domainIndependentProperty : NLResourceManager.domainIndependentProperties) {
            if (!NaturalOWLTab.OQM.getPropertySection(domainIndependentProperty.getIRI()).equals((Object)NLResourceManager.defaultSection.getIRI())) continue;
            propertyEntries.add(new ListIRI(domainIndependentProperty.getIRI()));
        }
        ArrayList sortList = new ArrayList(propertyEntries);
        Collections.sort(sortList);
        int i = 0;
        while (i < sortList.size()) {
            UnsortedPanel panel = new UnsortedPanel(this.getThis(), unsortedPanels);
            panel.createUnsortedPanel((ListIRI)sortList.get(i));
            unsorted.add(panel);
            ++i;
        }
        unsortedPanels.validate();
        unsortedPanels.repaint();
    }

    public void refreshUnsorted() {
        unsortedPanels = new MyJPanel(580, 0);
        unsortedScroll.setViewportView(unsortedPanels);
        this.loadUnsortedProperties();
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.getOWLModelManager().removeListener(this.listener);
    }

    public static MyJPanel getSectionsPanel() {
        return sectionsPanel;
    }

    public static MyJPanel getUnsortedPanels() {
        return unsortedPanels;
    }

    public static ArrayList<UnsortedPanel> getUnsorted() {
        return unsorted;
    }

    public static ArrayList<SectionPanel> getSections() {
        return sections;
    }

    public static void addToUnsorted(UnsortedPanel b) {
        unsorted.add(b);
    }

    public static void addToSections(SectionPanel b) {
        sections.add(b);
    }

    public static void addToSections(int i, SectionPanel b) {
        sections.add(i, b);
    }

    public static int getSectionsSize() {
        return sections.size();
    }

    public static void removeFromSections(SectionPanel b) {
        int i = 0;
        while (i < sections.size()) {
            if (sections.get(i).equals(b)) {
                sections.remove(i);
            }
            ++i;
        }
    }

    static void removeFromUnsorted(UnsortedPanel u) {
        int i = 0;
        while (i < unsorted.size()) {
            if (unsorted.get(i).equals(u)) {
                unsorted.remove(i);
            }
            ++i;
        }
    }

    public static int getPositionInSections(SectionPanel b) {
        boolean flag = false;
        int i = 0;
        while (!flag && i < sections.size()) {
            if (sections.get(i).equals(b)) {
                flag = true;
                continue;
            }
            ++i;
        }
        return i;
    }

    public static boolean isValidOrder(String num) {
        int i;
        block3: {
            try {
                i = Integer.parseInt(num);
                if (i >= 1) break block3;
                return false;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return i <= 100;
    }

    public static void updateSectionScroll() {
        sectionScroll.updateUI();
    }

    public static void updateUnsortedScroll() {
        unsortedScroll.updateUI();
    }

    OrderingTab getThis() {
        return this;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }
}

