/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.OrderingTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SectionPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class OrderPanel {
    private JPanel orderPanel = new JPanel();
    private int order;
    private JLabel propertyName;
    private JTextField propertyOrderTextField;
    private JButton up;
    private JButton down;
    private SectionPanel containingSectionPanel;
    private ListIRI propertyIRI;

    OrderPanel(SectionPanel b) {
        this.orderPanel.setLayout(new FlowLayout(3));
        this.orderPanel.setPreferredSize(new Dimension(320, 45));
        this.containingSectionPanel = b;
    }

    void createPropertyName(ListIRI s) {
        this.propertyName = new JLabel(s.toString());
        this.propertyName.setPreferredSize(new Dimension(160, 40));
        if (!DefaultResourcesManager.isDefaultResource(s.getEntryIRI())) {
            this.propertyName.setToolTipText(s.getEntryIRI().toString());
        } else {
            this.propertyName.setToolTipText("<html><b>This is a default resource of the system.</b> <br>" + s.getEntryIRI().toString() + "</html>");
        }
        this.orderPanel.add((Component)this.propertyName, 0);
    }

    void createPropertyOrder(int n) {
        this.order = n;
        this.propertyOrderTextField = new JTextField(3);
        this.propertyOrderTextField.setText(String.valueOf(this.order));
        this.propertyOrderTextField.setEditable(false);
        this.propertyOrderTextField.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent key) {
                if (key.getKeyCode() == 10) {
                    if (OrderingTab.isValidOrder(OrderPanel.this.getThis().propertyOrderTextField.getText())) {
                        OrderPanel.this.updateOrder(Integer.parseInt(OrderPanel.this.getThis().propertyOrderTextField.getText()));
                        OrderPanel.this.getThis().propertyOrderTextField.setEditable(false);
                        NaturalOWLTab.OQM.setPropertyOrder(OrderPanel.this.getThis().propertyIRI.getEntryIRI(), Integer.parseInt(OrderPanel.this.getThis().propertyOrderTextField.getText()));
                        OrderPanel.this.containingSectionPanel.getFather().dirtenOntologies();
                    } else {
                        OrderPanel.this.getThis().propertyOrderTextField.setText(String.valueOf(OrderPanel.this.order));
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent key) {
            }

            @Override
            public void keyTyped(KeyEvent key) {
            }
        });
        this.orderPanel.add((Component)this.propertyOrderTextField, 1);
    }

    void movePanel(int start, int finish) {
        if (start <= finish) {
            int i = start + 1;
            while (i <= finish) {
                this.getThis().containingSectionPanel.getOrderPanel().switchPanelOrder(i);
                this.switchInProperties(i);
                OrderPanel upperOrderPanel = this.containingSectionPanel.getOrderPanels().get(i - 1);
                OrderPanel thisOrderPanel = this.containingSectionPanel.getOrderPanels().get(i);
                this.updateUpDownArrows(upperOrderPanel);
                this.updateUpDownArrows(thisOrderPanel);
                upperOrderPanel.orderPanel.repaint();
                thisOrderPanel.orderPanel.repaint();
                ++i;
            }
        } else {
            int i = start;
            while (i > finish + 1) {
                this.getThis().containingSectionPanel.getOrderPanel().switchPanelOrder(i);
                this.switchInProperties(i);
                OrderPanel upperOrderPanel = this.containingSectionPanel.getOrderPanels().get(i - 1);
                OrderPanel thisOrderPanel = this.containingSectionPanel.getOrderPanels().get(i);
                this.updateUpDownArrows(upperOrderPanel);
                this.updateUpDownArrows(thisOrderPanel);
                upperOrderPanel.orderPanel.repaint();
                thisOrderPanel.orderPanel.repaint();
                --i;
            }
        }
        this.getThis().containingSectionPanel.getOrderPanel().repaint();
    }

    void switchInProperties(int i) {
        OrderPanel a = this.containingSectionPanel.getOrderPanels().get(i - 1);
        OrderPanel b = this.containingSectionPanel.getOrderPanels().get(i);
        this.containingSectionPanel.removeFromOrderPanels(a);
        this.containingSectionPanel.removeFromOrderPanels(b);
        this.containingSectionPanel.addToOrderPanels(i - 1, b);
        this.containingSectionPanel.addToOrderPanels(i, a);
    }

    void updateOrder(int newOrder) {
        int position = this.containingSectionPanel.getPositionInOrderPanels(this.getThis());
        OrderPanel thisOrderPanel = this.containingSectionPanel.getOrderPanels().get(position);
        int thisOrder = thisOrderPanel.getOrder();
        int i = 0;
        while (i < this.containingSectionPanel.getOrderPanels().size()) {
            OrderPanel checkOrderPanel = this.containingSectionPanel.getOrderPanels().get(i);
            int checkOrder = checkOrderPanel.getOrder();
            if (checkOrder > newOrder) {
                thisOrderPanel.setOrder(newOrder);
                this.movePanel(position, i - 1);
                return;
            }
            ++i;
        }
        thisOrderPanel.setOrder(newOrder);
        this.movePanel(position, this.containingSectionPanel.getOrderPanels().size() - 1);
    }

    void updateUpDownArrows(OrderPanel ordPanel) {
        int position;
        Image newimg;
        Image img;
        URL imageURL;
        ClassLoader loader;
        if (ordPanel.up == null) {
            loader = OrderingTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/upImg.png");
            ImageIcon upIcon = new ImageIcon(imageURL);
            img = upIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            upIcon = new ImageIcon(newimg);
            ordPanel.up = new JButton(upIcon);
            ordPanel.up.setOpaque(false);
            ordPanel.up.setContentAreaFilled(false);
            ordPanel.up.setBorderPainted(false);
            ordPanel.up.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int position = OrderPanel.this.containingSectionPanel.getPositionInOrderPanels(OrderPanel.this.getThis());
                    OrderPanel upperOrderPanel = OrderPanel.this.containingSectionPanel.getOrderPanels().get(position - 1);
                    OrderPanel thisOrderPanel = OrderPanel.this.containingSectionPanel.getOrderPanels().get(position);
                    OrderPanel.this.getThis().containingSectionPanel.getOrderPanel().switchPanelOrder(position);
                    OrderPanel.this.switchInProperties(position);
                    int upperOrder = upperOrderPanel.getOrder();
                    int thisOrder = thisOrderPanel.getOrder();
                    if (upperOrder != thisOrder) {
                        upperOrderPanel.setOrder(thisOrder);
                        thisOrderPanel.setOrder(upperOrder);
                    } else if (upperOrder > 1) {
                        if (position - 2 >= 0) {
                            int upperUpperOrder = OrderPanel.this.containingSectionPanel.getOrderPanels().get(position - 2).getOrder();
                            if (upperUpperOrder != upperOrder) {
                                thisOrderPanel.setOrder(upperOrder - 1);
                            }
                        } else {
                            thisOrderPanel.setOrder(upperOrder - 1);
                        }
                    }
                    OrderPanel.this.updateUpDownArrows(upperOrderPanel);
                    OrderPanel.this.updateUpDownArrows(thisOrderPanel);
                    upperOrderPanel.orderPanel.repaint();
                    thisOrderPanel.orderPanel.repaint();
                    OrderPanel.this.getThis().containingSectionPanel.getOrderPanel().repaint();
                }
            });
            ordPanel.up.setVisible(true);
            ordPanel.orderPanel.add(ordPanel.up);
        }
        if (ordPanel.down == null) {
            loader = OrderingTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/downImg.png");
            ImageIcon downIcon = new ImageIcon(imageURL);
            img = downIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            downIcon = new ImageIcon(newimg);
            ordPanel.down = new JButton(downIcon);
            ordPanel.down.setOpaque(false);
            ordPanel.down.setContentAreaFilled(false);
            ordPanel.down.setBorderPainted(false);
            ordPanel.down.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int position = OrderPanel.this.containingSectionPanel.getPositionInOrderPanels(OrderPanel.this.getThis());
                    OrderPanel thisOrderPanel = OrderPanel.this.containingSectionPanel.getOrderPanels().get(position);
                    OrderPanel lowerOrderPanel = OrderPanel.this.containingSectionPanel.getOrderPanels().get(position + 1);
                    OrderPanel.this.getThis().containingSectionPanel.getOrderPanel().switchPanelOrder(position + 1);
                    OrderPanel.this.switchInProperties(position + 1);
                    int thisOrder = thisOrderPanel.getOrder();
                    int lowerOrder = lowerOrderPanel.getOrder();
                    if (lowerOrder != thisOrder) {
                        thisOrderPanel.setOrder(lowerOrder);
                        lowerOrderPanel.setOrder(thisOrder);
                    } else if (lowerOrder < 100) {
                        if (position + 2 < OrderPanel.this.containingSectionPanel.getOrderPanels().size()) {
                            int lowerLowerOrder = OrderPanel.this.containingSectionPanel.getOrderPanels().get(position + 2).getOrder();
                            if (lowerLowerOrder != lowerOrder) {
                                thisOrderPanel.setOrder(lowerOrder + 1);
                            }
                        } else {
                            thisOrderPanel.setOrder(lowerOrder + 1);
                        }
                    }
                    OrderPanel.this.updateUpDownArrows(thisOrderPanel);
                    OrderPanel.this.updateUpDownArrows(lowerOrderPanel);
                    thisOrderPanel.orderPanel.repaint();
                    lowerOrderPanel.orderPanel.repaint();
                    OrderPanel.this.getThis().containingSectionPanel.getOrderPanel().repaint();
                }
            });
            ordPanel.down.setVisible(true);
            ordPanel.orderPanel.add(ordPanel.down);
        }
        if ((position = this.containingSectionPanel.getPositionInOrderPanels(ordPanel)) == 0 && this.containingSectionPanel.getOrderPanelsSize() == 1) {
            ordPanel.up.setEnabled(false);
            ordPanel.down.setEnabled(false);
        } else if (position == 0) {
            ordPanel.up.setEnabled(false);
            ordPanel.down.setEnabled(true);
        } else if (position > 0 && position < this.containingSectionPanel.getOrderPanelsSize() - 1) {
            ordPanel.down.setEnabled(true);
            ordPanel.up.setEnabled(true);
        } else if (position == this.containingSectionPanel.getOrderPanelsSize() - 1) {
            ordPanel.up.setEnabled(true);
            ordPanel.down.setEnabled(false);
        }
        ordPanel.orderPanel.repaint();
        ordPanel.orderPanel.validate();
    }

    void createOrderPanel(ListIRI propertyIRI, int propertyOrder) {
        this.getThis().propertyIRI = propertyIRI;
        if (this.getThis().containingSectionPanel.getOrderPanel().getComponentCount() == 0) {
            this.getThis().containingSectionPanel.getOrderPanel().increaseHeight(10);
            this.getThis().containingSectionPanel.getSectionPanel().increaseHeight(10);
            OrderingTab.getSectionsPanel().increaseHeight(10);
        }
        this.getThis().containingSectionPanel.getOrderPanel().increaseHeight(50);
        this.getThis().containingSectionPanel.getSectionPanel().increaseHeight(50);
        this.getThis().containingSectionPanel.getSectionPanel().validate();
        OrderingTab.getSectionsPanel().increaseHeight(50);
        OrderingTab.getSectionsPanel().validate();
        OrderingTab.updateSectionScroll();
        this.createPropertyName(propertyIRI);
        this.createPropertyOrder(propertyOrder);
        this.propertyOrderTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (!OrderPanel.this.getThis().propertyOrderTextField.isEditable()) {
                    OrderPanel.this.getThis().propertyOrderTextField.setEditable(true);
                }
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                if (OrderPanel.this.getThis().propertyOrderTextField.isEditable()) {
                    if (OrderingTab.isValidOrder(OrderPanel.this.getThis().propertyOrderTextField.getText())) {
                        OrderPanel.this.updateOrder(Integer.parseInt(OrderPanel.this.getThis().propertyOrderTextField.getText()));
                        OrderPanel.this.getThis().propertyOrderTextField.setEditable(false);
                        NaturalOWLTab.OQM.setPropertyOrder(OrderPanel.this.getThis().propertyIRI.getEntryIRI(), Integer.parseInt(OrderPanel.this.getThis().propertyOrderTextField.getText()));
                        OrderPanel.this.containingSectionPanel.getFather().dirtenOntologies();
                    } else {
                        OrderPanel.this.getThis().propertyOrderTextField.setText(String.valueOf(OrderPanel.this.order));
                    }
                }
            }
        });
        this.updateUpDownArrows(this);
        ClassLoader loader = OrderingTab.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/deleteImg.png");
        ImageIcon deleteIcon = new ImageIcon(imageURL);
        Image img = deleteIcon.getImage();
        Image newimg = img.getScaledInstance(20, 20, 4);
        deleteIcon = new ImageIcon(newimg);
        JButton deleteOrderBut = new JButton(deleteIcon);
        deleteOrderBut.setOpaque(false);
        deleteOrderBut.setContentAreaFilled(false);
        deleteOrderBut.setBorderPainted(false);
        String t = "Are you sure you want to remove this Property from this Section?";
        final String title = new String(t);
        deleteOrderBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ans = JOptionPane.showConfirmDialog(null, title, "Delete?", 2);
                if (ans == 0) {
                    OrderPanel.this.delete(OrderPanel.this.getThis());
                }
            }
        });
        this.orderPanel.add(deleteOrderBut);
        this.getThis().containingSectionPanel.getOrderPanel().add(this.orderPanel);
    }

    void delete(OrderPanel p) {
        this.getThis().containingSectionPanel.getOrderPanel().remove(p.orderPanel);
        if (this.getThis().containingSectionPanel.getOrderPanel().getComponentCount() == 0) {
            this.getThis().containingSectionPanel.getOrderPanel().decreaseHeight(10);
            this.getThis().containingSectionPanel.getSectionPanel().decreaseHeight(10);
            OrderingTab.getSectionsPanel().decreaseHeight(10);
        }
        this.getThis().containingSectionPanel.getOrderPanel().decreaseHeight(50);
        this.getThis().containingSectionPanel.getSectionPanel().decreaseHeight(50);
        this.getThis().containingSectionPanel.getSectionPanel().validate();
        OrderingTab.getSectionsPanel().decreaseHeight(50);
        OrderingTab.getSectionsPanel().validate();
        this.containingSectionPanel.getOrderPanel().validate();
        this.containingSectionPanel.getOrderPanel().repaint();
        this.containingSectionPanel.updatePropertiesPanel();
        OrderingTab.updateSectionScroll();
        int i = 0;
        while (i < this.containingSectionPanel.getOrderPanelsSize()) {
            if (this.containingSectionPanel.getOrderPanels().get(i).equals(p)) {
                this.containingSectionPanel.removeFromOrderPanels(p);
            }
            ++i;
        }
        i = 0;
        while (i < this.containingSectionPanel.getOrderPanelsSize()) {
            this.updateUpDownArrows(this.containingSectionPanel.getOrderPanels().get(i));
            ++i;
        }
        NaturalOWLTab.OQM.setPropertySection(this.getThis().propertyIRI.getEntryIRI(), NLResourceManager.defaultSection.getIRI());
        NaturalOWLTab.OQM.setPropertyOrder(this.getThis().propertyIRI.getEntryIRI(), 100);
        this.containingSectionPanel.getFather().dirtenOntologies();
        this.containingSectionPanel.getFather().refreshUnsorted();
    }

    OrderPanel getThis() {
        return this;
    }

    public JPanel getOrderPanel() {
        return this.orderPanel;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
        this.propertyOrderTextField.setText(String.valueOf(order));
    }

    public JButton getUp() {
        return this.up;
    }

    public JButton getDown() {
        return this.down;
    }

    public SectionPanel getSection() {
        return this.containingSectionPanel;
    }

    public ListIRI getPropertyIRI() {
        return this.propertyIRI;
    }
}

