/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeRenderer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;

public class ObjectPropertiesTreeComponent
extends TreeComponent {
    private DefaultMutableTreeNode parent;

    public ObjectPropertiesTreeComponent(NaturalOWLTab fatherTab) {
        super(fatherTab);
    }

    @Override
    public void createTree() {
        this.parent = new DefaultMutableTreeNode(new ListIRI(this.father.getOWLModelManager().getOWLDataFactory().getOWLTopObjectProperty().getIRI()), true);
        HashSet<ListIRI> objectToAdd = new HashSet<ListIRI>();
        for (OWLObjectProperty rootProperty : this.father.getOWLModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider().getRoots()) {
            for (OWLObjectProperty rootChild : this.father.getOWLModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider().getChildren((OWLObject)rootProperty)) {
                if (rootChild.getIRI().toString().startsWith(NLResourceManager.nlowlNS)) continue;
                objectToAdd.add(new ListIRI(rootChild.getIRI()));
            }
        }
        ArrayList objectToAddSorted = new ArrayList(objectToAdd);
        Collections.sort(objectToAddSorted);
        for (ListIRI add : objectToAddSorted) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(add, true);
            this.parent.add(node);
            this.addObjectSubProperties(node, this.father.getOWLModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider().getChildren((OWLObject)this.father.getOWLModelManager().getOWLDataFactory().getOWLObjectProperty(add.getEntryIRI())));
        }
        this.tree = new JTree(this.parent);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
    }

    private void addObjectSubProperties(DefaultMutableTreeNode parent, Set<OWLObjectProperty> subProperties) {
        HashSet<ListIRI> children = new HashSet<ListIRI>();
        for (OWLObjectProperty objProperty : subProperties) {
            if (objProperty.getIRI().toString().startsWith(NLResourceManager.nlowlNS)) continue;
            children.add(new ListIRI(objProperty.getIRI()));
        }
        ArrayList childrenSorted = new ArrayList(children);
        Collections.sort(childrenSorted);
        for (ListIRI child : childrenSorted) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(child, true);
            parent.add(node);
            this.addObjectSubProperties(node, this.father.getOWLModelManager().getOWLHierarchyManager().getOWLObjectPropertyHierarchyProvider().getChildren((OWLObject)this.father.getOWLModelManager().getOWLDataFactory().getOWLObjectProperty(child.getEntryIRI())));
        }
    }

    @Override
    public JPanel TP() {
        JPanel treepanel = new JPanel();
        this.createTree();
        treepanel.add(this.tree);
        treepanel.setBackground(new Color(255, 255, 255));
        treepanel.setLayout(new FlowLayout(0));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.addTreeSelectionListener(this);
        ClassLoader loader = LexiconTreeComponent.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/property.object.png");
        URL imageOpenURL = loader.getResource("/icons/property.object.open.png");
        URL imageCloseURL = loader.getResource("/icons/property.object.close.png");
        ImageIcon icon = new ImageIcon(imageURL);
        ImageIcon iconOpen = new ImageIcon(imageOpenURL);
        ImageIcon iconClose = new ImageIcon(imageCloseURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(iconOpen);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(iconClose);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(icon);
        return treepanel;
    }

    public void clearSelection() {
        this.tree.clearSelection();
        NaturalOWLTab.userModelTreePropertySelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTreePropertySelectionModel.getSelectedEntity());
        NaturalOWLTab.userModelTablePropertySelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTablePropertySelectionModel.getSelectedEntity());
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            NaturalOWLTab.userModelTreePropertySelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTreePropertySelectionModel.getSelectedEntity());
            NaturalOWLTab.userModelTablePropertySelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTablePropertySelectionModel.getSelectedEntity());
            return;
        }
        IRI selectedIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
        for (OWLOntology model : this.father.getOWLModelManager().getOntologies()) {
            if (!model.containsObjectPropertyInSignature(selectedIRI)) continue;
            NaturalOWLTab.userModelTreePropertySelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLObjectProperty(selectedIRI));
            NaturalOWLTab.userModelTablePropertySelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLObjectProperty(selectedIRI));
            return;
        }
    }
}

