/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNameTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.SentencePlanTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeComponent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class NewResourceDialogPanel
extends JPanel {
    private static final long serialVersionUID = 1799975683407897340L;
    GridBagConstraints gbc = new GridBagConstraints();
    GridBagLayout gbl = new GridBagLayout();
    ArrayList<JComponent> options = new ArrayList();

    NewResourceDialogPanel(TreeComponent tab, boolean simple, String text) {
        if (simple) {
            String name = "Please enter a new name:";
            JLabel nameLabel = new JLabel(name);
            JTextField nametf = new JTextField(text, 20);
            this.addComponent(nameLabel, 0, 0, 17);
            this.addComponent(nametf, 0, 1, 17);
            this.options.add(nametf);
        } else {
            String name = "";
            String parentType = "Please choose a language:";
            String[] choices = new String[]{"English", "Greek"};
            if (tab instanceof LexiconTreeComponent) {
                name = "Please enter a name for the new Lexicon Entry:";
                parentType = "Please choose a Part of Speech:";
                choices = new String[]{"Adjective", "Noun", "Verb"};
            } else if (tab instanceof NLNameTreeComponent) {
                name = "Please enter a name for the new NL Name:";
            } else if (tab instanceof SentencePlanTreeComponent) {
                name = "Please enter a name for the new Sentence Plan:";
            }
            JLabel nameLabel = new JLabel(name);
            JTextField nametf = new JTextField(text, 20);
            JLabel parentLabel = new JLabel(parentType);
            JComboBox<String> parentcb = new JComboBox<String>(choices);
            this.addComponent(nameLabel, 0, 0, 17);
            this.addComponent(nametf, 0, 1, 17);
            this.addComponent(parentLabel, 0, 2, 17);
            this.addComponent(parentcb, 0, 3, 17);
            this.options.add(nametf);
            this.options.add(parentcb);
        }
        this.setLayout(this.gbl);
    }

    @Override
    public String getName() {
        return ((JTextField)this.options.get(0)).getText();
    }

    public String getFirstSelected() {
        return ((JComboBox)this.options.get(0)).getSelectedItem().toString();
    }

    public String getSecondSelected() {
        return ((JComboBox)this.options.get(1)).getSelectedItem().toString();
    }

    public void addComponent(Component component, int xpos, int ypos) {
        this.gbc.gridx = xpos;
        this.gbc.gridy = ypos;
        this.gbc.insets = new Insets(2, 2, 2, 2);
        this.gbl.setConstraints(component, this.gbc);
        this.add(component);
    }

    public void addComponent(Component component, int xpos, int ypos, int anchor) {
        this.gbc.anchor = anchor;
        this.addComponent(component, xpos, ypos);
    }
}

