/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.LexiconQueryManager;
import gr.aueb.cs.nlg.NLFiles.MappingQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLNameQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.OrderingQueryManager;
import gr.aueb.cs.nlg.NLFiles.SentencePlanQueryManager;
import gr.aueb.cs.nlg.NLFiles.UserModelQueryManager;
import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTab;
import gr.aueb.cs.nlg.NLOwlPlugin.OWLFilter;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelImpl;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.io.FileDocumentTarget;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import uk.ac.manchester.cs.owl.owlapi.OWLOntologyImpl;

public abstract class NaturalOWLTab
extends AbstractOWLViewComponent
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = 2933019629486971027L;
    static Logger log = Logger.getLogger(LexiconTab.class);
    public NaturalOWLTab thisTab = this;
    static File loadedNLResourcesFile = null;
    static LexiconQueryManager LQM = null;
    static SentencePlanQueryManager SPQM = null;
    static NLNameQueryManager NLNQM = null;
    static MappingQueryManager MQM = null;
    static OrderingQueryManager OQM = null;
    static UserModelQueryManager UMQM = null;
    static OWLSelectionModel lexiconSelectionModel;
    static OWLSelectionModel sentencePlanSelectionModel;
    static OWLSelectionModel NLNameSelectionModel;
    static OWLSelectionModel userModelTreePropertySelectionModel;
    static OWLSelectionModel userModelTreeClassSelectionModel;
    static OWLSelectionModel userModelTableModifierSelectionModel;
    static OWLSelectionModel userModelTablePropertySelectionModel;
    static OWLSelectionModel userModelTableClassSelectionModel;
    static OWLSelectionModel userModelTableIndivSelectionModel;
    static OWLSelectionModel generationClassSelectionModel;
    static OWLSelectionModel generationIndivSelectionModel;
    static String NLFilePath;
    static String masterLoadedOntologyID;
    static JCheckBox refresh;
    static final JFileChooser fc;
    static boolean areNLResourcesDirty;
    static NLResourceManager resourcesManager;
    private IOListener ioListener;
    private OWLOntologyChangeListener changeListener;

    static {
        NLFilePath = "";
        masterLoadedOntologyID = "";
        refresh = new JCheckBox();
        fc = new JFileChooser();
        areNLResourcesDirty = false;
    }

    NaturalOWLTab() {
    }

    public void initialiseNaturalOWL() throws Exception {
        this.ioListener = new IOListener(){

            public void beforeSave(IOListenerEvent event) {
                Object[] options;
                int n;
                if (areNLResourcesDirty && (n = JOptionPane.showOptionDialog(null, "<html><b>Do you also want to save changes in the current NL resource ontology of the NaturalOWL plugin?</b><br>Your changes will be lost if you don't save them.</html>", "NaturalOWL: Save NL resources ontology?", 0, 2, null, options = new Object[]{"Yes", "No"}, options[0])) == 0) {
                    if (loadedNLResourcesFile != null) {
                        NaturalOWLTab.saveNLResourcesOntology(loadedNLResourcesFile);
                    } else {
                        NaturalOWLTab.saveAsNaturalOWLFiles(NaturalOWLTab.this.thisTab.getOWLWorkspace());
                    }
                }
            }

            public void afterSave(IOListenerEvent event) {
            }

            public void beforeLoad(IOListenerEvent event) {
            }

            public void afterLoad(IOListenerEvent event) {
            }
        };
        this.getOWLModelManager().addIOListener(this.ioListener);
        this.loadNaturalOWLFiles();
    }

    public void loadNaturalOWLFiles() {
        boolean reload = false;
        String ontPath = this.getOWLModelManager().getOWLOntologyManager().getOntologyDocumentIRI(this.getOWLModelManager().getActiveOntology()).toString();
        NLFilePath = ontPath.startsWith("file") ? ontPath.substring(6, ontPath.lastIndexOf("/") + 1).replaceAll("%20", " ") : "";
        if (!this.getOWLModelManager().getActiveOntology().getOntologyID().getOntologyIRI().toString().equals(masterLoadedOntologyID)) {
            System.out.println(masterLoadedOntologyID);
            masterLoadedOntologyID = this.getOWLModelManager().getActiveOntology().getOntologyID().getOntologyIRI().toString();
            reload = true;
        }
        if (reload) {
            File NLOwlFile = new File(String.valueOf(NLFilePath) + "NLresources.owl");
            if (NLOwlFile.exists()) {
                NaturalOWLTab.openNLResourcesOntology(NLOwlFile, this.getOWLModelManager().getOntologies(), false);
            } else {
                NaturalOWLTab.createNewNLResourcesOntology(IRI.create((String)NLResourceManager.resourcesNS.substring(0, NLResourceManager.resourcesNS.length() - 1)), this.getOWLModelManager().getOntologies());
            }
        }
    }

    static void createNewNLResourcesOntology(IRI ontologyIRI, Set<OWLOntology> ontologies) {
        resourcesManager = new NLResourceManager();
        OWLOntologyImpl resourcesOntology = new OWLOntologyImpl(resourcesManager.getOntologyManager(), new OWLOntologyID(ontologyIRI));
        resourcesManager.loadNLResourcesModel((OWLOntology)resourcesOntology);
        LQM = new LexiconQueryManager(resourcesManager);
        for (OWLOntology model : ontologies) {
            LQM.importLexiconEntries(model);
        }
        SPQM = new SentencePlanQueryManager(resourcesManager);
        for (OWLOntology model : ontologies) {
            SPQM.importSentencePlans(model);
        }
        NLNQM = new NLNameQueryManager(resourcesManager);
        for (OWLOntology model : ontologies) {
            NLNQM.importNLNames(model);
        }
        UMQM = new UserModelQueryManager(resourcesManager);
        for (OWLOntology owl : ontologies) {
            UMQM.importUserModels(owl);
            UMQM.importAnnotationEvents(owl);
        }
        MQM = new MappingQueryManager(resourcesManager);
        for (OWLOntology model : ontologies) {
            MQM.importMappings(model);
        }
        OQM = new OrderingQueryManager(resourcesManager);
        for (OWLOntology model : ontologies) {
            OQM.importSections(model);
            OQM.importOrdering(model);
        }
        NaturalOWLTab.refreshListeners();
    }

    static void openNLResourcesOntology(File NLOwlFile, Set<OWLOntology> ontologies, boolean replaceOld) {
        loadedNLResourcesFile = NLOwlFile;
        if (replaceOld || resourcesManager == null || resourcesManager.getNLResourcesModel() == null) {
            resourcesManager = new NLResourceManager();
            resourcesManager.loadNLResourcesModel(NLOwlFile);
        } else {
            NaturalOWLTab.importNLResourcesOntology(NLOwlFile, ontologies);
        }
        LQM = new LexiconQueryManager(resourcesManager);
        LQM.importLexiconEntries(resourcesManager.getNLResourcesModel());
        for (OWLOntology owl : ontologies) {
            LQM.importLexiconEntries(owl);
        }
        SPQM = new SentencePlanQueryManager(resourcesManager);
        SPQM.importSentencePlans(resourcesManager.getNLResourcesModel());
        for (OWLOntology owl : ontologies) {
            SPQM.importSentencePlans(owl);
        }
        NLNQM = new NLNameQueryManager(resourcesManager);
        NLNQM.importNLNames(resourcesManager.getNLResourcesModel());
        for (OWLOntology owl : ontologies) {
            NLNQM.importNLNames(owl);
        }
        UMQM = new UserModelQueryManager(resourcesManager);
        UMQM.importUserModels(resourcesManager.getNLResourcesModel());
        for (OWLOntology owl : ontologies) {
            UMQM.importUserModels(owl);
            UMQM.importAnnotationEvents(owl);
        }
        MQM = new MappingQueryManager(resourcesManager);
        for (OWLOntology owl : ontologies) {
            MQM.importMappings(owl);
        }
        OQM = new OrderingQueryManager(resourcesManager);
        OQM.importSections(resourcesManager.getNLResourcesModel());
        OQM.importOrdering(resourcesManager.getNLResourcesModel());
        for (OWLOntology owl : ontologies) {
            OQM.importSections(owl);
            OQM.importOrdering(owl);
        }
        NaturalOWLTab.refreshListeners();
        log.info((Object)("Loading NaturalOWL resources from " + resourcesManager.getNLResourcesModel()));
    }

    static void refreshListeners() {
        if (lexiconSelectionModel == null) {
            lexiconSelectionModel = new OWLSelectionModelImpl();
        }
        if (sentencePlanSelectionModel == null) {
            sentencePlanSelectionModel = new OWLSelectionModelImpl();
        }
        if (NLNameSelectionModel == null) {
            NLNameSelectionModel = new OWLSelectionModelImpl();
        }
        if (userModelTreePropertySelectionModel == null) {
            userModelTreePropertySelectionModel = new OWLSelectionModelImpl();
        }
        if (userModelTreeClassSelectionModel == null) {
            userModelTreeClassSelectionModel = new OWLSelectionModelImpl();
        }
        if (userModelTableModifierSelectionModel == null) {
            userModelTableModifierSelectionModel = new OWLSelectionModelImpl();
        }
        if (userModelTablePropertySelectionModel == null) {
            userModelTablePropertySelectionModel = new OWLSelectionModelImpl();
        }
        if (userModelTableClassSelectionModel == null) {
            userModelTableClassSelectionModel = new OWLSelectionModelImpl();
        }
        if (userModelTableIndivSelectionModel == null) {
            userModelTableIndivSelectionModel = new OWLSelectionModelImpl();
        }
        if (generationClassSelectionModel == null) {
            generationClassSelectionModel = new OWLSelectionModelImpl();
        }
        if (generationIndivSelectionModel == null) {
            generationIndivSelectionModel = new OWLSelectionModelImpl();
        }
    }

    static void importNLResourcesOntology(File NLOwlFile, Set<OWLOntology> ontologies) throws OWLOntologyRenameException {
        try {
            OWLOntology NLResourcesModel;
            if (resourcesManager == null) {
                resourcesManager = new NLResourceManager();
                LQM = new LexiconQueryManager(resourcesManager);
                SPQM = new SentencePlanQueryManager(resourcesManager);
                NLNQM = new NLNameQueryManager(resourcesManager);
                UMQM = new UserModelQueryManager(resourcesManager);
                MQM = new MappingQueryManager(resourcesManager);
                OQM = new OrderingQueryManager(resourcesManager);
                NLResourcesModel = resourcesManager.getOntologyManager().loadOntologyFromOntologyDocument(NLOwlFile);
            } else {
                NLResourceManager tempManager = new NLResourceManager();
                NLResourcesModel = tempManager.getOntologyManager().loadOntologyFromOntologyDocument(NLOwlFile);
            }
            LQM.importLexiconEntries(NLResourcesModel);
            for (OWLOntology owl : ontologies) {
                LQM.importLexiconEntries(owl);
            }
            SPQM.importSentencePlans(NLResourcesModel);
            for (OWLOntology owl : ontologies) {
                SPQM.importSentencePlans(owl);
            }
            NLNQM.importNLNames(NLResourcesModel);
            for (OWLOntology owl : ontologies) {
                NLNQM.importNLNames(owl);
            }
            UMQM.importUserModels(NLResourcesModel);
            for (OWLOntology owl : ontologies) {
                UMQM.importUserModels(owl);
                UMQM.importAnnotationEvents(owl);
            }
            MQM.importMappings(NLResourcesModel);
            for (OWLOntology owl : ontologies) {
                MQM.importMappings(owl);
            }
            OQM.importSections(NLResourcesModel);
            OQM.importOrdering(NLResourcesModel);
            for (OWLOntology owl : ontologies) {
                OQM.importSections(owl);
                OQM.importOrdering(owl);
            }
            NaturalOWLTab.refreshListeners();
            log.info((Object)("Importing NaturalOWL resources from " + NLResourcesModel));
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            // empty catch block
        }
    }

    static void saveAsNaturalOWLFiles(OWLWorkspace component) {
        fc.setFileFilter(new OWLFilter());
        int returnVal = fc.showSaveDialog((Component)component);
        if (returnVal == 0) {
            if (fc.getSelectedFile().exists()) {
                int confirm = JOptionPane.showConfirmDialog(null, "Replace existing file?");
                if (confirm == 0) {
                    loadedNLResourcesFile = fc.getSelectedFile();
                    NaturalOWLTab.saveNLResourcesOntology(loadedNLResourcesFile);
                }
                return;
            }
            try {
                if (fc.getSelectedFile().createNewFile()) {
                    loadedNLResourcesFile = fc.getSelectedFile();
                    NaturalOWLTab.saveNLResourcesOntology(loadedNLResourcesFile);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
    }

    static void saveNLResourcesOntology(File NLOwlFile) {
        if (resourcesManager == null) {
            resourcesManager = new NLResourceManager();
        }
        OWLOntologyImpl resourcesOntology = new OWLOntologyImpl(resourcesManager.getNLResourcesModel().getOWLOntologyManager(), resourcesManager.getNLResourcesModel().getOntologyID());
        if (LQM == null) {
            LQM = new LexiconQueryManager(resourcesManager);
        }
        if (SPQM == null) {
            SPQM = new SentencePlanQueryManager(resourcesManager);
        }
        if (NLNQM == null) {
            NLNQM = new NLNameQueryManager(resourcesManager);
        }
        if (OQM == null) {
            OQM = new OrderingQueryManager(resourcesManager);
        }
        if (UMQM == null) {
            UMQM = new UserModelQueryManager(resourcesManager);
        }
        resourcesManager.exportResourcesOntologyTBox((OWLOntology)resourcesOntology);
        LQM.exportLexiconEntries((OWLOntology)resourcesOntology);
        SPQM.exportSentencePlans((OWLOntology)resourcesOntology);
        NLNQM.exportNLNames((OWLOntology)resourcesOntology);
        OQM.exportSections((OWLOntology)resourcesOntology);
        OQM.exportOrders((OWLOntology)resourcesOntology);
        UMQM.exportUserModels((OWLOntology)resourcesOntology);
        try {
            if (NLOwlFile.exists()) {
                FileDocumentTarget fileTarget = new FileDocumentTarget(NLOwlFile);
                OWLFunctionalSyntaxOntologyFormat funSyntaxFormat = new OWLFunctionalSyntaxOntologyFormat();
                funSyntaxFormat.setPrefix(XmlMsgs.prefix, NLResourceManager.nlowlNS);
                resourcesManager.getOntologyManager().saveOntology((OWLOntology)resourcesOntology, (OWLOntologyFormat)funSyntaxFormat, (OWLOntologyDocumentTarget)fileTarget);
                areNLResourcesDirty = false;
                log.info((Object)("Saving NaturalOWL resources to " + NLOwlFile.toURI()));
            } else if (NLOwlFile.createNewFile()) {
                FileDocumentTarget fileTarget = new FileDocumentTarget(NLOwlFile);
                OWLFunctionalSyntaxOntologyFormat funSyntaxFormat = new OWLFunctionalSyntaxOntologyFormat();
                resourcesManager.getOntologyManager().saveOntology((OWLOntology)resourcesOntology, (OWLOntologyFormat)funSyntaxFormat, (OWLOntologyDocumentTarget)fileTarget);
                areNLResourcesDirty = false;
                log.info((Object)("Saving NaturalOWL resources to " + NLOwlFile.toURI()));
            }
        }
        catch (OWLOntologyStorageException e) {
            System.out.println("Could not save ontology: " + e.getMessage());
        }
        catch (IOException e) {
            System.out.println("Could not save ontology: " + e.getMessage());
        }
    }

    public void dirtenOntologies() {
        this.getOWLModelManager().setDirty(this.getOWLModelManager().getActiveOntology());
        areNLResourcesDirty = true;
    }

    static boolean isLegalIRI(IRI entryIRI) {
        try {
            new URI(entryIRI.toString());
        }
        catch (URISyntaxException e) {
            return false;
        }
        return true;
    }

    public boolean isUniqueIRI(IRI entryIRI) {
        if (DefaultResourcesManager.isDefaultResource(entryIRI)) {
            return false;
        }
        if (LQM.isNoun(entryIRI)) {
            return false;
        }
        if (LQM.isAdjective(entryIRI)) {
            return false;
        }
        if (LQM.isVerb(entryIRI)) {
            return false;
        }
        if (SPQM.getSentencePlansList("en").containsSentencePlan(entryIRI)) {
            return false;
        }
        if (SPQM.getSentencePlansList("el").containsSentencePlan(entryIRI)) {
            return false;
        }
        if (NLNQM.getNLNamesList("en").containsNLName(entryIRI)) {
            return false;
        }
        if (NLNQM.getNLNamesList("el").containsNLName(entryIRI)) {
            return false;
        }
        if (OQM.getOrderedSections().contains(entryIRI)) {
            return false;
        }
        return !UMQM.getUserModels().contains(entryIRI);
    }

    protected void disposeOWLView() {
        this.getOWLModelManager().removeOntologyChangeListener(this.changeListener);
        this.getOWLModelManager().removeIOListener(this.ioListener);
    }
}

