/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjective;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryNoun;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounGR;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNArticleSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLNStringSlot;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLGEngine.EnglishArticles;
import gr.aueb.cs.nlg.NLGEngine.GreekArticles;
import gr.aueb.cs.nlg.NLGEngine.SurfaceRealization;
import gr.aueb.cs.nlg.NLOwlPlugin.AppropriatenessDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.ConnectionDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.MyJP;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNameBox;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLEntity;

public class NLNamesTab
extends NaturalOWLTab {
    private static final long serialVersionUID = 8268241587271333587L;
    private ArrayList<NLNameBox> boxes = new ArrayList();
    private ArrayList<JPanel> pluses = new ArrayList();
    private MyJP mainPanel;
    private JScrollPane scroll;
    private JCheckBox aggr;
    private JCheckBox focus;
    private JButton anonymousButton;
    private JButton connectButton;
    private JButton appropButton;
    private static JPanel preview;
    private static JPanel error;
    private NLName loadedName;
    Logger log = Logger.getLogger(NLNamesTab.class);
    private OWLModelManagerListener modelListener;

    protected void initialiseOWLView() throws Exception {
        NLNameSelectionModel.addListener(new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = NLNameSelectionModel.getSelectedEntity();
                NLNamesTab.this.loadedName = NLNQM.getNLName(selected.getIRI());
                if (NLNamesTab.this.loadedName != null) {
                    NLNamesTab.this.checkOrderConsistency(NLNamesTab.this.loadedName);
                    NLNamesTab.this.showNLName(NLNamesTab.this.loadedName);
                    if (DefaultResourcesManager.isDefaultResource(NLNamesTab.this.loadedName.getNLNameIRI())) {
                        NLNamesTab.this.connectButton.setVisible(false);
                        NLNamesTab.this.appropButton.setVisible(false);
                        NLNamesTab.this.aggr.setVisible(false);
                        NLNamesTab.this.focus.setVisible(false);
                    } else {
                        NLNamesTab.this.connectButton.setVisible(true);
                        NLNamesTab.this.appropButton.setVisible(true);
                        NLNamesTab.this.aggr.setVisible(true);
                        NLNamesTab.this.focus.setVisible(true);
                    }
                }
                NLNamesTab.this.validate();
                NLNamesTab.this.repaint();
            }
        });
        this.setLayout(new BorderLayout(10, 10));
        JPanel previewPanel = new JPanel();
        previewPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        previewPanel.setPreferredSize(new Dimension(600, 120));
        previewPanel.setLayout(new BoxLayout(previewPanel, 3));
        JPanel previewLabelPanel = new JPanel(new FlowLayout());
        JLabel previewLabel = new JLabel("NL Name Preview");
        previewLabelPanel.add(previewLabel);
        preview = new JPanel();
        JLabel prevLabel = new JLabel(" ");
        preview.add(prevLabel);
        error = new JPanel();
        JLabel errorLabel = new JLabel(" ");
        error.add(errorLabel);
        JPanel previewButtonPanel = new JPanel(new FlowLayout());
        JButton previewRefreshButton = new JButton("Refresh preview");
        previewRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                NLNamesTab.this.getThis().repaintPreview();
            }
        });
        previewButtonPanel.add(previewRefreshButton);
        previewPanel.add(previewLabelPanel);
        previewPanel.add(preview);
        previewPanel.add(error);
        previewPanel.add(previewButtonPanel);
        this.mainPanel = new MyJP(0, 250);
        this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        this.mainPanel.setLayout(new FlowLayout(0));
        this.scroll = new JScrollPane(this.mainPanel);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(21);
        this.scroll.setViewportView(this.mainPanel);
        this.scroll.setSize(new Dimension(800, 400));
        JPanel subPanel = new JPanel();
        subPanel.setPreferredSize(new Dimension(600, 40));
        subPanel.setLayout(new BorderLayout(50, 50));
        this.anonymousButton = new JButton("Set classes and/or individuals as anonymous...");
        this.anonymousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog dlg = new ConnectionDialog(NLNamesTab.this.thisTab, NLResourceManager.anonymous.getIRI());
                dlg.getResponse();
            }
        });
        this.connectButton = new JButton("Connect current NL Name with classes and/or individuals...");
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConnectionDialog dlg = new ConnectionDialog(NLNamesTab.this.thisTab, NLNamesTab.this.loadedName.getNLNameIRI());
                dlg.getResponse();
            }
        });
        this.appropButton = new JButton("Set NL Name appropriateness...");
        this.appropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppropriatenessDialog dlg = new AppropriatenessDialog(NLNamesTab.this.thisTab, NLNamesTab.this.loadedName.getNLNameIRI());
                dlg.getResponse();
            }
        });
        this.aggr = new JCheckBox("Allow the containing sentence to be aggregated", true);
        this.aggr.addItemListener(this);
        this.focus = new JCheckBox("Causes the focus of the sentence to shift", true);
        this.focus.addItemListener(this);
        this.connectButton.setVisible(false);
        this.appropButton.setVisible(false);
        this.aggr.setVisible(false);
        this.focus.setVisible(false);
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.add(this.anonymousButton);
        buttonsPanel.add(this.connectButton);
        buttonsPanel.add(this.appropButton);
        subPanel.add((Component)buttonsPanel, "Before");
        JPanel checkboxPanel = new JPanel();
        checkboxPanel.setLayout(new BoxLayout(checkboxPanel, 3));
        checkboxPanel.add(this.aggr);
        checkboxPanel.add(this.focus);
        subPanel.add((Component)checkboxPanel, "After");
        this.add(previewPanel, "North");
        this.add(this.scroll, "Center");
        this.add(subPanel, "South");
        this.validate();
        this.repaint();
    }

    public MyJP getMainPanel() {
        return this.mainPanel;
    }

    public static JPanel getPreview() {
        return preview;
    }

    public static JPanel getError() {
        return error;
    }

    public ArrayList<NLNameBox> getBoxes() {
        return this.boxes;
    }

    public ArrayList<NLNSlot> getSlots() {
        return this.loadedName.getSlotsList();
    }

    public void addToBoxes(NLNameBox b) {
        this.boxes.add(b);
        this.repaintPreview();
    }

    public void addToBoxes(int pos, NLNameBox b) {
        this.boxes.add(pos, b);
        this.repaintPreview();
    }

    public void addToSlots(int pos, NLNSlot slot) {
        this.loadedName.getSlotsList().add(pos, slot);
    }

    public void removeFromBoxes(NLNameBox b) {
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get(i).equals(b)) {
                this.boxes.remove(i);
            }
            ++i;
        }
        this.repaintPreview();
    }

    public void removeFromSlots(NLNSlot slot) {
        this.loadedName.getSlotsList().remove(slot);
    }

    public void setSlot(NLNSlot slot, int pos) {
        this.loadedName.getSlotsList().set(pos, slot);
    }

    public NLNamesTab getThis() {
        return this;
    }

    public int getPositionInBoxes(NLNameBox b) {
        boolean flag = false;
        int i = 0;
        while (!flag && i < this.boxes.size()) {
            if (this.boxes.get(i).equals(b)) {
                flag = true;
                continue;
            }
            ++i;
        }
        if (flag) {
            return i;
        }
        return this.boxes.size() - 1;
    }

    public void repaintPreview() {
        NLNamesTab.getPreview().removeAll();
        NLNamesTab.getError().removeAll();
        JLabel prevLabel = new JLabel(this.previewNLName());
        NLNamesTab.getPreview().add(prevLabel);
        if (!this.isHeadSlotDefined()) {
            JLabel errorLabel = new JLabel("No head slot defined!");
            errorLabel.setForeground(new Color(255, 0, 0));
            NLNamesTab.getError().add(errorLabel);
        }
        NLNamesTab.getError().validate();
        NLNamesTab.getError().repaint();
        NLNamesTab.getPreview().validate();
        NLNamesTab.getPreview().repaint();
    }

    public void updateScroll() {
        this.scroll.validate();
        this.scroll.updateUI();
    }

    public void addToPluses(int pos, JPanel pane) {
        this.pluses.add(pos, pane);
    }

    public void removeFromPluses(int pos) {
        this.pluses.remove(pos);
    }

    public int getPlusPosition(JPanel pane) {
        int i = 0;
        while (i < this.pluses.size()) {
            if (this.pluses.get(i).equals(pane)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private void showNLName(NLName name) {
        int i = 0;
        ArrayList<NLNSlot> slots = name.getSlotsList();
        Collections.sort(slots);
        this.clearAllBoxesFromUI();
        for (NLNSlot slot : slots) {
            new NLNameBox(this, slot, name.getLanguage(), i++);
        }
        if (this.loadedName.getAggAllowed()) {
            this.aggr.setSelected(true);
        } else {
            this.aggr.setSelected(false);
        }
        if (this.loadedName.getFocusLost()) {
            this.focus.setSelected(true);
        } else {
            this.focus.setSelected(false);
        }
    }

    private void checkOrderConsistency(NLName name) {
        ArrayList<NLNSlot> slots = name.getSlotsList();
        Collections.sort(slots);
        HashSet<Integer> orders = new HashSet<Integer>();
        for (NLNSlot slot : slots) {
            while (orders.contains(slot.getOrder())) {
                slot.setOrder(slot.getOrder() + 1);
            }
            orders.add(slot.getOrder());
        }
    }

    public void clearAllBoxesFromUI() {
        ArrayList<NLNameBox> toBeRemoved = new ArrayList<NLNameBox>(this.boxes);
        for (NLNameBox box : toBeRemoved) {
            box.delete(box);
        }
        this.mainPanel.removeAll();
    }

    public NLName getLoadedName() {
        return this.loadedName;
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.getOWLModelManager().removeListener(this.modelListener);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.aggr) {
            if (this.aggr.isSelected()) {
                this.loadedName.setAggAllowed(true);
            } else {
                this.loadedName.setAggAllowed(false);
            }
            this.dirtenOntologies();
        } else if (evt.getSource() == this.focus) {
            if (this.focus.isSelected()) {
                this.loadedName.setFocusLost(true);
            } else {
                this.loadedName.setFocusLost(false);
            }
            this.dirtenOntologies();
        }
    }

    public String previewNLName() {
        int j;
        boolean shift;
        String number;
        ArrayList<NLNSlot> slots = new ArrayList<NLNSlot>();
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get((int)i).select.getSelectedIndex() != -1) {
                slots.add(this.boxes.get(i).getSlot());
            }
            ++i;
        }
        Collections.sort(slots);
        ArrayList<String> realizedSlots = new ArrayList<String>();
        ArrayList<String> slotTypes = new ArrayList<String>();
        int i2 = 0;
        while (i2 < slots.size()) {
            String caseType;
            IRI lexiconEntryIRI;
            if (slots.get(i2) instanceof NLNAdjectiveSlot) {
                slotTypes.add("ADJECTIVE");
                NLNAdjectiveSlot adjective = (NLNAdjectiveSlot)slots.get(i2);
                lexiconEntryIRI = adjective.getLexiconEntryIRI();
                if (lexiconEntryIRI != null) {
                    LexEntryAdjective adjectiveEntry;
                    number = "";
                    caseType = "";
                    String gender = "";
                    if (Languages.isGreek(this.loadedName.getLanguage())) {
                        if (adjective.isHead()) {
                            number = adjective.getNumber();
                            caseType = adjective.getCase();
                            gender = adjective.getGender();
                        } else if (adjective.getAgreesWithID() != null) {
                            NLNSlot headSlot = adjective;
                            boolean foundHead = false;
                            NodeID agreeID = adjective.getAgreesWithID();
                            shift = false;
                            while (!foundHead) {
                                j = 0;
                                while (j < slots.size()) {
                                    if (((NLNSlot)slots.get(j)).getId().equals(agreeID)) {
                                        headSlot = (NLNSlot)slots.get(j);
                                        if (headSlot instanceof NLNNounSlot) {
                                            if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                                agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                                shift = true;
                                            } else {
                                                foundHead = true;
                                            }
                                        } else if (headSlot instanceof NLNAdjectiveSlot) {
                                            if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                                agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                                shift = true;
                                            } else {
                                                foundHead = true;
                                            }
                                        }
                                    }
                                    ++j;
                                }
                                if (!shift) break;
                                shift = false;
                            }
                            if (headSlot != null) {
                                if (headSlot instanceof NLNNounSlot) {
                                    number = ((NLNNounSlot)headSlot).getNumber();
                                    caseType = ((NLNNounSlot)headSlot).getCase();
                                    gender = LQM.getNounEntry(((NLNNounSlot)headSlot).getLexiconEntryIRI(), this.loadedName.getLanguage()).getGender();
                                } else if (headSlot instanceof NLNAdjectiveSlot) {
                                    number = ((NLNAdjectiveSlot)headSlot).getNumber();
                                    caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                                    gender = ((NLNAdjectiveSlot)headSlot).getGender();
                                }
                            }
                        } else {
                            number = adjective.getNumber();
                            caseType = adjective.getCase();
                            gender = adjective.getGender();
                        }
                    }
                    if (Languages.isEnglish(this.loadedName.getLanguage())) {
                        adjectiveEntry = (LexEntryAdjectiveEN)LQM.getAdjectiveEntry(lexiconEntryIRI, this.loadedName.getLanguage());
                        if (adjective.isCapitalized()) {
                            realizedSlots.add(SurfaceRealization.capitalizeText(((LexEntryAdjectiveEN)adjectiveEntry).get_form()));
                        } else {
                            realizedSlots.add(((LexEntryAdjectiveEN)adjectiveEntry).get_form());
                        }
                    } else if (Languages.isGreek(this.loadedName.getLanguage())) {
                        adjectiveEntry = (LexEntryAdjectiveGR)LQM.getAdjectiveEntry(lexiconEntryIRI, this.loadedName.getLanguage());
                        if (adjective.isCapitalized()) {
                            realizedSlots.add(SurfaceRealization.capitalizeText(((LexEntryAdjectiveGR)adjectiveEntry).get(gender, number, caseType)));
                        } else {
                            realizedSlots.add(((LexEntryAdjectiveGR)adjectiveEntry).get(gender, number, caseType));
                        }
                    }
                } else {
                    realizedSlots.add("NULL");
                }
            } else if (slots.get(i2) instanceof NLNNounSlot) {
                slotTypes.add("NOUN");
                NLNNounSlot noun = (NLNNounSlot)slots.get(i2);
                lexiconEntryIRI = noun.getLexiconEntryIRI();
                if (lexiconEntryIRI != null) {
                    LexEntryNoun nounEntry;
                    number = "";
                    caseType = "";
                    if (noun.isHead()) {
                        number = noun.getNumber();
                        if (Languages.isGreek(this.loadedName.getLanguage())) {
                            caseType = noun.getCase();
                        }
                    } else if (noun.getAgreesWithID() != null) {
                        NLNSlot headSlot = noun;
                        boolean foundHead = false;
                        NodeID agreeID = noun.getAgreesWithID();
                        boolean shift2 = false;
                        while (!foundHead) {
                            int j2 = 0;
                            while (j2 < slots.size()) {
                                if (((NLNSlot)slots.get(j2)).getId().equals(agreeID)) {
                                    headSlot = (NLNSlot)slots.get(j2);
                                    if (headSlot instanceof NLNNounSlot) {
                                        if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                            shift2 = true;
                                        } else {
                                            foundHead = true;
                                        }
                                    } else if (headSlot instanceof NLNAdjectiveSlot) {
                                        if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                            shift2 = true;
                                        } else {
                                            foundHead = true;
                                        }
                                    }
                                }
                                ++j2;
                            }
                            if (!shift2) break;
                            shift2 = false;
                        }
                        if (headSlot != null) {
                            if (headSlot instanceof NLNNounSlot) {
                                number = ((NLNNounSlot)headSlot).getNumber();
                                if (Languages.isGreek(this.loadedName.getLanguage())) {
                                    caseType = ((NLNNounSlot)headSlot).getCase();
                                }
                            } else if (headSlot instanceof NLNAdjectiveSlot) {
                                number = ((NLNAdjectiveSlot)headSlot).getNumber();
                                if (Languages.isGreek(this.loadedName.getLanguage())) {
                                    caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                                }
                            }
                        }
                    } else {
                        number = noun.getNumber();
                        if (Languages.isGreek(this.loadedName.getLanguage())) {
                            caseType = noun.getCase();
                        }
                    }
                    if (Languages.isEnglish(this.loadedName.getLanguage())) {
                        nounEntry = (LexEntryNounEN)LQM.getNounEntry(lexiconEntryIRI, this.loadedName.getLanguage());
                        if (noun.isCapitalized()) {
                            realizedSlots.add(SurfaceRealization.capitalizeText(((LexEntryNounEN)nounEntry).get("", number)));
                        } else {
                            realizedSlots.add(((LexEntryNounEN)nounEntry).get("", number));
                        }
                    } else if (Languages.isGreek(this.loadedName.getLanguage())) {
                        nounEntry = (LexEntryNounGR)LQM.getNounEntry(lexiconEntryIRI, this.loadedName.getLanguage());
                        if (noun.isCapitalized()) {
                            realizedSlots.add(SurfaceRealization.capitalizeText(((LexEntryNounGR)nounEntry).get(caseType, number)));
                        } else {
                            realizedSlots.add(((LexEntryNounGR)nounEntry).get(caseType, number));
                        }
                    }
                } else {
                    realizedSlots.add("NULL");
                }
            } else if (slots.get(i2) instanceof NLNPrepositionSlot) {
                slotTypes.add("PREP");
                NLNPrepositionSlot preposition = (NLNPrepositionSlot)slots.get(i2);
                realizedSlots.add(preposition.getPrep());
            } else if (slots.get(i2) instanceof NLNStringSlot) {
                slotTypes.add("STRING");
                NLNStringSlot string = (NLNStringSlot)slots.get(i2);
                realizedSlots.add(string.getText());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < slots.size()) {
            if (slots.get(i2) instanceof NLNArticleSlot) {
                slotTypes.add(i2, "ARTICLE");
                NLNArticleSlot article = (NLNArticleSlot)slots.get(i2);
                String realizedArticle = "";
                number = "singular";
                String gender = "masculineOrFeminine";
                String caseType = "nominative";
                if (article.getAgreesWithID() != null) {
                    NLNSlot headSlot = article;
                    boolean foundHead = false;
                    NodeID agreeID = article.getAgreesWithID();
                    shift = false;
                    while (!foundHead) {
                        j = 0;
                        while (j < slots.size()) {
                            if (((NLNSlot)slots.get(j)).getId().equals(agreeID)) {
                                headSlot = (NLNSlot)slots.get(j);
                                if (headSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                        shift = true;
                                        j = 0;
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                        shift = true;
                                        j = 0;
                                    } else {
                                        foundHead = true;
                                    }
                                }
                            }
                            ++j;
                        }
                        if (!shift) break;
                        shift = false;
                    }
                    if (headSlot != null) {
                        if (headSlot instanceof NLNNounSlot) {
                            number = ((NLNNounSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.loadedName.getLanguage())) {
                                gender = LQM.getNounEntry(((NLNNounSlot)headSlot).getLexiconEntryIRI(), this.loadedName.getLanguage()).getGender();
                                caseType = ((NLNNounSlot)headSlot).getCase();
                            }
                        } else if (headSlot instanceof NLNAdjectiveSlot) {
                            number = ((NLNAdjectiveSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.loadedName.getLanguage())) {
                                gender = ((NLNAdjectiveSlot)headSlot).getGender();
                                caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                            }
                        }
                    }
                } else {
                    number = article.getNumber();
                    gender = article.getGender();
                    caseType = article.getCase();
                }
                if (Languages.isEnglish(this.loadedName.getLanguage())) {
                    if (article.isDefinite()) {
                        realizedArticle = EnglishArticles.getDefiniteArticle();
                    } else if (number.equals("singular")) {
                        realizedArticle = i2 < realizedSlots.size() ? EnglishArticles.getIndefiniteArticle((String)realizedSlots.get(i2)) : EnglishArticles.getIndefiniteArticle("");
                    }
                } else if (Languages.isGreek(this.loadedName.getLanguage())) {
                    realizedArticle = article.isDefinite() ? (i2 < realizedSlots.size() ? GreekArticles.getDefiniteArticle(gender, number, caseType, (String)realizedSlots.get(i2)) : GreekArticles.getDefiniteArticle(gender, number, caseType, "")) : GreekArticles.getIndefiniteArticle(gender, number, caseType);
                }
                realizedSlots.add(i2, realizedArticle);
            }
            ++i2;
        }
        String realizedName = "<html>";
        int i3 = 0;
        while (i3 < realizedSlots.size()) {
            realizedName = String.valueOf(realizedName) + " [ " + (String)realizedSlots.get(i3) + " <sub>" + (String)slotTypes.get(i3) + "</sub>" + " ] ";
            ++i3;
        }
        realizedName = String.valueOf(realizedName) + "</html>";
        return realizedName.trim();
    }

    public boolean isHeadSlotDefined() {
        ArrayList<NLNSlot> slots = new ArrayList<NLNSlot>();
        int i = 0;
        while (i < this.boxes.size()) {
            if (this.boxes.get((int)i).select.getSelectedIndex() != -1) {
                slots.add(this.boxes.get(i).getSlot());
            }
            ++i;
        }
        boolean headSlotDefined = false;
        int i2 = 0;
        while (i2 < slots.size()) {
            if (slots.get(i2) instanceof NLNAdjectiveSlot) {
                if (((NLNAdjectiveSlot)slots.get(i2)).isHead()) {
                    headSlotDefined = true;
                }
            } else if (slots.get(i2) instanceof NLNNounSlot && ((NLNNounSlot)slots.get(i2)).isHead()) {
                headSlotDefined = true;
            }
            ++i2;
        }
        return headSlotDefined;
    }
}

