/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.LexEntryNoun;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNArticleSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLNStringSlot;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.ListRenderer;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNamesTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SentencePlanTab;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.semanticweb.owlapi.model.IRI;

class NLNameBox
implements ItemListener,
FocusListener,
DocumentListener {
    static final String articleSlotStr = "Article";
    static final String adjectiveSlotStr = "Adjective";
    static final String nounSlotStr = "Noun";
    static final String prepositionSlotStr = "Preposition";
    static final String stringSlotStr = "String";
    String language;
    JPanel buttonsPanel;
    JPanel box = new JPanel();
    JPanel dynamicPanel;
    JPanel orderPanel;
    JButton del;
    JComboBox<String> select;
    JButton left;
    JButton right;
    int pos;
    JCheckBox definiteCheck;
    JLabel artCaseLabel;
    JLabel artGenderLabel;
    JLabel artNumLabel;
    JComboBox<String> artCaseCombo;
    JComboBox<String> artGenderCombo;
    JComboBox<String> artNumCombo;
    JComboBox artAgreeWithCombo;
    DefaultComboBoxModel artAgreeWithSlotModel;
    JCheckBox adjHeadCheck;
    JCheckBox adjCapitalCheck;
    JLabel adjCaseLabel;
    JLabel adjGenderLabel;
    JLabel adjNumLabel;
    JComboBox adjCaseCombo;
    JComboBox adjGenderCombo;
    JComboBox adjNumCombo;
    JComboBox adjLECombo;
    JComboBox adjAgreeWithCombo;
    DefaultComboBoxModel adjAgreeWithSlotModel;
    JCheckBox nounHeadCheck;
    JCheckBox nounCapitalCheck;
    JLabel nounCaseLabel;
    JLabel nounNumLabel;
    JComboBox nounCaseCombo;
    JComboBox nounNumCombo;
    JComboBox nounLECombo;
    JComboBox nounAgreeWithCombo;
    DefaultComboBoxModel nounAgreeWithSlotModel;
    JTextArea stringTextArea;
    JComboBox prepLECombo;
    JLabel orderLabel;
    String lastOpenSlotTab = "";
    NLNamesTab father = null;
    NLNSlot slot = null;

    NLNameBox(NLNamesTab f, NLNSlot slot, String lang, int pos) {
        this.father = f;
        this.slot = slot;
        this.pos = pos;
        this.language = lang;
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setPreferredSize(new Dimension(220, 30));
        this.buttonsPanel.setLayout(new FlowLayout(3, 0, 1));
        this.box.add(this.buttonsPanel);
        this.box.setPreferredSize(new Dimension(225, 330));
        this.box.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        String[] choices = new String[]{articleSlotStr, adjectiveSlotStr, nounSlotStr, prepositionSlotStr, stringSlotStr};
        this.select = new JComboBox<String>(choices);
        this.select.setEditable(false);
        this.select.setVisible(true);
        this.buttonsPanel.add(this.select);
        this.dynamicPanel = new JPanel();
        this.dynamicPanel.setLayout(new CardLayout());
        this.dynamicPanel.setPreferredSize(new Dimension(200, 250));
        this.box.add(this.dynamicPanel);
        this.orderPanel = new JPanel();
        this.orderPanel.setPreferredSize(new Dimension(220, 30));
        this.orderPanel.setLayout(new FlowLayout(3, 0, 1));
        this.box.add(this.orderPanel);
        this.orderLabel = new JLabel("Slot order: " + slot.getOrder());
        this.orderPanel.add(this.orderLabel);
        this.father.addToBoxes(pos, this);
        this.dynamicPanels();
        this.addMoveArrows(this);
        this.addDeleteButton();
        this.father.getMainPanel().increaseWidth(225);
        this.father.updateScroll();
        this.father.getMainPanel().add((Component)this.box, pos * 2);
        this.loadSlotInBox(slot);
        this.createPlus();
        this.updateAll();
    }

    void createPlus() {
        final JPanel p = new JPanel();
        p.setPreferredSize(new Dimension(40, 250));
        p.setLayout(new BoxLayout(p, 2));
        ClassLoader loader = NLNamesTab.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/plusImg.png");
        ImageIcon plusIcon = new ImageIcon(imageURL);
        Image img = plusIcon.getImage();
        Image newimg = img.getScaledInstance(25, 25, 4);
        plusIcon = new ImageIcon(newimg);
        JButton plus = new JButton(plusIcon);
        plus.setOpaque(false);
        plus.setContentAreaFilled(false);
        plus.setBorderPainted(false);
        p.add(plus);
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int pos = NLNameBox.this.father.getPlusPosition(p);
                NLNArticleSlot slot = new NLNArticleSlot(false, "nominative", "masculine", "singular", null, NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(NLNameBox.this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + (pos + 2)).getID(), pos + 2);
                NLNameBox.this.father.addToSlots(pos + 1, slot);
                int j = pos + 1;
                while (j < NLNameBox.this.father.getBoxes().size()) {
                    NLNameBox.this.father.getBoxes().get(j).getSlot().increaseOrder();
                    NLNameBox.this.father.getBoxes().get(j).getSlot().setId(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(NLNameBox.this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + NLNameBox.this.father.getBoxes().get(j).getSlot().getOrder()).getID());
                    ++j;
                }
                j = NLNameBox.this.father.getBoxes().size() - 1;
                while (j >= pos + 1) {
                    NLNSlot incSlot = NLNameBox.this.father.getBoxes().get(j).getSlot();
                    if (incSlot instanceof NLNArticleSlot || incSlot instanceof NLNAdjectiveSlot || incSlot instanceof NLNNounSlot) {
                        int f = 0;
                        while (f < NLNameBox.this.father.getBoxes().size()) {
                            ArrayList<DefaultComboBoxModel> mdls = NLNameBox.this.father.getBoxes().get(f).getAgreeWithSlotModels();
                            for (DefaultComboBoxModel mdl : mdls) {
                                if (mdl.getIndexOf(incSlot.getOrder() - 1) == -1) continue;
                                mdl.addElement(incSlot.getOrder());
                                if (!mdl.getSelectedItem().equals("none") && (Integer)mdl.getSelectedItem() == incSlot.getOrder() - 1) {
                                    mdl.setSelectedItem(incSlot.getOrder());
                                }
                                mdl.removeElement(incSlot.getOrder() - 1);
                            }
                            ++f;
                        }
                    }
                    NLNameBox.this.father.getBoxes().get(j).updateOrderLabel();
                    --j;
                }
                NLNameBox newBox = new NLNameBox(NLNameBox.this.father, slot, NLNameBox.this.language, pos + 1);
                NLNameBox.this.updatePositions();
                int j2 = 0;
                while (j2 < NLNameBox.this.father.getBoxes().size()) {
                    NLNameBox.this.addMoveArrows(NLNameBox.this.father.getBoxes().get(j2));
                    NLNameBox.this.father.getBoxes().get(j2).addDeleteButton();
                    ++j2;
                }
                NLNameBox.this.father.getMainPanel().validate();
                NLNameBox.this.father.updateScroll();
                NLNameBox.this.father.dirtenOntologies();
            }
        });
        this.father.getMainPanel().increaseWidth(60);
        this.father.updateScroll();
        this.updatePositions();
        this.father.addToPluses(this.getThis().pos, p);
        int position = this.father.getPositionInBoxes(this.getThis()) * 2 + 1;
        this.father.getMainPanel().add((Component)p, position);
        this.father.getMainPanel().validate();
    }

    void switchBoxes(int i) {
        ArrayList<DefaultComboBoxModel> mdls;
        int f;
        NLNameBox a = this.father.getBoxes().get(i - 1);
        NLNameBox b = this.father.getBoxes().get(i);
        this.father.removeFromBoxes(a);
        this.father.removeFromBoxes(b);
        this.father.addToBoxes(i - 1, b);
        this.father.addToBoxes(i, a);
        NLNSlot aSlot = a.getSlot();
        NLNSlot bSlot = b.getSlot();
        this.father.removeFromSlots(aSlot);
        this.father.removeFromSlots(bSlot);
        int aOrder = aSlot.getOrder();
        int bOrder = bSlot.getOrder();
        if (aSlot instanceof NLNAdjectiveSlot || aSlot instanceof NLNNounSlot) {
            f = 0;
            while (f < this.father.getBoxes().size()) {
                mdls = this.father.getBoxes().get(f).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(aSlot.getOrder()) == -1) continue;
                    mdl.addElement(bOrder);
                    if (!mdl.getSelectedItem().equals("none") && ((Integer)mdl.getSelectedItem()).intValue() == aSlot.getOrder()) {
                        mdl.setSelectedItem(bOrder);
                    }
                    mdl.removeElement(aSlot.getOrder());
                }
                ++f;
            }
        }
        if (bSlot instanceof NLNAdjectiveSlot || bSlot instanceof NLNNounSlot) {
            f = 0;
            while (f < this.father.getBoxes().size()) {
                mdls = this.father.getBoxes().get(f).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(bSlot.getOrder()) == -1) continue;
                    mdl.addElement(aOrder);
                    if (!mdl.getSelectedItem().equals("none") && ((Integer)mdl.getSelectedItem()).intValue() == bSlot.getOrder()) {
                        mdl.setSelectedItem(aOrder);
                    }
                    mdl.removeElement(bSlot.getOrder());
                }
                ++f;
            }
        }
        aSlot.setId(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + bOrder).getID());
        aSlot.setOrder(bOrder);
        bSlot.setId(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + aOrder).getID());
        bSlot.setOrder(aOrder);
        this.father.addToSlots(i - 1, bSlot);
        this.father.addToSlots(i, aSlot);
        a.updateOrderLabel();
        b.updateOrderLabel();
        this.father.repaintPreview();
        this.father.dirtenOntologies();
    }

    void addDeleteButton() {
        if (this.del == null) {
            ClassLoader loader = NLNamesTab.class.getClassLoader();
            URL imageURL = loader.getResource("/icons/deleteImg.png");
            ImageIcon delIcon = new ImageIcon(imageURL);
            Image img = delIcon.getImage();
            Image newimg = img.getScaledInstance(20, 20, 4);
            delIcon = new ImageIcon(newimg);
            this.del = new JButton(delIcon);
            this.del.setOpaque(false);
            this.del.setContentAreaFilled(false);
            this.del.setBorderPainted(false);
            String t = "Are you sure you want to delete this?";
            final String title = new String(t);
            this.del.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int ans = JOptionPane.showConfirmDialog(null, title, "Delete?", 2);
                    if (ans == 0) {
                        int position = NLNameBox.this.father.getPositionInBoxes(NLNameBox.this.getThis()) + 1;
                        NLNameBox.this.father.removeFromPluses(position - 1);
                        int j = position;
                        while (j < NLNameBox.this.father.getBoxes().size()) {
                            NLNameBox.this.father.getBoxes().get(j).getSlot().decreaseOrder();
                            NLNameBox.this.father.getBoxes().get(j).getSlot().setId(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(NLNameBox.this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + NLNameBox.this.father.getBoxes().get(j).getSlot().getOrder()).getID());
                            ++j;
                        }
                        if (NLNameBox.this.getThis().slot instanceof NLNAdjectiveSlot || NLNameBox.this.getThis().slot instanceof NLNNounSlot) {
                            int f = 0;
                            while (f < NLNameBox.this.father.getBoxes().size()) {
                                ArrayList<DefaultComboBoxModel> mdls = NLNameBox.this.father.getBoxes().get(f).getAgreeWithSlotModels();
                                for (DefaultComboBoxModel mdl : mdls) {
                                    if (mdl.getIndexOf(NLNameBox.this.getThis().getSlot().getOrder()) == -1) continue;
                                    if (!mdl.getSelectedItem().equals("none") && ((Integer)mdl.getSelectedItem()).intValue() == NLNameBox.this.getThis().getSlot().getOrder()) {
                                        mdl.setSelectedItem("none");
                                    }
                                    mdl.removeElement(NLNameBox.this.getThis().getSlot().getOrder());
                                }
                                ++f;
                            }
                        }
                        NLNameBox.this.father.removeFromSlots(NLNameBox.this.getThis().slot);
                        NLNameBox.this.delete(NLNameBox.this.getThis());
                        j = position - 1;
                        while (j < NLNameBox.this.father.getBoxes().size()) {
                            NLNSlot decSlot = NLNameBox.this.father.getBoxes().get(j).getSlot();
                            if (decSlot instanceof NLNAdjectiveSlot || decSlot instanceof NLNNounSlot) {
                                int f = 0;
                                while (f < NLNameBox.this.father.getBoxes().size()) {
                                    ArrayList<DefaultComboBoxModel> mdls = NLNameBox.this.father.getBoxes().get(f).getAgreeWithSlotModels();
                                    for (DefaultComboBoxModel mdl : mdls) {
                                        if (mdl.getIndexOf(decSlot.getOrder() + 1) == -1) continue;
                                        mdl.addElement(decSlot.getOrder());
                                        if (!mdl.getSelectedItem().equals("none") && (Integer)mdl.getSelectedItem() == decSlot.getOrder() + 1) {
                                            mdl.setSelectedItem(decSlot.getOrder());
                                        }
                                        mdl.removeElement(decSlot.getOrder() + 1);
                                    }
                                    ++f;
                                }
                            }
                            NLNameBox.this.father.getBoxes().get(j).updateOrderLabel();
                            ++j;
                        }
                        NLNameBox.this.father.dirtenOntologies();
                    }
                }
            });
            this.buttonsPanel.add((Component)this.del, 0);
            this.buttonsPanel.validate();
        }
        if (this.father.getBoxes().size() > 1) {
            this.del.setEnabled(true);
        } else {
            this.del.setEnabled(false);
        }
    }

    void addMoveArrows(NLNameBox b) {
        Image newimg;
        Image img;
        URL imageURL;
        ClassLoader loader;
        int pos;
        if (b.left != null) {
            b.buttonsPanel.remove(b.left);
        }
        if (b.right != null) {
            b.buttonsPanel.remove(b.right);
        }
        if ((pos = this.father.getPositionInBoxes(b)) > 0) {
            loader = NLNamesTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/leftImg.png");
            ImageIcon leftIcon = new ImageIcon(imageURL);
            img = leftIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            leftIcon = new ImageIcon(newimg);
            b.left = new JButton(leftIcon);
            b.left.setOpaque(false);
            b.left.setContentAreaFilled(false);
            b.left.setBorderPainted(false);
            b.left.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NLNameBox leftBox = NLNameBox.this.father.getBoxes().get(pos - 1);
                    NLNameBox thisBox = NLNameBox.this.father.getBoxes().get(pos);
                    NLNameBox.this.father.getMainPanel().switchOrder(pos * 2);
                    NLNameBox.this.switchBoxes(pos);
                    NLNameBox.this.updatePositions();
                    NLNameBox.this.addMoveArrows(leftBox);
                    NLNameBox.this.addMoveArrows(thisBox);
                    leftBox.box.repaint();
                    thisBox.box.repaint();
                    NLNameBox.this.father.getMainPanel().validate();
                    NLNameBox.this.father.getMainPanel().repaint();
                }
            });
            b.left.setVisible(true);
            b.buttonsPanel.add(b.left);
        }
        if (pos < this.father.getBoxes().size() - 1) {
            loader = NLNamesTab.class.getClassLoader();
            imageURL = loader.getResource("/icons/rightImg.png");
            ImageIcon rightIcon = new ImageIcon(imageURL);
            img = rightIcon.getImage();
            newimg = img.getScaledInstance(20, 20, 4);
            rightIcon = new ImageIcon(newimg);
            b.right = new JButton(rightIcon);
            b.right.setOpaque(false);
            b.right.setContentAreaFilled(false);
            b.right.setBorderPainted(false);
            b.right.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NLNameBox thisBox = NLNameBox.this.father.getBoxes().get(pos);
                    NLNameBox rightBox = NLNameBox.this.father.getBoxes().get(pos + 1);
                    NLNameBox.this.father.getMainPanel().switchOrder(pos * 2 + 2);
                    NLNameBox.this.switchBoxes(pos + 1);
                    NLNameBox.this.updatePositions();
                    NLNameBox.this.addMoveArrows(thisBox);
                    NLNameBox.this.addMoveArrows(rightBox);
                    thisBox.box.repaint();
                    rightBox.box.repaint();
                    NLNameBox.this.father.getMainPanel().validate();
                    NLNameBox.this.father.getMainPanel().repaint();
                }
            });
            b.right.setVisible(true);
            b.buttonsPanel.add(b.right);
        }
        b.buttonsPanel.validate();
        b.box.validate();
        b.box.repaint();
    }

    void delete(NLNameBox b) {
        this.father.getMainPanel().decreaseWidth(285);
        this.father.updateScroll();
        int pos = this.father.getPositionInBoxes(b);
        this.father.getMainPanel().remove(b.box);
        if (pos != 0 || this.father.getBoxes().size() != 1) {
            this.father.getMainPanel().remove(this.father.getMainPanel().getComponent(pos * 2));
        }
        this.father.getMainPanel().validate();
        this.father.getMainPanel().repaint();
        int i = 0;
        while (i < this.father.getBoxes().size()) {
            if (this.father.getBoxes().get(i).equals(b)) {
                this.father.removeFromBoxes(b);
            }
            ++i;
        }
        this.updatePositions();
        this.updateAll();
    }

    void updatePositions() {
        int i = 0;
        while (i < this.father.getBoxes().size()) {
            this.father.getBoxes().get(i).setPosition(i);
            ++i;
        }
    }

    NLNameBox getThis() {
        return this;
    }

    void setPosition(int i) {
        this.pos = i;
    }

    void updateAll() {
        int i = 0;
        while (i < this.father.getBoxes().size()) {
            this.addMoveArrows(this.father.getBoxes().get(i));
            this.father.getBoxes().get(i).addDeleteButton();
            ++i;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.select) {
            String option = (String)evt.getItem();
            if (option.equals(articleSlotStr)) {
                this.slot = new NLNArticleSlot(false, "nominative", "masculine", "singular", null, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(adjectiveSlotStr)) {
                this.slot = new NLNAdjectiveSlot(null, "nominative", "masculine", "singular", false, false, null, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(nounSlotStr)) {
                this.slot = new NLNNounSlot(null, "nominative", "singular", false, false, null, this.slot.getId(), this.slot.getOrder());
            } else if (option.equals(prepositionSlotStr)) {
                if (this.language.equals("en")) {
                    this.slot = new NLNPrepositionSlot("after", this.slot.getId(), this.slot.getOrder());
                } else if (this.language.equals("el")) {
                    this.slot = new NLNPrepositionSlot("\u03b1\u03c0\u03cc", this.slot.getId(), this.slot.getOrder());
                }
            } else if (option.equals(stringSlotStr)) {
                this.slot = new NLNStringSlot("", this.slot.getId(), this.slot.getOrder());
            }
            this.father.setSlot(this.slot, this.pos);
            this.loadSlotInBox(this.slot);
        } else if (evt.getSource() == this.definiteCheck) {
            if (this.definiteCheck.isSelected()) {
                ((NLNArticleSlot)this.slot).setDefinite(true);
            } else {
                ((NLNArticleSlot)this.slot).setDefinite(false);
            }
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.artCaseCombo) {
            ((NLNArticleSlot)this.slot).setCase(this.artCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.artGenderCombo) {
            ((NLNArticleSlot)this.slot).setGender(this.artGenderCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.artNumCombo) {
            ((NLNArticleSlot)this.slot).setNumber(this.artNumCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.artAgreeWithCombo) {
            if (this.artAgreeWithCombo.getSelectedItem().equals("none")) {
                ((NLNArticleSlot)this.slot).setAgreesWithID(null);
                this.father.dirtenOntologies();
                if (this.language.equals("el")) {
                    this.artCaseCombo.setEnabled(true);
                    if (this.artCaseCombo.getSelectedIndex() == -1) {
                        this.artCaseCombo.setSelectedIndex(0);
                    }
                    this.artCaseCombo.addItemListener(this);
                    this.artGenderCombo.setEnabled(true);
                    if (this.artGenderCombo.getSelectedIndex() == -1) {
                        this.artGenderCombo.setSelectedIndex(0);
                    }
                    this.artGenderCombo.addItemListener(this);
                }
                this.artNumCombo.setEnabled(true);
                if (this.artNumCombo.getSelectedIndex() == -1) {
                    this.artNumCombo.setSelectedIndex(0);
                }
                this.artNumCombo.addItemListener(this);
            } else {
                ((NLNArticleSlot)this.slot).setAgreesWithID(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + this.artAgreeWithCombo.getSelectedItem().toString()).getID());
                this.father.dirtenOntologies();
                if (this.language.equals("el")) {
                    this.artCaseCombo.setEnabled(false);
                    this.artCaseCombo.removeItemListener(this);
                    this.artGenderCombo.setEnabled(false);
                    this.artGenderCombo.removeItemListener(this);
                }
                this.artNumCombo.setEnabled(false);
                this.artNumCombo.removeItemListener(this);
            }
        } else if (evt.getSource() == this.adjLECombo) {
            ((NLNAdjectiveSlot)this.slot).setLexiconEntryIRI(((ListIRI)this.adjLECombo.getSelectedItem()).getEntryIRI());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjHeadCheck) {
            if (this.adjHeadCheck.isSelected()) {
                this.setAdjectiveHead(true);
                ((NLNAdjectiveSlot)this.slot).setAgreesWithID(null);
                int j = 0;
                while (j < this.father.getBoxes().size()) {
                    NLNameBox neighborBox = this.father.getBoxes().get(j);
                    if (neighborBox.getSlot().getOrder() != this.slot.getOrder()) {
                        if (neighborBox.getSlot() instanceof NLNAdjectiveSlot) {
                            neighborBox.setAdjectiveHead(false);
                        } else if (neighborBox.getSlot() instanceof NLNNounSlot) {
                            neighborBox.setNounHead(false);
                        }
                    }
                    ++j;
                }
            } else {
                this.setAdjectiveHead(false);
            }
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjCapitalCheck) {
            ((NLNAdjectiveSlot)this.slot).setCapitalized(this.adjCapitalCheck.isSelected());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjCaseCombo) {
            ((NLNAdjectiveSlot)this.slot).setCase(this.adjCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjGenderCombo) {
            ((NLNAdjectiveSlot)this.slot).setGender(this.adjGenderCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjNumCombo) {
            ((NLNAdjectiveSlot)this.slot).setNumber(this.adjNumCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.adjAgreeWithCombo) {
            if (this.adjAgreeWithCombo.getSelectedItem() != null) {
                if (this.adjAgreeWithCombo.getSelectedItem().equals("none")) {
                    ((NLNAdjectiveSlot)this.slot).setAgreesWithID(null);
                    this.father.dirtenOntologies();
                    if (this.language.equals("el")) {
                        this.adjCaseCombo.setEnabled(true);
                        if (this.adjCaseCombo.getSelectedIndex() == -1) {
                            this.adjCaseCombo.setSelectedIndex(0);
                        }
                        this.adjCaseCombo.addItemListener(this);
                        this.adjGenderCombo.setEnabled(true);
                        if (this.adjGenderCombo.getSelectedIndex() == -1) {
                            this.adjGenderCombo.setSelectedIndex(0);
                        }
                        this.adjGenderCombo.addItemListener(this);
                    }
                    this.adjNumCombo.setEnabled(true);
                    if (this.adjNumCombo.getSelectedIndex() == -1) {
                        this.adjNumCombo.setSelectedIndex(0);
                    }
                    this.adjNumCombo.addItemListener(this);
                } else {
                    HashSet<NLNSlot> slots = new HashSet<NLNSlot>();
                    slots.add(this.slot);
                    if (this.agreeCycleExists(slots, Integer.parseInt(this.adjAgreeWithCombo.getSelectedItem().toString()))) {
                        this.adjAgreeWithCombo.setSelectedItem("none");
                        JOptionPane.showMessageDialog(null, "Cyclic agreement between slots.", "Error", 0);
                    } else {
                        ((NLNAdjectiveSlot)this.slot).setAgreesWithID(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + this.adjAgreeWithCombo.getSelectedItem().toString()).getID());
                        this.father.dirtenOntologies();
                        if (this.language.equals("el")) {
                            this.adjCaseCombo.setEnabled(false);
                            this.adjCaseCombo.removeItemListener(this);
                            this.adjGenderCombo.setEnabled(false);
                            this.adjGenderCombo.removeItemListener(this);
                        }
                        this.adjNumCombo.setEnabled(false);
                        this.adjNumCombo.removeItemListener(this);
                    }
                }
            }
        } else if (evt.getSource() == this.nounLECombo) {
            ((NLNNounSlot)this.slot).setLexiconEntryIRI(((ListIRI)this.nounLECombo.getSelectedItem()).getEntryIRI());
            LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((NLNNounSlot)this.slot).getLexiconEntryIRI(), this.language);
            this.nounNumCombo.setEnabled(true);
            if (entry.getNumber().equals("singular")) {
                this.nounNumCombo.setSelectedItem("singular");
                this.nounNumCombo.setEnabled(false);
            } else if (entry.getNumber().equals("plural")) {
                this.nounNumCombo.setSelectedItem("plural");
                this.nounNumCombo.setEnabled(false);
            }
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounHeadCheck) {
            if (this.nounHeadCheck.isSelected()) {
                this.setNounHead(true);
                ((NLNNounSlot)this.slot).setAgreesWithID(null);
                int j = 0;
                while (j < this.father.getBoxes().size()) {
                    NLNameBox neighborBox = this.father.getBoxes().get(j);
                    if (neighborBox.getSlot().getOrder() != this.slot.getOrder()) {
                        if (neighborBox.getSlot() instanceof NLNAdjectiveSlot) {
                            neighborBox.setAdjectiveHead(false);
                        } else if (neighborBox.getSlot() instanceof NLNNounSlot) {
                            neighborBox.setNounHead(false);
                        }
                    }
                    ++j;
                }
            } else {
                this.setNounHead(false);
            }
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounCapitalCheck) {
            ((NLNNounSlot)this.slot).setCapitalized(this.nounCapitalCheck.isSelected());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounCaseCombo) {
            ((NLNNounSlot)this.slot).setCase(this.nounCaseCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounNumCombo) {
            ((NLNNounSlot)this.slot).setNumber(this.nounNumCombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        } else if (evt.getSource() == this.nounAgreeWithCombo) {
            if (this.nounAgreeWithCombo.getSelectedItem() != null) {
                if (this.nounAgreeWithCombo.getSelectedItem().equals("none")) {
                    ((NLNNounSlot)this.slot).setAgreesWithID(null);
                    this.father.dirtenOntologies();
                    if (this.language.equals("el")) {
                        this.nounCaseCombo.setEnabled(true);
                        if (this.nounCaseCombo.getSelectedIndex() == -1) {
                            this.nounCaseCombo.setSelectedIndex(0);
                        }
                        this.nounCaseCombo.addItemListener(this);
                    }
                    this.nounNumCombo.setEnabled(true);
                    if (this.nounNumCombo.getSelectedIndex() == -1) {
                        this.nounNumCombo.setSelectedIndex(0);
                    }
                    this.nounNumCombo.addItemListener(this);
                } else {
                    HashSet<NLNSlot> slots = new HashSet<NLNSlot>();
                    slots.add(this.slot);
                    if (this.agreeCycleExists(slots, Integer.parseInt(this.nounAgreeWithCombo.getSelectedItem().toString()))) {
                        this.nounAgreeWithCombo.setSelectedItem("none");
                        JOptionPane.showMessageDialog(null, "Cyclic agreement between slots.", "Error", 0);
                    } else {
                        ((NLNNounSlot)this.slot).setAgreesWithID(NLNamesTab.NLNQM.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(this.father.getLoadedName().getNLNameIRI().getFragment()) + "_" + "slot" + this.nounAgreeWithCombo.getSelectedItem().toString()).getID());
                        this.father.dirtenOntologies();
                        if (this.language.equals("el")) {
                            this.nounCaseCombo.setEnabled(false);
                            this.nounCaseCombo.removeItemListener(this);
                        }
                        this.nounNumCombo.setEnabled(false);
                        this.nounNumCombo.removeItemListener(this);
                    }
                }
            }
        } else if (evt.getSource() == this.prepLECombo) {
            ((NLNPrepositionSlot)this.slot).setPrep(this.prepLECombo.getSelectedItem().toString());
            this.father.dirtenOntologies();
        }
    }

    void dynamicPanels() {
        JPanel articleCard = new JPanel();
        JPanel articleCardSub1 = new JPanel();
        JPanel articleCardSub2 = new JPanel();
        JPanel articleCardSub3 = new JPanel();
        JPanel articleCardSub4 = new JPanel();
        JPanel articleCardSub5 = new JPanel();
        JPanel adjectiveCard = new JPanel();
        JPanel adjectiveCardSub1 = new JPanel();
        JPanel adjectiveCardSub2 = new JPanel();
        JPanel adjectiveCardSub3 = new JPanel();
        JPanel adjectiveCardSub4 = new JPanel();
        JPanel adjectiveCardSub5 = new JPanel();
        JPanel adjectiveCardSub6 = new JPanel();
        JPanel adjectiveCardSub7 = new JPanel();
        JPanel nounCard = new JPanel();
        JPanel nounCardSub1 = new JPanel();
        JPanel nounCardSub2 = new JPanel();
        JPanel nounCardSub3 = new JPanel();
        JPanel nounCardSub4 = new JPanel();
        JPanel nounCardSub5 = new JPanel();
        JPanel nounCardSub6 = new JPanel();
        JPanel stringCard = new JPanel();
        JPanel stringCardSub1 = new JPanel();
        JPanel prepositionCard = new JPanel();
        JPanel prepositionCardSub1 = new JPanel();
        articleCard.setLayout(new GridLayout(8, 0));
        articleCardSub1.setLayout(new FlowLayout(0));
        articleCardSub2.setLayout(new FlowLayout(0));
        articleCardSub3.setLayout(new FlowLayout(0));
        articleCardSub4.setLayout(new FlowLayout(0));
        articleCardSub5.setLayout(new FlowLayout(0));
        adjectiveCard.setLayout(new GridLayout(8, 0));
        adjectiveCardSub1.setLayout(new FlowLayout(0));
        adjectiveCardSub2.setLayout(new FlowLayout(0));
        adjectiveCardSub3.setLayout(new FlowLayout(0));
        adjectiveCardSub4.setLayout(new FlowLayout(0));
        adjectiveCardSub5.setLayout(new FlowLayout(0));
        adjectiveCardSub6.setLayout(new FlowLayout(0));
        adjectiveCardSub7.setLayout(new FlowLayout(0));
        nounCard.setLayout(new GridLayout(8, 0));
        nounCardSub1.setLayout(new FlowLayout(0));
        nounCardSub2.setLayout(new FlowLayout(0));
        nounCardSub3.setLayout(new FlowLayout(0));
        nounCardSub4.setLayout(new FlowLayout(0));
        nounCardSub5.setLayout(new FlowLayout(0));
        nounCardSub6.setLayout(new FlowLayout(0));
        stringCard.setLayout(new GridLayout(0, 1));
        stringCardSub1.setLayout(new BorderLayout());
        prepositionCard.setLayout(new GridLayout(8, 0));
        prepositionCardSub1.setLayout(new FlowLayout(0));
        this.definiteCheck = new JCheckBox("Definite", false);
        articleCardSub1.add(this.definiteCheck);
        articleCard.add(articleCardSub1);
        if (this.language.equals("el")) {
            this.artCaseLabel = new JLabel("Case");
            String[] cases = new String[]{"nominative", "genitive", "accusative"};
            this.artCaseCombo = new JComboBox<String>(cases);
            articleCardSub2.add(this.artCaseLabel);
            articleCardSub2.add(this.artCaseCombo);
            articleCard.add(articleCardSub2);
            this.artGenderLabel = new JLabel("Gender");
            String[] genders = new String[]{"masculine", "feminine", "neuter", "masculineOrFeminine"};
            this.artGenderCombo = new JComboBox<String>(genders);
            articleCardSub3.add(this.artGenderLabel);
            articleCardSub3.add(this.artGenderCombo);
            articleCard.add(articleCardSub3);
        }
        this.artNumLabel = new JLabel("Number");
        String[] numbers = new String[]{"singular", "plural"};
        this.artNumCombo = new JComboBox<String>(numbers);
        articleCardSub4.add(this.artNumLabel);
        articleCardSub4.add(this.artNumCombo);
        articleCard.add(articleCardSub4);
        this.artAgreeWithSlotModel = new DefaultComboBoxModel();
        this.artAgreeWithSlotModel.addElement("none");
        int j = 0;
        while (j < this.father.getBoxes().size()) {
            NLNSlot s = this.father.getBoxes().get(j).getSlot();
            if (s instanceof NLNAdjectiveSlot || s instanceof NLNNounSlot) {
                this.artAgreeWithSlotModel.addElement(s.getOrder());
            }
            ++j;
        }
        JLabel artAgreeWithLabel = new JLabel("Agree with slot ");
        this.artAgreeWithCombo = new JComboBox(this.artAgreeWithSlotModel);
        articleCardSub5.add(artAgreeWithLabel);
        articleCardSub5.add(this.artAgreeWithCombo);
        articleCard.add(articleCardSub5);
        Dimension labelD = this.artNumLabel.getPreferredSize();
        Dimension comboD = this.artNumCombo.getPreferredSize();
        int boxLabelWidth = 85;
        int boxComboWidth = 105;
        if (this.language.equals("el")) {
            this.artCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
            this.artGenderLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        }
        this.artNumLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        artAgreeWithLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        if (this.language.equals("el")) {
            this.artCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
            this.artGenderCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        }
        this.artNumCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.artAgreeWithCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        JLabel adjLELabel = new JLabel("Lexicon Entry");
        this.adjHeadCheck = new JCheckBox("Head Adjective", false);
        adjectiveCardSub1.add(this.adjHeadCheck);
        adjectiveCard.add(adjectiveCardSub1);
        this.adjCapitalCheck = new JCheckBox("Capitalized", false);
        adjectiveCardSub2.add(this.adjCapitalCheck);
        adjectiveCard.add(adjectiveCardSub2);
        HashSet<ListIRI> adjLexiconEntries = new HashSet<ListIRI>();
        for (IRI iri : SentencePlanTab.LQM.getAdjectiveEntries()) {
            adjLexiconEntries.add(new ListIRI(iri));
        }
        ArrayList sortedList = new ArrayList(adjLexiconEntries);
        Collections.sort(sortedList);
        this.adjLECombo = new JComboBox<Object>(sortedList.toArray());
        this.adjLECombo.setRenderer(new ListRenderer());
        adjectiveCardSub3.add(adjLELabel);
        adjectiveCardSub3.add(this.adjLECombo);
        adjectiveCard.add(adjectiveCardSub3);
        if (this.language.equals("el")) {
            this.adjCaseLabel = new JLabel("Case");
            String[] cases = new String[]{"nominative", "genitive", "accusative"};
            this.adjCaseCombo = new JComboBox<String>(cases);
            adjectiveCardSub4.add(this.adjCaseLabel);
            adjectiveCardSub4.add(this.adjCaseCombo);
            adjectiveCard.add(adjectiveCardSub4);
            this.adjGenderLabel = new JLabel("Gender");
            String[] genders = new String[]{"masculine", "feminine", "neuter"};
            this.adjGenderCombo = new JComboBox<String>(genders);
            adjectiveCardSub5.add(this.adjGenderLabel);
            adjectiveCardSub5.add(this.adjGenderCombo);
            adjectiveCard.add(adjectiveCardSub5);
        }
        this.adjNumLabel = new JLabel("Number");
        this.adjNumCombo = new JComboBox<String>(numbers);
        adjectiveCardSub6.add(this.adjNumLabel);
        adjectiveCardSub6.add(this.adjNumCombo);
        adjectiveCard.add(adjectiveCardSub6);
        this.adjAgreeWithSlotModel = new DefaultComboBoxModel();
        this.adjAgreeWithSlotModel.addElement("none");
        int j2 = 0;
        while (j2 < this.father.getBoxes().size()) {
            NLNSlot s = this.father.getBoxes().get(j2).getSlot();
            if ((s instanceof NLNAdjectiveSlot || s instanceof NLNNounSlot) && s.getOrder() != this.getSlot().getOrder()) {
                this.adjAgreeWithSlotModel.addElement(s.getOrder());
            }
            ++j2;
        }
        JLabel adjAgreeWithLabel = new JLabel("Agree with slot ");
        this.adjAgreeWithCombo = new JComboBox(this.adjAgreeWithSlotModel);
        adjectiveCardSub7.add(adjAgreeWithLabel);
        adjectiveCardSub7.add(this.adjAgreeWithCombo);
        adjectiveCard.add(adjectiveCardSub7);
        adjLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        if (this.language.equals("el")) {
            this.adjCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
            this.adjGenderLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        }
        this.adjNumLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        adjAgreeWithLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.adjLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        if (this.language.equals("el")) {
            this.adjCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
            this.adjGenderCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        }
        this.adjNumCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.adjAgreeWithCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        JLabel nounLELabel = new JLabel("Lexicon Entry");
        this.nounHeadCheck = new JCheckBox("Head Noun", false);
        nounCardSub1.add(this.nounHeadCheck);
        nounCard.add(nounCardSub1);
        this.nounCapitalCheck = new JCheckBox("Capitalized", false);
        nounCardSub2.add(this.nounCapitalCheck);
        nounCard.add(nounCardSub2);
        HashSet<ListIRI> nounLexiconEntries = new HashSet<ListIRI>();
        for (IRI iri : SentencePlanTab.LQM.getNounEntries()) {
            nounLexiconEntries.add(new ListIRI(iri));
        }
        sortedList = new ArrayList(nounLexiconEntries);
        Collections.sort(sortedList);
        this.nounLECombo = new JComboBox<Object>(sortedList.toArray());
        this.nounLECombo.setRenderer(new ListRenderer());
        nounCardSub3.add(nounLELabel);
        nounCardSub3.add(this.nounLECombo);
        nounCard.add(nounCardSub3);
        if (this.language.equals("el")) {
            this.nounCaseLabel = new JLabel("Case");
            String[] cases = new String[]{"nominative", "genitive", "accusative"};
            this.nounCaseCombo = new JComboBox<String>(cases);
            nounCardSub4.add(this.nounCaseLabel);
            nounCardSub4.add(this.nounCaseCombo);
            nounCard.add(nounCardSub4);
        }
        this.nounNumLabel = new JLabel("Number");
        this.nounNumCombo = new JComboBox<String>(numbers);
        nounCardSub5.add(this.nounNumLabel);
        nounCardSub5.add(this.nounNumCombo);
        nounCard.add(nounCardSub5);
        this.nounAgreeWithSlotModel = new DefaultComboBoxModel();
        this.nounAgreeWithSlotModel.addElement("none");
        int j3 = 0;
        while (j3 < this.father.getBoxes().size()) {
            NLNSlot s = this.father.getBoxes().get(j3).getSlot();
            if ((s instanceof NLNAdjectiveSlot || s instanceof NLNNounSlot) && s.getOrder() != this.getSlot().getOrder()) {
                this.nounAgreeWithSlotModel.addElement(s.getOrder());
            }
            ++j3;
        }
        JLabel nounAgreeWithLabel = new JLabel("Agree with slot ");
        this.nounAgreeWithCombo = new JComboBox(this.nounAgreeWithSlotModel);
        nounCardSub6.add(nounAgreeWithLabel);
        nounCardSub6.add(this.nounAgreeWithCombo);
        nounCard.add(nounCardSub6);
        nounLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        if (this.language.equals("el")) {
            this.nounCaseLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        }
        this.nounNumLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        nounAgreeWithLabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.nounLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        if (this.language.equals("el")) {
            this.nounCaseCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        }
        this.nounNumCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.nounAgreeWithCombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        JLabel stringLabel = new JLabel(stringSlotStr);
        this.stringTextArea = new JTextArea(8, 8);
        this.stringTextArea.setLineWrap(true);
        this.stringTextArea.getDocument().putProperty("name", "stringText");
        JScrollPane scroll = new JScrollPane(this.stringTextArea);
        stringCardSub1.add("North", stringLabel);
        stringCardSub1.add("Center", scroll);
        stringCard.add(stringCardSub1);
        JLabel prepLELabel = new JLabel(prepositionSlotStr);
        String[] preps = new String[]{};
        if (this.language.equals("en")) {
            preps = NLNPrepositionSlot.getEnglishPrepositionList().toArray(preps);
        } else if (this.language.equals("el")) {
            preps = NLNPrepositionSlot.getGreekPrepositionList().toArray(preps);
        }
        this.prepLECombo = new JComboBox<String>(preps);
        prepositionCardSub1.add(prepLELabel);
        prepositionCardSub1.add(this.prepLECombo);
        prepositionCard.add(prepositionCardSub1);
        prepLELabel.setPreferredSize(new Dimension(boxLabelWidth, labelD.height));
        this.prepLECombo.setPreferredSize(new Dimension(boxComboWidth, comboD.height));
        this.dynamicPanel.add((Component)articleCard, articleSlotStr);
        this.dynamicPanel.add((Component)adjectiveCard, adjectiveSlotStr);
        this.dynamicPanel.add((Component)nounCard, nounSlotStr);
        this.dynamicPanel.add((Component)stringCard, stringSlotStr);
        this.dynamicPanel.add((Component)prepositionCard, prepositionSlotStr);
    }

    void loadSlotInBox(NLNSlot slot) {
        this.select.removeItemListener(this);
        this.removeListenersOfLastOpenSlotTab();
        CardLayout cl = (CardLayout)this.dynamicPanel.getLayout();
        if (slot instanceof NLNArticleSlot) {
            this.lastOpenSlotTab = articleSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(articleSlotStr);
            if (((NLNArticleSlot)slot).isDefinite()) {
                this.definiteCheck.setSelected(true);
            } else {
                this.definiteCheck.setSelected(false);
            }
            this.definiteCheck.addItemListener(this);
            if (((NLNArticleSlot)slot).getAgreesWithID() == null) {
                if (this.language.equals("el")) {
                    this.artCaseCombo.setEnabled(true);
                    this.artCaseCombo.setSelectedItem(((NLNArticleSlot)slot).getCase());
                    this.artCaseCombo.addItemListener(this);
                    this.artGenderCombo.setEnabled(true);
                    this.artGenderCombo.setSelectedItem(((NLNArticleSlot)slot).getGender());
                    this.artGenderCombo.addItemListener(this);
                }
                this.artNumCombo.setEnabled(true);
                this.artNumCombo.setSelectedItem(((NLNArticleSlot)slot).getNumber());
                this.artNumCombo.addItemListener(this);
            } else {
                String agreeID = ((NLNArticleSlot)slot).getAgreesWithID().toString();
                int agreeSlot = -1;
                int i = 0;
                while (i < this.father.getSlots().size()) {
                    if (this.father.getSlots().get(i).getId().toString().equals(agreeID)) {
                        agreeSlot = i + 1;
                    }
                    ++i;
                }
                if (agreeSlot != -1) {
                    if (this.artAgreeWithSlotModel.getIndexOf(agreeSlot) == -1) {
                        this.artAgreeWithSlotModel.addElement(agreeSlot);
                    }
                    this.artAgreeWithCombo.setSelectedItem(agreeSlot);
                    if (this.language.equals("el")) {
                        this.artCaseCombo.setEnabled(false);
                        this.artCaseCombo.setSelectedItem(null);
                        this.artCaseCombo.removeItemListener(this);
                        this.artGenderCombo.setEnabled(false);
                        this.artGenderCombo.setSelectedItem(null);
                        this.artGenderCombo.removeItemListener(this);
                    }
                    this.artNumCombo.setEnabled(false);
                    this.artNumCombo.setSelectedItem(null);
                    this.artNumCombo.removeItemListener(this);
                } else {
                    System.err.println("Cannot find slot " + agreeID);
                    if (this.language.equals("el")) {
                        this.artCaseCombo.setEnabled(true);
                        this.artCaseCombo.setSelectedItem(((NLNArticleSlot)slot).getCase());
                        this.artCaseCombo.addItemListener(this);
                        this.artGenderCombo.setEnabled(true);
                        this.artGenderCombo.setSelectedItem(((NLNArticleSlot)slot).getGender());
                        this.artGenderCombo.addItemListener(this);
                    }
                    this.artNumCombo.setEnabled(true);
                    this.artNumCombo.setSelectedItem(((NLNArticleSlot)slot).getNumber());
                    this.artNumCombo.addItemListener(this);
                }
            }
            this.artAgreeWithCombo.addFocusListener(this);
            this.artAgreeWithCombo.addItemListener(this);
        } else if (slot instanceof NLNAdjectiveSlot) {
            this.lastOpenSlotTab = adjectiveSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) != -1 || this.father.getBoxes().get(j).getSlot().getOrder() == slot.getOrder()) continue;
                    mdl.addElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(adjectiveSlotStr);
            if (((NLNAdjectiveSlot)slot).getLexiconEntryIRI() != null) {
                this.adjLECombo.setSelectedItem(new ListIRI(((NLNAdjectiveSlot)slot).getLexiconEntryIRI()));
            } else if (this.adjLECombo.getSelectedItem() != null) {
                ((NLNAdjectiveSlot)slot).setLexiconEntryIRI(((ListIRI)this.adjLECombo.getSelectedItem()).getEntryIRI());
            }
            this.adjLECombo.addItemListener(this);
            this.adjLECombo.addFocusListener(this);
            this.adjCapitalCheck.setSelected(((NLNAdjectiveSlot)slot).isCapitalized());
            this.adjCapitalCheck.addItemListener(this);
            if (((NLNAdjectiveSlot)slot).isHead()) {
                this.adjHeadCheck.setSelected(true);
                if (this.language.equals("el")) {
                    this.adjCaseLabel.setText("Default Case");
                    this.adjGenderLabel.setText("Default Gender");
                }
                this.adjNumLabel.setText("Default Number");
                this.adjAgreeWithCombo.setEnabled(false);
                this.adjAgreeWithCombo.setSelectedItem("none");
                this.adjAgreeWithCombo.removeFocusListener(this);
                this.adjAgreeWithCombo.removeItemListener(this);
                if (this.language.equals("el")) {
                    this.adjCaseCombo.setEnabled(true);
                    this.adjCaseCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getCase());
                    this.adjCaseCombo.addItemListener(this);
                    this.adjGenderCombo.setEnabled(true);
                    this.adjGenderCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getGender());
                    this.adjGenderCombo.addItemListener(this);
                }
                this.adjNumCombo.setEnabled(true);
                this.adjNumCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getNumber());
                this.adjNumCombo.addItemListener(this);
            } else {
                this.adjHeadCheck.setSelected(false);
                if (this.language.equals("el")) {
                    this.adjCaseLabel.setText("Case");
                    this.adjGenderLabel.setText("Gender");
                }
                this.adjNumLabel.setText("Number");
                if (((NLNAdjectiveSlot)slot).getAgreesWithID() == null) {
                    if (this.language.equals("el")) {
                        this.adjCaseCombo.setEnabled(true);
                        this.adjCaseCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getCase());
                        this.adjCaseCombo.addItemListener(this);
                        this.adjGenderCombo.setEnabled(true);
                        this.adjGenderCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getGender());
                        this.adjGenderCombo.addItemListener(this);
                    }
                    this.adjNumCombo.setEnabled(true);
                    this.adjNumCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getNumber());
                    this.adjNumCombo.addItemListener(this);
                } else {
                    String agreeID = ((NLNAdjectiveSlot)slot).getAgreesWithID().toString();
                    int agreeSlot = -1;
                    int i = 0;
                    while (i < this.father.getSlots().size()) {
                        if (this.father.getSlots().get(i).getId().toString().equals(agreeID)) {
                            agreeSlot = i + 1;
                        }
                        ++i;
                    }
                    if (agreeSlot != -1) {
                        if (this.adjAgreeWithSlotModel.getIndexOf(agreeSlot) == -1) {
                            this.adjAgreeWithSlotModel.addElement(agreeSlot);
                        }
                        this.adjAgreeWithCombo.setSelectedItem(agreeSlot);
                        if (this.language.equals("el")) {
                            this.adjCaseCombo.setEnabled(false);
                            this.adjCaseCombo.setSelectedItem(null);
                            this.adjCaseCombo.removeItemListener(this);
                            this.adjGenderCombo.setEnabled(false);
                            this.adjGenderCombo.setSelectedItem(null);
                            this.adjGenderCombo.removeItemListener(this);
                        }
                        this.adjNumCombo.setEnabled(false);
                        this.adjNumCombo.setSelectedItem(null);
                        this.adjNumCombo.removeItemListener(this);
                    } else {
                        System.err.println("Cannot find slot " + agreeID);
                        if (this.language.equals("el")) {
                            this.adjCaseCombo.setEnabled(true);
                            this.adjCaseCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getCase());
                            this.adjCaseCombo.addItemListener(this);
                            this.adjGenderCombo.setEnabled(true);
                            this.adjGenderCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getGender());
                            this.adjGenderCombo.addItemListener(this);
                        }
                        this.adjNumCombo.setEnabled(true);
                        this.adjNumCombo.setSelectedItem(((NLNAdjectiveSlot)slot).getNumber());
                        this.adjNumCombo.addItemListener(this);
                    }
                }
                this.adjAgreeWithCombo.addFocusListener(this);
                this.adjAgreeWithCombo.addItemListener(this);
            }
            this.adjHeadCheck.addItemListener(this);
        } else if (slot instanceof NLNNounSlot) {
            this.lastOpenSlotTab = nounSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) != -1 || this.father.getBoxes().get(j).getSlot().getOrder() == slot.getOrder()) continue;
                    mdl.addElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(nounSlotStr);
            if (((NLNNounSlot)slot).getLexiconEntryIRI() != null) {
                this.nounLECombo.setSelectedItem(new ListIRI(((NLNNounSlot)slot).getLexiconEntryIRI()));
            } else if (this.nounLECombo.getSelectedItem() != null) {
                ((NLNNounSlot)slot).setLexiconEntryIRI(((ListIRI)this.nounLECombo.getSelectedItem()).getEntryIRI());
            }
            this.nounLECombo.addItemListener(this);
            this.nounLECombo.addFocusListener(this);
            this.nounCapitalCheck.setSelected(((NLNNounSlot)slot).isCapitalized());
            this.nounCapitalCheck.addItemListener(this);
            if (((NLNNounSlot)slot).isHead()) {
                this.nounHeadCheck.setSelected(true);
                if (this.language.equals("el")) {
                    this.nounCaseLabel.setText("Default Case");
                }
                this.nounNumLabel.setText("Default Number");
                this.nounAgreeWithCombo.removeFocusListener(this);
                this.nounAgreeWithCombo.removeItemListener(this);
                this.nounAgreeWithCombo.setEnabled(false);
                this.nounAgreeWithCombo.setSelectedItem("none");
                if (this.language.equals("el")) {
                    this.nounCaseCombo.setEnabled(true);
                    this.nounCaseCombo.setSelectedItem(((NLNNounSlot)slot).getCase());
                    this.nounCaseCombo.addItemListener(this);
                }
                this.nounNumCombo.setEnabled(true);
                this.nounNumCombo.setSelectedItem(((NLNNounSlot)slot).getNumber());
                LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.language);
                if (entry.getNumber().equals("singular")) {
                    this.nounNumCombo.setSelectedItem("singular");
                    this.nounNumCombo.setEnabled(false);
                    if (!((NLNNounSlot)slot).getNumber().equals("singular")) {
                        ((NLNNounSlot)slot).setNumber("singular");
                    }
                } else if (entry.getNumber().equals("plural")) {
                    this.nounNumCombo.setSelectedItem("plural");
                    this.nounNumCombo.setEnabled(false);
                    if (!((NLNNounSlot)slot).getNumber().equals("plural")) {
                        ((NLNNounSlot)slot).setNumber("plural");
                    }
                }
                this.nounNumCombo.addItemListener(this);
            } else {
                this.nounHeadCheck.setSelected(false);
                if (this.language.equals("el")) {
                    this.nounCaseLabel.setText("Case");
                }
                this.nounNumLabel.setText("Number");
                if (((NLNNounSlot)slot).getAgreesWithID() == null) {
                    if (this.language.equals("el")) {
                        this.nounCaseCombo.setEnabled(true);
                        this.nounCaseCombo.setSelectedItem(((NLNNounSlot)slot).getCase());
                        this.nounCaseCombo.addItemListener(this);
                    }
                    this.nounNumCombo.setEnabled(true);
                    this.nounNumCombo.setSelectedItem(((NLNNounSlot)slot).getNumber());
                    if (((NLNNounSlot)slot).getLexiconEntryIRI() != null) {
                        LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.language);
                        if (entry.getNumber().equals("singular")) {
                            this.nounNumCombo.setSelectedItem("singular");
                            this.nounNumCombo.setEnabled(false);
                            if (!((NLNNounSlot)slot).getNumber().equals("singular")) {
                                ((NLNNounSlot)slot).setNumber("singular");
                            }
                        } else if (entry.getNumber().equals("plural")) {
                            this.nounNumCombo.setSelectedItem("plural");
                            this.nounNumCombo.setEnabled(false);
                            if (!((NLNNounSlot)slot).getNumber().equals("plural")) {
                                ((NLNNounSlot)slot).setNumber("plural");
                            }
                        }
                    }
                    this.nounNumCombo.addItemListener(this);
                } else {
                    String agreeID = ((NLNNounSlot)slot).getAgreesWithID().toString();
                    int agreeSlot = -1;
                    int i = 0;
                    while (i < this.father.getSlots().size()) {
                        if (this.father.getSlots().get(i).getId().toString().equals(agreeID)) {
                            agreeSlot = i + 1;
                        }
                        ++i;
                    }
                    if (agreeSlot != -1) {
                        if (this.nounAgreeWithSlotModel.getIndexOf(agreeSlot) == -1) {
                            this.nounAgreeWithSlotModel.addElement(agreeSlot);
                        }
                        this.nounAgreeWithCombo.setSelectedItem(agreeSlot);
                        if (this.language.equals("el")) {
                            this.nounCaseCombo.setEnabled(false);
                            this.nounCaseCombo.setSelectedItem(null);
                            this.nounCaseCombo.removeItemListener(this);
                        }
                        this.nounNumCombo.setEnabled(false);
                        this.nounNumCombo.setSelectedItem(null);
                        this.nounNumCombo.removeItemListener(this);
                    } else {
                        System.err.println("Cannot find slot " + agreeID);
                        if (this.language.equals("el")) {
                            this.nounCaseCombo.setEnabled(true);
                            this.nounCaseCombo.setSelectedItem(((NLNNounSlot)slot).getCase());
                            this.nounCaseCombo.addItemListener(this);
                        }
                        this.nounNumCombo.setEnabled(true);
                        this.nounNumCombo.setSelectedItem(((NLNNounSlot)slot).getNumber());
                        if (((NLNNounSlot)slot).getLexiconEntryIRI() != null) {
                            LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.language);
                            if (entry.getNumber().equals("singular")) {
                                this.nounNumCombo.setSelectedItem("singular");
                                this.nounNumCombo.setEnabled(false);
                                if (!((NLNNounSlot)slot).getNumber().equals("singular")) {
                                    ((NLNNounSlot)slot).setNumber("singular");
                                }
                            } else if (entry.getNumber().equals("plural")) {
                                this.nounNumCombo.setSelectedItem("plural");
                                this.nounNumCombo.setEnabled(false);
                                if (!((NLNNounSlot)slot).getNumber().equals("plural")) {
                                    ((NLNNounSlot)slot).setNumber("plural");
                                }
                            }
                        }
                        this.nounNumCombo.addItemListener(this);
                    }
                }
                this.nounAgreeWithCombo.addFocusListener(this);
                this.nounAgreeWithCombo.addItemListener(this);
            }
            this.nounHeadCheck.addItemListener(this);
        } else if (slot instanceof NLNPrepositionSlot) {
            this.lastOpenSlotTab = prepositionSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(prepositionSlotStr);
            this.prepLECombo.setSelectedItem(((NLNPrepositionSlot)slot).getPrep());
            this.prepLECombo.addItemListener(this);
        } else if (slot instanceof NLNStringSlot) {
            this.lastOpenSlotTab = stringSlotStr;
            int j = 0;
            while (j < this.father.getBoxes().size()) {
                ArrayList<DefaultComboBoxModel> mdls = this.father.getBoxes().get(j).getAgreeWithSlotModels();
                for (DefaultComboBoxModel mdl : mdls) {
                    if (mdl.getIndexOf(slot.getOrder()) == -1) continue;
                    mdl.removeElement(slot.getOrder());
                }
                ++j;
            }
            this.select.setSelectedItem(stringSlotStr);
            this.stringTextArea.setText(((NLNStringSlot)slot).getText());
            this.stringTextArea.getDocument().addDocumentListener(this);
        }
        cl.show(this.dynamicPanel, this.lastOpenSlotTab);
        this.dynamicPanel.validate();
        this.select.addItemListener(this);
    }

    public void removeListenersOfLastOpenSlotTab() {
        if (this.lastOpenSlotTab == articleSlotStr) {
            this.definiteCheck.removeItemListener(this);
            if (this.language.equals("el")) {
                this.artCaseCombo.removeItemListener(this);
                this.artGenderCombo.removeItemListener(this);
            }
            this.artNumCombo.removeItemListener(this);
            this.artAgreeWithCombo.removeFocusListener(this);
            this.artAgreeWithCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == adjectiveSlotStr) {
            this.adjLECombo.removeItemListener(this);
            this.adjLECombo.removeFocusListener(this);
            this.adjHeadCheck.removeItemListener(this);
            this.adjCapitalCheck.removeItemListener(this);
            if (this.language.equals("el")) {
                this.adjCaseCombo.removeItemListener(this);
                this.adjGenderCombo.removeItemListener(this);
            }
            this.adjNumCombo.removeItemListener(this);
            this.adjAgreeWithCombo.removeFocusListener(this);
            this.adjAgreeWithCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == nounSlotStr) {
            this.nounLECombo.removeItemListener(this);
            this.nounLECombo.removeFocusListener(this);
            this.nounHeadCheck.removeItemListener(this);
            this.nounCapitalCheck.removeItemListener(this);
            if (this.language.equals("el")) {
                this.nounCaseCombo.removeItemListener(this);
            }
            this.nounNumCombo.removeItemListener(this);
            this.nounAgreeWithCombo.removeFocusListener(this);
            this.nounAgreeWithCombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == prepositionSlotStr) {
            this.prepLECombo.removeItemListener(this);
        } else if (this.lastOpenSlotTab == stringSlotStr) {
            this.stringTextArea.getDocument().removeDocumentListener(this);
        }
    }

    public void setAdjectiveHead(boolean isHead) {
        if (isHead && !((NLNAdjectiveSlot)this.slot).isHead()) {
            if (this.language.equals("el")) {
                this.adjCaseLabel.setText("Default Case");
                this.adjGenderLabel.setText("Default Gender");
            }
            this.adjNumLabel.setText("Default Number");
            if (this.language.equals("el")) {
                if (!this.adjCaseCombo.isEnabled()) {
                    this.adjCaseCombo.setEnabled(true);
                    if (this.adjCaseCombo.getSelectedIndex() == -1) {
                        this.adjCaseCombo.setSelectedIndex(0);
                    }
                    this.adjCaseCombo.addItemListener(this);
                }
                if (!this.adjGenderCombo.isEnabled()) {
                    this.adjGenderCombo.setEnabled(true);
                    if (this.adjGenderCombo.getSelectedIndex() == -1) {
                        this.adjGenderCombo.setSelectedIndex(0);
                    }
                    this.adjGenderCombo.addItemListener(this);
                }
            }
            if (!this.adjNumCombo.isEnabled()) {
                this.adjNumCombo.setEnabled(true);
                if (this.adjNumCombo.getSelectedIndex() == -1) {
                    this.adjNumCombo.setSelectedIndex(0);
                }
                this.adjNumCombo.addItemListener(this);
            }
            this.adjAgreeWithCombo.removeFocusListener(this);
            this.adjAgreeWithCombo.removeItemListener(this);
            this.adjAgreeWithCombo.setEnabled(false);
            this.adjAgreeWithCombo.setSelectedItem("none");
        } else if (!isHead && ((NLNAdjectiveSlot)this.slot).isHead()) {
            if (this.language.equals("el")) {
                this.adjCaseLabel.setText("Case");
                this.adjGenderLabel.setText("Gender");
            }
            this.adjNumLabel.setText("Number");
            this.adjAgreeWithCombo.setEnabled(true);
            this.adjAgreeWithCombo.setSelectedItem("none");
            this.adjAgreeWithCombo.addFocusListener(this);
            this.adjAgreeWithCombo.addItemListener(this);
        }
        this.adjHeadCheck.setSelected(isHead);
        ((NLNAdjectiveSlot)this.slot).setHead(isHead);
    }

    public void setNounHead(boolean isHead) {
        if (isHead && !((NLNNounSlot)this.slot).isHead()) {
            if (this.language.equals("el")) {
                this.nounCaseLabel.setText("Default Case");
            }
            this.nounNumLabel.setText("Default Number");
            if (this.language.equals("el") && !this.nounCaseCombo.isEnabled()) {
                this.nounCaseCombo.setEnabled(true);
                if (this.nounCaseCombo.getSelectedIndex() == -1) {
                    this.nounCaseCombo.setSelectedIndex(0);
                }
                this.nounCaseCombo.addItemListener(this);
            }
            if (!this.nounNumCombo.isEnabled()) {
                LexEntryNoun entry = NLNamesTab.LQM.getNounEntry(((NLNNounSlot)this.slot).getLexiconEntryIRI(), this.language);
                if (entry.getNumber().equals("singular")) {
                    this.nounNumCombo.setSelectedItem("singular");
                    this.nounNumCombo.setEnabled(false);
                } else if (entry.getNumber().equals("plural")) {
                    this.nounNumCombo.setSelectedItem("plural");
                    this.nounNumCombo.setEnabled(false);
                } else {
                    this.nounNumCombo.setEnabled(true);
                    if (this.nounNumCombo.getSelectedIndex() == -1) {
                        this.nounNumCombo.setSelectedIndex(0);
                    }
                    this.nounNumCombo.addItemListener(this);
                }
            }
            this.nounAgreeWithCombo.removeItemListener(this);
            this.nounAgreeWithCombo.removeFocusListener(this);
            this.nounAgreeWithCombo.setEnabled(false);
            this.nounAgreeWithCombo.setSelectedItem("none");
        } else if (!isHead && ((NLNNounSlot)this.slot).isHead()) {
            if (this.language.equals("el")) {
                this.nounCaseLabel.setText("Case");
            }
            this.nounNumLabel.setText("Number");
            this.nounAgreeWithCombo.setEnabled(true);
            this.nounAgreeWithCombo.setSelectedItem("none");
            this.nounAgreeWithCombo.addFocusListener(this);
            this.nounAgreeWithCombo.addItemListener(this);
        }
        this.nounHeadCheck.setSelected(isHead);
        ((NLNNounSlot)this.slot).setHead(isHead);
    }

    public void updateOrderLabel() {
        this.orderLabel.setText("Slot order: " + this.slot.getOrder());
    }

    public void updateEntry(DocumentEvent event) {
        String name = (String)event.getDocument().getProperty("name");
        if (name.equals("stringText")) {
            ((NLNStringSlot)this.slot).setText(this.stringTextArea.getText());
            this.father.dirtenOntologies();
        }
    }

    public NLNSlot getSlot() {
        return this.slot;
    }

    public ArrayList<DefaultComboBoxModel> getAgreeWithSlotModels() {
        ArrayList<DefaultComboBoxModel> agreeModels = new ArrayList<DefaultComboBoxModel>();
        agreeModels.add(this.artAgreeWithSlotModel);
        agreeModels.add(this.adjAgreeWithSlotModel);
        agreeModels.add(this.nounAgreeWithSlotModel);
        return agreeModels;
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource() == this.adjLECombo) {
            Object selected = this.adjLECombo.getSelectedItem();
            HashSet<ListIRI> adjLexiconEntries = new HashSet<ListIRI>();
            for (IRI iri : SentencePlanTab.LQM.getAdjectiveEntries()) {
                adjLexiconEntries.add(new ListIRI(iri));
            }
            if (!this.areIdentical((DefaultComboBoxModel)this.adjLECombo.getModel(), adjLexiconEntries)) {
                ArrayList sortedList = new ArrayList(adjLexiconEntries);
                Collections.sort(sortedList);
                DefaultComboBoxModel<Object> adjComboModel = new DefaultComboBoxModel<Object>(sortedList.toArray());
                this.adjLECombo.setModel(adjComboModel);
                if (adjComboModel.getIndexOf(selected) != -1) {
                    this.adjLECombo.setSelectedItem(selected);
                }
            }
        } else if (e.getSource() == this.nounLECombo) {
            Object selected = this.nounLECombo.getSelectedItem();
            HashSet<ListIRI> nounLexiconEntries = new HashSet<ListIRI>();
            for (IRI iri : SentencePlanTab.LQM.getNounEntries()) {
                nounLexiconEntries.add(new ListIRI(iri));
            }
            if (!this.areIdentical((DefaultComboBoxModel)this.nounLECombo.getModel(), nounLexiconEntries)) {
                ArrayList sortedList = new ArrayList(nounLexiconEntries);
                Collections.sort(sortedList);
                DefaultComboBoxModel<Object> nounComboModel = new DefaultComboBoxModel<Object>(sortedList.toArray());
                this.nounLECombo.setModel(nounComboModel);
                if (nounComboModel.getIndexOf(selected) != -1) {
                    this.nounLECombo.setSelectedItem(selected);
                }
            }
        } else if (e.getSource() == this.artAgreeWithCombo) {
            Object selected = this.artAgreeWithCombo.getSelectedItem();
            this.artAgreeWithCombo.setModel(this.artAgreeWithSlotModel);
            if (this.artAgreeWithSlotModel.getIndexOf(selected) != -1) {
                this.artAgreeWithCombo.setSelectedItem(selected);
            }
        } else if (e.getSource() == this.adjAgreeWithCombo) {
            Object selected = this.adjAgreeWithCombo.getSelectedItem();
            DefaultComboBoxModel tempModel = this.adjAgreeWithSlotModel;
            tempModel.removeElement(this.getSlot().getOrder());
            this.adjAgreeWithCombo.setModel(tempModel);
            if (tempModel.getIndexOf(selected) != -1) {
                this.adjAgreeWithCombo.setSelectedItem(selected);
            }
        } else if (e.getSource() == this.nounAgreeWithCombo) {
            Object selected = this.nounAgreeWithCombo.getSelectedItem();
            DefaultComboBoxModel tempModel = this.nounAgreeWithSlotModel;
            tempModel.removeElement(this.getSlot().getOrder());
            this.nounAgreeWithCombo.setModel(tempModel);
            if (tempModel.getIndexOf(selected) != -1) {
                this.nounAgreeWithCombo.setSelectedItem(selected);
            }
        }
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    private boolean agreeCycleExists(HashSet<NLNSlot> slots, int agreeWithOrder) {
        int j = 0;
        while (j < this.father.getBoxes().size()) {
            NLNSlot agreeSlot = this.father.getBoxes().get(j).getSlot();
            if (agreeSlot.getOrder() == agreeWithOrder) {
                if (agreeSlot instanceof NLNAdjectiveSlot) {
                    if (slots.contains(agreeSlot)) {
                        return true;
                    }
                    if (((NLNAdjectiveSlot)agreeSlot).getAgreesWithID() == null) {
                        return false;
                    }
                    slots.add(agreeSlot);
                    agreeWithOrder = Integer.parseInt(((NLNAdjectiveSlot)agreeSlot).getAgreesWithID().toString().substring(((NLNAdjectiveSlot)agreeSlot).getAgreesWithID().toString().indexOf("slot") + "slot".length()));
                    return this.agreeCycleExists(slots, agreeWithOrder);
                }
                if (agreeSlot instanceof NLNNounSlot) {
                    if (slots.contains(agreeSlot)) {
                        return true;
                    }
                    if (((NLNNounSlot)agreeSlot).getAgreesWithID() == null) {
                        return false;
                    }
                    slots.add(agreeSlot);
                    agreeWithOrder = Integer.parseInt(((NLNNounSlot)agreeSlot).getAgreesWithID().toString().substring(((NLNNounSlot)agreeSlot).getAgreesWithID().toString().indexOf("slot") + "slot".length()));
                    return this.agreeCycleExists(slots, agreeWithOrder);
                }
            }
            ++j;
        }
        return false;
    }

    public boolean areIdentical(DefaultComboBoxModel a, HashSet b) {
        if (a.getSize() == b.size()) {
            HashSet checkSet = new HashSet(b);
            int i = 0;
            while (i < a.getSize()) {
                checkSet.add(a.getElementAt(i));
                ++i;
            }
            return checkSet.size() == b.size();
        }
        return false;
    }
}

