/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SPAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.SPNounSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SPVerbSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.NewResourceDialog;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeRenderer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class LexiconTreeComponent
extends TreeComponent {
    JPanel complete;
    DefaultMutableTreeNode parent;
    DefaultMutableTreeNode nounParent;
    DefaultMutableTreeNode adjectiveParent;
    DefaultMutableTreeNode verbParent;

    public LexiconTreeComponent(NaturalOWLTab fatherTab) {
        super(fatherTab);
    }

    @Override
    public void createTree() {
        DefaultMutableTreeNode node;
        IRI s;
        this.parent = new DefaultMutableTreeNode("Lexicon Entries", true);
        this.adjectiveParent = new DefaultMutableTreeNode("Adjectives", true);
        this.parent.add(this.adjectiveParent);
        Iterator<IRI> it = NaturalOWLTab.LQM.getAdjectivesIRIs();
        ArrayList<ListIRI> toAdd = new ArrayList<ListIRI>();
        while (it.hasNext()) {
            s = it.next();
            if (DefaultResourcesManager.isDefaultResource(s)) continue;
            toAdd.add(new ListIRI(s));
        }
        Collections.sort(toAdd);
        for (ListIRI add : toAdd) {
            node = new DefaultMutableTreeNode(add, false);
            this.adjectiveParent.add(node);
        }
        this.nounParent = new DefaultMutableTreeNode("Nouns", true);
        this.parent.add(this.nounParent);
        it = NaturalOWLTab.LQM.getNounsIRIs();
        toAdd = new ArrayList();
        while (it.hasNext()) {
            s = it.next();
            if (DefaultResourcesManager.isDefaultResource(s)) continue;
            toAdd.add(new ListIRI(s));
        }
        Collections.sort(toAdd);
        for (ListIRI add : toAdd) {
            node = new DefaultMutableTreeNode(add, false);
            this.nounParent.add(node);
        }
        this.verbParent = new DefaultMutableTreeNode("Verbs", true);
        this.parent.add(this.verbParent);
        it = NaturalOWLTab.LQM.getVerbsIRIs();
        toAdd = new ArrayList();
        while (it.hasNext()) {
            s = it.next();
            if (DefaultResourcesManager.isDefaultResource(s)) continue;
            toAdd.add(new ListIRI(s));
        }
        Collections.sort(toAdd);
        for (ListIRI add : toAdd) {
            node = new DefaultMutableTreeNode(add, false);
            this.verbParent.add(node);
        }
        this.tree = new JTree(this.parent);
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                try {
                    if (evt.getButton() == 3) {
                        LexiconTreeComponent.this.treePopupMenu(evt);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void treePopupMenu(MouseEvent evt) {
        TreePath path = this.tree.getPathForLocation(evt.getX(), evt.getY());
        if (path == null) {
            return;
        }
        this.tree.setSelectionPath(path);
        final DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        JPopupMenu popup = new JPopupMenu();
        popup.setInvoker(this.tree);
        if (!node.equals(this.parent)) {
            if (!this.isEntry(node)) {
                JMenuItem newNLN = new JMenuItem("Create new " + ((String)node.getUserObject()).substring(0, ((String)node.getUserObject()).length() - 1) + " Lexicon Entry");
                newNLN.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        NewResourceDialog dlg = new NewResourceDialog("New Lexicon Entry", LexiconTreeComponent.this.treeCmp, true, "");
                        if (dlg.getResponse()) {
                            String name = dlg.getName();
                            IRI entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
                            while (name.equals("") || !NaturalOWLTab.isLegalIRI(entryIRI) || !LexiconTreeComponent.this.father.isUniqueIRI(entryIRI)) {
                                JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.", "Invalid entity name", 0);
                                dlg = new NewResourceDialog("New Lexicon Entry", LexiconTreeComponent.this.treeCmp, true, "");
                                if (dlg.getResponse()) {
                                    name = dlg.getName();
                                    entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
                                    continue;
                                }
                                return;
                            }
                            LexiconTreeComponent.this.createNewNode(node, entryIRI);
                        }
                    }
                });
                popup.add(newNLN);
            } else {
                JMenuItem rename = new JMenuItem("Rename");
                rename.addActionListener(new ActionListener(){

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ListIRI oldName = (ListIRI)node.getUserObject();
                        String startNS = oldName.getEntryIRI().getStart();
                        NewResourceDialog dlg = new NewResourceDialog("Rename Lexicon Entry", LexiconTreeComponent.this.treeCmp, true, oldName.toString());
                        if (dlg.getResponse()) {
                            void var11_17;
                            String name = dlg.getName();
                            IRI toIRI = IRI.create((String)(String.valueOf(startNS) + name));
                            while (name.equals("") || !NaturalOWLTab.isLegalIRI(toIRI) || !LexiconTreeComponent.this.father.isUniqueIRI(toIRI)) {
                                JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.", "Invalid entity name", 0);
                                dlg = new NewResourceDialog("Rename Lexicon Entry", LexiconTreeComponent.this.treeCmp, true, name);
                                if (dlg.getResponse()) {
                                    name = dlg.getName();
                                    toIRI = IRI.create((String)(String.valueOf(startNS) + name));
                                    continue;
                                }
                                return;
                            }
                            NaturalOWLTab.LQM.duplicateEntryInLexicon(oldName.getEntryIRI(), toIRI);
                            NaturalOWLTab.LQM.deleteLexiconEntry(oldName.getEntryIRI());
                            DefaultMutableTreeNode nodeParent = (DefaultMutableTreeNode)node.getParent();
                            ArrayList<SentencePlan> sentencePlansList = NaturalOWLTab.SPQM.getSentencePlansList("en").getSentencePlansList();
                            for (SentencePlan plan : sentencePlansList) {
                                for (SPSlot sPSlot : plan.getSlotsList()) {
                                    if (nodeParent.equals(LexiconTreeComponent.this.adjectiveParent) && sPSlot instanceof SPAdjectiveSlot) {
                                        if (!((SPAdjectiveSlot)sPSlot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                        ((SPAdjectiveSlot)sPSlot).setLexiconEntryIRI(toIRI);
                                        continue;
                                    }
                                    if (nodeParent.equals(LexiconTreeComponent.this.nounParent) && sPSlot instanceof SPNounSlot) {
                                        if (!((SPNounSlot)sPSlot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                        ((SPNounSlot)sPSlot).setLexiconEntryIRI(toIRI);
                                        continue;
                                    }
                                    if (!nodeParent.equals(LexiconTreeComponent.this.verbParent) || !(sPSlot instanceof SPVerbSlot) || !((SPVerbSlot)sPSlot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                    ((SPVerbSlot)sPSlot).setLexiconEntryIRI(toIRI);
                                }
                            }
                            sentencePlansList = NaturalOWLTab.SPQM.getSentencePlansList("el").getSentencePlansList();
                            for (SentencePlan plan : sentencePlansList) {
                                for (SPSlot sPSlot : plan.getSlotsList()) {
                                    if (nodeParent.equals(LexiconTreeComponent.this.adjectiveParent) && sPSlot instanceof SPAdjectiveSlot) {
                                        if (!((SPAdjectiveSlot)sPSlot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                        ((SPAdjectiveSlot)sPSlot).setLexiconEntryIRI(toIRI);
                                        continue;
                                    }
                                    if (nodeParent.equals(LexiconTreeComponent.this.nounParent) && sPSlot instanceof SPNounSlot) {
                                        if (!((SPNounSlot)sPSlot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                        ((SPNounSlot)sPSlot).setLexiconEntryIRI(toIRI);
                                        continue;
                                    }
                                    if (!nodeParent.equals(LexiconTreeComponent.this.verbParent) || !(sPSlot instanceof SPVerbSlot) || !((SPVerbSlot)sPSlot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                    ((SPVerbSlot)sPSlot).setLexiconEntryIRI(toIRI);
                                }
                            }
                            ArrayList<NLName> nlNamesList = NaturalOWLTab.NLNQM.getNLNamesList("en").getNLNamesList();
                            for (NLName nlName : nlNamesList) {
                                for (NLNSlot slot : nlName.getSlotsList()) {
                                    if (nodeParent.equals(LexiconTreeComponent.this.adjectiveParent) && slot instanceof NLNAdjectiveSlot) {
                                        if (!((NLNAdjectiveSlot)slot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                        ((NLNAdjectiveSlot)slot).setLexiconEntryIRI(toIRI);
                                        continue;
                                    }
                                    if (!nodeParent.equals(LexiconTreeComponent.this.nounParent) || !(slot instanceof NLNNounSlot) || !((NLNNounSlot)slot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                    ((NLNNounSlot)slot).setLexiconEntryIRI(toIRI);
                                }
                            }
                            nlNamesList = NaturalOWLTab.NLNQM.getNLNamesList("el").getNLNamesList();
                            for (NLName nlName : nlNamesList) {
                                for (NLNSlot slot : nlName.getSlotsList()) {
                                    if (nodeParent.equals(LexiconTreeComponent.this.adjectiveParent) && slot instanceof NLNAdjectiveSlot) {
                                        if (!((NLNAdjectiveSlot)slot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                        ((NLNAdjectiveSlot)slot).setLexiconEntryIRI(toIRI);
                                        continue;
                                    }
                                    if (!nodeParent.equals(LexiconTreeComponent.this.nounParent) || !(slot instanceof NLNNounSlot) || !((NLNNounSlot)slot).getLexiconEntryIRI().equals((Object)oldName.getEntryIRI())) continue;
                                    ((NLNNounSlot)slot).setLexiconEntryIRI(toIRI);
                                }
                            }
                            DefaultTreeModel model = (DefaultTreeModel)LexiconTreeComponent.this.tree.getModel();
                            model.removeNodeFromParent(node);
                            boolean bl = false;
                            int i = 0;
                            while (i < model.getChildCount(nodeParent)) {
                                if (((ListIRI)((DefaultMutableTreeNode)model.getChild(nodeParent, i)).getUserObject()).getEntryIRI().compareTo((OWLObject)toIRI) < 0) {
                                    ++var11_17;
                                }
                                ++i;
                            }
                            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                            model.insertNodeInto(newNode, nodeParent, (int)var11_17);
                            LexiconTreeComponent.this.father.dirtenOntologies();
                        }
                    }
                });
                JMenuItem duplicate = new JMenuItem("Duplicate");
                duplicate.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LexiconTreeComponent.this.duplicateNode(node, "", "");
                    }
                });
                JMenuItem delete = new JMenuItem("Delete");
                delete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selection = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete this Lexicon Entry?");
                        if (selection == 0) {
                            LexiconTreeComponent.this.deleteNode(node);
                        }
                    }
                });
                popup.add(rename);
                popup.add(duplicate);
                popup.add(delete);
            }
            popup.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    @Override
    public JPanel TP() {
        JPanel complete = new JPanel();
        JPanel jp = new JPanel();
        JPanel treepanel = new JPanel();
        jp.setLayout(new BoxLayout(jp, 0));
        complete.setLayout(new BoxLayout(complete, 1));
        JButton buttonNew = new JButton("New Lexicon Entry");
        buttonNew.addActionListener(this);
        this.createTree();
        jp.add(buttonNew);
        jp.setBackground(new Color(255, 255, 255));
        treepanel.add(this.tree);
        treepanel.setBackground(new Color(255, 255, 255));
        treepanel.setLayout(new FlowLayout(0));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.addTreeSelectionListener(this);
        ClassLoader loader = LexiconTreeComponent.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/LexiconFolder.gif");
        ImageIcon folderIcon = new ImageIcon(imageURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(folderIcon);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(folderIcon);
        imageURL = loader.getResource("/icons/Lexicon.png");
        ImageIcon leafIcon = new ImageIcon(imageURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(leafIcon);
        JScrollPane scrollPane = new JScrollPane(treepanel);
        complete.add(jp);
        complete.add(scrollPane);
        complete.setBackground(new Color(255, 255, 255));
        return complete;
    }

    @Override
    public void addNode() {
        NewResourceDialog dlg = new NewResourceDialog("New Lexicon entry", this.treeCmp, false, "");
        if (dlg.getResponse()) {
            String name = dlg.getName();
            String type = dlg.getSecondSelected();
            IRI entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
            while (name.equals("") || !NaturalOWLTab.isLegalIRI(entryIRI) || !this.father.isUniqueIRI(entryIRI)) {
                JOptionPane.showMessageDialog(null, "The name you input is invalid or already exists. Please choose a different name.", "Invalid entity name", 0);
                dlg = new NewResourceDialog("New Lexicon entry", this.treeCmp, false, name);
                if (dlg.getResponse()) {
                    name = dlg.getName();
                    type = dlg.getSecondSelected();
                    entryIRI = IRI.create((String)(String.valueOf(NLResourceManager.resourcesNS) + name));
                    continue;
                }
                return;
            }
            if (type.equals("Adjective")) {
                this.createNewNode(this.adjectiveParent, entryIRI);
            } else if (type.equals("Noun")) {
                this.createNewNode(this.nounParent, entryIRI);
            } else if (type.equals("Verb")) {
                this.createNewNode(this.verbParent, entryIRI);
            }
        }
    }

    public void createNewNode(DefaultMutableTreeNode nodeParent, IRI name) {
        DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
        DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(name), false);
        if (nodeParent.equals(this.adjectiveParent)) {
            NaturalOWLTab.LQM.addAdjectiveEntryToLexicon(name);
        } else if (nodeParent.equals(this.nounParent)) {
            NaturalOWLTab.LQM.addNounEntryToLexicon(name);
        } else {
            NaturalOWLTab.LQM.addVerbEntryToLexicon(name);
        }
        int pos = 0;
        int i = 0;
        while (i < model.getChildCount(nodeParent)) {
            if (((ListIRI)((DefaultMutableTreeNode)model.getChild(nodeParent, i)).getUserObject()).getEntryIRI().compareTo((OWLObject)name) < 0) {
                ++pos;
            }
            ++i;
        }
        model.insertNodeInto(newNode, nodeParent, pos);
        TreePath selectedPath = new TreePath(model.getPathToRoot(newNode));
        this.tree.setSelectionPath(selectedPath);
        this.tree.scrollPathToVisible(selectedPath);
        this.father.dirtenOntologies();
    }

    @Override
    public void deleteNode(DefaultMutableTreeNode node) {
        if (this.isEntry(node)) {
            IRI toDeleteIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
            ArrayList<SentencePlan> sentencePlansList = NaturalOWLTab.SPQM.getSentencePlansList("en").getSentencePlansList();
            for (SentencePlan plan : sentencePlansList) {
                for (SPSlot sPSlot : plan.getSlotsList()) {
                    if (node.getParent().equals(this.adjectiveParent) && sPSlot instanceof SPAdjectiveSlot) {
                        if (!((SPAdjectiveSlot)sPSlot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                        JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in Sentence Plan " + plan.getSentencePlanIRI(), "Lexicon Entry is used.", 0);
                        return;
                    }
                    if (node.getParent().equals(this.nounParent) && sPSlot instanceof SPNounSlot) {
                        if (!((SPNounSlot)sPSlot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                        JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in Sentence Plan " + plan.getSentencePlanIRI(), "Lexicon Entry is used.", 0);
                        return;
                    }
                    if (!node.getParent().equals(this.verbParent) || !(sPSlot instanceof SPVerbSlot) || !((SPVerbSlot)sPSlot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                    JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in Sentence Plan " + plan.getSentencePlanIRI(), "Lexicon Entry is used.", 0);
                    return;
                }
            }
            sentencePlansList = NaturalOWLTab.SPQM.getSentencePlansList("el").getSentencePlansList();
            for (SentencePlan plan : sentencePlansList) {
                for (SPSlot sPSlot : plan.getSlotsList()) {
                    if (node.getParent().equals(this.adjectiveParent) && sPSlot instanceof SPAdjectiveSlot) {
                        if (!((SPAdjectiveSlot)sPSlot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                        JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in Sentence Plan " + plan.getSentencePlanIRI(), "Lexicon Entry is used.", 0);
                        return;
                    }
                    if (node.getParent().equals(this.nounParent) && sPSlot instanceof SPNounSlot) {
                        if (!((SPNounSlot)sPSlot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                        JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in Sentence Plan " + plan.getSentencePlanIRI(), "Lexicon Entry is used.", 0);
                        return;
                    }
                    if (!node.getParent().equals(this.verbParent) || !(sPSlot instanceof SPVerbSlot) || !((SPVerbSlot)sPSlot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                    JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in Sentence Plan " + plan.getSentencePlanIRI(), "Lexicon Entry is used.", 0);
                    return;
                }
            }
            ArrayList<NLName> nlNamesList = NaturalOWLTab.NLNQM.getNLNamesList("en").getNLNamesList();
            for (NLName nlName : nlNamesList) {
                for (NLNSlot slot : nlName.getSlotsList()) {
                    if (node.getParent().equals(this.adjectiveParent) && slot instanceof NLNAdjectiveSlot) {
                        if (!((NLNAdjectiveSlot)slot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                        JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in NLName " + nlName.getNLNameIRI(), "Lexicon Entry is used.", 0);
                        return;
                    }
                    if (!node.getParent().equals(this.nounParent) || !(slot instanceof NLNNounSlot) || !((NLNNounSlot)slot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                    JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in NLName " + nlName.getNLNameIRI(), "Lexicon Entry is used.", 0);
                    return;
                }
            }
            nlNamesList = NaturalOWLTab.NLNQM.getNLNamesList("el").getNLNamesList();
            for (NLName nlName : nlNamesList) {
                for (NLNSlot slot : nlName.getSlotsList()) {
                    if (node.getParent().equals(this.adjectiveParent) && slot instanceof NLNAdjectiveSlot) {
                        if (!((NLNAdjectiveSlot)slot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                        JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in NLName " + nlName.getNLNameIRI(), "Lexicon Entry is used.", 0);
                        return;
                    }
                    if (!node.getParent().equals(this.nounParent) || !(slot instanceof NLNNounSlot) || !((NLNNounSlot)slot).getLexiconEntryIRI().equals((Object)toDeleteIRI)) continue;
                    JOptionPane.showMessageDialog(null, "Cannot delete this lexicon entry, it is used in NLName " + nlName.getNLNameIRI(), "Lexicon Entry is used.", 0);
                    return;
                }
            }
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            NaturalOWLTab.LQM.deleteLexiconEntry(toDeleteIRI);
            if (node.getParent().getIndex(node) + 1 < node.getParent().getChildCount()) {
                TreePath treePath = new TreePath(model.getPathToRoot(node.getParent().getChildAt(node.getParent().getIndex(node) + 1)));
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
            } else if (node.getParent().getIndex(node) - 1 < node.getParent().getChildCount() && node.getParent().getIndex(node) > 0) {
                TreePath treePath = new TreePath(model.getPathToRoot(node.getParent().getChildAt(node.getParent().getIndex(node) - 1)));
                this.tree.setSelectionPath(treePath);
                this.tree.scrollPathToVisible(treePath);
            }
            model.removeNodeFromParent(node);
            this.father.dirtenOntologies();
        }
    }

    @Override
    public void duplicateNode(DefaultMutableTreeNode node, String fromLanguage, String toLanguage) {
        if (this.isEntry(node)) {
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            IRI fromIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
            String toIRISuffix = "_copy";
            IRI toIRI = IRI.create((String)(String.valueOf(fromIRI.toString()) + toIRISuffix));
            int i = 2;
            while (!this.father.isUniqueIRI(toIRI)) {
                toIRISuffix = "_copy" + i;
                toIRI = IRI.create((String)(String.valueOf(fromIRI.toString()) + toIRISuffix));
                ++i;
            }
            int pos = 0;
            if (NaturalOWLTab.LQM.isNoun(fromIRI)) {
                NaturalOWLTab.LQM.duplicateEntryInLexicon(fromIRI, toIRI);
                pos = this.nounParent.getIndex(node) + 1;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                model.insertNodeInto(newNode, this.nounParent, pos);
            } else if (NaturalOWLTab.LQM.isAdjective(fromIRI)) {
                NaturalOWLTab.LQM.duplicateEntryInLexicon(fromIRI, toIRI);
                pos = this.adjectiveParent.getIndex(node) + 1;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                model.insertNodeInto(newNode, this.adjectiveParent, pos);
            } else if (NaturalOWLTab.LQM.isVerb(fromIRI)) {
                NaturalOWLTab.LQM.duplicateEntryInLexicon(fromIRI, toIRI);
                pos = this.verbParent.getIndex(node) + 1;
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new ListIRI(toIRI), false);
                model.insertNodeInto(newNode, this.verbParent, pos);
            }
            this.father.dirtenOntologies();
        }
    }

    public boolean isEntry(DefaultMutableTreeNode node) {
        return node.isLeaf() && !node.equals(this.nounParent) && !node.equals(this.adjectiveParent) && !node.equals(this.verbParent) && !node.equals(this.parent);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        if (this.isEntry(node)) {
            NaturalOWLTab.lexiconSelectionModel.setSelectedEntity((OWLEntity)NaturalOWLTab.LQM.getNLResourcesManager().getDataFactory().getOWLNamedIndividual(((ListIRI)node.getUserObject()).getEntryIRI()));
        }
    }
}

