/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.AdjectiveEntryList;
import gr.aueb.cs.nlg.NLFiles.EntryList;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbGR;
import gr.aueb.cs.nlg.NLFiles.NounEntryList;
import gr.aueb.cs.nlg.NLFiles.VerbEntryList;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.OWLEntity;

public class LexiconTab
extends NaturalOWLTab
implements ActionListener,
ItemListener,
DocumentListener {
    private static final long serialVersionUID = 8268241587271333587L;
    private OWLModelManagerListener modelListener;
    JPanel panelSelect;
    JPanel panelTree;
    JPanel panelMain;
    JPanel panelVerb;
    JPanel panelNoun;
    JPanel panelAdjective;
    JPanel panelTense;
    JPanel panelVerbCard;
    JPanel panelVerbVoiceCard;
    JPanel panelVerbActiveTenseCard;
    JPanel panelVerbPassiveTenseCard;
    JPanel panelNounCard;
    JPanel panelAdjectiveCard;
    JPanel panelAdjectiveGenderCard;
    JPanel nounCardEn;
    JPanel nounCardGr;
    JPanel nounCardEnA;
    JPanel nounCardEnB;
    JPanel nounCardEnTop;
    JPanel nounCardGrA;
    JPanel nounCardGrB;
    JPanel nounCardGrTop;
    JPanel nounCardsEn;
    JPanel nounCardsGr;
    JComboBox<String> type;
    JComboBox<String> verbLanguage;
    JComboBox<String> voice;
    JComboBox<String> activeTense;
    JComboBox<String> passiveTense;
    JComboBox<String> nounLanguage;
    JComboBox<String> adjectiveLanguage;
    JComboBox<String> adjectiveGender;
    JLabel typeLabel;
    JLabel tenseLabel;
    JLabel languageLabel;
    JLabel voiceLabel;
    JLabel numberLabel;
    JLabel genderLabel;
    JButton nounGrGenButton;
    String selectedLanguage = "English";
    String selectedGender = "Masculine";
    String selectedVoice = "Active";
    String selectedActiveTense = "Simple Present";
    String selectedPassiveTense = "Simple Present";
    LexEntryAdjectiveEN adjectiveEN = null;
    LexEntryAdjectiveGR adjectiveGR = null;
    JTextField adjEnTextfield;
    JTextField singMascNomAdjGrTextfield;
    JTextField singMascGenAdjGrTextfield;
    JTextField singMascAccAdjGrTextfield;
    JTextField plurMascNomAdjGrTextfield;
    JTextField plurMascGenAdjGrTextfield;
    JTextField plurMascAccAdjGrTextfield;
    JTextField singFemNomAdjGrTextfield;
    JTextField singFemGenAdjGrTextfield;
    JTextField singFemAccAdjGrTextfield;
    JTextField plurFemNomAdjGrTextfield;
    JTextField plurFemGenAdjGrTextfield;
    JTextField plurFemAccAdjGrTextfield;
    JTextField singNeutNomAdjGrTextfield;
    JTextField singNeutGenAdjGrTextfield;
    JTextField singNeutAccAdjGrTextfield;
    JTextField plurNeutNomAdjGrTextfield;
    JTextField plurNeutGenAdjGrTextfield;
    JTextField plurNeutAccAdjGrTextfield;
    LexEntryNounEN nounEN = null;
    LexEntryNounGR nounGR = null;
    JRadioButton mascEnNounBut;
    JRadioButton femEnNounBut;
    JRadioButton mascFemEnNounBut;
    JRadioButton neutEnNounBut;
    JRadioButton bothEnNounBut;
    JRadioButton singEnNounBut;
    JRadioButton plEnNounBut;
    JTextField singEnNounTextfield;
    JTextField plurEnNounTextfield;
    JRadioButton mascGrNounBut;
    JRadioButton femGrNounBut;
    JRadioButton mascFemGrNounBut;
    JRadioButton neutGrNounBut;
    JRadioButton bothGrNounBut;
    JRadioButton singGrNounBut;
    JRadioButton plGrNounBut;
    JTextField singNomGrNounTextfield;
    JTextField singGenGrNounTextfield;
    JTextField singAccGrNounTextfield;
    JTextField plurNomGrNounTextfield;
    JTextField plurGenGrNounTextfield;
    JTextField plurAccGrNounTextfield;
    LexEntryVerbEN verbEN = null;
    LexEntryVerbGR verbGR = null;
    JTextField baseFormEnVerbTextfield;
    JTextField simPres3rdSingEnVerbTextfield;
    JTextField presPartEnVerbTextfield;
    JTextField simPastEnVerbTextfield;
    JTextField pastPartEnVerbTextfield;
    JTextField actSimPres1stSingGrVerbTextfield;
    JTextField actSimPres2ndSingGrVerbTextfield;
    JTextField actSimPres3rdSingGrVerbTextfield;
    JTextField actSimPres1stPlurGrVerbTextfield;
    JTextField actSimPres2ndPlurGrVerbTextfield;
    JTextField actSimPres3rdPlurGrVerbTextfield;
    JTextField actSimPast1stSingGrVerbTextfield;
    JTextField actSimPast2ndSingGrVerbTextfield;
    JTextField actSimPast3rdSingGrVerbTextfield;
    JTextField actSimPast1stPlurGrVerbTextfield;
    JTextField actSimPast2ndPlurGrVerbTextfield;
    JTextField actSimPast3rdPlurGrVerbTextfield;
    JTextField actPastCont1stSingGrVerbTextfield;
    JTextField actPastCont2ndSingGrVerbTextfield;
    JTextField actPastCont3rdSingGrVerbTextfield;
    JTextField actPastCont1stPlurGrVerbTextfield;
    JTextField actPastCont2ndPlurGrVerbTextfield;
    JTextField actPastCont3rdPlurGrVerbTextfield;
    JTextField actSimpFut1stSingGrVerbTextfield;
    JTextField actSimpFut2ndSingGrVerbTextfield;
    JTextField actSimpFut3rdSingGrVerbTextfield;
    JTextField actSimpFut1stPlurGrVerbTextfield;
    JTextField actSimpFut2ndPlurGrVerbTextfield;
    JTextField actSimpFut3rdPlurGrVerbTextfield;
    JTextField actInfGrVerbTextfield;
    JTextField actPartGrVerbTextfield;
    JTextField pasSimPres1stSingGrVerbTextfield;
    JTextField pasSimPres2ndSingGrVerbTextfield;
    JTextField pasSimPres3rdSingGrVerbTextfield;
    JTextField pasSimPres1stPlurGrVerbTextfield;
    JTextField pasSimPres2ndPlurGrVerbTextfield;
    JTextField pasSimPres3rdPlurGrVerbTextfield;
    JTextField pasSimPast1stSingGrVerbTextfield;
    JTextField pasSimPast2ndSingGrVerbTextfield;
    JTextField pasSimPast3rdSingGrVerbTextfield;
    JTextField pasSimPast1stPlurGrVerbTextfield;
    JTextField pasSimPast2ndPlurGrVerbTextfield;
    JTextField pasSimPast3rdPlurGrVerbTextfield;
    JTextField pasPastCont1stSingGrVerbTextfield;
    JTextField pasPastCont2ndSingGrVerbTextfield;
    JTextField pasPastCont3rdSingGrVerbTextfield;
    JTextField pasPastCont1stPlurGrVerbTextfield;
    JTextField pasPastCont2ndPlurGrVerbTextfield;
    JTextField pasPastCont3rdPlurGrVerbTextfield;
    JTextField pasSimpFut1stSingGrVerbTextfield;
    JTextField pasSimpFut2ndSingGrVerbTextfield;
    JTextField pasSimpFut3rdSingGrVerbTextfield;
    JTextField pasSimpFut1stPlurGrVerbTextfield;
    JTextField pasSimpFut2ndPlurGrVerbTextfield;
    JTextField pasSimpFut3rdPlurGrVerbTextfield;
    JTextField pasInfGrVerbTextfield;
    JTextField pasPartGrVerbTextfield;

    protected void initialiseOWLView() throws Exception {
        lexiconSelectionModel.addListener(new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = lexiconSelectionModel.getSelectedEntity();
                EntryList entryList = LQM.getEntryList(selected.getIRI());
                if (entryList != null) {
                    LexiconTab.this.showLexiconEntry(entryList);
                }
                LexiconTab.this.validate();
                LexiconTab.this.repaint();
            }
        });
        this.setLayout(new BorderLayout(10, 10));
        this.panelMain = new JPanel();
        this.panelMain.setLayout(new FlowLayout(0));
        JScrollPane scroll = new JScrollPane(this.panelMain);
        scroll.setViewportView(this.panelMain);
        this.add("Center", scroll);
    }

    public void viewMainSubpanel(String type) {
        if (type.compareTo("Verb") == 0) {
            this.panelMain.removeAll();
            this.showVerbPanel();
            this.repaint();
        } else if (type.compareTo("Noun") == 0) {
            this.panelMain.removeAll();
            this.showNounPanel();
            this.repaint();
        } else if (type.compareTo("Adjective") == 0) {
            this.panelMain.removeAll();
            this.showAdjectivePanel();
            this.repaint();
        }
    }

    public void showAdjectivePanel() {
        this.panelSelect = new JPanel();
        this.panelSelect.setLayout(new FlowLayout(3));
        String[] languages = new String[]{"English", "Greek"};
        this.adjectiveLanguage = new JComboBox<String>(languages);
        this.adjectiveLanguage.setSelectedItem(this.selectedLanguage);
        this.adjectiveLanguage.addItemListener(this);
        this.languageLabel = new JLabel("Language: ");
        this.panelAdjective = new JPanel();
        this.panelAdjective.setLayout(new BoxLayout(this.panelAdjective, 1));
        this.panelAdjectiveCard = new JPanel();
        this.panelAdjectiveCard.setLayout(new CardLayout());
        this.adjectiveDynamicPanels();
        this.panelSelect.add(this.languageLabel);
        this.panelSelect.add(this.adjectiveLanguage);
        this.panelAdjective.add(this.panelSelect);
        this.panelAdjective.add(this.panelAdjectiveCard);
        this.panelMain.add(this.panelAdjective);
        this.validate();
        this.repaint();
    }

    public void adjectiveDynamicPanels() {
        JPanel card1 = new JPanel();
        JPanel card2 = new JPanel();
        card1.setLayout(new FlowLayout(0));
        JLabel label1e = new JLabel("Adjective");
        this.adjEnTextfield = new JTextField(12);
        this.adjEnTextfield.getDocument().putProperty("name", "adjEn");
        card1.add(label1e);
        card1.add(this.adjEnTextfield);
        this.adjEnTextfield.setText(this.adjectiveEN.get_form());
        card2.setLayout(new BoxLayout(card2, 1));
        JPanel card2top = new JPanel();
        card2top.setLayout(new FlowLayout(0));
        this.panelAdjectiveGenderCard = new JPanel();
        this.panelAdjectiveGenderCard.setLayout(new CardLayout());
        String[] gend = new String[]{"Masculine", "Feminine", "Neuter"};
        this.adjectiveGender = new JComboBox<String>(gend);
        this.adjectiveGender.setSelectedItem(this.selectedGender);
        this.adjectiveGender.addItemListener(this);
        this.genderLabel = new JLabel("Gender: ");
        card2top.add(this.genderLabel);
        card2top.add(this.adjectiveGender);
        JPanel card2masc = new JPanel();
        JPanel mascLeft = new JPanel();
        JPanel mascRight = new JPanel();
        mascLeft.setLayout(new GridLayout(3, 1));
        mascRight.setLayout(new GridLayout(3, 1));
        JLabel label1m = new JLabel("Singular Nominative");
        this.singMascNomAdjGrTextfield = new JTextField(12);
        this.singMascNomAdjGrTextfield.getDocument().putProperty("name", "singMascNomAdjGr");
        JLabel label2m = new JLabel("Singular Genitive");
        this.singMascGenAdjGrTextfield = new JTextField(12);
        this.singMascGenAdjGrTextfield.getDocument().putProperty("name", "singMascGenAdjGr");
        JLabel label3m = new JLabel("Singular Accusative");
        this.singMascAccAdjGrTextfield = new JTextField(12);
        this.singMascAccAdjGrTextfield.getDocument().putProperty("name", "singMascAccAdjGr");
        JLabel label4m = new JLabel("Plural Nominative");
        this.plurMascNomAdjGrTextfield = new JTextField(12);
        this.plurMascNomAdjGrTextfield.getDocument().putProperty("name", "plurMascNomAdjGr");
        JLabel label5m = new JLabel("Plural Genitive");
        this.plurMascGenAdjGrTextfield = new JTextField(12);
        this.plurMascGenAdjGrTextfield.getDocument().putProperty("name", "plurMascGenAdjGr");
        JLabel label6m = new JLabel("Plural Accusative");
        this.plurMascAccAdjGrTextfield = new JTextField(12);
        this.plurMascAccAdjGrTextfield.getDocument().putProperty("name", "plurMascAccAdjGr");
        mascLeft.add(label1m);
        mascLeft.add(this.singMascNomAdjGrTextfield);
        mascLeft.add(label2m);
        mascLeft.add(this.singMascGenAdjGrTextfield);
        mascLeft.add(label3m);
        mascLeft.add(this.singMascAccAdjGrTextfield);
        mascRight.add(label4m);
        mascRight.add(this.plurMascNomAdjGrTextfield);
        mascRight.add(label5m);
        mascRight.add(this.plurMascGenAdjGrTextfield);
        mascRight.add(label6m);
        mascRight.add(this.plurMascAccAdjGrTextfield);
        card2masc.setLayout(new FlowLayout(0));
        card2masc.add(mascLeft);
        card2masc.add(mascRight);
        this.singMascNomAdjGrTextfield.setText(this.adjectiveGR.get("masculine", "singular", "nominative"));
        this.singMascGenAdjGrTextfield.setText(this.adjectiveGR.get("masculine", "singular", "genitive"));
        this.singMascAccAdjGrTextfield.setText(this.adjectiveGR.get("masculine", "singular", "accusative"));
        this.plurMascNomAdjGrTextfield.setText(this.adjectiveGR.get("masculine", "plural", "nominative"));
        this.plurMascGenAdjGrTextfield.setText(this.adjectiveGR.get("masculine", "plural", "genitive"));
        this.plurMascAccAdjGrTextfield.setText(this.adjectiveGR.get("masculine", "plural", "accusative"));
        JPanel card2fem = new JPanel();
        JPanel femLeft = new JPanel();
        JPanel femRight = new JPanel();
        femLeft.setLayout(new GridLayout(3, 2));
        femRight.setLayout(new GridLayout(3, 2));
        JLabel label1f = new JLabel("Singular Nominative");
        this.singFemNomAdjGrTextfield = new JTextField(12);
        this.singFemNomAdjGrTextfield.getDocument().putProperty("name", "singFemNomAdjGr");
        JLabel label2f = new JLabel("Singular Genitive");
        this.singFemGenAdjGrTextfield = new JTextField(12);
        this.singFemGenAdjGrTextfield.getDocument().putProperty("name", "singFemGenAdjGr");
        JLabel label3f = new JLabel("Singular Accusative");
        this.singFemAccAdjGrTextfield = new JTextField(12);
        this.singFemAccAdjGrTextfield.getDocument().putProperty("name", "singFemAccAdjGr");
        JLabel label4f = new JLabel("Plural Nominative");
        this.plurFemNomAdjGrTextfield = new JTextField(12);
        this.plurFemNomAdjGrTextfield.getDocument().putProperty("name", "plurFemNomAdjGr");
        JLabel label5f = new JLabel("Plural Genitive");
        this.plurFemGenAdjGrTextfield = new JTextField(12);
        this.plurFemGenAdjGrTextfield.getDocument().putProperty("name", "plurFemGenAdjGr");
        JLabel label6f = new JLabel("Plural Accusative");
        this.plurFemAccAdjGrTextfield = new JTextField(12);
        this.plurFemAccAdjGrTextfield.getDocument().putProperty("name", "plurFemAccAdjGr");
        femLeft.add(label1f);
        femLeft.add(this.singFemNomAdjGrTextfield);
        femLeft.add(label2f);
        femLeft.add(this.singFemGenAdjGrTextfield);
        femLeft.add(label3f);
        femLeft.add(this.singFemAccAdjGrTextfield);
        femRight.add(label4f);
        femRight.add(this.plurFemNomAdjGrTextfield);
        femRight.add(label5f);
        femRight.add(this.plurFemGenAdjGrTextfield);
        femRight.add(label6f);
        femRight.add(this.plurFemAccAdjGrTextfield);
        card2fem.setLayout(new FlowLayout(0));
        card2fem.add(femLeft);
        card2fem.add(femRight);
        this.singFemNomAdjGrTextfield.setText(this.adjectiveGR.get("feminine", "singular", "nominative"));
        this.singFemGenAdjGrTextfield.setText(this.adjectiveGR.get("feminine", "singular", "genitive"));
        this.singFemAccAdjGrTextfield.setText(this.adjectiveGR.get("feminine", "singular", "accusative"));
        this.plurFemNomAdjGrTextfield.setText(this.adjectiveGR.get("feminine", "plural", "nominative"));
        this.plurFemGenAdjGrTextfield.setText(this.adjectiveGR.get("feminine", "plural", "genitive"));
        this.plurFemAccAdjGrTextfield.setText(this.adjectiveGR.get("feminine", "plural", "accusative"));
        JPanel card2neut = new JPanel();
        JPanel neutLeft = new JPanel();
        JPanel neutRight = new JPanel();
        neutLeft.setLayout(new GridLayout(3, 1));
        neutRight.setLayout(new GridLayout(3, 1));
        JLabel label1n = new JLabel("Singular Nominative");
        this.singNeutNomAdjGrTextfield = new JTextField(12);
        this.singNeutNomAdjGrTextfield.getDocument().putProperty("name", "singNeutNomAdjGr");
        JLabel label2n = new JLabel("Singular Genitive");
        this.singNeutGenAdjGrTextfield = new JTextField(12);
        this.singNeutGenAdjGrTextfield.getDocument().putProperty("name", "singNeutGenAdjGr");
        JLabel label3n = new JLabel("Singular Accusative");
        this.singNeutAccAdjGrTextfield = new JTextField(12);
        this.singNeutAccAdjGrTextfield.getDocument().putProperty("name", "singNeutAccAdjGr");
        JLabel label4n = new JLabel("Plural Nominative");
        this.plurNeutNomAdjGrTextfield = new JTextField(12);
        this.plurNeutNomAdjGrTextfield.getDocument().putProperty("name", "plurNeutNomAdjGr");
        JLabel label5n = new JLabel("Plural Genitive");
        this.plurNeutGenAdjGrTextfield = new JTextField(12);
        this.plurNeutGenAdjGrTextfield.getDocument().putProperty("name", "plurNeutGenAdjGr");
        JLabel label6n = new JLabel("Plural Accusative");
        this.plurNeutAccAdjGrTextfield = new JTextField(12);
        this.plurNeutAccAdjGrTextfield.getDocument().putProperty("name", "plurNeutAccAdjGr");
        neutLeft.add(label1n);
        neutLeft.add(this.singNeutNomAdjGrTextfield);
        neutLeft.add(label2n);
        neutLeft.add(this.singNeutGenAdjGrTextfield);
        neutLeft.add(label3n);
        neutLeft.add(this.singNeutAccAdjGrTextfield);
        neutRight.add(label4n);
        neutRight.add(this.plurNeutNomAdjGrTextfield);
        neutRight.add(label5n);
        neutRight.add(this.plurNeutGenAdjGrTextfield);
        neutRight.add(label6n);
        neutRight.add(this.plurNeutAccAdjGrTextfield);
        card2neut.setLayout(new FlowLayout(0));
        card2neut.add(neutLeft);
        card2neut.add(neutRight);
        this.singNeutNomAdjGrTextfield.setText(this.adjectiveGR.get("neuter", "singular", "nominative"));
        this.singNeutGenAdjGrTextfield.setText(this.adjectiveGR.get("neuter", "singular", "genitive"));
        this.singNeutAccAdjGrTextfield.setText(this.adjectiveGR.get("neuter", "singular", "accusative"));
        this.plurNeutNomAdjGrTextfield.setText(this.adjectiveGR.get("neuter", "plural", "nominative"));
        this.plurNeutGenAdjGrTextfield.setText(this.adjectiveGR.get("neuter", "plural", "genitive"));
        this.plurNeutAccAdjGrTextfield.setText(this.adjectiveGR.get("neuter", "plural", "accusative"));
        this.panelAdjectiveGenderCard.add((Component)card2masc, "Masculine");
        this.panelAdjectiveGenderCard.add((Component)card2fem, "Feminine");
        this.panelAdjectiveGenderCard.add((Component)card2neut, "Neuter");
        card2.add(card2top);
        card2.add(this.panelAdjectiveGenderCard);
        this.panelAdjectiveCard.add((Component)card1, "English");
        this.panelAdjectiveCard.add((Component)card2, "Greek");
        CardLayout cl = (CardLayout)this.panelAdjectiveGenderCard.getLayout();
        cl.show(this.panelAdjectiveGenderCard, this.selectedGender);
        this.panelAdjectiveGenderCard.validate();
        cl = (CardLayout)this.panelAdjectiveCard.getLayout();
        cl.show(this.panelAdjectiveCard, this.selectedLanguage);
        this.panelAdjectiveCard.validate();
    }

    public void showNounPanel() {
        this.panelSelect = new JPanel();
        this.panelSelect.setLayout(new FlowLayout(3));
        String[] languages = new String[]{"English", "Greek"};
        this.nounLanguage = new JComboBox<String>(languages);
        this.nounLanguage.setSelectedItem(this.selectedLanguage);
        this.nounLanguage.addItemListener(this);
        this.languageLabel = new JLabel("Language: ");
        this.panelSelect.add(this.languageLabel);
        this.panelSelect.add(this.nounLanguage);
        this.panelNoun = new JPanel();
        this.panelNoun.setLayout(new BoxLayout(this.panelNoun, 1));
        this.panelNounCard = new JPanel();
        this.panelNounCard.setLayout(new CardLayout());
        this.nounDynamicPanels();
        this.panelNoun.add(this.panelSelect);
        this.panelNoun.add(this.panelNounCard);
        this.panelMain.add(this.panelNoun);
        this.validate();
        this.repaint();
    }

    public void nounDynamicPanels() {
        this.nounCardEn = new JPanel();
        this.nounCardEn.setLayout(new BoxLayout(this.nounCardEn, 1));
        JPanel panel1Gender = new JPanel();
        panel1Gender.setLayout(new FlowLayout(0));
        JPanel panelEnNumber = new JPanel();
        panelEnNumber.setLayout(new FlowLayout(0));
        this.genderLabel = new JLabel("Gender: ");
        this.mascEnNounBut = new JRadioButton("Masculine");
        this.mascEnNounBut.setActionCommand("Masculine");
        this.mascEnNounBut.setSelected(true);
        this.mascEnNounBut.addActionListener(this);
        this.femEnNounBut = new JRadioButton("Feminine");
        this.femEnNounBut.setActionCommand("Feminine");
        this.femEnNounBut.addActionListener(this);
        this.mascFemEnNounBut = new JRadioButton("Masculine/Feminine");
        this.mascFemEnNounBut.setActionCommand("Masculine/Feminine");
        this.mascFemEnNounBut.addActionListener(this);
        this.neutEnNounBut = new JRadioButton("Neuter");
        this.neutEnNounBut.setActionCommand("Neuter");
        this.neutEnNounBut.addActionListener(this);
        ButtonGroup genderGroup1 = new ButtonGroup();
        genderGroup1.add(this.mascEnNounBut);
        genderGroup1.add(this.femEnNounBut);
        genderGroup1.add(this.mascFemEnNounBut);
        genderGroup1.add(this.neutEnNounBut);
        panel1Gender.add(this.genderLabel);
        panel1Gender.add(this.mascEnNounBut);
        panel1Gender.add(this.femEnNounBut);
        panel1Gender.add(this.mascFemEnNounBut);
        panel1Gender.add(this.neutEnNounBut);
        this.numberLabel = new JLabel("Number: ");
        this.bothEnNounBut = new JRadioButton("Both");
        this.bothEnNounBut.setActionCommand("Both");
        this.bothEnNounBut.setSelected(true);
        this.bothEnNounBut.addActionListener(this);
        this.singEnNounBut = new JRadioButton("Only Singular");
        this.singEnNounBut.setActionCommand("Only Singular");
        this.singEnNounBut.addActionListener(this);
        this.plEnNounBut = new JRadioButton("Only Plural");
        this.plEnNounBut.setActionCommand("Only Plural");
        this.plEnNounBut.addActionListener(this);
        ButtonGroup numberGroupEn = new ButtonGroup();
        numberGroupEn.add(this.bothEnNounBut);
        numberGroupEn.add(this.singEnNounBut);
        numberGroupEn.add(this.plEnNounBut);
        panelEnNumber.add(this.numberLabel);
        panelEnNumber.add(this.bothEnNounBut);
        panelEnNumber.add(this.singEnNounBut);
        panelEnNumber.add(this.plEnNounBut);
        this.nounCardEnA = new JPanel();
        this.nounCardEnB = new JPanel();
        this.nounCardEnTop = new JPanel();
        this.nounCardEnA.setLayout(new GridLayout(6, 1));
        this.nounCardEnB.setLayout(new GridLayout(6, 1));
        this.nounCardEnTop.setLayout(new BoxLayout(this.nounCardEnTop, 1));
        this.nounCardEnTop.add(panel1Gender);
        this.nounCardEnTop.add(panelEnNumber);
        JLabel label1 = new JLabel("Singular");
        this.singEnNounTextfield = new JTextField(12);
        this.singEnNounTextfield.getDocument().putProperty("name", "singEnNoun");
        JLabel label2 = new JLabel("Plural");
        this.plurEnNounTextfield = new JTextField(12);
        this.plurEnNounTextfield.getDocument().putProperty("name", "plurEnNoun");
        this.nounCardEnA.add(label1);
        this.nounCardEnA.add(this.singEnNounTextfield);
        this.nounCardEnB.add(label2);
        this.nounCardEnB.add(this.plurEnNounTextfield);
        this.nounCardsEn = new JPanel();
        this.nounCardsEn.setLayout(new FlowLayout(0));
        this.nounCardsEn.add(this.nounCardEnA);
        this.nounCardsEn.add(this.nounCardEnB);
        this.nounCardEn.add(this.nounCardEnTop);
        this.nounCardEn.add(this.nounCardsEn);
        if (this.nounEN.getGender().equals("masculine")) {
            this.mascEnNounBut.setSelected(true);
        } else if (this.nounEN.getGender().equals("feminine")) {
            this.femEnNounBut.setSelected(true);
        } else if (this.nounEN.getGender().equals("neuter")) {
            this.neutEnNounBut.setSelected(true);
        } else if (this.nounEN.getGender().equals("masculineOrFeminine")) {
            this.mascFemEnNounBut.setSelected(true);
        }
        if (this.nounEN.getNumber().equals("singular")) {
            this.singEnNounBut.setSelected(true);
            this.nounCardEnA.setVisible(true);
            this.nounCardEnB.setVisible(false);
        } else if (this.nounEN.getNumber().equals("plural")) {
            this.plEnNounBut.setSelected(true);
            this.nounCardEnA.setVisible(false);
            this.nounCardEnB.setVisible(true);
        } else if (this.nounEN.getNumber().equals("both")) {
            this.bothEnNounBut.setSelected(true);
            this.nounCardEnA.setVisible(true);
            this.nounCardEnB.setVisible(true);
        }
        this.singEnNounTextfield.setText(this.nounEN.getSingular());
        this.plurEnNounTextfield.setText(this.nounEN.getPlural());
        this.nounCardGr = new JPanel();
        this.nounCardGr.setLayout(new BoxLayout(this.nounCardGr, 1));
        JPanel panel2Gender = new JPanel();
        panel2Gender.setLayout(new FlowLayout(0));
        JPanel panelGrNumber = new JPanel();
        panelGrNumber.setLayout(new FlowLayout(0));
        this.genderLabel = new JLabel("Gender: ");
        this.mascGrNounBut = new JRadioButton("Masculine");
        this.mascGrNounBut.setActionCommand("Masculine");
        this.mascGrNounBut.setSelected(true);
        this.mascGrNounBut.addActionListener(this);
        this.femGrNounBut = new JRadioButton("Feminine");
        this.femGrNounBut.setActionCommand("Feminine");
        this.femGrNounBut.addActionListener(this);
        this.mascFemGrNounBut = new JRadioButton("Masculine/Feminine");
        this.mascFemGrNounBut.setActionCommand("Masculine/Feminine");
        this.mascFemGrNounBut.addActionListener(this);
        this.neutGrNounBut = new JRadioButton("Neuter");
        this.neutGrNounBut.setActionCommand("Neuter");
        this.neutGrNounBut.addActionListener(this);
        ButtonGroup genderGroup2 = new ButtonGroup();
        genderGroup2.add(this.mascGrNounBut);
        genderGroup2.add(this.femGrNounBut);
        genderGroup2.add(this.mascFemGrNounBut);
        genderGroup2.add(this.neutGrNounBut);
        panel2Gender.add(this.genderLabel);
        panel2Gender.add(this.mascGrNounBut);
        panel2Gender.add(this.femGrNounBut);
        panel2Gender.add(this.mascFemGrNounBut);
        panel2Gender.add(this.neutGrNounBut);
        this.numberLabel = new JLabel("Number: ");
        this.bothGrNounBut = new JRadioButton("Both");
        this.bothGrNounBut.setActionCommand("Both");
        this.bothGrNounBut.setSelected(true);
        this.bothGrNounBut.addActionListener(this);
        this.singGrNounBut = new JRadioButton("Only Singular");
        this.singGrNounBut.setActionCommand("Only Singular");
        this.singGrNounBut.addActionListener(this);
        this.plGrNounBut = new JRadioButton("Only Plural");
        this.plGrNounBut.setActionCommand("Only Plural");
        this.plGrNounBut.addActionListener(this);
        ButtonGroup numberGroupGr = new ButtonGroup();
        numberGroupGr.add(this.bothGrNounBut);
        numberGroupGr.add(this.singGrNounBut);
        numberGroupGr.add(this.plGrNounBut);
        panelGrNumber.add(this.numberLabel);
        panelGrNumber.add(this.bothGrNounBut);
        panelGrNumber.add(this.singGrNounBut);
        panelGrNumber.add(this.plGrNounBut);
        this.nounCardGrA = new JPanel();
        this.nounCardGrB = new JPanel();
        this.nounCardGrTop = new JPanel();
        this.nounCardGrA.setLayout(new GridLayout(6, 1));
        this.nounCardGrB.setLayout(new GridLayout(6, 1));
        this.nounCardGrTop.setLayout(new BoxLayout(this.nounCardGrTop, 1));
        this.nounCardGrTop.add(panel2Gender);
        this.nounCardGrTop.add(panelGrNumber);
        JLabel label1g = new JLabel("Singular Nominative");
        this.singNomGrNounTextfield = new JTextField(12);
        this.singNomGrNounTextfield.getDocument().putProperty("name", "singNomGr");
        JLabel label2g = new JLabel("Singular Genitive");
        this.singGenGrNounTextfield = new JTextField(12);
        this.singGenGrNounTextfield.getDocument().putProperty("name", "singGenGr");
        JLabel label3 = new JLabel("Singular Accusative");
        this.singAccGrNounTextfield = new JTextField(12);
        this.singAccGrNounTextfield.getDocument().putProperty("name", "singAccGr");
        JLabel label4 = new JLabel("Plural Nominative");
        this.plurNomGrNounTextfield = new JTextField(12);
        this.plurNomGrNounTextfield.getDocument().putProperty("name", "plurNomGr");
        JLabel label5 = new JLabel("Plural Genitive");
        this.plurGenGrNounTextfield = new JTextField(12);
        this.plurGenGrNounTextfield.getDocument().putProperty("name", "plurGenGr");
        JLabel label6 = new JLabel("Plural Accusative");
        this.plurAccGrNounTextfield = new JTextField(12);
        this.plurAccGrNounTextfield.getDocument().putProperty("name", "plurAccGr");
        this.nounCardGrA.add(label1g);
        this.nounCardGrA.add(this.singNomGrNounTextfield);
        this.nounCardGrA.add(label2g);
        this.nounCardGrA.add(this.singGenGrNounTextfield);
        this.nounCardGrA.add(label3);
        this.nounCardGrA.add(this.singAccGrNounTextfield);
        this.nounCardGrB.add(label4);
        this.nounCardGrB.add(this.plurNomGrNounTextfield);
        this.nounCardGrB.add(label5);
        this.nounCardGrB.add(this.plurGenGrNounTextfield);
        this.nounCardGrB.add(label6);
        this.nounCardGrB.add(this.plurAccGrNounTextfield);
        this.nounCardGr.add(this.nounCardGrTop);
        this.nounCardsGr = new JPanel();
        this.nounCardsGr.setLayout(new FlowLayout(0));
        this.nounCardsGr.add(this.nounCardGrA);
        this.nounCardsGr.add(this.nounCardGrB);
        this.nounCardGr.add(this.nounCardsGr);
        if (this.nounGR.getGender().equals("masculine")) {
            this.mascGrNounBut.setSelected(true);
        } else if (this.nounGR.getGender().equals("feminine")) {
            this.femGrNounBut.setSelected(true);
        } else if (this.nounGR.getGender().equals("neuter")) {
            this.neutGrNounBut.setSelected(true);
        } else if (this.nounGR.getGender().equals("masculineOrFeminine")) {
            this.mascFemGrNounBut.setSelected(true);
        }
        if (this.nounGR.getNumber().equals("singular")) {
            this.singGrNounBut.setSelected(true);
            this.nounCardGrA.setVisible(true);
            this.nounCardGrB.setVisible(false);
        } else if (this.nounGR.getNumber().equals("plural")) {
            this.plGrNounBut.setSelected(true);
            this.nounCardGrA.setVisible(false);
            this.nounCardGrB.setVisible(true);
        } else if (this.nounGR.getNumber().equals("both")) {
            this.bothGrNounBut.setSelected(true);
            this.nounCardGrA.setVisible(true);
            this.nounCardGrB.setVisible(true);
        }
        this.singNomGrNounTextfield.setText(this.nounGR.get("nominative", "singular"));
        this.singGenGrNounTextfield.setText(this.nounGR.get("genitive", "singular"));
        this.singAccGrNounTextfield.setText(this.nounGR.get("accusative", "singular"));
        this.plurNomGrNounTextfield.setText(this.nounGR.get("nominative", "plural"));
        this.plurGenGrNounTextfield.setText(this.nounGR.get("genitive", "plural"));
        this.plurAccGrNounTextfield.setText(this.nounGR.get("accusative", "plural"));
        this.panelNounCard.add((Component)this.nounCardEn, "English");
        this.panelNounCard.add((Component)this.nounCardGr, "Greek");
        CardLayout cl = (CardLayout)this.panelNounCard.getLayout();
        cl.show(this.panelNounCard, this.selectedLanguage);
        this.panelNounCard.validate();
    }

    public void showVerbPanel() {
        String[] choices = new String[]{"English", "Greek"};
        this.verbLanguage = new JComboBox<String>(choices);
        this.verbLanguage.setSelectedItem(this.selectedLanguage);
        this.verbLanguage.addItemListener(this);
        this.languageLabel = new JLabel("Language: ");
        this.panelSelect = new JPanel();
        this.panelSelect.setLayout(new FlowLayout(3));
        this.panelSelect.add(this.languageLabel);
        this.panelSelect.add(this.verbLanguage);
        this.panelVerb = new JPanel();
        this.panelVerb.setLayout(new BoxLayout(this.panelVerb, 1));
        this.panelVerbCard = new JPanel();
        this.panelVerbCard.setLayout(new CardLayout());
        this.verbDynamicPanels();
        this.panelVerb.add(this.panelSelect);
        this.panelVerb.add(this.panelVerbCard);
        this.panelMain.add(this.panelVerb);
        this.validate();
        this.repaint();
    }

    public void verbDynamicPanels() {
        JPanel verbCard1 = new JPanel();
        verbCard1.setLayout(new FlowLayout(3));
        JPanel verbCard1a = new JPanel();
        JPanel verbCard1b = new JPanel();
        verbCard1a.setLayout(new GridLayout(10, 1));
        verbCard1b.setLayout(new GridLayout(10, 1));
        JLabel label1 = new JLabel("Base Form");
        this.baseFormEnVerbTextfield = new JTextField(12);
        this.baseFormEnVerbTextfield.getDocument().putProperty("name", "baseFormEnVerb");
        this.baseFormEnVerbTextfield.setToolTipText("ex.: give");
        JLabel label2 = new JLabel("Simple Present 3rd Singular");
        this.simPres3rdSingEnVerbTextfield = new JTextField(12);
        this.simPres3rdSingEnVerbTextfield.getDocument().putProperty("name", "simPres3rdSingEnVerb");
        this.simPres3rdSingEnVerbTextfield.setToolTipText("ex.: gives");
        JLabel label3 = new JLabel("Present Participle");
        this.presPartEnVerbTextfield = new JTextField(12);
        this.presPartEnVerbTextfield.getDocument().putProperty("name", "presPartEnVerb");
        this.presPartEnVerbTextfield.setToolTipText("ex.: giving");
        JLabel label4 = new JLabel("Simple Past");
        this.simPastEnVerbTextfield = new JTextField(12);
        this.simPastEnVerbTextfield.getDocument().putProperty("name", "simPastEnVerb");
        this.simPastEnVerbTextfield.setToolTipText("ex.: gave");
        JLabel label5 = new JLabel("Past Participle");
        this.pastPartEnVerbTextfield = new JTextField(12);
        this.pastPartEnVerbTextfield.getDocument().putProperty("name", "pastPartEnVerb");
        this.pastPartEnVerbTextfield.setToolTipText("ex.: given");
        verbCard1a.add(label1);
        verbCard1a.add(this.baseFormEnVerbTextfield);
        verbCard1a.add(label2);
        verbCard1a.add(this.simPres3rdSingEnVerbTextfield);
        verbCard1a.add(label3);
        verbCard1a.add(this.presPartEnVerbTextfield);
        verbCard1b.add(label4);
        verbCard1b.add(this.simPastEnVerbTextfield);
        verbCard1b.add(label5);
        verbCard1b.add(this.pastPartEnVerbTextfield);
        verbCard1.add(verbCard1a);
        verbCard1.add(verbCard1b);
        this.baseFormEnVerbTextfield.setText(this.verbEN.getBaseForm());
        this.simPres3rdSingEnVerbTextfield.setText(this.verbEN.getSimplePresent3rdSingular());
        this.presPartEnVerbTextfield.setText(this.verbEN.getPresentParticiple());
        this.simPastEnVerbTextfield.setText(this.verbEN.getSimplePast());
        this.pastPartEnVerbTextfield.setText(this.verbEN.getPastParticiple());
        JPanel verbCard2 = new JPanel();
        JPanel panelVoice = new JPanel();
        panelVoice.setLayout(new FlowLayout(3));
        verbCard2.setLayout(new BorderLayout(5, 5));
        String[] voices = new String[]{"Active", "Passive"};
        this.voice = new JComboBox<String>(voices);
        this.voice.setSelectedItem(this.selectedVoice);
        this.voice.addItemListener(this);
        this.voiceLabel = new JLabel("Voice: ");
        panelVoice.add(this.voiceLabel);
        panelVoice.add(this.voice);
        verbCard2.add((Component)panelVoice, "North");
        this.panelVerbVoiceCard = new JPanel();
        this.panelVerbVoiceCard.setLayout(new CardLayout());
        verbCard2.add(this.panelVerbVoiceCard);
        this.dynamicVoicePanels();
        this.panelVerbCard.add((Component)verbCard1, "English");
        this.panelVerbCard.add((Component)verbCard2, "Greek");
        CardLayout cl = (CardLayout)this.panelVerbVoiceCard.getLayout();
        cl.show(this.panelVerbVoiceCard, this.selectedVoice);
        this.panelVerbVoiceCard.validate();
        cl = (CardLayout)this.panelVerbCard.getLayout();
        cl.show(this.panelVerbCard, this.selectedLanguage);
        this.panelVerbCard.validate();
    }

    public void dynamicVoicePanels() {
        JPanel panelActive = new JPanel();
        JPanel panelPassive = new JPanel();
        panelActive.setLayout(new BorderLayout(5, 5));
        panelPassive.setLayout(new BorderLayout(5, 5));
        String[] actTenses = new String[]{"Simple Present", "Simple Past", "Past Continuous", "Simple Future", "Infinitive", "Participle"};
        this.activeTense = new JComboBox<String>(actTenses);
        this.activeTense.setSelectedItem(this.selectedActiveTense);
        this.activeTense.addItemListener(this);
        this.tenseLabel = new JLabel("Tense: ");
        JPanel panelTense = new JPanel();
        panelTense.setLayout(new FlowLayout(3));
        panelTense.add(this.tenseLabel);
        panelTense.add(this.activeTense);
        panelActive.add((Component)panelTense, "North");
        this.panelVerbActiveTenseCard = new JPanel();
        this.panelVerbActiveTenseCard.setLayout(new CardLayout());
        JPanel aspr = new JPanel();
        JPanel aspr1 = new JPanel();
        JPanel aspr2 = new JPanel();
        JPanel aspr3 = new JPanel();
        JPanel aspr4 = new JPanel();
        JPanel aspr5 = new JPanel();
        JPanel aspr6 = new JPanel();
        JPanel asp = new JPanel();
        JPanel asp1 = new JPanel();
        JPanel asp2 = new JPanel();
        JPanel asp3 = new JPanel();
        JPanel asp4 = new JPanel();
        JPanel asp5 = new JPanel();
        JPanel asp6 = new JPanel();
        JPanel apc = new JPanel();
        JPanel apc1 = new JPanel();
        JPanel apc2 = new JPanel();
        JPanel apc3 = new JPanel();
        JPanel apc4 = new JPanel();
        JPanel apc5 = new JPanel();
        JPanel apc6 = new JPanel();
        JPanel asf = new JPanel();
        JPanel asf1 = new JPanel();
        JPanel asf2 = new JPanel();
        JPanel asf3 = new JPanel();
        JPanel asf4 = new JPanel();
        JPanel asf5 = new JPanel();
        JPanel asf6 = new JPanel();
        JPanel ai = new JPanel();
        JPanel ai1 = new JPanel();
        JPanel ap = new JPanel();
        JPanel ap1 = new JPanel();
        aspr.setLayout(new GridLayout(8, 0));
        aspr1.setLayout(new FlowLayout(3));
        aspr2.setLayout(new FlowLayout(3));
        aspr3.setLayout(new FlowLayout(3));
        aspr4.setLayout(new FlowLayout(3));
        aspr5.setLayout(new FlowLayout(3));
        aspr6.setLayout(new FlowLayout(3));
        asp.setLayout(new GridLayout(8, 0));
        asp1.setLayout(new FlowLayout(3));
        asp2.setLayout(new FlowLayout(3));
        asp3.setLayout(new FlowLayout(3));
        asp4.setLayout(new FlowLayout(3));
        asp5.setLayout(new FlowLayout(3));
        asp6.setLayout(new FlowLayout(3));
        apc.setLayout(new GridLayout(8, 0));
        apc1.setLayout(new FlowLayout(3));
        apc2.setLayout(new FlowLayout(3));
        apc3.setLayout(new FlowLayout(3));
        apc4.setLayout(new FlowLayout(3));
        apc5.setLayout(new FlowLayout(3));
        apc6.setLayout(new FlowLayout(3));
        asf.setLayout(new GridLayout(8, 0));
        asf1.setLayout(new FlowLayout(3));
        asf2.setLayout(new FlowLayout(3));
        asf3.setLayout(new FlowLayout(3));
        asf4.setLayout(new FlowLayout(3));
        asf5.setLayout(new FlowLayout(3));
        asf6.setLayout(new FlowLayout(3));
        ai.setLayout(new GridLayout(8, 0));
        ai1.setLayout(new FlowLayout(3));
        ap.setLayout(new GridLayout(8, 0));
        ap1.setLayout(new FlowLayout(3));
        JLabel labelpr1s = new JLabel("Active Simple Present 1st Singular");
        this.actSimPres1stSingGrVerbTextfield = new JTextField(12);
        this.actSimPres1stSingGrVerbTextfield.getDocument().putProperty("name", "actSimPres1stSingGrVerb");
        this.actSimPres1stSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03c9");
        JLabel labelpr2s = new JLabel("Active Simple Present 2nd Singular");
        this.actSimPres2ndSingGrVerbTextfield = new JTextField(12);
        this.actSimPres2ndSingGrVerbTextfield.getDocument().putProperty("name", "actSimPres2ndSingGrVerb");
        this.actSimPres2ndSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03b9\u03c2");
        JLabel labelpr3s = new JLabel("Active Simple Present 3rd Singular");
        this.actSimPres3rdSingGrVerbTextfield = new JTextField(12);
        this.actSimPres3rdSingGrVerbTextfield.getDocument().putProperty("name", "actSimPres3rdSingGrVerb");
        this.actSimPres3rdSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03b9");
        JLabel labelpr1p = new JLabel("Active Simple Present 1st Plural");
        this.actSimPres1stPlurGrVerbTextfield = new JTextField(12);
        this.actSimPres1stPlurGrVerbTextfield.getDocument().putProperty("name", "actSimPres1stPlurGrVerb");
        this.actSimPres1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03c5\u03bc\u03b5");
        JLabel labelpr2p = new JLabel("Active Simple Present 2nd Plural");
        this.actSimPres2ndPlurGrVerbTextfield = new JTextField(12);
        this.actSimPres2ndPlurGrVerbTextfield.getDocument().putProperty("name", "actSimPres2ndPlurGrVerb");
        this.actSimPres2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03c4\u03b5");
        JLabel labelpr3p = new JLabel("Active Simple Present 3rd Plural");
        this.actSimPres3rdPlurGrVerbTextfield = new JTextField(12);
        this.actSimPres3rdPlurGrVerbTextfield.getDocument().putProperty("name", "actSimPres3rdPlurGrVerb");
        this.actSimPres3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03c5\u03bd");
        JLabel labelp1s = new JLabel("Active Simple Past 1st Singular");
        this.actSimPast1stSingGrVerbTextfield = new JTextField(12);
        this.actSimPast1stSingGrVerbTextfield.getDocument().putProperty("name", "actSimPast1stSingGrVerb");
        this.actSimPast1stSingGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b1");
        JLabel labelp2s = new JLabel("Active Simple Past 2nd Singular");
        this.actSimPast2ndSingGrVerbTextfield = new JTextField(12);
        this.actSimPast2ndSingGrVerbTextfield.getDocument().putProperty("name", "actSimPast2ndSingGrVerb");
        this.actSimPast2ndSingGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b5\u03c2");
        JLabel labelp3s = new JLabel("Active Simple Past 3rd Singular");
        this.actSimPast3rdSingGrVerbTextfield = new JTextField(12);
        this.actSimPast3rdSingGrVerbTextfield.getDocument().putProperty("name", "actSimPast3rdSingGrVerb");
        this.actSimPast3rdSingGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b5");
        JLabel labelp1p = new JLabel("Active Simple Past 1st Plural");
        this.actSimPast1stPlurGrVerbTextfield = new JTextField(12);
        this.actSimPast1stPlurGrVerbTextfield.getDocument().putProperty("name", "actSimPast1stPlurGrVerb");
        this.actSimPast1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b1\u03bc\u03b5");
        JLabel labelp2p = new JLabel("Active Simple Past 2nd Plural");
        this.actSimPast2ndPlurGrVerbTextfield = new JTextField(12);
        this.actSimPast2ndPlurGrVerbTextfield.getDocument().putProperty("name", "actSimPast2ndPlurGrVerb");
        this.actSimPast2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b1\u03c4\u03b5");
        JLabel labelp3p = new JLabel("Active Simple Past 3rd Plural");
        this.actSimPast3rdPlurGrVerbTextfield = new JTextField(12);
        this.actSimPast3rdPlurGrVerbTextfield.getDocument().putProperty("name", "actSimPast3rdPlurGrVerb");
        this.actSimPast3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b1\u03bd");
        JLabel labelpc1s = new JLabel("Active Past Continuous 1st Singular");
        this.actPastCont1stSingGrVerbTextfield = new JTextField(12);
        this.actPastCont1stSingGrVerbTextfield.getDocument().putProperty("name", "actPastCont1stSingGrVerb");
        this.actPastCont1stSingGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b1");
        JLabel labelpc2s = new JLabel("Active Past Continuous 2nd Singular");
        this.actPastCont2ndSingGrVerbTextfield = new JTextField(12);
        this.actPastCont2ndSingGrVerbTextfield.getDocument().putProperty("name", "actPastCont2ndSingGrVerb");
        this.actPastCont2ndSingGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b5\u03c2");
        JLabel labelpc3s = new JLabel("Active Past Continuous 3rd Singular");
        this.actPastCont3rdSingGrVerbTextfield = new JTextField(12);
        this.actPastCont3rdSingGrVerbTextfield.getDocument().putProperty("name", "actPastCont3rdSingGrVerb");
        this.actPastCont3rdSingGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b5");
        JLabel labelpc1p = new JLabel("Active Past Continuous 1st Plural");
        this.actPastCont1stPlurGrVerbTextfield = new JTextField(12);
        this.actPastCont1stPlurGrVerbTextfield.getDocument().putProperty("name", "actPastCont1stPlurGrVerb");
        this.actPastCont1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b1\u03bc\u03b5");
        JLabel labelpc2p = new JLabel("Active Past Continuous 2nd Plural");
        this.actPastCont2ndPlurGrVerbTextfield = new JTextField(12);
        this.actPastCont2ndPlurGrVerbTextfield.getDocument().putProperty("name", "actPastCont2ndPlurGrVerb");
        this.actPastCont2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b1\u03c4\u03b5");
        JLabel labelpc3p = new JLabel("Active Past Continuous 3rd Plural");
        this.actPastCont3rdPlurGrVerbTextfield = new JTextField(12);
        this.actPastCont3rdPlurGrVerbTextfield.getDocument().putProperty("name", "actPastCont3rdPlurGrVerb");
        this.actPastCont3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03ad\u03b2\u03b1\u03c6\u03b1\u03bd");
        JLabel labelf1s = new JLabel("Active Simple Future 1st Singular");
        JLabel labelf1sPlus = new JLabel("\u03b8\u03b1 ");
        this.actSimpFut1stSingGrVerbTextfield = new JTextField(12);
        this.actSimpFut1stSingGrVerbTextfield.getDocument().putProperty("name", "actSimpFut1stSingGrVerb");
        this.actSimpFut1stSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03c9");
        JLabel labelf2s = new JLabel("Active Simple Future 2nd Singular");
        JLabel labelf2sPlus = new JLabel("\u03b8\u03b1 ");
        this.actSimpFut2ndSingGrVerbTextfield = new JTextField(12);
        this.actSimpFut2ndSingGrVerbTextfield.getDocument().putProperty("name", "actSimpFut2ndSingGrVerb");
        this.actSimpFut2ndSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03b9\u03c2");
        JLabel labelf3s = new JLabel("Active Simple Future 3rd Singular");
        JLabel labelf3sPlus = new JLabel("\u03b8\u03b1 ");
        this.actSimpFut3rdSingGrVerbTextfield = new JTextField(12);
        this.actSimpFut3rdSingGrVerbTextfield.getDocument().putProperty("name", "actSimpFut3rdSingGrVerb");
        this.actSimpFut3rdSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03b9");
        JLabel labelf1p = new JLabel("Active Simple Future 1st Plural");
        JLabel labelf1pPlus = new JLabel("\u03b8\u03b1 ");
        this.actSimpFut1stPlurGrVerbTextfield = new JTextField(12);
        this.actSimpFut1stPlurGrVerbTextfield.getDocument().putProperty("name", "actSimpFut1stPlurGrVerb");
        this.actSimpFut1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03c5\u03bc\u03b5");
        JLabel labelf2p = new JLabel("Active Simple Future 2nd Plural");
        JLabel labelf2pPlus = new JLabel("\u03b8\u03b1 ");
        this.actSimpFut2ndPlurGrVerbTextfield = new JTextField(12);
        this.actSimpFut2ndPlurGrVerbTextfield.getDocument().putProperty("name", "actSimpFut2ndPlurGrVerb");
        this.actSimpFut2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03c4\u03b5");
        JLabel labelf3p = new JLabel("Active Simple Future 3rd Plural");
        JLabel labelf3pPlus = new JLabel("\u03b8\u03b1 ");
        this.actSimpFut3rdPlurGrVerbTextfield = new JTextField(12);
        this.actSimpFut3rdPlurGrVerbTextfield.getDocument().putProperty("name", "actSimpFut3rdPlurGrVerb");
        this.actSimpFut3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03c5\u03bd");
        JLabel labelai = new JLabel("Active Infinitive");
        this.actInfGrVerbTextfield = new JTextField(12);
        this.actInfGrVerbTextfield.getDocument().putProperty("name", "actInfGrVerb");
        this.actInfGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03b9");
        JLabel labelap = new JLabel("Active Participle");
        this.actPartGrVerbTextfield = new JTextField(12);
        this.actPartGrVerbTextfield.getDocument().putProperty("name", "actPartGrVerb");
        this.actPartGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03bd\u03c4\u03b1\u03c2");
        Dimension d = labelpr1s.getPreferredSize();
        int tenseLabelWidth = 200;
        labelpr1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpr2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpr3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpr1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpr2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpr3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelp1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelp2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelp3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelp1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelp2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelp3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpc1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpc2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpc3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpc1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpc2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelpc3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelf1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelf2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelf3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelf1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelf2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelf3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelai.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        labelap.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        aspr1.add(labelpr1s);
        aspr1.add(this.actSimPres1stSingGrVerbTextfield);
        aspr2.add(labelpr2s);
        aspr2.add(this.actSimPres2ndSingGrVerbTextfield);
        aspr3.add(labelpr3s);
        aspr3.add(this.actSimPres3rdSingGrVerbTextfield);
        aspr4.add(labelpr1p);
        aspr4.add(this.actSimPres1stPlurGrVerbTextfield);
        aspr5.add(labelpr2p);
        aspr5.add(this.actSimPres2ndPlurGrVerbTextfield);
        aspr6.add(labelpr3p);
        aspr6.add(this.actSimPres3rdPlurGrVerbTextfield);
        aspr.add(aspr1);
        aspr.add(aspr2);
        aspr.add(aspr3);
        aspr.add(aspr4);
        aspr.add(aspr5);
        aspr.add(aspr6);
        asp1.add(labelp1s);
        asp1.add(this.actSimPast1stSingGrVerbTextfield);
        asp2.add(labelp2s);
        asp2.add(this.actSimPast2ndSingGrVerbTextfield);
        asp3.add(labelp3s);
        asp3.add(this.actSimPast3rdSingGrVerbTextfield);
        asp4.add(labelp1p);
        asp4.add(this.actSimPast1stPlurGrVerbTextfield);
        asp5.add(labelp2p);
        asp5.add(this.actSimPast2ndPlurGrVerbTextfield);
        asp6.add(labelp3p);
        asp6.add(this.actSimPast3rdPlurGrVerbTextfield);
        asp.add(asp1);
        asp.add(asp2);
        asp.add(asp3);
        asp.add(asp4);
        asp.add(asp5);
        asp.add(asp6);
        apc1.add(labelpc1s);
        apc1.add(this.actPastCont1stSingGrVerbTextfield);
        apc2.add(labelpc2s);
        apc2.add(this.actPastCont2ndSingGrVerbTextfield);
        apc3.add(labelpc3s);
        apc3.add(this.actPastCont3rdSingGrVerbTextfield);
        apc4.add(labelpc1p);
        apc4.add(this.actPastCont1stPlurGrVerbTextfield);
        apc5.add(labelpc2p);
        apc5.add(this.actPastCont2ndPlurGrVerbTextfield);
        apc6.add(labelpc3p);
        apc6.add(this.actPastCont3rdPlurGrVerbTextfield);
        apc.add(apc1);
        apc.add(apc2);
        apc.add(apc3);
        apc.add(apc4);
        apc.add(apc5);
        apc.add(apc6);
        asf1.add(labelf1s);
        asf1.add(labelf1sPlus);
        asf1.add(this.actSimpFut1stSingGrVerbTextfield);
        asf2.add(labelf2s);
        asf2.add(labelf2sPlus);
        asf2.add(this.actSimpFut2ndSingGrVerbTextfield);
        asf3.add(labelf3s);
        asf3.add(labelf3sPlus);
        asf3.add(this.actSimpFut3rdSingGrVerbTextfield);
        asf4.add(labelf1p);
        asf4.add(labelf1pPlus);
        asf4.add(this.actSimpFut1stPlurGrVerbTextfield);
        asf5.add(labelf2p);
        asf5.add(labelf2pPlus);
        asf5.add(this.actSimpFut2ndPlurGrVerbTextfield);
        asf6.add(labelf3p);
        asf6.add(labelf3pPlus);
        asf6.add(this.actSimpFut3rdPlurGrVerbTextfield);
        asf.add(asf1);
        asf.add(asf2);
        asf.add(asf3);
        asf.add(asf4);
        asf.add(asf5);
        asf.add(asf6);
        ai1.add(labelai);
        ai1.add(this.actInfGrVerbTextfield);
        ai.add(ai1);
        ap1.add(labelap);
        ap1.add(this.actPartGrVerbTextfield);
        ap.add(ap1);
        this.panelVerbActiveTenseCard.add((Component)aspr, "Simple Present");
        this.panelVerbActiveTenseCard.add((Component)asp, "Simple Past");
        this.panelVerbActiveTenseCard.add((Component)apc, "Past Continuous");
        this.panelVerbActiveTenseCard.add((Component)asf, "Simple Future");
        this.panelVerbActiveTenseCard.add((Component)ai, "Infinitive");
        this.panelVerbActiveTenseCard.add((Component)ap, "Participle");
        panelActive.add((Component)this.panelVerbActiveTenseCard, "Center");
        this.actSimPres1stSingGrVerbTextfield.setText(this.verbGR.get("active", "simple present", "1st", "singular"));
        this.actSimPres2ndSingGrVerbTextfield.setText(this.verbGR.get("active", "simple present", "2nd", "singular"));
        this.actSimPres3rdSingGrVerbTextfield.setText(this.verbGR.get("active", "simple present", "3rd", "singular"));
        this.actSimPres1stPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple present", "1st", "plural"));
        this.actSimPres2ndPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple present", "2nd", "plural"));
        this.actSimPres3rdPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple present", "3rd", "plural"));
        this.actSimPast1stSingGrVerbTextfield.setText(this.verbGR.get("active", "simple past", "1st", "singular"));
        this.actSimPast2ndSingGrVerbTextfield.setText(this.verbGR.get("active", "simple past", "2nd", "singular"));
        this.actSimPast3rdSingGrVerbTextfield.setText(this.verbGR.get("active", "simple past", "3rd", "singular"));
        this.actSimPast1stPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple past", "1st", "plural"));
        this.actSimPast2ndPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple past", "2nd", "plural"));
        this.actSimPast3rdPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple past", "3rd", "plural"));
        this.actPastCont1stSingGrVerbTextfield.setText(this.verbGR.get("active", "past continuous", "1st", "singular"));
        this.actPastCont2ndSingGrVerbTextfield.setText(this.verbGR.get("active", "past continuous", "2nd", "singular"));
        this.actPastCont3rdSingGrVerbTextfield.setText(this.verbGR.get("active", "past continuous", "3rd", "singular"));
        this.actPastCont1stPlurGrVerbTextfield.setText(this.verbGR.get("active", "past continuous", "1st", "plural"));
        this.actPastCont2ndPlurGrVerbTextfield.setText(this.verbGR.get("active", "past continuous", "2nd", "plural"));
        this.actPastCont3rdPlurGrVerbTextfield.setText(this.verbGR.get("active", "past continuous", "3rd", "plural"));
        this.actSimpFut1stSingGrVerbTextfield.setText(this.verbGR.get("active", "simple future", "1st", "singular"));
        this.actSimpFut2ndSingGrVerbTextfield.setText(this.verbGR.get("active", "simple future", "2nd", "singular"));
        this.actSimpFut3rdSingGrVerbTextfield.setText(this.verbGR.get("active", "simple future", "3rd", "singular"));
        this.actSimpFut1stPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple future", "1st", "plural"));
        this.actSimpFut2ndPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple future", "2nd", "plural"));
        this.actSimpFut3rdPlurGrVerbTextfield.setText(this.verbGR.get("active", "simple future", "3rd", "plural"));
        this.actInfGrVerbTextfield.setText(this.verbGR.get("active", "infinitive", "", ""));
        this.actPartGrVerbTextfield.setText(this.verbGR.get("active", "participle", "", ""));
        String[] pasTenses = new String[]{"Simple Present", "Simple Past", "Past Continuous", "Simple Future", "Infinitive", "Participle"};
        this.passiveTense = new JComboBox<String>(pasTenses);
        this.passiveTense.setSelectedItem(this.selectedPassiveTense);
        this.passiveTense.addItemListener(this);
        this.tenseLabel = new JLabel("Tense: ");
        JPanel panelTense1 = new JPanel();
        panelTense1.setLayout(new FlowLayout(3));
        panelTense1.add(this.tenseLabel);
        panelTense1.add(this.passiveTense);
        panelPassive.add((Component)panelTense1, "North");
        this.panelVerbPassiveTenseCard = new JPanel();
        this.panelVerbPassiveTenseCard.setLayout(new CardLayout());
        JPanel pspr = new JPanel();
        JPanel pspr1 = new JPanel();
        JPanel pspr2 = new JPanel();
        JPanel pspr3 = new JPanel();
        JPanel pspr4 = new JPanel();
        JPanel pspr5 = new JPanel();
        JPanel pspr6 = new JPanel();
        JPanel psp = new JPanel();
        JPanel psp1 = new JPanel();
        JPanel psp2 = new JPanel();
        JPanel psp3 = new JPanel();
        JPanel psp4 = new JPanel();
        JPanel psp5 = new JPanel();
        JPanel psp6 = new JPanel();
        JPanel ppc = new JPanel();
        JPanel ppc1 = new JPanel();
        JPanel ppc2 = new JPanel();
        JPanel ppc3 = new JPanel();
        JPanel ppc4 = new JPanel();
        JPanel ppc5 = new JPanel();
        JPanel ppc6 = new JPanel();
        JPanel psf = new JPanel();
        JPanel psf1 = new JPanel();
        JPanel psf2 = new JPanel();
        JPanel psf3 = new JPanel();
        JPanel psf4 = new JPanel();
        JPanel psf5 = new JPanel();
        JPanel psf6 = new JPanel();
        JPanel pi = new JPanel();
        JPanel pi1 = new JPanel();
        JPanel pp = new JPanel();
        JPanel pp1 = new JPanel();
        pspr.setLayout(new GridLayout(8, 0));
        pspr1.setLayout(new FlowLayout(3));
        pspr2.setLayout(new FlowLayout(3));
        pspr3.setLayout(new FlowLayout(3));
        pspr4.setLayout(new FlowLayout(3));
        pspr5.setLayout(new FlowLayout(3));
        pspr6.setLayout(new FlowLayout(3));
        psp.setLayout(new GridLayout(8, 0));
        psp1.setLayout(new FlowLayout(3));
        psp2.setLayout(new FlowLayout(3));
        psp3.setLayout(new FlowLayout(3));
        psp4.setLayout(new FlowLayout(3));
        psp5.setLayout(new FlowLayout(3));
        psp6.setLayout(new FlowLayout(3));
        ppc.setLayout(new GridLayout(8, 0));
        ppc1.setLayout(new FlowLayout(3));
        ppc2.setLayout(new FlowLayout(3));
        ppc3.setLayout(new FlowLayout(3));
        ppc4.setLayout(new FlowLayout(3));
        ppc5.setLayout(new FlowLayout(3));
        ppc6.setLayout(new FlowLayout(3));
        psf.setLayout(new GridLayout(8, 0));
        psf1.setLayout(new FlowLayout(3));
        psf2.setLayout(new FlowLayout(3));
        psf3.setLayout(new FlowLayout(3));
        psf4.setLayout(new FlowLayout(3));
        psf5.setLayout(new FlowLayout(3));
        psf6.setLayout(new FlowLayout(3));
        pi.setLayout(new GridLayout(8, 0));
        pi1.setLayout(new FlowLayout(3));
        pp.setLayout(new GridLayout(8, 0));
        pp1.setLayout(new FlowLayout(3));
        JLabel plabelpr1s = new JLabel("Passive Simple Present 1st Singular");
        this.pasSimPres1stSingGrVerbTextfield = new JTextField(12);
        this.pasSimPres1stSingGrVerbTextfield.getDocument().putProperty("name", "pasSimPres1stSingGrVerb");
        this.pasSimPres1stSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03bc\u03b1\u03b9");
        JLabel plabelpr2s = new JLabel("Passive Simple Present 2nd Singular");
        this.pasSimPres2ndSingGrVerbTextfield = new JTextField(12);
        this.pasSimPres2ndSingGrVerbTextfield.getDocument().putProperty("name", "pasSimPres2ndSingGrVerb");
        this.pasSimPres2ndSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03c3\u03b1\u03b9");
        JLabel plabelpr3s = new JLabel("Passive Simple Present 3rd Singular");
        this.pasSimPres3rdSingGrVerbTextfield = new JTextField(12);
        this.pasSimPres3rdSingGrVerbTextfield.getDocument().putProperty("name", "pasSimPres3rdSingGrVerb");
        this.pasSimPres3rdSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03c4\u03b1\u03b9");
        JLabel plabelpr1p = new JLabel("Passive Simple Present 1st Plural");
        this.pasSimPres1stPlurGrVerbTextfield = new JTextField(12);
        this.pasSimPres1stPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimPres1stPlurGrVerb");
        this.pasSimPres1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03cc\u03bc\u03b1\u03c3\u03c4\u03b5");
        JLabel plabelpr2p = new JLabel("Passive Simple Present 2nd Plural");
        this.pasSimPres2ndPlurGrVerbTextfield = new JTextField(12);
        this.pasSimPres2ndPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimPres2ndPlurGrVerb");
        this.pasSimPres2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03b5\u03c3\u03c4\u03b5");
        JLabel plabelpr3p = new JLabel("Passive Simple Present 3rd Plural");
        this.pasSimPres3rdPlurGrVerbTextfield = new JTextField(12);
        this.pasSimPres3rdPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimPres3rdPlurGrVerb");
        this.pasSimPres3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03bd\u03c4\u03b1\u03b9");
        JLabel plabelp1s = new JLabel("Passive Simple Past 1st Singular");
        this.pasSimPast1stSingGrVerbTextfield = new JTextField(12);
        this.pasSimPast1stSingGrVerbTextfield.getDocument().putProperty("name", "pasSimPast1stSingGrVerb");
        this.pasSimPast1stSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03c4\u03b7\u03ba\u03b1");
        JLabel plabelp2s = new JLabel("Passive Simple Past 2nd Singular");
        this.pasSimPast2ndSingGrVerbTextfield = new JTextField(12);
        this.pasSimPast2ndSingGrVerbTextfield.getDocument().putProperty("name", "pasSimPast2ndSingGrVerb");
        this.pasSimPast2ndSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03c4\u03b7\u03ba\u03b5\u03c2");
        JLabel plabelp3s = new JLabel("Passive Simple Past 3rd Singular");
        this.pasSimPast3rdSingGrVerbTextfield = new JTextField(12);
        this.pasSimPast3rdSingGrVerbTextfield.getDocument().putProperty("name", "pasSimPast3rdSingGrVerb");
        this.pasSimPast3rdSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03c4\u03b7\u03ba\u03b5");
        JLabel plabelp1p = new JLabel("Passive Simple Past 1st Plural");
        this.pasSimPast1stPlurGrVerbTextfield = new JTextField(12);
        this.pasSimPast1stPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimPast1stPlurGrVerb");
        this.pasSimPast1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03ae\u03ba\u03b1\u03bc\u03b5");
        JLabel plabelp2p = new JLabel("Passive Simple Past 2nd Plural");
        this.pasSimPast2ndPlurGrVerbTextfield = new JTextField(12);
        this.pasSimPast2ndPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimPast2ndPlurGrVerb");
        this.pasSimPast2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03ae\u03ba\u03b1\u03c4\u03b5");
        JLabel plabelp3p = new JLabel("Passive Simple Past 3rd Plural");
        this.pasSimPast3rdPlurGrVerbTextfield = new JTextField(12);
        this.pasSimPast3rdPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimPast3rdPlurGrVerb");
        this.pasSimPast3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03c4\u03b7\u03ba\u03b1\u03bd");
        JLabel plabelpc1s = new JLabel("Passive Past Continuous 1st Singular");
        this.pasPastCont1stSingGrVerbTextfield = new JTextField(12);
        this.pasPastCont1stSingGrVerbTextfield.getDocument().putProperty("name", "pasPastCont1stSingGrVerb");
        this.pasPastCont1stSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03cc\u03bc\u03bf\u03c5\u03bd");
        JLabel plabelpc2s = new JLabel("Passive Past Continuous 2nd Singular");
        this.pasPastCont2ndSingGrVerbTextfield = new JTextField(12);
        this.pasPastCont2ndSingGrVerbTextfield.getDocument().putProperty("name", "pasPastCont2ndSingGrVerb");
        this.pasPastCont2ndSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03cc\u03c3\u03bf\u03c5\u03bd");
        JLabel plabelpc3s = new JLabel("Passive Past Continuous 3rd Singular");
        this.pasPastCont3rdSingGrVerbTextfield = new JTextField(12);
        this.pasPastCont3rdSingGrVerbTextfield.getDocument().putProperty("name", "pasPastCont3rdSingGrVerb");
        this.pasPastCont3rdSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03cc\u03c4\u03b1\u03bd");
        JLabel plabelpc1p = new JLabel("Passive Past Continuous 1st Plural");
        this.pasPastCont1stPlurGrVerbTextfield = new JTextField(12);
        this.pasPastCont1stPlurGrVerbTextfield.getDocument().putProperty("name", "pasPastCont1stPlurGrVerb");
        this.pasPastCont1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03cc\u03bc\u03b1\u03c3\u03c4\u03b1\u03bd");
        JLabel plabelpc2p = new JLabel("Passive Past Continuous 2nd Plural");
        this.pasPastCont2ndPlurGrVerbTextfield = new JTextField(12);
        this.pasPastCont2ndPlurGrVerbTextfield.getDocument().putProperty("name", "pasPastCont2ndPlurGrVerb");
        this.pasPastCont2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03cc\u03c3\u03b1\u03c3\u03c4\u03b1\u03bd");
        JLabel plabelpc3p = new JLabel("Passive Past Continuous 3rd Plural");
        this.pasPastCont3rdPlurGrVerbTextfield = new JTextField(12);
        this.pasPastCont3rdPlurGrVerbTextfield.getDocument().putProperty("name", "pasPastCont3rdPlurGrVerb");
        this.pasPastCont3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03ac\u03c6\u03bf\u03bd\u03c4\u03b1\u03bd");
        JLabel plabelf1s = new JLabel("Passive Simple Future 1st Singular");
        JLabel plabelf1sPlus = new JLabel("\u03b8\u03b1 ");
        this.pasSimpFut1stSingGrVerbTextfield = new JTextField(12);
        this.pasSimpFut1stSingGrVerbTextfield.getDocument().putProperty("name", "pasSimpFut1stSingGrVerb");
        this.pasSimpFut1stSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03ce");
        JLabel plabelf2s = new JLabel("Passive Simple Future 2nd Singular");
        JLabel plabelf2sPlus = new JLabel("\u03b8\u03b1 ");
        this.pasSimpFut2ndSingGrVerbTextfield = new JTextField(12);
        this.pasSimpFut2ndSingGrVerbTextfield.getDocument().putProperty("name", "pasSimpFut2ndSingGrVerb");
        this.pasSimpFut2ndSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03b5\u03af\u03c2");
        JLabel plabelf3s = new JLabel("Passive Simple Future 3rd Singular");
        JLabel plabelf3sPlus = new JLabel("\u03b8\u03b1 ");
        this.pasSimpFut3rdSingGrVerbTextfield = new JTextField(12);
        this.pasSimpFut3rdSingGrVerbTextfield.getDocument().putProperty("name", "pasSimpFut3rdSingGrVerb");
        this.pasSimpFut3rdSingGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03b5\u03af");
        JLabel plabelf1p = new JLabel("Passive Simple Future 1st Plural");
        JLabel plabelf1pPlus = new JLabel("\u03b8\u03b1 ");
        this.pasSimpFut1stPlurGrVerbTextfield = new JTextField(12);
        this.pasSimpFut1stPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimpFut1stPlurGrVerb");
        this.pasSimpFut1stPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03bf\u03cd\u03bc\u03b5");
        JLabel plabelf2p = new JLabel("Passive Simple Future 2nd Plural");
        JLabel plabelf2pPlus = new JLabel("\u03b8\u03b1 ");
        this.pasSimpFut2ndPlurGrVerbTextfield = new JTextField(12);
        this.pasSimpFut2ndPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimpFut2ndPlurGrVerb");
        this.pasSimpFut2ndPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03b5\u03af\u03c4\u03b5");
        JLabel plabelf3p = new JLabel("Passive Simple Future 3rd Plural");
        JLabel plabelf3pPlus = new JLabel("\u03b8\u03b1 ");
        this.pasSimpFut3rdPlurGrVerbTextfield = new JTextField(12);
        this.pasSimpFut3rdPlurGrVerbTextfield.getDocument().putProperty("name", "pasSimpFut3rdPlurGrVerb");
        this.pasSimpFut3rdPlurGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03bf\u03cd\u03bd");
        JLabel plabelai = new JLabel("Passive Infinitive");
        this.pasInfGrVerbTextfield = new JTextField(12);
        this.pasInfGrVerbTextfield.getDocument().putProperty("name", "pasInfGrVerb");
        this.pasInfGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03c6\u03c4\u03b5\u03af");
        JLabel plabelap = new JLabel("Passive Participle");
        this.pasPartGrVerbTextfield = new JTextField(12);
        this.pasPartGrVerbTextfield.getDocument().putProperty("name", "pasPartGrVerb");
        this.pasPartGrVerbTextfield.setToolTipText("ex.: \u03b2\u03b1\u03bc\u03bc\u03ad\u03bd\u03bf\u03c2");
        d = plabelpr1s.getPreferredSize();
        plabelpr1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpr2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpr3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpr1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpr2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpr3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelp1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelp2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelp3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelp1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelp2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelp3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpc1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpc2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpc3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpc1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpc2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelpc3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelf1s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelf2s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelf3s.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelf1p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelf2p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelf3p.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelai.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        plabelap.setPreferredSize(new Dimension(tenseLabelWidth, d.height));
        pspr1.add(plabelpr1s);
        pspr1.add(this.pasSimPres1stSingGrVerbTextfield);
        pspr2.add(plabelpr2s);
        pspr2.add(this.pasSimPres2ndSingGrVerbTextfield);
        pspr3.add(plabelpr3s);
        pspr3.add(this.pasSimPres3rdSingGrVerbTextfield);
        pspr4.add(plabelpr1p);
        pspr4.add(this.pasSimPres1stPlurGrVerbTextfield);
        pspr5.add(plabelpr2p);
        pspr5.add(this.pasSimPres2ndPlurGrVerbTextfield);
        pspr6.add(plabelpr3p);
        pspr6.add(this.pasSimPres3rdPlurGrVerbTextfield);
        pspr.add(pspr1);
        pspr.add(pspr2);
        pspr.add(pspr3);
        pspr.add(pspr4);
        pspr.add(pspr5);
        pspr.add(pspr6);
        psp1.add(plabelp1s);
        psp1.add(this.pasSimPast1stSingGrVerbTextfield);
        psp2.add(plabelp2s);
        psp2.add(this.pasSimPast2ndSingGrVerbTextfield);
        psp3.add(plabelp3s);
        psp3.add(this.pasSimPast3rdSingGrVerbTextfield);
        psp4.add(plabelp1p);
        psp4.add(this.pasSimPast1stPlurGrVerbTextfield);
        psp5.add(plabelp2p);
        psp5.add(this.pasSimPast2ndPlurGrVerbTextfield);
        psp6.add(plabelp3p);
        psp6.add(this.pasSimPast3rdPlurGrVerbTextfield);
        psp.add(psp1);
        psp.add(psp2);
        psp.add(psp3);
        psp.add(psp4);
        psp.add(psp5);
        psp.add(psp6);
        ppc1.add(plabelpc1s);
        ppc1.add(this.pasPastCont1stSingGrVerbTextfield);
        ppc2.add(plabelpc2s);
        ppc2.add(this.pasPastCont2ndSingGrVerbTextfield);
        ppc3.add(plabelpc3s);
        ppc3.add(this.pasPastCont3rdSingGrVerbTextfield);
        ppc4.add(plabelpc1p);
        ppc4.add(this.pasPastCont1stPlurGrVerbTextfield);
        ppc5.add(plabelpc2p);
        ppc5.add(this.pasPastCont2ndPlurGrVerbTextfield);
        ppc6.add(plabelpc3p);
        ppc6.add(this.pasPastCont3rdPlurGrVerbTextfield);
        ppc.add(ppc1);
        ppc.add(ppc2);
        ppc.add(ppc3);
        ppc.add(ppc4);
        ppc.add(ppc5);
        ppc.add(ppc6);
        psf1.add(plabelf1s);
        psf1.add(plabelf1sPlus);
        psf1.add(this.pasSimpFut1stSingGrVerbTextfield);
        psf2.add(plabelf2s);
        psf2.add(plabelf2sPlus);
        psf2.add(this.pasSimpFut2ndSingGrVerbTextfield);
        psf3.add(plabelf3s);
        psf3.add(plabelf3sPlus);
        psf3.add(this.pasSimpFut3rdSingGrVerbTextfield);
        psf4.add(plabelf1p);
        psf4.add(plabelf1pPlus);
        psf4.add(this.pasSimpFut1stPlurGrVerbTextfield);
        psf5.add(plabelf2p);
        psf5.add(plabelf2pPlus);
        psf5.add(this.pasSimpFut2ndPlurGrVerbTextfield);
        psf6.add(plabelf3p);
        psf6.add(plabelf3pPlus);
        psf6.add(this.pasSimpFut3rdPlurGrVerbTextfield);
        psf.add(psf1);
        psf.add(psf2);
        psf.add(psf3);
        psf.add(psf4);
        psf.add(psf5);
        psf.add(psf6);
        pi1.add(plabelai);
        pi1.add(this.pasInfGrVerbTextfield);
        pi.add(pi1);
        pp1.add(plabelap);
        pp1.add(this.pasPartGrVerbTextfield);
        pp.add(pp1);
        this.panelVerbPassiveTenseCard.add((Component)pspr, "Simple Present");
        this.panelVerbPassiveTenseCard.add((Component)psp, "Simple Past");
        this.panelVerbPassiveTenseCard.add((Component)ppc, "Past Continuous");
        this.panelVerbPassiveTenseCard.add((Component)psf, "Simple Future");
        this.panelVerbPassiveTenseCard.add((Component)pi, "Infinitive");
        this.panelVerbPassiveTenseCard.add((Component)pp, "Participle");
        panelPassive.add((Component)this.panelVerbPassiveTenseCard, "Center");
        this.pasSimPres1stSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple present", "1st", "singular"));
        this.pasSimPres2ndSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple present", "2nd", "singular"));
        this.pasSimPres3rdSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple present", "3rd", "singular"));
        this.pasSimPres1stPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple present", "1st", "plural"));
        this.pasSimPres2ndPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple present", "2nd", "plural"));
        this.pasSimPres3rdPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple present", "3rd", "plural"));
        this.pasSimPast1stSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple past", "1st", "singular"));
        this.pasSimPast2ndSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple past", "2nd", "singular"));
        this.pasSimPast3rdSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple past", "3rd", "singular"));
        this.pasSimPast1stPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple past", "1st", "plural"));
        this.pasSimPast2ndPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple past", "2nd", "plural"));
        this.pasSimPast3rdPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple past", "3rd", "plural"));
        this.pasPastCont1stSingGrVerbTextfield.setText(this.verbGR.get("passive", "past continuous", "1st", "singular"));
        this.pasPastCont2ndSingGrVerbTextfield.setText(this.verbGR.get("passive", "past continuous", "2nd", "singular"));
        this.pasPastCont3rdSingGrVerbTextfield.setText(this.verbGR.get("passive", "past continuous", "3rd", "singular"));
        this.pasPastCont1stPlurGrVerbTextfield.setText(this.verbGR.get("passive", "past continuous", "1st", "plural"));
        this.pasPastCont2ndPlurGrVerbTextfield.setText(this.verbGR.get("passive", "past continuous", "2nd", "plural"));
        this.pasPastCont3rdPlurGrVerbTextfield.setText(this.verbGR.get("passive", "past continuous", "3rd", "plural"));
        this.pasSimpFut1stSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple future", "1st", "singular"));
        this.pasSimpFut2ndSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple future", "2nd", "singular"));
        this.pasSimpFut3rdSingGrVerbTextfield.setText(this.verbGR.get("passive", "simple future", "3rd", "singular"));
        this.pasSimpFut1stPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple future", "1st", "plural"));
        this.pasSimpFut2ndPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple future", "2nd", "plural"));
        this.pasSimpFut3rdPlurGrVerbTextfield.setText(this.verbGR.get("passive", "simple future", "3rd", "plural"));
        this.pasInfGrVerbTextfield.setText(this.verbGR.get("passive", "infinitive", "", ""));
        this.pasPartGrVerbTextfield.setText(this.verbGR.get("passive", "participle", "", ""));
        this.panelVerbVoiceCard.add((Component)panelActive, "Active");
        this.panelVerbVoiceCard.add((Component)panelPassive, "Passive");
        CardLayout cl = (CardLayout)this.panelVerbActiveTenseCard.getLayout();
        cl.show(this.panelVerbActiveTenseCard, this.selectedActiveTense);
        this.panelVerbActiveTenseCard.validate();
        cl = (CardLayout)this.panelVerbPassiveTenseCard.getLayout();
        cl.show(this.panelVerbPassiveTenseCard, this.selectedPassiveTense);
        this.panelVerbPassiveTenseCard.validate();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.singEnNounBut) {
            this.nounCardEnA.setVisible(true);
            this.nounCardEnB.setVisible(false);
            this.nounEN.setNumber("singular");
            this.dirtenOntologies();
        } else if (source == this.singGrNounBut) {
            this.nounCardGrA.setVisible(true);
            this.nounCardGrB.setVisible(false);
            this.nounGR.setNumber("singular");
            this.dirtenOntologies();
        } else if (source == this.plEnNounBut) {
            this.nounCardEnA.setVisible(false);
            this.nounCardEnB.setVisible(true);
            this.nounEN.setNumber("plural");
            this.dirtenOntologies();
        } else if (source == this.plGrNounBut) {
            this.nounCardGrA.setVisible(false);
            this.nounCardGrB.setVisible(true);
            this.nounGR.setNumber("plural");
            this.dirtenOntologies();
        } else if (source == this.bothEnNounBut) {
            this.nounCardEnA.setVisible(true);
            this.nounCardEnB.setVisible(true);
            this.nounEN.setNumber("both");
            this.dirtenOntologies();
        } else if (source == this.bothGrNounBut) {
            this.nounCardGrA.setVisible(true);
            this.nounCardGrB.setVisible(true);
            this.nounGR.setNumber("both");
            this.dirtenOntologies();
        } else if (source == this.mascEnNounBut) {
            this.nounEN.setGender("masculine");
            this.dirtenOntologies();
        } else if (source == this.mascGrNounBut) {
            this.nounGR.setGender("masculine");
            this.dirtenOntologies();
        } else if (source == this.femEnNounBut) {
            this.nounEN.setGender("feminine");
            this.dirtenOntologies();
        } else if (source == this.femGrNounBut) {
            this.nounGR.setGender("feminine");
            this.dirtenOntologies();
        } else if (source == this.mascFemEnNounBut) {
            this.nounEN.setGender("masculineOrFeminine");
            this.dirtenOntologies();
        } else if (source == this.mascFemGrNounBut) {
            this.nounGR.setGender("masculineOrFeminine");
            this.dirtenOntologies();
        } else if (source == this.neutEnNounBut) {
            this.nounEN.setGender("neuter");
            this.dirtenOntologies();
        } else if (source == this.neutGrNounBut) {
            this.nounGR.setGender("neuter");
            this.dirtenOntologies();
        }
        this.repaint();
    }

    @Override
    public void insertUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void removeUpdate(DocumentEvent event) {
        this.updateEntry(event);
    }

    @Override
    public void changedUpdate(DocumentEvent event) {
    }

    public void updateEntry(DocumentEvent event) {
        String name = (String)event.getDocument().getProperty("name");
        if (name.equals("singEnNoun")) {
            this.nounEN.setSingular(this.singEnNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurEnNoun")) {
            this.nounEN.setPlural(this.plurEnNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singNomGr")) {
            this.nounGR.setSingularNominative(this.singNomGrNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singGenGr")) {
            this.nounGR.setSingularGenitive(this.singGenGrNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singAccGr")) {
            this.nounGR.setSingularAccusative(this.singAccGrNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurNomGr")) {
            this.nounGR.setPluralNominative(this.plurNomGrNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurGenGr")) {
            this.nounGR.setPluralGenitive(this.plurGenGrNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurAccGr")) {
            this.nounGR.setPluralAccusative(this.plurAccGrNounTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("adjEn")) {
            this.adjectiveEN.set_form(this.adjEnTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singMascNomAdjGr")) {
            this.adjectiveGR.setSingularNominativeMasculine(this.singMascNomAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singMascGenAdjGr")) {
            this.adjectiveGR.setSingularGenitiveMasculine(this.singMascGenAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singMascAccAdjGr")) {
            this.adjectiveGR.setSingularAccusativeMasculine(this.singMascAccAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurMascNomAdjGr")) {
            this.adjectiveGR.setPluralNominativeMasculine(this.plurMascNomAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurMascGenAdjGr")) {
            this.adjectiveGR.setPluralGenitiveMasculine(this.plurMascGenAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurMascAccAdjGr")) {
            this.adjectiveGR.setPluralAccusativeMasculine(this.plurMascAccAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singFemNomAdjGr")) {
            this.adjectiveGR.setSingularNominativeFeminine(this.singFemNomAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singFemGenAdjGr")) {
            this.adjectiveGR.setSingularGenitiveFeminine(this.singFemGenAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singFemAccAdjGr")) {
            this.adjectiveGR.setSingularAccusativeFeminine(this.singFemAccAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurFemNomAdjGr")) {
            this.adjectiveGR.setPluralNominativeFeminine(this.plurFemNomAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurFemGenAdjGr")) {
            this.adjectiveGR.setPluralGenitiveFeminine(this.plurFemGenAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurFemAccAdjGr")) {
            this.adjectiveGR.setPluralAccusativeFeminine(this.plurFemAccAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singNeutNomAdjGr")) {
            this.adjectiveGR.setSingularNominativeNeuter(this.singNeutNomAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singNeutGenAdjGr")) {
            this.adjectiveGR.setSingularGenitiveNeuter(this.singNeutGenAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("singNeutAccAdjGr")) {
            this.adjectiveGR.setSingularAccusativeNeuter(this.singNeutAccAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurNeutNomAdjGr")) {
            this.adjectiveGR.setPluralNominativeNeuter(this.plurNeutNomAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurNeutGenAdjGr")) {
            this.adjectiveGR.setPluralGenitiveNeuter(this.plurNeutGenAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("plurNeutAccAdjGr")) {
            this.adjectiveGR.setPluralAccusativeNeuter(this.plurNeutAccAdjGrTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("baseFormEnVerb")) {
            this.verbEN.setBaseForm(this.baseFormEnVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("simPres3rdSingEnVerb")) {
            this.verbEN.setSimplePresent3rdSingular(this.simPres3rdSingEnVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("presPartEnVerb")) {
            this.verbEN.setPresentParticiple(this.presPartEnVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("simPastEnVerb")) {
            this.verbEN.setSimplePast(this.simPastEnVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pastPartEnVerb")) {
            this.verbEN.setPastParticiple(this.pastPartEnVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPres1stSingGrVerb")) {
            this.verbGR.set("active", "simple present", "1st", "singular", this.actSimPres1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPres2ndSingGrVerb")) {
            this.verbGR.set("active", "simple present", "2nd", "singular", this.actSimPres2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPres3rdSingGrVerb")) {
            this.verbGR.set("active", "simple present", "3rd", "singular", this.actSimPres3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPres1stPlurGrVerb")) {
            this.verbGR.set("active", "simple present", "1st", "plural", this.actSimPres1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPres2ndPlurGrVerb")) {
            this.verbGR.set("active", "simple present", "2nd", "plural", this.actSimPres2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPres3rdPlurGrVerb")) {
            this.verbGR.set("active", "simple present", "3rd", "plural", this.actSimPres3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPast1stSingGrVerb")) {
            this.verbGR.set("active", "simple past", "1st", "singular", this.actSimPast1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPast2ndSingGrVerb")) {
            this.verbGR.set("active", "simple past", "2nd", "singular", this.actSimPast2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPast3rdSingGrVerb")) {
            this.verbGR.set("active", "simple past", "3rd", "singular", this.actSimPast3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPast1stPlurGrVerb")) {
            this.verbGR.set("active", "simple past", "1st", "plural", this.actSimPast1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPast2ndPlurGrVerb")) {
            this.verbGR.set("active", "simple past", "2nd", "plural", this.actSimPast2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimPast3rdPlurGrVerb")) {
            this.verbGR.set("active", "simple past", "3rd", "plural", this.actSimPast3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPastCont1stSingGrVerb")) {
            this.verbGR.set("active", "past continuous", "1st", "singular", this.actPastCont1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPastCont2ndSingGrVerb")) {
            this.verbGR.set("active", "past continuous", "2nd", "singular", this.actPastCont2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPastCont3rdSingGrVerb")) {
            this.verbGR.set("active", "past continuous", "3rd", "singular", this.actPastCont3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPastCont1stPlurGrVerb")) {
            this.verbGR.set("active", "past continuous", "1st", "plural", this.actPastCont1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPastCont2ndPlurGrVerb")) {
            this.verbGR.set("active", "past continuous", "2nd", "plural", this.actPastCont2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPastCont3rdPlurGrVerb")) {
            this.verbGR.set("active", "past continuous", "3rd", "plural", this.actPastCont3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimpFut1stSingGrVerb")) {
            this.verbGR.set("active", "simple future", "1st", "singular", this.actSimpFut1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimpFut2ndSingGrVerb")) {
            this.verbGR.set("active", "simple future", "2nd", "singular", this.actSimpFut2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimpFut3rdSingGrVerb")) {
            this.verbGR.set("active", "simple future", "3rd", "singular", this.actSimpFut3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimpFut1stPlurGrVerb")) {
            this.verbGR.set("active", "simple future", "1st", "plural", this.actSimpFut1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimpFut2ndPlurGrVerb")) {
            this.verbGR.set("active", "simple future", "2nd", "plural", this.actSimpFut2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actSimpFut3rdPlurGrVerb")) {
            this.verbGR.set("active", "simple future", "3rd", "plural", this.actSimpFut3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actInfGrVerb")) {
            this.verbGR.setActiveInfinitive(this.actInfGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("actPartGrVerb")) {
            this.verbGR.setActiveParticiple(this.actPartGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPres1stSingGrVerb")) {
            this.verbGR.set("passive", "simple present", "1st", "singular", this.pasSimPres1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPres2ndSingGrVerb")) {
            this.verbGR.set("passive", "simple present", "2nd", "singular", this.pasSimPres2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPres3rdSingGrVerb")) {
            this.verbGR.set("passive", "simple present", "3rd", "singular", this.pasSimPres3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPres1stPlurGrVerb")) {
            this.verbGR.set("passive", "simple present", "1st", "plural", this.pasSimPres1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPres2ndPlurGrVerb")) {
            this.verbGR.set("passive", "simple present", "2nd", "plural", this.pasSimPres2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPres3rdPlurGrVerb")) {
            this.verbGR.set("passive", "simple present", "3rd", "plural", this.pasSimPres3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPast1stSingGrVerb")) {
            this.verbGR.set("passive", "simple past", "1st", "singular", this.pasSimPast1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPast2ndSingGrVerb")) {
            this.verbGR.set("passive", "simple past", "2nd", "singular", this.pasSimPast2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPast3rdSingGrVerb")) {
            this.verbGR.set("passive", "simple past", "3rd", "singular", this.pasSimPast3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPast1stPlurGrVerb")) {
            this.verbGR.set("passive", "simple past", "1st", "plural", this.pasSimPast1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPast2ndPlurGrVerb")) {
            this.verbGR.set("passive", "simple past", "2nd", "plural", this.pasSimPast2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimPast3rdPlurGrVerb")) {
            this.verbGR.set("passive", "simple past", "3rd", "plural", this.pasSimPast3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPastCont1stSingGrVerb")) {
            this.verbGR.set("passive", "past continuous", "1st", "singular", this.pasPastCont1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPastCont2ndSingGrVerb")) {
            this.verbGR.set("passive", "past continuous", "2nd", "singular", this.pasPastCont2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPastCont3rdSingGrVerb")) {
            this.verbGR.set("passive", "past continuous", "3rd", "singular", this.pasPastCont3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPastCont1stPlurGrVerb")) {
            this.verbGR.set("passive", "past continuous", "1st", "plural", this.pasPastCont1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPastCont2ndPlurGrVerb")) {
            this.verbGR.set("passive", "past continuous", "2nd", "plural", this.pasPastCont2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPastCont3rdPlurGrVerb")) {
            this.verbGR.set("passive", "past continuous", "3rd", "plural", this.pasPastCont3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimpFut1stSingGrVerb")) {
            this.verbGR.set("passive", "simple future", "1st", "singular", this.pasSimpFut1stSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimpFut2ndSingGrVerb")) {
            this.verbGR.set("passive", "simple future", "2nd", "singular", this.pasSimpFut2ndSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimpFut3rdSingGrVerb")) {
            this.verbGR.set("passive", "simple future", "3rd", "singular", this.pasSimpFut3rdSingGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimpFut1stPlurGrVerb")) {
            this.verbGR.set("passive", "simple future", "1st", "plural", this.pasSimpFut1stPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimpFut2ndPlurGrVerb")) {
            this.verbGR.set("passive", "simple future", "2nd", "plural", this.pasSimpFut2ndPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasSimpFut3rdPlurGrVerb")) {
            this.verbGR.set("passive", "simple future", "3rd", "plural", this.pasSimpFut3rdPlurGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasInfGrVerb")) {
            this.verbGR.setPassiveInfinitive(this.pasInfGrVerbTextfield.getText());
            this.dirtenOntologies();
        } else if (name.equals("pasPartGrVerb")) {
            this.verbGR.setPassiveParticiple(this.pasPartGrVerbTextfield.getText());
            this.dirtenOntologies();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            CardLayout cl;
            if (this.nounLanguage != null && e.getSource().hashCode() == this.nounLanguage.hashCode()) {
                this.selectedLanguage = (String)e.getItem();
                cl = (CardLayout)this.panelNounCard.getLayout();
                cl.show(this.panelNounCard, this.selectedLanguage);
                this.panelNounCard.validate();
            }
            if (this.adjectiveLanguage != null && e.getSource().hashCode() == this.adjectiveLanguage.hashCode()) {
                this.selectedLanguage = (String)e.getItem();
                cl = (CardLayout)this.panelAdjectiveCard.getLayout();
                cl.show(this.panelAdjectiveCard, this.selectedLanguage);
                this.panelAdjectiveCard.validate();
            }
            if (this.adjectiveGender != null && e.getSource().hashCode() == this.adjectiveGender.hashCode()) {
                this.selectedGender = (String)e.getItem();
                cl = (CardLayout)this.panelAdjectiveGenderCard.getLayout();
                cl.show(this.panelAdjectiveGenderCard, this.selectedGender);
                this.panelAdjectiveGenderCard.validate();
            }
            if (this.verbLanguage != null && e.getSource().hashCode() == this.verbLanguage.hashCode()) {
                this.selectedLanguage = (String)e.getItem();
                cl = (CardLayout)this.panelVerbCard.getLayout();
                cl.show(this.panelVerbCard, this.selectedLanguage);
                this.panelVerbCard.validate();
            }
            if (this.voice != null && e.getSource().hashCode() == this.voice.hashCode()) {
                this.selectedVoice = (String)e.getItem();
                cl = (CardLayout)this.panelVerbVoiceCard.getLayout();
                cl.show(this.panelVerbVoiceCard, this.selectedVoice);
                this.panelVerbVoiceCard.validate();
            }
            if (this.activeTense != null && e.getSource().hashCode() == this.activeTense.hashCode()) {
                this.selectedActiveTense = (String)e.getItem();
                cl = (CardLayout)this.panelVerbActiveTenseCard.getLayout();
                cl.show(this.panelVerbActiveTenseCard, this.selectedActiveTense);
                this.panelVerbActiveTenseCard.validate();
            }
            if (this.passiveTense != null && e.getSource().hashCode() == this.passiveTense.hashCode()) {
                this.selectedPassiveTense = (String)e.getItem();
                cl = (CardLayout)this.panelVerbPassiveTenseCard.getLayout();
                cl.show(this.panelVerbPassiveTenseCard, this.selectedPassiveTense);
                this.panelVerbPassiveTenseCard.validate();
            }
            if (e.getSource().equals(this.type)) {
                this.viewMainSubpanel(this.type.getSelectedItem().toString());
            }
        }
    }

    private void showLexiconEntry(EntryList entry) {
        if (entry instanceof NounEntryList) {
            this.adjectiveEN = null;
            this.adjectiveGR = null;
            this.verbEN = null;
            this.verbGR = null;
            this.nounEN = (LexEntryNounEN)((NounEntryList)entry).getEntry("en");
            this.nounGR = (LexEntryNounGR)((NounEntryList)entry).getEntry("el");
            this.panelMain.removeAll();
            this.showNounPanel();
            this.repaint();
            this.removeListeners();
            this.singEnNounTextfield.getDocument().addDocumentListener(this);
            this.plurEnNounTextfield.getDocument().addDocumentListener(this);
            this.singNomGrNounTextfield.getDocument().addDocumentListener(this);
            this.singGenGrNounTextfield.getDocument().addDocumentListener(this);
            this.singAccGrNounTextfield.getDocument().addDocumentListener(this);
            this.plurNomGrNounTextfield.getDocument().addDocumentListener(this);
            this.plurGenGrNounTextfield.getDocument().addDocumentListener(this);
            this.plurAccGrNounTextfield.getDocument().addDocumentListener(this);
        } else if (entry instanceof AdjectiveEntryList) {
            this.nounEN = null;
            this.nounGR = null;
            this.verbEN = null;
            this.verbGR = null;
            this.adjectiveEN = (LexEntryAdjectiveEN)((AdjectiveEntryList)entry).getEntry("en");
            this.adjectiveGR = (LexEntryAdjectiveGR)((AdjectiveEntryList)entry).getEntry("el");
            this.panelMain.removeAll();
            this.showAdjectivePanel();
            this.repaint();
            this.removeListeners();
            this.adjEnTextfield.getDocument().addDocumentListener(this);
            this.singMascNomAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singMascGenAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singMascAccAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurMascNomAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurMascGenAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurMascAccAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singFemNomAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singFemGenAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singFemAccAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurFemNomAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurFemGenAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurFemAccAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singNeutNomAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singNeutGenAdjGrTextfield.getDocument().addDocumentListener(this);
            this.singNeutAccAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurNeutNomAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurNeutGenAdjGrTextfield.getDocument().addDocumentListener(this);
            this.plurNeutAccAdjGrTextfield.getDocument().addDocumentListener(this);
        } else if (entry instanceof VerbEntryList) {
            this.nounEN = null;
            this.nounGR = null;
            this.adjectiveEN = null;
            this.adjectiveGR = null;
            this.verbEN = (LexEntryVerbEN)((VerbEntryList)entry).getEntry("en");
            this.verbGR = (LexEntryVerbGR)((VerbEntryList)entry).getEntry("el");
            this.panelMain.removeAll();
            this.showVerbPanel();
            this.repaint();
            this.removeListeners();
            this.baseFormEnVerbTextfield.getDocument().addDocumentListener(this);
            this.simPres3rdSingEnVerbTextfield.getDocument().addDocumentListener(this);
            this.presPartEnVerbTextfield.getDocument().addDocumentListener(this);
            this.simPastEnVerbTextfield.getDocument().addDocumentListener(this);
            this.pastPartEnVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPres1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPres2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPres3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPres1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPres2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPres3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPast1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPast2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPast3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPast1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPast2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimPast3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPastCont1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPastCont2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPastCont3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPastCont1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPastCont2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPastCont3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimpFut1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimpFut2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimpFut3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimpFut1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimpFut2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actSimpFut3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actInfGrVerbTextfield.getDocument().addDocumentListener(this);
            this.actPartGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPres1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPres2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPres3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPres1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPres2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPres3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPast1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPast2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPast3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPast1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPast2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimPast3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPastCont1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPastCont2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPastCont3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPastCont1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPastCont2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPastCont3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimpFut1stSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimpFut2ndSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimpFut3rdSingGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimpFut1stPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimpFut2ndPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasSimpFut3rdPlurGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasInfGrVerbTextfield.getDocument().addDocumentListener(this);
            this.pasPartGrVerbTextfield.getDocument().addDocumentListener(this);
        }
    }

    private void removeListeners() {
        if (this.singEnNounTextfield != null) {
            this.singEnNounTextfield.getDocument().removeDocumentListener(this);
            this.plurEnNounTextfield.getDocument().removeDocumentListener(this);
            this.singNomGrNounTextfield.getDocument().removeDocumentListener(this);
            this.singGenGrNounTextfield.getDocument().removeDocumentListener(this);
            this.singAccGrNounTextfield.getDocument().removeDocumentListener(this);
            this.plurNomGrNounTextfield.getDocument().removeDocumentListener(this);
            this.plurGenGrNounTextfield.getDocument().removeDocumentListener(this);
            this.plurAccGrNounTextfield.getDocument().removeDocumentListener(this);
        }
        if (this.adjEnTextfield != null) {
            this.adjEnTextfield.getDocument().removeDocumentListener(this);
            this.singMascNomAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singMascGenAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singMascAccAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurMascNomAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurMascGenAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurMascAccAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singFemNomAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singFemGenAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singFemAccAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurFemNomAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurFemGenAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurFemAccAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singNeutNomAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singNeutGenAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.singNeutAccAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurNeutNomAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurNeutGenAdjGrTextfield.getDocument().removeDocumentListener(this);
            this.plurNeutAccAdjGrTextfield.getDocument().removeDocumentListener(this);
        }
        if (this.baseFormEnVerbTextfield != null) {
            this.baseFormEnVerbTextfield.getDocument().removeDocumentListener(this);
            this.simPres3rdSingEnVerbTextfield.getDocument().removeDocumentListener(this);
            this.presPartEnVerbTextfield.getDocument().removeDocumentListener(this);
            this.simPastEnVerbTextfield.getDocument().removeDocumentListener(this);
            this.pastPartEnVerbTextfield.getDocument().removeDocumentListener(this);
        }
        if (this.actSimPres1stSingGrVerbTextfield != null) {
            this.actSimPres1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPres2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPres3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPres1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPres2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPres3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPast1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPast2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPast3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPast1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPast2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimPast3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPastCont1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPastCont2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPastCont3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPastCont1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPastCont2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPastCont3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimpFut1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimpFut2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimpFut3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimpFut1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimpFut2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actSimpFut3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actInfGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.actPartGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPres1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPres2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPres3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPres1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPres2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPres3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPast1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPast2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPast3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPast1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPast2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimPast3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPastCont1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPastCont2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPastCont3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPastCont1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPastCont2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPastCont3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimpFut1stSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimpFut2ndSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimpFut3rdSingGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimpFut1stPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimpFut2ndPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasSimpFut3rdPlurGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasInfGrVerbTextfield.getDocument().removeDocumentListener(this);
            this.pasPartGrVerbTextfield.getDocument().removeDocumentListener(this);
        }
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.removeListeners();
        this.getOWLModelManager().removeListener(this.modelListener);
    }
}

