/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLOwlPlugin.GenerationTrees;
import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeRenderer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;

public class IndividualsTreeComponent
extends TreeComponent {
    private DefaultMutableTreeNode parent;
    private IRI classIRI = null;

    public IndividualsTreeComponent(NaturalOWLTab fatherTab) {
        super(fatherTab);
    }

    @Override
    public void createTree() {
        if (this.classIRI != null) {
            this.parent = new DefaultMutableTreeNode(new ListIRI(this.classIRI), true);
            HashSet<ListIRI> individualsToAdd = new HashSet<ListIRI>();
            for (OWLObject indiv : this.father.getOWLModelManager().getOWLHierarchyManager().getOWLIndividualsByTypeHierarchyProvider().getChildren((OWLObject)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(this.classIRI))) {
                if (!((OWLIndividual)indiv).isNamed()) continue;
                individualsToAdd.add(new ListIRI(((OWLIndividual)indiv).asOWLNamedIndividual().getIRI()));
            }
            ArrayList individualsToAddSorted = new ArrayList(individualsToAdd);
            Collections.sort(individualsToAddSorted);
            for (ListIRI add : individualsToAddSorted) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(add, true);
                this.parent.add(node);
            }
            this.tree = new JTree(this.parent);
        } else {
            this.tree = new JTree();
        }
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
    }

    @Override
    public JPanel TP() {
        JPanel treepanel = new JPanel();
        this.createTree();
        treepanel.setBackground(new Color(255, 255, 255));
        treepanel.setLayout(new FlowLayout(0));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.addTreeSelectionListener(this);
        ClassLoader loader = LexiconTreeComponent.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/individual.png");
        ImageIcon icon = new ImageIcon(imageURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(icon);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(icon);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(icon);
        if (this.classIRI == null) {
            treepanel.remove(this.tree);
        } else {
            treepanel.add(this.tree);
        }
        return treepanel;
    }

    public IRI getClassIRI() {
        return this.classIRI;
    }

    public void setClassIRI(IRI classIRI) {
        this.classIRI = classIRI;
    }

    public void clearSelection() {
        this.tree.clearSelection();
        if (this.father instanceof GenerationTrees) {
            NaturalOWLTab.generationIndivSelectionModel.clearLastSelectedEntity(NaturalOWLTab.generationIndivSelectionModel.getSelectedEntity());
            NaturalOWLTab.generationIndivSelectionModel.setSelectedEntity(null);
        } else {
            NaturalOWLTab.userModelTableIndivSelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTableIndivSelectionModel.getSelectedEntity());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            if (this.father instanceof GenerationTrees) {
                NaturalOWLTab.generationIndivSelectionModel.clearLastSelectedEntity(NaturalOWLTab.generationIndivSelectionModel.getSelectedEntity());
                NaturalOWLTab.generationIndivSelectionModel.setSelectedEntity(null);
            } else {
                NaturalOWLTab.userModelTableIndivSelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTableIndivSelectionModel.getSelectedEntity());
            }
            return;
        }
        IRI selectedIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
        for (OWLOntology model : this.father.getOWLModelManager().getOntologies()) {
            if (!model.containsIndividualInSignature(selectedIRI)) continue;
            if (this.father instanceof GenerationTrees) {
                NaturalOWLTab.generationIndivSelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(selectedIRI));
            } else {
                NaturalOWLTab.userModelTableIndivSelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLNamedIndividual(selectedIRI));
            }
            return;
        }
    }
}

