/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLOwlPlugin.ClassesTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.IndividualsTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTab;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;

public class GenerationTrees
extends NaturalOWLTab {
    private static final long serialVersionUID = 4013375086058766803L;
    protected static final String DefaultMutableTreeNode = null;
    Logger log = Logger.getLogger(LexiconTab.class);
    private OWLModelManagerListener modelListener;
    JPanel classesPanel;
    JPanel individualsPanel;
    JPanel panelMain;
    JPanel classesTreePanel;
    JPanel individualsTreePanel;
    JButton classClearButton;
    JButton individualClearButton;
    JButton classRefreshButton;
    JButton individualRefreshButton;
    JScrollPane scrollClasses;
    JScrollPane scrollIndividuals;
    ClassesTreeComponent classesTree;
    IndividualsTreeComponent individualsTree;

    protected void initialiseOWLView() throws Exception {
        this.initialiseNaturalOWL();
        generationClassSelectionModel.addListener(this.getOWLClassSelectionModelListener());
        this.setLayout(new BorderLayout(10, 10));
        this.panelMain = new JPanel();
        this.classesPanel = new JPanel();
        this.individualsPanel = new JPanel();
        this.panelMain.setLayout(new GridBagLayout());
        this.classesPanel.setLayout(new BorderLayout());
        this.individualsPanel.setLayout(new BorderLayout());
        this.classClearButton = new JButton("Clear class selection");
        this.individualClearButton = new JButton("Clear individual selection");
        this.classClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GenerationTrees.this.classesTree.clearSelection();
                GenerationTrees.this.individualsTree.clearSelection();
                GenerationTrees.this.individualsTree.setClassIRI(null);
                GenerationTrees.this.individualsTreePanel = GenerationTrees.this.individualsTree.TP();
                GenerationTrees.this.scrollIndividuals.setViewportView(GenerationTrees.this.individualsTreePanel);
            }
        });
        this.individualClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                GenerationTrees.this.individualsTree.clearSelection();
            }
        });
        this.classRefreshButton = new JButton("Refresh");
        this.individualRefreshButton = new JButton("Refresh");
        this.classRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ListIRI selectedClassIRI = null;
                ListIRI selectedIndividualIRI = null;
                if (GenerationTrees.this.classesTree.tree.getLastSelectedPathComponent() != null) {
                    selectedClassIRI = (ListIRI)((DefaultMutableTreeNode)GenerationTrees.this.classesTree.tree.getLastSelectedPathComponent()).getUserObject();
                }
                if (GenerationTrees.this.individualsTree.tree.getLastSelectedPathComponent() != null) {
                    selectedIndividualIRI = (ListIRI)((DefaultMutableTreeNode)GenerationTrees.this.individualsTree.tree.getLastSelectedPathComponent()).getUserObject();
                }
                GenerationTrees.this.classesTreePanel = GenerationTrees.this.classesTree.TP();
                GenerationTrees.this.scrollClasses.setViewportView(GenerationTrees.this.classesTreePanel);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)GenerationTrees.this.classesTree.tree.getModel().getRoot();
                DefaultMutableTreeNode selectedNode = GenerationTrees.this.classesTree.getMatchingNode(parent, selectedClassIRI);
                if (selectedNode != null) {
                    TreePath selectedPath = new TreePath(((DefaultTreeModel)GenerationTrees.this.classesTree.tree.getModel()).getPathToRoot(selectedNode));
                    GenerationTrees.this.classesTree.tree.setSelectionPath(selectedPath);
                    GenerationTrees.this.individualsTree.setClassIRI(selectedClassIRI.getEntryIRI());
                    parent = (DefaultMutableTreeNode)GenerationTrees.this.individualsTree.tree.getModel().getRoot();
                    selectedNode = GenerationTrees.this.individualsTree.getMatchingNode(parent, selectedIndividualIRI);
                    if (selectedNode != null) {
                        selectedPath = new TreePath(((DefaultTreeModel)GenerationTrees.this.individualsTree.tree.getModel()).getPathToRoot(selectedNode));
                        GenerationTrees.this.individualsTree.tree.setSelectionPath(selectedPath);
                    }
                } else {
                    GenerationTrees.this.individualsTree.setClassIRI(null);
                    GenerationTrees.this.individualsTreePanel = GenerationTrees.this.individualsTree.TP();
                    GenerationTrees.this.scrollIndividuals.setViewportView(GenerationTrees.this.individualsTreePanel);
                }
            }
        });
        this.individualRefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ListIRI selectedIndividualIRI = null;
                if (GenerationTrees.this.individualsTree.tree.getLastSelectedPathComponent() != null) {
                    selectedIndividualIRI = (ListIRI)((DefaultMutableTreeNode)GenerationTrees.this.individualsTree.tree.getLastSelectedPathComponent()).getUserObject();
                }
                GenerationTrees.this.individualsTreePanel = GenerationTrees.this.individualsTree.TP();
                GenerationTrees.this.scrollIndividuals.setViewportView(GenerationTrees.this.individualsTreePanel);
                DefaultMutableTreeNode parent = (DefaultMutableTreeNode)GenerationTrees.this.individualsTree.tree.getModel().getRoot();
                DefaultMutableTreeNode selectedNode = GenerationTrees.this.individualsTree.getMatchingNode(parent, selectedIndividualIRI);
                if (selectedNode != null) {
                    TreePath selectedPath = new TreePath(((DefaultTreeModel)GenerationTrees.this.individualsTree.tree.getModel()).getPathToRoot(selectedNode));
                    GenerationTrees.this.individualsTree.tree.setSelectionPath(selectedPath);
                }
            }
        });
        this.classesPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        this.individualsPanel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        this.classesTree = new ClassesTreeComponent(this);
        this.individualsTree = new IndividualsTreeComponent(this);
        JLabel classesLabel = new JLabel("Classes");
        JLabel individualsLabel = new JLabel("Individuals");
        this.classesTreePanel = this.classesTree.TP();
        this.scrollClasses = new JScrollPane(this.classesTreePanel);
        this.scrollClasses.setViewportView(this.classesTreePanel);
        this.individualsTreePanel = this.individualsTree.TP();
        this.scrollIndividuals = new JScrollPane(this.individualsTreePanel);
        this.scrollIndividuals.setViewportView(this.individualsTreePanel);
        JPanel classesButtonsPanel = new JPanel();
        JPanel individualsButtonsPanel = new JPanel();
        classesButtonsPanel.add(this.classClearButton);
        classesButtonsPanel.add(this.classRefreshButton);
        individualsButtonsPanel.add(this.individualClearButton);
        individualsButtonsPanel.add(this.individualRefreshButton);
        this.classesPanel.add((Component)classesLabel, "First");
        this.classesPanel.add((Component)this.scrollClasses, "Center");
        this.classesPanel.add((Component)classesButtonsPanel, "Last");
        this.individualsPanel.add((Component)individualsLabel, "First");
        this.individualsPanel.add((Component)this.scrollIndividuals, "Center");
        this.individualsPanel.add((Component)individualsButtonsPanel, "Last");
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.anchor = 21;
        c.insets = new Insets(0, 0, 0, 10);
        this.panelMain.add((Component)this.classesPanel, c);
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 22;
        this.panelMain.add((Component)this.individualsPanel, c);
        this.add(this.panelMain);
    }

    private OWLSelectionModelListener getOWLClassSelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = generationClassSelectionModel.getSelectedEntity();
                if (selected != null) {
                    GenerationTrees.this.individualsTree.clearSelection();
                    GenerationTrees.this.showDomainIndividuals(selected.getIRI());
                    GenerationTrees.this.validate();
                    GenerationTrees.this.repaint();
                }
            }
        };
    }

    private void showDomainIndividuals(IRI classIRI) {
        this.individualsTree.setClassIRI(classIRI);
        this.individualsTreePanel = this.individualsTree.TP();
        this.scrollIndividuals.setViewportView(this.individualsTreePanel);
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.getOWLModelManager().removeListener(this.modelListener);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }
}

