/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLGEngine.NLGEngine;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNamesTab;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.Utils.NLGUser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.selection.OWLSelectionModelImpl;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;

public class GenerationTab
extends NaturalOWLTab {
    private static final long serialVersionUID = 8268241587271333587L;
    private static final String PIPELINE_MODEL = "Pipeline model";
    private static final String ILP_MODEL = "ILP model";
    private static final String ILP_MODEL_APPROX = "ILP model (approx.)";
    private JPanel optionsPanelUnderSub2Pipeline;
    private JPanel optionsPanelUnderSub2ILP;
    private JLabel generationLabel;
    private JLabel lamdaContentSection;
    private JLabel lamdaAggregation;
    private JLabel weightFactImportance;
    private JLabel weightSlotMinimization;
    private JLabel overridePipelineFactLimitFacts;
    private JLabel overridePipelineFactLimitSlots;
    private JLabel overrideILPFactLimitSlots;
    private JLabel overrideILPTextLimitSentences;
    private JButton errorButton;
    private JComboBox<String> languageCombo;
    private JComboBox<ListIRI> userTypeCombo;
    private JComboBox<String> distanceCombo;
    private JComboBox<String> engineCombo;
    private JCheckBox annotationCheck;
    private JCheckBox shapeCheck;
    private JCheckBox annotateGeneratedCheck;
    private JCheckBox generateComparisonsCheck;
    private JCheckBox overridePipelineFactLimitCheck;
    private JCheckBox overridePipelineSlotLimitCheck;
    private JCheckBox overrideILPSlotLimitCheck;
    private JCheckBox overrideILPTextLimitCheck;
    private JTextField overridePipelineFactLimitText;
    private JTextField overridePipelineSlotLimitText;
    private JTextField overrideILPSlotLimitText;
    private JTextField overrideILPTextLimitText;
    private JButton generateButton;
    private JButton resetButton;
    private JSlider lamdaSlider;
    private JScrollPane scroll;
    private JTextPane resultTextPane;
    private DecimalFormat df = new DecimalFormat("0.00");
    private OWLClass selectedClass = null;
    private OWLNamedIndividual selectedIndividual = null;
    private NLGUser user = null;
    private NLGEngine engine = null;
    private OWLModelManagerListener modelListener;
    private int pipelineFactLimit = 2;
    private int pipelineSlotLimit = 10;
    private int ILPSlotLimit = 10;
    private int ILPTextLimit = 20;

    protected void initialiseOWLView() throws Exception {
        generationClassSelectionModel.addListener(this.getOWLClassSelectionModelListener());
        generationIndivSelectionModel.addListener(this.getOWLIndividualSelectionModelListener());
        refresh.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                GenerationTab.this.refresh();
            }
        });
        this.setLayout(new BorderLayout());
        this.generateButton = new JButton("Generate text");
        this.resetButton = new JButton("Reset interaction history");
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new BoxLayout(optionsPanel, 3));
        JPanel optionsPanelOver = new JPanel();
        optionsPanelOver.setLayout(new BoxLayout(optionsPanelOver, 3));
        JPanel optionsPanelOverSub1 = new JPanel();
        optionsPanelOverSub1.setLayout(new FlowLayout(3));
        this.generationLabel = new JLabel();
        optionsPanelOverSub1.add(this.generationLabel);
        JPanel optionsPanelOverSub2 = new JPanel();
        optionsPanelOverSub2.setLayout(new FlowLayout(3));
        JLabel languageLabel = new JLabel("For language: ");
        String[] languages = new String[]{"English", "Greek"};
        this.languageCombo = new JComboBox<String>(languages);
        JLabel userTypeLabel = new JLabel("For user type: ");
        this.userTypeCombo = new JComboBox();
        this.updateUserTypeCombo();
        this.userTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                IRI userType = null;
                if (GenerationTab.this.user != null) {
                    userType = GenerationTab.this.user.getUserModel().getUMIRI();
                }
                if (((ListIRI)GenerationTab.this.userTypeCombo.getSelectedItem()).getEntryIRI().equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    GenerationTab.this.user = new NLGUser("globalUser", UMQM.getGlobalUserModel());
                } else {
                    GenerationTab.this.user = new NLGUser("tempUser", UMQM.getUserModel(((ListIRI)GenerationTab.this.userTypeCombo.getSelectedItem()).getEntryIRI()));
                }
                if (userType != null && !userType.equals((Object)GenerationTab.this.user.getUserModel().getUMIRI())) {
                    GenerationTab.this.overridePipelineFactLimitCheck.setSelected(false);
                    GenerationTab.this.overridePipelineSlotLimitCheck.setSelected(false);
                    GenerationTab.this.overrideILPSlotLimitCheck.setSelected(false);
                    GenerationTab.this.overrideILPTextLimitCheck.setSelected(false);
                    GenerationTab.this.overridePipelineFactLimitText.setText("" + GenerationTab.this.user.getUserModel().getMaxMessagesPerSentence());
                    GenerationTab.this.overridePipelineSlotLimitText.setText("10");
                    GenerationTab.this.overrideILPSlotLimitText.setText("10");
                    GenerationTab.this.overrideILPTextLimitText.setText("" + GenerationTab.this.user.getUserModel().getMaxMessagesPerPage());
                }
            }
        });
        this.userTypeCombo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                GenerationTab.this.updateUserTypeCombo();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        optionsPanelOverSub2.add(languageLabel);
        optionsPanelOverSub2.add(this.languageCombo);
        optionsPanelOverSub2.add(Box.createRigidArea(new Dimension(10, 10)));
        optionsPanelOverSub2.add(userTypeLabel);
        optionsPanelOverSub2.add(this.userTypeCombo);
        JPanel optionsPanelOverSub3 = new JPanel();
        optionsPanelOverSub3.setLayout(new FlowLayout(3));
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GenerationTab.this.selectedIndividual != null) {
                    GenerationTab.this.generateText(GenerationTab.this.selectedIndividual.getIRI());
                } else if (GenerationTab.this.selectedClass != null) {
                    GenerationTab.this.generateText(GenerationTab.this.selectedClass.getIRI());
                }
            }
        });
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GenerationTab.this.user.resetCounters();
            }
        });
        optionsPanelOverSub3.add(this.generateButton);
        optionsPanelOverSub3.add(Box.createRigidArea(new Dimension(10, 10)));
        optionsPanelOverSub3.add(this.resetButton);
        optionsPanelOver.add(optionsPanelOverSub1);
        optionsPanelOver.add(optionsPanelOverSub2);
        optionsPanelOver.add(optionsPanelOverSub3);
        JPanel optionsPanelUnder = new JPanel();
        optionsPanelUnder.setLayout(new BoxLayout(optionsPanelUnder, 2));
        JPanel optionsPanelUnderSub1 = new JPanel();
        optionsPanelUnderSub1.setLayout(new BoxLayout(optionsPanelUnderSub1, 3));
        JPanel optionsPanelUnderSub1Sub1 = new JPanel();
        optionsPanelUnderSub1Sub1.setLayout(new FlowLayout(3));
        JLabel engineLabel = new JLabel("Use engine: ");
        String[] engines = new String[]{PIPELINE_MODEL, ILP_MODEL, ILP_MODEL_APPROX};
        this.engineCombo = new JComboBox<String>(engines);
        this.engineCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (GenerationTab.this.engineCombo.getSelectedItem().equals(GenerationTab.PIPELINE_MODEL)) {
                    GenerationTab.this.optionsPanelUnderSub2Pipeline.setVisible(true);
                    GenerationTab.this.optionsPanelUnderSub2ILP.setVisible(false);
                } else {
                    if (GenerationTab.this.engineCombo.getSelectedItem().equals(GenerationTab.ILP_MODEL)) {
                        if (GenerationTab.isValidNumber(GenerationTab.this.overrideILPTextLimitText.getText()) && (Integer.parseInt(GenerationTab.this.overrideILPTextLimitText.getText()) > 3 || GenerationTab.this.user.getUserModel().getMaxMessagesPerPage() > 3)) {
                            GenerationTab.this.overrideILPTextLimitText.setText("3");
                            GenerationTab.this.overrideILPTextLimitCheck.setSelected(true);
                            GenerationTab.this.errorButton.setVisible(true);
                        }
                    } else {
                        GenerationTab.this.errorButton.setVisible(false);
                    }
                    GenerationTab.this.optionsPanelUnderSub2Pipeline.setVisible(false);
                    GenerationTab.this.optionsPanelUnderSub2ILP.setVisible(true);
                }
            }
        });
        optionsPanelUnderSub1Sub1.add(engineLabel);
        optionsPanelUnderSub1Sub1.add(this.engineCombo);
        optionsPanelUnderSub1.add(optionsPanelUnderSub1Sub1);
        this.optionsPanelUnderSub2Pipeline = new JPanel();
        this.optionsPanelUnderSub2Pipeline.setLayout(new BoxLayout(this.optionsPanelUnderSub2Pipeline, 3));
        JPanel optionsPanelUnderSub2PipelineSub1 = new JPanel();
        optionsPanelUnderSub2PipelineSub1.setLayout(new FlowLayout(3));
        JLabel distanceLabel = new JLabel("For maximum graph distance: ");
        String[] distances = new String[]{"1", "2"};
        this.distanceCombo = new JComboBox<String>(distances);
        optionsPanelUnderSub2PipelineSub1.add(distanceLabel);
        optionsPanelUnderSub2PipelineSub1.add(this.distanceCombo);
        JPanel optionsPanelUnderSub2PipelineSub2 = new JPanel();
        optionsPanelUnderSub2PipelineSub2.setLayout(new FlowLayout(3));
        JLabel overrideSentenceLimitLabel = new JLabel("Override user model's sentence aggregation limit:");
        optionsPanelUnderSub2PipelineSub2.add(overrideSentenceLimitLabel);
        JPanel optionsPanelUnderSub2PipelineSub3 = new JPanel();
        optionsPanelUnderSub2PipelineSub3.setLayout(new FlowLayout(3));
        this.overridePipelineFactLimitCheck = new JCheckBox("Limit sentence to ");
        this.overridePipelineFactLimitText = new JTextField(2);
        this.overridePipelineFactLimitFacts = new JLabel("facts.");
        this.overridePipelineFactLimitText.setEnabled(false);
        this.overridePipelineFactLimitCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.overridePipelineFactLimitCheck.isSelected()) {
                    GenerationTab.this.overridePipelineFactLimitText.setEnabled(true);
                } else {
                    GenerationTab.this.overridePipelineFactLimitText.setEnabled(false);
                }
            }
        });
        this.overridePipelineFactLimitText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            public void checkValue() {
                if (GenerationTab.isValidNumber(GenerationTab.this.overridePipelineFactLimitText.getText().trim())) {
                    GenerationTab.this.pipelineFactLimit = Integer.parseInt(GenerationTab.this.overridePipelineFactLimitText.getText());
                } else {
                    GenerationTab.this.overridePipelineFactLimitText.setText("" + GenerationTab.this.pipelineFactLimit);
                }
            }
        });
        optionsPanelUnderSub2PipelineSub3.add(Box.createRigidArea(new Dimension(5, 5)));
        optionsPanelUnderSub2PipelineSub3.add(this.overridePipelineFactLimitCheck);
        optionsPanelUnderSub2PipelineSub3.add(this.overridePipelineFactLimitText);
        optionsPanelUnderSub2PipelineSub3.add(this.overridePipelineFactLimitFacts);
        JPanel optionsPanelUnderSub2PipelineSub4 = new JPanel();
        optionsPanelUnderSub2PipelineSub4.setLayout(new FlowLayout(3));
        this.overridePipelineSlotLimitCheck = new JCheckBox("Limit sentence to ");
        this.overridePipelineSlotLimitText = new JTextField(2);
        this.overridePipelineFactLimitSlots = new JLabel("slots.");
        this.overridePipelineSlotLimitText.setEnabled(false);
        this.overridePipelineSlotLimitCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.overridePipelineSlotLimitCheck.isSelected()) {
                    GenerationTab.this.overridePipelineSlotLimitText.setEnabled(true);
                } else {
                    GenerationTab.this.overridePipelineSlotLimitText.setEnabled(false);
                }
            }
        });
        this.overridePipelineSlotLimitText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            public void checkValue() {
                if (GenerationTab.isValidNumber(GenerationTab.this.overridePipelineSlotLimitText.getText().trim())) {
                    GenerationTab.this.pipelineSlotLimit = Integer.parseInt(GenerationTab.this.overridePipelineSlotLimitText.getText());
                } else {
                    GenerationTab.this.overridePipelineSlotLimitText.setText("" + GenerationTab.this.pipelineSlotLimit);
                }
            }
        });
        optionsPanelUnderSub2PipelineSub4.add(Box.createRigidArea(new Dimension(5, 5)));
        optionsPanelUnderSub2PipelineSub4.add(this.overridePipelineSlotLimitCheck);
        optionsPanelUnderSub2PipelineSub4.add(this.overridePipelineSlotLimitText);
        optionsPanelUnderSub2PipelineSub4.add(this.overridePipelineFactLimitSlots);
        this.optionsPanelUnderSub2Pipeline.add(optionsPanelUnderSub2PipelineSub1);
        this.optionsPanelUnderSub2Pipeline.add(new JSeparator(0));
        this.optionsPanelUnderSub2Pipeline.add(optionsPanelUnderSub2PipelineSub2);
        this.optionsPanelUnderSub2Pipeline.add(optionsPanelUnderSub2PipelineSub3);
        this.optionsPanelUnderSub2Pipeline.add(optionsPanelUnderSub2PipelineSub4);
        this.optionsPanelUnderSub2ILP = new JPanel();
        this.optionsPanelUnderSub2ILP.setLayout(new BoxLayout(this.optionsPanelUnderSub2ILP, 3));
        JPanel optionsPanelUnderSub2ILPSub1 = new JPanel();
        optionsPanelUnderSub2ILPSub1.setLayout(new FlowLayout(3));
        JLabel lamdaLabel = new JLabel("Set the value of lamda:");
        optionsPanelUnderSub2ILPSub1.add(lamdaLabel);
        JPanel optionsPanelUnderSub2ILPSub2 = new JPanel();
        optionsPanelUnderSub2ILPSub2.setLayout(new FlowLayout(3));
        this.lamdaSlider = new JSlider(0, 0, 100, 50);
        this.lamdaSlider.setPaintLabels(false);
        this.lamdaSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                GenerationTab.this.lamdaContentSection.setText(GenerationTab.this.df.format((double)GenerationTab.this.lamdaSlider.getValue() / 100.0));
                GenerationTab.this.lamdaAggregation.setText(GenerationTab.this.df.format(1.0 - (double)GenerationTab.this.lamdaSlider.getValue() / 100.0));
                if (((ListIRI)GenerationTab.this.userTypeCombo.getSelectedItem()).getEntryIRI().equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    GenerationTab.this.user = new NLGUser("globalUser", UMQM.getGlobalUserModel());
                } else {
                    GenerationTab.this.user = new NLGUser("tempUser", UMQM.getUserModel(((ListIRI)GenerationTab.this.userTypeCombo.getSelectedItem()).getEntryIRI()));
                }
            }
        });
        optionsPanelUnderSub2ILPSub2.add(this.lamdaSlider);
        JPanel optionsPanelUnderSub2ILPSub3 = new JPanel();
        optionsPanelUnderSub2ILPSub3.setLayout(new FlowLayout(3));
        this.weightFactImportance = new JLabel("Weight on maximization of fact importance: ");
        this.lamdaContentSection = new JLabel(this.df.format((double)this.lamdaSlider.getValue() / 100.0));
        optionsPanelUnderSub2ILPSub3.add(Box.createRigidArea(new Dimension(5, 5)));
        optionsPanelUnderSub2ILPSub3.add(this.weightFactImportance);
        optionsPanelUnderSub2ILPSub3.add(this.lamdaContentSection);
        JPanel optionsPanelUnderSub2ILPSub4 = new JPanel();
        optionsPanelUnderSub2ILPSub4.setLayout(new FlowLayout(3));
        this.weightSlotMinimization = new JLabel("Weight on minimization of distinct slots: ");
        this.lamdaAggregation = new JLabel(this.df.format(1.0 - (double)this.lamdaSlider.getValue() / 100.0));
        optionsPanelUnderSub2ILPSub4.add(Box.createRigidArea(new Dimension(5, 5)));
        optionsPanelUnderSub2ILPSub4.add(this.weightSlotMinimization);
        optionsPanelUnderSub2ILPSub4.add(this.lamdaAggregation);
        JPanel optionsPanelUnderSub2ILPSub5 = new JPanel();
        optionsPanelUnderSub2ILPSub5.setLayout(new FlowLayout(3));
        JLabel overrideTextLimitLabel = new JLabel("Override user model's text length limit:");
        optionsPanelUnderSub2ILPSub5.add(overrideTextLimitLabel);
        JPanel optionsPanelUnderSub2ILPSub6 = new JPanel();
        optionsPanelUnderSub2ILPSub6.setLayout(new FlowLayout(3));
        this.overrideILPTextLimitCheck = new JCheckBox("Limit text to ");
        this.overrideILPTextLimitText = new JTextField(2);
        this.overrideILPTextLimitSentences = new JLabel("sentences.");
        ClassLoader loader = NLNamesTab.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/error.png");
        ImageIcon errorIcon = new ImageIcon(imageURL);
        Image img = errorIcon.getImage();
        Image newimg = img.getScaledInstance(15, 15, 4);
        errorIcon = new ImageIcon(newimg);
        this.errorButton = new JButton(errorIcon);
        this.errorButton.setBorder(null);
        this.errorButton.setFocusPainted(false);
        this.errorButton.setContentAreaFilled(false);
        this.errorButton.setToolTipText("Unacceptable max messages per page value: click to view error");
        this.errorButton.setVisible(false);
        this.errorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GenerationTab.this.user.getUserModel().getMaxMessagesPerPage() > 3) {
                    JOptionPane.showMessageDialog(null, "The selected user type has greater 'max messages per page' (" + GenerationTab.this.user.getUserModel().getMaxMessagesPerPage() + ") than advisable. \nThe 'ILP model' engine requires too much time for texts larger than 3 sentences! \nUse 'ILP model (approx.)' engine instead.", "Unacceptable max messages per page value", 0);
                } else {
                    JOptionPane.showMessageDialog(null, "The 'ILP model' engine requires too much time for texts larger than 3 sentences! \nUse 'ILP model (approx.)' engine instead.", "Unacceptable max messages per page value", 0);
                    GenerationTab.this.errorButton.setVisible(false);
                }
            }
        });
        this.overrideILPTextLimitText.setEnabled(false);
        this.overrideILPTextLimitCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.overrideILPTextLimitCheck.isSelected()) {
                    GenerationTab.this.overrideILPTextLimitText.setEnabled(true);
                    GenerationTab.this.errorButton.setVisible(false);
                } else {
                    GenerationTab.this.overrideILPTextLimitText.setEnabled(false);
                    if (GenerationTab.this.engineCombo.getSelectedItem().equals(GenerationTab.ILP_MODEL) && GenerationTab.this.user.getUserModel().getMaxMessagesPerPage() > 3) {
                        GenerationTab.this.overrideILPTextLimitText.setText("3");
                        GenerationTab.this.overrideILPTextLimitCheck.setSelected(true);
                        GenerationTab.this.errorButton.setVisible(true);
                    }
                }
            }
        });
        this.overrideILPTextLimitText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            public void checkValue() {
                if (GenerationTab.isValidNumber(GenerationTab.this.overrideILPTextLimitText.getText().trim())) {
                    if (GenerationTab.this.engineCombo.getSelectedItem().equals(GenerationTab.ILP_MODEL)) {
                        if (Integer.parseInt(GenerationTab.this.overrideILPTextLimitText.getText()) > 3) {
                            GenerationTab.this.overrideILPTextLimitText.setText("3");
                            GenerationTab.this.overrideILPTextLimitCheck.setSelected(true);
                            GenerationTab.this.overrideILPTextLimitText.setEnabled(true);
                            GenerationTab.this.errorButton.setVisible(true);
                        }
                    } else {
                        GenerationTab.this.errorButton.setVisible(false);
                    }
                    GenerationTab.this.ILPTextLimit = Integer.parseInt(GenerationTab.this.overrideILPTextLimitText.getText());
                } else {
                    GenerationTab.this.overrideILPTextLimitText.setText("" + GenerationTab.this.ILPTextLimit);
                    GenerationTab.this.errorButton.setVisible(false);
                }
            }
        });
        optionsPanelUnderSub2ILPSub6.add(Box.createRigidArea(new Dimension(5, 5)));
        optionsPanelUnderSub2ILPSub6.add(this.overrideILPTextLimitCheck);
        optionsPanelUnderSub2ILPSub6.add(this.overrideILPTextLimitText);
        optionsPanelUnderSub2ILPSub6.add(this.overrideILPTextLimitSentences);
        optionsPanelUnderSub2ILPSub6.add(this.errorButton);
        JPanel optionsPanelUnderSub2ILPSub7 = new JPanel();
        optionsPanelUnderSub2ILPSub7.setLayout(new FlowLayout(3));
        JLabel overrideSentenceLimitLabel2 = new JLabel("Override user model's sentence aggregation limit:");
        optionsPanelUnderSub2ILPSub7.add(overrideSentenceLimitLabel2);
        JPanel optionsPanelUnderSub2ILPSub8 = new JPanel();
        optionsPanelUnderSub2ILPSub8.setLayout(new FlowLayout(3));
        this.overrideILPSlotLimitCheck = new JCheckBox("Limit sentence to ");
        this.overrideILPSlotLimitText = new JTextField(2);
        this.overrideILPFactLimitSlots = new JLabel("slots.");
        this.overrideILPSlotLimitText.setEnabled(false);
        this.overrideILPSlotLimitCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.overrideILPSlotLimitCheck.isSelected()) {
                    GenerationTab.this.overrideILPSlotLimitText.setEnabled(true);
                } else {
                    GenerationTab.this.overrideILPSlotLimitText.setEnabled(false);
                }
            }
        });
        this.overrideILPSlotLimitText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.checkValue();
                    }
                });
            }

            public void checkValue() {
                if (GenerationTab.isValidNumber(GenerationTab.this.overrideILPSlotLimitText.getText().trim())) {
                    GenerationTab.this.ILPSlotLimit = Integer.parseInt(GenerationTab.this.overrideILPSlotLimitText.getText());
                } else {
                    GenerationTab.this.overrideILPSlotLimitText.setText("" + GenerationTab.this.ILPSlotLimit);
                }
            }
        });
        optionsPanelUnderSub2ILPSub8.add(Box.createRigidArea(new Dimension(5, 5)));
        optionsPanelUnderSub2ILPSub8.add(this.overrideILPSlotLimitCheck);
        optionsPanelUnderSub2ILPSub8.add(this.overrideILPSlotLimitText);
        optionsPanelUnderSub2ILPSub8.add(this.overrideILPFactLimitSlots);
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub1);
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub2);
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub3);
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub4);
        this.optionsPanelUnderSub2ILP.add(new JSeparator(0));
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub5);
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub6);
        this.optionsPanelUnderSub2ILP.add(new JSeparator(0));
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub7);
        this.optionsPanelUnderSub2ILP.add(optionsPanelUnderSub2ILPSub8);
        JPanel optionsPanelUnderSub3 = new JPanel();
        optionsPanelUnderSub3.setLayout(new BoxLayout(optionsPanelUnderSub3, 3));
        JPanel optionsPanelUnderSub3Sub1 = new JPanel();
        optionsPanelUnderSub3Sub1.setLayout(new FlowLayout(3));
        this.annotationCheck = new JCheckBox("Show semantic and syntactic annotations.");
        this.annotationCheck.setSelected(false);
        this.annotationCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.annotationCheck.isSelected()) {
                    GenerationTab.this.shapeCheck.setSelected(false);
                    GenerationTab.this.annotateGeneratedCheck.setSelected(false);
                    if (GenerationTab.this.engine != null) {
                        GenerationTab.this.engine.setSectionParagraphs(GenerationTab.this.shapeCheck.isSelected());
                        GenerationTab.this.engine.setAnnotateGeneratedResources(GenerationTab.this.annotateGeneratedCheck.isSelected());
                    }
                }
            }
        });
        optionsPanelUnderSub3Sub1.add(this.annotationCheck);
        JPanel optionsPanelUnderSub3Sub2 = new JPanel();
        optionsPanelUnderSub3Sub2.setLayout(new FlowLayout(3));
        this.shapeCheck = new JCheckBox("Shape text paragraphs.");
        this.shapeCheck.setSelected(false);
        this.shapeCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.shapeCheck.isSelected()) {
                    GenerationTab.this.annotationCheck.setSelected(false);
                }
            }
        });
        optionsPanelUnderSub3Sub2.add(this.shapeCheck);
        JPanel optionsPanelUnderSub3Sub3 = new JPanel();
        optionsPanelUnderSub3Sub3.setLayout(new FlowLayout(3));
        this.annotateGeneratedCheck = new JCheckBox("Markup use of default resources.");
        this.annotateGeneratedCheck.setSelected(false);
        this.annotateGeneratedCheck.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                if (GenerationTab.this.annotateGeneratedCheck.isSelected()) {
                    GenerationTab.this.annotationCheck.setSelected(false);
                    if (GenerationTab.this.engine != null) {
                        GenerationTab.this.engine.setAnnotateGeneratedResources(GenerationTab.this.annotateGeneratedCheck.isSelected());
                    }
                }
            }
        });
        optionsPanelUnderSub3Sub3.add(this.annotateGeneratedCheck);
        JPanel optionsPanelUnderSub3Sub4 = new JPanel();
        optionsPanelUnderSub3Sub4.setLayout(new FlowLayout(3));
        this.generateComparisonsCheck = new JCheckBox("Generate comparisons.");
        this.generateComparisonsCheck.setSelected(false);
        optionsPanelUnderSub3Sub4.add(this.generateComparisonsCheck);
        optionsPanelUnderSub3.add(optionsPanelUnderSub3Sub1);
        optionsPanelUnderSub3.add(optionsPanelUnderSub3Sub2);
        optionsPanelUnderSub3.add(optionsPanelUnderSub3Sub3);
        optionsPanelUnderSub3.add(optionsPanelUnderSub3Sub4);
        JPanel optionsPanelUnderSub3Shell = new JPanel();
        optionsPanelUnderSub3Shell.setLayout(new FlowLayout());
        optionsPanelUnderSub3Shell.add(optionsPanelUnderSub3);
        if (this.user == null) {
            this.user = new NLGUser("tempUser", UMQM.getUserModel(((ListIRI)this.userTypeCombo.getSelectedItem()).getEntryIRI()));
            this.overridePipelineFactLimitText.setText("" + this.user.getUserModel().getMaxMessagesPerSentence());
            this.overridePipelineSlotLimitText.setText("10");
            this.overrideILPSlotLimitText.setText("10");
            if (this.engineCombo.getSelectedItem().equals(ILP_MODEL)) {
                if (this.user.getUserModel().getMaxMessagesPerPage() > 3) {
                    this.overrideILPTextLimitText.setText("3");
                    this.overrideILPTextLimitCheck.setSelected(true);
                    this.overrideILPTextLimitText.setEnabled(true);
                    this.errorButton.setVisible(true);
                } else {
                    this.overrideILPTextLimitText.setText("" + this.user.getUserModel().getMaxMessagesPerPage());
                    this.errorButton.setVisible(false);
                }
            } else {
                this.overrideILPTextLimitText.setText("" + this.user.getUserModel().getMaxMessagesPerPage());
            }
        }
        optionsPanelUnder.add(optionsPanelUnderSub1);
        optionsPanelUnder.add(this.optionsPanelUnderSub2Pipeline);
        optionsPanelUnder.add(this.optionsPanelUnderSub2ILP);
        optionsPanelUnder.add(optionsPanelUnderSub3Shell);
        this.optionsPanelUnderSub2ILP.setVisible(false);
        optionsPanel.add(optionsPanelOver);
        optionsPanel.add(new JSeparator(0));
        optionsPanel.add(optionsPanelUnder);
        this.resultTextPane = new JTextPane();
        this.resultTextPane.setEditable(false);
        this.resultTextPane.setContentType("text/html");
        this.resultTextPane.setBackground(new Color(255, 255, 255));
        this.scroll = new JScrollPane(this.resultTextPane);
        this.scroll.setHorizontalScrollBarPolicy(31);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.scroll.setViewportView(this.resultTextPane);
        this.add(optionsPanel, "First");
        this.add(this.scroll, "Center");
        this.setAllEnabled(false);
        this.validate();
        this.repaint();
    }

    private void refresh() {
        IRI userType = null;
        if (this.user != null) {
            userType = this.user.getUserModel().getUMIRI();
        }
        this.user = ((ListIRI)this.userTypeCombo.getSelectedItem()).getEntryIRI().equals((Object)NLResourceManager.globalUserModel.getIRI()) ? new NLGUser("globalUser", UMQM.getGlobalUserModel()) : new NLGUser("tempUser", UMQM.getUserModel(((ListIRI)this.userTypeCombo.getSelectedItem()).getEntryIRI()));
        if (userType != null && !userType.equals((Object)this.user.getUserModel().getUMIRI())) {
            this.overridePipelineFactLimitCheck.setSelected(false);
            this.overridePipelineSlotLimitCheck.setSelected(false);
            this.overrideILPSlotLimitCheck.setSelected(false);
            this.overrideILPTextLimitCheck.setSelected(false);
            this.overridePipelineFactLimitText.setText("" + this.user.getUserModel().getMaxMessagesPerSentence());
            this.overridePipelineSlotLimitText.setText("10");
            this.overrideILPSlotLimitText.setText("10");
            if (this.engineCombo.getSelectedItem().equals(ILP_MODEL)) {
                if (this.user.getUserModel().getMaxMessagesPerPage() > 3) {
                    this.overrideILPTextLimitText.setText("3");
                    this.overrideILPTextLimitCheck.setSelected(true);
                    this.overrideILPTextLimitText.setEnabled(true);
                    this.errorButton.setVisible(true);
                } else {
                    this.overrideILPTextLimitText.setText("" + this.user.getUserModel().getMaxMessagesPerPage());
                    this.errorButton.setVisible(false);
                }
            } else {
                this.overrideILPTextLimitText.setText("" + this.user.getUserModel().getMaxMessagesPerPage());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void generateText(IRI target) {
        block24: {
            this.engine = this.languageCombo.getSelectedItem().equals("English") != false ? new NLGEngine(this.getOWLModelManager().getOWLOntologyManager(), GenerationTab.LQM, GenerationTab.SPQM, GenerationTab.NLNQM, GenerationTab.UMQM, GenerationTab.MQM, GenerationTab.OQM, "en") : new NLGEngine(this.getOWLModelManager().getOWLOntologyManager(), GenerationTab.LQM, GenerationTab.SPQM, GenerationTab.NLNQM, GenerationTab.UMQM, GenerationTab.MQM, GenerationTab.OQM, "el");
            this.engine.setSectionParagraphs(this.shapeCheck.isSelected());
            this.engine.setAnnotateGeneratedResources(this.annotateGeneratedCheck.isSelected());
            this.engine.setAllowComparisons(this.generateComparisonsCheck.isSelected());
            if (this.generateComparisonsCheck.isSelected()) {
                this.engine.buildTree();
            }
            if (this.engineCombo.getSelectedItem().equals("Pipeline model")) {
                this.engine.setUseEngine(0);
                if (this.overridePipelineFactLimitCheck.isSelected()) {
                    this.engine.setOverrideMaxMessagesPerSentence(Integer.parseInt(this.overridePipelineFactLimitText.getText()));
                } else {
                    this.engine.setOverrideMaxMessagesPerSentence(-1);
                }
                if (this.overridePipelineSlotLimitCheck.isSelected()) {
                    this.engine.setUseSlotLimit(true);
                    this.engine.setMaxSlotsPerSentence(Integer.parseInt(this.overridePipelineSlotLimitText.getText()));
                } else {
                    this.engine.setUseSlotLimit(false);
                }
            } else if (this.engineCombo.getSelectedItem().equals("ILP model")) {
                this.engine.setUseEngine(1);
            } else if (this.engineCombo.getSelectedItem().equals("ILP model (approx.)")) {
                this.engine.setUseEngine(2);
            }
            if (this.user == null) {
                this.user = new NLGUser("tempUser", GenerationTab.UMQM.getUserModel(((ListIRI)this.userTypeCombo.getSelectedItem()).getEntryIRI()));
            }
            if (this.engineCombo.getSelectedItem().equals("Pipeline model")) {
                result = this.engine.generateDescription(target, this.user, Integer.parseInt((String)this.distanceCombo.getSelectedItem()));
            } else {
                try {
                    result = this.engine.generateDescription(target, this.user, 1, Double.parseDouble(this.lamdaContentSection.getText().replace(',', '.')), Integer.parseInt(this.overrideILPTextLimitText.getText()), Integer.parseInt(this.overrideILPSlotLimitText.getText()));
                    break block24;
                }
                catch (UnsatisfiedLinkError e) {
                    result = new String[3];
                    i = 0;
                    ** while (i < 3)
                }
lbl-1000:
                // 1 sources

                {
                    result[i] = "*NULL*";
                    ++i;
                    continue;
                }
lbl39:
                // 1 sources

                JOptionPane.showMessageDialog(null, "The GNU Linear Programming Kit is not installed properly. See the README file for details.", "GLPK error", 0);
            }
            break block24;
            catch (NoClassDefFoundError e) {
                result = new String[3];
                i = 0;
                ** while (i < 3)
            }
lbl-1000:
            // 1 sources

            {
                result[i] = "*NULL*";
                ++i;
                continue;
            }
lbl48:
            // 1 sources

            JOptionPane.showMessageDialog(null, "The GNU Linear Programming Kit is not installed properly. See the README file for details.", "GLPK error", 0);
        }
        if (this.annotateGeneratedCheck.isSelected()) {
            e = "<html>";
        }
        if (this.annotationCheck.isSelected()) {
            this.resultTextPane.setContentType("text");
        } else {
            this.resultTextPane.setContentType("text/html");
        }
        generatedText = result[1].trim().equals("") != false ? "*NULL*" : result[1];
        if (this.engine.areAllFactsAssimilated()) {
            generatedText = this.annotationCheck.isSelected() != false ? String.valueOf(generatedText) + "\n\n" : String.valueOf(generatedText) + "<br><br>";
            generatedText = String.valueOf(generatedText) + "All facts are assimilated!";
        }
        if (this.annotationCheck.isSelected()) {
            generatedText = String.valueOf(generatedText) + "\n\n";
            generatedText = String.valueOf(generatedText) + result[2];
        }
        if (this.annotateGeneratedCheck.isSelected()) {
            generatedText = String.valueOf(generatedText) + "</html>";
        }
        this.resultTextPane.setText(generatedText);
    }

    private void updateUserTypeCombo() {
        HashSet<ListIRI> userTypes = new HashSet<ListIRI>();
        for (IRI iri : UMQM.getUserModels()) {
            userTypes.add(new ListIRI(iri));
        }
        userTypes.add(new ListIRI(NLResourceManager.globalUserModel.getIRI()));
        Object selected = this.userTypeCombo.getSelectedItem();
        if (!this.areIdentical((DefaultComboBoxModel)this.userTypeCombo.getModel(), userTypes)) {
            ArrayList<ListIRI> sortedList = new ArrayList<ListIRI>(userTypes);
            Collections.sort(sortedList);
            DefaultComboBoxModel<Object> userTypeComboModel = new DefaultComboBoxModel<Object>(sortedList.toArray());
            this.userTypeCombo.setModel(userTypeComboModel);
            if (userTypeComboModel.getIndexOf(selected) != -1) {
                this.userTypeCombo.setSelectedItem(selected);
            }
        }
    }

    private void setAllEnabled(boolean enabled) {
        this.languageCombo.setEnabled(enabled);
        this.userTypeCombo.setEnabled(enabled);
        this.distanceCombo.setEnabled(enabled);
        this.engineCombo.setEnabled(enabled);
        this.lamdaSlider.setEnabled(enabled);
        this.lamdaAggregation.setEnabled(enabled);
        this.lamdaContentSection.setEnabled(enabled);
        this.overridePipelineFactLimitCheck.setEnabled(enabled);
        this.overridePipelineSlotLimitCheck.setEnabled(enabled);
        this.overrideILPSlotLimitCheck.setEnabled(enabled);
        this.overrideILPTextLimitCheck.setEnabled(enabled);
        if (enabled) {
            if (this.overridePipelineFactLimitCheck.isSelected()) {
                this.overridePipelineFactLimitText.setEnabled(true);
            }
            if (this.overridePipelineSlotLimitCheck.isSelected()) {
                this.overridePipelineSlotLimitText.setEnabled(true);
            }
            if (this.overrideILPSlotLimitCheck.isSelected()) {
                this.overrideILPSlotLimitText.setEnabled(true);
            }
            if (this.overrideILPTextLimitCheck.isSelected()) {
                this.overrideILPTextLimitText.setEnabled(true);
            }
        } else {
            this.overridePipelineFactLimitText.setEnabled(false);
            this.overridePipelineSlotLimitText.setEnabled(false);
            this.overrideILPSlotLimitText.setEnabled(false);
            this.overrideILPTextLimitText.setEnabled(false);
        }
        this.weightFactImportance.setEnabled(enabled);
        this.weightSlotMinimization.setEnabled(enabled);
        this.overridePipelineFactLimitFacts.setEnabled(enabled);
        this.overridePipelineFactLimitSlots.setEnabled(enabled);
        this.overrideILPFactLimitSlots.setEnabled(enabled);
        this.overrideILPTextLimitSentences.setEnabled(enabled);
        this.annotationCheck.setEnabled(enabled);
        this.shapeCheck.setEnabled(enabled);
        this.annotateGeneratedCheck.setEnabled(enabled);
        this.generateComparisonsCheck.setEnabled(enabled);
        this.generateButton.setEnabled(enabled);
        this.resetButton.setEnabled(enabled);
    }

    private void updateLabel() {
        if (this.selectedIndividual != null) {
            this.generationLabel.setText("Generation text for " + this.selectedIndividual.getIRI().getFragment() + ".");
        } else if (this.selectedClass != null) {
            this.generationLabel.setText("Generation text for " + this.selectedClass.getIRI().getFragment() + ".");
        } else {
            this.generationLabel.setText("");
        }
    }

    private OWLSelectionModelListener getOWLClassSelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = generationClassSelectionModel.getSelectedEntity();
                if (selected != null) {
                    GenerationTab.this.selectedClass = GenerationTab.this.getOWLModelManager().getOWLDataFactory().getOWLClass(selected.getIRI());
                } else {
                    GenerationTab.this.selectedClass = null;
                    userModelTableClassSelectionModel = new OWLSelectionModelImpl();
                    userModelTableClassSelectionModel.addListener(GenerationTab.this.getOWLClassSelectionModelListener());
                }
                if (GenerationTab.this.selectedClass != null) {
                    GenerationTab.this.setAllEnabled(true);
                } else {
                    GenerationTab.this.setAllEnabled(false);
                }
                GenerationTab.this.updateLabel();
                GenerationTab.this.validate();
                GenerationTab.this.repaint();
            }
        };
    }

    private OWLSelectionModelListener getOWLIndividualSelectionModelListener() {
        return new OWLSelectionModelListener(){

            public void selectionChanged() throws Exception {
                OWLEntity selected = generationIndivSelectionModel.getSelectedEntity();
                if (selected != null) {
                    GenerationTab.this.selectedIndividual = GenerationTab.this.getOWLModelManager().getOWLDataFactory().getOWLNamedIndividual(selected.getIRI());
                } else {
                    GenerationTab.this.selectedIndividual = null;
                    userModelTableIndivSelectionModel = new OWLSelectionModelImpl();
                    userModelTableIndivSelectionModel.addListener(GenerationTab.this.getOWLIndividualSelectionModelListener());
                }
                if (GenerationTab.this.selectedClass != null) {
                    GenerationTab.this.setAllEnabled(true);
                } else {
                    GenerationTab.this.setAllEnabled(false);
                }
                GenerationTab.this.updateLabel();
                GenerationTab.this.validate();
                GenerationTab.this.repaint();
            }
        };
    }

    @Override
    protected void disposeOWLView() {
        super.disposeOWLView();
        this.getOWLModelManager().removeListener(this.modelListener);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
    }

    public boolean areIdentical(DefaultComboBoxModel<ListIRI> a, HashSet<ListIRI> b) {
        if (a.getSize() == b.size()) {
            HashSet<ListIRI> checkSet = new HashSet<ListIRI>(b);
            int i = 0;
            while (i < a.getSize()) {
                checkSet.add(a.getElementAt(i));
                ++i;
            }
            return checkSet.size() == b.size();
        }
        return false;
    }

    public static boolean isValidNumber(String num) {
        try {
            int i = Integer.parseInt(num);
            return i >= 1;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

