/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLOwlPlugin.GenerationTrees;
import gr.aueb.cs.nlg.NLOwlPlugin.LexiconTreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeComponent;
import gr.aueb.cs.nlg.NLOwlPlugin.TreeRenderer;
import java.awt.Color;
import java.awt.FlowLayout;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;

public class ClassesTreeComponent
extends TreeComponent {
    private DefaultMutableTreeNode parent;
    private IRI propertyIRI = null;

    public ClassesTreeComponent(NaturalOWLTab fatherTab) {
        super(fatherTab);
    }

    @Override
    public void createTree() {
        if (this.father instanceof GenerationTrees) {
            this.parent = new DefaultMutableTreeNode(new ListIRI(this.father.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI()), true);
            HashSet<ListIRI> classesToAdd = new HashSet<ListIRI>();
            for (OWLClass rootClass : this.father.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getRoots()) {
                classesToAdd.add(new ListIRI(rootClass.getIRI()));
            }
            ArrayList classesToAddSorted = new ArrayList(classesToAdd);
            Collections.sort(classesToAddSorted);
            for (ListIRI add : classesToAddSorted) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(add, true);
                this.parent.add(node);
                this.addSubClasses(node, this.father.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getChildren((OWLObject)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(add.getEntryIRI())));
            }
            this.tree = new JTree(this.parent);
        } else if (this.propertyIRI != null) {
            this.parent = new DefaultMutableTreeNode(new ListIRI(this.father.getOWLModelManager().getOWLDataFactory().getOWLThing().getIRI()), true);
            HashSet<ListIRI> classesToAdd = new HashSet<ListIRI>();
            for (OWLOntology model : this.father.getOWLModelManager().getOntologies()) {
                if (model.containsObjectPropertyInSignature(this.propertyIRI)) {
                    for (OWLObjectPropertyDomainAxiom domainAxiom : model.getObjectPropertyDomainAxioms((OWLObjectPropertyExpression)this.father.getOWLModelManager().getOWLDataFactory().getOWLObjectProperty(this.propertyIRI))) {
                        classesToAdd.addAll(this.getClassExpressionIRIs(domainAxiom.getDomain()));
                    }
                    continue;
                }
                if (!model.containsDataPropertyInSignature(this.propertyIRI)) continue;
                for (OWLObjectPropertyDomainAxiom domainAxiom : model.getDataPropertyDomainAxioms(this.father.getOWLModelManager().getOWLDataFactory().getOWLDataProperty(this.propertyIRI))) {
                    classesToAdd.addAll(this.getClassExpressionIRIs(domainAxiom.getDomain()));
                }
            }
            if (classesToAdd.isEmpty()) {
                for (OWLClass rootClass : this.father.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getRoots()) {
                    classesToAdd.add(new ListIRI(rootClass.getIRI()));
                }
            }
            ArrayList classesToAddSorted = new ArrayList(classesToAdd);
            Collections.sort(classesToAddSorted);
            for (Object add : classesToAddSorted) {
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(add, true);
                this.parent.add(node);
                this.addSubClasses(node, this.father.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getChildren((OWLObject)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(((ListIRI)add).getEntryIRI())));
            }
            this.tree = new JTree(this.parent);
        } else {
            this.tree = new JTree();
        }
        this.tree.setEditable(false);
        this.tree.setRootVisible(false);
    }

    private void addSubClasses(DefaultMutableTreeNode parent, Set<OWLClass> subClasses) {
        HashSet<ListIRI> children = new HashSet<ListIRI>();
        for (OWLClassExpression oWLClassExpression : subClasses) {
            children.addAll(this.getClassExpressionIRIs(oWLClassExpression));
        }
        ArrayList arrayList = new ArrayList(children);
        Collections.sort(arrayList);
        for (ListIRI childIRI : arrayList) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(childIRI, true);
            parent.add(node);
            this.addSubClasses(node, this.father.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider().getChildren((OWLObject)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(childIRI.getEntryIRI())));
        }
    }

    private HashSet<ListIRI> getClassExpressionIRIs(OWLClassExpression classExpr) {
        HashSet<ListIRI> classesToAdd = new HashSet<ListIRI>();
        if (classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) {
            if (!classExpr.asOWLClass().getIRI().toString().startsWith(NLResourceManager.nlowlNS)) {
                classesToAdd.add(new ListIRI(classExpr.asOWLClass().getIRI()));
            }
        } else if (classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) {
            for (OWLClassExpression disjExpr : classExpr.asConjunctSet()) {
                classesToAdd.addAll(this.getClassExpressionIRIs(disjExpr));
            }
        }
        return classesToAdd;
    }

    @Override
    public JPanel TP() {
        JPanel treepanel = new JPanel();
        this.createTree();
        treepanel.setBackground(new Color(255, 255, 255));
        treepanel.setLayout(new FlowLayout(0));
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new TreeRenderer());
        this.tree.addTreeSelectionListener(this);
        ClassLoader loader = LexiconTreeComponent.class.getClassLoader();
        URL imageURL = loader.getResource("/icons/Classes.gif");
        ImageIcon icon = new ImageIcon(imageURL);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setClosedIcon(icon);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setOpenIcon(icon);
        ((DefaultTreeCellRenderer)this.tree.getCellRenderer()).setLeafIcon(icon);
        if (this.father instanceof GenerationTrees) {
            treepanel.add(this.tree);
        } else if (this.propertyIRI == null) {
            treepanel.remove(this.tree);
        } else {
            treepanel.add(this.tree);
        }
        return treepanel;
    }

    public IRI getPropertyIRI() {
        return this.propertyIRI;
    }

    public void setPropertyIRI(IRI propertyIRI) {
        this.propertyIRI = propertyIRI;
    }

    public void clearSelection() {
        this.tree.clearSelection();
        if (this.father instanceof GenerationTrees) {
            NaturalOWLTab.generationClassSelectionModel.clearLastSelectedEntity(NaturalOWLTab.generationClassSelectionModel.getSelectedEntity());
        } else {
            NaturalOWLTab.userModelTreeClassSelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTreeClassSelectionModel.getSelectedEntity());
            NaturalOWLTab.userModelTableClassSelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTableClassSelectionModel.getSelectedEntity());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            if (this.father instanceof GenerationTrees) {
                NaturalOWLTab.generationClassSelectionModel.clearLastSelectedEntity(NaturalOWLTab.generationClassSelectionModel.getSelectedEntity());
            } else {
                NaturalOWLTab.userModelTreeClassSelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTreeClassSelectionModel.getSelectedEntity());
                NaturalOWLTab.userModelTableClassSelectionModel.clearLastSelectedEntity(NaturalOWLTab.userModelTableClassSelectionModel.getSelectedEntity());
            }
            return;
        }
        IRI selectedIRI = ((ListIRI)node.getUserObject()).getEntryIRI();
        for (OWLOntology model : this.father.getOWLModelManager().getOntologies()) {
            if (!model.containsClassInSignature(selectedIRI)) continue;
            if (this.father instanceof GenerationTrees) {
                NaturalOWLTab.generationClassSelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(selectedIRI));
            } else {
                NaturalOWLTab.userModelTreeClassSelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(selectedIRI));
                NaturalOWLTab.userModelTableClassSelectionModel.setSelectedEntity((OWLEntity)this.father.getOWLModelManager().getOWLDataFactory().getOWLClass(selectedIRI));
            }
            return;
        }
    }
}

