/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLOwlPlugin;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLOwlPlugin.AppropriatenessTableModel;
import gr.aueb.cs.nlg.NLOwlPlugin.ListIRI;
import gr.aueb.cs.nlg.NLOwlPlugin.NLNamesTab;
import gr.aueb.cs.nlg.NLOwlPlugin.NaturalOWLTab;
import gr.aueb.cs.nlg.NLOwlPlugin.SentencePlanTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.semanticweb.owlapi.model.IRI;

class AppropriatenessDialogPanel
extends JPanel
implements TableModelListener {
    private static final long serialVersionUID = -2771247919823475133L;
    private final String userTypeColumn = "User Type";
    private final String appropriatenessColumn = "Appropriateness";
    NaturalOWLTab tab;
    IRI resourceEntry;
    JLabel connectLabel;
    JTable appropriatenessTable;

    AppropriatenessDialogPanel(NaturalOWLTab tab, IRI resourceEntry) {
        this.tab = tab;
        this.resourceEntry = resourceEntry;
        JPanel connectionCard = new JPanel();
        JPanel connectionCardSub1 = new JPanel();
        connectionCard.setLayout(new BorderLayout());
        connectionCardSub1.setLayout(new FlowLayout(0));
        if (tab instanceof NLNamesTab) {
            this.connectLabel = new JLabel("Set how appropriate this NL Name is for each User Type");
            this.fillNLNameTable();
        } else if (tab instanceof SentencePlanTab) {
            this.connectLabel = new JLabel("Set how appropriate this Sentence Plan is for each User Type");
            this.fillSentencePlanTable();
        }
        JScrollPane scrollApropTable = new JScrollPane(this.appropriatenessTable);
        connectionCardSub1.add(this.connectLabel);
        connectionCard.add((Component)connectionCardSub1, "First");
        connectionCard.add((Component)scrollApropTable, "Center");
        this.add(connectionCard);
    }

    public void fillNLNameTable() {
        String[] columnNames = new String[]{"User Type", "Appropriateness"};
        Object[][] data = new Object[NaturalOWLTab.UMQM.getUserModels().size() - 1][2];
        int row = 0;
        for (IRI UMIRI : NaturalOWLTab.UMQM.getUserModels()) {
            if (UMIRI.equals((Object)NLResourceManager.globalUserModel.getIRI())) continue;
            data[row][0] = new ListIRI(UMIRI);
            data[row][1] = NaturalOWLTab.UMQM.getNLNameAppropriateness(this.resourceEntry, UMIRI);
            ++row;
        }
        this.appropriatenessTable = new JTable(new AppropriatenessTableModel(data, columnNames));
        TableColumn column = null;
        int i = 0;
        while (i < this.appropriatenessTable.getColumnCount()) {
            column = this.appropriatenessTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            ++i;
        }
        this.appropriatenessTable.getTableHeader().setReorderingAllowed(false);
        this.appropriatenessTable.setCellSelectionEnabled(true);
        this.appropriatenessTable.getModel().addTableModelListener(this);
    }

    public void fillSentencePlanTable() {
        String[] columnNames = new String[]{"User Type", "Appropriateness"};
        Object[][] data = new Object[NaturalOWLTab.UMQM.getUserModels().size() - 1][2];
        int row = 0;
        for (IRI UMIRI : NaturalOWLTab.UMQM.getUserModels()) {
            if (UMIRI.equals((Object)NLResourceManager.globalUserModel.getIRI())) continue;
            data[row][0] = new ListIRI(UMIRI);
            data[row][1] = NaturalOWLTab.UMQM.getSentencePlanAppropriateness(this.resourceEntry, UMIRI);
            ++row;
        }
        this.appropriatenessTable = new JTable(new AppropriatenessTableModel(data, columnNames));
        TableColumn column = null;
        int i = 0;
        while (i < this.appropriatenessTable.getColumnCount()) {
            column = this.appropriatenessTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(25);
            ++i;
        }
        this.appropriatenessTable.getTableHeader().setReorderingAllowed(false);
        this.appropriatenessTable.setCellSelectionEnabled(true);
        this.appropriatenessTable.getModel().addTableModelListener(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = e.getFirstRow();
        int column = e.getColumn();
        TableModel model = (TableModel)e.getSource();
        String columnName = model.getColumnName(column);
        if (columnName.equals("Appropriateness")) {
            ListIRI userTypeIRI = (ListIRI)model.getValueAt(row, 0);
            String number = "" + model.getValueAt(row, column);
            int oldNumber = 1;
            if (this.tab instanceof NLNamesTab) {
                oldNumber = NaturalOWLTab.UMQM.getNLNameAppropriateness(this.resourceEntry, userTypeIRI.getEntryIRI());
            } else if (this.tab instanceof SentencePlanTab) {
                oldNumber = NaturalOWLTab.UMQM.getSentencePlanAppropriateness(this.resourceEntry, userTypeIRI.getEntryIRI());
            }
            try {
                int newNumber = Integer.parseInt(number);
                if (newNumber != oldNumber) {
                    if (this.tab instanceof NLNamesTab) {
                        NaturalOWLTab.UMQM.setNLNameAppropriateness(this.resourceEntry, userTypeIRI.getEntryIRI(), newNumber);
                    } else if (this.tab instanceof SentencePlanTab) {
                        NaturalOWLTab.UMQM.setSentencePlanAppropriateness(this.resourceEntry, userTypeIRI.getEntryIRI(), newNumber);
                    }
                    this.tab.dirtenOntologies();
                }
            }
            catch (NumberFormatException nfe) {
                model.setValueAt(oldNumber, row, column);
            }
        }
    }
}

