/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLGEngine;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjective;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerb;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbGR;
import gr.aueb.cs.nlg.NLFiles.LexiconQueryManager;
import gr.aueb.cs.nlg.NLFiles.MappingQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNArticleSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLNStringSlot;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLNameQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.OrderingQueryManager;
import gr.aueb.cs.nlg.NLGEngine.AnnotatedDescription;
import gr.aueb.cs.nlg.NLGEngine.EnglishArticles;
import gr.aueb.cs.nlg.NLGEngine.GreekArticles;
import gr.aueb.cs.nlg.NLGEngine.NLGEngine;
import gr.aueb.cs.nlg.NLGEngine.NLGEngineComponent;
import gr.aueb.cs.nlg.Utils.NLGUser;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SurfaceRealization
extends NLGEngineComponent {
    private AnnotatedDescription annotatedDescription = new AnnotatedDescription();
    private StringBuffer realizedText;
    private NLNameQueryManager NLNQM;
    private LexiconQueryManager LQM;
    private OrderingQueryManager OQM;
    private MappingQueryManager MQM;
    private Set<OWLOntology> mainModels;
    private NLGUser user;
    private boolean sectionParagraphs = false;
    private boolean generateReferringExpressions;
    private boolean annotateGeneratedResources;
    private static boolean first;
    public static String PROD_RE_BAD;
    public static String PROD_RE_NP;
    public static String PROD_RE_Pronoun;
    public static String PROD_RE_Demonstrative;
    public static String PROD_RE_Article;
    public static String PROD_RE_NULL;
    private HashMap<IRI, IRI> generatedSuperNames;

    static {
        PROD_RE_BAD = "BAD_RE";
        PROD_RE_NP = "NP";
        PROD_RE_Pronoun = "Pronoun";
        PROD_RE_Demonstrative = "Demonstrative";
        PROD_RE_Article = "Article";
        PROD_RE_NULL = "NullSubject";
    }

    SurfaceRealization(Set<OWLOntology> ontModels, NLNameQueryManager NLNQM, LexiconQueryManager LQM, MappingQueryManager MQM, OrderingQueryManager OQM, String language) {
        super(language);
        this.NLNQM = NLNQM;
        this.LQM = LQM;
        this.MQM = MQM;
        this.OQM = OQM;
        this.mainModels = ontModels;
        this.generateReferringExpressions = true;
        this.generatedSuperNames = new HashMap();
    }

    public void setModel(Set<OWLOntology> m) {
        this.mainModels = m;
    }

    public String realizeMessages(XmlMsgs messages, NLGUser user) {
        this.annotatedDescription.generateAnnotatedDescription();
        this.annotatedDescription.setEntityId(messages.getOwner());
        this.user = user;
        this.realizedText = new StringBuffer();
        ArrayList<Node> messageNodes = messages.getMessages();
        String section = "";
        boolean isFirstMessage = true;
        int i = 0;
        while (i < messageNodes.size()) {
            first = true;
            ArrayList<Node> messageSlots = XmlMsgs.returnChildNodes(messageNodes.get(i));
            if (this.sectionParagraphs && !XmlMsgs.getAttribute(messageNodes.get(i), XmlMsgs.prefix, "sectionName").equals(section) && !(section = XmlMsgs.getAttribute(messageNodes.get(i), XmlMsgs.prefix, "sectionName")).isEmpty()) {
                IRI currentSectionIRI = null;
                for (IRI sectionIRI : this.OQM.getOrderedSections()) {
                    if (!sectionIRI.getFragment().equals(section)) continue;
                    currentSectionIRI = sectionIRI;
                }
                if (currentSectionIRI != null) {
                    String name;
                    if (!isFirstMessage) {
                        this.realizedText.append("<br><br>");
                    }
                    if ((name = this.OQM.getSectionLabel(currentSectionIRI, this.getLanguage())).isEmpty()) {
                        name = this.capitalize(DefaultResourcesManager.spaceString(currentSectionIRI.getFragment(), false));
                    }
                    this.realizedText.append("<u><b>").append(name).append("</u></b><br><br>");
                    first = true;
                }
            }
            if (messageSlots.size() > 0) {
                if (XmlMsgs.getAttribute(messageNodes.get(i), XmlMsgs.prefix, "sentencePlan").startsWith(NLResourceManager.nlowlNS) && !DefaultResourcesManager.isDefaultResource(IRI.create((String)XmlMsgs.getAttribute(messageNodes.get(i), XmlMsgs.prefix, "sentencePlan"))) && this.annotateGeneratedResources) {
                    this.realizedText.append("<font color=\"#580000\"><b>");
                }
                this.realizeMessageSlots(this.realizedText, messageSlots);
                if (XmlMsgs.getAttribute(messageNodes.get(i), XmlMsgs.prefix, "sentencePlan").startsWith(NLResourceManager.nlowlNS) && !DefaultResourcesManager.isDefaultResource(IRI.create((String)XmlMsgs.getAttribute(messageNodes.get(i), XmlMsgs.prefix, "sentencePlan"))) && this.annotateGeneratedResources) {
                    this.realizedText.append("</b></font>");
                }
                first = false;
                isFirstMessage = false;
            }
            ++i;
        }
        String ret = this.realizedText.toString();
        ret = ret.replaceAll(" is not ", " isn't ");
        ret = ret.replaceAll(" are not ", " aren't ");
        ret = ret.replaceAll(" has not ", " hasn't ");
        ret = ret.replaceAll(" have not ", " haven't ");
        ret = ret.replaceAll(" do not ", " don't ");
        ret = ret.replaceAll(" does not ", " doesn't ");
        ret = ret.replaceAll(" did not ", " didn't ");
        ret = ret.replaceAll(" can not ", " cannot ");
        ret = ret.replaceAll(" exactly 1 ", " exactly one ");
        ret = ret.replaceAll(" exactly 2 ", " exactly two ");
        ret = ret.replaceAll(" exactly 3 ", " exactly three ");
        ret = ret.replaceAll(" exactly 4 ", " exactly four ");
        ret = ret.replaceAll(" exactly 5 ", " exactly five ");
        ret = ret.replaceAll(" exactly 6 ", " exactly six ");
        ret = ret.replaceAll(" exactly 7 ", " exactly seven ");
        ret = ret.replaceAll(" exactly 8 ", " exactly eight ");
        ret = ret.replaceAll(" exactly 9 ", " exactly nine ");
        ret = ret.replaceAll(" at most 1 ", " at most one ");
        ret = ret.replaceAll(" at most 2 ", " at most two ");
        ret = ret.replaceAll(" at most 3 ", " at most three ");
        ret = ret.replaceAll(" at most 4 ", " at most four ");
        ret = ret.replaceAll(" at most 5 ", " at most five ");
        ret = ret.replaceAll(" at most 6 ", " at most six ");
        ret = ret.replaceAll(" at most 7 ", " at most seven ");
        ret = ret.replaceAll(" at most 8 ", " at most eight ");
        ret = ret.replaceAll(" at most 9 ", " at most nine ");
        ret = ret.replaceAll(" at least 1 ", " at least one ");
        ret = ret.replaceAll(" at least 2 ", " at least two ");
        ret = ret.replaceAll(" at least 3 ", " at least three ");
        ret = ret.replaceAll(" at least 4 ", " at least four ");
        ret = ret.replaceAll(" at least 5 ", " at least five ");
        ret = ret.replaceAll(" at least 6 ", " at least six ");
        ret = ret.replaceAll(" at least 7 ", " at least seven ");
        ret = ret.replaceAll(" at least 8 ", " at least eight ");
        ret = ret.replaceAll(" at least 9 ", " at least nine ");
        ret = ret.replaceAll(" only 1 ", " only one ");
        ret = ret.replaceAll(" only 2 ", " only two ");
        ret = ret.replaceAll(" only 3 ", " only three ");
        ret = ret.replaceAll(" only 4 ", " only four ");
        ret = ret.replaceAll(" only 5 ", " only five ");
        ret = ret.replaceAll(" only 6 ", " only six ");
        ret = ret.replaceAll(" only 7 ", " only seven ");
        ret = ret.replaceAll(" only 8 ", " only eight ");
        ret = ret.replaceAll(" only 9 ", " only nine ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03bf ", " \u03c3\u03c4\u03bf ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03bf\u03bd ", " \u03c3\u03c4\u03bf\u03bd ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03b7 ", " \u03c3\u03c4\u03b7 ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03b7\u03bd ", " \u03c3\u03c4\u03b7\u03bd ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03b1 ", " \u03c3\u03c4\u03b1 ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03bf\u03c5\u03c2 ", " \u03c3\u03c4\u03bf\u03c5\u03c2 ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03b9\u03c2 ", " \u03c3\u03c4\u03b9\u03c2 ");
        ret = ret.replaceAll(" \u03c3\u03b5 \u03c4\u03c9\u03bd ", " \u03c3\u03c4\u03c9\u03bd ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 1 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03ad\u03bd\u03b1 ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 2 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03b4\u03cd\u03bf ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 3 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03c4\u03c1\u03af\u03b1 ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 4 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1 ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 5 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03c0\u03ad\u03bd\u03c4\u03b5 ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 6 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03ad\u03be\u03b9 ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 7 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03b5\u03c0\u03c4\u03ac ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 8 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03bf\u03c7\u03c4\u03ce ");
        ret = ret.replaceAll(" \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 9 ", " \u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 \u03b5\u03bd\u03bd\u03b9\u03ac ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 1 ", " \u03bc\u03cc\u03bd\u03bf \u03ad\u03bd\u03b1 ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 2 ", " \u03bc\u03cc\u03bd\u03bf \u03b4\u03cd\u03bf ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 3 ", " \u03bc\u03cc\u03bd\u03bf \u03c4\u03c1\u03af\u03b1 ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 4 ", " \u03bc\u03cc\u03bd\u03bf \u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1 ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 5 ", " \u03bc\u03cc\u03bd\u03bf \u03c0\u03ad\u03bd\u03c4\u03b5 ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 6 ", " \u03bc\u03cc\u03bd\u03bf \u03ad\u03be\u03b9 ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 7 ", " \u03bc\u03cc\u03bd\u03bf \u03b5\u03c0\u03c4\u03ac ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 8 ", " \u03bc\u03cc\u03bd\u03bf \u03bf\u03c7\u03c4\u03ce ");
        ret = ret.replaceAll(" \u03bc\u03cc\u03bd\u03bf 9 ", " \u03bc\u03cc\u03bd\u03bf \u03b5\u03bd\u03bd\u03b9\u03ac ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 1 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03ad\u03bd\u03b1 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 2 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03b4\u03cd\u03bf ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 3 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03c4\u03c1\u03af\u03b1 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 4 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 5 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03c0\u03ad\u03bd\u03c4\u03b5 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 6 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03ad\u03be\u03b9 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 7 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03b5\u03c0\u03c4\u03ac ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 8 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03bf\u03c7\u03c4\u03ce ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf 9 ", " \u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf \u03b5\u03bd\u03bd\u03b9\u03ac ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 1 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03ad\u03bd\u03b1 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 2 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03b4\u03cd\u03bf ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 3 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03c4\u03c1\u03af\u03b1 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 4 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03c4\u03ad\u03c3\u03c3\u03b5\u03c1\u03b1 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 5 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03c0\u03ad\u03bd\u03c4\u03b5 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 6 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03ad\u03be\u03b9 ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 7 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03b5\u03c0\u03c4\u03ac ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 8 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03bf\u03c7\u03c4\u03ce ");
        ret = ret.replaceAll(" \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 9 ", " \u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf \u03b5\u03bd\u03bd\u03b9\u03ac ");
        ret = ret.replaceAll(" ;", ";");
        ret = ret.replaceAll(" ,", ",");
        ret = ret.replaceAll(" :", ":");
        ret = ret.replaceAll(" ''", "''");
        ret = ret.replaceAll("[(] ", "(");
        ret = ret.replaceAll(" [)]", ")");
        return ret;
    }

    private void realizeMessageSlots(StringBuffer REALIZED_TEXT, ArrayList<Node> messageSlots) {
        try {
            boolean firstFiller = true;
            int j = 0;
            while (j < messageSlots.size()) {
                NLName name;
                Node pre_Slot;
                Node pre_Slot2;
                IRI NLNameIRI;
                IRI fillerIRI;
                String ret;
                String ret2;
                String realizedName;
                String ret3;
                String agreeWith;
                String ret4;
                IRI lexiconEntryIRI;
                Node slot = messageSlots.get(j);
                if (XmlMsgs.compare(slot, XmlMsgs.prefix, "verb")) {
                    lexiconEntryIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "lexiconEntryIRI"));
                    String voice = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "voice");
                    String tense = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "tense");
                    String agreeWith2 = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "agree");
                    String number = "singular";
                    String person = "3rd";
                    if (agreeWith2.isEmpty()) {
                        number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                        person = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "person");
                    } else {
                        int k;
                        String recursiveAgreeWith = agreeWith2;
                        while (!recursiveAgreeWith.isEmpty()) {
                            k = 0;
                            while (k < messageSlots.size()) {
                                if (XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "ID").equals(recursiveAgreeWith) && !(recursiveAgreeWith = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "agree")).isEmpty()) {
                                    agreeWith2 = recursiveAgreeWith;
                                }
                                ++k;
                            }
                        }
                        k = 0;
                        while (k < messageSlots.size()) {
                            if (XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "ID").equals(agreeWith2)) {
                                if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "adjective") || XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "noun")) {
                                    String restriction;
                                    number = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "number");
                                    person = "3rd";
                                    if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "noun") && !(restriction = this.LQM.getNounEntry(IRI.create((String)XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "lexiconEntryIRI")), this.getLanguage()).getNumber()).equals("both")) {
                                        if (restriction.equals("singular")) {
                                            number = "singular";
                                        } else if (restriction.equals("plural")) {
                                            number = "plural";
                                        }
                                    }
                                } else if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "comparator") || XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "comparatorFiller")) {
                                    number = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "number");
                                } else {
                                    NLNSlot nameSlot;
                                    String name2 = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "NLName");
                                    if (name2.startsWith("anonymous(")) {
                                        name2 = name2.substring(10, name2.length() - 1);
                                    }
                                    if ((nameSlot = this.NLNQM.getNLName(IRI.create((String)name2)).getHeadSlot()) instanceof NLNNounSlot) {
                                        number = ((NLNNounSlot)nameSlot).getNumber();
                                    } else if (nameSlot instanceof NLNAdjectiveSlot) {
                                        number = ((NLNAdjectiveSlot)nameSlot).getNumber();
                                    }
                                }
                            }
                            ++k;
                        }
                        person = "3rd";
                    }
                    boolean polarity = true;
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "polarity").equals("false")) {
                        polarity = false;
                    }
                    boolean useAuxiliaryVerb = true;
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "useAuxiliaryVerb").equals("false")) {
                        useAuxiliaryVerb = false;
                    }
                    ret4 = this.realizeVerb(lexiconEntryIRI, tense, voice, number, person, polarity, useAuxiliaryVerb);
                    this.annotatedDescription.addVerb(ret4.trim(), this.getForProperty(slot), this.getInterest(slot), this.getAssimilation(slot));
                    this.addText(ret4.trim());
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "adjective")) {
                    lexiconEntryIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "lexiconEntryIRI"));
                    agreeWith = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "agree");
                    String number = "singular";
                    String caseType = "nominative";
                    String gender = "masculineOrFeminine";
                    if (agreeWith.isEmpty()) {
                        number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                        if (Languages.isGreek(this.getLanguage())) {
                            caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                            gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                        }
                    } else {
                        String recursiveAgreeWith = agreeWith;
                        while (!recursiveAgreeWith.isEmpty()) {
                            int k = 0;
                            while (k < messageSlots.size()) {
                                if (XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "ID").equals(recursiveAgreeWith) && !(recursiveAgreeWith = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "agree")).isEmpty()) {
                                    agreeWith = recursiveAgreeWith;
                                }
                                ++k;
                            }
                        }
                        int k = 0;
                        while (k < messageSlots.size()) {
                            if (XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "ID").equals(agreeWith)) {
                                if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "adjective") || XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "noun")) {
                                    caseType = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "case");
                                    gender = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "gender");
                                } else if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "comparator") || XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "comparatorFiller")) {
                                    number = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "number");
                                } else {
                                    NLNSlot nameSlot;
                                    String name3 = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "NLName");
                                    if (name3.startsWith("anonymous(")) {
                                        name3 = name3.substring(10, name3.length() - 1);
                                    }
                                    if ((nameSlot = this.NLNQM.getNLName(IRI.create((String)name3)).getHeadSlot()) instanceof NLNNounSlot) {
                                        number = ((NLNNounSlot)nameSlot).getNumber();
                                        if (Languages.isGreek(this.getLanguage())) {
                                            caseType = ((NLNNounSlot)nameSlot).getCase();
                                            gender = ((LexEntryNounGR)this.LQM.getNounEntry(((NLNNounSlot)nameSlot).getLexiconEntryIRI(), this.getLanguage())).getGender();
                                        }
                                    } else if (nameSlot instanceof NLNAdjectiveSlot) {
                                        number = ((NLNAdjectiveSlot)nameSlot).getNumber();
                                        if (Languages.isGreek(this.getLanguage())) {
                                            caseType = ((NLNAdjectiveSlot)nameSlot).getCase();
                                            gender = ((NLNAdjectiveSlot)nameSlot).getGender();
                                        }
                                    }
                                }
                            }
                            ++k;
                        }
                    }
                    if (Languages.isEnglish(this.getLanguage())) {
                        LexEntryAdjectiveEN adjectiveEntry = (LexEntryAdjectiveEN)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                        this.addText(adjectiveEntry.get_form());
                    } else if (Languages.isGreek(this.getLanguage())) {
                        LexEntryAdjectiveGR adjectiveEntry = (LexEntryAdjectiveGR)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                        this.addText(adjectiveEntry.get(gender, number, caseType));
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "noun")) {
                    String restriction;
                    lexiconEntryIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "lexiconEntryIRI"));
                    agreeWith = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "agree");
                    String number = "singular";
                    String caseType = "nominative";
                    if (agreeWith.isEmpty()) {
                        number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                        if (Languages.isGreek(this.getLanguage())) {
                            caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                        }
                    } else {
                        String recursiveAgreeWith = agreeWith;
                        while (!recursiveAgreeWith.isEmpty()) {
                            int k = 0;
                            while (k < messageSlots.size()) {
                                if (XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "ID").equals(recursiveAgreeWith) && !(recursiveAgreeWith = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "agree")).isEmpty()) {
                                    agreeWith = recursiveAgreeWith;
                                }
                                ++k;
                            }
                        }
                        int k = 0;
                        while (k < messageSlots.size()) {
                            if (XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "ID").equals(agreeWith)) {
                                if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "noun") || XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "noun")) {
                                    String restriction2;
                                    number = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "number");
                                    caseType = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "case");
                                    if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "noun") && !(restriction2 = this.LQM.getNounEntry(IRI.create((String)XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "lexiconEntryIRI")), this.getLanguage()).getNumber()).equals("both")) {
                                        if (restriction2.equals("singular")) {
                                            number = "singular";
                                        } else if (restriction2.equals("plural")) {
                                            number = "plural";
                                        }
                                    }
                                } else if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "comparator") || XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "comparatorFiller")) {
                                    number = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "number");
                                } else {
                                    NLNSlot nameSlot;
                                    String name4 = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "NLName");
                                    if (name4.startsWith("anonymous(")) {
                                        name4 = name4.substring(10, name4.length() - 1);
                                    }
                                    if ((nameSlot = this.NLNQM.getNLName(IRI.create((String)name4)).getHeadSlot()) instanceof NLNNounSlot) {
                                        number = ((NLNNounSlot)nameSlot).getNumber();
                                        if (Languages.isGreek(this.getLanguage())) {
                                            caseType = ((NLNNounSlot)nameSlot).getCase();
                                        }
                                    } else if (nameSlot instanceof NLNAdjectiveSlot) {
                                        number = ((NLNAdjectiveSlot)nameSlot).getNumber();
                                        if (Languages.isGreek(this.getLanguage())) {
                                            caseType = ((NLNAdjectiveSlot)nameSlot).getCase();
                                        }
                                    }
                                }
                            }
                            ++k;
                        }
                    }
                    if (!(restriction = this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage()).getNumber()).equals("both")) {
                        if (restriction.equals("singular")) {
                            number = "singular";
                        } else if (restriction.equals("plural")) {
                            number = "plural";
                        }
                    }
                    if (Languages.isEnglish(this.getLanguage())) {
                        LexEntryNounEN nounEntry = (LexEntryNounEN)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                        this.addText(nounEntry.get("", number));
                    } else if (Languages.isGreek(this.getLanguage())) {
                        LexEntryNounGR nounEntry = (LexEntryNounGR)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                        this.addText(nounEntry.get(caseType, number));
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "text") || XmlMsgs.compare(slot, XmlMsgs.prefix, "preposition")) {
                    if (XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "sentencePlan").startsWith(NLResourceManager.nlowlNS) && !DefaultResourcesManager.isDefaultResource(IRI.create((String)XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "sentencePlan"))) && XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "polarity").equals("false")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            this.addText("not");
                        } else {
                            this.addText("\u03b4\u03b5\u03bd");
                        }
                    }
                    if (slot.getTextContent().compareTo("\u03c3\u03b5") != 0) {
                        ret3 = slot.getTextContent();
                        this.annotatedDescription.addText(ret3, this.getForProperty(slot), this.getRERole(slot), this.getRef(slot), this.getInterest(slot), this.getAssimilation(slot), this.getPrep(slot));
                        this.addText(ret3);
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "isA")) {
                    if (Languages.isEnglish(this.getLanguage())) {
                        ret3 = "is";
                        this.annotatedDescription.addVerb(ret3, this.getForProperty(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret3);
                    } else if (Languages.isGreek(this.getLanguage())) {
                        ret3 = "\u03b5\u03af\u03bd\u03b1\u03b9";
                        this.annotatedDescription.addVerb(ret3, this.getForProperty(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret3);
                    }
                } else if (XmlMsgs.compare(slot, "", "COMMA")) {
                    REALIZED_TEXT.deleteCharAt(REALIZED_TEXT.length() - 1);
                    REALIZED_TEXT.append(", ");
                    this.annotatedDescription.addText(",");
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "owner")) {
                    IRI ownerIRI = IRI.create((String)XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "ref"));
                    String caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                    String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                    String number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                    String refType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_TYPE");
                    String nameStr = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "NLName");
                    if (nameStr.startsWith("anonymous(")) {
                        this.setProducedRE(slot, PROD_RE_NP);
                        String ret5 = this.generateRefExpressionForAnonEntity(slot, IRI.create((String)nameStr.substring(10, nameStr.length() - 1)), gender, number, caseType);
                        this.annotatedDescription.addRE(ret5, ownerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret5);
                    } else {
                        IRI NLNameIRI2 = IRI.create((String)nameStr);
                        this.annotatedDescription.setStringCompEntities(ownerIRI.toString());
                        NLName name5 = this.NLNQM.getNLName(NLNameIRI2);
                        IRI superNLName = null;
                        if (name5.isGenerated() && (superNLName = this.getSuperNLName(ownerIRI, this.user)) != null) {
                            NLNSlot superHeadSlot = this.NLNQM.getNLName(superNLName).getHeadSlot();
                            if (superHeadSlot instanceof NLNAdjectiveSlot) {
                                refType = "auto";
                                gender = ((NLNAdjectiveSlot)superHeadSlot).getGender();
                                number = ((NLNAdjectiveSlot)superHeadSlot).getNumber();
                            } else if (superHeadSlot instanceof NLNNounSlot) {
                                refType = "auto";
                                gender = this.LQM.getNounEntry(((NLNNounSlot)superHeadSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                number = ((NLNNounSlot)superHeadSlot).getNumber();
                            }
                        }
                        if (name5.isGenerated() && this.annotateGeneratedResources) {
                            this.addText("<font color=\"#00FF00\"><b>");
                        }
                        if (name5.isGenerated() && superNLName == null) {
                            this.setProducedRE(slot, PROD_RE_NP);
                            realizedName = this.realizeNLName(name5, caseType, number, gender, 0);
                            this.annotatedDescription.addRE(realizedName, ownerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                            this.addText(realizedName);
                        } else if (!this.generateReferringExpressions) {
                            this.setProducedRE(slot, PROD_RE_NP);
                            realizedName = this.realizeNLName(name5, caseType, number, gender, 0);
                            this.annotatedDescription.addRE(realizedName, ownerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                            this.addText(realizedName);
                        } else if (!refType.equals("auto")) {
                            if (this.getLanguage().equals("en")) {
                                realizedName = this.realizeNLName(name5, caseType, number, gender, 0);
                                this.setProducedRE(slot, PROD_RE_NP);
                                ret2 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName);
                                this.annotatedDescription.addRE(ret2, ownerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret2);
                            } else if (this.getLanguage().equals("el")) {
                                realizedName = this.realizeNLName(name5, caseType, number, gender, 0);
                                this.setProducedRE(slot, PROD_RE_NP);
                                ret2 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName);
                                this.annotatedDescription.addRE(ret2, ownerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret2);
                            }
                        } else {
                            ret = this.autoGenerateRefExpression(name5, gender, number, slot);
                            this.setProducedRE(slot, PROD_RE_NP);
                            this.annotatedDescription.addRE(ret, ownerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                            this.addText(ret);
                        }
                        if (name5.isGenerated() && this.annotateGeneratedResources) {
                            this.addText("</b></font>");
                        }
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "filler")) {
                    fillerIRI = IRI.create((String)slot.getTextContent());
                    NLNameIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "NLName"));
                    String caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                    int articleUse = Integer.parseInt(XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "articleUse"));
                    ArrayList appendAdjectives = new ArrayList();
                    if (firstFiller) {
                        firstFiller = false;
                        if (!XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "countAppends").isEmpty()) {
                            int counter = Integer.parseInt(XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "countAppends"));
                            int c = 1;
                            while (c < counter) {
                                appendAdjectives.add(IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "appendAdjective" + c)));
                                if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "isConnective" + c).equals("false") && c + 1 < counter) {
                                    appendAdjectives.add(IRI.create((String)"||"));
                                }
                                ++c;
                            }
                        }
                    }
                    boolean useBullets = false;
                    if (j > 1 && XmlMsgs.compare(messageSlots.get(j - 2), XmlMsgs.prefix, "filler") && XmlMsgs.getAttribute(messageSlots.get(j - 2), XmlMsgs.prefix, "useBullets").equals("true") && XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "useBullets").equals("true")) {
                        this.addText("</li><li>");
                        useBullets = true;
                    }
                    if (j < messageSlots.size() - 2 && !useBullets && XmlMsgs.compare(messageSlots.get(j + 2), XmlMsgs.prefix, "filler") && XmlMsgs.getAttribute(messageSlots.get(j + 2), XmlMsgs.prefix, "useBullets").equals("true") && XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "useBullets").equals("true")) {
                        this.addText("<ul><li>");
                        useBullets = true;
                    }
                    if (NLNameIRI != null && !XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "NLName").trim().isEmpty()) {
                        String ret6;
                        String number;
                        if (Languages.isEnglish(this.getLanguage())) {
                            NLName name6 = this.NLNQM.getNLName(NLNameIRI);
                            if (name6 != null) {
                                String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                                number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                                realizedName = appendAdjectives.isEmpty() ? this.realizeNLName(name6, caseType, number, gender, articleUse) : this.realizeNLName(name6, caseType, number, gender, articleUse, appendAdjectives);
                                if (name6.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("<font color=\"#00FF00\"><b>");
                                }
                                if (realizedName.isEmpty()) {
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    ret2 = "NOT FOUND FILLER";
                                    this.annotatedDescription.addRE(ret2, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret2);
                                } else if (slot.getPreviousSibling() != null && XmlMsgs.compare(slot.getPreviousSibling(), XmlMsgs.prefix, "text") && slot.getPreviousSibling().getTextContent().compareTo(", a kind of") == 0) {
                                    this.addText(realizedName);
                                    this.setProducedRE(slot, PROD_RE_NP);
                                    this.annotatedDescription.addRE(realizedName, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                } else if (!this.isREAuto(slot)) {
                                    ret2 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName);
                                    this.annotatedDescription.addRE(ret2, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret2);
                                } else {
                                    Node pre_Slot22 = slot.getPreviousSibling();
                                    if (pre_Slot22 != null && XmlMsgs.compare(pre_Slot22, XmlMsgs.prefix, "isA")) {
                                        ret6 = realizedName;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret6);
                                    } else {
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(realizedName, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(realizedName);
                                    }
                                }
                                if (name6.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("</b></font>");
                                }
                            } else {
                                String ret7 = "[NOUN OR CANNED TEXT NOT FOUND]";
                                this.annotatedDescription.addCannedText(ret7, fillerIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret7);
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            NLName name7 = this.NLNQM.getNLName(NLNameIRI);
                            if (name7 != null) {
                                String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                                number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                                if (gender.isEmpty() || number.isEmpty()) {
                                    int k = 0;
                                    while (k < messageSlots.size()) {
                                        if (XmlMsgs.compare(messageSlots.get(k), XmlMsgs.prefix, "owner")) {
                                            if (gender.isEmpty()) {
                                                gender = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "gender");
                                            }
                                            if (number.isEmpty()) {
                                                number = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "number");
                                            }
                                            if (gender.isEmpty() || number.isEmpty()) {
                                                IRI ownerIRI = IRI.create((String)XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "ref"));
                                                String nameStr = XmlMsgs.getAttribute(messageSlots.get(k), XmlMsgs.prefix, "NLName");
                                                if (!nameStr.startsWith("anonymous(")) {
                                                    NLNSlot superHeadSlot;
                                                    IRI ownerNLNameIRI = IRI.create((String)nameStr);
                                                    NLName ownerName = this.NLNQM.getNLName(ownerNLNameIRI);
                                                    IRI superNLName = null;
                                                    if (ownerName.isGenerated()) {
                                                        superNLName = this.getSuperNLName(ownerIRI, this.user);
                                                        if (superNLName != null) {
                                                            superHeadSlot = this.NLNQM.getNLName(superNLName).getHeadSlot();
                                                            if (superHeadSlot instanceof NLNAdjectiveSlot) {
                                                                if (gender.isEmpty()) {
                                                                    gender = ((NLNAdjectiveSlot)superHeadSlot).getGender();
                                                                }
                                                                if (number.isEmpty()) {
                                                                    number = ((NLNAdjectiveSlot)superHeadSlot).getNumber();
                                                                }
                                                            } else if (superHeadSlot instanceof NLNNounSlot) {
                                                                if (gender.isEmpty()) {
                                                                    gender = this.LQM.getNounEntry(((NLNNounSlot)superHeadSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                                                }
                                                                if (number.isEmpty()) {
                                                                    number = ((NLNNounSlot)superHeadSlot).getNumber();
                                                                }
                                                            }
                                                        }
                                                    } else {
                                                        superHeadSlot = this.NLNQM.getNLName(ownerNLNameIRI).getHeadSlot();
                                                        if (superHeadSlot instanceof NLNAdjectiveSlot) {
                                                            if (gender.isEmpty()) {
                                                                gender = ((NLNAdjectiveSlot)superHeadSlot).getGender();
                                                            }
                                                            if (number.isEmpty()) {
                                                                number = ((NLNAdjectiveSlot)superHeadSlot).getNumber();
                                                            }
                                                        } else if (superHeadSlot instanceof NLNNounSlot) {
                                                            if (gender.isEmpty()) {
                                                                gender = this.LQM.getNounEntry(((NLNNounSlot)superHeadSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                                            }
                                                            if (number.isEmpty()) {
                                                                number = ((NLNNounSlot)superHeadSlot).getNumber();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        ++k;
                                    }
                                }
                                realizedName = appendAdjectives.isEmpty() ? this.realizeNLName(name7, caseType, number, gender, articleUse) : this.realizeNLName(name7, caseType, number, gender, articleUse, appendAdjectives);
                                if (name7.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("<font color=\"#00FF00\"><b>");
                                }
                                if (realizedName.compareTo("") == 0) {
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    ret2 = "NOT FOUND FILLER";
                                    this.annotatedDescription.addRE(ret2, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret2);
                                } else if (!this.generateReferringExpressions) {
                                    ret2 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName);
                                    this.addText(ret2);
                                    this.annotatedDescription.addRE(ret2, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                } else {
                                    Node pre_Slot3 = slot.getPreviousSibling();
                                    if (pre_Slot3 != null) {
                                        if (XmlMsgs.compare(pre_Slot3, XmlMsgs.prefix, "isA")) {
                                            if (gender.compareTo("masculine") == 0) {
                                                ret6 = "\u03ad\u03bd\u03b1\u03c2 " + realizedName;
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret6);
                                            } else if (gender.compareTo("feminine") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret6 = "\u03bc\u03af\u03b1 " + realizedName;
                                                this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret6);
                                            } else if (gender.compareTo("neuter") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret6 = "\u03ad\u03bd\u03b1 " + realizedName;
                                                this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret6);
                                            } else if (gender.compareTo("masculineOrFeminine") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret6 = "\u03ad\u03bd\u03b1\u03c2/\u03bc\u03af\u03b1 " + realizedName;
                                                this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret6);
                                            }
                                        } else if (!this.isREAuto(slot)) {
                                            ret6 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName);
                                            this.addText(ret6);
                                            this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        } else if (slot.getPreviousSibling().getTextContent().compareTo("\u03c3\u03b5") == 0) {
                                            ret6 = "\u03c3\u03b5 " + realizedName;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret6);
                                        } else {
                                            ret6 = realizedName;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret6);
                                        }
                                    } else {
                                        ret6 = realizedName;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret6, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret6);
                                    }
                                }
                                if (name7.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("</b></font>");
                                }
                            } else {
                                String ret8 = "[NOUN OR CANNED TEXT NOT FOUND]";
                                this.setProducedRE(slot, PROD_RE_BAD);
                                this.annotatedDescription.addCannedText(ret8, fillerIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret8);
                            }
                        }
                    } else if (slot.getTextContent().indexOf("^^http://") > 0) {
                        String text;
                        String ret9 = text = slot.getTextContent().substring(0, slot.getTextContent().indexOf("^^http://"));
                        this.annotatedDescription.addRE(ret9, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret9);
                    } else {
                        String text;
                        String ret10 = text = slot.getTextContent();
                        this.annotatedDescription.addRE(ret10, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret10);
                    }
                    if (useBullets) {
                        if (j == messageSlots.size() - 1) {
                            this.addText("</li></ul>");
                        } else if (!(j >= messageSlots.size() - 2 || XmlMsgs.compare(messageSlots.get(j + 2), XmlMsgs.prefix, "filler") && XmlMsgs.getAttribute(messageSlots.get(j + 2), XmlMsgs.prefix, "useBullets").equals("true") && XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "useBullets").equals("true"))) {
                            this.addText("</li></ul>");
                        }
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "AGGREGATE_NLNAME")) {
                    fillerIRI = IRI.create((String)slot.getTextContent());
                    ArrayList<NLName> NLNames = new ArrayList<NLName>();
                    boolean useBullets = true;
                    for (Node filler : XmlMsgs.returnChildNodes(slot)) {
                        if (!XmlMsgs.compare(filler, XmlMsgs.prefix, "filler")) continue;
                        IRI NLNameIRI3 = IRI.create((String)XmlMsgs.getAttribute(filler, XmlMsgs.prefix, "NLName"));
                        NLName name8 = this.NLNQM.getNLName(NLNameIRI3);
                        if (!XmlMsgs.getAttribute(filler, XmlMsgs.prefix, "useBullets").equals("true")) {
                            useBullets = false;
                        }
                        if (name8 == null) continue;
                        NLNames.add(name8);
                    }
                    boolean isConnective = true;
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "isConnective").equals("false")) {
                        isConnective = false;
                    }
                    String caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                    if (Languages.isEnglish(this.getLanguage())) {
                        if (!NLNames.isEmpty()) {
                            String realizedName2;
                            String gender = "masculineOrFeminine";
                            String number = "singular";
                            if (!XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number").isEmpty()) {
                                number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                            }
                            if (((NLName)NLNames.get(0)).getHeadSlot() != null) {
                                NLNSlot head = ((NLName)NLNames.get(0)).getHeadSlot();
                                if (head instanceof NLNNounSlot) {
                                    gender = this.LQM.getNounEntry(((NLNNounSlot)head).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                    if (number.isEmpty()) {
                                        number = ((NLNNounSlot)head).getNumber();
                                    }
                                } else if (head instanceof NLNAdjectiveSlot) {
                                    gender = ((NLNAdjectiveSlot)head).getGender();
                                    if (number.isEmpty()) {
                                        number = ((NLNAdjectiveSlot)head).getNumber();
                                    }
                                }
                            }
                            if ((realizedName2 = this.aggregateNLNameAdjectives(NLNames, caseType, number, isConnective, useBullets)).isEmpty()) {
                                this.setProducedRE(slot, PROD_RE_BAD);
                                ret4 = "NOT FOUND FILLER";
                                this.annotatedDescription.addRE(ret4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret4);
                            } else if (slot.getPreviousSibling() != null && XmlMsgs.compare(slot.getPreviousSibling(), XmlMsgs.prefix, "text") && slot.getPreviousSibling().getTextContent().compareTo(", a kind of") == 0) {
                                this.addText(realizedName2);
                                this.setProducedRE(slot, PROD_RE_NP);
                                this.annotatedDescription.addRE(realizedName2, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                            } else if (!this.isREAuto(slot)) {
                                ret4 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName2);
                                this.annotatedDescription.addRE(ret4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret4);
                            } else {
                                pre_Slot2 = slot.getPreviousSibling();
                                if (pre_Slot2 != null && XmlMsgs.compare(pre_Slot2, XmlMsgs.prefix, "isA")) {
                                    ret = realizedName2;
                                    this.setProducedRE(slot, PROD_RE_NP);
                                    this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret);
                                } else {
                                    this.setProducedRE(slot, PROD_RE_NP);
                                    this.annotatedDescription.addRE(realizedName2, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(realizedName2);
                                }
                            }
                        }
                    } else if (Languages.isGreek(this.getLanguage())) {
                        if (!NLNames.isEmpty()) {
                            String realizedName3;
                            String gender = "masculineOrFeminine";
                            String number = "singular";
                            if (((NLName)NLNames.get(0)).getHeadSlot() != null) {
                                NLNSlot head = ((NLName)NLNames.get(0)).getHeadSlot();
                                if (head instanceof NLNNounSlot) {
                                    gender = this.LQM.getNounEntry(((NLNNounSlot)head).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                    number = ((NLNNounSlot)head).getNumber();
                                } else if (head instanceof NLNAdjectiveSlot) {
                                    gender = ((NLNAdjectiveSlot)head).getGender();
                                    number = ((NLNAdjectiveSlot)head).getNumber();
                                }
                            }
                            if ((realizedName3 = this.aggregateNLNameAdjectives(NLNames, caseType, number, isConnective, useBullets)).compareTo("") == 0) {
                                this.setProducedRE(slot, PROD_RE_BAD);
                                ret4 = "NOT FOUND FILLER";
                                this.setProducedRE(slot, PROD_RE_BAD);
                                this.annotatedDescription.addRE(ret4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret4);
                            } else {
                                pre_Slot = slot.getPreviousSibling();
                                if (pre_Slot != null) {
                                    if (XmlMsgs.compare(pre_Slot, XmlMsgs.prefix, "isA")) {
                                        if (gender.compareTo("masculine") == 0) {
                                            ret = "\u03ad\u03bd\u03b1\u03c2 " + realizedName3;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        } else if (gender.compareTo("feminine") == 0) {
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            ret = "\u03bc\u03af\u03b1 " + realizedName3;
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        } else if (gender.compareTo("neuter") == 0) {
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            ret = "\u03ad\u03bd\u03b1 " + realizedName3;
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        } else if (gender.compareTo("masculineOrFeminine") == 0) {
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            ret = "\u03ad\u03bd\u03b1\u03c2/\u03bc\u03af\u03b1 " + realizedName3;
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        }
                                    } else if (!this.isREAuto(slot)) {
                                        ret = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName3);
                                        this.addText(ret);
                                        this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    } else if (slot.getPreviousSibling().getTextContent().compareTo("\u03c3\u03b5") == 0) {
                                        ret = "\u03c3\u03b5 " + realizedName3;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret);
                                    } else {
                                        ret = realizedName3;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret);
                                    }
                                } else {
                                    ret = realizedName3;
                                    this.setProducedRE(slot, PROD_RE_NP);
                                    this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret);
                                }
                            }
                        } else {
                            String ret11 = "[NOUN OR CANNED TEXT NOT FOUND]";
                            this.setProducedRE(slot, PROD_RE_BAD);
                            this.annotatedDescription.addCannedText(ret11, fillerIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                            this.addText(ret11);
                        }
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "concatenation")) {
                    String text;
                    fillerIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "concatenateIndividual"));
                    NLNameIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "NLName"));
                    String caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                    int articleUse = Integer.parseInt(XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "articleUse"));
                    if (XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "prpType").equals("objPrp")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            name = this.NLNQM.getNLName(NLNameIRI);
                            if (name != null) {
                                String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                                String number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                                String realizedName4 = this.realizeNLName(name, caseType, number, gender, articleUse);
                                if (realizedName4.isEmpty()) {
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    ret4 = "NOT FOUND FILLER";
                                    this.annotatedDescription.addRE(ret4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret4);
                                } else if (slot.getPreviousSibling() != null && XmlMsgs.compare(slot.getPreviousSibling(), XmlMsgs.prefix, "text") && slot.getPreviousSibling().getTextContent().compareTo(", a kind of") == 0) {
                                    this.addText(realizedName4);
                                    this.setProducedRE(slot, PROD_RE_NP);
                                    this.annotatedDescription.addRE(realizedName4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                } else if (!this.isREAuto(slot)) {
                                    ret4 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName4);
                                    this.annotatedDescription.addRE(ret4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret4);
                                } else {
                                    pre_Slot2 = slot.getPreviousSibling();
                                    if (pre_Slot2 != null && XmlMsgs.compare(pre_Slot2, XmlMsgs.prefix, "isA")) {
                                        ret = realizedName4;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret);
                                    } else {
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(realizedName4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(realizedName4);
                                    }
                                }
                            } else {
                                String ret12 = "[NOUN OR CANNED TEXT NOT FOUND]";
                                this.annotatedDescription.addCannedText(ret12, fillerIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret12);
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            name = this.NLNQM.getNLName(NLNameIRI);
                            if (name != null) {
                                String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                                String number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                                String realizedName5 = this.realizeNLName(name, caseType, number, gender, articleUse);
                                if (realizedName5.compareTo("") == 0) {
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    ret4 = "NOT FOUND FILLER";
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    this.annotatedDescription.addRE(ret4, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret4);
                                } else {
                                    pre_Slot = slot.getPreviousSibling();
                                    if (pre_Slot != null) {
                                        if (XmlMsgs.compare(pre_Slot, XmlMsgs.prefix, "isA")) {
                                            if (gender.compareTo("masculine") == 0) {
                                                ret = "\u03ad\u03bd\u03b1\u03c2 " + realizedName5;
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            } else if (gender.compareTo("feminine") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret = "\u03bc\u03af\u03b1 " + realizedName5;
                                                this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            } else if (gender.compareTo("neuter") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret = "\u03ad\u03bd\u03b1 " + realizedName5;
                                                this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            } else if (gender.compareTo("masculineOrFeminine") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret = "\u03ad\u03bd\u03b1\u03c2/\u03bc\u03af\u03b1 " + realizedName5;
                                                this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            }
                                        } else if (!this.isREAuto(slot)) {
                                            ret = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName5);
                                            this.addText(ret);
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        } else if (slot.getPreviousSibling().getTextContent().compareTo("\u03c3\u03b5") == 0) {
                                            ret = "\u03c3\u03b5 " + realizedName5;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        } else {
                                            ret = realizedName5;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        }
                                    } else {
                                        ret = realizedName5;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret);
                                    }
                                }
                            } else {
                                String ret13 = "[NOUN OR CANNED TEXT NOT FOUND]";
                                this.setProducedRE(slot, PROD_RE_BAD);
                                this.annotatedDescription.addCannedText(ret13, fillerIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret13);
                            }
                        }
                    } else if (slot.getTextContent().indexOf("^^http://") > 0) {
                        String ret14 = text = slot.getTextContent().substring(0, slot.getTextContent().indexOf("^^http://"));
                        this.annotatedDescription.addRE(ret14, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret14);
                    } else {
                        String ret15 = text = slot.getTextContent();
                        this.annotatedDescription.addRE(ret15, fillerIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                        this.addText(ret15);
                    }
                } else if (XmlMsgs.compare(slot, XmlMsgs.prefix, "comparator") || XmlMsgs.compare(slot, XmlMsgs.prefix, "comparatorFiller")) {
                    IRI comparatorIRI = IRI.create((String)slot.getTextContent());
                    NLNameIRI = IRI.create((String)XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "NLName"));
                    String caseType = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
                    int articleUse = Integer.parseInt(XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "articleUse"));
                    if (NLNameIRI != null && !XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "NLName").trim().isEmpty()) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            name = this.NLNQM.getNLName(NLNameIRI);
                            if (name != null) {
                                String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                                String number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                                String realizedName6 = this.realizeNLName(name, caseType, number, gender, articleUse);
                                if (name.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("<font color=\"#00FF00\"><b>");
                                }
                                if (realizedName6.isEmpty()) {
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    ret4 = "NOT FOUND FILLER";
                                    this.annotatedDescription.addRE(ret4, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret4);
                                } else if (slot.getPreviousSibling() != null && XmlMsgs.compare(slot.getPreviousSibling(), XmlMsgs.prefix, "text") && slot.getPreviousSibling().getTextContent().compareTo(", a kind of") == 0) {
                                    this.addText(realizedName6);
                                    this.setProducedRE(slot, PROD_RE_NP);
                                    this.annotatedDescription.addRE(realizedName6, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                } else if (!this.isREAuto(slot)) {
                                    ret4 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName6);
                                    this.annotatedDescription.addRE(ret4, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret4);
                                } else {
                                    pre_Slot2 = slot.getPreviousSibling();
                                    if (pre_Slot2 != null && XmlMsgs.compare(pre_Slot2, XmlMsgs.prefix, "isA")) {
                                        ret = realizedName6;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret);
                                    } else {
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(realizedName6, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(realizedName6);
                                    }
                                }
                                if (name.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("</b></font>");
                                }
                            } else {
                                String ret16 = "[NOUN OR CANNED TEXT NOT FOUND]";
                                this.annotatedDescription.addCannedText(ret16, comparatorIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret16);
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            name = this.NLNQM.getNLName(NLNameIRI);
                            if (name != null) {
                                String gender = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "gender");
                                String number = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "number");
                                String realizedName7 = this.realizeNLName(name, caseType, number, gender, articleUse);
                                if (name.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("<font color=\"#00FF00\"><b>");
                                }
                                if (realizedName7.compareTo("") == 0) {
                                    this.setProducedRE(slot, PROD_RE_BAD);
                                    ret4 = "NOT FOUND FILLER";
                                    this.annotatedDescription.addRE(ret4, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                    this.addText(ret4);
                                } else if (!this.generateReferringExpressions) {
                                    ret4 = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName7);
                                    this.addText(ret4);
                                    this.annotatedDescription.addRE(ret4, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                } else {
                                    pre_Slot = slot.getPreviousSibling();
                                    if (pre_Slot != null) {
                                        if (XmlMsgs.compare(pre_Slot, XmlMsgs.prefix, "isA")) {
                                            if (gender.compareTo("masculine") == 0) {
                                                ret = "\u03ad\u03bd\u03b1\u03c2 " + realizedName7;
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            } else if (gender.compareTo("feminine") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret = "\u03bc\u03af\u03b1 " + realizedName7;
                                                this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            } else if (gender.compareTo("neuter") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret = "\u03ad\u03bd\u03b1 " + realizedName7;
                                                this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            } else if (gender.compareTo("masculineOrFeminine") == 0) {
                                                this.setProducedRE(slot, PROD_RE_NP);
                                                ret = "\u03ad\u03bd\u03b1\u03c2/\u03bc\u03af\u03b1 " + realizedName7;
                                                this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                                this.addText(ret);
                                            }
                                        } else if (!this.isREAuto(slot)) {
                                            ret = this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, realizedName7);
                                            this.addText(ret);
                                            this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        } else if (slot.getPreviousSibling().getTextContent().compareTo("\u03c3\u03b5") == 0) {
                                            ret = "\u03c3\u03b5 " + realizedName7;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        } else {
                                            ret = realizedName7;
                                            this.setProducedRE(slot, PROD_RE_NP);
                                            this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                            this.addText(ret);
                                        }
                                    } else {
                                        ret = realizedName7;
                                        this.setProducedRE(slot, PROD_RE_NP);
                                        this.annotatedDescription.addRE(ret, comparatorIRI.toString(), this.getForProperty(slot), this.getProducedRE(slot), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                        this.addText(ret);
                                    }
                                }
                                if (name.isGenerated() && this.annotateGeneratedResources) {
                                    this.addText("</b></font>");
                                }
                            } else {
                                String ret17 = "[NOUN OR CANNED TEXT NOT FOUND]";
                                this.setProducedRE(slot, PROD_RE_BAD);
                                this.annotatedDescription.addCannedText(ret17, comparatorIRI.toString(), String.valueOf(slot.getParentNode().getNamespaceURI()) + slot.getParentNode().getLocalName(), this.getRERole(slot), this.getInterest(slot), this.getAssimilation(slot));
                                this.addText(ret17);
                            }
                        }
                    }
                }
                if (j == messageSlots.size() - 1) {
                    if (REALIZED_TEXT.charAt(REALIZED_TEXT.length() - 2) != '.') {
                        REALIZED_TEXT.deleteCharAt(REALIZED_TEXT.length() - 1);
                        if (!slot.getParentNode().getNodeName().equals("nlowl:Comparator")) {
                            this.annotatedDescription.addText(".");
                            REALIZED_TEXT.append(". ");
                        }
                    } else {
                        this.annotatedDescription.addStartPeriod();
                        this.annotatedDescription.addStartSentence();
                    }
                }
                ++j;
            }
        }
        catch (DOMException dOMException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void addSpace() {
        this.realizedText.append(" ");
    }

    public void addText(String text) {
        if (text.compareTo("") != 0) {
            this.realizedText.append(this.capitalize(text));
            this.addSpace();
        }
    }

    private String capitalize(String text) {
        if (first) {
            first = false;
            char ch = Character.toUpperCase(text.charAt(0));
            return String.valueOf(ch) + text.substring(1);
        }
        return text;
    }

    public static String capitalizeText(String text) {
        if (text.length() > 0) {
            char ch = Character.toUpperCase(text.charAt(0));
            return String.valueOf(ch) + text.substring(1);
        }
        return text;
    }

    private IRI getSuperNLName(IRI indivOrClassIRI, NLGUser user) {
        if (!this.generatedSuperNames.containsKey(indivOrClassIRI)) {
            HashSet<IRI> superClasses = new HashSet<IRI>();
            HashSet entities = new HashSet();
            for (OWLOntology ontology : this.mainModels) {
                entities.addAll(ontology.getEntitiesInSignature(indivOrClassIRI, true));
            }
            for (OWLEntity entity : entities) {
                IRI superName;
                HashSet superClassAssertions = new HashSet();
                if (entity.isOWLClass()) {
                    for (OWLOntology oWLOntology : this.mainModels) {
                        superClassAssertions.addAll(oWLOntology.getClassAssertionAxioms((OWLClassExpression)entity.asOWLClass()));
                    }
                } else if (entity.isOWLNamedIndividual()) {
                    for (OWLOntology oWLOntology : this.mainModels) {
                        superClassAssertions.addAll(oWLOntology.getClassAssertionAxioms((OWLIndividual)entity.asOWLNamedIndividual()));
                    }
                }
                if (!superClassAssertions.isEmpty()) {
                    for (OWLClassAssertionAxiom oWLClassAssertionAxiom : superClassAssertions) {
                        superClasses.addAll(NLGEngine.getSuperClasses(indivOrClassIRI, oWLClassAssertionAxiom.getClassExpression()));
                    }
                }
                superClasses.remove(indivOrClassIRI);
                for (IRI iRI : superClasses) {
                    superName = this.MQM.chooseNLName(iRI, this.NLNQM, this.getLanguage(), user);
                    if (superName == null || superName.equals((Object)NLResourceManager.anonymous.getIRI()) || this.NLNQM.getNLName(superName).isGenerated()) continue;
                    this.generatedSuperNames.put(indivOrClassIRI, superName);
                    return superName;
                }
                for (IRI iRI : superClasses) {
                    superName = this.getSuperNLName(iRI, user);
                    if (superName == null) continue;
                    this.generatedSuperNames.put(indivOrClassIRI, superName);
                    return superName;
                }
            }
        } else {
            return this.generatedSuperNames.get(indivOrClassIRI);
        }
        return null;
    }

    private String autoGenerateRefExpression(NLName name, String gender, String number, Node slot) {
        String ownerCase = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "case");
        return this.generateRefExpressionForEntity(name, ownerCase, gender, number, slot);
    }

    public String realizeVerb(IRI lexiconEntryIRI, String tense, String voice, String number, String person, boolean polarity, boolean useAuxiliaryVerb) {
        LexEntryVerb verb = this.LQM.getVerbEntry(lexiconEntryIRI, this.getLanguage());
        String ret = "";
        if (lexiconEntryIRI.equals((Object)DefaultResourcesManager.toBeVLE_IRI)) {
            if (Languages.isEnglish(this.getLanguage())) {
                if (voice.equals("active")) {
                    if (tense.equals("simple present")) {
                        if (number.equals("singular")) {
                            if (person.equals("1st")) {
                                ret = String.valueOf(ret) + "am";
                            } else if (person.equals("2nd")) {
                                ret = String.valueOf(ret) + "are";
                            } else if (person.equals("3rd")) {
                                ret = String.valueOf(ret) + "is";
                            }
                        } else if (number.equals("plural")) {
                            ret = String.valueOf(ret) + "are";
                        }
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("present continuous")) {
                        if (number.equals("singular")) {
                            if (person.equals("1st")) {
                                ret = String.valueOf(ret) + "am";
                            } else if (person.equals("2nd")) {
                                ret = String.valueOf(ret) + "are";
                            } else if (person.equals("3rd")) {
                                ret = String.valueOf(ret) + "is";
                            }
                        } else if (number.equals("plural")) {
                            ret = String.valueOf(ret) + "are";
                        }
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " being";
                    } else if (tense.equals("present perfect")) {
                        ret = number.equals("singular") && person.equals("3rd") ? String.valueOf(ret) + "has" : String.valueOf(ret) + "have";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " been";
                    } else if (tense.equals("simple past")) {
                        ret = number.equals("singular") && person.equals("3rd") ? String.valueOf(ret) + "was" : String.valueOf(ret) + "were";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("past continuous")) {
                        ret = number.equals("singular") && person.equals("3rd") ? String.valueOf(ret) + "was" : String.valueOf(ret) + "were";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " being";
                    } else if (tense.equals("past perfect continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "had not been" : String.valueOf(ret) + "had been";
                    } else if (tense.equals("simple future")) {
                        ret = String.valueOf(ret) + "will";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " be";
                    } else if (tense.equals("future continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "will not be" : String.valueOf(ret) + "will be";
                    } else if (tense.equals("future perfect")) {
                        ret = !polarity ? String.valueOf(ret) + "will not have been" : String.valueOf(ret) + "will have been";
                    } else if (tense.equals("future perfect continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "will not have been" : String.valueOf(ret) + "will have been";
                    }
                }
            } else if (Languages.isGreek(this.getLanguage())) {
                if (!polarity) {
                    ret = String.valueOf(ret) + "\u03b4\u03b5\u03bd ";
                }
                if (tense.equals("simple future")) {
                    ret = String.valueOf(ret) + "\u03b8\u03b1";
                }
                ret = String.valueOf(ret) + ((LexEntryVerbGR)verb).get(voice, tense, person, number);
            }
        } else if (Languages.isEnglish(this.getLanguage())) {
            if (useAuxiliaryVerb) {
                if (voice.equals("active")) {
                    if (tense.equals("simple present")) {
                        if (number.equals("singular")) {
                            if (!polarity) {
                                if (person.equals("3rd")) {
                                    ret = String.valueOf(ret) + "does not";
                                    person = "2nd";
                                } else {
                                    ret = String.valueOf(ret) + "do not";
                                }
                            } else if (number.equals("plural")) {
                                ret = String.valueOf(ret) + "do not";
                            }
                        }
                    } else if (tense.equals("present continuous")) {
                        if (number.equals("singular")) {
                            if (person.equals("1st")) {
                                ret = String.valueOf(ret) + "am";
                            } else if (person.equals("2nd")) {
                                ret = String.valueOf(ret) + "are";
                            } else if (person.equals("3rd")) {
                                ret = String.valueOf(ret) + "is";
                            }
                        } else if (number.equals("plural")) {
                            ret = String.valueOf(ret) + "are";
                        }
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("present perfect")) {
                        ret = number.equals("singular") && person.equals("3rd") ? String.valueOf(ret) + "has" : String.valueOf(ret) + "have";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("simple past")) {
                        if (!polarity) {
                            ret = String.valueOf(ret) + "did not";
                        }
                    } else if (tense.equals("past continuous")) {
                        ret = number.equals("singular") && (person.equals("1st") || person.equals("3rd")) ? String.valueOf(ret) + "was" : String.valueOf(ret) + "were";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("past perfect continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "had not been" : String.valueOf(ret) + "had been";
                    } else if (tense.equals("simple future")) {
                        ret = String.valueOf(ret) + "will";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("future continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "will not be" : String.valueOf(ret) + "will be";
                    } else if (tense.equals("future perfect")) {
                        ret = !polarity ? String.valueOf(ret) + "will not have" : String.valueOf(ret) + "will have";
                    } else if (tense.equals("future perfect continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "will not have been" : String.valueOf(ret) + "will have been";
                    }
                } else if (voice.equals("passive")) {
                    if (tense.equals("simple present")) {
                        if (number.equals("singular")) {
                            if (person.equals("1st")) {
                                ret = String.valueOf(ret) + "am";
                            } else if (person.equals("2nd")) {
                                ret = String.valueOf(ret) + "are";
                            } else if (person.equals("3rd")) {
                                ret = String.valueOf(ret) + "is";
                            }
                        } else if (number.equals("plural")) {
                            ret = String.valueOf(ret) + "are";
                        }
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("present continuous")) {
                        if (number.equals("singular")) {
                            if (person.equals("1st")) {
                                ret = String.valueOf(ret) + "am";
                            } else if (person.equals("2nd")) {
                                ret = String.valueOf(ret) + "are";
                            } else if (person.equals("3rd")) {
                                ret = String.valueOf(ret) + "is";
                            }
                        } else if (number.equals("plural")) {
                            ret = String.valueOf(ret) + "are";
                        }
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " being";
                    } else if (tense.equals("present perfect")) {
                        ret = number.equals("singular") && person.equals("3rd") ? String.valueOf(ret) + "has" : String.valueOf(ret) + "have";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " been";
                    } else if (tense.equals("simple past")) {
                        ret = number.equals("singular") && (person.equals("1st") || person.equals("3rd")) ? String.valueOf(ret) + "was" : String.valueOf(ret) + "were";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                    } else if (tense.equals("past continuous")) {
                        ret = number.equals("singular") && (person.equals("1st") || person.equals("3rd")) ? String.valueOf(ret) + "was" : String.valueOf(ret) + "were";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " being";
                    } else if (tense.equals("past perfect continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "has not been" : String.valueOf(ret) + "has been";
                        ret = String.valueOf(ret) + " being";
                    } else if (tense.equals("simple future")) {
                        ret = String.valueOf(ret) + "will";
                        if (!polarity) {
                            ret = String.valueOf(ret) + " not";
                        }
                        ret = String.valueOf(ret) + " be";
                    } else if (tense.equals("future continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "will not be" : String.valueOf(ret) + "will be";
                        ret = String.valueOf(ret) + " being";
                    } else if (tense.equals("future perfect")) {
                        ret = !polarity ? String.valueOf(ret) + "will not have" : String.valueOf(ret) + "will have";
                        ret = String.valueOf(ret) + " been";
                    } else if (tense.equals("future perfect continuous")) {
                        ret = !polarity ? String.valueOf(ret) + "will not have been" : String.valueOf(ret) + "will have been";
                        ret = String.valueOf(ret) + " being";
                    }
                }
            } else if (!polarity) {
                ret = String.valueOf(ret) + "not";
            }
            ret = !polarity && tense.equals("simple past") ? String.valueOf(ret) + " " + ((LexEntryVerbEN)verb).get(voice, "simple present", person, number) : String.valueOf(ret) + " " + ((LexEntryVerbEN)verb).get(voice, tense, person, number);
            if (!polarity && !ret.contains("not")) {
                ret = String.valueOf(ret) + " not";
            }
        } else if (Languages.isGreek(this.getLanguage())) {
            if (!polarity) {
                ret = String.valueOf(ret) + "\u03b4\u03b5\u03bd";
            }
            if (useAuxiliaryVerb) {
                if (tense.equals("present perfect")) {
                    if (number.equals("singular")) {
                        if (person.equals("1st")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03c9";
                        } else if (person.equals("2nd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03b5\u03b9\u03c2";
                        } else if (person.equals("3rd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03b5\u03b9";
                        }
                    } else if (number.equals("plural")) {
                        if (person.equals("1st")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03bf\u03c5\u03bc\u03b5";
                        } else if (person.equals("2nd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03b5\u03c4\u03b5 ";
                        } else if (person.equals("3rd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03bf\u03c5\u03bd";
                        }
                    }
                } else if (tense.equals("past perfect")) {
                    if (number.equals("singular")) {
                        if (person.equals("1st")) {
                            ret = String.valueOf(ret) + "\u03b5\u03af\u03c7\u03b1";
                        } else if (person.equals("2nd")) {
                            ret = String.valueOf(ret) + "\u03b5\u03af\u03c7\u03b5\u03c2";
                        } else if (person.equals("3rd")) {
                            ret = String.valueOf(ret) + "\u03b5\u03af\u03c7\u03b5";
                        }
                    } else if (number.equals("plural")) {
                        if (person.equals("1st")) {
                            ret = String.valueOf(ret) + "\u03b5\u03af\u03c7\u03b1\u03bc\u03b5";
                        } else if (person.equals("2nd")) {
                            ret = String.valueOf(ret) + "\u03b5\u03af\u03c7\u03b1\u03c4\u03b5";
                        } else if (person.equals("3rd")) {
                            ret = String.valueOf(ret) + "\u03b5\u03af\u03c7\u03b1\u03bd";
                        }
                    }
                } else if (tense.equals("simple future")) {
                    ret = String.valueOf(ret) + "\u03b8\u03b1";
                } else if (tense.equals("future continuous")) {
                    ret = String.valueOf(ret) + "\u03b8\u03b1";
                } else if (tense.equals("future perfect")) {
                    ret = String.valueOf(ret) + "\u03b8\u03b1 ";
                    if (number.equals("singular")) {
                        if (person.equals("1st")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03c9";
                        } else if (person.equals("2nd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03b5\u03b9\u03c2";
                        } else if (person.equals("3rd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03b5\u03b9";
                        }
                    } else if (number.equals("plural")) {
                        if (person.equals("1st")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03bf\u03c5\u03bc\u03b5";
                        } else if (person.equals("2nd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03b5\u03c4\u03b5";
                        } else if (person.equals("3rd")) {
                            ret = String.valueOf(ret) + "\u03ad\u03c7\u03bf\u03c5\u03bd";
                        }
                    }
                }
            }
            ret = String.valueOf(ret) + " " + ((LexEntryVerbGR)verb).get(voice, tense, person, number);
        }
        return ret.trim();
    }

    public String realizeNLName(NLName name, String SPCaseType, String SPNumber, String SPGender, int articleUse) {
        String number;
        ArrayList<NLNSlot> slots = name.getSlotsList();
        Collections.sort(slots);
        ArrayList<String> realizedSlots = new ArrayList<String>();
        int i = 0;
        while (i < slots.size()) {
            String caseType;
            IRI lexiconEntryIRI;
            if (slots.get(i) instanceof NLNAdjectiveSlot) {
                LexEntryAdjective adjectiveEntry;
                NLNAdjectiveSlot adjective = (NLNAdjectiveSlot)slots.get(i);
                lexiconEntryIRI = adjective.getLexiconEntryIRI();
                number = "";
                caseType = "";
                String gender = "";
                if (Languages.isGreek(this.getLanguage())) {
                    if (adjective.isHead()) {
                        number = SPNumber.isEmpty() ? adjective.getNumber() : SPNumber;
                        caseType = SPCaseType.isEmpty() ? adjective.getCase() : SPCaseType;
                        gender = SPGender.isEmpty() ? adjective.getGender() : SPGender;
                    } else if (adjective.getAgreesWithID() != null) {
                        NLNSlot agreeSlot = adjective;
                        boolean foundAgree = false;
                        NodeID agreeID = adjective.getAgreesWithID();
                        while (!foundAgree) {
                            int j = 0;
                            while (j < slots.size()) {
                                if (slots.get(j).getId().equals(agreeID)) {
                                    agreeSlot = slots.get(j);
                                    if (agreeSlot instanceof NLNNounSlot) {
                                        if (((NLNNounSlot)agreeSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNNounSlot)agreeSlot).getAgreesWithID();
                                        } else {
                                            foundAgree = true;
                                        }
                                    } else if (agreeSlot instanceof NLNAdjectiveSlot) {
                                        if (((NLNAdjectiveSlot)agreeSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNAdjectiveSlot)agreeSlot).getAgreesWithID();
                                        } else {
                                            foundAgree = true;
                                        }
                                    } else if (agreeSlot instanceof NLNArticleSlot) {
                                        if (((NLNArticleSlot)agreeSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNArticleSlot)agreeSlot).getAgreesWithID();
                                        } else {
                                            foundAgree = true;
                                        }
                                    }
                                }
                                ++j;
                            }
                        }
                        if (foundAgree && agreeSlot != null) {
                            if (agreeSlot instanceof NLNNounSlot) {
                                if (!SPNumber.isEmpty() && ((NLNNounSlot)agreeSlot).isHead()) {
                                    number = SPNumber;
                                    String restriction = this.LQM.getNounEntry(((NLNNounSlot)agreeSlot).getLexiconEntryIRI(), this.getLanguage()).getNumber();
                                    if (!restriction.equals("both")) {
                                        if (restriction.equals("singular")) {
                                            number = "singular";
                                        } else if (restriction.equals("plural")) {
                                            number = "plural";
                                        }
                                    }
                                } else {
                                    number = ((NLNNounSlot)agreeSlot).getNumber();
                                }
                                caseType = !SPCaseType.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPCaseType : ((NLNNounSlot)agreeSlot).getCase();
                                gender = !SPGender.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPGender : this.LQM.getNounEntry(((NLNNounSlot)agreeSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                            } else if (agreeSlot instanceof NLNAdjectiveSlot) {
                                number = !SPNumber.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPNumber : ((NLNAdjectiveSlot)agreeSlot).getNumber();
                                caseType = !SPCaseType.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPCaseType : ((NLNAdjectiveSlot)agreeSlot).getCase();
                                gender = !SPGender.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPGender : ((NLNAdjectiveSlot)agreeSlot).getGender();
                            }
                        }
                    } else {
                        number = adjective.getNumber();
                        caseType = adjective.getCase();
                        gender = adjective.getGender();
                    }
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    adjectiveEntry = (LexEntryAdjectiveEN)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                    if (adjective.isCapitalized()) {
                        realizedSlots.add(SurfaceRealization.capitalizeText(((LexEntryAdjectiveEN)adjectiveEntry).get_form()));
                    } else {
                        realizedSlots.add(((LexEntryAdjectiveEN)adjectiveEntry).get_form());
                    }
                } else if (Languages.isGreek(this.getLanguage())) {
                    adjectiveEntry = (LexEntryAdjectiveGR)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                    if (adjective.isCapitalized()) {
                        realizedSlots.add(SurfaceRealization.capitalizeText(((LexEntryAdjectiveGR)adjectiveEntry).get(gender, number, caseType)));
                    } else {
                        realizedSlots.add(((LexEntryAdjectiveGR)adjectiveEntry).get(gender, number, caseType));
                    }
                }
            } else if (slots.get(i) instanceof NLNNounSlot) {
                NLNNounSlot noun = (NLNNounSlot)slots.get(i);
                lexiconEntryIRI = noun.getLexiconEntryIRI();
                number = "";
                caseType = "";
                if (noun.isHead()) {
                    number = SPNumber.isEmpty() ? noun.getNumber() : SPNumber;
                    caseType = SPCaseType.isEmpty() ? noun.getCase() : SPCaseType;
                } else if (noun.getAgreesWithID() != null) {
                    NLNSlot agreeSlot = noun;
                    boolean foundAgree = false;
                    NodeID agreeID = noun.getAgreesWithID();
                    while (!foundAgree) {
                        int j = 0;
                        while (j < slots.size()) {
                            if (slots.get(j).getId().equals(agreeID)) {
                                agreeSlot = slots.get(j);
                                if (agreeSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)agreeSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)agreeSlot).getAgreesWithID();
                                    } else {
                                        foundAgree = true;
                                    }
                                } else if (agreeSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)agreeSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)agreeSlot).getAgreesWithID();
                                    } else {
                                        foundAgree = true;
                                    }
                                } else if (agreeSlot instanceof NLNArticleSlot) {
                                    if (((NLNArticleSlot)agreeSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNArticleSlot)agreeSlot).getAgreesWithID();
                                    } else {
                                        foundAgree = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (foundAgree && agreeSlot != null) {
                        if (agreeSlot instanceof NLNNounSlot) {
                            if (!SPNumber.isEmpty() && ((NLNNounSlot)agreeSlot).isHead()) {
                                number = SPNumber;
                                String restriction = this.LQM.getNounEntry(((NLNNounSlot)agreeSlot).getLexiconEntryIRI(), this.getLanguage()).getNumber();
                                if (!restriction.equals("both")) {
                                    if (restriction.equals("singular")) {
                                        number = "singular";
                                    } else if (restriction.equals("plural")) {
                                        number = "plural";
                                    }
                                }
                            } else {
                                number = ((NLNNounSlot)agreeSlot).getNumber();
                            }
                            caseType = !SPCaseType.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPCaseType : ((NLNNounSlot)agreeSlot).getCase();
                        } else if (agreeSlot instanceof NLNAdjectiveSlot) {
                            number = !SPNumber.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPNumber : ((NLNAdjectiveSlot)agreeSlot).getNumber();
                            caseType = !SPCaseType.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPCaseType : ((NLNAdjectiveSlot)agreeSlot).getCase();
                        }
                    }
                } else {
                    number = noun.getNumber();
                    if (Languages.isGreek(this.getLanguage())) {
                        caseType = noun.getCase();
                    }
                }
                String restriction = this.LQM.getNounEntry(noun.getLexiconEntryIRI(), this.getLanguage()).getNumber();
                if (!restriction.equals("both")) {
                    if (restriction.equals("singular")) {
                        number = "singular";
                    } else if (restriction.equals("plural")) {
                        number = "plural";
                    }
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    LexEntryNounEN nounEntry = (LexEntryNounEN)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                    if (noun.isCapitalized()) {
                        realizedSlots.add(SurfaceRealization.capitalizeText(nounEntry.get(caseType, number)));
                    } else {
                        realizedSlots.add(nounEntry.get(caseType, number));
                    }
                } else if (Languages.isGreek(this.getLanguage())) {
                    LexEntryNounGR nounEntry = (LexEntryNounGR)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                    if (noun.isCapitalized()) {
                        realizedSlots.add(SurfaceRealization.capitalizeText(nounEntry.get(caseType, number)));
                    } else {
                        realizedSlots.add(nounEntry.get(caseType, number));
                    }
                }
            } else if (slots.get(i) instanceof NLNPrepositionSlot) {
                NLNPrepositionSlot preposition = (NLNPrepositionSlot)slots.get(i);
                realizedSlots.add(preposition.getPrep());
            } else if (slots.get(i) instanceof NLNStringSlot) {
                NLNStringSlot string = (NLNStringSlot)slots.get(i);
                realizedSlots.add(string.getText());
            }
            ++i;
        }
        i = 0;
        while (i < slots.size()) {
            if (slots.get(i) instanceof NLNArticleSlot && (i == 0 && articleUse != 1 || i > 0)) {
                NLNArticleSlot article = (NLNArticleSlot)slots.get(i);
                String realizedArticle = "";
                number = "";
                String gender = "";
                String caseType = "";
                if (article.getAgreesWithID() != null) {
                    NLNSlot agreeSlot = article;
                    boolean foundAgree = false;
                    NodeID agreeID = article.getAgreesWithID();
                    while (!foundAgree) {
                        int j = 0;
                        while (j < slots.size()) {
                            if (slots.get(j).getId().equals(agreeID)) {
                                agreeSlot = slots.get(j);
                                if (agreeSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)agreeSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)agreeSlot).getAgreesWithID();
                                        j = 0;
                                    } else {
                                        foundAgree = true;
                                    }
                                } else if (agreeSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)agreeSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)agreeSlot).getAgreesWithID();
                                        j = 0;
                                    } else {
                                        foundAgree = true;
                                    }
                                } else if (agreeSlot instanceof NLNArticleSlot) {
                                    if (((NLNArticleSlot)agreeSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNArticleSlot)agreeSlot).getAgreesWithID();
                                        j = 0;
                                    } else {
                                        foundAgree = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (foundAgree && agreeSlot != null) {
                        if (agreeSlot instanceof NLNNounSlot) {
                            number = ((NLNNounSlot)agreeSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                gender = !SPGender.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPGender : this.LQM.getNounEntry(((NLNNounSlot)agreeSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                caseType = !SPCaseType.isEmpty() && ((NLNNounSlot)agreeSlot).isHead() ? SPCaseType : ((NLNNounSlot)agreeSlot).getCase();
                            }
                        } else if (agreeSlot instanceof NLNAdjectiveSlot) {
                            number = ((NLNAdjectiveSlot)agreeSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                gender = ((NLNAdjectiveSlot)agreeSlot).getGender();
                                caseType = ((NLNAdjectiveSlot)agreeSlot).getCase();
                            }
                        }
                    }
                } else {
                    number = article.getNumber();
                    gender = article.getGender();
                    caseType = article.getCase();
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    if (articleUse == 2) {
                        realizedArticle = EnglishArticles.getDefiniteArticle();
                    } else if (articleUse == 3) {
                        if (number.equals("singular")) {
                            realizedArticle = i < realizedSlots.size() ? EnglishArticles.getIndefiniteArticle((String)realizedSlots.get(i)) : EnglishArticles.getIndefiniteArticle("");
                        }
                    } else if (article.isDefinite()) {
                        realizedArticle = EnglishArticles.getDefiniteArticle();
                    } else if (number.equals("singular")) {
                        realizedArticle = i < realizedSlots.size() ? EnglishArticles.getIndefiniteArticle((String)realizedSlots.get(i)) : EnglishArticles.getIndefiniteArticle("");
                    }
                } else if (Languages.isGreek(this.getLanguage())) {
                    realizedArticle = articleUse == 2 ? (i < realizedSlots.size() ? GreekArticles.getDefiniteArticle(gender, number, caseType, (String)realizedSlots.get(i)) : GreekArticles.getDefiniteArticle(gender, number, caseType, "")) : (articleUse == 3 ? GreekArticles.getIndefiniteArticle(gender, number, caseType) : (article.isDefinite() ? (i < realizedSlots.size() ? GreekArticles.getDefiniteArticle(gender, number, caseType, (String)realizedSlots.get(i)) : GreekArticles.getDefiniteArticle(gender, number, caseType, "")) : GreekArticles.getIndefiniteArticle(gender, number, caseType)));
                }
                realizedSlots.add(i, realizedArticle);
            }
            ++i;
        }
        if (Languages.isEnglish(this.getLanguage()) && slots.size() == 1 && slots.get(0) instanceof NLNStringSlot && SPCaseType.equals("genitive")) {
            if (!((String)realizedSlots.get(realizedSlots.size() - 1)).endsWith("s")) {
                realizedSlots.set(realizedSlots.size() - 1, String.valueOf((String)realizedSlots.get(realizedSlots.size() - 1)) + "'s");
            } else {
                realizedSlots.set(realizedSlots.size() - 1, String.valueOf((String)realizedSlots.get(realizedSlots.size() - 1)) + "'");
            }
        }
        String realizedName = "";
        int i2 = 0;
        while (i2 < realizedSlots.size()) {
            realizedName = String.valueOf(realizedName) + " " + (String)realizedSlots.get(i2);
            ++i2;
        }
        return realizedName.trim();
    }

    private String realizeNLName(NLName name, String SPCaseType, String SPNumber, String SPGender, int articleUse, ArrayList<IRI> appendAdjectives) {
        int j;
        String number;
        ArrayList<NLNSlot> slots = name.getSlotsList();
        Collections.sort(slots);
        ArrayList<String> realizedSlots = new ArrayList<String>();
        int adjectiveInsertion = 0;
        boolean nameContainsAdjective = false;
        String headNumber = "";
        String headGender = "";
        String headCase = "";
        int i = 0;
        while (i < slots.size()) {
            String caseType;
            IRI lexiconEntryIRI;
            if (slots.get(i) instanceof NLNAdjectiveSlot) {
                nameContainsAdjective = true;
                NLNAdjectiveSlot adjective = (NLNAdjectiveSlot)slots.get(i);
                lexiconEntryIRI = adjective.getLexiconEntryIRI();
                number = "";
                caseType = "";
                String gender = "";
                if (Languages.isGreek(this.getLanguage())) {
                    if (adjective.isHead()) {
                        number = SPNumber.isEmpty() ? adjective.getNumber() : SPNumber;
                        caseType = SPCaseType.isEmpty() ? adjective.getCase() : SPCaseType;
                        gender = SPGender.isEmpty() ? adjective.getGender() : SPGender;
                    } else if (adjective.getAgreesWithID() != null) {
                        NLNSlot headSlot = adjective;
                        boolean foundHead = false;
                        NodeID agreeID = adjective.getAgreesWithID();
                        while (!foundHead) {
                            j = 0;
                            while (j < slots.size()) {
                                if (slots.get(j).getId().equals(agreeID)) {
                                    headSlot = slots.get(j);
                                    if (headSlot instanceof NLNNounSlot) {
                                        if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                        } else {
                                            foundHead = true;
                                        }
                                    } else if (headSlot instanceof NLNAdjectiveSlot) {
                                        if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                        } else {
                                            foundHead = true;
                                        }
                                    } else if (headSlot instanceof NLNArticleSlot) {
                                        if (((NLNArticleSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNArticleSlot)headSlot).getAgreesWithID();
                                        } else {
                                            foundHead = true;
                                        }
                                    }
                                }
                                ++j;
                            }
                        }
                        if (headSlot != null) {
                            if (headSlot instanceof NLNNounSlot) {
                                number = ((NLNNounSlot)headSlot).getNumber();
                                caseType = ((NLNNounSlot)headSlot).getCase();
                                gender = this.LQM.getNounEntry(((NLNNounSlot)headSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                            } else if (headSlot instanceof NLNAdjectiveSlot) {
                                number = ((NLNAdjectiveSlot)headSlot).getNumber();
                                caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                                gender = ((NLNAdjectiveSlot)headSlot).getGender();
                            }
                        }
                    } else {
                        number = adjective.getNumber();
                        caseType = adjective.getCase();
                        gender = adjective.getGender();
                    }
                }
                if (adjective.isHead()) {
                    boolean foundStart = false;
                    int j2 = i;
                    while (!foundStart && j2 > 0) {
                        if (!(slots.get(j2) instanceof NLNNounSlot) && !(slots.get(j2) instanceof NLNAdjectiveSlot)) {
                            foundStart = true;
                            adjectiveInsertion = i;
                        }
                        --j2;
                    }
                    headNumber = number;
                    headCase = caseType;
                    headGender = gender;
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    LexEntryAdjectiveEN adjectiveEntry = (LexEntryAdjectiveEN)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                    realizedSlots.add(adjectiveEntry.get_form());
                } else if (Languages.isGreek(this.getLanguage())) {
                    LexEntryAdjectiveGR adjectiveEntry = (LexEntryAdjectiveGR)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                    realizedSlots.add(adjectiveEntry.get(gender, number, caseType));
                }
            } else if (slots.get(i) instanceof NLNNounSlot) {
                String restriction;
                NLNNounSlot noun = (NLNNounSlot)slots.get(i);
                lexiconEntryIRI = noun.getLexiconEntryIRI();
                number = "";
                caseType = "";
                if (noun.isHead()) {
                    number = SPNumber.isEmpty() ? noun.getNumber() : SPNumber;
                    caseType = SPCaseType.isEmpty() ? noun.getCase() : SPCaseType;
                } else if (noun.getAgreesWithID() != null) {
                    NLNSlot headSlot = noun;
                    boolean foundHead = false;
                    NodeID agreeID = noun.getAgreesWithID();
                    while (!foundHead) {
                        int j3 = 0;
                        while (j3 < slots.size()) {
                            if (slots.get(j3).getId().equals(agreeID)) {
                                headSlot = slots.get(j3);
                                if (headSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNArticleSlot) {
                                    if (((NLNArticleSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNArticleSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                }
                            }
                            ++j3;
                        }
                    }
                    if (headSlot != null) {
                        if (headSlot instanceof NLNNounSlot) {
                            number = ((NLNNounSlot)headSlot).getNumber();
                            caseType = ((NLNNounSlot)headSlot).getCase();
                        } else if (headSlot instanceof NLNAdjectiveSlot) {
                            number = ((NLNAdjectiveSlot)headSlot).getNumber();
                            caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                        }
                    }
                } else {
                    number = noun.getNumber();
                    caseType = noun.getCase();
                }
                if (noun.isHead()) {
                    boolean foundStart = false;
                    int j4 = i;
                    while (!foundStart && j4 > 0) {
                        if (!(slots.get(j4) instanceof NLNNounSlot) && !(slots.get(j4) instanceof NLNAdjectiveSlot)) {
                            foundStart = true;
                            adjectiveInsertion = i;
                        }
                        --j4;
                    }
                    headNumber = number;
                    headCase = caseType;
                    headGender = SPGender.isEmpty() ? this.LQM.getNounEntry(noun.getLexiconEntryIRI(), this.getLanguage()).getGender() : SPGender;
                }
                if (!(restriction = this.LQM.getNounEntry(noun.getLexiconEntryIRI(), this.getLanguage()).getNumber()).equals("both")) {
                    if (restriction.equals("singular")) {
                        number = "singular";
                    } else if (restriction.equals("plural")) {
                        number = "plural";
                    }
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    LexEntryNounEN nounEntry = (LexEntryNounEN)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                    realizedSlots.add(nounEntry.get("", number));
                } else if (Languages.isGreek(this.getLanguage())) {
                    LexEntryNounGR nounEntry = (LexEntryNounGR)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                    realizedSlots.add(nounEntry.get(caseType, number));
                }
            } else if (slots.get(i) instanceof NLNPrepositionSlot) {
                NLNPrepositionSlot preposition = (NLNPrepositionSlot)slots.get(i);
                realizedSlots.add(preposition.getPrep());
            } else if (slots.get(i) instanceof NLNStringSlot) {
                NLNStringSlot string = (NLNStringSlot)slots.get(i);
                realizedSlots.add(string.getText());
            }
            ++i;
        }
        int a = 0;
        while (a < appendAdjectives.size()) {
            LexEntryAdjective adjectiveEntry;
            if (appendAdjectives.get(a).toString().equals("||")) {
                realizedSlots.add("||");
            } else if (Languages.isEnglish(this.getLanguage())) {
                if (a > 0 || nameContainsAdjective) {
                    realizedSlots.add(adjectiveInsertion, ",");
                }
                adjectiveEntry = (LexEntryAdjectiveEN)this.LQM.getAdjectiveEntry(appendAdjectives.get(a), this.getLanguage());
                realizedSlots.add(adjectiveInsertion, ((LexEntryAdjectiveEN)adjectiveEntry).get_form());
            } else if (Languages.isGreek(this.getLanguage())) {
                if (a > 0 || nameContainsAdjective) {
                    realizedSlots.add(adjectiveInsertion, ",");
                }
                adjectiveEntry = (LexEntryAdjectiveGR)this.LQM.getAdjectiveEntry(appendAdjectives.get(a), this.getLanguage());
                realizedSlots.add(adjectiveInsertion, ((LexEntryAdjectiveGR)adjectiveEntry).get(headGender, headNumber, headCase));
            }
            ++a;
        }
        i = 0;
        while (i < slots.size()) {
            if (slots.get(i) instanceof NLNArticleSlot && (i == 0 && articleUse != 1 || i > 0)) {
                NLNArticleSlot article = (NLNArticleSlot)slots.get(i);
                String realizedArticle = "";
                number = "";
                String gender = "";
                String caseType = "";
                if (article.getAgreesWithID() != null) {
                    NLNSlot headSlot = article;
                    boolean foundHead = false;
                    NodeID agreeID = article.getAgreesWithID();
                    while (!foundHead) {
                        j = 0;
                        while (j < slots.size()) {
                            if (slots.get(j).getId().equals(agreeID)) {
                                headSlot = slots.get(j);
                                if (headSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNArticleSlot) {
                                    if (((NLNArticleSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNArticleSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (headSlot != null) {
                        if (headSlot instanceof NLNNounSlot) {
                            number = ((NLNNounSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                gender = this.LQM.getNounEntry(((NLNNounSlot)headSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                caseType = ((NLNNounSlot)headSlot).getCase();
                            }
                        } else if (headSlot instanceof NLNAdjectiveSlot) {
                            number = ((NLNAdjectiveSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                gender = ((NLNAdjectiveSlot)headSlot).getGender();
                                caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                            }
                        }
                    }
                } else {
                    number = article.getNumber();
                    gender = article.getGender();
                    caseType = article.getCase();
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    if (articleUse == 2) {
                        realizedArticle = EnglishArticles.getDefiniteArticle();
                    } else if (articleUse == 3) {
                        if (number.equals("singular")) {
                            realizedArticle = i < realizedSlots.size() ? EnglishArticles.getIndefiniteArticle((String)realizedSlots.get(i)) : EnglishArticles.getIndefiniteArticle("");
                        }
                    } else if (article.isDefinite()) {
                        realizedArticle = EnglishArticles.getDefiniteArticle();
                    } else if (number.equals("singular")) {
                        realizedArticle = i < realizedSlots.size() ? EnglishArticles.getIndefiniteArticle((String)realizedSlots.get(i)) : EnglishArticles.getIndefiniteArticle("");
                    }
                } else if (Languages.isGreek(this.getLanguage())) {
                    realizedArticle = articleUse == 2 ? (i < realizedSlots.size() ? GreekArticles.getDefiniteArticle(gender, number, caseType, (String)realizedSlots.get(i)) : GreekArticles.getDefiniteArticle(gender, number, caseType, "")) : (articleUse == 3 ? GreekArticles.getIndefiniteArticle(gender, number, caseType) : (article.isDefinite() ? (i < realizedSlots.size() ? GreekArticles.getDefiniteArticle(gender, number, caseType, (String)realizedSlots.get(i)) : GreekArticles.getDefiniteArticle(gender, number, caseType, "")) : GreekArticles.getIndefiniteArticle(gender, number, caseType)));
                }
                realizedSlots.add(i, realizedArticle);
            }
            ++i;
        }
        boolean isLast = true;
        boolean isBeforeLast = true;
        int i2 = realizedSlots.size() - 1;
        while (i2 >= 0) {
            if (((String)realizedSlots.get(i2)).equals("||")) {
                if (isLast) {
                    realizedSlots.set(i2, ",");
                    isLast = false;
                } else if (isBeforeLast) {
                    if (Languages.isEnglish(this.getLanguage())) {
                        realizedSlots.set(i2, "or");
                    } else if (Languages.isGreek(this.getLanguage())) {
                        realizedSlots.set(i2, "\u03ae");
                    }
                    isBeforeLast = false;
                } else {
                    realizedSlots.set(i2, ",");
                }
            }
            --i2;
        }
        String realizedName = "";
        int i3 = 0;
        while (i3 < realizedSlots.size()) {
            realizedName = String.valueOf(realizedName) + " " + (String)realizedSlots.get(i3);
            ++i3;
        }
        return realizedName.trim();
    }

    private String aggregateNLNameAdjectives(ArrayList<NLName> names, String SPCaseType, String SPNumber, boolean isConjunction, boolean useBullets) {
        String number;
        String gender;
        ArrayList<NLNSlot> slots = names.get(0).getSlotsList();
        Collections.sort(slots);
        ArrayList<String> realizedSlots = new ArrayList<String>();
        int i = 0;
        while (i < slots.size()) {
            int j;
            NodeID agreeID;
            NLNSlot headSlot;
            if (slots.get(i) instanceof NLNAdjectiveSlot) {
                NLNAdjectiveSlot adjective = (NLNAdjectiveSlot)slots.get(i);
                String number2 = "";
                String caseType = "";
                gender = "";
                if (Languages.isGreek(this.getLanguage())) {
                    if (adjective.getAgreesWithID() != null) {
                        headSlot = adjective;
                        boolean foundHead = false;
                        agreeID = adjective.getAgreesWithID();
                        while (!foundHead) {
                            j = 0;
                            while (j < slots.size()) {
                                if (slots.get(j).getId().equals(agreeID)) {
                                    headSlot = slots.get(j);
                                    if (headSlot instanceof NLNNounSlot) {
                                        if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                        } else {
                                            foundHead = true;
                                        }
                                    } else if (headSlot instanceof NLNAdjectiveSlot) {
                                        if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                        } else {
                                            foundHead = true;
                                        }
                                    } else if (headSlot instanceof NLNArticleSlot) {
                                        if (((NLNArticleSlot)headSlot).getAgreesWithID() != null) {
                                            agreeID = ((NLNArticleSlot)headSlot).getAgreesWithID();
                                        } else {
                                            foundHead = true;
                                        }
                                    }
                                }
                                ++j;
                            }
                        }
                        if (headSlot != null && headSlot instanceof NLNNounSlot) {
                            number2 = ((NLNNounSlot)headSlot).getNumber();
                            caseType = ((NLNNounSlot)headSlot).getCase();
                            gender = this.LQM.getNounEntry(((NLNNounSlot)headSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                        }
                    } else {
                        number2 = adjective.getNumber();
                        caseType = adjective.getCase();
                        gender = adjective.getGender();
                    }
                }
                for (NLName name : names) {
                    ArrayList<NLNSlot> nameSlots = name.getSlotsList();
                    int k = 0;
                    while (k < nameSlots.size()) {
                        if (nameSlots.get(k) instanceof NLNAdjectiveSlot) {
                            LexEntryAdjective adjectiveEntry;
                            adjective = (NLNAdjectiveSlot)nameSlots.get(k);
                            IRI lexiconEntryIRI = adjective.getLexiconEntryIRI();
                            if (Languages.isEnglish(this.getLanguage())) {
                                adjectiveEntry = (LexEntryAdjectiveEN)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                                realizedSlots.add(((LexEntryAdjectiveEN)adjectiveEntry).get_form());
                            } else if (Languages.isGreek(this.getLanguage())) {
                                adjectiveEntry = (LexEntryAdjectiveGR)this.LQM.getAdjectiveEntry(lexiconEntryIRI, this.getLanguage());
                                realizedSlots.add(((LexEntryAdjectiveGR)adjectiveEntry).get(gender, number2, caseType));
                            }
                            if (isConjunction) {
                                realizedSlots.add("&&");
                            } else {
                                realizedSlots.add("||");
                            }
                        }
                        ++k;
                    }
                }
            } else if (slots.get(i) instanceof NLNNounSlot) {
                String restriction;
                NLNNounSlot noun = (NLNNounSlot)slots.get(i);
                IRI lexiconEntryIRI = noun.getLexiconEntryIRI();
                number = "";
                String caseType = "";
                if (noun.isHead()) {
                    number = SPNumber.isEmpty() ? noun.getNumber() : SPNumber;
                    if (Languages.isGreek(this.getLanguage())) {
                        caseType = SPCaseType.isEmpty() ? noun.getCase() : SPCaseType;
                    }
                } else if (noun.getAgreesWithID() != null) {
                    headSlot = noun;
                    boolean foundHead = false;
                    agreeID = noun.getAgreesWithID();
                    while (!foundHead) {
                        j = 0;
                        while (j < slots.size()) {
                            if (slots.get(j).getId().equals(agreeID)) {
                                headSlot = slots.get(j);
                                if (headSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNArticleSlot) {
                                    if (((NLNArticleSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNArticleSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (headSlot != null) {
                        if (headSlot instanceof NLNNounSlot) {
                            number = ((NLNNounSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                caseType = ((NLNNounSlot)headSlot).getCase();
                            }
                        } else if (headSlot instanceof NLNAdjectiveSlot) {
                            number = ((NLNAdjectiveSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                            }
                        }
                    }
                } else {
                    number = noun.getNumber();
                    if (Languages.isGreek(this.getLanguage())) {
                        caseType = noun.getCase();
                    }
                }
                if (!(restriction = this.LQM.getNounEntry(noun.getLexiconEntryIRI(), this.getLanguage()).getNumber()).equals("both")) {
                    if (restriction.equals("singular")) {
                        number = "singular";
                    } else if (restriction.equals("plural")) {
                        number = "plural";
                    }
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    LexEntryNounEN nounEntry = (LexEntryNounEN)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                    realizedSlots.add(nounEntry.get("", number));
                } else if (Languages.isGreek(this.getLanguage())) {
                    LexEntryNounGR nounEntry = (LexEntryNounGR)this.LQM.getNounEntry(lexiconEntryIRI, this.getLanguage());
                    realizedSlots.add(nounEntry.get(caseType, number));
                }
            } else if (slots.get(i) instanceof NLNPrepositionSlot) {
                NLNPrepositionSlot preposition = (NLNPrepositionSlot)slots.get(i);
                realizedSlots.add(preposition.getPrep());
            } else if (slots.get(i) instanceof NLNStringSlot) {
                NLNStringSlot string = (NLNStringSlot)slots.get(i);
                realizedSlots.add(string.getText());
            }
            ++i;
        }
        i = 0;
        while (i < slots.size()) {
            if (slots.get(i) instanceof NLNArticleSlot) {
                NLNArticleSlot article = (NLNArticleSlot)slots.get(i);
                String realizedArticle = "";
                number = "";
                gender = "";
                String caseType = "";
                if (article.getAgreesWithID() != null) {
                    NLNSlot headSlot = article;
                    boolean foundHead = false;
                    NodeID agreeID = article.getAgreesWithID();
                    while (!foundHead) {
                        int j = 0;
                        while (j < slots.size()) {
                            if (slots.get(j).getId().equals(agreeID)) {
                                headSlot = slots.get(j);
                                if (headSlot instanceof NLNNounSlot) {
                                    if (((NLNNounSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNNounSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNAdjectiveSlot) {
                                    if (((NLNAdjectiveSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNAdjectiveSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                } else if (headSlot instanceof NLNArticleSlot) {
                                    if (((NLNArticleSlot)headSlot).getAgreesWithID() != null) {
                                        agreeID = ((NLNArticleSlot)headSlot).getAgreesWithID();
                                    } else {
                                        foundHead = true;
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (headSlot != null) {
                        if (headSlot instanceof NLNNounSlot) {
                            number = ((NLNNounSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                gender = this.LQM.getNounEntry(((NLNNounSlot)headSlot).getLexiconEntryIRI(), this.getLanguage()).getGender();
                                caseType = ((NLNNounSlot)headSlot).getCase();
                            }
                        } else if (headSlot instanceof NLNAdjectiveSlot) {
                            number = ((NLNAdjectiveSlot)headSlot).getNumber();
                            if (Languages.isGreek(this.getLanguage())) {
                                gender = ((NLNAdjectiveSlot)headSlot).getGender();
                                caseType = ((NLNAdjectiveSlot)headSlot).getCase();
                            }
                        }
                    }
                } else {
                    number = article.getNumber();
                    gender = article.getGender();
                    caseType = article.getCase();
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    if (article.isDefinite()) {
                        realizedArticle = EnglishArticles.getDefiniteArticle();
                    } else if (number.equals("singular")) {
                        realizedArticle = i < realizedSlots.size() ? EnglishArticles.getIndefiniteArticle((String)realizedSlots.get(i)) : EnglishArticles.getIndefiniteArticle("");
                    }
                } else if (Languages.isGreek(this.getLanguage())) {
                    realizedArticle = article.isDefinite() ? (i < realizedSlots.size() ? GreekArticles.getDefiniteArticle(gender, number, caseType, (String)realizedSlots.get(i)) : GreekArticles.getDefiniteArticle(gender, number, caseType, "")) : GreekArticles.getIndefiniteArticle(gender, number, caseType);
                }
                realizedSlots.add(i, realizedArticle);
            }
            ++i;
        }
        boolean isLast = true;
        boolean isBeforeLast = true;
        int i2 = realizedSlots.size() - 1;
        while (i2 >= 0) {
            if (((String)realizedSlots.get(i2)).equals("&&")) {
                if (isLast) {
                    realizedSlots.remove(i2);
                    isLast = false;
                } else if (isBeforeLast) {
                    if (Languages.isEnglish(this.getLanguage())) {
                        realizedSlots.set(i2, "and");
                    } else if (Languages.isGreek(this.getLanguage())) {
                        realizedSlots.set(i2, "\u03ba\u03b1\u03b9");
                    }
                    isBeforeLast = false;
                } else {
                    realizedSlots.set(i2, ",");
                }
            } else if (((String)realizedSlots.get(i2)).equals("||")) {
                if (isLast) {
                    realizedSlots.remove(i2);
                    isLast = false;
                } else if (isBeforeLast) {
                    if (Languages.isEnglish(this.getLanguage())) {
                        realizedSlots.set(i2, "or");
                    } else if (Languages.isGreek(this.getLanguage())) {
                        realizedSlots.set(i2, "\u03ae");
                    }
                    isBeforeLast = false;
                } else {
                    realizedSlots.set(i2, ",");
                }
            }
            --i2;
        }
        String realizedName = "";
        int i3 = 0;
        while (i3 < realizedSlots.size()) {
            if (useBullets) {
                if (i3 == 0) {
                    realizedName = String.valueOf(realizedName) + "<ul><li>";
                } else if (((String)realizedSlots.get(i3 - 1)).equals(",") || ((String)realizedSlots.get(i3 - 1)).equals("and") || ((String)realizedSlots.get(i3 - 1)).equals("\u03ba\u03b1\u03b9") || ((String)realizedSlots.get(i3 - 1)).equals("or") || ((String)realizedSlots.get(i3 - 1)).equals("\u03ae")) {
                    realizedName = String.valueOf(realizedName) + "<li>";
                }
            }
            realizedName = String.valueOf(realizedName) + " " + (String)realizedSlots.get(i3);
            if (useBullets) {
                if (i3 == realizedSlots.size() - 1) {
                    realizedName = String.valueOf(realizedName) + "</li></ul>";
                } else if (((String)realizedSlots.get(i3)).equals(",") || ((String)realizedSlots.get(i3)).equals("and") || ((String)realizedSlots.get(i3)).equals("\u03ba\u03b1\u03b9") || ((String)realizedSlots.get(i3)).equals("or") || ((String)realizedSlots.get(i3)).equals("\u03ae")) {
                    realizedName = String.valueOf(realizedName) + "</li>";
                }
            }
            ++i3;
        }
        return realizedName.trim();
    }

    private String generateRefExpressionForAnonEntity(Node slot, IRI superIRI, String gender, String number, String caseType) {
        if (this.NLNQM.getNLName(superIRI, this.getLanguage()) == null) {
            this.setProducedRE(slot, PROD_RE_BAD);
            return "[NOT FOUND next Filler]";
        }
        if (this.NLNQM.getNLName(superIRI, this.getLanguage()) != null) {
            String ret = "";
            NLNSlot head = this.NLNQM.getNLName(superIRI, this.getLanguage()).getHeadSlot();
            if (head != null) {
                if (head instanceof NLNNounSlot) {
                    if (gender.isEmpty()) {
                        gender = this.LQM.getNounEntry(((NLNNounSlot)head).getLexiconEntryIRI(), this.getLanguage()).getGender();
                    }
                    if (number.isEmpty()) {
                        number = ((NLNNounSlot)head).getNumber();
                    }
                } else if (head instanceof NLNAdjectiveSlot) {
                    if (gender.isEmpty()) {
                        gender = ((NLNAdjectiveSlot)head).getGender();
                    }
                    if (number.isEmpty()) {
                        number = ((NLNAdjectiveSlot)head).getNumber();
                    }
                }
            }
            if (number.isEmpty()) {
                number = "singular";
            }
            if (XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "forDomainIndependentProperty").equals(NLResourceManager.isA.getIRI().toString()) || XmlMsgs.getAttribute(slot.getParentNode(), XmlMsgs.prefix, "forDomainIndependentProperty").equals(NLResourceManager.instanceOf.getIRI().toString())) {
                if (Languages.isGreek(this.getLanguage())) {
                    ret = this.realizeNLName(this.NLNQM.getNLName(superIRI, this.getLanguage()), caseType, number, gender, 1);
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").equals("FOCUSLevel1")) {
                        if (caseType.equals("genitive")) {
                            this.setProducedRE(slot, PROD_RE_NP);
                            return GreekArticles.getDefiniteArticle(gender, number, caseType, ret);
                        }
                        this.setProducedRE(slot, PROD_RE_NULL);
                        return "";
                    }
                    if (!this.isREAuto(slot)) {
                        return this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, ret);
                    }
                    this.setProducedRE(slot, PROD_RE_Demonstrative);
                    return GreekArticles.getPronoun(gender, number, caseType, false);
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").equals("FOCUSLevel1")) {
                        this.setProducedRE(slot, PROD_RE_Pronoun);
                        String prn = EnglishArticles.getPronoun(caseType, number, gender);
                        return prn;
                    }
                    ret = this.realizeNLName(this.NLNQM.getNLName(superIRI, this.getLanguage()), caseType, number, gender, 1);
                    if (!this.isREAuto(slot)) {
                        return this.generateRefExpressionFromUserChoice(slot, gender, number, caseType, ret);
                    }
                    this.setProducedRE(slot, PROD_RE_Demonstrative);
                    return EnglishArticles.getDemonstrativePronoun(number);
                }
            } else {
                if (Languages.isEnglish(this.getLanguage())) {
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").equals("FOCUSLevel1")) {
                        this.setProducedRE(slot, PROD_RE_Pronoun);
                        String prn = EnglishArticles.getPronoun(caseType, number, gender);
                        return prn;
                    }
                    ret = this.realizeNLName(this.NLNQM.getNLName(superIRI, this.getLanguage()), caseType, number, gender, 1);
                    if (ret.isEmpty()) {
                        this.setProducedRE(slot, PROD_RE_BAD);
                        return "[NOUN OR CANNED TEXT NOT FOUND]";
                    }
                    this.setProducedRE(slot, PROD_RE_Demonstrative);
                    return String.valueOf(EnglishArticles.getDemonstrativePronoun(number)) + " " + ret;
                }
                if (Languages.isGreek(this.getLanguage())) {
                    ret = this.realizeNLName(this.NLNQM.getNLName(superIRI, this.getLanguage()), caseType, number, gender, 1);
                    if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").equals("FOCUSLevel1")) {
                        if (caseType.equals("genitive")) {
                            this.setProducedRE(slot, PROD_RE_NP);
                            return GreekArticles.getDefiniteArticle(gender, number, caseType, ret);
                        }
                        this.setProducedRE(slot, PROD_RE_NULL);
                        return "";
                    }
                    if (ret.isEmpty()) {
                        this.setProducedRE(slot, PROD_RE_BAD);
                        return "[NOUN OR CANNED TEXT NOT FOUND]";
                    }
                    return String.valueOf(GreekArticles.getPronoun(gender, number, caseType, true)) + " " + ret;
                }
                return "[NOUN OR CANNED TEXT NOT FOUND]";
            }
        }
        return "ERROR";
    }

    private String generateRefExpressionForEntity(NLName name, String caseType, String gender, String number, Node slot) {
        if (Languages.isEnglish(this.getLanguage())) {
            String realizedName = this.realizeNLName(name, caseType, number, gender, 0);
            NLNSlot head = name.getHeadSlot();
            if (head != null) {
                if (head instanceof NLNNounSlot) {
                    if (gender.isEmpty()) {
                        gender = this.LQM.getNounEntry(((NLNNounSlot)head).getLexiconEntryIRI(), this.getLanguage()).getGender();
                    }
                    if (number.isEmpty()) {
                        number = ((NLNNounSlot)head).getNumber();
                    }
                } else if (head instanceof NLNAdjectiveSlot) {
                    if (gender.isEmpty()) {
                        gender = ((NLNAdjectiveSlot)head).getGender();
                    }
                    if (number.isEmpty()) {
                        number = ((NLNAdjectiveSlot)head).getNumber();
                    }
                }
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel4") == 0) {
                if (this.exist("previous", slot.getParentNode().getAttributes())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return realizedName;
                }
                this.setProducedRE(slot, PROD_RE_NP);
                return realizedName;
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel3") == 0) {
                if (this.exist("previous", slot.getParentNode().getAttributes())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return realizedName;
                }
                if (this.realizedText.lastIndexOf(" the") > this.realizedText.length() - 6) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return realizedName;
                }
                this.setProducedRE(slot, PROD_RE_NP);
                return realizedName;
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel2") == 0) {
                if (this.exist("previous", slot.getParentNode().getAttributes())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return realizedName;
                }
                this.setProducedRE(slot, PROD_RE_NP);
                return realizedName;
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel1") == 0) {
                this.setProducedRE(slot, PROD_RE_Pronoun);
                String prn = EnglishArticles.getPronoun(caseType, number, gender);
                return prn;
            }
        } else if (Languages.isGreek(this.getLanguage())) {
            String realizedName = this.realizeNLName(name, caseType, number, gender, 0);
            NLNSlot head = name.getHeadSlot();
            if (head != null) {
                if (head instanceof NLNNounSlot) {
                    if (gender.isEmpty()) {
                        gender = this.LQM.getNounEntry(((NLNNounSlot)head).getLexiconEntryIRI(), this.getLanguage()).getGender();
                    }
                    if (number.isEmpty()) {
                        number = ((NLNNounSlot)head).getNumber();
                    }
                } else if (head instanceof NLNAdjectiveSlot) {
                    if (gender.isEmpty()) {
                        gender = ((NLNAdjectiveSlot)head).getGender();
                    }
                    if (number.isEmpty()) {
                        number = ((NLNAdjectiveSlot)head).getNumber();
                    }
                }
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel4") == 0) {
                if (this.exist("previous", slot.getParentNode().getAttributes())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return realizedName;
                }
                this.setProducedRE(slot, PROD_RE_NP);
                return String.valueOf(GreekArticles.getDefiniteArticle(gender, "singular", caseType, realizedName)) + " " + realizedName;
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel3") == 0) {
                this.setProducedRE(slot, PROD_RE_NP);
                if (!realizedName.startsWith(GreekArticles.getDefiniteArticle(gender, number, caseType, realizedName))) {
                    return String.valueOf(GreekArticles.getDefiniteArticle(gender, number, caseType, realizedName)) + " " + realizedName;
                }
                return realizedName;
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel2") == 0) {
                if (this.exist("previous", slot.getParentNode().getAttributes())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return realizedName;
                }
                this.setProducedRE(slot, PROD_RE_NP);
                if (!realizedName.startsWith(GreekArticles.getDefiniteArticle(gender, number, caseType, realizedName))) {
                    return String.valueOf(GreekArticles.getDefiniteArticle(gender, "singular", caseType, realizedName)) + " " + realizedName;
                }
                return realizedName;
            }
            if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_FOCUS").compareTo("FOCUSLevel1") == 0) {
                if (caseType.compareTo("genitive") == 0) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return GreekArticles.getDefiniteArticle(gender, number, caseType, realizedName);
                }
                this.setProducedRE(slot, PROD_RE_NULL);
                return "";
            }
        }
        return "ERROR";
    }

    public boolean isREAuto(Node Slot) {
        return XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "RE_TYPE").compareTo("auto") == 0 || XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "RE_TYPE").compareTo("") == 0;
    }

    public void removePreviousWords() {
        if (this.realizedText.indexOf(",") < 0 && this.realizedText.indexOf(".") < 0) {
            if (this.getLanguage().equalsIgnoreCase("El")) {
                String tmp = this.realizedText.substring(0, this.realizedText.indexOf("\u03b5\u03af\u03bd\u03b1\u03b9"));
                this.realizedText.delete(0, this.realizedText.length() - 1);
                this.realizedText.append(tmp).append("\u03b5\u03af\u03bd\u03b1\u03b9 ");
            } else {
                String tmp = this.realizedText.substring(0, this.realizedText.indexOf("is"));
                this.realizedText.delete(0, this.realizedText.length() - 1);
                this.realizedText.append(tmp).append("is ");
            }
        }
    }

    public boolean exist(String name, NamedNodeMap map) {
        int i = 0;
        while (i < map.getLength()) {
            if (map.item(i).getLocalName().equalsIgnoreCase(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String generateRefExpressionFromUserChoice(Node slot, String gender, String number, String caseType, String text) {
        if (XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_TYPE").compareTo("auto") != 0) {
            String retype = XmlMsgs.getAttribute(slot, XmlMsgs.prefix, "RE_TYPE");
            if (retype.compareTo("pronoun") == 0) {
                if (Languages.isEnglish(this.getLanguage())) {
                    this.setProducedRE(slot, PROD_RE_Pronoun);
                    return EnglishArticles.getPronoun(caseType, number, gender);
                }
                if (Languages.isGreek(this.getLanguage())) {
                    this.setProducedRE(slot, PROD_RE_NULL);
                    return "";
                }
            } else if (retype.compareTo("demonstrative") == 0) {
                if (Languages.isEnglish(this.getLanguage())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return "this " + text;
                }
                if (Languages.isGreek(this.getLanguage())) {
                    this.setProducedRE(slot, PROD_RE_NP);
                    return String.valueOf(GreekArticles.getPronoun(gender, number, caseType, true)) + " " + text;
                }
            } else {
                this.setProducedRE(slot, PROD_RE_BAD);
                return "ERROR";
            }
        }
        return "GREforNotAnonEntity did not procused an appropriate referring expression";
    }

    public AnnotatedDescription getAnnotatedDescription() {
        return this.annotatedDescription;
    }

    private void setProducedRE(Node slot, String type) {
        ((Element)slot).setAttribute("nlowl:Produced_RE", type);
        if (XmlMsgs.compare(slot, XmlMsgs.prefix, "owner")) {
            this.setREROLE(slot, "owner");
        } else {
            this.setREROLE(slot, "filler");
        }
    }

    private String getProducedRE(Node Slot) {
        Node nd;
        if (Slot.getAttributes() != null && (nd = Slot.getAttributes().getNamedItem("nlowl:Produced_RE")) != null) {
            return nd.getTextContent();
        }
        return "NOT_FOUND_RE";
    }

    private String getRERole(Node Slot) {
        Node nd;
        if (Slot.getAttributes() != null && (nd = Slot.getAttributes().getNamedItem("nlowl:role")) != null) {
            return nd.getTextContent();
        }
        return "NOT_FOUND_RE_ROLE";
    }

    private void setREROLE(Node Slot, String type) {
        ((Element)Slot).setAttribute("nlowl:role", type);
    }

    private String getForProperty(Node Slot) {
        return XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "forProperty");
    }

    private String getInterest(Node Slot) {
        return XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "interest");
    }

    private String getAssimilation(Node Slot) {
        return XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "AssimilationScore");
    }

    private String getRef(Node Slot) {
        return XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "ref");
    }

    private String getPrep(Node Slot) {
        return XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "Prep");
    }

    public void setSectionParagraphs(boolean sectionParagraphs) {
        this.sectionParagraphs = sectionParagraphs;
    }

    public boolean isGenerateReferringExpressions() {
        return this.generateReferringExpressions;
    }

    public void setGenerateReferringExpressions(boolean generateReferringExpressions) {
        this.generateReferringExpressions = generateReferringExpressions;
    }

    public boolean isAnnotateGeneratedResources() {
        return this.annotateGeneratedResources;
    }

    public void setAnnotateGeneratedResources(boolean annotateGeneratedResources) {
        this.annotateGeneratedResources = annotateGeneratedResources;
    }
}

