/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLGEngine;

import gr.aueb.cs.nlg.Comparisons.Comparison;
import gr.aueb.cs.nlg.Comparisons.ComparisonTree;
import gr.aueb.cs.nlg.Comparisons.MelegkoglouAlgorithm;
import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.LexiconQueryManager;
import gr.aueb.cs.nlg.NLFiles.MappingQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNArticleSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLNameQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.OrderingQueryManager;
import gr.aueb.cs.nlg.NLFiles.SentencePlanQueryManager;
import gr.aueb.cs.nlg.NLFiles.UserModel;
import gr.aueb.cs.nlg.NLFiles.UserModelQueryManager;
import gr.aueb.cs.nlg.NLGEngine.Aggregation;
import gr.aueb.cs.nlg.NLGEngine.AnnotatedDescription;
import gr.aueb.cs.nlg.NLGEngine.ContentSelection;
import gr.aueb.cs.nlg.NLGEngine.ILPEngine;
import gr.aueb.cs.nlg.NLGEngine.Lexicalisation;
import gr.aueb.cs.nlg.NLGEngine.ReferringExpressionsGenerator;
import gr.aueb.cs.nlg.NLGEngine.SurfaceRealization;
import gr.aueb.cs.nlg.Utils.NLGUser;
import gr.aueb.cs.nlg.Utils.XmlDocumentCreator;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NLGEngine {
    public static final int ENGINE_PIPELINE_MODEL = 0;
    public static final int ENGINE_ILP_MODEL = 1;
    public static final int ENGINE_ILP_APPROXIMATION_MODEL = 2;
    private OWLOntologyManager manager = null;
    private File domainOwlFile = null;
    private File NLOwlFile = null;
    private String lang;
    private int mode;
    private int useEngine = 0;
    private boolean useSlotLimit = false;
    private boolean allowComparisons = false;
    private XmlDocumentCreator XmlDocCreator;
    private SentencePlanQueryManager SPQM;
    private LexiconQueryManager LQM;
    private NLNameQueryManager NLNQM;
    private UserModelQueryManager UMQM;
    private MappingQueryManager MQM;
    private OrderingQueryManager OQM;
    private ContentSelection CS;
    private Lexicalisation LEX;
    private Aggregation AGGRGT;
    private ReferringExpressionsGenerator genRefExpr;
    private SurfaceRealization SR;
    private ILPEngine ILPEn;
    private XmlMsgs messagesAfterContentSelection;
    private ArrayList<String> stagesOutputs;
    private double lamda = 0.5;
    private int maxSentences = 3;
    private int maxSlotsPerSentence = 10;
    public List<?> charComparison;
    private AnnotatedDescription AD;
    private ComparisonTree comparisonTree;
    private ComparisonTree fullTree;

    public NLGEngine() {
    }

    public void setGenerateReferringExpressions(boolean b) {
        this.SR.setGenerateReferringExpressions(b);
    }

    public void setAnnotateGeneratedResources(boolean b) {
        this.SR.setAnnotateGeneratedResources(b);
    }

    public void setUseNLNames(boolean b) {
        this.MQM.setUseNLNames(b);
    }

    public void setUseSentencePlans(boolean b) {
        this.MQM.setUseSentencePlans(b);
    }

    public ContentSelection getCS() {
        return this.CS;
    }

    public void setCS(ContentSelection CS) {
        this.CS = CS;
    }

    public SurfaceRealization getSR() {
        return this.SR;
    }

    public void reset() {
        this.comparisonTree = new ComparisonTree(this.manager, this.MQM);
    }

    public LexiconQueryManager getLexicon() {
        return this.LQM;
    }

    public NLGEngine(String domainOwlPath, String NLResourcesOwlPath, String lang) {
        NLResourceManager resourcesManager;
        this.XmlDocCreator = new XmlDocumentCreator();
        this.lang = lang;
        this.domainOwlFile = new File(domainOwlPath);
        if (this.domainOwlFile.exists()) {
            this.manager = OWLManager.createOWLOntologyManager();
            try {
                OWLOntology ontology = this.manager.loadOntologyFromOntologyDocument(this.domainOwlFile);
                System.err.println("Loaded ontology: " + ontology);
                Set imports = ontology.getImportsClosure();
                for (OWLOntology importOnt : imports) {
                    IRI importOntIRI = this.manager.getOntologyDocumentIRI(importOnt);
                    if (importOntIRI.getScheme().equals("http")) {
                        try {
                            this.manager.loadOntology(importOntIRI);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!importOntIRI.getScheme().equals("file")) continue;
                    try {
                        this.manager.removeOntology(this.manager.getOntology(importOnt.getOntologyID()));
                        this.manager.loadOntologyFromOntologyDocument(importOntIRI);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (OWLOntologyCreationException ontology) {
            }
            catch (UnknownOWLOntologyException ontology) {
                // empty catch block
            }
        }
        this.NLOwlFile = new File(NLResourcesOwlPath);
        if (this.NLOwlFile.exists()) {
            resourcesManager = new NLResourceManager();
            resourcesManager.loadNLResourcesModel(this.NLOwlFile);
            this.LQM = new LexiconQueryManager(resourcesManager);
            this.LQM.importLexiconEntries(resourcesManager.getNLResourcesModel());
            for (OWLOntology model : this.manager.getOntologies()) {
                this.LQM.importLexiconEntries(model);
            }
            this.SPQM = new SentencePlanQueryManager(resourcesManager);
            this.SPQM.importSentencePlans(resourcesManager.getNLResourcesModel());
            for (OWLOntology model : this.manager.getOntologies()) {
                this.SPQM.importSentencePlans(model);
            }
            this.NLNQM = new NLNameQueryManager(resourcesManager);
            this.NLNQM.importNLNames(resourcesManager.getNLResourcesModel());
            for (OWLOntology model : this.manager.getOntologies()) {
                this.NLNQM.importNLNames(model);
            }
            this.UMQM = new UserModelQueryManager(resourcesManager);
            this.UMQM.importUserModels(resourcesManager.getNLResourcesModel());
            for (OWLOntology model : this.manager.getOntologies()) {
                this.UMQM.importUserModels(model);
                this.UMQM.importAnnotationEvents(model);
            }
            this.MQM = new MappingQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.MQM.importMappings(model);
            }
            this.OQM = new OrderingQueryManager(resourcesManager);
            this.OQM.importSections(resourcesManager.getNLResourcesModel());
            this.OQM.importOrdering(resourcesManager.getNLResourcesModel());
            for (OWLOntology model : this.manager.getOntologies()) {
                this.OQM.importSections(model);
                this.OQM.importOrdering(model);
            }
            this.initializeNLGModules();
        } else {
            resourcesManager = new NLResourceManager();
            this.LQM = new LexiconQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.LQM.importLexiconEntries(model);
            }
            this.SPQM = new SentencePlanQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.SPQM.importSentencePlans(model);
            }
            this.NLNQM = new NLNameQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.NLNQM.importNLNames(model);
            }
            this.UMQM = new UserModelQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.UMQM.importUserModels(model);
                this.UMQM.importAnnotationEvents(model);
            }
            this.MQM = new MappingQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.MQM.importMappings(model);
            }
            this.OQM = new OrderingQueryManager(resourcesManager);
            for (OWLOntology model : this.manager.getOntologies()) {
                this.OQM.importSections(model);
                this.OQM.importOrdering(model);
            }
            this.initializeNLGModules();
        }
    }

    public NLGEngine(OWLOntologyManager ontologyManager, LexiconQueryManager LQMan, SentencePlanQueryManager SPQMan, NLNameQueryManager NLNQMan, UserModelQueryManager UMQMan, MappingQueryManager MQMan, OrderingQueryManager OQMan, String lang) {
        this.XmlDocCreator = new XmlDocumentCreator();
        this.manager = ontologyManager;
        this.lang = lang;
        this.LQM = LQMan;
        this.SPQM = SPQMan;
        this.NLNQM = NLNQMan;
        this.UMQM = UMQMan;
        this.MQM = MQMan;
        this.OQM = OQMan;
        this.initializeNLGModules();
    }

    public void buildTree() {
        if (this.manager == null) {
            return;
        }
        for (OWLOntology model : this.manager.getOntologies()) {
            Set entities = model.getIndividualsInSignature();
            for (OWLNamedIndividual entity : entities) {
                if (model.containsClassInSignature(entity.getIRI())) continue;
                this.fullTree.add(entity.getIRI());
            }
        }
    }

    public boolean areAllFactsAssimilated() {
        return this.CS.allFactsAreAssimilated();
    }

    private void initializeNLGModules() {
        this.CS = new ContentSelection(this.manager.getOntologies(), this.SPQM, this.NLNQM, this.UMQM, this.MQM, this.OQM, this.lang);
        this.LEX = new Lexicalisation(this.manager.getOntologies(), this.SPQM, this.lang);
        this.AGGRGT = new Aggregation(this.SPQM, this.NLNQM, this.LQM, this.lang);
        this.genRefExpr = new ReferringExpressionsGenerator(this.lang);
        this.SR = new SurfaceRealization(this.manager.getOntologies(), this.NLNQM, this.LQM, this.MQM, this.OQM, this.lang);
        this.ILPEn = new ILPEngine(this.SPQM, this.MQM, this.lang);
        this.comparisonTree = new ComparisonTree(this.manager, this.MQM);
        this.fullTree = new ComparisonTree(this.manager, this.MQM);
    }

    public void refreshNLGModules(Set<OWLOntology> new_models, String mylang) {
        this.CS = new ContentSelection(new_models, this.SPQM, this.NLNQM, this.UMQM, this.MQM, this.OQM, mylang);
        this.LEX = new Lexicalisation(new_models, this.SPQM, mylang);
        this.AGGRGT = new Aggregation(this.SPQM, this.NLNQM, this.LQM, mylang);
        this.genRefExpr = new ReferringExpressionsGenerator(mylang);
        this.SR = new SurfaceRealization(new_models, this.NLNQM, this.LQM, this.MQM, this.OQM, mylang);
        this.ILPEn = new ILPEngine(this.SPQM, this.MQM, mylang);
    }

    public String[] generateDescription(IRI entityIRI, NLGUser user, int depth, double lamda, int maxSentences, int maxSlotsPerSentence) {
        this.setLamda(lamda);
        this.setMaxSentences(maxSentences);
        this.setMaxSlotsPerSentence(maxSlotsPerSentence);
        return this.generateDescription(entityIRI, user, depth);
    }

    public String[] generateDescription(IRI entityIRI, NLGUser user, int depth) {
        this.stagesOutputs = new ArrayList();
        String[] result = new String[]{"", "", ""};
        if (user != null && user.getUserModel() != null) {
            if (user.getUserModel().getMaxMessagesPerSentence() != -1) {
                this.AGGRGT.setMaxMessagesPerSentence(user.getUserModel().getMaxMessagesPerSentence());
            }
        } else {
            user = new NLGUser("default", this.UMQM.getGlobalUserModel());
            this.AGGRGT.setMaxMessagesPerSentence(1);
        }
        String textResult = "";
        XmlMsgs messages = NLGEngine.isClass(this.manager.getOntologies(), entityIRI) ? new XmlMsgs(entityIRI.toString(), 0, this.XmlDocCreator.getNewDocument()) : new XmlMsgs(entityIRI.toString(), 1, this.XmlDocCreator.getNewDocument());
        this.CS.clearBuffers();
        this.CS.setNamespaces(messages);
        messages = this.CS.getMessages(entityIRI, messages, messages.getRoot(), depth, user);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        if (messages.getMessages().isEmpty()) {
            System.err.println("No facts could be retrieved!");
        }
        this.CS.setAssimilationON(true);
        this.CS.setInterestON(true);
        messages = this.CS.getTheMostInterestingUnassimilatedFacts(messages, depth, user);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection/Most Interesting Not Assimilated Facts---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        boolean enforceILPDecisions = false;
        boolean enforceSlotLimit = false;
        if (messages.getMessages().size() > 0) {
            if (this.useEngine == 1) {
                messages = this.ILPEn.createAndSolveILPNLG(messages, this.lamda, this.maxSentences, this.maxSlotsPerSentence);
                enforceILPDecisions = true;
                enforceSlotLimit = true;
            } else if (this.useEngine == 2) {
                messages = this.ILPEn.createAndApproximateILPNLG(messages, this.lamda, this.maxSentences, this.maxSlotsPerSentence);
                enforceILPDecisions = true;
                enforceSlotLimit = true;
            }
        }
        if (user != null) {
            this.CS.setMentionedEntity(entityIRI);
            this.CS.updateUser(user);
        }
        if (this.allowComparisons) {
            this.findComparisons(entityIRI, user, messages);
        }
        messages.sortByOrder();
        textResult = String.valueOf(textResult) + "\n" + "---Ordering---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        this.messagesAfterContentSelection = messages;
        messages = this.LEX.lexicalizeInstances(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Lexicalisation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = enforceSlotLimit ? this.AGGRGT.aggregate(messages, enforceILPDecisions, enforceSlotLimit) : this.AGGRGT.aggregate(messages, enforceILPDecisions, this.useSlotLimit);
        textResult = String.valueOf(textResult) + "\n" + "---Aggregation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.genRefExpr.generateReferringExpressions(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Referring expressions---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        String RT = this.SR.realizeMessages(messages, user);
        textResult = String.valueOf(textResult) + "\n" + "---Surface Realization---" + "\n";
        this.stagesOutputs.add(RT);
        result[0] = textResult = String.valueOf(textResult) + "\n" + RT + "\n";
        result[1] = RT;
        this.SR.getAnnotatedDescription().removeLastPeriod();
        this.AD = this.SR.getAnnotatedDescription();
        result[2] = this.AD.getAnnotatedXml();
        return result;
    }

    public String[] generateSingleObjectDescription(IRI entityIRI, IRI propertyIRI, IRI fillerObject, NLGUser user) {
        this.stagesOutputs = new ArrayList();
        String[] result = new String[]{"", "", ""};
        if (user != null && user.getUserModel() != null) {
            if (user.getUserModel().getMaxMessagesPerSentence() != -1) {
                this.AGGRGT.setMaxMessagesPerSentence(user.getUserModel().getMaxMessagesPerSentence());
            }
        } else {
            user = new NLGUser("default", this.UMQM.getGlobalUserModel());
            this.AGGRGT.setMaxMessagesPerSentence(1);
        }
        String textResult = "";
        XmlMsgs messages = NLGEngine.isClass(this.manager.getOntologies(), entityIRI) ? new XmlMsgs(entityIRI.toString(), 0, this.XmlDocCreator.getNewDocument()) : new XmlMsgs(entityIRI.toString(), 1, this.XmlDocCreator.getNewDocument());
        this.CS.clearBuffers();
        this.CS.setNamespaces(messages);
        messages = this.CS.getSingleObjectMessages(entityIRI, propertyIRI, fillerObject, messages, messages.getRoot(), user);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        if (messages.getMessages().isEmpty()) {
            System.err.println("No facts could be retrieved!");
        }
        this.CS.setAssimilationON(false);
        this.CS.setInterestON(false);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection/Most Interesting Not Assimilated Facts---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        this.messagesAfterContentSelection = messages;
        messages = this.LEX.lexicalizeInstances(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Lexicalisation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.AGGRGT.aggregate(messages, false, false);
        textResult = String.valueOf(textResult) + "\n" + "---Aggregation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.genRefExpr.generateReferringExpressions(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Referring expressions---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        String RT = this.SR.realizeMessages(messages, user);
        textResult = String.valueOf(textResult) + "\n" + "---Surface Realization---" + "\n";
        this.stagesOutputs.add(RT);
        result[0] = textResult = String.valueOf(textResult) + "\n" + RT + "\n";
        result[1] = RT;
        this.SR.getAnnotatedDescription().removeLastPeriod();
        this.AD = this.SR.getAnnotatedDescription();
        result[2] = this.AD.getAnnotatedXml();
        return result;
    }

    public String[] generateSingleDataDescription(IRI entityIRI, IRI propertyIRI, OWLLiteral filler, NLGUser user) {
        this.stagesOutputs = new ArrayList();
        String[] result = new String[]{"", "", ""};
        if (user != null && user.getUserModel() != null) {
            if (user.getUserModel().getMaxMessagesPerSentence() != -1) {
                this.AGGRGT.setMaxMessagesPerSentence(user.getUserModel().getMaxMessagesPerSentence());
            }
        } else {
            user = new NLGUser("default", this.UMQM.getGlobalUserModel());
            this.AGGRGT.setMaxMessagesPerSentence(1);
        }
        String textResult = "";
        XmlMsgs messages = NLGEngine.isClass(this.manager.getOntologies(), entityIRI) ? new XmlMsgs(entityIRI.toString(), 0, this.XmlDocCreator.getNewDocument()) : new XmlMsgs(entityIRI.toString(), 1, this.XmlDocCreator.getNewDocument());
        this.CS.clearBuffers();
        this.CS.setNamespaces(messages);
        messages = this.CS.getSingleDataMessages(entityIRI, propertyIRI, filler, messages, messages.getRoot(), user);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        if (messages.getMessages().isEmpty()) {
            System.err.println("No facts could be retrieved!");
        }
        this.CS.setAssimilationON(false);
        this.CS.setInterestON(false);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection/Most Interesting Not Assimilated Facts---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        this.messagesAfterContentSelection = messages;
        messages = this.LEX.lexicalizeInstances(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Lexicalisation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.AGGRGT.aggregate(messages, false, false);
        textResult = String.valueOf(textResult) + "\n" + "---Aggregation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.genRefExpr.generateReferringExpressions(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Referring expressions---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        String RT = this.SR.realizeMessages(messages, user);
        textResult = String.valueOf(textResult) + "\n" + "---Surface Realization---" + "\n";
        this.stagesOutputs.add(RT);
        result[0] = textResult = String.valueOf(textResult) + "\n" + RT + "\n";
        result[1] = RT;
        this.SR.getAnnotatedDescription().removeLastPeriod();
        this.AD = this.SR.getAnnotatedDescription();
        result[2] = this.AD.getAnnotatedXml();
        return result;
    }

    public String[] generateSpecificDescription(IRI subjectIRI, IRI subjectNLNameIRI, IRI propertyIRI, IRI sentencePlanIRI, IRI objectIRI, IRI objectNLNameIRI, NLGUser user) {
        this.stagesOutputs = new ArrayList();
        String[] result = new String[]{"", "", ""};
        String textResult = "";
        XmlMsgs messages = NLGEngine.isClass(this.manager.getOntologies(), subjectIRI) ? new XmlMsgs(subjectIRI.toString(), 0, this.XmlDocCreator.getNewDocument()) : new XmlMsgs(subjectIRI.toString(), 1, this.XmlDocCreator.getNewDocument());
        this.CS.clearBuffers();
        this.CS.setNamespaces(messages);
        messages = this.CS.getSpecificMessage(subjectIRI, subjectNLNameIRI, propertyIRI, sentencePlanIRI, objectIRI, objectNLNameIRI, messages, messages.getRoot(), user);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        if (messages.getMessages().isEmpty()) {
            System.err.println("No facts could be retrieved!");
        }
        this.CS.setAssimilationON(false);
        this.CS.setInterestON(false);
        textResult = String.valueOf(textResult) + "\n" + "---Content Selection/Most Interesting Not Assimilated Facts---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        this.messagesAfterContentSelection = messages;
        messages = this.LEX.lexicalizeInstances(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Lexicalisation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.AGGRGT.aggregate(messages, false, false);
        textResult = String.valueOf(textResult) + "\n" + "---Aggregation---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        messages = this.genRefExpr.generateReferringExpressions(messages);
        textResult = String.valueOf(textResult) + "\n" + "---Referring expressions---" + "\n";
        this.stagesOutputs.add(messages.getStringDescription(true));
        textResult = String.valueOf(textResult) + " " + messages.getStringDescription(true);
        String RT = this.SR.realizeMessages(messages, user);
        textResult = String.valueOf(textResult) + "\n" + "---Surface Realization---" + "\n";
        this.stagesOutputs.add(RT);
        result[0] = textResult = String.valueOf(textResult) + "\n" + RT + "\n";
        result[1] = RT;
        this.SR.getAnnotatedDescription().removeLastPeriod();
        this.AD = this.SR.getAnnotatedDescription();
        result[2] = this.AD.getAnnotatedXml();
        return result;
    }

    private void findComparisons(IRI entityIRI, NLGUser user, XmlMsgs messages) {
        if (!NLGEngine.isClass(this.manager.getOntologies(), entityIRI)) {
            ComparisonTree tempTree = new ComparisonTree(this.comparisonTree);
            ComparisonTree fulltreetemp = new ComparisonTree(this.fullTree);
            this.comparisonTree.add(entityIRI);
            boolean entityMentioned = false;
            if (tempTree.contains(entityIRI.toString())) {
                tempTree.removeEntity(entityIRI);
                entityMentioned = true;
            }
            MelegkoglouAlgorithm full = new MelegkoglouAlgorithm(fulltreetemp);
            Comparison comparison = full.detectUnique(this.comparisonTree.create(entityIRI));
            boolean isASelected = false;
            for (Node property : messages.getMessages()) {
                if (!property.getNodeName().equals(String.valueOf(XmlMsgs.prefix) + ":" + "isA") && !property.getNodeName().equals(String.valueOf(XmlMsgs.prefix) + ":" + "instanceOf")) continue;
                isASelected = true;
            }
            if (!isASelected && comparison != null) {
                comparison = null;
            }
            if (comparison == null) {
                fulltreetemp = new ComparisonTree(this.fullTree);
                full = new MelegkoglouAlgorithm(fulltreetemp);
                comparison = full.compareFullCollection(this.comparisonTree.create(entityIRI));
            }
            if (comparison == null) {
                fulltreetemp = new ComparisonTree(this.fullTree);
                full = new MelegkoglouAlgorithm(fulltreetemp);
                comparison = full.compareFullCollectionBlur(this.comparisonTree.create(entityIRI));
            }
            MelegkoglouAlgorithm mentioned = new MelegkoglouAlgorithm(tempTree);
            if (comparison == null) {
                comparison = mentioned.compare(this.comparisonTree.create(entityIRI));
            }
            if (comparison == null) {
                comparison = mentioned.compareBlur(this.comparisonTree.create(entityIRI));
            }
            ArrayList<Node> properties = messages.getMessages();
            if (comparison != null) {
                comparison.setLang(this.lang);
                for (Node property : properties) {
                    if (comparison.getProperty().equals(String.valueOf(XmlMsgs.prefix) + ":" + "isA")) {
                        if (!property.getNodeName().equals(String.valueOf(XmlMsgs.prefix) + ":" + "isA") && !property.getNodeName().equals(String.valueOf(XmlMsgs.prefix) + ":" + "instanceOf")) continue;
                        property.getAttributes().item(0).setNodeValue("false");
                        IRI sentencePlanIRI = IRI.create((String)XmlMsgs.getAttribute(property, XmlMsgs.prefix, "sentencePlan"));
                        IRI sentencePlanUniqueIRI = this.MQM.chooseUniqueSentencePlan(sentencePlanIRI, this.SPQM, this.lang);
                        messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", sentencePlanUniqueIRI.toString());
                        ArrayList<IRI> NLNamesIRIs = new ArrayList<IRI>();
                        String NLNameIRIStrings = XmlMsgs.getAttribute(property, XmlMsgs.prefix, "objectNLName");
                        boolean and = NLNameIRIStrings.toLowerCase().startsWith("and(");
                        int i = 0;
                        while (i < NLNameIRIStrings.split(",").length) {
                            IRI NLNameIRI;
                            if (and) {
                                NLNameIRI = IRI.create((String)NLNameIRIStrings.substring(4, NLNameIRIStrings.length()).split(",")[i]);
                                NLNamesIRIs.add(NLNameIRI);
                            } else {
                                NLNameIRI = IRI.create((String)NLNameIRIStrings.substring(3, NLNameIRIStrings.length()).split(",")[i]);
                                NLNamesIRIs.add(NLNameIRI);
                            }
                            ++i;
                        }
                        IRI newIRI = IRI.create((String)((IRI)NLNamesIRIs.get(NLNamesIRIs.size() - 1)).toString().substring(0, ((IRI)NLNamesIRIs.get(NLNamesIRIs.size() - 1)).toString().length() - 1));
                        NLNamesIRIs.set(NLNamesIRIs.size() - 1, newIRI);
                        ArrayList<IRI> NLNameUniqueIRIs = this.MQM.chooseUniqueNLName(NLNamesIRIs, this.NLNQM, this.lang);
                        String names = "";
                        if (NLNameUniqueIRIs.isEmpty()) continue;
                        if (NLNameUniqueIRIs.size() == 1) {
                            names = ((IRI)NLNameUniqueIRIs.get(0)).toString();
                        } else {
                            names = and ? "and(" : "or(";
                            Iterator iterator = NLNameUniqueIRIs.iterator();
                            while (iterator.hasNext()) {
                                IRI name = (IRI)iterator.next();
                                names = String.valueOf(names) + name.toString() + ",";
                            }
                            names = String.valueOf(names.substring(0, names.length() - 1)) + ")";
                        }
                        messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "objectNLName", names);
                        continue;
                    }
                    if (!property.getNodeName().equals(comparison.getProperty())) continue;
                    property.getAttributes().item(0).setNodeValue("false");
                    IRI NLNameIRI = this.MQM.chooseNLName(IRI.create((String)comparison.getComparator()), this.NLNQM, this.lang, user);
                    if (entityMentioned && this.comparisonTree.comparatorIncludes(entityIRI.toString(), comparison.getComparator())) {
                        entityMentioned = false;
                    }
                    IRI NLNameCompIRI = this.MQM.chooseComparisonNLName(NLNameIRI, this.NLNQM, this.lang, comparison, entityMentioned);
                    String gen = "masculineOrFeminine";
                    String number = "singular";
                    NLName valueNLName = null;
                    if (!comparison.isSame() && !comparison.getValueIRI().toString().isEmpty()) {
                        IRI value = this.MQM.chooseNLName(comparison.getValueIRI(), this.NLNQM, this.lang, user);
                        valueNLName = this.NLNQM.getNLName(value);
                        for (NLNSlot slot : valueNLName.getSlotsList()) {
                            if (slot instanceof NLNArticleSlot) {
                                if (!((NLNArticleSlot)slot).getGender().isEmpty()) {
                                    gen = ((NLNArticleSlot)slot).getGender();
                                }
                                if (((NLNArticleSlot)slot).getNumber().isEmpty()) continue;
                                number = ((NLNArticleSlot)slot).getNumber();
                                continue;
                            }
                            if (!(slot instanceof NLNNounSlot) || !((NLNNounSlot)slot).isHead()) continue;
                            gen = this.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.lang).getGender();
                            number = this.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.lang).getNumber();
                        }
                        if (number.equals("both")) {
                            number = "singular";
                        }
                    }
                    IRI sentencePlanIRI = IRI.create((String)XmlMsgs.getAttribute(property, XmlMsgs.prefix, "sentencePlan"));
                    IRI sentencePlanCompIRI = this.MQM.chooseComparisonSentencePlan(sentencePlanIRI, this.SPQM, this.lang, comparison, gen, number, this.SR, NLNameCompIRI);
                    messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", sentencePlanCompIRI.toString());
                    messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "compareTo", comparison.getComparator());
                    messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "comparatorNLName", NLNameCompIRI.toString());
                    messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "compareToFiller", comparison.getValueIRI().toString());
                    if (valueNLName != null) {
                        messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "comparatorFillerNLName", valueNLName.getNLNameIRI().toString());
                    }
                    messages.addStringSlot(property, property.getNodeName(), comparison.getText());
                    gen = "masculineOrFeminine";
                    if (comparison.isMany()) {
                        for (NLNSlot slot : this.NLNQM.getNLName(NLNameCompIRI).getSlotsList()) {
                            if (!(slot instanceof NLNNounSlot) || !((NLNNounSlot)slot).isHead()) continue;
                            gen = this.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.lang).getGender();
                        }
                        for (NLNSlot slot : this.NLNQM.getNLName(NLNameCompIRI).getSlotsList()) {
                            if (!(slot instanceof NLNArticleSlot)) continue;
                            ((NLNArticleSlot)slot).setGender(gen);
                            ((NLNArticleSlot)slot).setNumber("plural");
                            ((NLNArticleSlot)slot).setAgreesWithID(null);
                            if (comparison.isSame()) {
                                ((NLNArticleSlot)slot).setCase("nominative");
                            } else {
                                ((NLNArticleSlot)slot).setCase("accusative");
                            }
                            ((NLNArticleSlot)slot).setDefinite(true);
                        }
                        continue;
                    }
                    for (NLNSlot slot : this.NLNQM.getNLName(NLNameCompIRI).getSlotsList()) {
                        if (slot instanceof NLNNounSlot) {
                            if (!((NLNNounSlot)slot).isHead()) continue;
                            gen = this.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.lang).getGender();
                            continue;
                        }
                        if (!(slot instanceof NLNAdjectiveSlot) || !((NLNAdjectiveSlot)slot).isHead()) continue;
                        gen = this.LQM.getNounEntry(((NLNNounSlot)slot).getLexiconEntryIRI(), this.lang).getGender();
                    }
                    for (NLNSlot slot : this.NLNQM.getNLName(NLNameCompIRI).getSlotsList()) {
                        if (!(slot instanceof NLNArticleSlot)) continue;
                        ((NLNArticleSlot)slot).setGender(gen);
                        ((NLNArticleSlot)slot).setNumber("singular");
                        ((NLNArticleSlot)slot).setAgreesWithID(null);
                        ((NLNArticleSlot)slot).setCase("nominative");
                        ((NLNArticleSlot)slot).setDefinite(true);
                    }
                    messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "compareTo", comparison.getComparator());
                    messages.setAttr((Element)property, NLResourceManager.nlowlNS, XmlMsgs.prefix, "comparatorNLName", NLNameCompIRI.toString());
                }
            }
        }
    }

    public void setLanguage(String lang) {
        this.lang = lang;
        Languages.updateLanguages(this.CS, this.LEX, this.genRefExpr, this.SR, this.AGGRGT, lang);
    }

    public String getLang() {
        return this.lang;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public Set<OWLOntology> getDomainOntologies() {
        return this.manager.getOntologies();
    }

    public Set<IRI> getUserModels() {
        return this.UMQM.getUserModels();
    }

    public UserModel getUserModel(IRI userModelIRI) {
        return this.UMQM.getUserModel(userModelIRI);
    }

    public static boolean isClass(Set<OWLOntology> models, IRI entityIRI) {
        for (OWLOntology model : models) {
            if (!model.containsClassInSignature(entityIRI, true)) continue;
            return true;
        }
        return false;
    }

    public static IRI getClassType(OWLOntology model, IRI instanceIRI) {
        if (model == null) {
            return null;
        }
        Set entities = model.getEntitiesInSignature(instanceIRI, true);
        for (OWLEntity entity : entities) {
            OWLClass superC;
            Set superCs;
            if (entity.isOWLClass()) {
                OWLClass cls = entity.asOWLClass();
                superCs = cls.getSuperClasses(model);
                for (OWLClassExpression expr : superCs) {
                    if (!expr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS) || (superC = expr.asOWLClass()).isAnonymous()) continue;
                    return superC.getIRI();
                }
                continue;
            }
            if (entity.isOWLNamedIndividual()) {
                OWLNamedIndividual ind = entity.asOWLNamedIndividual();
                superCs = ind.getTypes(model);
                for (OWLClassExpression expr : superCs) {
                    if (!expr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS) || (superC = expr.asOWLClass()).isAnonymous()) continue;
                    return superC.getIRI();
                }
                continue;
            }
            return null;
        }
        return null;
    }

    public static ArrayList<IRI> getSuperClasses(IRI indivOrClassIRI, OWLClassExpression expression) {
        ArrayList<IRI> superClasses;
        block6: {
            block5: {
                superClasses = new ArrayList<IRI>();
                if (!expression.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) break block5;
                if (expression.asOWLClass().getIRI().equals((Object)indivOrClassIRI)) break block6;
                superClasses.add(expression.asOWLClass().getIRI());
                break block6;
            }
            if (expression.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) {
                OWLObjectIntersectionOf intersectionOfExpr = (OWLObjectIntersectionOf)expression;
                for (OWLClassExpression conjunctExpr : intersectionOfExpr.asConjunctSet()) {
                    superClasses.addAll(NLGEngine.getSuperClasses(indivOrClassIRI, conjunctExpr));
                }
            } else if (expression.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_UNION_OF)) {
                OWLObjectUnionOf unionOfExpr = (OWLObjectUnionOf)expression;
                for (OWLClassExpression disjunctExpr : unionOfExpr.asDisjunctSet()) {
                    superClasses.addAll(NLGEngine.getSuperClasses(indivOrClassIRI, disjunctExpr));
                }
            }
        }
        return superClasses;
    }

    public String[][] getFactsAndAssimilations() {
        ArrayList<Node> msgs = this.messagesAfterContentSelection.getMessages();
        String[][] array = new String[msgs.size()][2];
        int i = 0;
        while (i < msgs.size()) {
            Node msg = msgs.get(i);
            String sub = XmlMsgs.getAttribute(msg, XmlMsgs.prefix, "ref");
            String obj = XmlMsgs.getAttribute(msg, XmlMsgs.prefix, "value");
            String pred = "";
            String score = XmlMsgs.getAttribute(msg, XmlMsgs.prefix, "AssimilationScore");
            pred = msg.getNodeName().equals("nlowl:type") ? "http://www.w3.org/1999/02/22-rdf-syntax-ns#type" : String.valueOf(msg.getNamespaceURI()) + msg.getLocalName();
            array[i][0] = "[" + sub + ", " + pred + ", " + obj + "]";
            array[i][1] = score;
            ++i;
        }
        return array;
    }

    public AnnotatedDescription getAnnotatedText() {
        return this.AD;
    }

    public SentencePlanQueryManager getSentencePlanQueryManager() {
        return this.SPQM;
    }

    public NLNameQueryManager getNLNameQueryManager() {
        return this.NLNQM;
    }

    public MappingQueryManager getMappingQueryManager() {
        return this.MQM;
    }

    public LexiconQueryManager getLexiconQueryManager() {
        return this.LQM;
    }

    public void setUseEngine(int engine) {
        this.useEngine = engine;
    }

    public void setUseSlotLimit(boolean use) {
        this.useSlotLimit = use;
    }

    public void setMaxSentences(int max) {
        this.maxSentences = max;
    }

    public void setMaxSlotsPerSentence(int max) {
        this.maxSlotsPerSentence = max;
        this.AGGRGT.setMaxSlotsPerSentence(max);
    }

    public void setLamda(double l) {
        this.lamda = l;
    }

    public void setSectionParagraphs(boolean sp) {
        this.SR.setSectionParagraphs(sp);
    }

    public void setOverrideMaxMessagesPerSentence(int value) {
        this.AGGRGT.setOverrideMaxMessagesPerSentence(value);
    }

    public void setAllowComparisons(boolean value) {
        this.allowComparisons = value;
    }

    public boolean isUniqueIRI(IRI entryIRI) {
        if (DefaultResourcesManager.isDefaultResource(entryIRI)) {
            return false;
        }
        if (this.LQM.isNoun(entryIRI)) {
            return false;
        }
        if (this.LQM.isAdjective(entryIRI)) {
            return false;
        }
        if (this.LQM.isVerb(entryIRI)) {
            return false;
        }
        if (this.SPQM.getSentencePlansList("en").containsSentencePlan(entryIRI)) {
            return false;
        }
        if (this.SPQM.getSentencePlansList("el").containsSentencePlan(entryIRI)) {
            return false;
        }
        if (this.NLNQM.getNLNamesList("en").containsNLName(entryIRI)) {
            return false;
        }
        if (this.NLNQM.getNLNamesList("el").containsNLName(entryIRI)) {
            return false;
        }
        if (this.OQM.getOrderedSections().contains(entryIRI)) {
            return false;
        }
        return !this.UMQM.getUserModels().contains(entryIRI);
    }
}

