/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLGEngine;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SPAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.SPComparatorFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPComparatorSlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationPropertySlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationSlot;
import gr.aueb.cs.nlg.NLFiles.SPFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPNounSlot;
import gr.aueb.cs.nlg.NLFiles.SPOwnerSlot;
import gr.aueb.cs.nlg.NLFiles.SPPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SPStringSlot;
import gr.aueb.cs.nlg.NLFiles.SPVerbSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlanQueryManager;
import gr.aueb.cs.nlg.NLGEngine.NLGEngineComponent;
import gr.aueb.cs.nlg.Utils.Fact;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.w3c.dom.Node;

public class Lexicalisation
extends NLGEngineComponent {
    public static final String MAX_CARDINALITY_EN = "at most";
    public static final String MAX_CARDINALITY_GR = "\u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf";
    public static final String MIN_CARDINALITY_EN = "at least";
    public static final String MIN_CARDINALITY_GR = "\u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf";
    public static final String EXACT_CARDINALITY_EN = "exactly";
    public static final String EXACT_CARDINALITY_GR = "\u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2";
    public static final String ALL_VALUES_CARDINALITY_EN = "only";
    public static final String ALL_VALUES_CARDINALITY_GR = "\u03bc\u03cc\u03bd\u03bf";
    public static final String SOME_VALUES_CARDINALITY_EN = "at least 1";
    public static final String SOME_VALUES_CARDINALITY_GR = "\u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf 1";
    private Set<OWLOntology> mainModels;
    private SentencePlanQueryManager SPQM;

    public Lexicalisation(Set<OWLOntology> ontologies, SentencePlanQueryManager SPQM, String Language) {
        super(Language);
        this.mainModels = ontologies;
        this.SPQM = SPQM;
    }

    public XmlMsgs lexicalizeInstances(XmlMsgs messages) {
        for (Node message : messages.getMessages()) {
            IRI sentencePlanIRI = IRI.create((String)XmlMsgs.getAttribute(message, XmlMsgs.prefix, "sentencePlan"));
            if (!XmlMsgs.getAttribute(message, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                if (sentencePlanIRI == null) continue;
                this.applySentencePlan(messages, message, this.SPQM.getSlots(sentencePlanIRI));
                continue;
            }
            if (XmlMsgs.compare(message, XmlMsgs.prefix, "hasValueRestriction")) {
                this.applySentencePlan(messages, message, this.SPQM.getSlots(sentencePlanIRI));
                continue;
            }
            if (XmlMsgs.compare(message, XmlMsgs.prefix, "maxCardRestriction")) {
                this.applySentencePlan(messages, message, this.SPQM.getSlots(sentencePlanIRI));
                continue;
            }
            if (XmlMsgs.compare(message, XmlMsgs.prefix, "minCardRestriction")) {
                this.applySentencePlan(messages, message, this.SPQM.getSlots(sentencePlanIRI));
                continue;
            }
            if (XmlMsgs.compare(message, XmlMsgs.prefix, "exactCardRestriction")) {
                this.applySentencePlan(messages, message, this.SPQM.getSlots(sentencePlanIRI));
                continue;
            }
            if (XmlMsgs.compare(message, XmlMsgs.prefix, "differentFrom") || XmlMsgs.compare(message, XmlMsgs.prefix, "sameAs") || XmlMsgs.getAttribute(message, XmlMsgs.prefix, "forProperty").isEmpty() || sentencePlanIRI.toString().isEmpty()) continue;
            this.applySentencePlan(messages, message, this.SPQM.getSlots(sentencePlanIRI));
        }
        return messages;
    }

    public void applySentencePlan(XmlMsgs messages, Node messageRoot, ArrayList<SPSlot> slots) {
        if (slots != null) {
            String forProperty = "";
            if (!XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "forProperty").isEmpty()) {
                forProperty = XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "forProperty");
            } else if (!XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                forProperty = XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "forDomainIndependentProperty");
            }
            Collections.sort(slots);
            Node before = null;
            int i = 0;
            while (i < slots.size()) {
                SPSlot CS;
                SPSlot slot = slots.get(i);
                if (slot instanceof SPOwnerSlot) {
                    SPOwnerSlot OS = (SPOwnerSlot)slot;
                    messages.addOwnerSlot(messageRoot, forProperty, OS.getCase(), OS.getRefType(), OS.getId());
                } else if (slot instanceof SPFillerSlot) {
                    SPFillerSlot FS = (SPFillerSlot)slot;
                    if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "modifier").equals("maxCardRestriction")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "maxCardinality(" + forProperty + ")", "at most " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"), before);
                            } else {
                                messages.addStringSlot(messageRoot, "maxCardinality(" + forProperty + ")", "at most " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"));
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "maxCardinality(" + forProperty + ")", "\u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"), before);
                            } else {
                                messages.addStringSlot(messageRoot, "maxCardinality(" + forProperty + ")", "\u03c4\u03bf \u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"));
                            }
                        }
                        if (Integer.parseInt(XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality").trim()) == 1) {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "singular", FS.getBullets(), 1, FS.getId());
                        } else {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "plural", FS.getBullets(), 1, FS.getId());
                        }
                    } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "modifier").equals("minCardRestriction")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "minCardinality(" + forProperty + ")", "at least " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"), before);
                            } else {
                                messages.addStringSlot(messageRoot, "minCardinality(" + forProperty + ")", "at least " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"));
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "minCardinality(" + forProperty + ")", "\u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"), before);
                            } else {
                                messages.addStringSlot(messageRoot, "minCardinality(" + forProperty + ")", "\u03c4\u03bf \u03bb\u03b9\u03b3\u03cc\u03c4\u03b5\u03c1\u03bf " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"));
                            }
                        }
                        if (Integer.parseInt(XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality").trim()) == 1) {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "singular", FS.getBullets(), 1, FS.getId());
                        } else {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "plural", FS.getBullets(), 1, FS.getId());
                        }
                    } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "modifier").equals("exactCardRestriction")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "exactCardinality(" + forProperty + ")", "exactly " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"), before);
                            } else {
                                messages.addStringSlot(messageRoot, "exactCardinality(" + forProperty + ")", "exactly " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"));
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "exactCardinality(" + forProperty + ")", "\u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"), before);
                            } else {
                                messages.addStringSlot(messageRoot, "exactCardinality(" + forProperty + ")", "\u03b1\u03ba\u03c1\u03b9\u03b2\u03ce\u03c2 " + XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality"));
                            }
                        }
                        if (Integer.parseInt(XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "cardinality").trim()) == 1) {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "singular", FS.getBullets(), 1, FS.getId());
                        } else {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "plural", FS.getBullets(), 1, FS.getId());
                        }
                    } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "modifier").equals("allValuesFromRestriction")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "allValues(" + forProperty + ")", ALL_VALUES_CARDINALITY_EN, before);
                            } else {
                                messages.addStringSlot(messageRoot, "allValues(" + forProperty + ")", ALL_VALUES_CARDINALITY_EN);
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "allValues(" + forProperty + ")", ALL_VALUES_CARDINALITY_GR, before);
                            } else {
                                messages.addStringSlot(messageRoot, "allValues(" + forProperty + ")", ALL_VALUES_CARDINALITY_GR);
                            }
                        }
                        messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "plural", FS.getBullets(), 3, FS.getId());
                    } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "modifier").equals("someValuesFromRestriction")) {
                        if (Languages.isEnglish(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "someValues(" + forProperty + ")", SOME_VALUES_CARDINALITY_EN, before);
                            } else {
                                messages.addStringSlot(messageRoot, "someValues(" + forProperty + ")", SOME_VALUES_CARDINALITY_EN);
                            }
                        } else if (Languages.isGreek(this.getLanguage())) {
                            if (before != null) {
                                messages.addStringSlot(messageRoot, "someValues(" + forProperty + ")", SOME_VALUES_CARDINALITY_GR, before);
                            } else {
                                messages.addStringSlot(messageRoot, "someValues(" + forProperty + ")", SOME_VALUES_CARDINALITY_GR);
                            }
                        }
                        messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "singular", FS.getBullets(), 1, FS.getId());
                    } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "forDomainIndependentProperty").equals(NLResourceManager.isA.getIRI().toString())) {
                        if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "sentencePlan").equals(DefaultResourcesManager.kindOfSPEN_IRI.toString()) || XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "sentencePlan").equals(DefaultResourcesManager.kindOfSPGR_IRI.toString())) {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "", FS.getBullets(), 1, FS.getId());
                        } else {
                            messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "", FS.getBullets(), 3, FS.getId());
                        }
                    } else {
                        messages.addFillerSlot(messageRoot, forProperty, FS.getCase(), "", FS.getBullets(), 0, FS.getId());
                    }
                } else if (slot instanceof SPVerbSlot) {
                    SPVerbSlot VS = (SPVerbSlot)slot;
                    boolean polarity = true;
                    if (VS.getPolarity().equals(SPVerbSlot.POLARITY_POSITIVE)) {
                        polarity = true;
                    } else if (VS.getPolarity().equals(SPVerbSlot.POLARITY_NEGATIVE)) {
                        polarity = false;
                    } else if (VS.getPolarity().equals(SPVerbSlot.POLARITY_FILLER)) {
                        if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "value").equals("and(true)")) {
                            polarity = true;
                        } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "value").equals("and(false)")) {
                            polarity = false;
                        }
                    }
                    before = XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "polarity").equals("false") ? messages.addVerbSlot(messageRoot, forProperty, VS.getLexiconEntryIRI(), VS.getVoice(), VS.getTense(), VS.getNumber(), VS.getPerson(), VS.getAgreesWithID(), !polarity, VS.getId()) : messages.addVerbSlot(messageRoot, forProperty, VS.getLexiconEntryIRI(), VS.getVoice(), VS.getTense(), VS.getNumber(), VS.getPerson(), VS.getAgreesWithID(), polarity, VS.getId());
                } else if (slot instanceof SPAdjectiveSlot) {
                    SPAdjectiveSlot AS = (SPAdjectiveSlot)slot;
                    messages.addAdjectiveSlot(messageRoot, forProperty, AS.getLexiconEntryIRI(), AS.getCase(), AS.getGender(), AS.getNumber(), AS.getAgreesWithID(), AS.getId());
                } else if (slot instanceof SPNounSlot) {
                    SPNounSlot NS = (SPNounSlot)slot;
                    messages.addNounSlot(messageRoot, forProperty, NS.getLexiconEntryIRI(), NS.getCase(), NS.getNumber(), NS.getAgreesWithID(), NS.getId());
                } else if (slot instanceof SPPrepositionSlot) {
                    SPPrepositionSlot PS = (SPPrepositionSlot)slot;
                    if (i > 0) {
                        if (slots.get(i - 1) instanceof SPVerbSlot) {
                            before = messages.addPrepositionSlot(messageRoot, forProperty, PS.getPrep());
                        } else {
                            messages.addPrepositionSlot(messageRoot, forProperty, PS.getPrep());
                        }
                    } else {
                        messages.addPrepositionSlot(messageRoot, forProperty, PS.getPrep());
                    }
                } else if (slot instanceof SPStringSlot) {
                    SPStringSlot SS = (SPStringSlot)slot;
                    messages.addStringSlot(messageRoot, forProperty, SS.getText());
                } else if (slot instanceof SPConcatenationSlot) {
                    CS = (SPConcatenationSlot)slot;
                    ArrayList<SPConcatenationPropertySlot> CPSs = ((SPConcatenationSlot)CS).getSortedPropertySlots();
                    ArrayList<String> values = Fact.parseModifier(XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "value"));
                    boolean first = true;
                    for (String value : values) {
                        if (!first) {
                            if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "value").startsWith("and(")) {
                                messages.addStringSlot(messageRoot, forProperty, "&&&");
                            } else if (XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "value").startsWith("or(")) {
                                messages.addStringSlot(messageRoot, forProperty, "|||");
                            }
                        }
                        first = false;
                        HashSet concatObjectProperties = new HashSet();
                        HashSet concatDataProperties = new HashSet();
                        IRI concatOwnerIRI = IRI.create((String)value);
                        HashSet entities = new HashSet();
                        for (OWLOntology ontology : this.mainModels) {
                            entities.addAll(ontology.getEntitiesInSignature(concatOwnerIRI, true));
                        }
                        for (OWLEntity concatOwner : entities) {
                            if (!concatOwner.isOWLNamedIndividual()) continue;
                            for (OWLOntology ontology : this.mainModels) {
                                concatObjectProperties.addAll(ontology.getObjectPropertyAssertionAxioms((OWLIndividual)concatOwner.asOWLNamedIndividual()));
                                concatDataProperties.addAll(ontology.getDataPropertyAssertionAxioms((OWLIndividual)concatOwner.asOWLNamedIndividual()));
                            }
                        }
                        int j = 0;
                        while (j < CPSs.size()) {
                            IRI propertyIRI = CPSs.get(j).getPropertyIRI();
                            boolean containsObject = false;
                            boolean containsData = false;
                            for (OWLOntology ontology : this.mainModels) {
                                if (ontology.containsObjectPropertyInSignature(propertyIRI, true)) {
                                    containsObject = true;
                                }
                                if (!ontology.containsDataPropertyInSignature(propertyIRI, true)) continue;
                                containsData = true;
                            }
                            if (containsObject) {
                                for (OWLObjectPropertyAssertionAxiom concatProperty : concatObjectProperties) {
                                    if (!((OWLObjectPropertyExpression)concatProperty.getProperty()).asOWLObjectProperty().getIRI().equals((Object)propertyIRI) || !((OWLIndividual)concatProperty.getObject()).isNamed()) continue;
                                    messages.addConcatenationIndividualSlot(messageRoot, forProperty, ((OWLIndividual)concatProperty.getObject()).asOWLNamedIndividual().getIRI(), CPSs.get(j).getCaseType());
                                }
                            } else if (containsData) {
                                for (OWLObjectPropertyAssertionAxiom concatProperty : concatDataProperties) {
                                    if (!((OWLDataPropertyExpression)concatProperty.getProperty()).asOWLDataProperty().getIRI().equals((Object)propertyIRI)) continue;
                                    messages.addStringSlot(messageRoot, forProperty, ((OWLLiteral)concatProperty.getObject()).getLiteral());
                                }
                            }
                            ++j;
                        }
                    }
                } else if (slot instanceof SPComparatorSlot) {
                    CS = (SPComparatorSlot)slot;
                    messages.addComparatorSlot(messageRoot, forProperty, ((SPComparatorSlot)CS).getCase(), ((SPComparatorSlot)CS).isMany(), 0, CS.getId());
                } else if (slot instanceof SPComparatorFillerSlot) {
                    CS = (SPComparatorFillerSlot)slot;
                    messages.addComparatorFillerSlot(messageRoot, forProperty, ((SPComparatorFillerSlot)CS).getCase(), ((SPComparatorFillerSlot)CS).isMany(), 0, CS.getId());
                }
                ++i;
            }
        }
    }
}

