/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLGEngine;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.MappingQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SPFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPOwnerSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlanQueryManager;
import gr.aueb.cs.nlg.NLGEngine.NLGEngineComponent;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.gnu.glpk.GLPK;
import org.gnu.glpk.GLPKConstants;
import org.gnu.glpk.GlpkException;
import org.gnu.glpk.SWIGTYPE_p_double;
import org.gnu.glpk.SWIGTYPE_p_int;
import org.gnu.glpk.glp_iocp;
import org.gnu.glpk.glp_prob;
import org.semanticweb.owlapi.model.IRI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ILPEngine
extends NLGEngineComponent {
    private int factCount;
    private SentencePlanQueryManager SPQM;
    private MappingQueryManager MQM;
    private ArrayList<Node> facts;
    private ArrayList<ArrayList<IRI>> sentencePlans;
    private ArrayList<String> slots;
    private HashMap<IRI, Boolean> selectedFacts;
    private HashMap<IRI, Integer> selectedSubsets;
    private HashMap<IRI, HashMap<IRI, Boolean>> selectedSentencePlans;

    public ILPEngine(SentencePlanQueryManager SPQM, MappingQueryManager MQM, String Language) {
        super(Language);
        this.SPQM = SPQM;
        this.MQM = MQM;
    }

    public XmlMsgs createAndSolveILPNLG(XmlMsgs messages, double lamda, int maxSentences, int maxSlotsPerSentence) {
        glp_prob lp;
        this.facts = new ArrayList();
        int i = 0;
        while (i < messages.getMessages().size()) {
            if (Integer.parseInt(XmlMsgs.getAttribute(messages.getMessages().get(i), XmlMsgs.prefix, "interest")) != 0) {
                this.facts.add(messages.getMessages().get(i));
            }
            ++i;
        }
        this.selectedSubsets = new HashMap();
        i = 0;
        while (i < this.facts.size()) {
            this.selectedSubsets.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), -1);
            ++i;
        }
        this.selectedFacts = new HashMap();
        i = 0;
        while (i < this.facts.size()) {
            this.selectedFacts.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), Boolean.FALSE);
            ++i;
        }
        this.selectedSentencePlans = new HashMap();
        i = 0;
        while (i < this.facts.size()) {
            HashMap<IRI, Boolean> selectedSentencePlanIRIs = new HashMap<IRI, Boolean>();
            if (!this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty"))).isEmpty()) {
                if (this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty"))).size() > 0) {
                    for (IRI spIRI : this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")))) {
                        if (!this.SPQM.getSentencePlan(spIRI).getLanguage().equals(this.getLanguage())) continue;
                        selectedSentencePlanIRIs.put(spIRI, Boolean.FALSE);
                    }
                }
            } else {
                selectedSentencePlanIRIs.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "sentencePlan")), Boolean.FALSE);
            }
            this.selectedSentencePlans.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), selectedSentencePlanIRIs);
            ++i;
        }
        if (!this.facts.isEmpty() && (lp = this.createAndSolveModel(lamda, 1.0 - lamda, maxSentences, maxSlotsPerSentence)) != null) {
            this.exportSelection(lp, maxSentences, -1);
            GLPK.glp_delete_prob((glp_prob)lp);
        }
        return this.applyNLGSolution(messages);
    }

    public XmlMsgs createAndApproximateILPNLG(XmlMsgs messages, double lamda, int maxSentences, int maxSlotsPerSentence) {
        this.facts = new ArrayList();
        int i = 0;
        while (i < messages.getMessages().size()) {
            if (Integer.parseInt(XmlMsgs.getAttribute(messages.getMessages().get(i), XmlMsgs.prefix, "interest")) != 0) {
                this.facts.add(messages.getMessages().get(i));
            }
            ++i;
        }
        this.selectedSubsets = new HashMap();
        i = 0;
        while (i < this.facts.size()) {
            this.selectedSubsets.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), -1);
            ++i;
        }
        this.selectedFacts = new HashMap();
        i = 0;
        while (i < this.facts.size()) {
            this.selectedFacts.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), Boolean.FALSE);
            ++i;
        }
        this.selectedSentencePlans = new HashMap();
        i = 0;
        while (i < this.facts.size()) {
            HashMap<IRI, Boolean> selectedSentencePlanIRIs = new HashMap<IRI, Boolean>();
            if (!this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty"))).isEmpty()) {
                if (this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty"))).size() > 0) {
                    for (IRI spIRI : this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")))) {
                        if (!this.SPQM.getSentencePlan(spIRI).getLanguage().equals(this.getLanguage())) continue;
                        selectedSentencePlanIRIs.put(spIRI, Boolean.FALSE);
                    }
                }
            } else {
                selectedSentencePlanIRIs.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "sentencePlan")), Boolean.FALSE);
            }
            this.selectedSentencePlans.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), selectedSentencePlanIRIs);
            ++i;
        }
        int m = 0;
        while (m < maxSentences) {
            glp_prob lp;
            if (!this.facts.isEmpty() && (lp = this.createAndSolveModel(lamda, 1.0 - lamda, 1, maxSlotsPerSentence)) != null) {
                this.exportSelection(lp, 1, m);
                ArrayList<Node> toRemove = new ArrayList<Node>();
                int i2 = 0;
                while (i2 < this.facts.size()) {
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("a" + (i2 + 1)));
                    double val = GLPK.glp_mip_col_val((glp_prob)lp, (int)column);
                    if (val == 1.0) {
                        toRemove.add(this.facts.get(i2));
                    }
                    ++i2;
                }
                this.facts.removeAll(toRemove);
                GLPK.glp_delete_prob((glp_prob)lp);
            }
            ++m;
        }
        return this.applyNLGSolution(messages);
    }

    private glp_prob createAndSolveModel(double lamda1, double lamda2, int maxSentences, int maxSlotsPerSentence) {
        try {
            SWIGTYPE_p_double val;
            SWIGTYPE_p_int ind;
            glp_prob lp = GLPK.glp_create_prob();
            GLPK.glp_set_prob_name((glp_prob)lp, (String)"NLG problem");
            GLPK.glp_create_index((glp_prob)lp);
            int columnCount = 1;
            GLPK.glp_add_cols((glp_prob)lp, (int)this.facts.size());
            int i = 0;
            while (i < this.facts.size()) {
                GLPK.glp_set_col_name((glp_prob)lp, (int)columnCount, (String)("a" + (i + 1)));
                GLPK.glp_set_col_kind((glp_prob)lp, (int)columnCount, (int)GLPKConstants.GLP_BV);
                ++columnCount;
                ++i;
            }
            int totalLikVariables = 0;
            this.sentencePlans = new ArrayList();
            int i2 = 0;
            while (i2 < this.facts.size()) {
                ArrayList<IRI> sentencePlanIRIs = new ArrayList<IRI>();
                if (!this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i2), XmlMsgs.prefix, "forProperty"))).isEmpty()) {
                    if (this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i2), XmlMsgs.prefix, "forProperty"))).size() > 0) {
                        for (IRI spIRI : this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i2), XmlMsgs.prefix, "forProperty")))) {
                            if (!this.SPQM.getSentencePlan(spIRI).getLanguage().equals(this.getLanguage())) continue;
                            sentencePlanIRIs.add(spIRI);
                            ++totalLikVariables;
                        }
                    }
                } else {
                    sentencePlanIRIs.add(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i2), XmlMsgs.prefix, "sentencePlan")));
                    ++totalLikVariables;
                }
                this.sentencePlans.add(sentencePlanIRIs);
                ++i2;
            }
            GLPK.glp_add_cols((glp_prob)lp, (int)(totalLikVariables * maxSentences));
            i2 = 0;
            while (i2 < this.facts.size()) {
                int k = 0;
                while (k < this.sentencePlans.get(i2).size()) {
                    int j = 0;
                    while (j < maxSentences) {
                        GLPK.glp_set_col_name((glp_prob)lp, (int)columnCount, (String)("l" + (i2 + 1) + "," + (k + 1) + "," + (j + 1)));
                        GLPK.glp_set_col_kind((glp_prob)lp, (int)columnCount, (int)GLPKConstants.GLP_BV);
                        ++columnCount;
                        ++j;
                    }
                    ++k;
                }
                ++i2;
            }
            int totalSoVariables = 0;
            HashSet<String> slotStrings = new HashSet<String>();
            int i3 = 0;
            while (i3 < this.facts.size()) {
                if (this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forProperty"))) != null) {
                    if (this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forProperty"))).size() > 0) {
                        for (IRI SPIRI : this.MQM.getSentencePlansSet(this.SPQM, IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forProperty")))) {
                            if (!this.SPQM.getSentencePlan(SPIRI).getLanguage().equals(this.getLanguage())) continue;
                            for (SPSlot slot : this.SPQM.getSentencePlan(SPIRI).getSlotsList()) {
                                if (slot instanceof SPOwnerSlot) {
                                    slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                                    continue;
                                }
                                if (slot instanceof SPFillerSlot) {
                                    slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                                    continue;
                                }
                                slotStrings.add(slot.toString());
                            }
                        }
                    }
                } else {
                    for (SPSlot slot : this.SPQM.getSentencePlan(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "sentencePlan"))).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    for (SPSlot slot : this.SPQM.getSentencePlan(DefaultResourcesManager.isASPEN_IRI).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                    for (SPSlot slot : this.SPQM.getSentencePlan(DefaultResourcesManager.kindOfSPEN_IRI).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                    for (SPSlot slot : this.SPQM.getSentencePlan(DefaultResourcesManager.sameIndividualSPEN_IRI).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                } else {
                    for (SPSlot slot : this.SPQM.getSentencePlan(DefaultResourcesManager.isASPGR_IRI).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                    for (SPSlot slot : this.SPQM.getSentencePlan(DefaultResourcesManager.kindOfSPGR_IRI).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                    for (SPSlot slot : this.SPQM.getSentencePlan(DefaultResourcesManager.sameIndividualSPGR_IRI).getSlotsList()) {
                        if (slot instanceof SPOwnerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forSubject"));
                            continue;
                        }
                        if (slot instanceof SPFillerSlot) {
                            slotStrings.add(String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i3), XmlMsgs.prefix, "forObject"));
                            continue;
                        }
                        slotStrings.add(slot.toString());
                    }
                }
                ++i3;
            }
            this.slots = new ArrayList(slotStrings);
            totalSoVariables = this.slots.size();
            GLPK.glp_add_cols((glp_prob)lp, (int)(totalSoVariables * maxSentences));
            int o = 0;
            while (o < this.slots.size()) {
                int j = 0;
                while (j < maxSentences) {
                    GLPK.glp_set_col_name((glp_prob)lp, (int)columnCount, (String)("s" + (o + 1) + "," + (j + 1)));
                    GLPK.glp_set_col_kind((glp_prob)lp, (int)columnCount, (int)GLPKConstants.GLP_BV);
                    ++columnCount;
                    ++j;
                }
                ++o;
            }
            int rowCount = 1;
            GLPK.glp_add_rows((glp_prob)lp, (int)this.facts.size());
            int i4 = 0;
            while (i4 < this.facts.size()) {
                GLPK.glp_set_row_name((glp_prob)lp, (int)rowCount, (String)("constr" + rowCount));
                GLPK.glp_set_row_bnds((glp_prob)lp, (int)rowCount, (int)GLPKConstants.GLP_FX, (double)0.0, (double)0.0);
                columnCount = 1;
                ind = GLPK.new_intArray((int)(this.sentencePlans.get(i4).size() * maxSentences + 2));
                val = GLPK.new_doubleArray((int)(this.sentencePlans.get(i4).size() * maxSentences + 2));
                int column = GLPK.glp_find_col((glp_prob)lp, (String)("a" + (i4 + 1)));
                GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)-1.0);
                ++columnCount;
                int k = 0;
                while (k < this.sentencePlans.get(i4).size()) {
                    int j = 0;
                    while (j < maxSentences) {
                        column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i4 + 1) + "," + (k + 1) + "," + (j + 1)));
                        GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                        GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                        ++columnCount;
                        ++j;
                    }
                    ++k;
                }
                GLPK.glp_set_mat_row((glp_prob)lp, (int)rowCount, (int)(this.sentencePlans.get(i4).size() * maxSentences + 1), (SWIGTYPE_p_int)ind, (SWIGTYPE_p_double)val);
                ++rowCount;
                ++i4;
            }
            GLPK.glp_add_rows((glp_prob)lp, (int)(totalLikVariables * maxSentences));
            i4 = 0;
            while (i4 < this.facts.size()) {
                int j = 0;
                while (j < maxSentences) {
                    int k = 0;
                    while (k < this.sentencePlans.get(i4).size()) {
                        GLPK.glp_set_row_name((glp_prob)lp, (int)rowCount, (String)("constr" + rowCount));
                        GLPK.glp_set_row_bnds((glp_prob)lp, (int)rowCount, (int)GLPKConstants.GLP_LO, (double)0.0, (double)0.0);
                        HashSet<String> slotStrs = new HashSet<String>();
                        for (SPSlot slot : this.SPQM.getSentencePlan(this.sentencePlans.get(i4).get(k)).getSlotsList()) {
                            String slotStr = slot instanceof SPOwnerSlot ? String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i4), XmlMsgs.prefix, "forSubject") : (slot instanceof SPFillerSlot ? String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i4), XmlMsgs.prefix, "forObject") : slot.toString());
                            slotStrs.add(slotStr);
                        }
                        ind = GLPK.new_intArray((int)(slotStrs.size() + 2));
                        val = GLPK.new_doubleArray((int)(slotStrs.size() + 2));
                        columnCount = 1;
                        for (String slotStr : slotStrs) {
                            int o2 = 0;
                            while (o2 < this.slots.size()) {
                                if (this.slots.get(o2).equals(slotStr)) {
                                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("s" + (o2 + 1) + "," + (j + 1)));
                                    GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                                    GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                                    ++columnCount;
                                }
                                ++o2;
                            }
                        }
                        int column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i4 + 1) + "," + (k + 1) + "," + (j + 1)));
                        GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                        GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)(-this.SPQM.getSentencePlan(this.sentencePlans.get(i4).get(k)).getSlotsList().size()));
                        ++columnCount;
                        GLPK.glp_set_mat_row((glp_prob)lp, (int)rowCount, (int)(slotStrs.size() + 1), (SWIGTYPE_p_int)ind, (SWIGTYPE_p_double)val);
                        ++rowCount;
                        ++k;
                    }
                    ++j;
                }
                ++i4;
            }
            GLPK.glp_add_rows((glp_prob)lp, (int)(this.slots.size() * maxSentences));
            int o3 = 0;
            while (o3 < this.slots.size()) {
                int j = 0;
                while (j < maxSentences) {
                    ArrayList<String> sentencePlansContainingSlot = new ArrayList<String>();
                    int i5 = 0;
                    while (i5 < this.facts.size()) {
                        int k = 0;
                        while (k < this.sentencePlans.get(i5).size()) {
                            HashSet<String> slotStrs = new HashSet<String>();
                            for (SPSlot slot : this.SPQM.getSentencePlan(this.sentencePlans.get(i5).get(k)).getSlotsList()) {
                                String slotStr = slot instanceof SPOwnerSlot ? String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i5), XmlMsgs.prefix, "forSubject") : (slot instanceof SPFillerSlot ? String.valueOf(slot.toString()) + XmlMsgs.getAttribute(this.facts.get(i5), XmlMsgs.prefix, "forObject") : slot.toString());
                                slotStrs.add(slotStr);
                            }
                            Iterator<SPSlot> iterator = slotStrs.iterator();
                            while (iterator.hasNext()) {
                                String slotStr = (String)((Object)iterator.next());
                                if (!this.slots.get(o3).equals(slotStr)) continue;
                                sentencePlansContainingSlot.add("l" + (i5 + 1) + "," + (k + 1) + "," + (j + 1));
                            }
                            ++k;
                        }
                        ++i5;
                    }
                    GLPK.glp_set_row_name((glp_prob)lp, (int)rowCount, (String)("constr" + rowCount));
                    GLPK.glp_set_row_bnds((glp_prob)lp, (int)rowCount, (int)GLPKConstants.GLP_LO, (double)0.0, (double)0.0);
                    ind = GLPK.new_intArray((int)(sentencePlansContainingSlot.size() + 2));
                    val = GLPK.new_doubleArray((int)(sentencePlansContainingSlot.size() + 2));
                    columnCount = 1;
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("s" + (o3 + 1) + "," + (j + 1)));
                    GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                    GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)-1.0);
                    ++columnCount;
                    for (String sp : sentencePlansContainingSlot) {
                        column = GLPK.glp_find_col((glp_prob)lp, (String)sp);
                        GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                        GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                        ++columnCount;
                    }
                    GLPK.glp_set_mat_row((glp_prob)lp, (int)rowCount, (int)(sentencePlansContainingSlot.size() + 1), (SWIGTYPE_p_int)ind, (SWIGTYPE_p_double)val);
                    ++rowCount;
                    ++j;
                }
                ++o3;
            }
            GLPK.glp_add_rows((glp_prob)lp, (int)maxSentences);
            int j = 0;
            while (j < maxSentences) {
                GLPK.glp_set_row_name((glp_prob)lp, (int)rowCount, (String)("constr" + rowCount));
                GLPK.glp_set_row_bnds((glp_prob)lp, (int)rowCount, (int)GLPKConstants.GLP_UP, (double)0.0, (double)maxSlotsPerSentence);
                ind = GLPK.new_intArray((int)(this.slots.size() + 1));
                val = GLPK.new_doubleArray((int)(this.slots.size() + 1));
                columnCount = 1;
                int o4 = 0;
                while (o4 < this.slots.size()) {
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("s" + (o4 + 1) + "," + (j + 1)));
                    GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                    GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                    ++columnCount;
                    ++o4;
                }
                GLPK.glp_set_mat_row((glp_prob)lp, (int)rowCount, (int)this.slots.size(), (SWIGTYPE_p_int)ind, (SWIGTYPE_p_double)val);
                ++rowCount;
                ++j;
            }
            int firstSection = 100000000;
            int i6 = 0;
            while (i6 < this.facts.size()) {
                if (Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i6), XmlMsgs.prefix, "section")) != 0 && Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i6), XmlMsgs.prefix, "section")) < firstSection) {
                    firstSection = Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i6), XmlMsgs.prefix, "section"));
                }
                ++i6;
            }
            int i1 = 0;
            while (i1 < this.facts.size()) {
                int i22 = i1 + 1;
                while (i22 < this.facts.size()) {
                    if (!(XmlMsgs.getAttribute(this.facts.get(i1), XmlMsgs.prefix, "section").equals(XmlMsgs.getAttribute(this.facts.get(i22), XmlMsgs.prefix, "section")) || Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i1), XmlMsgs.prefix, "section")) == 0 && Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i22), XmlMsgs.prefix, "section")) == firstSection || Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i22), XmlMsgs.prefix, "section")) == 0 && Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i1), XmlMsgs.prefix, "section")) == firstSection)) {
                        GLPK.glp_add_rows((glp_prob)lp, (int)maxSentences);
                        int j2 = 0;
                        while (j2 < maxSentences) {
                            int column;
                            GLPK.glp_set_row_name((glp_prob)lp, (int)rowCount, (String)("constr" + rowCount));
                            GLPK.glp_set_row_bnds((glp_prob)lp, (int)rowCount, (int)GLPKConstants.GLP_UP, (double)1.0, (double)1.0);
                            ind = GLPK.new_intArray((int)(this.sentencePlans.get(i1).size() + this.sentencePlans.get(i22).size()));
                            val = GLPK.new_doubleArray((int)(this.sentencePlans.get(i1).size() + this.sentencePlans.get(i22).size()));
                            columnCount = 1;
                            int k = 0;
                            while (k < this.sentencePlans.get(i1).size()) {
                                column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i1 + 1) + "," + (k + 1) + "," + (j2 + 1)));
                                GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                                GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                                ++columnCount;
                                ++k;
                            }
                            k = 0;
                            while (k < this.sentencePlans.get(i22).size()) {
                                column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i22 + 1) + "," + (k + 1) + "," + (j2 + 1)));
                                GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                                GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                                ++columnCount;
                                ++k;
                            }
                            GLPK.glp_set_mat_row((glp_prob)lp, (int)rowCount, (int)(this.sentencePlans.get(i1).size() + this.sentencePlans.get(i22).size()), (SWIGTYPE_p_int)ind, (SWIGTYPE_p_double)val);
                            ++rowCount;
                            ++j2;
                        }
                    }
                    ++i22;
                }
                ++i1;
            }
            i1 = 0;
            while (i1 < this.facts.size()) {
                int i23 = i1 + 1;
                while (i23 < this.facts.size()) {
                    if (XmlMsgs.getAttribute(this.facts.get(i1), XmlMsgs.prefix, "modifier").equals("allValuesFromRestriction") && XmlMsgs.getAttribute(this.facts.get(i23), XmlMsgs.prefix, "modifier").equals("allValuesFromRestriction") && XmlMsgs.getAttribute(this.facts.get(i1), XmlMsgs.prefix, "forProperty").equals(XmlMsgs.getAttribute(this.facts.get(i23), XmlMsgs.prefix, "forProperty"))) {
                        GLPK.glp_add_rows((glp_prob)lp, (int)maxSentences);
                        int j3 = 0;
                        while (j3 < maxSentences) {
                            int column;
                            GLPK.glp_set_row_name((glp_prob)lp, (int)rowCount, (String)("constr" + rowCount));
                            GLPK.glp_set_row_bnds((glp_prob)lp, (int)rowCount, (int)GLPKConstants.GLP_FX, (double)0.0, (double)0.0);
                            ind = GLPK.new_intArray((int)(this.sentencePlans.get(i1).size() + this.sentencePlans.get(i23).size()));
                            val = GLPK.new_doubleArray((int)(this.sentencePlans.get(i1).size() + this.sentencePlans.get(i23).size()));
                            columnCount = 1;
                            int k = 0;
                            while (k < this.sentencePlans.get(i1).size()) {
                                column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i1 + 1) + "," + (k + 1) + "," + (j3 + 1)));
                                GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                                GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)1.0);
                                ++columnCount;
                                ++k;
                            }
                            k = 0;
                            while (k < this.sentencePlans.get(i1).size()) {
                                column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i23 + 1) + "," + (k + 1) + "," + (j3 + 1)));
                                GLPK.intArray_setitem((SWIGTYPE_p_int)ind, (int)columnCount, (int)column);
                                GLPK.doubleArray_setitem((SWIGTYPE_p_double)val, (int)columnCount, (double)-1.0);
                                ++columnCount;
                                ++k;
                            }
                            GLPK.glp_set_mat_row((glp_prob)lp, (int)rowCount, (int)(this.sentencePlans.get(i1).size() + this.sentencePlans.get(i23).size()), (SWIGTYPE_p_int)ind, (SWIGTYPE_p_double)val);
                            ++rowCount;
                            ++j3;
                        }
                    }
                    ++i23;
                }
                ++i1;
            }
            GLPK.glp_set_obj_name((glp_prob)lp, (String)"z");
            GLPK.glp_set_obj_dir((glp_prob)lp, (int)GLPKConstants.GLP_MAX);
            GLPK.glp_set_obj_coef((glp_prob)lp, (int)0, (double)1.0);
            i6 = 0;
            while (i6 < this.facts.size()) {
                int column = GLPK.glp_find_col((glp_prob)lp, (String)("a" + (i6 + 1)));
                GLPK.glp_set_obj_coef((glp_prob)lp, (int)column, (double)(lamda1 * this.normalizeInterestValue(Integer.parseInt(XmlMsgs.getAttribute(this.facts.get(i6), XmlMsgs.prefix, "interest"))) / (double)this.facts.size()));
                ++i6;
            }
            int o5 = 0;
            while (o5 < this.slots.size()) {
                int j4 = 0;
                while (j4 < maxSentences) {
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("s" + (o5 + 1) + "," + (j4 + 1)));
                    GLPK.glp_set_obj_coef((glp_prob)lp, (int)column, (double)(-lamda2 * (double)(1.0f / (float)(totalSoVariables * maxSentences))));
                    ++j4;
                }
                ++o5;
            }
            GLPK.glp_write_lp((glp_prob)lp, null, (String)"temp.lp");
            glp_iocp iocp = new glp_iocp();
            GLPK.glp_mem_limit((int)10000);
            GLPK.glp_init_iocp((glp_iocp)iocp);
            iocp.setMsg_lev(GLPKConstants.GLP_MSG_OFF);
            iocp.setPresolve(GLPKConstants.GLP_ON);
            iocp.setCb_size(256);
            iocp.setBr_tech(GLPKConstants.GLP_BR_PCH);
            iocp.setBt_tech(GLPKConstants.GLP_BT_BPH);
            iocp.setMir_cuts(GLPKConstants.GLP_ON);
            iocp.setCov_cuts(GLPKConstants.GLP_ON);
            iocp.setClq_cuts(GLPKConstants.GLP_ON);
            int ret = GLPK.glp_intopt((glp_prob)lp, (glp_iocp)iocp);
            if (ret != 0) {
                System.err.println("The problem could not be solved");
            }
            return lp;
        }
        catch (GlpkException glpkException) {
            return null;
        }
    }

    private void exportSelection(glp_prob lp, int maxSentences, int placeAllInThisSentence) {
        double val;
        int i = 0;
        while (i < this.facts.size()) {
            int column = GLPK.glp_find_col((glp_prob)lp, (String)("a" + (i + 1)));
            val = GLPK.glp_mip_col_val((glp_prob)lp, (int)column);
            if (val == 1.0) {
                this.selectedFacts.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), Boolean.TRUE);
            }
            ++i;
        }
        i = 0;
        while (i < this.facts.size()) {
            int k = 0;
            while (k < this.sentencePlans.get(i).size()) {
                int j = 0;
                while (j < maxSentences) {
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i + 1) + "," + (k + 1) + "," + (j + 1)));
                    val = GLPK.glp_mip_col_val((glp_prob)lp, (int)column);
                    if (val == 1.0) {
                        this.selectedSentencePlans.get(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty"))).put(this.sentencePlans.get(i).get(k), Boolean.TRUE);
                        if (placeAllInThisSentence == -1) {
                            this.selectedSubsets.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), j);
                        } else {
                            this.selectedSubsets.put(IRI.create((String)XmlMsgs.getAttribute(this.facts.get(i), XmlMsgs.prefix, "forProperty")), placeAllInThisSentence);
                        }
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }

    private XmlMsgs applyNLGSolution(XmlMsgs messages) {
        int i;
        ArrayList<Node> toRemove = new ArrayList<Node>();
        toRemove.addAll(messages.getMessages());
        for (IRI fact : this.selectedFacts.keySet()) {
            if (!this.selectedFacts.get(fact).equals(Boolean.TRUE)) continue;
            i = 0;
            while (i < messages.getMessages().size()) {
                if (XmlMsgs.getAttribute(messages.getMessages().get(i), XmlMsgs.prefix, "forProperty").toString().equals(fact.toString())) {
                    toRemove.remove(messages.getMessages().get(i));
                }
                ++i;
            }
        }
        messages.removeMsgs(toRemove);
        for (IRI fact : this.selectedSubsets.keySet()) {
            if (this.selectedSubsets.get(fact) <= -1) continue;
            i = 0;
            while (i < messages.getMessages().size()) {
                if (XmlMsgs.getAttribute(messages.getMessages().get(i), XmlMsgs.prefix, "forProperty").toString().equals(fact.toString())) {
                    messages.setAttr((Element)messages.getMessages().get(i), NLResourceManager.nlowlNS, XmlMsgs.prefix, "ILPSentence", "" + this.selectedSubsets.get(fact));
                }
                ++i;
            }
        }
        for (IRI fact : this.selectedSentencePlans.keySet()) {
            for (IRI plan : this.selectedSentencePlans.get(fact).keySet()) {
                if (!this.selectedSentencePlans.get(fact).get(plan).equals(Boolean.TRUE)) continue;
                int i2 = 0;
                while (i2 < messages.getMessages().size()) {
                    if (XmlMsgs.getAttribute(messages.getMessages().get(i2), XmlMsgs.prefix, "forProperty").toString().equals(fact.toString())) {
                        messages.setAttr((Element)messages.getMessages().get(i2), NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", plan.toString());
                    }
                    ++i2;
                }
            }
        }
        return messages;
    }

    private double normalizeInterestValue(int interest) {
        if (interest == 0) {
            return 0.0;
        }
        return (double)interest / 3.0;
    }

    private void printMIPSolution(glp_prob lp) {
        String name = GLPK.glp_get_obj_name((glp_prob)lp);
        double val = GLPK.glp_mip_obj_val((glp_prob)lp);
        System.out.print(name);
        System.out.print(" = ");
        System.out.println(val);
        int n = GLPK.glp_get_num_cols((glp_prob)lp);
        int i = 1;
        while (i <= n) {
            name = GLPK.glp_get_col_name((glp_prob)lp, (int)i);
            val = GLPK.glp_mip_col_val((glp_prob)lp, (int)i);
            System.out.print(name);
            System.out.print(" = ");
            System.out.println(val);
            ++i;
        }
    }

    private void printNLGSolution(glp_prob lp, XmlMsgs msgs, int maxSentences) {
        double val;
        HashSet[] sentences = new HashSet[maxSentences];
        int i = 0;
        while (i < maxSentences) {
            sentences[i] = new HashSet();
            ++i;
        }
        ArrayList selectedSlots = new ArrayList();
        int i2 = 0;
        while (i2 < maxSentences) {
            selectedSlots.add(new HashSet());
            ++i2;
        }
        i2 = 0;
        while (i2 < this.facts.size()) {
            int k = 0;
            while (k < this.sentencePlans.get(i2).size()) {
                int j = 0;
                while (j < maxSentences) {
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i2 + 1) + "," + (k + 1) + "," + (j + 1)));
                    val = GLPK.glp_mip_col_val((glp_prob)lp, (int)column);
                    if (val == 1.0) {
                        sentences[j].add(GLPK.glp_get_col_name((glp_prob)lp, (int)(i2 + 1)));
                    }
                    ++j;
                }
                ++k;
            }
            ++i2;
        }
        int n = GLPK.glp_get_num_cols((glp_prob)lp);
        i2 = 1;
        while (i2 <= n) {
            String name = GLPK.glp_get_col_name((glp_prob)lp, (int)i2);
            val = GLPK.glp_mip_col_val((glp_prob)lp, (int)i2);
            if (name.startsWith("c")) {
                // empty if block
            }
            if (name.startsWith("s") && name.indexOf(44) != -1 && val == 1.0) {
                int sentence = Integer.parseInt(name.substring(name.indexOf(44) + 1));
                ((HashSet)selectedSlots.get(sentence - 1)).add(name);
            }
            ++i2;
        }
        System.out.println("-----------------");
        i2 = 0;
        while (i2 < maxSentences) {
            System.out.println(sentences[i2]);
            System.out.print("[");
            for (String sentence : sentences[i2]) {
                if (XmlMsgs.getAttribute(msgs.getMessages().get(Integer.parseInt(sentence.substring(sentence.indexOf("a") + 1)) - 1), XmlMsgs.prefix, "forProperty").contains("#")) {
                    System.out.print(IRI.create((String)XmlMsgs.getAttribute(msgs.getMessages().get(Integer.parseInt(sentence.substring(sentence.indexOf("a") + 1))), XmlMsgs.prefix, "forProperty")).getFragment());
                } else {
                    System.out.print(XmlMsgs.getAttribute(msgs.getMessages().get(Integer.parseInt(sentence.substring(sentence.indexOf("a") + 1))), XmlMsgs.prefix, "forProperty"));
                }
                System.out.print(", ");
            }
            System.out.println("]");
            ++i2;
        }
        System.out.println("-----------------");
    }

    private void calculateNLGFactCount(glp_prob lp, int maxSentences) {
        int i = 0;
        while (i < this.facts.size()) {
            int k = 0;
            while (k < this.sentencePlans.get(i).size()) {
                int j = 0;
                while (j < maxSentences) {
                    int column = GLPK.glp_find_col((glp_prob)lp, (String)("l" + (i + 1) + "," + (k + 1) + "," + (j + 1)));
                    double val = GLPK.glp_mip_col_val((glp_prob)lp, (int)column);
                    if (val == 1.0) {
                        ++this.factCount;
                    }
                    ++j;
                }
                ++k;
            }
            ++i;
        }
    }
}

