/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLGEngine;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.MappingQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNameQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.OrderingQueryManager;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationPropertySlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLFiles.SentencePlanQueryManager;
import gr.aueb.cs.nlg.NLFiles.UserModelQueryManager;
import gr.aueb.cs.nlg.NLGEngine.NLGEngine;
import gr.aueb.cs.nlg.NLGEngine.NLGEngineComponent;
import gr.aueb.cs.nlg.Utils.Fact;
import gr.aueb.cs.nlg.Utils.InterestComparatorImpl;
import gr.aueb.cs.nlg.Utils.NLGUser;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentSelection
extends NLGEngineComponent {
    Set<OWLOntology> mainModels;
    private NLNameQueryManager NLNQM;
    private SentencePlanQueryManager SPQM;
    private OrderingQueryManager OQM;
    private UserModelQueryManager UMQM;
    private MappingQueryManager MQM;
    private HashSet<IRI> mentionedEntities;
    private HashSet<Fact> conveyedFacts;
    private HashSet<IRI> usedSentencePlans;
    private HashSet<IRI> usedNLNames;
    private HashMap<IRI, IRI> usedSentencePlanInDescr;
    private HashMap<IRI, IRI> usedNLNamesInDescr;
    private HashMap<IRI, IRI> anonymousSuperClasses;
    private boolean assimilationON = true;
    private boolean interestON = true;
    private boolean allFactsAreAssimilated = false;

    public ContentSelection(Set<OWLOntology> ontologies, SentencePlanQueryManager SPQM, NLNameQueryManager NLNQM, UserModelQueryManager UMQM, MappingQueryManager MQM, OrderingQueryManager OQM, String Language) {
        super(Language);
        this.mainModels = ontologies;
        this.SPQM = SPQM;
        this.NLNQM = NLNQM;
        this.UMQM = UMQM;
        this.MQM = MQM;
        this.OQM = OQM;
    }

    public boolean isAssimilationON() {
        return this.assimilationON;
    }

    public void setAssimilationON(boolean AssimilationON) {
        this.assimilationON = AssimilationON;
    }

    public boolean isInterestON() {
        return this.interestON;
    }

    public void setInterestON(boolean InterestON) {
        this.interestON = InterestON;
    }

    public void addModel(OWLOntology m) {
        this.mainModels.add(m);
    }

    public void setNamespaces(XmlMsgs MyXmlMsgs) {
        for (OWLOntology ontology : this.mainModels) {
            Map prefixesToNSMap = ontology.getOWLOntologyManager().getOntologyFormat(ontology).asPrefixOWLOntologyFormat().getPrefixName2PrefixMap();
            Iterator iter = prefixesToNSMap.keySet().iterator();
            while (iter.hasNext()) {
                String pref = ((String)iter.next()).toString();
                String uriForPref = ((String)prefixesToNSMap.get(pref)).toString();
                MyXmlMsgs.setNamespace(uriForPref, pref);
            }
        }
    }

    public void clearBuffers() {
        this.mentionedEntities = new HashSet();
        this.conveyedFacts = new HashSet();
        this.usedSentencePlans = new HashSet();
        this.usedNLNames = new HashSet();
        this.usedSentencePlanInDescr = new HashMap();
        this.usedNLNamesInDescr = new HashMap();
        this.anonymousSuperClasses = new HashMap();
    }

    public void setMentionedEntity(IRI entityIRI) {
        this.mentionedEntities.add(entityIRI);
    }

    public void updateUser(NLGUser user) {
        for (IRI mentionedEntity : this.mentionedEntities) {
            user.increaseEntityMentionedCount(mentionedEntity);
        }
        for (IRI usedSentencePlan : this.usedSentencePlans) {
            user.increaseSentencePlanUseCount(usedSentencePlan);
        }
        for (IRI usedNLName : this.usedNLNames) {
            user.increaseNLNameUseCount(usedNLName);
        }
        for (Fact conveyedFact : this.conveyedFacts) {
            ArrayList<Object> values = new ArrayList();
            if (conveyedFact.getObject().startsWith("and(")) {
                values = Fact.parseModifier(conveyedFact.getObject());
            } else if (conveyedFact.getObject().startsWith("or(")) {
                values = Fact.parseModifier(conveyedFact.getObject());
            } else {
                values.add(conveyedFact.getObject());
            }
            for (String string : values) {
                Fact conveyed = new Fact(conveyedFact.getSubject(), conveyedFact.getPredicate(), string);
                for (String modifier : conveyedFact.getModifiers()) {
                    conveyed.addModifier(modifier);
                }
                conveyed.setCardinality(conveyedFact.getCardinality());
                conveyed.setPolarity(conveyedFact.isPolarity());
                user.increaseFactMentionedCount(conveyed);
            }
            if (this.usedSentencePlanInDescr.get(conveyedFact.getPredicate()) == null) continue;
            SentencePlan sentencePlan = this.SPQM.getSentencePlan(this.usedSentencePlanInDescr.get(conveyedFact.getPredicate()));
            for (SPSlot slot : sentencePlan.getSlotsList()) {
                if (!(slot instanceof SPConcatenationSlot)) continue;
                for (SPConcatenationPropertySlot propertySlot : ((SPConcatenationSlot)slot).getPropertySlots()) {
                    Fact secondLevelFact;
                    HashMap<OWLObjectPropertyExpression, Set> objPropertyExprMaps = new HashMap<OWLObjectPropertyExpression, Set>();
                    HashMap<OWLDataPropertyExpression, Set> dataPropertyExprMaps = new HashMap<OWLDataPropertyExpression, Set>();
                    for (OWLOntology oWLOntology : this.mainModels) {
                        for (String string : values) {
                            for (OWLEntity entity : oWLOntology.getEntitiesInSignature(IRI.create((String)string))) {
                                if (!entity.isOWLNamedIndividual()) continue;
                                for (Map.Entry propertyExprMap : entity.asOWLNamedIndividual().getObjectPropertyValues(oWLOntology).entrySet()) {
                                    if (!((OWLObjectPropertyExpression)propertyExprMap.getKey()).asOWLObjectProperty().getIRI().equals((Object)propertySlot.getPropertyIRI())) continue;
                                    objPropertyExprMaps.put((OWLObjectPropertyExpression)propertyExprMap.getKey(), (Set)propertyExprMap.getValue());
                                }
                                for (Map.Entry propertyExprMap : entity.asOWLNamedIndividual().getDataPropertyValues(oWLOntology).entrySet()) {
                                    if (!((OWLDataPropertyExpression)propertyExprMap.getKey()).asOWLDataProperty().getIRI().equals((Object)propertySlot.getPropertyIRI())) continue;
                                    dataPropertyExprMaps.put((OWLDataPropertyExpression)propertyExprMap.getKey(), (Set)propertyExprMap.getValue());
                                }
                            }
                        }
                    }
                    for (Map.Entry entry : objPropertyExprMaps.entrySet()) {
                        for (OWLIndividual oWLIndividual : (Set)entry.getValue()) {
                            if (!oWLIndividual.isNamed()) continue;
                            secondLevelFact = new Fact(IRI.create((String)conveyedFact.getObject()), propertySlot.getPropertyIRI(), oWLIndividual.asOWLNamedIndividual().getIRI().toString());
                            user.increaseFactMentionedCount(secondLevelFact);
                        }
                    }
                    for (Map.Entry entry : dataPropertyExprMaps.entrySet()) {
                        for (OWLLiteral oWLLiteral : (Set)entry.getValue()) {
                            secondLevelFact = new Fact(IRI.create((String)conveyedFact.getObject()), propertySlot.getPropertyIRI(), oWLLiteral.getLiteral());
                            user.increaseFactMentionedCount(secondLevelFact);
                        }
                    }
                }
            }
        }
    }

    public XmlMsgs getMessages(IRI entityOrClassIRI, XmlMsgs messages, Node messageRoot, int depth, NLGUser user) {
        if (NLGEngine.isClass(this.mainModels, entityOrClassIRI)) {
            return this.getClassMessages(entityOrClassIRI, messages, messages.getRoot(), depth, 1, user);
        }
        return this.getIndividualMessages(entityOrClassIRI, messages, messages.getRoot(), depth, 1, user);
    }

    public XmlMsgs getClassMessages(IRI classIRI, XmlMsgs messages, Node messageRoot, int depth, int level, NLGUser user) {
        HashSet classes = new HashSet();
        for (OWLOntology ontology : this.mainModels) {
            classes.addAll(ontology.getEntitiesInSignature(classIRI, true));
        }
        for (OWLEntity owlClass : classes) {
            OWLClass subject;
            if (!owlClass.isOWLClass() || (subject = owlClass.asOWLClass()).isAnonymous()) continue;
            ArrayList<Fact> isAFacts = new ArrayList<Fact>();
            ArrayList<Fact> notIsAFacts = new ArrayList<Fact>();
            ArrayList<Fact> oneOfFacts = new ArrayList<Fact>();
            ArrayList<Fact> disjointFacts = new ArrayList<Fact>();
            HashSet classExprs = new HashSet();
            for (OWLOntology ontology : this.mainModels) {
                classExprs.addAll(subject.getSuperClasses(ontology));
            }
            for (OWLClassExpression classExpr : classExprs) {
                this.addClassExpressionMessages(classExpr, classIRI, messages, messageRoot, isAFacts, notIsAFacts, oneOfFacts, depth, level, user);
            }
            classExprs = new HashSet();
            for (OWLOntology ontology : this.mainModels) {
                classExprs.addAll(subject.getEquivalentClasses(ontology));
            }
            for (OWLClassExpression classExpr : classExprs) {
                this.addClassExpressionMessages(classExpr, classIRI, messages, messageRoot, isAFacts, notIsAFacts, oneOfFacts, depth, level, user);
            }
            if (!isAFacts.isEmpty()) {
                this.addDomainIndependentMessage(isAFacts, messages, messageRoot, true, depth, level, user);
            }
            if (!notIsAFacts.isEmpty()) {
                this.addDomainIndependentMessage(notIsAFacts, messages, messageRoot, true, depth, level, user);
            }
            if (!oneOfFacts.isEmpty()) {
                this.addDomainIndependentMessage(oneOfFacts, messages, messageRoot, false, depth, level, user);
            }
            classExprs = new HashSet();
            for (OWLOntology ontology : this.mainModels) {
                classExprs.addAll(subject.getDisjointClasses(ontology));
            }
            for (OWLClassExpression classExpr : classExprs) {
                Set disjointClasses = classExpr.getClassesInSignature();
                for (OWLClass disjointClass : disjointClasses) {
                    if (disjointClass.isAnonymous()) continue;
                    IRI disjointClassIRI = disjointClass.getIRI();
                    Fact fact = new Fact(classIRI, NLResourceManager.isA.getIRI(), disjointClassIRI.toString());
                    fact.addModifier("not");
                    disjointFacts.add(fact);
                }
            }
            if (disjointFacts.isEmpty()) continue;
            this.addDomainIndependentMessage(disjointFacts, messages, messageRoot, true, depth, level, user);
        }
        return messages;
    }

    public XmlMsgs getIndividualMessages(IRI individualIRI, XmlMsgs messages, Node messageRoot, int depth, int level, NLGUser user) {
        HashSet entities = new HashSet();
        for (OWLOntology ontology : this.mainModels) {
            entities.addAll(ontology.getEntitiesInSignature(individualIRI, true));
        }
        Iterator<Object> iterator = entities.iterator();
        if (iterator.hasNext()) {
            OWLEntity entity = (OWLEntity)iterator.next();
            if (entity.isOWLNamedIndividual()) {
                OWLNamedIndividual subject = entity.asOWLNamedIndividual();
                if (subject == null) {
                    return messages;
                }
                ArrayList<Fact> isAFacts = new ArrayList<Fact>();
                ArrayList<Fact> notIsAFacts = new ArrayList<Fact>();
                ArrayList<Fact> oneOfFacts = new ArrayList<Fact>();
                HashSet classExprs = new HashSet();
                for (OWLOntology ontology : this.mainModels) {
                    classExprs.addAll(subject.getTypes(ontology));
                }
                for (OWLClassExpression classExpr : classExprs) {
                    this.addClassExpressionMessages(classExpr, individualIRI, messages, messageRoot, isAFacts, notIsAFacts, oneOfFacts, depth, level, user);
                }
                if (!isAFacts.isEmpty()) {
                    this.addDomainIndependentMessage(isAFacts, messages, messageRoot, true, depth, level, user);
                }
                if (!notIsAFacts.isEmpty()) {
                    this.addDomainIndependentMessage(notIsAFacts, messages, messageRoot, true, depth, level, user);
                }
                if (!oneOfFacts.isEmpty()) {
                    this.addDomainIndependentMessage(oneOfFacts, messages, messageRoot, false, depth, level, user);
                }
                HashSet individuals = new HashSet();
                for (OWLOntology ontology : this.mainModels) {
                    individuals.addAll(subject.getSameIndividuals(ontology));
                }
                ArrayList<Fact> facts = new ArrayList<Fact>();
                for (OWLIndividual indiv : individuals) {
                    IRI iRI;
                    if (!indiv.isNamed() || (iRI = indiv.asOWLNamedIndividual().getIRI()).equals((Object)individualIRI)) continue;
                    Fact fact = new Fact(individualIRI, NLResourceManager.sameIndividuals.getIRI(), iRI.toString());
                    facts.add(fact);
                }
                if (!facts.isEmpty()) {
                    this.addDomainIndependentMessage(facts, messages, messageRoot, true, depth, level, user);
                }
                facts = new ArrayList();
                individuals = new HashSet();
                for (OWLOntology ontology : this.mainModels) {
                    individuals.addAll(subject.getDifferentIndividuals(ontology));
                }
                for (OWLIndividual indiv : individuals) {
                    if (!indiv.isNamed()) continue;
                    IRI iRI = indiv.asOWLNamedIndividual().getIRI();
                    Fact fact = new Fact(individualIRI, NLResourceManager.differentIndividuals.getIRI(), iRI.toString());
                    facts.add(fact);
                }
                if (!facts.isEmpty()) {
                    this.addDomainIndependentMessage(facts, messages, messageRoot, true, depth, level, user);
                }
                facts = new ArrayList();
                HashMap<OWLObjectPropertyExpression, Set> objPropertyExprMaps = new HashMap<OWLObjectPropertyExpression, Set>();
                for (OWLOntology oWLOntology : this.mainModels) {
                    for (Map.Entry entry : subject.getObjectPropertyValues(oWLOntology).entrySet()) {
                        objPropertyExprMaps.put((OWLObjectPropertyExpression)entry.getKey(), (Set)entry.getValue());
                    }
                }
                for (Map.Entry entry : objPropertyExprMaps.entrySet()) {
                    OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)entry.getKey();
                    facts = new ArrayList();
                    for (OWLIndividual oWLIndividual : (Set)entry.getValue()) {
                        Iterator fact2 = new Fact(individualIRI, oWLObjectPropertyExpression.asOWLObjectProperty().getIRI(), oWLIndividual.asOWLNamedIndividual().getIRI().toString());
                        facts.add((Fact)((Object)fact2));
                    }
                    this.addPropertyMessage(facts, messages, messageRoot, true, depth, level, user);
                }
                facts = new ArrayList();
                HashMap<OWLObjectPropertyExpression, Set> hashMap = new HashMap<OWLObjectPropertyExpression, Set>();
                for (OWLOntology oWLOntology : this.mainModels) {
                    for (Map.Entry entry : subject.getNegativeObjectPropertyValues(oWLOntology).entrySet()) {
                        hashMap.put((OWLObjectPropertyExpression)entry.getKey(), (Set)entry.getValue());
                    }
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    OWLObjectPropertyExpression oWLObjectPropertyExpression = (OWLObjectPropertyExpression)entry.getKey();
                    facts = new ArrayList();
                    for (OWLIndividual object : (Set)entry.getValue()) {
                        if (!object.isNamed()) continue;
                        Iterator fact3 = new Fact(individualIRI, oWLObjectPropertyExpression.asOWLObjectProperty().getIRI(), object.asOWLNamedIndividual().getIRI().toString());
                        ((Fact)((Object)fact3)).addModifier("not");
                        facts.add((Fact)((Object)fact3));
                    }
                    this.addPropertyMessage(facts, messages, messageRoot, true, depth, level, user);
                }
                HashMap<OWLDataPropertyExpression, Set> hashMap2 = new HashMap<OWLDataPropertyExpression, Set>();
                for (OWLOntology oWLOntology : this.mainModels) {
                    for (Map.Entry propertyExprMap : subject.getDataPropertyValues(oWLOntology).entrySet()) {
                        hashMap2.put((OWLDataPropertyExpression)propertyExprMap.getKey(), (Set)propertyExprMap.getValue());
                    }
                }
                for (Map.Entry entry : hashMap2.entrySet()) {
                    OWLDataPropertyExpression propertyExpr = (OWLDataPropertyExpression)entry.getKey();
                    facts = new ArrayList();
                    for (OWLLiteral object : (Set)entry.getValue()) {
                        Fact fact4 = new Fact(individualIRI, propertyExpr.asOWLDataProperty().getIRI(), object.getLiteral());
                        facts.add(fact4);
                    }
                    this.addPropertyMessage(facts, messages, messageRoot, true, depth, level, user);
                }
                HashMap<OWLDataPropertyExpression, Set> hashMap3 = new HashMap<OWLDataPropertyExpression, Set>();
                for (OWLOntology oWLOntology : this.mainModels) {
                    for (Map.Entry propertyExprMap : subject.getNegativeDataPropertyValues(oWLOntology).entrySet()) {
                        hashMap3.put((OWLDataPropertyExpression)propertyExprMap.getKey(), (Set)propertyExprMap.getValue());
                    }
                }
                for (Map.Entry entry : hashMap3.entrySet()) {
                    OWLDataPropertyExpression propertyExpr = (OWLDataPropertyExpression)entry.getKey();
                    facts = new ArrayList();
                    for (OWLLiteral object : (Set)entry.getValue()) {
                        Fact fact5 = new Fact(individualIRI, propertyExpr.asOWLDataProperty().getIRI(), object.getLiteral());
                        fact5.addModifier("not");
                        facts.add(fact5);
                    }
                    this.addPropertyMessage(facts, messages, messageRoot, true, depth, level, user);
                }
            }
            return messages;
        }
        return messages;
    }

    public XmlMsgs getSingleObjectMessages(IRI individualIRI, IRI propertyIRI, IRI fillerIRI, XmlMsgs messages, Node messageRoot, NLGUser user) {
        HashSet entities = new HashSet();
        for (OWLOntology ontology : this.mainModels) {
            entities.addAll(ontology.getEntitiesInSignature(individualIRI, true));
        }
        Iterator<Object> iterator = entities.iterator();
        if (iterator.hasNext()) {
            OWLEntity entity = (OWLEntity)iterator.next();
            if (entity.isOWLNamedIndividual()) {
                OWLNamedIndividual subject = entity.asOWLNamedIndividual();
                HashMap<OWLObjectPropertyExpression, Set> objPropertyExprMaps = new HashMap<OWLObjectPropertyExpression, Set>();
                for (OWLOntology oWLOntology : this.mainModels) {
                    for (Map.Entry propertyExprMap : subject.getObjectPropertyValues(oWLOntology).entrySet()) {
                        objPropertyExprMaps.put((OWLObjectPropertyExpression)propertyExprMap.getKey(), (Set)propertyExprMap.getValue());
                    }
                }
                for (Map.Entry entry : objPropertyExprMaps.entrySet()) {
                    OWLObjectPropertyExpression propertyExpr = (OWLObjectPropertyExpression)entry.getKey();
                    ArrayList<Fact> facts = new ArrayList<Fact>();
                    if (!propertyExpr.asOWLObjectProperty().getIRI().equals((Object)propertyIRI)) continue;
                    for (OWLIndividual object : (Set)entry.getValue()) {
                        Fact fact;
                        if (fillerIRI != null) {
                            if (!object.asOWLNamedIndividual().getIRI().equals((Object)fillerIRI)) continue;
                            fact = new Fact(individualIRI, propertyExpr.asOWLObjectProperty().getIRI(), object.asOWLNamedIndividual().getIRI().toString());
                            facts.add(fact);
                            continue;
                        }
                        fact = new Fact(individualIRI, propertyExpr.asOWLObjectProperty().getIRI(), object.asOWLNamedIndividual().getIRI().toString());
                        facts.add(fact);
                    }
                    this.addPropertyMessage(facts, messages, messageRoot, true, 1, 1, user);
                }
            }
            return messages;
        }
        return messages;
    }

    public XmlMsgs getSingleDataMessages(IRI individualIRI, IRI propertyIRI, OWLLiteral filler, XmlMsgs messages, Node messageRoot, NLGUser user) {
        HashSet entities = new HashSet();
        for (OWLOntology ontology : this.mainModels) {
            entities.addAll(ontology.getEntitiesInSignature(individualIRI, true));
        }
        Iterator<Object> iterator = entities.iterator();
        if (iterator.hasNext()) {
            OWLEntity entity = (OWLEntity)iterator.next();
            if (entity.isOWLNamedIndividual()) {
                OWLNamedIndividual subject = entity.asOWLNamedIndividual();
                HashMap<OWLDataPropertyExpression, Set> dataPropertyExprMaps = new HashMap<OWLDataPropertyExpression, Set>();
                for (OWLOntology oWLOntology : this.mainModels) {
                    for (Map.Entry propertyExprMap : subject.getDataPropertyValues(oWLOntology).entrySet()) {
                        dataPropertyExprMaps.put((OWLDataPropertyExpression)propertyExprMap.getKey(), (Set)propertyExprMap.getValue());
                    }
                }
                for (Map.Entry entry : dataPropertyExprMaps.entrySet()) {
                    OWLDataPropertyExpression propertyExpr = (OWLDataPropertyExpression)entry.getKey();
                    ArrayList<Fact> facts = new ArrayList<Fact>();
                    if (!propertyExpr.asOWLDataProperty().getIRI().equals((Object)propertyIRI)) continue;
                    for (OWLLiteral object : (Set)entry.getValue()) {
                        Fact fact;
                        if (filler != null) {
                            if (!object.getLiteral().equals(filler)) continue;
                            fact = new Fact(individualIRI, propertyExpr.asOWLDataProperty().getIRI(), object.getLiteral());
                            facts.add(fact);
                            continue;
                        }
                        fact = new Fact(individualIRI, propertyExpr.asOWLDataProperty().getIRI(), object.getLiteral());
                        facts.add(fact);
                    }
                    this.addPropertyMessage(facts, messages, messageRoot, true, 1, 1, user);
                }
            }
            return messages;
        }
        return messages;
    }

    public XmlMsgs getSpecificMessage(IRI subjectIRI, IRI subjectNLNameIRI, IRI propertyIRI, IRI sentencePlanIRI, IRI objectIRI, IRI objectNLNameIRI, XmlMsgs messages, Node messageRoot, NLGUser user) {
        boolean isObjectProperty = false;
        for (OWLOntology ontology : this.mainModels) {
            if (!ontology.containsObjectPropertyInSignature(propertyIRI, true)) continue;
            isObjectProperty = true;
        }
        Element message = messages.addNewElement((Element)messageRoot, "", "", propertyIRI.getFragment());
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forProperty", propertyIRI.toString());
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", sentencePlanIRI.toString());
        if (subjectNLNameIRI.equals((Object)NLResourceManager.anonymous.getIRI())) {
            subjectNLNameIRI = this.chooseAnonymousNLName(subjectIRI, user);
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "subjectNLName", "anonymous(" + subjectNLNameIRI.toString() + ')');
        } else {
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "subjectNLName", subjectNLNameIRI.toString());
        }
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "ref", subjectIRI.toString());
        if (isObjectProperty) {
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "objectNLName", objectNLNameIRI.toString());
        }
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "value", objectIRI.toString());
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "LEVEL", "1");
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "isConnective", "false");
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "true");
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AGGREG_ALLOWED", "false");
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "FOCUS_LOST", "false");
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "interest", "1");
        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AssimilationScore", "0");
        if (isObjectProperty) {
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "prpType", "objPrp");
        } else {
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "prpType", "dPrp");
        }
        return messages;
    }

    private void addClassExpressionMessages(OWLClassExpression classExpr, IRI individualIRI, XmlMsgs messages, Node messageRoot, ArrayList<Fact> isAFacts, ArrayList<Fact> notIsAFacts, ArrayList<Fact> oneOfFacts, int depth, int level, NLGUser user) {
        block51: {
            block64: {
                block62: {
                    OWLObjectAllValuesFrom allValuesExpr;
                    block63: {
                        block60: {
                            OWLObjectSomeValuesFrom someValuesExpr;
                            block61: {
                                block59: {
                                    block58: {
                                        block57: {
                                            block56: {
                                                block55: {
                                                    block54: {
                                                        block53: {
                                                            block52: {
                                                                block50: {
                                                                    if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) break block50;
                                                                    IRI classIRI = classExpr.asOWLClass().getIRI();
                                                                    Fact fact = NLGEngine.isClass(this.mainModels, individualIRI) ? new Fact(individualIRI, NLResourceManager.isA.getIRI(), classIRI.toString()) : new Fact(individualIRI, NLResourceManager.instanceOf.getIRI(), classIRI.toString());
                                                                    isAFacts.add(fact);
                                                                    break block51;
                                                                }
                                                                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_COMPLEMENT_OF)) break block52;
                                                                OWLObjectComplementOf complementExpr = (OWLObjectComplementOf)classExpr;
                                                                if (complementExpr.getOperand().isAnonymous()) break block51;
                                                                Fact fact = NLGEngine.isClass(this.mainModels, individualIRI) ? new Fact(individualIRI, NLResourceManager.isA.getIRI(), complementExpr.getOperand().asOWLClass().getIRI().toString()) : new Fact(individualIRI, NLResourceManager.instanceOf.getIRI(), complementExpr.getOperand().asOWLClass().getIRI().toString());
                                                                fact.addModifier("not");
                                                                notIsAFacts.add(fact);
                                                                break block51;
                                                            }
                                                            if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ONE_OF)) break block53;
                                                            OWLObjectOneOf oneOfExpr = (OWLObjectOneOf)classExpr;
                                                            for (OWLIndividual indiv : oneOfExpr.getIndividuals()) {
                                                                if (!indiv.isNamed()) continue;
                                                                Fact fact = new Fact(individualIRI, NLResourceManager.oneOf.getIRI(), indiv.asOWLNamedIndividual().getIRI().toString());
                                                                oneOfFacts.add(fact);
                                                            }
                                                            break block51;
                                                        }
                                                        if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_HAS_VALUE)) break block54;
                                                        OWLObjectHasValue hasValueExpr = (OWLObjectHasValue)classExpr;
                                                        ArrayList<Fact> facts = new ArrayList<Fact>();
                                                        if (((OWLIndividual)hasValueExpr.getValue()).isNamed()) {
                                                            Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)hasValueExpr.getProperty()).asOWLObjectProperty().getIRI(), ((OWLIndividual)hasValueExpr.getValue()).asOWLNamedIndividual().getIRI().toString());
                                                            facts.add(fact);
                                                        }
                                                        this.addPropertyMessage(facts, messages, messageRoot, true, depth, level, user);
                                                        break block51;
                                                    }
                                                    if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.DATA_HAS_VALUE)) break block55;
                                                    OWLDataHasValue hasValueExpr = (OWLDataHasValue)classExpr;
                                                    ArrayList<Fact> facts = new ArrayList<Fact>();
                                                    Fact fact = new Fact(individualIRI, ((OWLDataPropertyExpression)hasValueExpr.getProperty()).asOWLDataProperty().getIRI(), ((OWLLiteral)hasValueExpr.getValue()).getLiteral().toString());
                                                    facts.add(fact);
                                                    this.addPropertyMessage(facts, messages, messageRoot, true, depth, level, user);
                                                    break block51;
                                                }
                                                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_HAS_SELF)) break block56;
                                                OWLObjectHasSelf hasSelfExpr = (OWLObjectHasSelf)classExpr;
                                                Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)hasSelfExpr.getProperty()).asOWLObjectProperty().getIRI(), individualIRI.toString());
                                                this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                                                break block51;
                                            }
                                            if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_MAX_CARDINALITY)) break block57;
                                            OWLObjectCardinalityRestriction maxExpr = (OWLObjectCardinalityRestriction)classExpr;
                                            if (((OWLClassExpression)maxExpr.getFiller()).isAnonymous() || !((OWLObjectPropertyExpression)maxExpr.getProperty()).isObjectPropertyExpression()) break block51;
                                            String filler = "";
                                            if (((OWLClassExpression)maxExpr.getFiller()).asOWLClass().isOWLThing()) {
                                                HashSet properties = new HashSet();
                                                for (OWLOntology ontology : this.mainModels) {
                                                    properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                                }
                                                for (OWLObjectProperty property : properties) {
                                                    if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)maxExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                                    HashSet ranges = new HashSet();
                                                    for (OWLOntology ontology : this.mainModels) {
                                                        ranges.addAll(property.getRanges(ontology));
                                                    }
                                                    for (OWLClassExpression range : ranges) {
                                                        if (range.isAnonymous()) continue;
                                                        filler = range.asOWLClass().getIRI().toString();
                                                    }
                                                }
                                            } else {
                                                filler = ((OWLClassExpression)maxExpr.getFiller()).asOWLClass().getIRI().toString();
                                            }
                                            if (filler.isEmpty()) {
                                                for (OWLOntology ontology : this.mainModels) {
                                                    filler = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing().toString();
                                                }
                                            }
                                            Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)maxExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                                            fact.addModifier("maxCardRestriction");
                                            fact.setCardinality(maxExpr.getCardinality());
                                            this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                                            break block51;
                                        }
                                        if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_MIN_CARDINALITY)) break block58;
                                        OWLObjectCardinalityRestriction minExpr = (OWLObjectCardinalityRestriction)classExpr;
                                        if (((OWLClassExpression)minExpr.getFiller()).isAnonymous() || !((OWLObjectPropertyExpression)minExpr.getProperty()).isObjectPropertyExpression()) break block51;
                                        String filler = "";
                                        if (((OWLClassExpression)minExpr.getFiller()).asOWLClass().isOWLThing()) {
                                            HashSet properties = new HashSet();
                                            for (OWLOntology ontology : this.mainModels) {
                                                properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                            }
                                            for (OWLObjectProperty property : properties) {
                                                if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)minExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                                HashSet ranges = new HashSet();
                                                for (OWLOntology ontology : this.mainModels) {
                                                    ranges.addAll(property.getRanges(ontology));
                                                }
                                                for (OWLClassExpression range : ranges) {
                                                    if (range.isAnonymous()) continue;
                                                    filler = range.asOWLClass().getIRI().toString();
                                                }
                                            }
                                        } else {
                                            filler = ((OWLClassExpression)minExpr.getFiller()).asOWLClass().getIRI().toString();
                                        }
                                        if (filler.isEmpty()) {
                                            for (OWLOntology ontology : this.mainModels) {
                                                filler = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing().toString();
                                            }
                                        }
                                        Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)minExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                                        fact.addModifier("minCardRestriction");
                                        fact.setCardinality(minExpr.getCardinality());
                                        this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                                        break block51;
                                    }
                                    if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_EXACT_CARDINALITY)) break block59;
                                    OWLObjectCardinalityRestriction exactExpr = (OWLObjectCardinalityRestriction)classExpr;
                                    if (((OWLClassExpression)exactExpr.getFiller()).isAnonymous() || !((OWLObjectPropertyExpression)exactExpr.getProperty()).isObjectPropertyExpression()) break block51;
                                    String filler = "";
                                    if (((OWLClassExpression)exactExpr.getFiller()).asOWLClass().isOWLThing()) {
                                        HashSet properties = new HashSet();
                                        for (OWLOntology ontology : this.mainModels) {
                                            properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                        }
                                        for (OWLObjectProperty property : properties) {
                                            if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)exactExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                            HashSet ranges = new HashSet();
                                            for (OWLOntology ontology : this.mainModels) {
                                                ranges.addAll(property.getRanges(ontology));
                                            }
                                            for (OWLClassExpression range : ranges) {
                                                if (range.isAnonymous()) continue;
                                                filler = range.asOWLClass().getIRI().toString();
                                            }
                                        }
                                    } else {
                                        filler = ((OWLClassExpression)exactExpr.getFiller()).asOWLClass().getIRI().toString();
                                    }
                                    if (filler.isEmpty()) {
                                        for (OWLOntology ontology : this.mainModels) {
                                            filler = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing().toString();
                                        }
                                    }
                                    Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)exactExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                                    fact.addModifier("exactCardRestriction");
                                    fact.setCardinality(exactExpr.getCardinality());
                                    this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                                    break block51;
                                }
                                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_SOME_VALUES_FROM)) break block60;
                                someValuesExpr = (OWLObjectSomeValuesFrom)classExpr;
                                if (((OWLClassExpression)someValuesExpr.getFiller()).isAnonymous()) break block61;
                                if (!((OWLObjectPropertyExpression)someValuesExpr.getProperty()).isObjectPropertyExpression()) break block51;
                                String filler = "";
                                if (((OWLClassExpression)someValuesExpr.getFiller()).asOWLClass().isOWLThing()) {
                                    HashSet properties = new HashSet();
                                    for (OWLOntology ontology : this.mainModels) {
                                        properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                    }
                                    for (OWLObjectProperty property : properties) {
                                        if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)someValuesExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                        HashSet ranges = new HashSet();
                                        for (OWLOntology ontology : this.mainModels) {
                                            ranges.addAll(property.getRanges(ontology));
                                        }
                                        for (OWLClassExpression range : ranges) {
                                            if (range.isAnonymous()) continue;
                                            filler = range.asOWLClass().getIRI().toString();
                                        }
                                    }
                                } else {
                                    filler = ((OWLClassExpression)someValuesExpr.getFiller()).asOWLClass().getIRI().toString();
                                }
                                if (filler.isEmpty()) {
                                    for (OWLOntology ontology : this.mainModels) {
                                        filler = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing().toString();
                                    }
                                }
                                Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)someValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                                fact.addModifier("someValuesFromRestriction");
                                this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                                break block51;
                            }
                            if (!((OWLClassExpression)someValuesExpr.getFiller()).getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ONE_OF)) break block51;
                            OWLObjectOneOf oneOfExpr = (OWLObjectOneOf)someValuesExpr.getFiller();
                            for (OWLIndividual indiv : oneOfExpr.getIndividuals()) {
                                if (!indiv.isNamed()) continue;
                                Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)someValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), indiv.asOWLNamedIndividual().getIRI().toString());
                                fact.addModifier("someValuesFromRestriction");
                                this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                            }
                            break block51;
                        }
                        if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ALL_VALUES_FROM)) break block62;
                        allValuesExpr = (OWLObjectAllValuesFrom)classExpr;
                        if (((OWLClassExpression)allValuesExpr.getFiller()).isAnonymous()) break block63;
                        if (!((OWLObjectPropertyExpression)allValuesExpr.getProperty()).isObjectPropertyExpression()) break block51;
                        String filler = "";
                        if (((OWLClassExpression)allValuesExpr.getFiller()).asOWLClass().isOWLThing()) {
                            HashSet properties = new HashSet();
                            for (OWLOntology ontology : this.mainModels) {
                                properties.addAll(ontology.getObjectPropertiesInSignature(true));
                            }
                            for (OWLObjectProperty property : properties) {
                                if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)allValuesExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                HashSet ranges = new HashSet();
                                for (OWLOntology ontology : this.mainModels) {
                                    ranges.addAll(property.getRanges(ontology));
                                }
                                for (OWLClassExpression range : ranges) {
                                    if (range.isAnonymous()) continue;
                                    filler = range.asOWLClass().getIRI().toString();
                                }
                            }
                        } else {
                            filler = ((OWLClassExpression)allValuesExpr.getFiller()).asOWLClass().getIRI().toString();
                        }
                        if (filler.isEmpty()) {
                            for (OWLOntology ontology : this.mainModels) {
                                filler = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLThing().toString();
                            }
                        }
                        Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)allValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                        fact.addModifier("allValuesFromRestriction");
                        this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                        break block51;
                    }
                    if (!((OWLClassExpression)allValuesExpr.getFiller()).getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ONE_OF)) break block51;
                    OWLObjectOneOf oneOfExpr = (OWLObjectOneOf)allValuesExpr.getFiller();
                    for (OWLIndividual indiv : oneOfExpr.getIndividuals()) {
                        if (!indiv.isNamed()) continue;
                        Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)allValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), indiv.asOWLNamedIndividual().getIRI().toString());
                        fact.addModifier("allValuesFromRestriction");
                        this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                    }
                    break block51;
                }
                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_UNION_OF)) break block64;
                OWLObjectUnionOf unionOfExpr = (OWLObjectUnionOf)classExpr;
                boolean containsMultiClassOperators = false;
                for (OWLClassExpression disjunctExpr : unionOfExpr.asDisjunctSet()) {
                    if (!disjunctExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_UNION_OF) && !disjunctExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) continue;
                    containsMultiClassOperators = true;
                }
                if (containsMultiClassOperators) break block51;
                for (OWLClassExpression disjunctExpr : unionOfExpr.asDisjunctSet()) {
                    this.addDisjunctedClassExpressionMessages(disjunctExpr, individualIRI, messages, messageRoot, depth, level, user);
                }
                break block51;
            }
            if (classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) {
                OWLObjectIntersectionOf intersectionOfExpr = (OWLObjectIntersectionOf)classExpr;
                boolean containsMultiClassOperators = false;
                for (OWLClassExpression conjunctExpr : intersectionOfExpr.asConjunctSet()) {
                    if (!conjunctExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_UNION_OF) && !conjunctExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) continue;
                    containsMultiClassOperators = true;
                }
                if (!containsMultiClassOperators) {
                    for (OWLClassExpression conjunctExpr : intersectionOfExpr.asConjunctSet()) {
                        this.addClassExpressionMessages(conjunctExpr, individualIRI, messages, messageRoot, isAFacts, notIsAFacts, oneOfFacts, depth, level, user);
                    }
                }
            }
        }
    }

    private void addDisjunctedClassExpressionMessages(OWLClassExpression classExpr, IRI individualIRI, XmlMsgs messages, Node messageRoot, int depth, int level, NLGUser user) {
        block24: {
            OWLObjectAllValuesFrom allValuesExpr;
            block34: {
                block32: {
                    OWLObjectSomeValuesFrom someValuesExpr;
                    block33: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block27: {
                                            block26: {
                                                block25: {
                                                    block23: {
                                                        if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) break block23;
                                                        IRI classIRI = classExpr.asOWLClass().getIRI();
                                                        Fact fact = new Fact(individualIRI, NLResourceManager.isA.getIRI(), classIRI.toString());
                                                        this.addDomainIndependentMessage(fact, messages, messageRoot, false, depth, level, user);
                                                        break block24;
                                                    }
                                                    if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_COMPLEMENT_OF)) break block25;
                                                    OWLObjectComplementOf complementExpr = (OWLObjectComplementOf)classExpr;
                                                    if (complementExpr.getOperand().isAnonymous()) break block24;
                                                    Fact fact = new Fact(individualIRI, NLResourceManager.isA.getIRI(), complementExpr.getOperand().asOWLClass().getIRI().toString());
                                                    fact.addModifier("not");
                                                    this.addDomainIndependentMessage(fact, messages, messageRoot, false, depth, level, user);
                                                    break block24;
                                                }
                                                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ONE_OF)) break block26;
                                                OWLObjectOneOf oneOfExpr = (OWLObjectOneOf)classExpr;
                                                for (OWLIndividual indiv : oneOfExpr.getIndividuals()) {
                                                    if (!indiv.isNamed()) continue;
                                                    Fact fact = new Fact(individualIRI, NLResourceManager.oneOf.getIRI(), indiv.asOWLNamedIndividual().getIRI().toString());
                                                    this.addDomainIndependentMessage(fact, messages, messageRoot, false, depth, level, user);
                                                }
                                                break block24;
                                            }
                                            if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_HAS_VALUE)) break block27;
                                            OWLObjectHasValue hasValueExpr = (OWLObjectHasValue)classExpr;
                                            ArrayList<Fact> facts = new ArrayList<Fact>();
                                            if (((OWLIndividual)hasValueExpr.getValue()).isNamed()) {
                                                Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)hasValueExpr.getProperty()).asOWLObjectProperty().getIRI(), ((OWLIndividual)hasValueExpr.getValue()).asOWLNamedIndividual().getIRI().toString());
                                                facts.add(fact);
                                            }
                                            this.addPropertyMessage(facts, messages, messageRoot, false, depth, level, user);
                                            break block24;
                                        }
                                        if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_HAS_SELF)) break block28;
                                        OWLObjectHasSelf hasSelfExpr = (OWLObjectHasSelf)classExpr;
                                        Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)hasSelfExpr.getProperty()).asOWLObjectProperty().getIRI(), individualIRI.toString());
                                        this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                                        break block24;
                                    }
                                    if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_MAX_CARDINALITY)) break block29;
                                    OWLObjectCardinalityRestriction maxExpr = (OWLObjectCardinalityRestriction)classExpr;
                                    if (((OWLClassExpression)maxExpr.getFiller()).isAnonymous() || !((OWLObjectPropertyExpression)maxExpr.getProperty()).isObjectPropertyExpression()) break block24;
                                    String filler = "";
                                    if (((OWLClassExpression)maxExpr.getFiller()).asOWLClass().isOWLThing()) {
                                        HashSet properties = new HashSet();
                                        for (OWLOntology ontology : this.mainModels) {
                                            properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                        }
                                        for (OWLObjectProperty property : properties) {
                                            if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)maxExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                            HashSet ranges = new HashSet();
                                            for (OWLOntology ontology : this.mainModels) {
                                                ranges.addAll(property.getRanges(ontology));
                                            }
                                            for (OWLClassExpression range : ranges) {
                                                if (range.isAnonymous()) continue;
                                                filler = range.asOWLClass().getIRI().toString();
                                            }
                                        }
                                    } else {
                                        filler = ((OWLClassExpression)maxExpr.getFiller()).asOWLClass().getIRI().toString();
                                    }
                                    Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)maxExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                                    fact.addModifier("maxCardRestriction");
                                    fact.setCardinality(maxExpr.getCardinality());
                                    this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                                    break block24;
                                }
                                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_MIN_CARDINALITY)) break block30;
                                OWLObjectCardinalityRestriction minExpr = (OWLObjectCardinalityRestriction)classExpr;
                                if (((OWLClassExpression)minExpr.getFiller()).isAnonymous() || !((OWLObjectPropertyExpression)minExpr.getProperty()).isObjectPropertyExpression()) break block24;
                                String filler = "";
                                if (((OWLClassExpression)minExpr.getFiller()).asOWLClass().isOWLThing()) {
                                    HashSet properties = new HashSet();
                                    for (OWLOntology ontology : this.mainModels) {
                                        properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                    }
                                    for (OWLObjectProperty property : properties) {
                                        if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)minExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                        HashSet ranges = new HashSet();
                                        for (OWLOntology ontology : this.mainModels) {
                                            ranges.addAll(property.getRanges(ontology));
                                        }
                                        for (OWLClassExpression range : ranges) {
                                            if (range.isAnonymous()) continue;
                                            filler = range.asOWLClass().getIRI().toString();
                                        }
                                    }
                                } else {
                                    filler = ((OWLClassExpression)minExpr.getFiller()).asOWLClass().getIRI().toString();
                                }
                                Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)minExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                                fact.addModifier("minCardRestriction");
                                fact.setCardinality(minExpr.getCardinality());
                                this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                                break block24;
                            }
                            if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_EXACT_CARDINALITY)) break block31;
                            OWLObjectCardinalityRestriction exactExpr = (OWLObjectCardinalityRestriction)classExpr;
                            if (((OWLClassExpression)exactExpr.getFiller()).isAnonymous() || !((OWLObjectPropertyExpression)exactExpr.getProperty()).isObjectPropertyExpression()) break block24;
                            String filler = "";
                            if (((OWLClassExpression)exactExpr.getFiller()).asOWLClass().isOWLThing()) {
                                HashSet properties = new HashSet();
                                for (OWLOntology ontology : this.mainModels) {
                                    properties.addAll(ontology.getObjectPropertiesInSignature(true));
                                }
                                for (OWLObjectProperty property : properties) {
                                    if (!property.getIRI().equals((Object)((OWLObjectPropertyExpression)exactExpr.getProperty()).asOWLObjectProperty().getIRI())) continue;
                                    HashSet ranges = new HashSet();
                                    for (OWLOntology ontology : this.mainModels) {
                                        ranges.addAll(property.getRanges(ontology));
                                    }
                                    for (OWLClassExpression range : ranges) {
                                        if (range.isAnonymous()) continue;
                                        filler = range.asOWLClass().getIRI().toString();
                                    }
                                }
                            } else {
                                filler = ((OWLClassExpression)exactExpr.getFiller()).asOWLClass().getIRI().toString();
                            }
                            Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)exactExpr.getProperty()).asOWLObjectProperty().getIRI(), filler);
                            fact.addModifier("exactCardRestriction");
                            fact.setCardinality(exactExpr.getCardinality());
                            this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                            break block24;
                        }
                        if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_SOME_VALUES_FROM)) break block32;
                        someValuesExpr = (OWLObjectSomeValuesFrom)classExpr;
                        if (((OWLClassExpression)someValuesExpr.getFiller()).isAnonymous()) break block33;
                        if (!((OWLObjectPropertyExpression)someValuesExpr.getProperty()).isObjectPropertyExpression()) break block24;
                        Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)someValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), ((OWLClassExpression)someValuesExpr.getFiller()).asOWLClass().getIRI().toString());
                        fact.addModifier("someValuesFromRestriction");
                        this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                        break block24;
                    }
                    if (!((OWLClassExpression)someValuesExpr.getFiller()).getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ONE_OF)) break block24;
                    OWLObjectOneOf oneOfExpr = (OWLObjectOneOf)someValuesExpr.getFiller();
                    for (OWLIndividual indiv : oneOfExpr.getIndividuals()) {
                        if (!indiv.isNamed()) continue;
                        Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)someValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), indiv.asOWLNamedIndividual().getIRI().toString());
                        fact.addModifier("someValuesFromRestriction");
                        this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                    }
                    break block24;
                }
                if (!classExpr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ALL_VALUES_FROM)) break block24;
                allValuesExpr = (OWLObjectAllValuesFrom)classExpr;
                if (((OWLClassExpression)allValuesExpr.getFiller()).isAnonymous()) break block34;
                if (!((OWLObjectPropertyExpression)allValuesExpr.getProperty()).isObjectPropertyExpression()) break block24;
                Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)allValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), ((OWLClassExpression)allValuesExpr.getFiller()).asOWLClass().getIRI().toString());
                fact.addModifier("allValuesFromRestriction");
                this.addPropertyMessage(fact, messages, messageRoot, true, depth, level, user);
                break block24;
            }
            if (((OWLClassExpression)allValuesExpr.getFiller()).getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_ONE_OF)) {
                OWLObjectOneOf oneOfExpr = (OWLObjectOneOf)allValuesExpr.getFiller();
                for (OWLIndividual indiv : oneOfExpr.getIndividuals()) {
                    if (!indiv.isNamed()) continue;
                    Fact fact = new Fact(individualIRI, ((OWLObjectPropertyExpression)allValuesExpr.getProperty()).asOWLObjectProperty().getIRI(), indiv.asOWLNamedIndividual().getIRI().toString());
                    fact.addModifier("allValuesFromRestriction");
                    this.addPropertyMessage(fact, messages, messageRoot, false, depth, level, user);
                }
            }
        }
    }

    private void addDomainIndependentMessage(Fact fact, XmlMsgs messages, Node messageRoot, boolean isConnective, int depth, int level, NLGUser user) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        this.addDomainIndependentMessage(facts, messages, messageRoot, isConnective, depth, level, user);
    }

    private void addDomainIndependentMessage(ArrayList<Fact> facts, XmlMsgs messages, Node messageRoot, boolean isConnective, int depth, int level, NLGUser user) {
        if (!facts.isEmpty()) {
            StringBuffer NLNameMessage;
            StringBuffer valueMessage;
            IRI forModifier;
            String interestValue = "";
            String assimilationScore = "";
            Fact fact = facts.get(0);
            Element message = messages.addNewElement((Element)messageRoot, NLResourceManager.nlowlNS, XmlMsgs.prefix, fact.getPredicate().getFragment());
            if (fact.getPredicate().equals((Object)NLResourceManager.isA.getIRI()) || fact.getPredicate().equals((Object)NLResourceManager.instanceOf.getIRI())) {
                if (fact.getPredicate().equals((Object)NLResourceManager.isA.getIRI())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forDomainIndependentProperty", NLResourceManager.isA.getIRI().toString());
                } else {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forDomainIndependentProperty", NLResourceManager.instanceOf.getIRI().toString());
                }
                if (Languages.isEnglish(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.isASPEN_IRI.toString());
                } else if (Languages.isGreek(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.isASPGR_IRI.toString());
                }
                if (fact.hasModifier("not")) {
                    if (XmlMsgs.getAttribute(message, XmlMsgs.prefix, "polarity").equals("false")) {
                        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "true");
                    }
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "false");
                } else {
                    if (XmlMsgs.getAttribute(message, XmlMsgs.prefix, "polarity").equals("true")) {
                        messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "false");
                    }
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "true");
                }
                forModifier = null;
                if (fact.hasModifier("maxCardRestriction")) {
                    forModifier = NLResourceManager.maxCardinality.getIRI();
                } else if (fact.hasModifier("minCardRestriction")) {
                    forModifier = NLResourceManager.minCardinality.getIRI();
                } else if (fact.hasModifier("exactCardRestriction")) {
                    forModifier = NLResourceManager.exactCardinality.getIRI();
                } else if (fact.hasModifier("allValuesFromRestriction")) {
                    forModifier = NLResourceManager.allValuesFrom.getIRI();
                } else if (fact.hasModifier("someValuesFromRestriction")) {
                    forModifier = NLResourceManager.someValuesFrom.getIRI();
                }
                if (user != null) {
                    interestValue = fact.getPredicate().equals((Object)NLResourceManager.isA.getIRI()) ? "" + this.UMQM.getInterest(NLResourceManager.isA.getIRI(), fact.getSubject(), forModifier, user.getUserModel().getUMIRI()) : "" + this.UMQM.getInterest(NLResourceManager.instanceOf.getIRI(), fact.getSubject(), forModifier, user.getUserModel().getUMIRI());
                    assimilationScore = "" + this.calculateAssimilationScore(fact, user);
                } else {
                    interestValue = "1";
                    assimilationScore = "0";
                }
            } else if (fact.getPredicate().equals((Object)NLResourceManager.sameIndividuals.getIRI())) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forDomainIndependentProperty", NLResourceManager.sameIndividuals.getIRI().toString());
                if (Languages.isEnglish(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.sameIndividualSPEN_IRI.toString());
                } else if (Languages.isGreek(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.sameIndividualSPGR_IRI.toString());
                }
                forModifier = null;
                if (fact.hasModifier("maxCardRestriction")) {
                    forModifier = NLResourceManager.maxCardinality.getIRI();
                } else if (fact.hasModifier("minCardRestriction")) {
                    forModifier = NLResourceManager.minCardinality.getIRI();
                } else if (fact.hasModifier("exactCardRestriction")) {
                    forModifier = NLResourceManager.exactCardinality.getIRI();
                } else if (fact.hasModifier("allValuesFromRestriction")) {
                    forModifier = NLResourceManager.allValuesFrom.getIRI();
                } else if (fact.hasModifier("someValuesFromRestriction")) {
                    forModifier = NLResourceManager.someValuesFrom.getIRI();
                }
                if (user != null) {
                    interestValue = "" + this.UMQM.getInterest(NLResourceManager.sameIndividuals.getIRI(), fact.getSubject(), forModifier, user.getUserModel().getUMIRI());
                    assimilationScore = "" + this.calculateAssimilationScore(fact, user);
                } else {
                    interestValue = "1";
                    assimilationScore = "0";
                }
            } else if (fact.getPredicate().equals((Object)NLResourceManager.differentIndividuals.getIRI())) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forDomainIndependentProperty", NLResourceManager.differentIndividuals.getIRI().toString());
                if (Languages.isEnglish(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.sameIndividualSPEN_IRI.toString());
                } else if (Languages.isGreek(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.sameIndividualSPGR_IRI.toString());
                }
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "false");
                forModifier = null;
                if (fact.hasModifier("maxCardRestriction")) {
                    forModifier = NLResourceManager.maxCardinality.getIRI();
                } else if (fact.hasModifier("minCardRestriction")) {
                    forModifier = NLResourceManager.minCardinality.getIRI();
                } else if (fact.hasModifier("exactCardRestriction")) {
                    forModifier = NLResourceManager.exactCardinality.getIRI();
                } else if (fact.hasModifier("allValuesFromRestriction")) {
                    forModifier = NLResourceManager.allValuesFrom.getIRI();
                } else if (fact.hasModifier("someValuesFromRestriction")) {
                    forModifier = NLResourceManager.someValuesFrom.getIRI();
                }
                if (user != null) {
                    interestValue = "" + this.UMQM.getInterest(NLResourceManager.differentIndividuals.getIRI(), fact.getSubject(), forModifier, user.getUserModel().getUMIRI());
                    assimilationScore = "" + this.calculateAssimilationScore(fact, user);
                } else {
                    interestValue = "1";
                    assimilationScore = "0";
                }
            } else if (fact.getPredicate().equals((Object)NLResourceManager.oneOf.getIRI())) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forDomainIndependentProperty", NLResourceManager.oneOf.getIRI().toString());
                if (Languages.isEnglish(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.isASPEN_IRI.toString());
                } else if (Languages.isGreek(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.isASPGR_IRI.toString());
                }
                forModifier = null;
                if (fact.hasModifier("maxCardRestriction")) {
                    forModifier = NLResourceManager.maxCardinality.getIRI();
                } else if (fact.hasModifier("minCardRestriction")) {
                    forModifier = NLResourceManager.minCardinality.getIRI();
                } else if (fact.hasModifier("exactCardRestriction")) {
                    forModifier = NLResourceManager.exactCardinality.getIRI();
                } else if (fact.hasModifier("allValuesFromRestriction")) {
                    forModifier = NLResourceManager.allValuesFrom.getIRI();
                } else if (fact.hasModifier("someValuesFromRestriction")) {
                    forModifier = NLResourceManager.someValuesFrom.getIRI();
                }
                if (user != null) {
                    interestValue = "" + this.UMQM.getInterest(NLResourceManager.oneOf.getIRI(), fact.getSubject(), forModifier, user.getUserModel().getUMIRI());
                    assimilationScore = "" + this.calculateAssimilationScore(fact, user);
                } else {
                    interestValue = "1";
                    assimilationScore = "0";
                }
            }
            IRI propertyIRI = fact.getPredicate();
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forProperty", propertyIRI.toString());
            if (isConnective) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "isConnective", "true");
                valueMessage = new StringBuffer("and(");
                NLNameMessage = new StringBuffer("and(");
            } else {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "isConnective", "false");
                valueMessage = new StringBuffer("or(");
                NLNameMessage = new StringBuffer("or(");
            }
            boolean useKindOf = false;
            ArrayList<IRI> objectNLNames = new ArrayList<IRI>();
            for (Fact f : facts) {
                IRI objectNLName = null;
                boolean contains = false;
                for (OWLOntology ontology : this.mainModels) {
                    if (!ontology.containsEntityInSignature(IRI.create((String)fact.getObject()), true)) continue;
                    contains = true;
                }
                if (contains) {
                    if (!f.getObject().isEmpty()) {
                        objectNLName = this.chooseNLName(IRI.create((String)f.getObject()), user);
                        if (objectNLName.equals((Object)NLResourceManager.anonymous.getIRI())) {
                            objectNLName = null;
                        }
                    } else if (Languages.isEnglish(this.getLanguage())) {
                        objectNLName = DefaultResourcesManager.entityNLNEN_IRI;
                    } else if (Languages.isGreek(this.getLanguage())) {
                        objectNLName = DefaultResourcesManager.entityNLNGR_IRI;
                    }
                    if (objectNLName != null) {
                        NLNameMessage.append(objectNLName.toString()).append(", ");
                        objectNLNames.add(objectNLName);
                    }
                }
                if (objectNLName == null) continue;
                valueMessage.append(f.getObject().toString()).append(", ");
                if (!NLGEngine.isClass(this.mainModels, f.getSubject()) || !f.getPredicate().equals((Object)NLResourceManager.isA.getIRI()) || this.NLNQM.getNLName(objectNLName).getHeadSlot() instanceof NLNAdjectiveSlot) continue;
                useKindOf = true;
            }
            valueMessage = new StringBuffer(valueMessage.substring(0, valueMessage.length() - 2));
            valueMessage.append(")");
            NLNameMessage = new StringBuffer(NLNameMessage.substring(0, NLNameMessage.length() - 2));
            NLNameMessage.append(")");
            IRI subjectNLName = this.chooseNLName(fact.getSubject(), user);
            if (subjectNLName != null) {
                if (subjectNLName.equals((Object)NLResourceManager.anonymous.getIRI())) {
                    subjectNLName = this.chooseAnonymousNLName(fact.getSubject(), user);
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "subjectNLName", "anonymous(" + subjectNLName.toString() + ')');
                } else {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "subjectNLName", subjectNLName.toString());
                }
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "value", valueMessage.toString());
            boolean contains = false;
            for (OWLOntology ontology : this.mainModels) {
                if (!ontology.containsEntityInSignature(IRI.create((String)fact.getObject()), true)) continue;
                contains = true;
            }
            if (contains) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "objectNLName", NLNameMessage.toString());
            }
            if (useKindOf) {
                if (Languages.isEnglish(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.kindOfSPEN_IRI.toString());
                } else if (Languages.isGreek(this.getLanguage())) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", DefaultResourcesManager.kindOfSPGR_IRI.toString());
                }
            }
            if (fact.getPredicate().equals((Object)NLResourceManager.isA.getIRI()) || fact.getPredicate().equals((Object)NLResourceManager.instanceOf.getIRI())) {
                String aggAllowedSubjectNLN = String.valueOf(this.NLNQM.getIsAggAllowed(subjectNLName, this.getLanguage()));
                boolean aggAllowedObjectNLN = true;
                for (IRI objectNLName : objectNLNames) {
                    if (this.NLNQM.getIsAggAllowed(objectNLName, this.getLanguage())) continue;
                    aggAllowedObjectNLN = false;
                }
                if (aggAllowedSubjectNLN.equals("true") && aggAllowedObjectNLN) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AGGREG_ALLOWED", "true");
                } else {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AGGREG_ALLOWED", "false");
                }
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "ref", fact.getSubject().toString());
            if (this.OQM.getPropertySection(propertyIRI).equals((Object)NLResourceManager.defaultSection.getIRI())) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "order", "0");
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "section", "0");
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sectionName", NLResourceManager.defaultSection.getIRI().getFragment());
            } else {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "order", "" + this.OQM.getPropertyOrder(propertyIRI));
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "section", "" + this.OQM.getPropertySectionOrder(propertyIRI));
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sectionName", this.OQM.getPropertySection(propertyIRI).getFragment());
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "LEVEL", String.valueOf(level));
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "interest", interestValue);
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AssimilationScore", assimilationScore);
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "prpType", "objPrp");
            contains = false;
            for (OWLOntology ontology : this.mainModels) {
                if (!ontology.containsClassInSignature(fact.getSubject(), true)) continue;
                contains = true;
            }
            if (!contains) {
                contains = false;
                for (OWLOntology ontology : this.mainModels) {
                    if (!ontology.containsClassInSignature(IRI.create((String)fact.getObject()), true) || level >= depth) continue;
                    contains = true;
                }
                boolean contains2 = false;
                for (OWLOntology ontology : this.mainModels) {
                    if (!ontology.containsIndividualInSignature(IRI.create((String)fact.getObject()), true) || level >= depth) continue;
                    contains2 = true;
                }
                if (contains) {
                    this.getClassMessages(IRI.create((String)fact.getObject()), messages, message, depth, ++level, user);
                } else if (contains2) {
                    this.getIndividualMessages(IRI.create((String)fact.getObject()), messages, message, depth, ++level, user);
                }
            }
        }
    }

    private void addPropertyMessage(Fact fact, XmlMsgs messages, Node messageRoot, boolean isConnective, int depth, int level, NLGUser user) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        this.addPropertyMessage(facts, messages, messageRoot, isConnective, depth, level, user);
    }

    private void addPropertyMessage(ArrayList<Fact> facts, XmlMsgs messages, Node messageRoot, boolean isConnective, int depth, int level, NLGUser user) {
        if (!facts.isEmpty()) {
            StringBuffer NLNameMessage;
            StringBuffer valueMessage;
            IRI subjectNLName;
            boolean isObjectProperty = false;
            Fact fact = facts.get(0);
            IRI propertyIRI = fact.getPredicate();
            for (OWLOntology ontology : this.mainModels) {
                if (!ontology.containsObjectPropertyInSignature(propertyIRI, true)) continue;
                isObjectProperty = true;
            }
            IRI sentencePlanSelected = this.chooseSentencePlan(propertyIRI, user);
            Element message = messages.addNewElement((Element)messageRoot, "", "", propertyIRI.getFragment());
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "forProperty", propertyIRI.toString());
            if (sentencePlanSelected != null) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sentencePlan", sentencePlanSelected.toString());
            }
            if ((subjectNLName = this.chooseNLName(fact.getSubject(), user)) != null) {
                if (subjectNLName.equals((Object)NLResourceManager.anonymous.getIRI())) {
                    subjectNLName = this.chooseAnonymousNLName(fact.getSubject(), user);
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "subjectNLName", "anonymous(" + subjectNLName.toString() + ')');
                } else {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "subjectNLName", subjectNLName.toString());
                }
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "ref", fact.getSubject().toString());
            if (isConnective) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "isConnective", "true");
                valueMessage = new StringBuffer("and(");
                NLNameMessage = new StringBuffer("and(");
            } else {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "isConnective", "false");
                valueMessage = new StringBuffer("or(");
                NLNameMessage = new StringBuffer("or(");
            }
            ArrayList<IRI> objectNLNames = new ArrayList<IRI>();
            for (Fact f : facts) {
                IRI objectNLName = null;
                if (isObjectProperty) {
                    if (!f.getObject().isEmpty()) {
                        objectNLName = this.chooseNLName(IRI.create((String)f.getObject()), user);
                        if (objectNLName.equals((Object)NLResourceManager.anonymous.getIRI())) {
                            objectNLName = null;
                        }
                    } else if (Languages.isEnglish(this.getLanguage())) {
                        objectNLName = DefaultResourcesManager.entityNLNEN_IRI;
                    } else if (Languages.isGreek(this.getLanguage())) {
                        objectNLName = DefaultResourcesManager.entityNLNGR_IRI;
                    }
                    if (objectNLName == null) continue;
                    valueMessage.append(f.getObject().toString()).append(", ");
                    if (objectNLName.equals((Object)NLResourceManager.anonymous.getIRI())) {
                        objectNLName = this.MQM.getDefaultNLName(IRI.create((String)f.getObject()), this.NLNQM, this.getLanguage());
                    }
                    NLNameMessage.append(objectNLName.toString()).append(", ");
                    objectNLNames.add(objectNLName);
                    continue;
                }
                valueMessage.append(f.getObject().toString()).append(", ");
            }
            if (valueMessage.substring(valueMessage.length() - 2).equals(", ")) {
                valueMessage = new StringBuffer(valueMessage.substring(0, valueMessage.length() - 2));
            }
            valueMessage.append(")");
            if (NLNameMessage.substring(NLNameMessage.length() - 2).equals(", ")) {
                NLNameMessage = new StringBuffer(NLNameMessage.substring(0, NLNameMessage.length() - 2));
            }
            NLNameMessage.append(")");
            if (isObjectProperty && subjectNLName != null) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "objectNLName", NLNameMessage.toString());
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "value", valueMessage.toString());
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "LEVEL", "" + level);
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "order", "" + this.OQM.getPropertyOrder(propertyIRI));
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "section", "" + this.OQM.getPropertySectionOrder(propertyIRI));
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "sectionName", this.OQM.getPropertySection(propertyIRI).getFragment());
            if (fact.hasModifier("not")) {
                if (XmlMsgs.getAttribute(message, XmlMsgs.prefix, "polarity").equals("false")) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "true");
                }
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "false");
            } else {
                if (XmlMsgs.getAttribute(message, XmlMsgs.prefix, "polarity").equals("true")) {
                    messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "false");
                }
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "polarity", "true");
            }
            if (fact.hasModifier("maxCardRestriction")) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "modifier", "maxCardRestriction");
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "cardinality", String.valueOf(fact.getCardinality()));
            } else if (fact.hasModifier("minCardRestriction")) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "modifier", "minCardRestriction");
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "cardinality", String.valueOf(fact.getCardinality()));
            } else if (fact.hasModifier("exactCardRestriction")) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "modifier", "exactCardRestriction");
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "cardinality", String.valueOf(fact.getCardinality()));
            } else if (fact.hasModifier("allValuesFromRestriction")) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "modifier", "allValuesFromRestriction");
            } else if (fact.hasModifier("someValuesFromRestriction")) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "modifier", "someValuesFromRestriction");
            }
            String aggAllowedSP = String.valueOf(this.SPQM.getIsAggAllowed(sentencePlanSelected, this.getLanguage()));
            String aggAllowedSubjectNLN = String.valueOf(this.NLNQM.getIsAggAllowed(subjectNLName, this.getLanguage()));
            boolean aggAllowedObjectNLN = true;
            boolean focusLost = false;
            for (IRI objectNLName : objectNLNames) {
                if (!this.NLNQM.getIsAggAllowed(objectNLName, this.getLanguage())) {
                    aggAllowedObjectNLN = false;
                }
                if (!this.NLNQM.getFocusLost(objectNLName, this.getLanguage())) continue;
                focusLost = true;
            }
            if (aggAllowedSP.equals("true") && aggAllowedSubjectNLN.equals("true") && aggAllowedObjectNLN) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AGGREG_ALLOWED", "true");
            } else {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AGGREG_ALLOWED", "false");
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "FOCUS_LOST", String.valueOf(focusLost));
            String interestValue = "";
            String assimilationScore = "";
            IRI forModifier = null;
            if (fact.hasModifier("maxCardRestriction")) {
                forModifier = NLResourceManager.maxCardinality.getIRI();
            } else if (fact.hasModifier("minCardRestriction")) {
                forModifier = NLResourceManager.minCardinality.getIRI();
            } else if (fact.hasModifier("exactCardRestriction")) {
                forModifier = NLResourceManager.exactCardinality.getIRI();
            } else if (fact.hasModifier("allValuesFromRestriction")) {
                forModifier = NLResourceManager.allValuesFrom.getIRI();
            } else if (fact.hasModifier("someValuesFromRestriction")) {
                forModifier = NLResourceManager.someValuesFrom.getIRI();
            }
            if (user != null) {
                interestValue = "" + this.UMQM.getInterest(propertyIRI, fact.getSubject(), forModifier, user.getUserModel().getUMIRI());
                assimilationScore = "" + this.calculateAssimilationScore(fact, user);
            } else {
                interestValue = "1";
                assimilationScore = "0";
            }
            if (depth == 2 && !XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "sentencePlan").isEmpty()) {
                SentencePlan plan = this.SPQM.getSentencePlan(IRI.create((String)XmlMsgs.getAttribute(messageRoot, XmlMsgs.prefix, "sentencePlan")));
                for (SPSlot slot : plan.getSlotsList()) {
                    if (!(slot instanceof SPConcatenationSlot)) continue;
                    for (SPConcatenationPropertySlot propertySlot : ((SPConcatenationSlot)slot).getPropertySlots()) {
                        if (!propertySlot.getPropertyIRI().equals((Object)fact.getPredicate())) continue;
                        interestValue = "0";
                    }
                }
            }
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "interest", interestValue);
            messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "AssimilationScore", assimilationScore);
            if (isObjectProperty) {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "prpType", "objPrp");
                boolean contains = false;
                for (OWLOntology ontology : this.mainModels) {
                    if (!ontology.containsClassInSignature(fact.getSubject())) continue;
                    contains = true;
                    break;
                }
                if (!contains && level < depth) {
                    this.getIndividualMessages(IRI.create((String)fact.getObject()), messages, message, depth, ++level, user);
                }
            } else {
                messages.setAttr(message, NLResourceManager.nlowlNS, XmlMsgs.prefix, "prpType", "dPrp");
            }
        }
    }

    public IRI chooseSentencePlan(IRI propertyIRI, NLGUser user) {
        IRI sentencePlanSelected = null;
        if (!this.usedSentencePlanInDescr.containsKey(propertyIRI)) {
            sentencePlanSelected = this.MQM.chooseSentencePlan(propertyIRI, this.SPQM, this.getLanguage(), user);
            this.usedSentencePlanInDescr.put(propertyIRI, sentencePlanSelected);
        } else {
            sentencePlanSelected = this.usedSentencePlanInDescr.get(propertyIRI);
        }
        return sentencePlanSelected;
    }

    public IRI chooseNLName(IRI indivOrClassIRI, NLGUser user) {
        IRI NLNameSelected = null;
        if (!this.usedNLNamesInDescr.containsKey(indivOrClassIRI)) {
            NLNameSelected = this.MQM.chooseNLName(indivOrClassIRI, this.NLNQM, this.getLanguage(), user);
            this.usedNLNamesInDescr.put(indivOrClassIRI, NLNameSelected);
        } else {
            NLNameSelected = this.usedNLNamesInDescr.get(indivOrClassIRI);
        }
        return NLNameSelected;
    }

    private IRI chooseAnonymousNLName(IRI indivOrClassIRI, NLGUser user) {
        if (!this.anonymousSuperClasses.containsKey(indivOrClassIRI)) {
            ArrayList<IRI> superClasses = new ArrayList<IRI>();
            HashSet entities = new HashSet();
            for (OWLOntology ontology : this.mainModels) {
                entities.addAll(ontology.getEntitiesInSignature(indivOrClassIRI, true));
            }
            Iterator<Object> iterator = entities.iterator();
            if (iterator.hasNext()) {
                OWLEntity entity = (OWLEntity)iterator.next();
                HashSet superClassAssertions = null;
                HashSet equivalentClasses = null;
                if (entity.isOWLClass()) {
                    superClassAssertions = new HashSet();
                    for (OWLOntology ontology : this.mainModels) {
                        superClassAssertions.addAll(ontology.getClassAssertionAxioms((OWLClassExpression)entity.asOWLClass()));
                    }
                    equivalentClasses = new HashSet();
                    for (OWLOntology ontology : this.mainModels) {
                        equivalentClasses.addAll(entity.asOWLClass().getEquivalentClasses(ontology));
                    }
                } else if (entity.isOWLNamedIndividual()) {
                    superClassAssertions = new HashSet();
                    for (OWLOntology ontology : this.mainModels) {
                        superClassAssertions.addAll(ontology.getClassAssertionAxioms((OWLIndividual)entity.asOWLNamedIndividual()));
                    }
                }
                if (superClassAssertions != null) {
                    for (OWLClassAssertionAxiom superClass : superClassAssertions) {
                        superClasses.addAll(NLGEngine.getSuperClasses(indivOrClassIRI, superClass.getClassExpression()));
                    }
                }
                if (equivalentClasses != null) {
                    for (OWLClassExpression equivalentClass : equivalentClasses) {
                        superClasses.addAll(NLGEngine.getSuperClasses(indivOrClassIRI, equivalentClass));
                    }
                }
                int i = superClasses.size() - 1;
                while (i >= 0) {
                    IRI superName = this.chooseNLName((IRI)superClasses.get(i), user);
                    if (superName != null && !superName.equals((Object)NLResourceManager.anonymous.getIRI())) {
                        this.anonymousSuperClasses.put(indivOrClassIRI, superName);
                        return superName;
                    }
                    --i;
                }
                for (IRI superClass : superClasses) {
                    IRI superName = this.chooseAnonymousNLName(superClass, user);
                    if (superName == null) continue;
                    this.anonymousSuperClasses.put(indivOrClassIRI, superName);
                    return superName;
                }
                return this.MQM.chooseDefaultNLName(indivOrClassIRI, this.NLNQM, this.getLanguage());
            }
        } else {
            return this.anonymousSuperClasses.get(indivOrClassIRI);
        }
        return null;
    }

    public XmlMsgs visitRecursivelyForInverseFacts(Node n, XmlMsgs messages, ArrayList<String> array) {
        if (n.hasChildNodes()) {
            NodeList list = n.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node node = list.item(i);
                if (node != null && !node.getNodeName().equals(String.valueOf(XmlMsgs.prefix) + ":type") && node.getAttributes().getNamedItem(String.valueOf(XmlMsgs.prefix) + ":" + "prpType").getNodeValue().equals("objPrp")) {
                    String property1 = node.getNodeName();
                    String namespace = property1.substring(0, property1.indexOf(58));
                    HashSet entities = new HashSet();
                    for (OWLOntology ontology : this.mainModels) {
                        entities.addAll(ontology.getEntitiesInSignature(IRI.create((String)(String.valueOf(messages.getRoot().getAttributes().getNamedItem("xmlns:" + namespace).getNodeValue()) + property1.substring(3))), true));
                    }
                    for (OWLEntity curProp : entities) {
                        if (!curProp.isOWLObjectProperty()) continue;
                        String val = node.getAttributes().getNamedItem("nlowl:Val").getNodeValue();
                        String ref = node.getAttributes().getNamedItem("nlowl:ref").getNodeValue();
                        array.add(list.item(i).getNodeName());
                        int k = 0;
                        while (k < array.size()) {
                            HashSet entities2 = new HashSet();
                            for (OWLOntology ontology : this.mainModels) {
                                entities2.addAll(ontology.getEntitiesInSignature(IRI.create((String)(String.valueOf(messages.getRoot().getAttributes().getNamedItem("xmlns:p1").getNodeValue()) + array.get(k).substring(3))), true));
                            }
                            for (OWLEntity curProp2 : entities2) {
                                if (!curProp2.isOWLObjectProperty()) continue;
                                boolean contains = false;
                                for (OWLOntology ontology : this.mainModels) {
                                    if (!curProp.asOWLObjectProperty().getInverses(ontology).contains(curProp2)) continue;
                                    contains = true;
                                }
                                if (!contains || !val.equals(array.get(k).substring(array.get(k).lastIndexOf(32) + 1)) || !ref.equals(array.get(k).substring(array.get(k).indexOf(32) + 1, array.get(k).lastIndexOf(32)))) continue;
                                messages.removeNode(node);
                            }
                            ++k;
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < list.getLength()) {
                if (list.item(i).hasChildNodes()) {
                    messages = this.visitRecursivelyForInverseFacts(list.item(i), messages, array);
                }
                ++i;
            }
        }
        return messages;
    }

    public XmlMsgs removeInverseFacts(XmlMsgs messages, int depth) {
        ArrayList<String> array = new ArrayList<String>();
        if (depth == 1) {
            return messages;
        }
        NodeList list = messages.getRoot().getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).hasChildNodes() && !list.item(i).getNodeName().equals("nlowl:type")) {
                String val = list.item(i).getAttributes().getNamedItem("nlowl:Val").getNodeValue();
                String ref = list.item(i).getAttributes().getNamedItem("nlowl:ref").getNodeValue();
                array.add(String.valueOf(list.item(i).getNodeName()) + " " + val + " " + ref);
                messages = this.visitRecursivelyForInverseFacts(list.item(i), messages, array);
            }
            ++i;
        }
        return messages;
    }

    public float calculateAssimilationScore(Fact factID, NLGUser user) {
        IRI forModifier = null;
        if (factID.hasModifier("maxCardRestriction")) {
            forModifier = NLResourceManager.maxCardinality.getIRI();
        } else if (factID.hasModifier("minCardRestriction")) {
            forModifier = NLResourceManager.minCardinality.getIRI();
        } else if (factID.hasModifier("exactCardRestriction")) {
            forModifier = NLResourceManager.exactCardinality.getIRI();
        }
        int factMentionedCount = user.getFactMentionedCount(factID);
        int maxRepetitions = this.UMQM.getRepetitions(factID.getPredicate(), factID.getSubject(), forModifier, user.getUserModel().getUMIRI());
        if (maxRepetitions == 0) {
            return 0.0f;
        }
        return factMentionedCount / maxRepetitions;
    }

    public boolean allFactsAreAssimilated() {
        return this.allFactsAreAssimilated;
    }

    public XmlMsgs getTheMostInterestingUnassimilatedFacts(XmlMsgs messages, int depth, NLGUser user) {
        if (user != null) {
            int[] levelsSizes = new int[depth];
            int i = 0;
            while (i < levelsSizes.length) {
                levelsSizes[i] = 0;
                ++i;
            }
            Node messageRoot = messages.getRoot();
            ArrayList<Node> factNodes = XmlMsgs.returnChildNodes(messageRoot);
            levelsSizes[0] = factNodes.size();
            int levelBegin = 0;
            int d = 1;
            while (d < depth) {
                int level_size = 0;
                int i2 = levelBegin;
                while (i2 < levelsSizes[d - 1]) {
                    Node currNode = factNodes.get(i2);
                    ArrayList<Node> currNode_NextLevelFacts = XmlMsgs.returnChildNodes(currNode);
                    level_size += currNode_NextLevelFacts.size();
                    factNodes.addAll(currNode_NextLevelFacts);
                    ++i2;
                }
                levelsSizes[d] = level_size;
                levelBegin += level_size;
                ++d;
            }
            for (Node checkNode : factNodes) {
                int secondaryCardinality;
                String forOwnerMin;
                String forPropertyMin;
                int checkCardinality;
                String forOwnerMax;
                String forPropertyMax;
                if (XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "modifier").equals("maxCardRestriction")) {
                    forPropertyMax = "";
                    if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                        forPropertyMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forProperty");
                    } else if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                        forPropertyMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                    }
                    forOwnerMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "ref");
                    checkCardinality = Integer.parseInt(XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "cardinality"));
                    for (Node secondaryNode : factNodes) {
                        if (secondaryNode.equals(checkNode)) continue;
                        if (XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "modifier").equals("minCardRestriction")) {
                            forPropertyMin = "";
                            if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                                forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty");
                            } else if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                                forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                            }
                            forOwnerMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "ref");
                            secondaryCardinality = Integer.parseInt(XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "cardinality"));
                            if (!forPropertyMax.equals(forPropertyMin) || !forOwnerMax.equals(forOwnerMin)) continue;
                            if (checkCardinality < secondaryCardinality) {
                                if (messages.getMessages().contains(secondaryNode)) {
                                    messages.removeNode(secondaryNode);
                                }
                                if (messages.getMessages().contains(checkNode)) {
                                    messages.removeNode(checkNode);
                                }
                            }
                            if (checkCardinality != secondaryCardinality) continue;
                            messages.setAttr((Element)secondaryNode, NLResourceManager.nlowlNS, XmlMsgs.prefix, "modifier", "exactCardRestriction");
                            if (!messages.getMessages().contains(checkNode)) continue;
                            messages.removeNode(checkNode);
                            continue;
                        }
                        if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "modifier").equals("maxCardRestriction")) continue;
                        forPropertyMin = "";
                        if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                            forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty");
                        } else if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                            forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                        }
                        forOwnerMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "ref");
                        secondaryCardinality = Integer.parseInt(XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "cardinality"));
                        if (!forPropertyMax.equals(forPropertyMin) || !forOwnerMax.equals(forOwnerMin)) continue;
                        if (checkCardinality <= secondaryCardinality) {
                            if (!messages.getMessages().contains(secondaryNode)) continue;
                            messages.removeNode(secondaryNode);
                            continue;
                        }
                        if (!messages.getMessages().contains(checkNode)) continue;
                        messages.removeNode(checkNode);
                    }
                    continue;
                }
                if (XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "modifier").equals("exactCardRestriction")) {
                    forPropertyMax = "";
                    if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                        forPropertyMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forProperty");
                    } else if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                        forPropertyMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                    }
                    forOwnerMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "ref");
                    int currentCardinality = Integer.parseInt(XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "cardinality"));
                    for (Node secondaryNode : factNodes) {
                        if (secondaryNode.equals(checkNode)) continue;
                        if (XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "modifier").equals("minCardRestriction")) {
                            forPropertyMin = "";
                            if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                                forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty");
                            } else if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                                forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                            }
                            forOwnerMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "ref");
                            if (!forPropertyMax.equals(forPropertyMin) || !forOwnerMax.equals(forOwnerMin) || !messages.getMessages().contains(secondaryNode)) continue;
                            messages.removeNode(secondaryNode);
                            continue;
                        }
                        if (XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "modifier").equals("maxCardRestriction")) {
                            forPropertyMin = "";
                            if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                                forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty");
                            } else if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                                forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                            }
                            forOwnerMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "ref");
                            if (!forPropertyMax.equals(forPropertyMin) || !forOwnerMax.equals(forOwnerMin) || !messages.getMessages().contains(secondaryNode)) continue;
                            messages.removeNode(secondaryNode);
                            continue;
                        }
                        if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "modifier").equals("exactCardRestriction")) continue;
                        forPropertyMin = "";
                        if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                            forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty");
                        } else if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                            forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                        }
                        forOwnerMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "ref");
                        secondaryCardinality = Integer.parseInt(XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "cardinality"));
                        if (!forPropertyMax.equals(forPropertyMin) || !forOwnerMax.equals(forOwnerMin)) continue;
                        if (currentCardinality == secondaryCardinality) {
                            if (!messages.getMessages().contains(secondaryNode)) continue;
                            messages.removeNode(secondaryNode);
                            continue;
                        }
                        if (messages.getMessages().contains(checkNode)) {
                            messages.removeNode(checkNode);
                        }
                        if (!messages.getMessages().contains(secondaryNode)) continue;
                        messages.removeNode(secondaryNode);
                    }
                    continue;
                }
                if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "modifier").equals("minCardRestriction")) continue;
                forPropertyMax = "";
                if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                    forPropertyMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forProperty");
                } else if (!XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                    forPropertyMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                }
                forOwnerMax = XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "ref");
                checkCardinality = Integer.parseInt(XmlMsgs.getAttribute(checkNode, XmlMsgs.prefix, "cardinality"));
                for (Node secondaryNode : factNodes) {
                    if (secondaryNode.equals(checkNode) || !XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "modifier").equals("minCardRestriction")) continue;
                    forPropertyMin = "";
                    if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty").isEmpty()) {
                        forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forProperty");
                    } else if (!XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty").isEmpty()) {
                        forPropertyMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "forDomainIndependentProperty");
                    }
                    forOwnerMin = XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "ref");
                    secondaryCardinality = Integer.parseInt(XmlMsgs.getAttribute(secondaryNode, XmlMsgs.prefix, "cardinality"));
                    if (!forPropertyMax.equals(forPropertyMin) || !forOwnerMax.equals(forOwnerMin)) continue;
                    if (checkCardinality >= secondaryCardinality) {
                        if (!messages.getMessages().contains(secondaryNode)) continue;
                        messages.removeNode(secondaryNode);
                        continue;
                    }
                    if (!messages.getMessages().contains(checkNode)) continue;
                    messages.removeNode(checkNode);
                }
            }
            Object[] factNodesArray = factNodes.toArray();
            levelBegin = 0;
            int i3 = 0;
            while (i3 < depth) {
                if (i3 == 0) {
                    Arrays.sort(factNodesArray, levelBegin, levelBegin + levelsSizes[i3], new InterestComparatorImpl(false));
                } else {
                    int LevelEnd = (levelBegin += levelsSizes[i3 - 1]) + levelsSizes[i3];
                    Arrays.sort(factNodesArray, levelBegin, LevelEnd, new InterestComparatorImpl(false));
                }
                ++i3;
            }
            int maxMessages = user.getUserModel().getMaxMessagesPerPage();
            boolean allFirstLevelFactsAssimilated = true;
            int i4 = 0;
            while (i4 < levelsSizes[0]) {
                Node currNode = (Node)factNodesArray[i4];
                if (Float.parseFloat(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "AssimilationScore")) < 1.0f && Integer.parseInt(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "interest")) != 0) {
                    allFirstLevelFactsAssimilated = false;
                }
                ++i4;
            }
            this.allFactsAreAssimilated = allFirstLevelFactsAssimilated;
            if (!allFirstLevelFactsAssimilated) {
                int countMessages = 0;
                int i5 = 0;
                while (i5 < factNodesArray.length) {
                    Node currNode = (Node)factNodesArray[i5];
                    if ((countMessages < maxMessages || maxMessages == -1) && Integer.parseInt(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "interest")) != 0 && Float.parseFloat(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "AssimilationScore")) < 1.0f) {
                        ++countMessages;
                        Fact fact = new Fact("[" + XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "ref") + ", " + XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "forProperty") + ", " + XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "value") + "]");
                        if (!XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "modifier").trim().isEmpty()) {
                            fact.addModifier(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "modifier"));
                        }
                        if ((fact.hasModifier("maxCardRestriction") || fact.hasModifier("minCardRestriction") || fact.hasModifier("exactCardRestriction")) && !XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "cardinality").trim().isEmpty()) {
                            fact.setCardinality(Integer.parseInt(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "cardinality")));
                        }
                        if (XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "polarity").trim().equals("false")) {
                            fact.setPolarity(false);
                        }
                        if (AxiomType.getAxiomType((String)fact.getPredicate().getFragment()) == null) {
                            this.conveyedFacts.add(fact);
                            this.usedSentencePlans.add(IRI.create((String)XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "sentencePlan")));
                            this.usedNLNames.add(IRI.create((String)XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "subjectNLName")));
                            if (!XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "objectNLName").isEmpty()) {
                                this.usedNLNames.add(IRI.create((String)XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "objectNLName")));
                            }
                        } else {
                            this.conveyedFacts.add(fact);
                            this.usedNLNames.add(IRI.create((String)XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "subjectNLName")));
                            if (!XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "objectNLName").isEmpty()) {
                                this.usedNLNames.add(IRI.create((String)XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "objectNLName")));
                            }
                        }
                    } else if (this.assimilationON && this.interestON) {
                        currNode.getParentNode().removeChild(currNode);
                    }
                    ++i5;
                }
            } else {
                i4 = 0;
                while (i4 < factNodesArray.length) {
                    Node currNode = (Node)factNodesArray[i4];
                    if (Integer.parseInt(XmlMsgs.getAttribute(currNode, XmlMsgs.prefix, "interest")) == 0 && this.assimilationON && this.interestON) {
                        currNode.getParentNode().removeChild(currNode);
                    }
                    ++i4;
                }
            }
            return messages;
        }
        return messages;
    }
}

