/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLGEngine;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLGEngine.SurfaceRealization;
import gr.aueb.cs.nlg.Utils.XmlDocumentCreator;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotatedDescription {
    private XmlDocumentCreator XmlDocCreator = new XmlDocumentCreator();
    private Document AnnotatedText;
    private Element AnnTExt;
    private Element currentPeriod;
    private Element currentSentence;
    public static String AnnotText = "AnnotatedText";
    public static String RE = "RE";
    public static String CANNEDTEXT = "CANNEDTEXT";
    public static String RELATIVE_PRONOUN = "RelativePronoun";
    public static String forProperty = "forProperty";
    public static String text = "TEXT";
    public static String VERB = "VERB";
    public static String PERIOD = "Period";
    public static String SENTENCE = "Sentence";
    public static String PUNCTUATION = "Punct";
    public static String REF = "ref";
    public static String ROLE = "role";
    public static String Interest = "Interest";
    public static String Assim = "Assim";
    public static String RE_TYPE = "RE_TYPE";
    public static String WSPACE = "WSPACE";
    public static String EmptyRef = "EmptyRef";
    public static String Comparator = "Comparator";
    public static String TURN = "Turn";
    private Node ComparatorSlot;
    private Element ComparatorSlotInAnnotationsTree;
    private String StringCompEntities = "";
    private String TurnToSee = "";
    private boolean InComparator = false;

    public Document getXmlDoc() {
        NodeList periods = this.AnnTExt.getChildNodes();
        int i = 0;
        while (i < periods.getLength()) {
            Node Period = periods.item(i);
            NodeList PeriodSlots = Period.getChildNodes();
            int k = 0;
            while (k < PeriodSlots.getLength()) {
                Node PeriodSlot = PeriodSlots.item(k);
                if ((PeriodSlot.getNodeName().equals("Sentence") || PeriodSlot.getNodeName().equals("Comparator")) && k == 0) {
                    Node sent = PeriodSlot;
                    NodeList SentSlots = sent.getChildNodes();
                    int j = 0;
                    while (j < SentSlots.getLength()) {
                        Node Slot = SentSlots.item(j);
                        if (Slot.getTextContent() != null && !Slot.getTextContent().isEmpty()) {
                            Slot.setTextContent(SurfaceRealization.capitalizeText(Slot.getTextContent()));
                            j = SentSlots.getLength();
                        } else {
                            Slot.setTextContent(Slot.getTextContent());
                        }
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
        return this.AnnotatedText;
    }

    public Node getRoot() {
        this.getXmlDoc();
        return this.AnnTExt;
    }

    public void setStringCompEntities(String str) {
        this.StringCompEntities = str;
    }

    public void setTurnToSee(String str) {
        this.TurnToSee = str;
    }

    public void startComparator(Node Slot) {
        this.ComparatorSlot = Slot;
        this.InComparator = true;
        String turn = XmlMsgs.getAttribute(Slot, XmlMsgs.prefix, "ComparatorEntitiesTurn");
        if (turn != null && !turn.isEmpty()) {
            this.setTurnToSee(turn);
        }
    }

    public void finishComparator() {
        this.reformComparator();
        this.ComparatorSlot = null;
        this.InComparator = false;
    }

    public void print() {
        this.getXmlDoc();
    }

    public String getAnnotatedXml() {
        this.getXmlDoc();
        return XmlMsgs.getStringDescription(this.AnnTExt, true);
    }

    public void generateAnnotatedDescription() {
        this.AnnotatedText = this.XmlDocCreator.getNewDocument();
        this.AnnTExt = this.AnnotatedText.createElement(AnnotText);
        this.AnnotatedText.appendChild(this.AnnTExt);
        this.addStartPeriod();
        this.addStartSentence();
    }

    public void setEntityId(String id) {
        this.AnnTExt.setAttribute("ref", id);
    }

    public void addRE(String text, String ontID, String prop, String produced_re, String role, String interest, String assimScore) {
        if (this.currentSentence != null) {
            this.makeItComparator();
            String re_tag = RE;
            re_tag = produced_re.equals(SurfaceRealization.PROD_RE_NULL) ? EmptyRef : produced_re;
            Element ELEM = this.AnnotatedText.createElement(re_tag);
            this.currentSentence.appendChild(ELEM);
            ELEM.setAttribute(REF, ontID);
            ELEM.setAttribute(ROLE, role);
            this.addForProperty(ELEM, prop);
            this.addInterest(ELEM, interest);
            this.addAssim(ELEM, assimScore);
            ELEM.setTextContent(text);
            this.slotInComparator(ELEM, prop);
        }
    }

    public void addRE(String ontID, String role) {
        if (this.currentSentence != null) {
            this.makeItComparator();
            String re_tag = EmptyRef;
            Element ELEM = this.AnnotatedText.createElement(re_tag);
            this.currentSentence.appendChild(ELEM);
            ELEM.setAttribute(REF, ontID);
            ELEM.setAttribute(ROLE, role);
            ELEM.setTextContent("");
        }
    }

    public void addCannedText(String text, String ontID, String prop, String role, String interest, String assimScore) {
        if (this.currentSentence != null) {
            this.makeItComparator();
            Element ELEM = this.AnnotatedText.createElement(CANNEDTEXT);
            this.currentSentence.appendChild(ELEM);
            ELEM.setAttribute(REF, ontID);
            ELEM.setAttribute(ROLE, role);
            ELEM.setTextContent(text);
            this.addForProperty(ELEM, prop);
            this.addInterest(ELEM, interest);
            this.addAssim(ELEM, assimScore);
            this.slotInComparator(ELEM, prop);
        }
    }

    public void addText(String text) {
        this.addText(text, "", "", "", "", "", "false", false);
    }

    public void addText(String text, String prop, String role, String ref, String interest, String assimScore, String isPrep) {
        this.addText(text, prop, role, ref, interest, assimScore, isPrep, true);
    }

    public void addText(String text, String prop, String role, String ref, String interest, String assimScore, String isPrep, boolean b) {
        if (this.currentSentence != null) {
            this.makeItComparator();
            boolean endOfSentence = false;
            boolean endOfPeriod = false;
            if (text.equals(".")) {
                Element punct = this.AnnotatedText.createElement(PUNCTUATION);
                punct.setTextContent(text);
                endOfSentence = true;
                endOfPeriod = true;
                this.addStartPeriod(endOfPeriod, punct);
                this.addStartSentence(endOfSentence);
                this.slotInComparator(punct, prop);
            } else if (text.equals("and") || text.equals("\u03ba\u03b1\u03b9")) {
                Element textEl = this.AnnotatedText.createElement("Text");
                textEl.setTextContent(text);
                endOfSentence = true;
                this.addStartSentence(endOfSentence, textEl);
                this.slotInComparator(textEl, prop);
            } else if (text.equals(";")) {
                Element Punct = this.AnnotatedText.createElement(PUNCTUATION);
                Punct.setTextContent(text);
                endOfSentence = true;
                this.addStartSentence(endOfSentence, Punct);
                this.slotInComparator(Punct, prop);
            } else if (text.equals(",")) {
                Element Punct = this.AnnotatedText.createElement(PUNCTUATION);
                Punct.setTextContent(text);
                endOfSentence = true;
                this.addStartSentence(endOfSentence, Punct);
                this.slotInComparator(Punct, prop);
            } else if (text.equals("\u03b7 \u03bf\u03c0\u03bf\u03af\u03b1") || text.equals("\u03bf \u03bf\u03c0\u03bf\u03af\u03bf\u03c2") || text.equals("\u03c4\u03bf \u03bf\u03c0\u03bf\u03af\u03bf") || text.equals("\u03c0\u03bf\u03c5")) {
                Element textEl = this.AnnotatedText.createElement(RELATIVE_PRONOUN);
                textEl.setTextContent(text);
                textEl.setAttribute(REF, ref);
                textEl.setAttribute(ROLE, role);
                endOfSentence = true;
                if (this.currentSentence.getLastChild() == null || this.currentSentence.getLastChild().getTextContent().compareTo(",") != 0) {
                    this.addStartSentence(endOfSentence);
                }
                this.currentSentence.appendChild(textEl);
                this.slotInComparator(textEl, prop);
            } else if (text.equals("which")) {
                Element textEl = this.AnnotatedText.createElement(RELATIVE_PRONOUN);
                textEl.setTextContent(text);
                textEl.setAttribute(REF, ref);
                textEl.setAttribute(ROLE, role);
                this.currentSentence.appendChild(textEl);
                this.slotInComparator(textEl, prop);
            } else if (text.equals("that")) {
                Element textEl = this.AnnotatedText.createElement(AnnotatedDescription.text);
                textEl.setTextContent(text);
                this.currentSentence.appendChild(textEl);
                this.slotInComparator(textEl, prop);
            } else {
                Element elem = this.AnnotatedText.createElement(AnnotatedDescription.text);
                elem = isPrep.equals("true") ? this.AnnotatedText.createElement("Prep") : this.AnnotatedText.createElement(AnnotatedDescription.text);
                this.currentSentence.appendChild(elem);
                elem.setTextContent(text);
                if (b) {
                    this.addForProperty(elem, prop);
                    this.addInterest(elem, interest);
                    this.addAssim(elem, assimScore);
                }
                this.slotInComparator(elem, prop);
            }
        }
    }

    public void addVerb(String text, String prop, String interest, String assimScore) {
        if (this.currentSentence != null) {
            this.makeItComparator();
            Element ELEM = this.AnnotatedText.createElement(VERB);
            this.currentSentence.appendChild(ELEM);
            ELEM.setTextContent(text);
            this.addForProperty(ELEM, prop);
            this.addInterest(ELEM, interest);
            this.addAssim(ELEM, assimScore);
            this.slotInComparator(ELEM, prop);
        }
    }

    public void addWhitespace() {
        if (this.currentSentence != null) {
            Element elem = this.AnnotatedText.createElement(WSPACE);
            this.currentSentence.appendChild(elem);
        }
    }

    public void addStartPeriod() {
        Element elem;
        this.currentPeriod = elem = this.AnnotatedText.createElement(PERIOD);
        this.AnnTExt.appendChild(elem);
    }

    private void addStartPeriod(boolean endOfPeriod, Element punct) {
        if (endOfPeriod) {
            Element elem = this.AnnotatedText.createElement(PERIOD);
            this.currentPeriod.appendChild(punct);
            this.currentPeriod = elem;
            this.AnnTExt.appendChild(elem);
        }
    }

    public void addStartSentence() {
        if (!this.InComparator) {
            Element sentenceElem;
            this.currentSentence = sentenceElem = this.AnnotatedText.createElement(SENTENCE);
            if (this.currentPeriod != null) {
                this.currentPeriod.appendChild(sentenceElem);
            }
        }
    }

    private void addStartSentence(boolean end_of_sentence) {
        if (end_of_sentence && !this.InComparator) {
            Element sentenceElem;
            this.currentSentence = sentenceElem = this.AnnotatedText.createElement(SENTENCE);
            if (this.currentPeriod != null) {
                this.currentPeriod.appendChild(sentenceElem);
            }
        }
    }

    private void addStartSentence(boolean end_of_sentence, Element connector) {
        if (end_of_sentence && !this.InComparator) {
            Element sentenceElem;
            this.currentSentence = sentenceElem = this.AnnotatedText.createElement(SENTENCE);
            if (this.currentPeriod != null) {
                this.currentPeriod.appendChild(connector);
                this.currentPeriod.appendChild(sentenceElem);
            }
        } else if (end_of_sentence && this.InComparator) {
            this.currentSentence.appendChild(connector);
        }
    }

    public void makeItComparator() {
        if (this.InComparator && this.currentSentence != null && this.currentSentence.getNodeName().compareTo(SENTENCE) == 0) {
            Element comparator = this.AnnotatedText.createElement(Comparator);
            this.currentSentence.getParentNode().replaceChild(comparator, this.currentSentence);
            this.currentSentence = comparator;
            this.ComparatorSlotInAnnotationsTree = comparator;
        }
    }

    private void slotInComparator(Node createdSlot, String prop) {
        if (this.InComparator && prop != null && prop.compareTo("") != 0 && prop.compareTo(String.valueOf(NLResourceManager.nlowlNS) + "Comparator") != 0) {
            ((Element)createdSlot).setAttribute(forProperty, prop);
        }
        if (!this.InComparator && createdSlot.getTextContent().compareTo(",") == 0 && createdSlot.getPreviousSibling() != null && createdSlot.getPreviousSibling().getNodeName().compareTo("Comparator") == 0) {
            createdSlot.getPreviousSibling().appendChild(createdSlot);
        }
    }

    public void reformComparator() {
        if (this.ComparatorSlotInAnnotationsTree != null) {
            this.ComparatorSlotInAnnotationsTree.removeAttribute(Interest);
            this.ComparatorSlotInAnnotationsTree.removeAttribute(forProperty);
            this.ComparatorSlotInAnnotationsTree.removeAttribute(Assim);
            this.ComparatorSlotInAnnotationsTree.setAttribute(REF, this.StringCompEntities);
            this.ComparatorSlotInAnnotationsTree.setAttribute(TURN, this.TurnToSee);
            Node feat = this.ComparatorSlot.getAttributes().getNamedItem("nlowl:Feature");
            if (feat != null) {
                if (!feat.getTextContent().isEmpty()) {
                    this.ComparatorSlotInAnnotationsTree.setAttribute("type", "negative");
                } else {
                    this.ComparatorSlotInAnnotationsTree.setAttribute("type", "positive");
                }
            } else {
                this.ComparatorSlotInAnnotationsTree.setAttribute("type", "positive");
            }
            NodeList CompSlots = this.ComparatorSlotInAnnotationsTree.getChildNodes();
            int i = 0;
            while (i < CompSlots.getLength()) {
                Node slot = CompSlots.item(i);
                if (slot.getAttributes().getNamedItem(ROLE) != null && slot.getAttributes().getNamedItem(forProperty) == null) {
                    slot.getAttributes().removeNamedItem(ROLE);
                }
                ++i;
            }
            CompSlots = this.ComparatorSlotInAnnotationsTree.getChildNodes();
            ArrayList<Node> NPs_Delete = new ArrayList<Node>();
            ArrayList<Node> CompSlots_VEC = new ArrayList<Node>();
            int NP_count = 0;
            String NPs_Content = "";
            int i2 = 0;
            i2 = 0;
            while (i2 < CompSlots.getLength()) {
                CompSlots_VEC.add(CompSlots.item(i2));
                ++i2;
            }
            i2 = 0;
            while (i2 < CompSlots_VEC.size()) {
                Node slot = (Node)CompSlots_VEC.get(i2);
                if (slot.getNodeName().compareTo("NP") == 0) {
                    NP_count = 1;
                    NPs_Content = slot.getTextContent();
                    NPs_Delete.clear();
                    NPs_Delete.add(slot);
                    if (i2 + 1 < CompSlots.getLength()) {
                        slot = (Node)CompSlots_VEC.get(++i2);
                        while (i2 < CompSlots.getLength() && ((Node)CompSlots_VEC.get(i2)).getNodeName().compareTo("NP") == 0) {
                            ++NP_count;
                            NPs_Content = String.valueOf(NPs_Content) + " " + ((Node)CompSlots_VEC.get(i2)).getTextContent();
                            NPs_Delete.add((Node)CompSlots_VEC.get(i2));
                            ++i2;
                        }
                    }
                    if (NP_count > 1) {
                        int j = 0;
                        while (j < NPs_Delete.size() - 1) {
                            ((Node)NPs_Delete.get(j)).getParentNode().removeChild((Node)NPs_Delete.get(j));
                            ++j;
                        }
                        ((Node)NPs_Delete.get(NPs_Delete.size() - 1)).setTextContent(NPs_Content);
                    }
                }
                ++i2;
            }
            CompSlots = this.ComparatorSlotInAnnotationsTree.getChildNodes();
            CompSlots_VEC = null;
            CompSlots_VEC = new ArrayList();
            i2 = 0;
            while (i2 < CompSlots.getLength()) {
                CompSlots_VEC.add(CompSlots.item(i2));
                ++i2;
            }
            boolean found_owner = false;
            boolean sentence_created = false;
            Node the_comp_sent_slot = null;
            i2 = 0;
            while (i2 < CompSlots_VEC.size()) {
                Node slot = (Node)CompSlots_VEC.get(i2);
                if ((slot.getAttributes() == null || slot.getAttributes().getNamedItem(forProperty) != null) && slot.getAttributes().getNamedItem(forProperty).getNodeName().compareTo("") != 0) {
                    Element SENTENCE_ELEM;
                    String PropURI = ((Element)slot).getAttribute(forProperty);
                    sentence_created = true;
                    this.currentSentence = SENTENCE_ELEM = this.AnnotatedText.createElement(SENTENCE);
                    this.currentSentence.setAttribute(forProperty, PropURI);
                    while (i2 < CompSlots_VEC.size()) {
                        slot = (Node)CompSlots_VEC.get(i2);
                        ((Element)slot).removeAttribute(forProperty);
                        this.currentSentence.appendChild(slot);
                        ++i2;
                    }
                    this.ComparatorSlotInAnnotationsTree.appendChild(SENTENCE_ELEM);
                    NodeList sentence_slots = SENTENCE_ELEM.getChildNodes();
                    int k = 0;
                    while (k < sentence_slots.getLength()) {
                        Element sent_slot = (Element)sentence_slots.item(k);
                        if (sent_slot.getAttribute(ROLE) != null && sent_slot.getAttribute(ROLE).compareTo("owner") == 0) {
                            found_owner = true;
                        }
                        ++k;
                    }
                    the_comp_sent_slot = SENTENCE_ELEM;
                }
                ++i2;
            }
            if (!found_owner && sentence_created) {
                CompSlots = this.ComparatorSlotInAnnotationsTree.getChildNodes();
                CompSlots_VEC = null;
                CompSlots_VEC = new ArrayList();
                i2 = 0;
                while (i2 < CompSlots.getLength()) {
                    CompSlots_VEC.add(CompSlots.item(i2));
                    ++i2;
                }
                i2 = 0;
                boolean found_NP = false;
                Node node_after_new = null;
                while (i2 < CompSlots_VEC.size()) {
                    Node slot = (Node)CompSlots_VEC.get(i2);
                    if (slot.getNodeName().compareTo("NP") == 0) {
                        found_NP = true;
                        ((Element)slot).setAttribute(ROLE, "owner");
                        the_comp_sent_slot.insertBefore(slot, the_comp_sent_slot.getFirstChild());
                        node_after_new = slot;
                    } else if (slot.getNodeName().compareTo(SENTENCE) != 0 && found_NP) {
                        the_comp_sent_slot.insertBefore(slot, node_after_new);
                    }
                    ++i2;
                }
            }
        }
    }

    private void addInterest(Element SentenceSlot, String interest) {
        Element SentenceNode = (Element)SentenceSlot.getParentNode();
        if (SentenceNode.getAttributes() != null) {
            if (SentenceNode.getAttributes().getNamedItem(Interest) == null) {
                SentenceNode.setAttribute(Interest, interest);
            } else if (SentenceNode.getAttributes().getNamedItem(Interest).getTextContent().isEmpty()) {
                SentenceNode.setAttribute(Interest, interest);
            }
        }
    }

    private void addAssim(Element SentenceSlot, String assim) {
        Element SentenceNode = (Element)SentenceSlot.getParentNode();
        if (SentenceNode.getAttributes() != null) {
            if (SentenceNode.getAttributes().getNamedItem(Assim) == null) {
                SentenceNode.setAttribute(Assim, assim);
            } else if (SentenceNode.getAttributes().getNamedItem(Assim).getTextContent().isEmpty()) {
                SentenceNode.setAttribute(Assim, assim);
            }
        }
    }

    private void addForProperty(Element SentenceSlot, String property) {
        Element SentenceNode = (Element)SentenceSlot.getParentNode();
        if (SentenceNode.getAttributes() != null) {
            if (SentenceNode.getAttributes().getNamedItem(forProperty) == null) {
                SentenceNode.setAttribute(forProperty, property);
            } else if (SentenceNode.getAttributes().getNamedItem(forProperty).getTextContent().isEmpty()) {
                SentenceNode.setAttribute(forProperty, property);
            }
        }
    }

    public void removeLastPeriod() {
        if (this.currentPeriod != null) {
            this.currentPeriod.getParentNode().removeChild(this.currentPeriod);
        }
    }
}

