/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.UMPrpClassLevelKey;
import gr.aueb.cs.nlg.NLFiles.UMPrpInstanceLevelKey;
import gr.aueb.cs.nlg.NLFiles.UMPrpLevelKey;
import gr.aueb.cs.nlg.NLFiles.UserModel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLEntityRenamer;

public class UserModelQueryManager {
    private HashMap<IRI, UserModel> userModels;
    private NLResourceManager NLResourcesManager;
    public HashSet<OWLOntology> mainModels;

    public UserModelQueryManager(NLResourceManager NLResourcesManager) {
        this.NLResourcesManager = NLResourcesManager;
        this.mainModels = new HashSet();
        this.init();
    }

    private void init() {
        this.userModels = new HashMap();
        UserModel UM = new UserModel(NLResourceManager.globalUserModel.getIRI());
        UM.setMaxMessagesPerSentence(1);
        UM.setMaxMessagesPerPage(-1);
        UM.setGlobalInterest(1);
        UM.setGlobalRepetitions(1);
        UM.setPropertyLevelInterest(NLResourceManager.instanceOf.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.instanceOf.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.oneOf.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.oneOf.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.differentIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.differentIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.sameIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.sameIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.isA.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.isA.getIRI(), null, 1);
        this.userModels.put(UM.getUMIRI(), UM);
    }

    public void duplicateUserModel(IRI fromIRI, IRI toIRI) {
        UserModel fromModel = this.userModels.get(fromIRI);
        UserModel toModel = new UserModel(toIRI, fromModel.getMaxMessagesPerSentence(), fromModel.getMaxMessagesPerPage());
        this.userModels.put(toIRI, toModel);
        this.setGlobalInterest(toIRI, fromModel.getGlobalInterest());
        this.setGlobalRepetitions(toIRI, fromModel.getGlobalRepetitions());
        for (IRI iRI : fromModel.getSentencePlansIRIs()) {
            this.setSentencePlanAppropriateness(iRI, toIRI, fromModel.getSentencePlanAppropriateness(iRI));
        }
        for (IRI iRI : fromModel.getNLNamesIRIs()) {
            this.setNLNameAppropriateness(iRI, toIRI, fromModel.getNLNameAppropriateness(iRI));
        }
        for (UMPrpLevelKey uMPrpLevelKey : fromModel.getPropertyLevelKeys()) {
            this.setPropertyLevelInterest(uMPrpLevelKey.getForProperty(), uMPrpLevelKey.getForModifier(), toIRI, fromModel.getPropertyLevelInterest(uMPrpLevelKey.getForProperty(), uMPrpLevelKey.getForModifier()));
            this.setPropertyLevelRepetitions(uMPrpLevelKey.getForProperty(), uMPrpLevelKey.getForModifier(), toIRI, fromModel.getPropertyLevelRepetitions(uMPrpLevelKey.getForProperty(), uMPrpLevelKey.getForModifier()));
        }
        for (UMPrpClassLevelKey uMPrpClassLevelKey : fromModel.getClassLevelKeys()) {
            this.setClassLevelInterest(uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier(), toIRI, fromModel.getClassLevelInterest(uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier()));
            this.setClassLevelRepetitions(uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier(), toIRI, fromModel.getClassLevelRepetitions(uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier()));
        }
        for (UMPrpInstanceLevelKey uMPrpInstanceLevelKey : fromModel.getInstanceLevelKeys()) {
            this.setInstanceLevelInterest(uMPrpInstanceLevelKey.getForProperty(), uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier(), toIRI, fromModel.getInstanceLevelInterest(uMPrpInstanceLevelKey.getForProperty(), uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier()));
            this.setInstanceLevelRepetitions(uMPrpInstanceLevelKey.getForProperty(), uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier(), toIRI, fromModel.getInstanceLevelRepetitions(uMPrpInstanceLevelKey.getForProperty(), uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier()));
        }
    }

    public void deleteUserModel(IRI UserModelIRI) {
        UserModel UT = this.userModels.remove(UserModelIRI);
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(UserModelIRI);
        for (OWLOntology mainModel : this.mainModels) {
            OWLDataPropertyAssertionAxiom dataAssertion;
            OWLDataProperty dataProperty;
            OWLDataProperty dataProperty2;
            OWLAnnotationAssertionAxiom annotationAssertion;
            RemoveAxiom removeAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLObjectProperty objectProperty;
            OWLAnonymousIndividual anIndiv;
            for (UMPrpLevelKey uMPrpLevelKey : UT.getPropertyLevelKeys()) {
                int oldValue;
                anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), uMPrpLevelKey.getForProperty(), null, null, uMPrpLevelKey.getForModifier(), null, null);
                if (anIndiv != null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                if (uMPrpLevelKey.getForProperty() != null) {
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpLevelKey.getForProperty());
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if (uMPrpLevelKey.getForModifier() != null) {
                    objectProperty = NLResourceManager.forModifier;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(uMPrpLevelKey.getForModifier()));
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if ((oldValue = UT.getPropertyLevelInterest(uMPrpLevelKey.getForProperty(), uMPrpLevelKey.getForModifier())) != -1) {
                    OWLDataProperty dataProperty22 = NLResourceManager.hasInterest;
                    OWLDataPropertyAssertionAxiom dataAssertion2 = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty22, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion2);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if ((oldValue = UT.getPropertyLevelRepetitions(uMPrpLevelKey.getForProperty(), uMPrpLevelKey.getForModifier())) == -1) continue;
                dataProperty2 = NLResourceManager.maxRepetitions;
                OWLDataPropertyAssertionAxiom dataAssertion2 = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty2, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion2);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            for (UMPrpClassLevelKey uMPrpClassLevelKey : UT.getClassLevelKeys()) {
                int oldValue;
                anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), null, uMPrpClassLevelKey.getForModifier(), null, null);
                if (anIndiv != null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpClassLevelKey.getForProperty());
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                annotationProperty = NLResourceManager.forOwner;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpClassLevelKey.getForClass());
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                if (uMPrpClassLevelKey.getForModifier() != null) {
                    objectProperty = NLResourceManager.forModifier;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(uMPrpClassLevelKey.getForModifier()));
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if ((oldValue = UT.getClassLevelInterest(uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier())) != -1) {
                    dataProperty = NLResourceManager.hasInterest;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if ((oldValue = UT.getClassLevelRepetitions(uMPrpClassLevelKey.getForProperty(), uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier())) == -1) continue;
                dataProperty = NLResourceManager.maxRepetitions;
                dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            for (UMPrpInstanceLevelKey uMPrpInstanceLevelKey : UT.getInstanceLevelKeys()) {
                int oldValue;
                anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), uMPrpInstanceLevelKey.getForProperty(), null, uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier(), null, null);
                if (anIndiv != null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpInstanceLevelKey.getForProperty());
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                annotationProperty = NLResourceManager.forOwner;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpInstanceLevelKey.getForInstance());
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                if (uMPrpInstanceLevelKey.getForModifier() != null) {
                    objectProperty = NLResourceManager.forModifier;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(uMPrpInstanceLevelKey.getForModifier()));
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if ((oldValue = UT.getInstanceLevelInterest(uMPrpInstanceLevelKey.getForProperty(), uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier())) != -1) {
                    dataProperty = NLResourceManager.hasInterest;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if ((oldValue = UT.getInstanceLevelRepetitions(uMPrpInstanceLevelKey.getForProperty(), uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier())) == -1) continue;
                dataProperty = NLResourceManager.maxRepetitions;
                dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            for (IRI iRI : UT.getSentencePlansIRIs()) {
                anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), null, null, null, null, iRI, null);
                if (anIndiv != null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectProperty = NLResourceManager.forSentencePlan;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(iRI));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                int oldValue = UT.getSentencePlanAppropriateness(iRI);
                dataProperty2 = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion3 = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty2, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion3);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            for (IRI iRI : UT.getNLNamesIRIs()) {
                anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), null, null, null, null, null, iRI);
                if (anIndiv == null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectProperty = NLResourceManager.forNLName;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(iRI));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                int oldValue = UT.getNLNameAppropriateness(iRI);
                dataProperty2 = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion4 = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty2, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion4);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
        }
    }

    public void addUserModel(IRI UserModelIRI) {
        UserModel UM = new UserModel(UserModelIRI, 1, 5);
        UM.setPropertyLevelInterest(NLResourceManager.instanceOf.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.instanceOf.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.oneOf.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.oneOf.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.differentIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.differentIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.sameIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.sameIndividuals.getIRI(), null, 1);
        UM.setPropertyLevelInterest(NLResourceManager.isA.getIRI(), null, 1);
        UM.setPropertyLevelRepetitions(NLResourceManager.isA.getIRI(), null, 1);
        this.userModels.put(UserModelIRI, UM);
    }

    public void addSentencePlan(IRI sentencePlanIRI) {
        for (UserModel UT : this.userModels.values()) {
            UT.addSentencePlan(sentencePlanIRI);
        }
    }

    public void addNLName(IRI NLNameIRI) {
        for (UserModel UT : this.userModels.values()) {
            UT.addNLName(NLNameIRI);
        }
    }

    public void renameUserModel(IRI oldUTIRI, IRI newUTIRI) {
        UserModel UT = this.userModels.remove(oldUTIRI);
        OWLEntityRenamer renamer = new OWLEntityRenamer(this.NLResourcesManager.getOntologyManager(), this.mainModels);
        for (OWLOntologyChange renameChange : renamer.changeIRI(oldUTIRI, newUTIRI)) {
            this.NLResourcesManager.getOntologyManager().applyChange(renameChange);
        }
        this.userModels.put(newUTIRI, UT);
    }

    public void renameProperty(IRI oldPropertyIRI, IRI newPropertyIRI) {
        for (UserModel UT : this.userModels.values()) {
            for (OWLOntology mainModel : this.mainModels) {
                AddAxiom addAxiomChange;
                RemoveAxiom removeAxiomChange;
                OWLAnnotationAssertionAxiom annotationAssertion;
                OWLAnnotationProperty annotationProperty;
                OWLAnonymousIndividual anIndiv;
                for (UMPrpLevelKey uMPrpLevelKey : UT.getPropertyLevelKeys()) {
                    if (!uMPrpLevelKey.getForProperty().equals((Object)oldPropertyIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), oldPropertyIRI, null, null, uMPrpLevelKey.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)oldPropertyIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)newPropertyIRI);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
                for (UMPrpClassLevelKey uMPrpClassLevelKey : UT.getClassLevelKeys()) {
                    if (!uMPrpClassLevelKey.getForProperty().equals((Object)oldPropertyIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), oldPropertyIRI, uMPrpClassLevelKey.getForClass(), null, uMPrpClassLevelKey.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)oldPropertyIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)newPropertyIRI);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
                for (UMPrpInstanceLevelKey uMPrpInstanceLevelKey : UT.getInstanceLevelKeys()) {
                    if (!uMPrpInstanceLevelKey.getForProperty().equals((Object)oldPropertyIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), oldPropertyIRI, null, uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)oldPropertyIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)newPropertyIRI);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            }
            UT.renameProperty(oldPropertyIRI, newPropertyIRI);
        }
    }

    public void renameClass(IRI oldClassIRI, IRI newClassIRI) {
        for (UserModel UT : this.userModels.values()) {
            for (OWLOntology mainModel : this.mainModels) {
                for (UMPrpClassLevelKey key : UT.getClassLevelKeys()) {
                    OWLAnonymousIndividual anIndiv;
                    if (!key.getForClass().equals((Object)oldClassIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), key.getForProperty(), oldClassIRI, null, key.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forOwner;
                    OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)oldClassIRI);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)newClassIRI);
                    AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            }
            UT.renameClass(oldClassIRI, newClassIRI);
        }
    }

    public void renameInstance(IRI oldInstanceIRI, IRI newInstanceIRI) {
        for (UserModel UT : this.userModels.values()) {
            for (OWLOntology mainModel : this.mainModels) {
                for (UMPrpInstanceLevelKey key : UT.getInstanceLevelKeys()) {
                    OWLAnonymousIndividual anIndiv;
                    if (!key.getForInstance().equals((Object)oldInstanceIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), key.getForProperty(), null, oldInstanceIRI, key.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forOwner;
                    OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)oldInstanceIRI);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)newInstanceIRI);
                    AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            }
            UT.renameInstance(oldInstanceIRI, newInstanceIRI);
        }
    }

    public void renameSentencePlan(IRI oldSentencePlanIRI, IRI newSentencePlanIRI) {
        for (UserModel UT : this.userModels.values()) {
            for (OWLOntology mainModel : this.mainModels) {
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), null, null, null, null, oldSentencePlanIRI, null);
                if (anIndiv != null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                OWLObjectProperty objectProperty = NLResourceManager.forSentencePlan;
                OWLObjectPropertyAssertionAxiom objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(oldSentencePlanIRI));
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(newSentencePlanIRI));
                AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            UT.renameSentencePlan(oldSentencePlanIRI, newSentencePlanIRI);
        }
    }

    public void renameNLName(IRI oldNLNameIRI, IRI newNLNameIRI) {
        for (UserModel UT : this.userModels.values()) {
            for (OWLOntology mainModel : this.mainModels) {
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), null, null, null, null, null, oldNLNameIRI);
                if (anIndiv == null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                OWLObjectProperty objectProperty = NLResourceManager.forNLName;
                OWLObjectPropertyAssertionAxiom objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(oldNLNameIRI));
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(newNLNameIRI));
                AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            UT.renameNLName(oldNLNameIRI, newNLNameIRI);
        }
    }

    public void deleteProperty(IRI propertyIRI) {
        for (UserModel UT : this.userModels.values()) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(UT.getUMIRI());
            for (OWLOntology mainModel : this.mainModels) {
                OWLDataPropertyAssertionAxiom dataAssertion;
                OWLDataProperty dataProperty;
                int oldValue;
                OWLAnnotationAssertionAxiom annotationAssertion;
                OWLAnnotationProperty annotationProperty;
                RemoveAxiom removeAxiomChange;
                OWLObjectPropertyAssertionAxiom objectAssertion;
                OWLObjectProperty objectProperty;
                OWLAnonymousIndividual anIndiv;
                for (UMPrpLevelKey uMPrpLevelKey : UT.getPropertyLevelKeys()) {
                    if (!uMPrpLevelKey.getForProperty().equals((Object)propertyIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), propertyIRI, null, null, uMPrpLevelKey.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)propertyIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    oldValue = UT.getPropertyLevelInterest(propertyIRI, uMPrpLevelKey.getForModifier());
                    if (oldValue != -1) {
                        dataProperty = NLResourceManager.hasInterest;
                        dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                        removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    }
                    if ((oldValue = UT.getPropertyLevelRepetitions(propertyIRI, uMPrpLevelKey.getForModifier())) == -1) continue;
                    dataProperty = NLResourceManager.maxRepetitions;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                for (UMPrpClassLevelKey uMPrpClassLevelKey : UT.getClassLevelKeys()) {
                    if (!uMPrpClassLevelKey.getForProperty().equals((Object)propertyIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), propertyIRI, uMPrpClassLevelKey.getForClass(), null, uMPrpClassLevelKey.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)propertyIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forOwner;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpClassLevelKey.getForClass());
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    oldValue = UT.getClassLevelInterest(propertyIRI, uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier());
                    if (oldValue != -1) {
                        dataProperty = NLResourceManager.hasInterest;
                        dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                        removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    }
                    if ((oldValue = UT.getClassLevelRepetitions(propertyIRI, uMPrpClassLevelKey.getForClass(), uMPrpClassLevelKey.getForModifier())) == -1) continue;
                    dataProperty = NLResourceManager.maxRepetitions;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                for (UMPrpInstanceLevelKey uMPrpInstanceLevelKey : UT.getInstanceLevelKeys()) {
                    if (!uMPrpInstanceLevelKey.getForProperty().equals((Object)propertyIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), propertyIRI, null, uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forProperty;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)propertyIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forOwner;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)uMPrpInstanceLevelKey.getForInstance());
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    oldValue = UT.getInstanceLevelInterest(propertyIRI, uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier());
                    if (oldValue != -1) {
                        dataProperty = NLResourceManager.hasInterest;
                        dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                        removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    }
                    if ((oldValue = UT.getInstanceLevelRepetitions(propertyIRI, uMPrpInstanceLevelKey.getForInstance(), uMPrpInstanceLevelKey.getForModifier())) == -1) continue;
                    dataProperty = NLResourceManager.maxRepetitions;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
            }
            UT.deleteProperty(propertyIRI);
        }
    }

    public void deleteClass(IRI classIRI) {
        for (UserModel UT : this.userModels.values()) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(UT.getUMIRI());
            for (OWLOntology mainModel : this.mainModels) {
                for (UMPrpClassLevelKey key : UT.getClassLevelKeys()) {
                    OWLDataPropertyAssertionAxiom dataAssertion;
                    OWLDataProperty dataProperty;
                    OWLAnonymousIndividual anIndiv;
                    if (!key.getForClass().equals((Object)classIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), key.getForProperty(), classIRI, null, key.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    OWLObjectPropertyAssertionAxiom objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                    OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)key.getForProperty());
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forOwner;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)classIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    int oldValue = UT.getClassLevelInterest(key.getForProperty(), classIRI, key.getForModifier());
                    if (oldValue != -1) {
                        dataProperty = NLResourceManager.hasInterest;
                        dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                        removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    }
                    if ((oldValue = UT.getClassLevelRepetitions(key.getForProperty(), classIRI, key.getForModifier())) == -1) continue;
                    dataProperty = NLResourceManager.maxRepetitions;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
            }
            UT.deleteClass(classIRI);
        }
    }

    public void deleteInstance(IRI instanceIRI) {
        for (UserModel UT : this.userModels.values()) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(UT.getUMIRI());
            for (OWLOntology mainModel : this.mainModels) {
                for (UMPrpInstanceLevelKey key : UT.getInstanceLevelKeys()) {
                    OWLDataPropertyAssertionAxiom dataAssertion;
                    OWLDataProperty dataProperty;
                    OWLAnonymousIndividual anIndiv;
                    if (!key.getForInstance().equals((Object)instanceIRI) || (anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), key.getForProperty(), null, instanceIRI, key.getForModifier(), null, null)) != null) continue;
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    OWLObjectPropertyAssertionAxiom objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                    OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)key.getForProperty());
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    annotationProperty = NLResourceManager.forOwner;
                    annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)instanceIRI);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    int oldValue = UT.getInstanceLevelInterest(key.getForProperty(), instanceIRI, key.getForModifier());
                    if (oldValue != -1) {
                        dataProperty = NLResourceManager.hasInterest;
                        dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                        removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                    }
                    if ((oldValue = UT.getInstanceLevelRepetitions(key.getForProperty(), instanceIRI, key.getForModifier())) == -1) continue;
                    dataProperty = NLResourceManager.maxRepetitions;
                    dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
            }
            UT.deleteInstance(instanceIRI);
        }
    }

    public void deleteSentencePlan(IRI sentencePlanIRI) {
        for (UserModel UT : this.userModels.values()) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(UT.getUMIRI());
            for (OWLOntology mainModel : this.mainModels) {
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), null, null, null, null, sentencePlanIRI, null);
                if (anIndiv != null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                OWLObjectPropertyAssertionAxiom objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectProperty = NLResourceManager.forSentencePlan;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(sentencePlanIRI));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                int oldValue = UT.getSentencePlanAppropriateness(sentencePlanIRI);
                OWLDataProperty dataProperty = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            UT.deleteSentencePlan(sentencePlanIRI);
        }
    }

    public void deleteNLName(IRI NLNameIRI) {
        for (UserModel UT : this.userModels.values()) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(UT.getUMIRI());
            for (OWLOntology mainModel : this.mainModels) {
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, UT.getUMIRI(), null, null, null, null, null, NLNameIRI);
                if (anIndiv == null) continue;
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                OWLObjectPropertyAssertionAxiom objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectProperty = NLResourceManager.forNLName;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(NLNameIRI));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                int oldValue = UT.getNLNameAppropriateness(NLNameIRI);
                OWLDataProperty dataProperty = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            UT.deleteNLName(NLNameIRI);
        }
    }

    public void setMaxMessagesPerPage(IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        int oldValue = UT.getMaxMessagesPerPage();
        for (OWLOntology mainModel : this.mainModels) {
            OWLDataProperty dataProperty = NLResourceManager.maxMessagesPerPage;
            OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, oldValue);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            if (value == -1) continue;
            dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, value);
            AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
        UT.setMaxMessagesPerPage(value);
    }

    public void setMaxMessagesPerSentence(IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        int oldValue = UT.getMaxMessagesPerSentence();
        for (OWLOntology mainModel : this.mainModels) {
            OWLDataProperty dataProperty = NLResourceManager.maxMessagesPerSentence;
            OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, oldValue);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, value);
            AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
        UT.setMaxMessagesPerSentence(value);
    }

    public void setGlobalInterest(IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value > 3) {
            value = 3;
        } else if (value < -1) {
            value = 1;
        }
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        int oldValue = UT.getGlobalInterest();
        for (OWLOntology mainModel : this.mainModels) {
            RemoveAxiom removeAxiomChange;
            OWLDataPropertyAssertionAxiom dataAssertion;
            OWLDataProperty dataProperty;
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLObjectProperty objectProperty;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, null, null, null, null, null, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            } else {
                dataProperty = NLResourceManager.hasInterest;
                dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != -1) {
                dataProperty = NLResourceManager.hasInterest;
                dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            if (UT.getGlobalInterest() != -1) continue;
            objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setGlobalInterest(value);
    }

    public void setGlobalRepetitions(IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value < 0) {
            value = 1;
        }
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        int oldValue = UT.getGlobalRepetitions();
        for (OWLOntology mainModel : this.mainModels) {
            RemoveAxiom removeAxiomChange;
            OWLDataPropertyAssertionAxiom dataAssertion;
            OWLDataProperty dataProperty;
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLObjectProperty objectProperty;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, null, null, null, null, null, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            } else {
                dataProperty = NLResourceManager.maxRepetitions;
                dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != -1) {
                dataProperty = NLResourceManager.maxRepetitions;
                dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            if (UT.getGlobalRepetitions() != -1) continue;
            objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setGlobalRepetitions(value);
    }

    public void setPropertyLevelInterest(IRI forProperty, IRI forModifier, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value > 3) {
            value = 3;
        } else if (value < -1) {
            value = -1;
        }
        if (forProperty != null) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
            for (OWLOntology mainModel : this.mainModels) {
                AddAxiom addAxiomChange;
                OWLObjectPropertyAssertionAxiom objectAssertion;
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, forProperty, null, null, forModifier, null, null);
                if (anIndiv == null) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                        OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                        objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                        addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                    OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (forModifier != null) {
                        OWLObjectProperty objectProperty = NLResourceManager.forModifier;
                        OWLObjectPropertyAssertionAxiom objectAssertion2 = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                        addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion2);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                } else {
                    int oldValue = UT.getPropertyLevelInterest(forProperty, forModifier);
                    OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if (value != -1) {
                    OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (UT.getPropertyLevelRepetitions(forProperty, forModifier) != -1) continue;
                OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                if (forModifier == null) continue;
                objectProperty = NLResourceManager.forModifier;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
        } else if (forModifier != null) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
            for (OWLOntology mainModel : this.mainModels) {
                AddAxiom addAxiomChange;
                OWLObjectPropertyAssertionAxiom objectAssertion;
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, null, null, null, forModifier, null, null);
                if (anIndiv == null) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.forModifier;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                } else {
                    int oldValue = UT.getPropertyLevelInterest(forProperty, forModifier);
                    OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if (value != -1) {
                    OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (UT.getPropertyLevelRepetitions(forProperty, forModifier) != -1) continue;
                OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectProperty = NLResourceManager.forModifier;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
        }
        UT.setPropertyLevelInterest(forProperty, forModifier, value);
    }

    public void setPropertyLevelRepetitions(IRI forProperty, IRI forModifier, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value < 0) {
            value = 1;
        }
        if (forProperty != null) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
            for (OWLOntology mainModel : this.mainModels) {
                AddAxiom addAxiomChange;
                OWLObjectPropertyAssertionAxiom objectAssertion;
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, forProperty, null, null, forModifier, null, null);
                if (anIndiv == null) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                        OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                        objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                        addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                    OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (forModifier != null) {
                        OWLObjectProperty objectProperty = NLResourceManager.forModifier;
                        OWLObjectPropertyAssertionAxiom objectAssertion2 = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                        addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion2);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                } else {
                    int oldValue = UT.getPropertyLevelRepetitions(forProperty, forModifier);
                    OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if (value != -1) {
                    OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (UT.getPropertyLevelInterest(forProperty, forModifier) != -1) continue;
                OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                if (forModifier == null) continue;
                objectProperty = NLResourceManager.forModifier;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
        } else if (forModifier != null) {
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
            for (OWLOntology mainModel : this.mainModels) {
                AddAxiom addAxiomChange;
                OWLObjectPropertyAssertionAxiom objectAssertion;
                OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, null, null, null, forModifier, null, null);
                if (anIndiv == null) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                        anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                    }
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.forModifier;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                } else {
                    int oldValue = UT.getPropertyLevelRepetitions(forProperty, forModifier);
                    OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                    RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                }
                if (value != -1) {
                    OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                    OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (UT.getPropertyLevelInterest(forProperty, forModifier) != -1) continue;
                OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
                objectProperty = NLResourceManager.forModifier;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
        }
        UT.setPropertyLevelRepetitions(forProperty, forModifier, value);
    }

    public void setClassLevelInterest(IRI forProperty, IRI forClass, IRI forModifier, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value > 3) {
            value = 3;
        } else if (value < -1) {
            value = -1;
        }
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        for (OWLOntology mainModel : this.mainModels) {
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, forProperty, forClass, null, forModifier, null, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                annotationProperty = NLResourceManager.forOwner;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forClass);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                if (forModifier != null) {
                    OWLObjectProperty objectProperty = NLResourceManager.forModifier;
                    OWLObjectPropertyAssertionAxiom objectAssertion2 = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion2);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            } else {
                int oldValue = UT.getClassLevelInterest(forProperty, forClass, forModifier);
                OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != -1) {
                OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            if (UT.getClassLevelRepetitions(forProperty, forClass, forModifier) != -1) continue;
            OWLObjectProperty objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
            OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            annotationProperty = NLResourceManager.forOwner;
            annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forClass);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            if (forModifier == null) continue;
            objectProperty = NLResourceManager.forModifier;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setClassLevelInterest(forProperty, forClass, forModifier, value);
    }

    public void setClassLevelRepetitions(IRI forProperty, IRI forClass, IRI forModifier, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value < 0) {
            value = 1;
        }
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        for (OWLOntology mainModel : this.mainModels) {
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, forProperty, forClass, null, forModifier, null, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                annotationProperty = NLResourceManager.forOwner;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forClass);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                if (forModifier != null) {
                    OWLObjectProperty objectProperty = NLResourceManager.forModifier;
                    OWLObjectPropertyAssertionAxiom objectAssertion2 = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion2);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            } else {
                int oldValue = UT.getClassLevelRepetitions(forProperty, forClass, forModifier);
                OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != -1) {
                OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            if (UT.getClassLevelInterest(forProperty, forClass, forModifier) != -1) continue;
            OWLObjectProperty objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
            OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            annotationProperty = NLResourceManager.forOwner;
            annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forClass);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            if (forModifier == null) continue;
            objectProperty = NLResourceManager.forModifier;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setClassLevelRepetitions(forProperty, forClass, forModifier, value);
    }

    public void setInstanceLevelInterest(IRI forProperty, IRI forInstance, IRI forModifier, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value > 3) {
            value = 3;
        } else if (value < -1) {
            value = -1;
        }
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        for (OWLOntology mainModel : this.mainModels) {
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, forProperty, null, forInstance, forModifier, null, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                annotationProperty = NLResourceManager.forOwner;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forInstance);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                if (forModifier != null) {
                    OWLObjectProperty objectProperty = NLResourceManager.forModifier;
                    OWLObjectPropertyAssertionAxiom objectAssertion2 = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion2);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            } else {
                int oldValue = UT.getInstanceLevelInterest(forProperty, forInstance, forModifier);
                OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != -1) {
                OWLDataProperty dataProperty = NLResourceManager.hasInterest;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            if (UT.getInstanceLevelRepetitions(forProperty, forInstance, forModifier) != -1) continue;
            OWLObjectProperty objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
            OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            annotationProperty = NLResourceManager.forOwner;
            annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forInstance);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            if (forModifier == null) continue;
            objectProperty = NLResourceManager.forModifier;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setInstanceLevelInterest(forProperty, forInstance, forModifier, value);
    }

    public void setInstanceLevelRepetitions(IRI forProperty, IRI forInstance, IRI forModifier, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        if (value < 0) {
            value = 1;
        }
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        for (OWLOntology mainModel : this.mainModels) {
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, forProperty, null, forInstance, forModifier, null, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                if (!userType.equals((Object)NLResourceManager.globalUserModel.getIRI())) {
                    OWLObjectProperty objectProperty = NLResourceManager.forUserType;
                    objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
                OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
                OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                annotationProperty = NLResourceManager.forOwner;
                annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forInstance);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                if (forModifier != null) {
                    OWLObjectProperty objectProperty = NLResourceManager.forModifier;
                    OWLObjectPropertyAssertionAxiom objectAssertion2 = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
                    addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion2);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            } else {
                int oldValue = UT.getInstanceLevelRepetitions(forProperty, forInstance, forModifier);
                OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != -1) {
                OWLDataProperty dataProperty = NLResourceManager.maxRepetitions;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            if (UT.getInstanceLevelInterest(forProperty, forInstance, forModifier) != -1) continue;
            OWLObjectProperty objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            OWLAnnotationProperty annotationProperty = NLResourceManager.forProperty;
            OWLAnnotationAssertionAxiom annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forProperty);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            annotationProperty = NLResourceManager.forOwner;
            annotationAssertion = this.NLResourcesManager.getDataFactory().getOWLAnnotationAssertionAxiom(annotationProperty, (OWLAnnotationSubject)anIndiv, (OWLAnnotationValue)forInstance);
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            if (forModifier == null) continue;
            objectProperty = NLResourceManager.forModifier;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(forModifier));
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setInstanceLevelRepetitions(forProperty, forInstance, forModifier, value);
    }

    public void setSentencePlanAppropriateness(IRI sentencePlanIRI, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        for (OWLOntology mainModel : this.mainModels) {
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLObjectProperty objectProperty;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, null, null, null, null, sentencePlanIRI, null);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                objectProperty = NLResourceManager.forSentencePlan;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(sentencePlanIRI));
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            } else {
                int oldValue = UT.getSentencePlanAppropriateness(sentencePlanIRI);
                OWLDataProperty dataProperty = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != 1) {
                OWLDataProperty dataProperty = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            objectProperty = NLResourceManager.forSentencePlan;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(sentencePlanIRI));
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setSentencePlanAppropriateness(sentencePlanIRI, value);
    }

    public void setNLNameAppropriateness(IRI NLNameIRI, IRI userType, int value) {
        UserModel UT = this.userModels.get(userType);
        OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userType);
        for (OWLOntology mainModel : this.mainModels) {
            AddAxiom addAxiomChange;
            OWLObjectPropertyAssertionAxiom objectAssertion;
            OWLObjectProperty objectProperty;
            OWLAnonymousIndividual anIndiv = this.getUMNode(mainModel, userType, null, null, null, null, null, NLNameIRI);
            if (anIndiv == null) {
                anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                while (mainModel.getReferencedAnonymousIndividuals().contains(anIndiv)) {
                    anIndiv = this.NLResourcesManager.getDataFactory().getOWLAnonymousIndividual();
                }
                objectProperty = NLResourceManager.forUserType;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                objectProperty = NLResourceManager.forNLName;
                objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(NLNameIRI));
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            } else {
                int oldValue = UT.getNLNameAppropriateness(NLNameIRI);
                OWLDataProperty dataProperty = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, oldValue);
                RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            }
            if (value != 1) {
                OWLDataProperty dataProperty = NLResourceManager.hasAppropriateness;
                OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, value);
                addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            objectProperty = NLResourceManager.forUserType;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indivUM);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
            objectProperty = NLResourceManager.forNLName;
            objectAssertion = this.NLResourcesManager.getDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(NLNameIRI));
            removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        UT.setNLNameAppropriateness(NLNameIRI, value);
    }

    public void importUserModels(OWLOntology NLResourcesModel) {
        Set userModelAssertations = NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)NLResourceManager.UserType);
        for (OWLClassAssertionAxiom userModelAssertation : userModelAssertations) {
            OWLIndividual userModelEntry = userModelAssertation.getIndividual();
            if (this.userModels.containsKey(userModelEntry.asOWLNamedIndividual().getIRI())) continue;
            UserModel UM = new UserModel(userModelEntry.asOWLNamedIndividual().getIRI());
            Set literals = userModelEntry.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.maxMessagesPerSentence, NLResourcesModel);
            for (OWLLiteral literal : literals) {
                UM.setMaxMessagesPerSentence(literal.parseInteger());
            }
            literals = userModelEntry.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.maxMessagesPerPage, NLResourcesModel);
            for (OWLLiteral literal : literals) {
                UM.setMaxMessagesPerPage(literal.parseInteger());
            }
            UM.setPropertyLevelInterest(NLResourceManager.instanceOf.getIRI(), null, 1);
            UM.setPropertyLevelRepetitions(NLResourceManager.instanceOf.getIRI(), null, 1);
            UM.setPropertyLevelInterest(NLResourceManager.oneOf.getIRI(), null, 1);
            UM.setPropertyLevelRepetitions(NLResourceManager.oneOf.getIRI(), null, 1);
            UM.setPropertyLevelInterest(NLResourceManager.differentIndividuals.getIRI(), null, 1);
            UM.setPropertyLevelRepetitions(NLResourceManager.differentIndividuals.getIRI(), null, 1);
            UM.setPropertyLevelInterest(NLResourceManager.sameIndividuals.getIRI(), null, 1);
            UM.setPropertyLevelRepetitions(NLResourceManager.sameIndividuals.getIRI(), null, 1);
            UM.setPropertyLevelInterest(NLResourceManager.isA.getIRI(), null, 1);
            UM.setPropertyLevelRepetitions(NLResourceManager.isA.getIRI(), null, 1);
            this.userModels.put(UM.getUMIRI(), UM);
        }
    }

    public void exportUserModels(OWLOntology NLResourcesModel) {
        for (IRI userModelIRI : this.getUserModels()) {
            UserModel UM = this.userModels.get(userModelIRI);
            OWLNamedIndividual indivUM = this.NLResourcesManager.getDataFactory().getOWLNamedIndividual(userModelIRI);
            OWLClass cls = NLResourceManager.UserType;
            OWLClassAssertionAxiom classAssertion = this.NLResourcesManager.getDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indivUM);
            this.NLResourcesManager.getOntologyManager().addAxiom(NLResourcesModel, (OWLAxiom)classAssertion);
            OWLDataProperty dataProperty = NLResourceManager.maxMessagesPerSentence;
            OWLDataPropertyAssertionAxiom dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, UM.getMaxMessagesPerSentence());
            AddAxiom addAxiomChange = new AddAxiom(NLResourcesModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.maxMessagesPerPage;
            dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, UM.getMaxMessagesPerPage());
            addAxiomChange = new AddAxiom(NLResourcesModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasInterest;
            dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, UM.getGlobalInterest());
            addAxiomChange = new AddAxiom(NLResourcesModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.maxRepetitions;
            dataAssertion = this.NLResourcesManager.getDataFactory().getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivUM, UM.getGlobalRepetitions());
            addAxiomChange = new AddAxiom(NLResourcesModel, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
    }

    public void importAnnotationEvents(OWLOntology mainModel) {
        this.mainModels.add(mainModel);
        Set UMNodes = mainModel.getReferencedAnonymousIndividuals();
        for (OWLAnonymousIndividual node : UMNodes) {
            OWLLiteral literal;
            OWLIndividual individual2;
            OWLIndividual forUserModel = null;
            IRI forProperty = null;
            IRI forClass = null;
            IRI forInstance = null;
            IRI forModifier = null;
            OWLLiteral hasInterest = null;
            OWLLiteral maxRepetitions = null;
            OWLIndividual forSentencePlan = null;
            OWLIndividual forNLName = null;
            OWLLiteral hasAppropriateness = null;
            Set individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forUserType, mainModel);
            Iterator iterator = individuals.iterator();
            while (iterator.hasNext()) {
                forUserModel = individual2 = (OWLIndividual)iterator.next();
            }
            for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)node)) {
                if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.forProperty)) continue;
                if (annotation.getAnnotation().getValue() instanceof IRI) {
                    forProperty = (IRI)annotation.getAnnotation().getValue();
                    continue;
                }
                if (!(annotation.getAnnotation().getValue() instanceof OWLLiteral)) continue;
                forProperty = IRI.create((String)((OWLLiteral)annotation.getAnnotation().getValue()).getLiteral());
            }
            for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)node)) {
                if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.forOwner) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
                if (mainModel.containsClassInSignature((IRI)annotation.getAnnotation().getValue(), true)) {
                    forClass = (IRI)annotation.getAnnotation().getValue();
                    continue;
                }
                if (!mainModel.containsIndividualInSignature((IRI)annotation.getAnnotation().getValue(), true)) continue;
                forInstance = (IRI)annotation.getAnnotation().getValue();
            }
            individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forModifier, mainModel);
            for (OWLIndividual individual2 : individuals) {
                forModifier = individual2.asOWLNamedIndividual().getIRI();
            }
            Set literals = node.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasInterest, mainModel);
            iterator = literals.iterator();
            while (iterator.hasNext()) {
                hasInterest = literal = (OWLLiteral)iterator.next();
            }
            literals = node.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.maxRepetitions, mainModel);
            iterator = literals.iterator();
            while (iterator.hasNext()) {
                maxRepetitions = literal = (OWLLiteral)iterator.next();
            }
            individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forSentencePlan, mainModel);
            iterator = individuals.iterator();
            while (iterator.hasNext()) {
                forSentencePlan = individual2 = (OWLIndividual)iterator.next();
            }
            individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forNLName, mainModel);
            iterator = individuals.iterator();
            while (iterator.hasNext()) {
                forNLName = individual2 = (OWLIndividual)iterator.next();
            }
            literals = node.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasAppropriateness, mainModel);
            iterator = literals.iterator();
            while (iterator.hasNext()) {
                hasAppropriateness = literal = (OWLLiteral)iterator.next();
            }
            HashSet<UserModel> UMs = new HashSet<UserModel>();
            if (forUserModel != null) {
                if (this.checkUserTypeExists(forUserModel.asOWLNamedIndividual().getIRI())) {
                    UMs.add(this.userModels.get(forUserModel.asOWLNamedIndividual().getIRI()));
                }
            } else {
                UMs.add(this.userModels.get(NLResourceManager.globalUserModel.getIRI()));
            }
            for (UserModel UM : UMs) {
                if (forProperty != null && forInstance != null && hasInterest != null) {
                    UM.setInstanceLevelInterest(forProperty, forInstance, forModifier, hasInterest.parseInteger());
                } else if (forProperty != null && forClass != null && hasInterest != null) {
                    UM.setClassLevelInterest(forProperty, forClass, forModifier, hasInterest.parseInteger());
                } else if (forProperty != null && hasInterest != null) {
                    UM.setPropertyLevelInterest(forProperty, forModifier, hasInterest.parseInteger());
                } else if (forModifier != null && hasInterest != null) {
                    UM.setPropertyLevelInterest(null, forModifier, hasInterest.parseInteger());
                } else if (hasInterest != null) {
                    UM.setGlobalInterest(hasInterest.parseInteger());
                }
                if (forProperty != null && forInstance != null && maxRepetitions != null) {
                    UM.setInstanceLevelRepetitions(forProperty, forInstance, forModifier, maxRepetitions.parseInteger());
                } else if (forProperty != null && forClass != null && maxRepetitions != null) {
                    UM.setClassLevelRepetitions(forProperty, forClass, forModifier, maxRepetitions.parseInteger());
                } else if (forProperty != null && maxRepetitions != null) {
                    UM.setPropertyLevelRepetitions(forProperty, forModifier, maxRepetitions.parseInteger());
                } else if (forModifier != null && maxRepetitions != null) {
                    UM.setPropertyLevelRepetitions(null, forModifier, maxRepetitions.parseInteger());
                } else if (maxRepetitions != null) {
                    UM.setGlobalRepetitions(maxRepetitions.parseInteger());
                }
                if (forSentencePlan != null && hasAppropriateness != null) {
                    UM.setSentencePlanAppropriateness(forSentencePlan.asOWLNamedIndividual().getIRI(), hasAppropriateness.parseInteger());
                    continue;
                }
                if (forNLName == null || hasAppropriateness == null) continue;
                UM.setNLNameAppropriateness(forNLName.asOWLNamedIndividual().getIRI(), hasAppropriateness.parseInteger());
            }
        }
    }

    public OWLAnonymousIndividual getUMNode(OWLOntology mainModel, IRI userModel, IRI property, IRI cls, IRI instance, IRI modifier, IRI sentencePlan, IRI NLName2) {
        OWLAnonymousIndividual UMNode = null;
        Set UMNodes = mainModel.getReferencedAnonymousIndividuals();
        for (OWLAnonymousIndividual node : UMNodes) {
            UMNode = !userModel.equals((Object)NLResourceManager.globalUserModel.getIRI()) ? this.checkUMNode(mainModel, node, userModel, property, cls, instance, modifier, sentencePlan, NLName2) : this.checkUMNode(mainModel, node, null, property, cls, instance, modifier, sentencePlan, NLName2);
            if (UMNode == null) continue;
            return UMNode;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OWLAnonymousIndividual checkUMNode(OWLOntology mainModel, OWLAnonymousIndividual node, IRI userModel, IRI property, IRI cls, IRI instance, IRI modifier, IRI sentencePlan, IRI NLName2) {
        IRI forUserModel = null;
        IRI forProperty = null;
        IRI forClass = null;
        IRI forInstance = null;
        IRI forModifier = null;
        IRI forSentencePlan = null;
        IRI forNLName = null;
        Set individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forUserType, mainModel);
        for (OWLIndividual individual : individuals) {
            forUserModel = individual.asOWLNamedIndividual().getIRI();
        }
        for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)node)) {
            if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.forProperty)) continue;
            if (annotation.getAnnotation().getValue() instanceof IRI) {
                forProperty = (IRI)annotation.getAnnotation().getValue();
                continue;
            }
            if (!(annotation.getAnnotation().getValue() instanceof OWLLiteral)) continue;
            forProperty = IRI.create((String)((OWLLiteral)annotation.getAnnotation().getValue()).getLiteral());
        }
        for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)node)) {
            if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.forOwner) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
            if (mainModel.containsClassInSignature((IRI)annotation.getAnnotation().getValue(), true)) {
                forClass = (IRI)annotation.getAnnotation().getValue();
                continue;
            }
            if (!mainModel.containsIndividualInSignature((IRI)annotation.getAnnotation().getValue(), true)) continue;
            forInstance = (IRI)annotation.getAnnotation().getValue();
        }
        individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forModifier, mainModel);
        for (OWLIndividual individual : individuals) {
            forModifier = individual.asOWLNamedIndividual().getIRI();
        }
        individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forSentencePlan, mainModel);
        for (OWLIndividual individual : individuals) {
            forSentencePlan = individual.asOWLNamedIndividual().getIRI();
        }
        individuals = node.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forNLName, mainModel);
        for (OWLIndividual individual : individuals) {
            forNLName = individual.asOWLNamedIndividual().getIRI();
        }
        if (forUserModel != null) {
            if (userModel == null) return null;
            if (!forUserModel.equals((Object)userModel)) {
                return null;
            }
        } else if (userModel != null) {
            return null;
        }
        if (forProperty != null) {
            if (property == null) return null;
            if (!forProperty.equals((Object)property)) {
                return null;
            }
        } else if (property != null) {
            return null;
        }
        if (forClass != null) {
            if (cls == null) return null;
            if (!forClass.equals((Object)cls)) {
                return null;
            }
        } else if (cls != null) {
            return null;
        }
        if (forInstance != null) {
            if (instance == null) return null;
            if (!forInstance.equals((Object)instance)) {
                return null;
            }
        } else if (instance != null) {
            return null;
        }
        if (forModifier != null) {
            if (modifier == null) return null;
            if (!forModifier.equals((Object)modifier)) {
                return null;
            }
        } else if (modifier != null) {
            return null;
        }
        if (forSentencePlan != null) {
            if (sentencePlan == null) return null;
            if (!forSentencePlan.equals((Object)sentencePlan)) {
                return null;
            }
        } else if (sentencePlan != null) {
            return null;
        }
        if (forNLName != null) {
            if (NLName2 == null) return null;
            if (forNLName.equals((Object)NLName2)) return node;
            return null;
        }
        if (NLName2 == null) return node;
        return null;
    }

    public int getMaxMessagesPerPage(IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getMaxMessagesPerPage();
    }

    public int getMaxMessagesPerSentence(IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getMaxMessagesPerSentence();
    }

    public int getGlobalInterest(IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getGlobalInterest();
    }

    public int getGlobalRepetitions(IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getGlobalRepetitions();
    }

    public int getPropertyLevelInterest(IRI forProperty, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getPropertyLevelInterest(forProperty, forModifier);
    }

    public int getPropertyLevelRepetitions(IRI forProperty, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getPropertyLevelRepetitions(forProperty, forModifier);
    }

    public int getClassLevelInterest(IRI forProperty, IRI forClass, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getClassLevelInterest(forProperty, forClass, forModifier);
    }

    public int getClassLevelRepetitions(IRI forProperty, IRI forClass, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getClassLevelRepetitions(forProperty, forClass, forModifier);
    }

    public int getInstanceLevelInterest(IRI forProperty, IRI forInstance, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getInstanceLevelInterest(forProperty, forInstance, forModifier);
    }

    public int getInstanceLevelRepetitions(IRI forProperty, IRI forInstance, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getInstanceLevelRepetitions(forProperty, forInstance, forModifier);
    }

    public int getInterest(IRI forProperty, IRI forOwner, IRI forModifier, IRI userType) {
        UserModel UM = this.userModels.get(userType);
        UserModel global = this.userModels.get(NLResourceManager.globalUserModel.getIRI());
        HashSet<Integer> modelInterests = new HashSet<Integer>();
        int interest = -1;
        for (OWLOntology mainModel : this.mainModels) {
            for (OWLEntity entity : mainModel.getEntitiesInSignature(forOwner, false)) {
                if (entity.isOWLNamedIndividual()) {
                    interest = UM.getInstanceLevelInterest(forProperty, forOwner, forModifier);
                    if (interest == -1) {
                        interest = global.getInstanceLevelInterest(forProperty, forOwner, forModifier);
                    }
                    if (interest == -1) {
                        for (OWLClassAssertionAxiom superClassAxiom : mainModel.getClassAssertionAxioms((OWLIndividual)entity.asOWLNamedIndividual())) {
                            if (superClassAxiom.getClassExpression().isAnonymous() || interest != -1) continue;
                            interest = this.getInterest(forProperty, superClassAxiom.getClassExpression().asOWLClass().getIRI(), forModifier, userType);
                        }
                    }
                    if (interest == -1) {
                        interest = UM.getPropertyLevelInterest(forProperty, forModifier);
                    }
                    if (interest == -1) {
                        interest = global.getPropertyLevelInterest(forProperty, forModifier);
                    }
                    if (interest == -1 && forModifier != null) {
                        interest = UM.getPropertyLevelInterest(null, forModifier);
                    }
                    if (interest != -1 || forModifier == null) continue;
                    interest = global.getPropertyLevelInterest(null, forModifier);
                    continue;
                }
                if (!entity.isOWLClass()) continue;
                interest = UM.getClassLevelInterest(forProperty, forOwner, forModifier);
                if (interest == -1) {
                    interest = global.getClassLevelInterest(forProperty, forOwner, forModifier);
                }
                if (interest == -1) {
                    for (OWLClassAssertionAxiom superClassAxiom : entity.asOWLClass().getSuperClasses(mainModel)) {
                        if (superClassAxiom.isAnonymous() || interest != -1) continue;
                        interest = this.getInterest(forProperty, superClassAxiom.asOWLClass().getIRI(), forModifier, userType);
                    }
                }
                if (interest == -1) {
                    interest = UM.getPropertyLevelInterest(forProperty, forModifier);
                }
                if (interest == -1) {
                    interest = global.getPropertyLevelInterest(forProperty, forModifier);
                }
                if (interest == -1 && forModifier != null) {
                    interest = UM.getPropertyLevelInterest(null, forModifier);
                }
                if (interest != -1 || forModifier == null) continue;
                interest = global.getPropertyLevelInterest(null, forModifier);
            }
            modelInterests.add(interest);
        }
        interest = -1;
        for (Integer modelInterest : modelInterests) {
            if (modelInterest <= interest) continue;
            interest = modelInterest;
        }
        if (interest == -1) {
            interest = UM.getGlobalInterest();
        }
        if (interest == -1) {
            interest = global.getGlobalInterest();
        }
        return interest;
    }

    public int getRepetitions(IRI forProperty, IRI forIRI, IRI forModifier, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        UserModel global = this.userModels.get(NLResourceManager.globalUserModel.getIRI());
        HashSet<Integer> modelRepetitions = new HashSet<Integer>();
        int repetitions = -1;
        for (OWLOntology mainModel : this.mainModels) {
            for (OWLEntity entity : mainModel.getEntitiesInSignature(forIRI, false)) {
                if (entity instanceof OWLNamedIndividual) {
                    repetitions = UT.getInstanceLevelRepetitions(forProperty, forIRI, forModifier);
                    if (repetitions == -1) {
                        repetitions = global.getPropertyLevelRepetitions(forProperty, forModifier);
                    }
                    if (repetitions == -1) {
                        for (OWLClassAssertionAxiom superClassAxiom : mainModel.getClassAssertionAxioms((OWLIndividual)((OWLNamedIndividual)entity))) {
                            if (superClassAxiom.getClassExpression().isAnonymous() || repetitions != -1) continue;
                            repetitions = UT.getClassLevelRepetitions(forProperty, superClassAxiom.getClassExpression().asOWLClass().getIRI(), forModifier);
                        }
                    }
                    if (repetitions == -1) {
                        repetitions = UT.getPropertyLevelRepetitions(forProperty, forModifier);
                    }
                    if (repetitions != -1) continue;
                    repetitions = global.getPropertyLevelRepetitions(forProperty, forModifier);
                    continue;
                }
                if (!(entity instanceof OWLClass)) continue;
                repetitions = UT.getClassLevelRepetitions(forProperty, forIRI, forModifier);
                if (repetitions == -1) {
                    repetitions = global.getClassLevelRepetitions(forProperty, forIRI, forModifier);
                }
                if (repetitions == -1) {
                    repetitions = UT.getPropertyLevelRepetitions(forProperty, forModifier);
                }
                if (repetitions != -1) continue;
                repetitions = global.getPropertyLevelRepetitions(forProperty, forModifier);
            }
            modelRepetitions.add(repetitions);
        }
        repetitions = -1;
        for (Integer modelInterest : modelRepetitions) {
            if (modelInterest <= repetitions) continue;
            repetitions = modelInterest;
        }
        if (repetitions == -1) {
            repetitions = UT.getGlobalRepetitions();
        }
        if (repetitions == -1) {
            repetitions = global.getGlobalRepetitions();
        }
        return repetitions;
    }

    public UserModel getGlobalUserModel() {
        return this.userModels.get(NLResourceManager.globalUserModel.getIRI());
    }

    public int getSentencePlanAppropriateness(IRI sentencePlanIRI, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getSentencePlanAppropriateness(sentencePlanIRI);
    }

    public int getNLNameAppropriateness(IRI NLNameIRI, IRI userType) {
        UserModel UT = this.userModels.get(userType);
        return UT.getNLNameAppropriateness(NLNameIRI);
    }

    public UserModel getUserModel(IRI userType) {
        return this.userModels.get(userType);
    }

    public Set<IRI> getUserModels() {
        return this.userModels.keySet();
    }

    public boolean checkUserTypeExists(IRI UserType) {
        return this.userModels.containsKey(UserType);
    }
}

