/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SPAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.SPComparatorFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPComparatorSlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationPropertySlot;
import gr.aueb.cs.nlg.NLFiles.SPConcatenationSlot;
import gr.aueb.cs.nlg.NLFiles.SPFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPNounSlot;
import gr.aueb.cs.nlg.NLFiles.SPOwnerSlot;
import gr.aueb.cs.nlg.NLFiles.SPPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SPStringSlot;
import gr.aueb.cs.nlg.NLFiles.SPVerbSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLFiles.SentencePlansList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class SentencePlanQueryManager {
    public List<String> PropertiesUsedForComparisons;
    private SentencePlansList GreekSentencePlanList;
    private SentencePlansList EnglishSentencePlanList;
    private NLResourceManager NLResourcesManager;

    public SentencePlanQueryManager(NLResourceManager NLResourcesManager) {
        this.NLResourcesManager = NLResourcesManager;
        this.init();
    }

    private void init() {
        this.GreekSentencePlanList = new SentencePlansList("el");
        this.EnglishSentencePlanList = new SentencePlansList("en");
        for (SentencePlan plan : DefaultResourcesManager.generateDefaultSentencePlans("el")) {
            this.GreekSentencePlanList.add(plan);
        }
        for (SentencePlan plan : DefaultResourcesManager.generateDefaultSentencePlans("en")) {
            this.EnglishSentencePlanList.add(plan);
        }
    }

    public void importSentencePlans(OWLOntology NLResourcesModel) {
        Set sentencePlanAssertations = NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)NLResourceManager.SentencePlan);
        for (OWLClassAssertionAxiom sentencePlanAssertation : sentencePlanAssertations) {
            OWLIndividual sentencePlanEntry = sentencePlanAssertation.getIndividual();
            if (this.EnglishSentencePlanList.containsSentencePlan(sentencePlanEntry.asOWLNamedIndividual().getIRI())) {
                this.EnglishSentencePlanList.removeSentencePlan(sentencePlanEntry.asOWLNamedIndividual().getIRI());
            }
            if (this.GreekSentencePlanList.containsSentencePlan(sentencePlanEntry.asOWLNamedIndividual().getIRI())) {
                this.GreekSentencePlanList.removeSentencePlan(sentencePlanEntry.asOWLNamedIndividual().getIRI());
            }
            Set forLanguages = sentencePlanEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forLanguage, NLResourcesModel);
            for (OWLIndividual language : forLanguages) {
                if (language.equals(NLResourceManager.greekLanguage)) {
                    this.GreekSentencePlanList.add(this.createSentencePlan(sentencePlanEntry, "el", NLResourcesModel));
                    continue;
                }
                if (!language.equals(NLResourceManager.englishLanguage)) continue;
                this.EnglishSentencePlanList.add(this.createSentencePlan(sentencePlanEntry, "en", NLResourcesModel));
            }
        }
    }

    private SentencePlan createSentencePlan(OWLIndividual sentencePlan, String lang, OWLOntology NLResourcesModel) {
        String aggAllowed = "true";
        Set literals = sentencePlan.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.aggregationAllowed, NLResourcesModel);
        for (OWLLiteral literal : literals) {
            aggAllowed = literal.getLiteral();
        }
        ArrayList<SPSlot> slots = this.createSlots(sentencePlan, NLResourcesModel);
        return new SentencePlan(slots, sentencePlan.asOWLNamedIndividual().getIRI(), aggAllowed.compareTo("true") == 0, lang);
    }

    public ArrayList<SPSlot> createSlots(OWLIndividual sentencePlan, OWLOntology NLResourcesModel) {
        ArrayList<SPSlot> sentencePlanSlots = new ArrayList<SPSlot>();
        int order = -1;
        String refType = "";
        String caseType = "";
        boolean bullets = false;
        String text = "";
        IRI entryIRI = null;
        String tense = "";
        String voice = "";
        String polarity = "";
        String gender = "";
        String number = "";
        String person = "";
        NodeID agreesWithID = null;
        Set slots = sentencePlan.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasSlot, NLResourcesModel);
        for (OWLIndividual slot : slots) {
            Set slotTypes = slot.getTypes(NLResourcesModel);
            for (OWLClassExpression slotType : slotTypes) {
                Set literals;
                Set individuals;
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.OwnerSlot.getIRI())) {
                    refType = "";
                    caseType = "";
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        if (individual.equals(NLResourceManager.nominativeCase)) {
                            caseType = "nominative";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.genitiveCase)) {
                            caseType = "genitive";
                            continue;
                        }
                        if (!individual.equals(NLResourceManager.accusativeCase)) continue;
                        caseType = "accusative";
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.refExpressionType, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        if (individual.equals(NLResourceManager.autoRefExpression)) {
                            refType = "auto";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.pronounRefExpression)) {
                            refType = "pronoun";
                            continue;
                        }
                        if (!individual.equals(NLResourceManager.demonstrativeRefExpression)) continue;
                        refType = "demonstrative";
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPOwnerSlot OS = new SPOwnerSlot(caseType, refType, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(OS);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.FillerSlot.getIRI())) {
                    caseType = "";
                    bullets = false;
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        if (individual.equals(NLResourceManager.nominativeCase)) {
                            caseType = "nominative";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.genitiveCase)) {
                            caseType = "genitive";
                            continue;
                        }
                        if (!individual.equals(NLResourceManager.accusativeCase)) continue;
                        caseType = "accusative";
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.useBullets, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        bullets = literal.parseBoolean();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPFillerSlot FS = new SPFillerSlot(caseType, bullets, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(FS);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.VerbSlot.getIRI())) {
                    entryIRI = null;
                    tense = "";
                    voice = "";
                    polarity = "";
                    number = "";
                    person = "";
                    agreesWithID = null;
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useLexiconEntry, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        entryIRI = individual.asOWLNamedIndividual().getIRI();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.agreeWith, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        agreesWithID = individual.asOWLAnonymousIndividual().getID();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useTense, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        if (individual.equals(NLResourceManager.simplePresentTense)) {
                            tense = "simple present";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.presentContinuousTense)) {
                            tense = "present continuous";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.presentPerfectTense)) {
                            tense = "present perfect";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.simplePastTense)) {
                            tense = "simple past";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.pastContinuousTense)) {
                            tense = "past continuous";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.pastPerfectTense)) {
                            tense = "past perfect";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.pastPerfectContinuousTense)) {
                            tense = "past perfect continuous";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.simpleFutureTense)) {
                            tense = "simple future";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.futureContinuousTense)) {
                            tense = "future continuous";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.futurePerfectTense)) {
                            tense = "future perfect";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.futurePerfectContinuousTense)) {
                            tense = "future perfect continuous";
                            continue;
                        }
                        if (individual.equals(NLResourceManager.infinitiveTense)) {
                            tense = "infinitive";
                            continue;
                        }
                        if (!individual.equals(NLResourceManager.participleTense)) continue;
                        tense = "participle";
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useVoice, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        if (individual.equals(NLResourceManager.activeVoice)) {
                            voice = "active";
                            continue;
                        }
                        if (!individual.equals(NLResourceManager.passiveVoice)) continue;
                        voice = "passive";
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.usePolarity, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        polarity = literal.getLiteral();
                    }
                    if (agreesWithID == null) {
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useNumber, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.singularNumber)) {
                                number = "singular";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.pluralNumber)) {
                                number = "plural";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                            number = "both";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.usePerson, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.firstPerson)) {
                                person = "1st";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.secondPerson)) {
                                person = "2nd";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.thirdPerson)) continue;
                            person = "3rd";
                        }
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPVerbSlot VLES = new SPVerbSlot(entryIRI, tense, voice, polarity, number, person, agreesWithID, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(VLES);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.AdjectiveSlot.getIRI())) {
                    entryIRI = null;
                    caseType = "";
                    gender = "";
                    number = "";
                    agreesWithID = null;
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useLexiconEntry, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        entryIRI = individual.asOWLNamedIndividual().getIRI();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.agreeWith, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        agreesWithID = individual.asOWLAnonymousIndividual().getID();
                    }
                    if (agreesWithID == null) {
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.nominativeCase)) {
                                caseType = "nominative";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.genitiveCase)) {
                                caseType = "genitive";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.accusativeCase)) continue;
                            caseType = "accusative";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useGender, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.masculineGender)) {
                                gender = "masculine";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.feminineGender)) {
                                gender = "feminine";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.neuterGender)) {
                                gender = "neuter";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.masculineOrFeminineGender)) continue;
                            gender = "masculineOrFeminine";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useNumber, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.singularNumber)) {
                                number = "singular";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.pluralNumber)) {
                                number = "plural";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                            number = "both";
                        }
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPAdjectiveSlot ALES = new SPAdjectiveSlot(entryIRI, caseType, gender, number, agreesWithID, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(ALES);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.NounSlot.getIRI())) {
                    entryIRI = null;
                    caseType = "";
                    number = "";
                    agreesWithID = null;
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useLexiconEntry, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        entryIRI = individual.asOWLNamedIndividual().getIRI();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.agreeWith, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        agreesWithID = individual.asOWLAnonymousIndividual().getID();
                    }
                    if (agreesWithID == null) {
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.nominativeCase)) {
                                caseType = "nominative";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.genitiveCase)) {
                                caseType = "genitive";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.accusativeCase)) {
                                caseType = "accusative";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                            number = "both";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useNumber, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.singularNumber)) {
                                number = "singular";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.pluralNumber)) continue;
                            number = "plural";
                        }
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPNounSlot NLES = new SPNounSlot(entryIRI, caseType, number, agreesWithID, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(NLES);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.StringSlot.getIRI())) {
                    text = "";
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasString, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        text = literal.getLiteral();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPStringSlot SS = new SPStringSlot(text, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(SS);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.PrepositionSlot.getIRI())) {
                    text = "";
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasString, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        text = literal.getLiteral();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPPrepositionSlot PS = new SPPrepositionSlot(text, slot.asOWLAnonymousIndividual().getID(), order);
                    sentencePlanSlots.add(PS);
                    continue;
                }
                if (!slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.ConcatenationSlot.getIRI())) continue;
                literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    order = literal.parseInteger();
                }
                SPConcatenationSlot CS = new SPConcatenationSlot(slot.asOWLAnonymousIndividual().getID(), order);
                individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.concatenates, NLResourcesModel);
                for (OWLIndividual individual : individuals) {
                    entryIRI = null;
                    caseType = "";
                    literals = individual.asOWLAnonymousIndividual().getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasProperty, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        entryIRI = IRI.create((String)literal.getLiteral());
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                    for (OWLIndividual indiv : individuals) {
                        if (indiv.equals(NLResourceManager.nominativeCase)) {
                            caseType = "nominative";
                            continue;
                        }
                        if (indiv.equals(NLResourceManager.genitiveCase)) {
                            caseType = "genitive";
                            continue;
                        }
                        if (!indiv.equals(NLResourceManager.accusativeCase)) continue;
                        caseType = "accusative";
                    }
                    literals = individual.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    SPConcatenationPropertySlot CPS = new SPConcatenationPropertySlot(entryIRI, caseType, individual.asOWLAnonymousIndividual().getID(), order);
                    CS.concatenateProperty(CPS);
                }
                sentencePlanSlots.add(CS);
            }
        }
        return sentencePlanSlots;
    }

    public boolean getIsAggAllowed(IRI SentencePlanIRI, String language) {
        SentencePlan plan;
        if (Languages.isEnglish(language)) {
            SentencePlan plan2 = this.EnglishSentencePlanList.getSentencePlan(SentencePlanIRI);
            if (plan2 != null) {
                return plan2.getAggAllowed();
            }
        } else if (Languages.isGreek(language) && (plan = this.GreekSentencePlanList.getSentencePlan(SentencePlanIRI)) != null) {
            return plan.getAggAllowed();
        }
        return false;
    }

    public NLResourceManager getNLResourcesManager() {
        return this.NLResourcesManager;
    }

    public SentencePlansList getSentencePlansList(String language) {
        if (Languages.isEnglish(language)) {
            return this.EnglishSentencePlanList;
        }
        if (Languages.isGreek(language)) {
            return this.GreekSentencePlanList;
        }
        return null;
    }

    public void duplicateSentencePlanInLists(IRI fromIRI, IRI toIRI, String toLanguage) {
        SentencePlan fromPlan = null;
        if (this.EnglishSentencePlanList.containsSentencePlan(fromIRI)) {
            fromPlan = this.EnglishSentencePlanList.getSentencePlan(fromIRI);
        } else if (this.GreekSentencePlanList.containsSentencePlan(fromIRI)) {
            fromPlan = this.GreekSentencePlanList.getSentencePlan(fromIRI);
        }
        if (fromPlan != null) {
            ArrayList<SPSlot> slots = new ArrayList<SPSlot>();
            for (SPSlot slot : fromPlan.getSlotsList()) {
                SPSlot slotCopy;
                if (slot instanceof SPOwnerSlot) {
                    slotCopy = new SPOwnerSlot((SPOwnerSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPFillerSlot) {
                    slotCopy = new SPFillerSlot((SPFillerSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPVerbSlot) {
                    slotCopy = new SPVerbSlot((SPVerbSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    if (((SPVerbSlot)slotCopy).getAgreesWithID() != null) {
                        ((SPVerbSlot)slotCopy).setAgreesWithID(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((SPVerbSlot)slotCopy).getAgreesWithID().toString().substring(((SPVerbSlot)slotCopy).getAgreesWithID().toString().indexOf("slot") + "slot".length())).getID());
                    }
                    if (fromPlan.getLanguage().equals("en") && toLanguage.equals("el")) {
                        if (!(((SPVerbSlot)slotCopy).getTense().equals("simple present") || ((SPVerbSlot)slotCopy).getTense().equals("present perfect") || ((SPVerbSlot)slotCopy).getTense().equals("simple past") || ((SPVerbSlot)slotCopy).getTense().equals("past continuous") || ((SPVerbSlot)slotCopy).getTense().equals("past perfect") || ((SPVerbSlot)slotCopy).getTense().equals("simple future") || ((SPVerbSlot)slotCopy).getTense().equals("future continuous") || ((SPVerbSlot)slotCopy).getTense().equals("future perfect") || ((SPVerbSlot)slotCopy).getTense().equals("infinitive") || ((SPVerbSlot)slotCopy).getTense().equals("participle"))) {
                            ((SPVerbSlot)slotCopy).setTense("simple present");
                        }
                    } else if (!(!fromPlan.getLanguage().equals("el") || !toLanguage.equals("en") || ((SPVerbSlot)slotCopy).getTense().equals("simple present") || ((SPVerbSlot)slotCopy).getTense().equals("present continuous") || ((SPVerbSlot)slotCopy).getTense().equals("present perfect") || ((SPVerbSlot)slotCopy).getTense().equals("simple past") || ((SPVerbSlot)slotCopy).getTense().equals("past continuous") || ((SPVerbSlot)slotCopy).getTense().equals("past perfect continuous") || ((SPVerbSlot)slotCopy).getTense().equals("simple future") || ((SPVerbSlot)slotCopy).getTense().equals("future continuous") || ((SPVerbSlot)slotCopy).getTense().equals("future perfect") || ((SPVerbSlot)slotCopy).getTense().equals("future perfect continuous"))) {
                        ((SPVerbSlot)slotCopy).setTense("simple present");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPAdjectiveSlot) {
                    slotCopy = new SPAdjectiveSlot((SPAdjectiveSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    if (((SPAdjectiveSlot)slotCopy).getAgreesWithID() != null) {
                        ((SPAdjectiveSlot)slotCopy).setAgreesWithID(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((SPAdjectiveSlot)slotCopy).getAgreesWithID().toString().substring(((SPAdjectiveSlot)slotCopy).getAgreesWithID().toString().indexOf("slot") + "slot".length())).getID());
                    }
                    if (fromPlan.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((SPAdjectiveSlot)slotCopy).setCase("nominative");
                        ((SPAdjectiveSlot)slotCopy).setGender("masculineOrFeminine");
                    } else if (fromPlan.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((SPAdjectiveSlot)slotCopy).setCase("");
                        ((SPAdjectiveSlot)slotCopy).setGender("");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPNounSlot) {
                    slotCopy = new SPNounSlot((SPNounSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    if (((SPNounSlot)slotCopy).getAgreesWithID() != null) {
                        ((SPNounSlot)slotCopy).setAgreesWithID(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((SPNounSlot)slotCopy).getAgreesWithID().toString().substring(((SPNounSlot)slotCopy).getAgreesWithID().toString().indexOf("slot") + "slot".length())).getID());
                    }
                    if (fromPlan.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((SPNounSlot)slotCopy).setCase("nominative");
                    } else if (fromPlan.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((SPNounSlot)slotCopy).setCase("");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPPrepositionSlot) {
                    slotCopy = new SPPrepositionSlot((SPPrepositionSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    if (fromPlan.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((SPPrepositionSlot)slotCopy).setPrep("\u03ac\u03bd\u03b5\u03c5");
                    } else if (fromPlan.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((SPPrepositionSlot)slotCopy).setPrep("aboard");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPStringSlot) {
                    slotCopy = new SPStringSlot((SPStringSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPConcatenationSlot) {
                    slotCopy = new SPConcatenationSlot((SPConcatenationSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    for (SPConcatenationPropertySlot concatCopy : ((SPConcatenationSlot)slotCopy).getPropertySlots()) {
                        concatCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "conslot" + slotCopy.getOrder() + "_" + concatCopy.getOrder()).getID());
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof SPComparatorSlot) {
                    slotCopy = new SPComparatorSlot((SPComparatorSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                    slots.add(slotCopy);
                    continue;
                }
                if (!(slot instanceof SPComparatorFillerSlot)) continue;
                slotCopy = new SPComparatorFillerSlot((SPComparatorFillerSlot)slot);
                slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + slotCopy.getOrder()).getID());
                slots.add(slotCopy);
            }
            if (toLanguage.equals("en")) {
                this.EnglishSentencePlanList.add(new SentencePlan(slots, toIRI, fromPlan.getAggAllowed(), "en"));
            } else if (toLanguage.equals("el")) {
                this.GreekSentencePlanList.add(new SentencePlan(slots, toIRI, fromPlan.getAggAllowed(), "el"));
            }
        }
    }

    public SentencePlan getSentencePlan(IRI sentencePlanIRI, String language) {
        if (Languages.isEnglish(language)) {
            return this.EnglishSentencePlanList.getSentencePlan(sentencePlanIRI);
        }
        if (Languages.isGreek(language)) {
            return this.GreekSentencePlanList.getSentencePlan(sentencePlanIRI);
        }
        return null;
    }

    public ArrayList<SPSlot> getSlots(IRI sentencePlanIRI) {
        if (this.EnglishSentencePlanList.containsSentencePlan(sentencePlanIRI)) {
            return this.EnglishSentencePlanList.getSentencePlan(sentencePlanIRI).getSlotsList();
        }
        if (this.GreekSentencePlanList.containsSentencePlan(sentencePlanIRI)) {
            return this.GreekSentencePlanList.getSentencePlan(sentencePlanIRI).getSlotsList();
        }
        return null;
    }

    public void addSentencePlan(IRI entryIRI, String lang) {
        if (Languages.isEnglish(lang)) {
            ArrayList<SPSlot> slots = new ArrayList<SPSlot>();
            SPOwnerSlot OS = new SPOwnerSlot("nominative", "auto", this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(entryIRI.getFragment()) + "_" + "slot" + 1).getID(), 1);
            slots.add(OS);
            this.EnglishSentencePlanList.add(new SentencePlan(slots, entryIRI, true, "en"));
        } else if (Languages.isGreek(lang)) {
            ArrayList<SPSlot> slots = new ArrayList<SPSlot>();
            SPOwnerSlot OS = new SPOwnerSlot("nominative", "auto", this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(entryIRI.getFragment()) + "_" + "slot" + 1).getID(), 1);
            slots.add(OS);
            this.GreekSentencePlanList.add(new SentencePlan(slots, entryIRI, true, "el"));
        }
    }

    public void addSentencePlan(SentencePlan plan, String lang) {
        if (Languages.isEnglish(lang)) {
            this.EnglishSentencePlanList.add(plan);
        } else if (Languages.isGreek(lang)) {
            this.GreekSentencePlanList.add(plan);
        }
    }

    public void removeSentencePlan(IRI entryIRI) {
        if (this.EnglishSentencePlanList.containsSentencePlan(entryIRI)) {
            this.EnglishSentencePlanList.removeSentencePlan(entryIRI);
        }
        if (this.GreekSentencePlanList.containsSentencePlan(entryIRI)) {
            this.GreekSentencePlanList.removeSentencePlan(entryIRI);
        }
    }

    public SentencePlan getSentencePlan(IRI SentencePlanIRI) {
        if (this.EnglishSentencePlanList.containsSentencePlan(SentencePlanIRI)) {
            return this.EnglishSentencePlanList.getSentencePlan(SentencePlanIRI);
        }
        if (this.GreekSentencePlanList.containsSentencePlan(SentencePlanIRI)) {
            return this.GreekSentencePlanList.getSentencePlan(SentencePlanIRI);
        }
        return null;
    }

    public void exportSentencePlans(OWLOntology resourceOntology) {
        OWLDataFactory factory = this.NLResourcesManager.getDataFactory();
        ArrayList<SentencePlan> sentencePlanMasterList = new ArrayList<SentencePlan>();
        sentencePlanMasterList.addAll(this.EnglishSentencePlanList.getSentencePlansList());
        sentencePlanMasterList.addAll(this.GreekSentencePlanList.getSentencePlansList());
        for (SentencePlan plan : sentencePlanMasterList) {
            if (!DefaultResourcesManager.isDefaultResource(plan.getSentencePlanIRI()) && plan.getSentencePlanIRI().toString().startsWith(NLResourceManager.nlowlNS)) continue;
            IRI sentencePlanIRI = plan.getSentencePlanIRI();
            OWLClass cls = NLResourceManager.SentencePlan;
            OWLNamedIndividual indivPlan = factory.getOWLNamedIndividual(sentencePlanIRI);
            OWLClassAssertionAxiom classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indivPlan);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            OWLObjectProperty objectProperty = NLResourceManager.forLanguage;
            Object objectAssertion = null;
            if (Languages.isEnglish(plan.getLanguage())) {
                objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)NLResourceManager.englishLanguage);
            } else if (Languages.isGreek(plan.getLanguage())) {
                objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)NLResourceManager.greekLanguage);
            }
            AddAxiom addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            OWLDataProperty dataProperty = NLResourceManager.aggregationAllowed;
            OWLDataPropertyAssertionAxiom dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivPlan, plan.getAggAllowed());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            ArrayList<SPSlot> slots = plan.getSlotsList();
            for (SPSlot slot : slots) {
                OWLAnonymousIndividual anonym;
                OWLNamedIndividual indiv;
                OWLAnonymousIndividual anIndiv;
                if (slot instanceof SPOwnerSlot) {
                    cls = NLResourceManager.OwnerSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useCase;
                    objectAssertion = ((SPOwnerSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((SPOwnerSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((SPOwnerSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                    if (objectAssertion != null) {
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    objectProperty = NLResourceManager.refExpressionType;
                    objectAssertion = ((SPOwnerSlot)slot).getRefType().equals("auto") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.autoRefExpression) : (((SPOwnerSlot)slot).getRefType().equals("pronoun") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pronounRefExpression) : (((SPOwnerSlot)slot).getRefType().equals("demonstrative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.demonstrativeRefExpression) : null));
                    if (objectAssertion != null) {
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof SPFillerSlot) {
                    cls = NLResourceManager.FillerSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useCase;
                    objectAssertion = ((SPFillerSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((SPFillerSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((SPFillerSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                    if (objectAssertion != null) {
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    dataProperty = NLResourceManager.useBullets;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((SPFillerSlot)slot).getBullets());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof SPVerbSlot) {
                    cls = NLResourceManager.VerbSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useLexiconEntry;
                    indiv = factory.getOWLNamedIndividual(((SPVerbSlot)slot).getLexiconEntryIRI());
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useTense;
                    objectAssertion = ((SPVerbSlot)slot).getTense().equals("simple present") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.simplePresentTense) : (((SPVerbSlot)slot).getTense().equals("present continuous") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.presentContinuousTense) : (((SPVerbSlot)slot).getTense().equals("present perfect") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.presentPerfectTense) : (((SPVerbSlot)slot).getTense().equals("simple past") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.simplePastTense) : (((SPVerbSlot)slot).getTense().equals("past continuous") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pastContinuousTense) : (((SPVerbSlot)slot).getTense().equals("past perfect") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pastPerfectTense) : (((SPVerbSlot)slot).getTense().equals("past perfect continuous") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pastPerfectContinuousTense) : (((SPVerbSlot)slot).getTense().equals("simple future") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.simpleFutureTense) : (((SPVerbSlot)slot).getTense().equals("future continuous") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.futureContinuousTense) : (((SPVerbSlot)slot).getTense().equals("future perfect") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.futurePerfectTense) : (((SPVerbSlot)slot).getTense().equals("future perfect continuous") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.futurePerfectContinuousTense) : (((SPVerbSlot)slot).getTense().equals("infinitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.infinitiveTense) : (((SPVerbSlot)slot).getTense().equals("participle") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.participleTense) : null))))))))))));
                    if (objectAssertion != null) {
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    objectProperty = NLResourceManager.useVoice;
                    objectAssertion = ((SPVerbSlot)slot).getVoice().equals("active") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.activeVoice) : (((SPVerbSlot)slot).getVoice().equals("passive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.passiveVoice) : null);
                    if (objectAssertion != null) {
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    dataProperty = NLResourceManager.usePolarity;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((SPVerbSlot)slot).getPolarity());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (((SPVerbSlot)slot).getAgreesWithID() != null) {
                        objectProperty = NLResourceManager.agreeWith;
                        anonym = factory.getOWLAnonymousIndividual(((SPVerbSlot)slot).getAgreesWithID().toString());
                        objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)anonym);
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    } else {
                        objectProperty = NLResourceManager.useNumber;
                        objectAssertion = ((SPVerbSlot)slot).getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.singularNumber) : (((SPVerbSlot)slot).getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pluralNumber) : (((SPVerbSlot)slot).getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.bothNumbers) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        objectProperty = NLResourceManager.usePerson;
                        objectAssertion = ((SPVerbSlot)slot).getPerson().equals("1st") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.firstPerson) : (((SPVerbSlot)slot).getPerson().equals("2nd") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.secondPerson) : (((SPVerbSlot)slot).getPerson().equals("3rd") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.thirdPerson) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof SPAdjectiveSlot) {
                    cls = NLResourceManager.AdjectiveSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useLexiconEntry;
                    indiv = factory.getOWLNamedIndividual(((SPAdjectiveSlot)slot).getLexiconEntryIRI());
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (((SPAdjectiveSlot)slot).getAgreesWithID() != null) {
                        objectProperty = NLResourceManager.agreeWith;
                        anonym = factory.getOWLAnonymousIndividual(((SPAdjectiveSlot)slot).getAgreesWithID().toString());
                        objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)anonym);
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    } else {
                        objectProperty = NLResourceManager.useNumber;
                        objectAssertion = ((SPAdjectiveSlot)slot).getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.singularNumber) : (((SPAdjectiveSlot)slot).getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pluralNumber) : (((SPAdjectiveSlot)slot).getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.bothNumbers) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        if (Languages.isGreek(plan.getLanguage())) {
                            objectProperty = NLResourceManager.useCase;
                            objectAssertion = ((SPAdjectiveSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((SPAdjectiveSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((SPAdjectiveSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                            if (objectAssertion != null) {
                                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                            }
                            objectProperty = NLResourceManager.useGender;
                            objectAssertion = ((SPAdjectiveSlot)slot).getGender().equals("masculine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.masculineGender) : (((SPAdjectiveSlot)slot).getGender().equals("feminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.feminineGender) : (((SPAdjectiveSlot)slot).getGender().equals("neuter") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.neuterGender) : (((SPAdjectiveSlot)slot).getGender().equals("masculineOrFeminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.masculineOrFeminineGender) : null)));
                            if (objectAssertion != null) {
                                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                            }
                        }
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof SPNounSlot) {
                    cls = NLResourceManager.NounSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useLexiconEntry;
                    indiv = factory.getOWLNamedIndividual(((SPNounSlot)slot).getLexiconEntryIRI());
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (((SPNounSlot)slot).getAgreesWithID() != null) {
                        objectProperty = NLResourceManager.agreeWith;
                        anonym = factory.getOWLAnonymousIndividual(((SPNounSlot)slot).getAgreesWithID().toString());
                        objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)anonym);
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    } else {
                        objectProperty = NLResourceManager.useNumber;
                        objectAssertion = ((SPNounSlot)slot).getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.singularNumber) : (((SPNounSlot)slot).getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pluralNumber) : (((SPNounSlot)slot).getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.bothNumbers) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        if (Languages.isGreek(plan.getLanguage())) {
                            objectProperty = NLResourceManager.useCase;
                            objectAssertion = ((SPNounSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((SPNounSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((SPNounSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                            if (objectAssertion != null) {
                                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                            }
                        }
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof SPStringSlot) {
                    cls = NLResourceManager.StringSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasString;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((SPStringSlot)slot).getText());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof SPPrepositionSlot) {
                    cls = NLResourceManager.PrepositionSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasString;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((SPPrepositionSlot)slot).getPrep());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (!(slot instanceof SPConcatenationSlot)) continue;
                cls = NLResourceManager.ConcatenationSlot;
                anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                objectProperty = NLResourceManager.hasSlot;
                objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasOrder;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                ArrayList<SPConcatenationPropertySlot> propertySlots = ((SPConcatenationSlot)slot).getPropertySlots();
                for (SPConcatenationPropertySlot propertySlot : propertySlots) {
                    cls = NLResourceManager.PropertySlot;
                    OWLAnonymousIndividual propertyAnIndiv = factory.getOWLAnonymousIndividual(propertySlot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)propertyAnIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.concatenates;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)propertyAnIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasProperty;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)propertyAnIndiv, propertySlot.getPropertyIRI().toString());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useCase;
                    objectAssertion = propertySlot.getCaseType().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)propertyAnIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (propertySlot.getCaseType().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)propertyAnIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (propertySlot.getCaseType().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)propertyAnIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                    if (objectAssertion != null) {
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)propertyAnIndiv, propertySlot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                }
            }
        }
    }

    public List<String> getPropertiesUsedForComparisons() {
        return this.PropertiesUsedForComparisons;
    }
}

