/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class OrderingQueryManager {
    public static final int defaultOrder = 100;
    private HashMap<IRI, Integer> propertyOrders;
    private HashMap<IRI, IRI> propertySections;
    private HashMap<IRI, Integer> sectionOrders;
    private HashMap<IRI, String> sectionLabelsEN;
    private HashMap<IRI, String> sectionLabelsGR;
    public HashSet<OWLOntology> mainModels = new HashSet();
    NLResourceManager NLResourceManager;

    public OrderingQueryManager(NLResourceManager NLResourceManager2) {
        this.NLResourceManager = NLResourceManager2;
        this.init();
    }

    private void init() {
        this.propertyOrders = new HashMap();
        this.propertySections = new HashMap();
        this.sectionOrders = new HashMap();
        this.sectionLabelsEN = new HashMap();
        this.sectionLabelsGR = new HashMap();
        this.sectionOrders.put(gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI(), 100);
        for (OWLNamedIndividual domainIndependentProperty : gr.aueb.cs.nlg.NLFiles.NLResourceManager.domainIndependentProperties) {
            this.propertySections.put(domainIndependentProperty.getIRI(), gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI());
            this.propertyOrders.put(domainIndependentProperty.getIRI(), 0);
        }
    }

    public void setPropertySection(IRI propertyIRI, IRI sectionIRI) {
        this.propertySections.put(propertyIRI, sectionIRI);
        if (!DefaultResourcesManager.isDefaultResource(propertyIRI)) {
            for (OWLOntology model : this.getContainingOntologies(propertyIRI)) {
                OWLAnnotationAssertionAxiom annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sectionIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sectionIRI);
                axiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void setPropertyOrder(IRI propertyIRI, int order) {
        int oldOrder = this.propertyOrders.get(propertyIRI);
        this.propertyOrders.put(propertyIRI, order);
        if (!DefaultResourcesManager.isDefaultResource(propertyIRI)) {
            for (OWLOntology model : this.getContainingOntologies(propertyIRI)) {
                OWLAnnotationAssertionAxiom annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)model.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(oldOrder));
                RemoveAxiom axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)model.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(order));
                axiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void setSectionOrder(IRI sectionIRI, int order) {
        this.sectionOrders.put(sectionIRI, order);
    }

    public void addProperty(IRI propertyIRI) {
        this.propertySections.put(propertyIRI, gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI());
        this.propertyOrders.put(propertyIRI, 100);
        for (OWLOntology model : this.getContainingOntologies(propertyIRI)) {
            AddAxiom addAxiomChange;
            OWLAnnotationAssertionAxiom annotationAssertion;
            if (!this.propertyOrders.containsKey(propertyIRI)) {
                annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)model.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(100));
                addAxiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            if (this.propertySections.containsKey(propertyIRI)) continue;
            annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI());
            addAxiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
    }

    public void addSection(IRI sectionIRI) {
        this.sectionOrders.put(sectionIRI, 100);
    }

    public void renameProperty(IRI oldPropertyIRI, IRI newPropertyIRI) {
        int order = this.propertyOrders.remove(oldPropertyIRI);
        IRI sectionIRI = this.propertySections.remove(oldPropertyIRI);
        this.propertyOrders.put(newPropertyIRI, order);
        this.propertySections.put(newPropertyIRI, sectionIRI);
        for (OWLOntology model : this.getContainingOntologies(oldPropertyIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)oldPropertyIRI, (OWLAnnotationValue)model.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(order));
            RemoveAxiom axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)newPropertyIRI, (OWLAnnotationValue)model.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(order));
            axiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)oldPropertyIRI, (OWLAnnotationValue)sectionIRI);
            axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)newPropertyIRI, (OWLAnnotationValue)sectionIRI);
            axiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
    }

    public void renameSection(IRI oldSectionIRI, IRI newSectionIRI) {
        String label;
        int order = this.sectionOrders.remove(oldSectionIRI);
        this.sectionOrders.put(newSectionIRI, order);
        if (this.sectionLabelsEN.containsKey(oldSectionIRI)) {
            label = this.sectionLabelsEN.remove(oldSectionIRI);
            this.sectionLabelsEN.put(newSectionIRI, label);
        }
        if (this.sectionLabelsGR.containsKey(oldSectionIRI)) {
            label = this.sectionLabelsGR.remove(oldSectionIRI);
            this.sectionLabelsGR.put(newSectionIRI, label);
        }
        for (OWLOntology model : this.mainModels) {
            for (IRI property : this.propertySections.keySet()) {
                if (!this.propertySections.get(property).equals((Object)oldSectionIRI)) continue;
                this.propertySections.put(property, newSectionIRI);
                if (DefaultResourcesManager.isDefaultResource(property)) continue;
                OWLAnnotationAssertionAxiom annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)property, (OWLAnnotationValue)oldSectionIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)property, (OWLAnnotationValue)newSectionIRI);
                axiomChange = new AddAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void deleteProperty(IRI propertyIRI) {
        int order = this.propertyOrders.remove(propertyIRI);
        IRI sectionIRI = this.propertySections.remove(propertyIRI);
        for (OWLOntology model : this.getContainingOntologies(propertyIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)model.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(order));
            RemoveAxiom axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sectionIRI);
            axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
            model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
    }

    public void deleteSection(IRI sectionIRI) {
        this.sectionOrders.remove(sectionIRI);
        if (this.sectionLabelsEN.containsKey(sectionIRI)) {
            this.sectionLabelsEN.remove(sectionIRI);
        }
        if (this.sectionLabelsGR.containsKey(sectionIRI)) {
            this.sectionLabelsGR.remove(sectionIRI);
        }
        for (OWLOntology model : this.mainModels) {
            for (IRI property : this.propertySections.keySet()) {
                if (!this.propertySections.get(property).equals((Object)sectionIRI)) continue;
                this.propertySections.put(property, gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI());
                if (DefaultResourcesManager.isDefaultResource(property)) continue;
                OWLAnnotationAssertionAxiom annotationAssertion = model.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)property, (OWLAnnotationValue)sectionIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(model, (OWLAxiom)annotationAssertion);
                model.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void importSections(OWLOntology NLResourcesModel) {
        HashSet<IRI> sectionIRIs = new HashSet<IRI>();
        for (OWLClassAssertionAxiom sectionAssertion : NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)gr.aueb.cs.nlg.NLFiles.NLResourceManager.Section)) {
            OWLIndividual sectionEntry = sectionAssertion.getIndividual();
            if (!sectionEntry.isNamed()) continue;
            sectionIRIs.add(sectionEntry.asOWLNamedIndividual().getIRI());
        }
        for (IRI sectionIRI : sectionIRIs) {
            for (OWLAnnotationAssertionAxiom annotation : NLResourcesModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)sectionIRI)) {
                if (annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn) && annotation.getAnnotation().getValue() instanceof OWLLiteral) {
                    int order = ((OWLLiteral)annotation.getAnnotation().getValue()).parseInteger();
                    this.sectionOrders.put(sectionIRI, order);
                }
                if (!annotation.getProperty().isLabel() || !(annotation.getValue() instanceof OWLLiteral)) continue;
                if (((OWLLiteral)annotation.getValue()).hasLang("gr") || ((OWLLiteral)annotation.getValue()).hasLang("el")) {
                    this.sectionLabelsGR.put(sectionIRI, ((OWLLiteral)annotation.getValue()).getLiteral());
                }
                if (((OWLLiteral)annotation.getValue()).hasLang("en")) {
                    this.sectionLabelsEN.put(sectionIRI, ((OWLLiteral)annotation.getValue()).getLiteral());
                    continue;
                }
                if (((OWLLiteral)annotation.getValue()).hasLang()) continue;
                this.sectionLabelsEN.put(sectionIRI, ((OWLLiteral)annotation.getValue()).getLiteral());
            }
            if (this.sectionOrders.containsKey(sectionIRI)) continue;
            this.addSection(sectionIRI);
        }
    }

    public void importOrdering(OWLOntology model) {
        IRI propertyIRI;
        this.mainModels.add(model);
        for (OWLDataProperty dataProperty : model.getDataPropertiesInSignature(true)) {
            if (dataProperty.getIRI().toString().startsWith(gr.aueb.cs.nlg.NLFiles.NLResourceManager.nlowlNS)) continue;
            for (OWLAnnotationAssertionAxiom annotation : model.getAnnotationAssertionAxioms((OWLAnnotationSubject)dataProperty.getIRI())) {
                if (annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn)) {
                    if (!(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral)) continue;
                    propertyIRI = (IRI)annotation.getSubject();
                    int order = ((OWLLiteral)annotation.getAnnotation().getValue()).parseInteger();
                    this.propertyOrders.put(propertyIRI, order);
                    continue;
                }
                if (!annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
                propertyIRI = (IRI)annotation.getSubject();
                IRI sectionIRI = (IRI)annotation.getAnnotation().getValue();
                this.propertySections.put(propertyIRI, sectionIRI);
            }
            if (this.propertyOrders.containsKey(dataProperty.getIRI()) && this.propertySections.containsKey(dataProperty.getIRI())) continue;
            this.addProperty(dataProperty.getIRI());
        }
        for (OWLObjectProperty objectProperty : model.getObjectPropertiesInSignature(true)) {
            if (objectProperty.getIRI().toString().startsWith(gr.aueb.cs.nlg.NLFiles.NLResourceManager.nlowlNS)) continue;
            for (OWLAnnotationAssertionAxiom annotation : model.getAnnotationAssertionAxioms((OWLAnnotationSubject)objectProperty.getIRI())) {
                if (annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn)) {
                    if (!(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral)) continue;
                    propertyIRI = (IRI)annotation.getSubject();
                    int order = ((OWLLiteral)annotation.getAnnotation().getValue()).parseInteger();
                    this.propertyOrders.put(propertyIRI, order);
                    continue;
                }
                if (!annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
                propertyIRI = (IRI)annotation.getSubject();
                IRI sectionIRI = (IRI)annotation.getAnnotation().getValue();
                this.propertySections.put(propertyIRI, sectionIRI);
            }
            if (this.propertyOrders.containsKey(objectProperty.getIRI()) && this.propertySections.containsKey(objectProperty.getIRI())) continue;
            this.addProperty(objectProperty.getIRI());
        }
        for (OWLNamedIndividual domainIndependentProperty : gr.aueb.cs.nlg.NLFiles.NLResourceManager.domainIndependentProperties) {
            for (OWLAnnotationAssertionAxiom annotation : model.getAnnotationAssertionAxioms((OWLAnnotationSubject)domainIndependentProperty.getIRI())) {
                if (annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn)) {
                    if (!(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral)) continue;
                    propertyIRI = (IRI)annotation.getSubject();
                    int order = ((OWLLiteral)annotation.getAnnotation().getValue()).parseInteger();
                    this.propertyOrders.put(propertyIRI, order);
                    continue;
                }
                if (!annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
                propertyIRI = (IRI)annotation.getSubject();
                IRI sectionIRI = (IRI)annotation.getAnnotation().getValue();
                this.propertySections.put(propertyIRI, sectionIRI);
            }
            if (this.propertyOrders.containsKey(domainIndependentProperty.getIRI()) && this.propertySections.containsKey(domainIndependentProperty.getIRI())) continue;
            this.addProperty(domainIndependentProperty.getIRI());
        }
        for (IRI sectionIRI : this.propertySections.values()) {
            if (this.sectionOrders.containsKey(sectionIRI)) continue;
            for (OWLAnnotationAssertionAxiom annotation : model.getAnnotationAssertionAxioms((OWLAnnotationSubject)sectionIRI)) {
                if (!annotation.getAnnotation().getProperty().equals(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral)) continue;
                int order = ((OWLLiteral)annotation.getAnnotation().getValue()).parseInteger();
                this.sectionOrders.put(sectionIRI, order);
            }
            if (this.sectionOrders.containsKey(sectionIRI)) continue;
            this.addSection(sectionIRI);
        }
    }

    public void exportSections(OWLOntology resourceOntology) {
        AddAxiom axiomChange;
        OWLAnnotationAssertionAxiom annotationAssertion;
        OWLClassAssertionAxiom classAssertion;
        OWLNamedIndividual indiv;
        OWLDataFactory factory = resourceOntology.getOWLOntologyManager().getOWLDataFactory();
        OWLClass cls = gr.aueb.cs.nlg.NLFiles.NLResourceManager.Section;
        for (IRI sectionIRI : this.sectionOrders.keySet()) {
            if (sectionIRI.equals((Object)gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI())) continue;
            indiv = factory.getOWLNamedIndividual(sectionIRI);
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indiv);
            resourceOntology.getOWLOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            annotationAssertion = factory.getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)sectionIRI, (OWLAnnotationValue)factory.getOWLLiteral(this.getSectionOrder(sectionIRI)));
            axiomChange = new AddAxiom(resourceOntology, (OWLAxiom)annotationAssertion);
            resourceOntology.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
        for (IRI sectionIRI : this.sectionLabelsEN.keySet()) {
            if (sectionIRI.equals((Object)gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI())) continue;
            indiv = factory.getOWLNamedIndividual(sectionIRI);
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indiv);
            resourceOntology.getOWLOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            annotationAssertion = factory.getOWLAnnotationAssertionAxiom(factory.getRDFSLabel(), (OWLAnnotationSubject)sectionIRI, (OWLAnnotationValue)factory.getOWLLiteral(this.sectionLabelsEN.get(sectionIRI), "en"));
            axiomChange = new AddAxiom(resourceOntology, (OWLAxiom)annotationAssertion);
            resourceOntology.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
        for (IRI sectionIRI : this.sectionLabelsGR.keySet()) {
            if (sectionIRI.equals((Object)gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI())) continue;
            indiv = factory.getOWLNamedIndividual(sectionIRI);
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indiv);
            resourceOntology.getOWLOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            annotationAssertion = factory.getOWLAnnotationAssertionAxiom(factory.getRDFSLabel(), (OWLAnnotationSubject)sectionIRI, (OWLAnnotationValue)factory.getOWLLiteral(this.sectionLabelsGR.get(sectionIRI), "gr"));
            axiomChange = new AddAxiom(resourceOntology, (OWLAxiom)annotationAssertion);
            resourceOntology.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
    }

    public void exportOrders(OWLOntology resourceOntology) {
        OWLDataFactory factory = resourceOntology.getOWLOntologyManager().getOWLDataFactory();
        for (OWLNamedIndividual domainIndependentProperty : gr.aueb.cs.nlg.NLFiles.NLResourceManager.domainIndependentProperties) {
            if (this.getPropertySection(domainIndependentProperty.getIRI()).equals((Object)gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI())) continue;
            OWLAnnotationAssertionAxiom annotationAssertion = factory.getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasSection, (OWLAnnotationSubject)domainIndependentProperty.getIRI(), (OWLAnnotationValue)this.getPropertySection(domainIndependentProperty.getIRI()));
            AddAxiom axiomChange = new AddAxiom(resourceOntology, (OWLAxiom)annotationAssertion);
            resourceOntology.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            annotationAssertion = factory.getOWLAnnotationAssertionAxiom(gr.aueb.cs.nlg.NLFiles.NLResourceManager.hasOrderAnn, (OWLAnnotationSubject)domainIndependentProperty.getIRI(), (OWLAnnotationValue)factory.getOWLLiteral(this.getPropertyOrder(domainIndependentProperty.getIRI())));
            axiomChange = new AddAxiom(resourceOntology, (OWLAxiom)annotationAssertion);
            resourceOntology.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
    }

    public ArrayList<IRI> getOrderedSections() {
        HashSet<IRI> sectionIRIs = new HashSet<IRI>();
        for (IRI sectionIRI : this.sectionOrders.keySet()) {
            sectionIRIs.add(sectionIRI);
        }
        sectionIRIs.remove(gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI());
        ArrayList<IRI> orderedSectionIRIs = new ArrayList<IRI>();
        while (!sectionIRIs.isEmpty()) {
            IRI minIRI = null;
            int minOrder = Integer.MAX_VALUE;
            for (IRI sectionIRI : sectionIRIs) {
                if (this.sectionOrders.get(sectionIRI) > minOrder) continue;
                minIRI = sectionIRI;
                minOrder = this.sectionOrders.get(sectionIRI);
            }
            orderedSectionIRIs.add(minIRI);
            sectionIRIs.remove(minIRI);
        }
        return orderedSectionIRIs;
    }

    public ArrayList<IRI> getPropertiesInSection(IRI sectionIRI) {
        HashSet<IRI> propertyIRIs = new HashSet<IRI>();
        for (IRI propertyIRI : this.propertySections.keySet()) {
            if (!this.propertySections.get(propertyIRI).equals((Object)sectionIRI)) continue;
            propertyIRIs.add(propertyIRI);
        }
        ArrayList<IRI> orderedPropertyIRIs = new ArrayList<IRI>();
        while (!propertyIRIs.isEmpty()) {
            IRI minIRI = null;
            int minOrder = Integer.MAX_VALUE;
            for (IRI propertyIRI : propertyIRIs) {
                if (this.propertyOrders.get(propertyIRI) > minOrder) continue;
                minIRI = propertyIRI;
                minOrder = this.propertyOrders.get(propertyIRI);
            }
            orderedPropertyIRIs.add(minIRI);
            propertyIRIs.remove(minIRI);
        }
        return orderedPropertyIRIs;
    }

    public int getPropertyOrder(IRI propertyIRI) {
        if (this.propertyOrders.containsKey(propertyIRI)) {
            return this.propertyOrders.get(propertyIRI);
        }
        return 100;
    }

    public IRI getPropertySection(IRI propertyIRI) {
        if (this.propertySections.containsKey(propertyIRI)) {
            return this.propertySections.get(propertyIRI);
        }
        return gr.aueb.cs.nlg.NLFiles.NLResourceManager.defaultSection.getIRI();
    }

    public int getSectionOrder(IRI section) {
        if (this.sectionOrders.containsKey(section)) {
            return this.sectionOrders.get(section);
        }
        return 100;
    }

    public int getPropertySectionOrder(IRI propertyIRI) {
        if (this.propertySections.containsKey(propertyIRI)) {
            return this.sectionOrders.get(this.propertySections.get(propertyIRI));
        }
        return 100;
    }

    public String getSectionLabel(IRI sectionIRI, String language) {
        if (Languages.isEnglish(language)) {
            if (this.sectionLabelsEN.containsKey(sectionIRI)) {
                return this.sectionLabelsEN.get(sectionIRI);
            }
        } else if (Languages.isGreek(language) && this.sectionLabelsGR.containsKey(sectionIRI)) {
            return this.sectionLabelsGR.get(sectionIRI);
        }
        return "";
    }

    public void setSectionLabel(IRI sectionIRI, String label, String language) {
        if (label.isEmpty()) {
            if (Languages.isEnglish(language)) {
                this.sectionLabelsEN.remove(sectionIRI);
            } else if (Languages.isGreek(language)) {
                this.sectionLabelsGR.remove(sectionIRI);
            }
        } else if (Languages.isEnglish(language)) {
            this.sectionLabelsEN.put(sectionIRI, label);
        } else if (Languages.isGreek(language)) {
            this.sectionLabelsGR.put(sectionIRI, label);
        }
    }

    public HashSet<OWLOntology> getContainingOntologies(IRI entryIRI) {
        HashSet<OWLOntology> containingOntologies = new HashSet<OWLOntology>();
        for (OWLOntology model : this.mainModels) {
            if (model.containsObjectPropertyInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsDataPropertyInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsClassInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsEntityInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (!model.containsIndividualInSignature(entryIRI, true)) continue;
            containingOntologies.add(model);
        }
        return containingOntologies;
    }
}

