/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNArticleSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLNStringSlot;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLNamesList;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import java.util.ArrayList;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class NLNameQueryManager {
    private NLNamesList GreekNLNameList;
    private NLNamesList EnglishNLNameList;
    NLResourceManager NLResourcesManager;

    public NLNameQueryManager(NLResourceManager NLResourcesManager) {
        this.NLResourcesManager = NLResourcesManager;
        this.init();
    }

    private void init() {
        this.GreekNLNameList = new NLNamesList("el");
        this.EnglishNLNameList = new NLNamesList("en");
        for (NLName plan : DefaultResourcesManager.generateDefaultNLNames("el")) {
            this.GreekNLNameList.add(plan);
        }
        for (NLName plan : DefaultResourcesManager.generateDefaultNLNames("en")) {
            this.EnglishNLNameList.add(plan);
        }
    }

    public void importNLNames(OWLOntology NLResourcesModel) {
        Set nlNameAssertations = NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)NLResourceManager.NLName);
        for (OWLClassAssertionAxiom nlNameAssertation : nlNameAssertations) {
            OWLIndividual nlNameEntry = nlNameAssertation.getIndividual();
            if (this.EnglishNLNameList.containsNLName(nlNameEntry.asOWLNamedIndividual().getIRI())) {
                this.EnglishNLNameList.removeNLName(nlNameEntry.asOWLNamedIndividual().getIRI());
            }
            if (this.GreekNLNameList.containsNLName(nlNameEntry.asOWLNamedIndividual().getIRI())) {
                this.GreekNLNameList.removeNLName(nlNameEntry.asOWLNamedIndividual().getIRI());
            }
            Set forLanguages = nlNameEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.forLanguage, NLResourcesModel);
            for (OWLIndividual language : forLanguages) {
                if (language.equals(NLResourceManager.greekLanguage)) {
                    this.GreekNLNameList.add(this.createNLName(nlNameEntry, "el", NLResourcesModel));
                    continue;
                }
                if (!language.equals(NLResourceManager.englishLanguage)) continue;
                this.EnglishNLNameList.add(this.createNLName(nlNameEntry, "en", NLResourcesModel));
            }
        }
    }

    private NLName createNLName(OWLIndividual nlName, String lang, OWLOntology NLResourcesModel) {
        String aggAllowed = "true";
        Set literals = nlName.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.aggregationAllowed, NLResourcesModel);
        for (OWLLiteral literal : literals) {
            aggAllowed = literal.getLiteral();
        }
        String focusLost = "false";
        literals = nlName.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.focusLost, NLResourcesModel);
        for (OWLLiteral literal : literals) {
            focusLost = literal.getLiteral();
        }
        ArrayList<NLNSlot> slots = this.createSlots(nlName, NLResourcesModel);
        return new NLName(slots, nlName.asOWLNamedIndividual().getIRI(), aggAllowed.compareTo("true") == 0, focusLost.compareTo("true") == 0, lang);
    }

    public ArrayList<NLNSlot> createSlots(OWLIndividual nlName, OWLOntology NLResourcesModel) {
        ArrayList<NLNSlot> nlNameSlots = new ArrayList<NLNSlot>();
        int order = -1;
        String caseType = "";
        boolean definite = false;
        String text = "";
        IRI entryIRI = null;
        boolean isHead = false;
        boolean isCapitalized = false;
        String gender = "";
        String number = "";
        NodeID agreesWithID = null;
        Set slots = nlName.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasSlot, NLResourcesModel);
        for (OWLIndividual slot : slots) {
            Set slotTypes = slot.getTypes(NLResourcesModel);
            for (OWLClassExpression slotType : slotTypes) {
                Set individuals;
                Set literals;
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.ArticleSlot.getIRI())) {
                    caseType = "";
                    gender = "";
                    number = "";
                    definite = false;
                    agreesWithID = null;
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.isDefinite, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        definite = literal.parseBoolean();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.agreeWith, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        agreesWithID = individual.asOWLAnonymousIndividual().getID();
                    }
                    if (agreesWithID == null) {
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.nominativeCase)) {
                                caseType = "nominative";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.genitiveCase)) {
                                caseType = "genitive";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.accusativeCase)) continue;
                            caseType = "accusative";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useGender, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.masculineGender)) {
                                gender = "masculine";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.feminineGender)) {
                                gender = "feminine";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.neuterGender)) {
                                gender = "neuter";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.masculineOrFeminineGender)) continue;
                            gender = "masculineOrFeminine";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useNumber, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.singularNumber)) {
                                number = "singular";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.pluralNumber)) {
                                number = "plural";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                            number = "both";
                        }
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    NLNArticleSlot AS = new NLNArticleSlot(definite, caseType, gender, number, agreesWithID, slot.asOWLAnonymousIndividual().getID(), order);
                    nlNameSlots.add(AS);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.AdjectiveSlot.getIRI())) {
                    entryIRI = null;
                    caseType = "";
                    gender = "";
                    number = "";
                    isHead = false;
                    isCapitalized = false;
                    agreesWithID = null;
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useLexiconEntry, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        entryIRI = individual.asOWLNamedIndividual().getIRI();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.agreeWith, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        agreesWithID = individual.asOWLAnonymousIndividual().getID();
                    }
                    if (agreesWithID == null) {
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.nominativeCase)) {
                                caseType = "nominative";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.genitiveCase)) {
                                caseType = "genitive";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.accusativeCase)) continue;
                            caseType = "accusative";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useGender, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.masculineGender)) {
                                gender = "masculine";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.feminineGender)) {
                                gender = "feminine";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.neuterGender)) {
                                gender = "neuter";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.masculineOrFeminineGender)) continue;
                            gender = "masculineOrFeminine";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useNumber, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.singularNumber)) {
                                number = "singular";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.pluralNumber)) {
                                number = "plural";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                            number = "both";
                        }
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.isHead, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        isHead = literal.parseBoolean();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.isCapitalized, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        isCapitalized = literal.parseBoolean();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    NLNAdjectiveSlot ES = new NLNAdjectiveSlot(entryIRI, caseType, gender, number, isHead, isCapitalized, agreesWithID, slot.asOWLAnonymousIndividual().getID(), order);
                    nlNameSlots.add(ES);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.NounSlot.getIRI())) {
                    entryIRI = null;
                    caseType = "";
                    number = "";
                    isHead = false;
                    isCapitalized = false;
                    agreesWithID = null;
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useLexiconEntry, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        entryIRI = individual.asOWLNamedIndividual().getIRI();
                    }
                    individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.agreeWith, NLResourcesModel);
                    for (OWLIndividual individual : individuals) {
                        agreesWithID = individual.asOWLAnonymousIndividual().getID();
                    }
                    if (agreesWithID == null) {
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useCase, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.nominativeCase)) {
                                caseType = "nominative";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.genitiveCase)) {
                                caseType = "genitive";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.accusativeCase)) continue;
                            caseType = "accusative";
                        }
                        individuals = slot.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.useNumber, NLResourcesModel);
                        for (OWLIndividual individual : individuals) {
                            if (individual.equals(NLResourceManager.singularNumber)) {
                                number = "singular";
                                continue;
                            }
                            if (individual.equals(NLResourceManager.pluralNumber)) {
                                number = "plural";
                                continue;
                            }
                            if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                            number = "both";
                        }
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.isHead, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        isHead = literal.parseBoolean();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.isCapitalized, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        isCapitalized = literal.parseBoolean();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    NLNNounSlot NS = new NLNNounSlot(entryIRI, caseType, number, isHead, isCapitalized, agreesWithID, slot.asOWLAnonymousIndividual().getID(), order);
                    nlNameSlots.add(NS);
                    continue;
                }
                if (slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.StringSlot.getIRI())) {
                    text = "";
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasString, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        text = literal.getLiteral();
                    }
                    literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                    for (OWLLiteral literal : literals) {
                        order = literal.parseInteger();
                    }
                    NLNStringSlot SS = new NLNStringSlot(text, slot.asOWLAnonymousIndividual().getID(), order);
                    nlNameSlots.add(SS);
                    continue;
                }
                if (!slotType.asOWLClass().getIRI().equals((Object)NLResourceManager.PrepositionSlot.getIRI())) continue;
                text = "";
                literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasString, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    text = literal.getLiteral();
                }
                literals = slot.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasOrder, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    order = literal.parseInteger();
                }
                NLNPrepositionSlot PS = new NLNPrepositionSlot(text, slot.asOWLAnonymousIndividual().getID(), order);
                nlNameSlots.add(PS);
            }
        }
        return nlNameSlots;
    }

    public boolean getIsAggAllowed(IRI NLNameIRI, String language) {
        NLName name;
        if (Languages.isEnglish(language)) {
            NLName name2 = this.EnglishNLNameList.getNLName(NLNameIRI);
            if (name2 != null) {
                return name2.getAggAllowed();
            }
        } else if (Languages.isGreek(language) && (name = this.GreekNLNameList.getNLName(NLNameIRI)) != null) {
            return name.getAggAllowed();
        }
        return false;
    }

    public boolean getFocusLost(IRI NLNameIRI, String language) {
        NLName name;
        if (Languages.isEnglish(language)) {
            NLName name2 = this.EnglishNLNameList.getNLName(NLNameIRI);
            if (name2 != null) {
                return name2.getFocusLost();
            }
        } else if (Languages.isGreek(language) && (name = this.GreekNLNameList.getNLName(NLNameIRI)) != null) {
            return name.getFocusLost();
        }
        return false;
    }

    public NLResourceManager getNLResourcesManager() {
        return this.NLResourcesManager;
    }

    public NLNamesList getNLNamesList(String language) {
        if (Languages.isEnglish(language)) {
            return this.EnglishNLNameList;
        }
        if (Languages.isGreek(language)) {
            return this.GreekNLNameList;
        }
        return null;
    }

    public void duplicateNLNameInLists(IRI fromIRI, IRI toIRI, String toLanguage) {
        NLName fromName = null;
        if (this.EnglishNLNameList.containsNLName(fromIRI)) {
            fromName = this.EnglishNLNameList.getNLName(fromIRI);
        } else if (this.GreekNLNameList.containsNLName(fromIRI)) {
            fromName = this.GreekNLNameList.getNLName(fromIRI);
        }
        if (fromName != null) {
            ArrayList<NLNSlot> slots = new ArrayList<NLNSlot>();
            for (NLNSlot slot : fromName.getSlotsList()) {
                NLNSlot slotCopy;
                if (slot instanceof NLNArticleSlot) {
                    slotCopy = new NLNArticleSlot((NLNArticleSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNArticleSlot)slot).getOrder()).getID());
                    if (((NLNArticleSlot)slot).getAgreesWithID() != null) {
                        ((NLNArticleSlot)slotCopy).setAgreesWithID(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNArticleSlot)slot).getAgreesWithID().toString().substring(((NLNArticleSlot)slot).getAgreesWithID().toString().indexOf("slot") + "slot".length())).getID());
                    }
                    if (fromName.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((NLNArticleSlot)slotCopy).setCase("nominative");
                        ((NLNArticleSlot)slotCopy).setGender("masculineOrFeminine");
                    } else if (fromName.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((NLNArticleSlot)slotCopy).setCase("");
                        ((NLNArticleSlot)slotCopy).setGender("");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof NLNAdjectiveSlot) {
                    slotCopy = new NLNAdjectiveSlot((NLNAdjectiveSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNAdjectiveSlot)slot).getOrder()).getID());
                    if (((NLNAdjectiveSlot)slot).getAgreesWithID() != null) {
                        ((NLNAdjectiveSlot)slotCopy).setAgreesWithID(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNAdjectiveSlot)slot).getAgreesWithID().toString().substring(((NLNAdjectiveSlot)slot).getAgreesWithID().toString().indexOf("slot") + "slot".length())).getID());
                    }
                    if (fromName.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((NLNAdjectiveSlot)slotCopy).setCase("nominative");
                        ((NLNAdjectiveSlot)slotCopy).setGender("masculineOrFeminine");
                    } else if (fromName.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((NLNAdjectiveSlot)slotCopy).setCase("");
                        ((NLNAdjectiveSlot)slotCopy).setGender("");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof NLNNounSlot) {
                    slotCopy = new NLNNounSlot((NLNNounSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNNounSlot)slot).getOrder()).getID());
                    if (((NLNNounSlot)slot).getAgreesWithID() != null) {
                        ((NLNNounSlot)slotCopy).setAgreesWithID(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNNounSlot)slot).getAgreesWithID().toString().substring(((NLNNounSlot)slot).getAgreesWithID().toString().indexOf("slot") + "slot".length())).getID());
                    }
                    if (fromName.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((NLNNounSlot)slotCopy).setCase("nominative");
                    } else if (fromName.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((NLNNounSlot)slotCopy).setCase("");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (slot instanceof NLNPrepositionSlot) {
                    slotCopy = new NLNPrepositionSlot((NLNPrepositionSlot)slot);
                    slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNPrepositionSlot)slot).getOrder()).getID());
                    if (fromName.getLanguage().equals("en") && toLanguage.equals("el")) {
                        ((NLNPrepositionSlot)slotCopy).setPrep("\u03ac\u03bd\u03b5\u03c5");
                    } else if (fromName.getLanguage().equals("el") && toLanguage.equals("en")) {
                        ((NLNPrepositionSlot)slotCopy).setPrep("aboard");
                    }
                    slots.add(slotCopy);
                    continue;
                }
                if (!(slot instanceof NLNStringSlot)) continue;
                slotCopy = new NLNStringSlot((NLNStringSlot)slot);
                slotCopy.setId(this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(toIRI.getFragment()) + "_" + "slot" + ((NLNStringSlot)slot).getOrder()).getID());
                slots.add(slotCopy);
            }
            if (toLanguage.equals("en")) {
                this.EnglishNLNameList.add(new NLName(slots, toIRI, fromName.getAggAllowed(), fromName.getFocusLost(), "en"));
            } else if (toLanguage.equals("el")) {
                this.GreekNLNameList.add(new NLName(slots, toIRI, fromName.getAggAllowed(), fromName.getFocusLost(), "el"));
            }
        }
    }

    public NLName getNLName(IRI NLNameIRI, String language) {
        if (Languages.isEnglish(language)) {
            return this.EnglishNLNameList.getNLName(NLNameIRI);
        }
        if (Languages.isGreek(language)) {
            return this.GreekNLNameList.getNLName(NLNameIRI);
        }
        return null;
    }

    public NLName getNLName(IRI NLNameIRI) {
        if (this.EnglishNLNameList.containsNLName(NLNameIRI)) {
            return this.EnglishNLNameList.getNLName(NLNameIRI);
        }
        if (this.GreekNLNameList.containsNLName(NLNameIRI)) {
            return this.GreekNLNameList.getNLName(NLNameIRI);
        }
        return null;
    }

    public ArrayList<NLNSlot> getSlots(IRI NLNameIRI) {
        if (this.EnglishNLNameList.containsNLName(NLNameIRI)) {
            return this.EnglishNLNameList.getNLName(NLNameIRI).getSlotsList();
        }
        if (this.GreekNLNameList.containsNLName(NLNameIRI)) {
            return this.GreekNLNameList.getNLName(NLNameIRI).getSlotsList();
        }
        return null;
    }

    public void addNLName(IRI entryIRI, String lang) {
        ArrayList<NLNSlot> slots = new ArrayList<NLNSlot>();
        NLNArticleSlot AS = new NLNArticleSlot(false, "nominative", "masculine", "singular", null, this.getNLResourcesManager().getDataFactory().getOWLAnonymousIndividual(String.valueOf(entryIRI.getFragment()) + "_" + "slot" + 1).getID(), 1);
        slots.add(AS);
        if (Languages.isEnglish(lang)) {
            this.EnglishNLNameList.add(new NLName(slots, entryIRI, true, false, "en"));
        } else if (Languages.isGreek(lang)) {
            this.GreekNLNameList.add(new NLName(slots, entryIRI, true, false, "el"));
        }
    }

    public void addNLName(NLName name, String lang) {
        if (Languages.isEnglish(lang)) {
            this.EnglishNLNameList.add(name);
        } else if (Languages.isGreek(lang)) {
            this.GreekNLNameList.add(name);
        }
    }

    public void removeNLName(IRI entryIRI) {
        if (this.EnglishNLNameList.containsNLName(entryIRI)) {
            this.EnglishNLNameList.removeNLName(entryIRI);
        }
        if (this.GreekNLNameList.containsNLName(entryIRI)) {
            this.GreekNLNameList.removeNLName(entryIRI);
        }
    }

    public void exportNLNames(OWLOntology resourceOntology) {
        OWLDataFactory factory = this.NLResourcesManager.getDataFactory();
        ArrayList<NLName> nlNameMasterList = new ArrayList<NLName>();
        nlNameMasterList.addAll(this.EnglishNLNameList.getNLNamesList());
        nlNameMasterList.addAll(this.GreekNLNameList.getNLNamesList());
        for (NLName name : nlNameMasterList) {
            if (!DefaultResourcesManager.isDefaultResource(name.getNLNameIRI()) && name.getNLNameIRI().toString().startsWith(NLResourceManager.nlowlNS)) continue;
            IRI nlNameIRI = name.getNLNameIRI();
            OWLClass cls = NLResourceManager.NLName;
            OWLNamedIndividual indivPlan = factory.getOWLNamedIndividual(nlNameIRI);
            OWLClassAssertionAxiom classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indivPlan);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            OWLObjectProperty objectProperty = NLResourceManager.forLanguage;
            Object objectAssertion = null;
            if (Languages.isEnglish(name.getLanguage())) {
                objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)NLResourceManager.englishLanguage);
            } else if (Languages.isGreek(name.getLanguage())) {
                objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)NLResourceManager.greekLanguage);
            }
            AddAxiom addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            OWLDataProperty dataProperty = NLResourceManager.aggregationAllowed;
            OWLDataPropertyAssertionAxiom dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivPlan, name.getAggAllowed());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.focusLost;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)indivPlan, name.getFocusLost());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            ArrayList<NLNSlot> slots = name.getSlotsList();
            for (NLNSlot slot : slots) {
                OWLNamedIndividual indiv;
                OWLAnonymousIndividual anonym;
                OWLAnonymousIndividual anIndiv;
                if (slot instanceof NLNArticleSlot) {
                    cls = NLResourceManager.ArticleSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.isDefinite;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNArticleSlot)slot).isDefinite());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (((NLNArticleSlot)slot).getAgreesWithID() != null) {
                        objectProperty = NLResourceManager.agreeWith;
                        anonym = factory.getOWLAnonymousIndividual(((NLNArticleSlot)slot).getAgreesWithID().toString());
                        objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)anonym);
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    } else {
                        objectProperty = NLResourceManager.useCase;
                        objectAssertion = ((NLNArticleSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((NLNArticleSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((NLNArticleSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        objectProperty = NLResourceManager.useGender;
                        objectAssertion = ((NLNArticleSlot)slot).getGender().equals("masculine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.masculineGender) : (((NLNArticleSlot)slot).getGender().equals("feminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.feminineGender) : (((NLNArticleSlot)slot).getGender().equals("neuter") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.neuterGender) : (((NLNArticleSlot)slot).getGender().equals("masculineOrFeminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.masculineOrFeminineGender) : null)));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        objectProperty = NLResourceManager.useNumber;
                        objectAssertion = ((NLNArticleSlot)slot).getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.singularNumber) : (((NLNArticleSlot)slot).getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pluralNumber) : (((NLNArticleSlot)slot).getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.bothNumbers) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof NLNAdjectiveSlot) {
                    cls = NLResourceManager.AdjectiveSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useLexiconEntry;
                    indiv = factory.getOWLNamedIndividual(((NLNAdjectiveSlot)slot).getLexiconEntryIRI());
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.isHead;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNAdjectiveSlot)slot).isHead());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.isCapitalized;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNAdjectiveSlot)slot).isCapitalized());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (((NLNAdjectiveSlot)slot).getAgreesWithID() != null) {
                        objectProperty = NLResourceManager.agreeWith;
                        anonym = factory.getOWLAnonymousIndividual(((NLNAdjectiveSlot)slot).getAgreesWithID().toString());
                        objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)anonym);
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    } else {
                        objectProperty = NLResourceManager.useNumber;
                        objectAssertion = ((NLNAdjectiveSlot)slot).getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.singularNumber) : (((NLNAdjectiveSlot)slot).getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pluralNumber) : (((NLNAdjectiveSlot)slot).getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.bothNumbers) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        if (Languages.isGreek(name.getLanguage())) {
                            objectProperty = NLResourceManager.useCase;
                            objectAssertion = ((NLNAdjectiveSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((NLNAdjectiveSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((NLNAdjectiveSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                            if (objectAssertion != null) {
                                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                            }
                            objectProperty = NLResourceManager.useGender;
                            objectAssertion = ((NLNAdjectiveSlot)slot).getGender().equals("masculine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.masculineGender) : (((NLNAdjectiveSlot)slot).getGender().equals("feminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.feminineGender) : (((NLNAdjectiveSlot)slot).getGender().equals("neuter") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.neuterGender) : (((NLNAdjectiveSlot)slot).getGender().equals("masculineOrFeminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.masculineOrFeminineGender) : null)));
                            if (objectAssertion != null) {
                                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                            }
                        }
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof NLNNounSlot) {
                    cls = NLResourceManager.NounSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    objectProperty = NLResourceManager.useLexiconEntry;
                    indiv = factory.getOWLNamedIndividual(((NLNNounSlot)slot).getLexiconEntryIRI());
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)indiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.isHead;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNNounSlot)slot).isHead());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.isCapitalized;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNNounSlot)slot).isCapitalized());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    if (((NLNNounSlot)slot).getAgreesWithID() != null) {
                        objectProperty = NLResourceManager.agreeWith;
                        anonym = factory.getOWLAnonymousIndividual(((NLNNounSlot)slot).getAgreesWithID().toString());
                        objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)anonym);
                        addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                        this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    } else {
                        objectProperty = NLResourceManager.useNumber;
                        objectAssertion = ((NLNNounSlot)slot).getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.singularNumber) : (((NLNNounSlot)slot).getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.pluralNumber) : (((NLNNounSlot)slot).getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.bothNumbers) : null));
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        if (objectAssertion != null) {
                            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                        }
                        if (Languages.isGreek(name.getLanguage())) {
                            objectProperty = NLResourceManager.useCase;
                            objectAssertion = ((NLNNounSlot)slot).getCase().equals("nominative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.nominativeCase) : (((NLNNounSlot)slot).getCase().equals("genitive") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.genitiveCase) : (((NLNNounSlot)slot).getCase().equals("accusative") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)anIndiv, (OWLIndividual)NLResourceManager.accusativeCase) : null));
                            if (objectAssertion != null) {
                                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                            }
                        }
                    }
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (slot instanceof NLNStringSlot) {
                    cls = NLResourceManager.StringSlot;
                    anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                    classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                    this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                    objectProperty = NLResourceManager.hasSlot;
                    objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasString;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNStringSlot)slot).getText());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    dataProperty = NLResourceManager.hasOrder;
                    dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                    addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                    this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                    continue;
                }
                if (!(slot instanceof NLNPrepositionSlot)) continue;
                cls = NLResourceManager.PrepositionSlot;
                anIndiv = factory.getOWLAnonymousIndividual(slot.getId().toString());
                classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)anIndiv);
                this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
                objectProperty = NLResourceManager.hasSlot;
                objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indivPlan, (OWLIndividual)anIndiv);
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasString;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, ((NLNPrepositionSlot)slot).getPrep());
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasOrder;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)anIndiv, slot.getOrder());
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
        }
    }
}

