/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.Comparisons.Comparison;
import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLNameQueryManager;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLFiles.SentencePlanQueryManager;
import gr.aueb.cs.nlg.NLGEngine.SurfaceRealization;
import gr.aueb.cs.nlg.Utils.NLGUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class MappingQueryManager {
    private boolean useNLNames = true;
    private boolean useSentencePlans = true;
    private HashMap<IRI, HashSet<IRI>> sentencePlanMappings;
    private HashMap<IRI, HashSet<IRI>> NLNameMappings;
    private HashMap<IRI, Boolean> propertyComparisonsAllowed;
    private HashSet<OWLOntology> mainModels = new HashSet();
    NLResourceManager NLResourcesManager;

    public MappingQueryManager(NLResourceManager NLResourcesManager) {
        this.NLResourcesManager = NLResourcesManager;
        this.init();
    }

    public final void init() {
        this.sentencePlanMappings = new HashMap();
        this.NLNameMappings = new HashMap();
        this.propertyComparisonsAllowed = new HashMap();
    }

    public IRI chooseSentencePlan(IRI propertyIRI, SentencePlanQueryManager SPQM, String language) {
        Iterator<OWLOntology> iterator;
        if (this.useSentencePlans) {
            HashSet<IRI> sentencePlans = new HashSet<IRI>();
            HashSet<IRI> candSentencePlans = this.sentencePlanMappings.get(propertyIRI);
            if (candSentencePlans != null) {
                for (IRI plan : candSentencePlans) {
                    if (SPQM.getSentencePlan(plan) == null) continue;
                    sentencePlans.add(plan);
                }
            }
            ArrayList<IRI> availableSentencePlans = new ArrayList<IRI>();
            if (!sentencePlans.isEmpty()) {
                for (IRI sentencePlanIRI : sentencePlans) {
                    if (SPQM.getSentencePlan(sentencePlanIRI, language) == null) continue;
                    availableSentencePlans.add(sentencePlanIRI);
                }
                if (!availableSentencePlans.isEmpty()) {
                    int index = (int)Math.floor(Math.random() * (double)availableSentencePlans.size());
                    return (IRI)availableSentencePlans.get(index);
                }
            }
        }
        if ((iterator = this.getContainingOntologies(propertyIRI).iterator()).hasNext()) {
            OWLOntology mainModel = iterator.next();
            SentencePlan defaultPlan = DefaultResourcesManager.generateDefaultSentencePlanForProperty(propertyIRI, mainModel, language);
            SPQM.addSentencePlan(defaultPlan, language);
            return defaultPlan.getSentencePlanIRI();
        }
        return null;
    }

    public IRI chooseSentencePlan(IRI propertyIRI, SentencePlanQueryManager SPQM, String language, NLGUser user) {
        if (user != null) {
            Iterator<OWLOntology> iterator;
            if (this.useSentencePlans) {
                HashSet<IRI> sentencePlans = new HashSet<IRI>();
                HashSet<IRI> candSentencePlans = this.sentencePlanMappings.get(propertyIRI);
                if (candSentencePlans != null) {
                    for (IRI plan : candSentencePlans) {
                        if (SPQM.getSentencePlan(plan) == null) continue;
                        sentencePlans.add(plan);
                    }
                }
                HashMap<IRI, Float> sentencePlanScores = new HashMap<IRI, Float>();
                if (!sentencePlans.isEmpty()) {
                    for (IRI sentencePlanIRI : sentencePlans) {
                        if (SPQM.getSentencePlan(sentencePlanIRI, language) == null) continue;
                        float score = (1.0f + (float)user.getUserModel().getSentencePlanAppropriateness(sentencePlanIRI)) / (1.0f + (float)user.getSentencePlanUseCount(sentencePlanIRI));
                        sentencePlanScores.put(sentencePlanIRI, Float.valueOf(score));
                    }
                    if (!sentencePlanScores.isEmpty()) {
                        IRI bestPlanIRI = null;
                        float max_score = 0.0f;
                        for (IRI sentencePlanIRI : sentencePlanScores.keySet()) {
                            if (!(((Float)sentencePlanScores.get(sentencePlanIRI)).floatValue() >= max_score)) continue;
                            max_score = ((Float)sentencePlanScores.get(sentencePlanIRI)).floatValue();
                            bestPlanIRI = sentencePlanIRI;
                        }
                        return bestPlanIRI;
                    }
                }
            }
            if ((iterator = this.getContainingOntologies(propertyIRI).iterator()).hasNext()) {
                OWLOntology mainModel = iterator.next();
                SentencePlan defaultPlan = DefaultResourcesManager.generateDefaultSentencePlanForProperty(propertyIRI, mainModel, language);
                SPQM.addSentencePlan(defaultPlan, language);
                return defaultPlan.getSentencePlanIRI();
            }
            return null;
        }
        return this.chooseSentencePlan(propertyIRI, SPQM, language);
    }

    public IRI chooseComparisonSentencePlan(IRI sentencePlanIRI, SentencePlanQueryManager SPQM, String language, Comparison comparison, String gen, String number, SurfaceRealization SR, IRI NLNameCompIRI) {
        IRI compSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + sentencePlanIRI.getFragment() + "-" + comparison.getType() + "_" + comparison.getValueIRI().getFragment() + "_" + language));
        SentencePlan sentencePlan = SPQM.getSentencePlan(compSPEN_IRI);
        if (sentencePlan != null) {
            return sentencePlan.getSentencePlanIRI();
        }
        sentencePlan = SPQM.getSentencePlan(sentencePlanIRI);
        if (sentencePlan != null) {
            SentencePlan compPlan = DefaultResourcesManager.generateSentencePlanForComparison(sentencePlan, comparison);
            SPQM.addSentencePlan(compPlan, language);
            return compPlan.getSentencePlanIRI();
        }
        return null;
    }

    public IRI chooseUniqueSentencePlan(IRI sentencePlanIRI, SentencePlanQueryManager SPQM, String language) {
        IRI uniqueSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + sentencePlanIRI.getFragment() + "-" + "UNIQUE" + "SP" + language));
        SentencePlan sentencePlan = SPQM.getSentencePlan(uniqueSPEN_IRI);
        if (sentencePlan != null) {
            return sentencePlan.getSentencePlanIRI();
        }
        sentencePlan = SPQM.getSentencePlan(sentencePlanIRI);
        if (sentencePlan != null) {
            SentencePlan uniquePlan = DefaultResourcesManager.generateSentencePlanForUniqueComparison(sentencePlan);
            SPQM.addSentencePlan(uniquePlan, language);
            return uniquePlan.getSentencePlanIRI();
        }
        return null;
    }

    public IRI chooseNLName(IRI indivOrClassIRI, NLNameQueryManager NLNQM, String language) {
        Iterator<OWLOntology> iterator;
        if (this.useNLNames) {
            HashSet<IRI> NLNames = new HashSet<IRI>();
            HashSet<IRI> candNLNames = this.NLNameMappings.get(indivOrClassIRI);
            if (candNLNames != null) {
                for (IRI name : candNLNames) {
                    if (NLNQM.getNLName(name) == null) continue;
                    NLNames.add(name);
                }
            }
            ArrayList<IRI> availableNLNames = new ArrayList<IRI>();
            if (!NLNames.isEmpty()) {
                for (IRI NLNameIRI : NLNames) {
                    if (NLNQM.getNLName(NLNameIRI, language) == null) continue;
                    availableNLNames.add(NLNameIRI);
                }
                if (!availableNLNames.isEmpty()) {
                    int index = (int)Math.floor(1.0 + Math.random() * (double)availableNLNames.size());
                    return (IRI)availableNLNames.get(index);
                }
            }
            if (indivOrClassIRI.isThing()) {
                if (Languages.isEnglish(language)) {
                    return DefaultResourcesManager.entityNLNEN_IRI;
                }
                if (Languages.isGreek(language)) {
                    return DefaultResourcesManager.entityNLNGR_IRI;
                }
            }
        }
        if ((iterator = this.getContainingOntologies(indivOrClassIRI).iterator()).hasNext()) {
            OWLOntology mainModel = iterator.next();
            NLName defaultName = DefaultResourcesManager.generateDefaultNLNameForIndividual(indivOrClassIRI, mainModel, language);
            NLNQM.addNLName(defaultName, language);
            return defaultName.getNLNameIRI();
        }
        return null;
    }

    public IRI chooseNLName(IRI indivOrClassIRI, NLNameQueryManager NLNQM, String language, NLGUser user) {
        if (user != null) {
            Iterator<OWLOntology> iterator;
            if (this.useNLNames) {
                HashSet<IRI> NLNames = new HashSet<IRI>();
                HashSet<IRI> candNLNames = this.NLNameMappings.get(indivOrClassIRI);
                if (candNLNames != null) {
                    for (IRI name : candNLNames) {
                        if (NLNQM.getNLName(name) == null && !name.equals((Object)NLResourceManager.anonymous.getIRI())) continue;
                        NLNames.add(name);
                    }
                }
                HashMap<IRI, Float> NLNameScores = new HashMap<IRI, Float>();
                if (!NLNames.isEmpty()) {
                    for (IRI NLNameIRI : NLNames) {
                        if (NLNameIRI.equals((Object)NLResourceManager.anonymous.getIRI())) {
                            return NLNameIRI;
                        }
                        if (NLNQM.getNLName(NLNameIRI, language) == null) continue;
                        float score = (1.0f + (float)user.getUserModel().getNLNameAppropriateness(NLNameIRI)) / (1.0f + (float)user.getNLNameUseCount(NLNameIRI));
                        NLNameScores.put(NLNameIRI, Float.valueOf(score));
                    }
                    if (!NLNameScores.isEmpty()) {
                        IRI bestNameIRI = null;
                        float max_score = 0.0f;
                        for (IRI NLNameIRI : NLNameScores.keySet()) {
                            if (!(((Float)NLNameScores.get(NLNameIRI)).floatValue() >= max_score)) continue;
                            max_score = ((Float)NLNameScores.get(NLNameIRI)).floatValue();
                            bestNameIRI = NLNameIRI;
                        }
                        return bestNameIRI;
                    }
                }
                if (indivOrClassIRI.isThing()) {
                    if (Languages.isEnglish(language)) {
                        return DefaultResourcesManager.entityNLNEN_IRI;
                    }
                    if (Languages.isGreek(language)) {
                        return DefaultResourcesManager.entityNLNGR_IRI;
                    }
                }
            }
            if ((iterator = this.getContainingOntologies(indivOrClassIRI).iterator()).hasNext()) {
                OWLOntology mainModel = iterator.next();
                NLName defaultName = DefaultResourcesManager.generateDefaultNLNameForIndividual(indivOrClassIRI, mainModel, language);
                NLNQM.addNLName(defaultName, language);
                return defaultName.getNLNameIRI();
            }
            return null;
        }
        return this.chooseNLName(indivOrClassIRI, NLNQM, language);
    }

    public IRI chooseDefaultNLName(IRI indivOrClassIRI, NLNameQueryManager NLNQM, String language) {
        Iterator<OWLOntology> iterator = this.getContainingOntologies(indivOrClassIRI).iterator();
        if (iterator.hasNext()) {
            OWLOntology mainModel = iterator.next();
            NLName defaultName = DefaultResourcesManager.generateDefaultNLNameForIndividual(indivOrClassIRI, mainModel, language);
            NLNQM.addNLName(defaultName, language);
            return defaultName.getNLNameIRI();
        }
        return null;
    }

    public IRI chooseComparisonNLName(IRI NLNameIRI, NLNameQueryManager NLNQM, String language, Comparison comparison, boolean entityMentioned) {
        IRI compIRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + NLNameIRI.getFragment() + "-CompNLN" + "_" + comparison.getType() + language));
        NLName name = NLNQM.getNLName(compIRI);
        if (name != null) {
            return name.getNLNameIRI();
        }
        name = NLNQM.getNLName(NLNameIRI);
        if (name != null) {
            name = DefaultResourcesManager.generateNLNameForComparison(name, comparison, entityMentioned);
            NLNQM.addNLName(name, language);
            return name.getNLNameIRI();
        }
        return null;
    }

    public ArrayList<IRI> chooseUniqueNLName(ArrayList<IRI> NLNameIRIs, NLNameQueryManager NLNQM, String language) {
        ArrayList<IRI> iris = new ArrayList<IRI>();
        for (IRI NLNameIRI : NLNameIRIs) {
            IRI uniqueNLNEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + NLNameIRI.getFragment() + "-" + "UNIQUE" + "NLN" + language));
            NLName name = NLNQM.getNLName(uniqueNLNEN_IRI);
            if (name != null) {
                iris.add(name.getNLNameIRI());
                continue;
            }
            name = NLNQM.getNLName(NLNameIRI);
            if (name == null) continue;
            NLName uniqueName = DefaultResourcesManager.generateNLNameForUniqueComparison(name);
            NLNQM.addNLName(uniqueName, language);
            iris.add(uniqueName.getNLNameIRI());
        }
        return iris;
    }

    public IRI getDefaultNLName(IRI indivOrClassIRI, NLNameQueryManager NLNQM, String language) {
        Iterator<OWLOntology> iterator = this.getContainingOntologies(indivOrClassIRI).iterator();
        if (iterator.hasNext()) {
            OWLOntology mainModel = iterator.next();
            NLName defaultName = DefaultResourcesManager.generateDefaultNLNameForIndividual(indivOrClassIRI, mainModel, language);
            NLNQM.addNLName(defaultName, language);
            return defaultName.getNLNameIRI();
        }
        return null;
    }

    public void addSentencePlanMapping(IRI propertyIRI, IRI sentencePlanIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(propertyIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sentencePlanIRI);
            AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
        if (this.sentencePlanMappings.containsKey(propertyIRI)) {
            this.sentencePlanMappings.get(propertyIRI).add(sentencePlanIRI);
        } else {
            HashSet<IRI> sentencePlanIRIs = new HashSet<IRI>();
            sentencePlanIRIs.add(sentencePlanIRI);
            this.sentencePlanMappings.put(propertyIRI, sentencePlanIRIs);
        }
    }

    public void addNLNameMapping(IRI indivOrClassIRI, IRI NLNameIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(indivOrClassIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)indivOrClassIRI, (OWLAnnotationValue)NLNameIRI);
            AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
        if (this.NLNameMappings.containsKey(indivOrClassIRI)) {
            this.NLNameMappings.get(indivOrClassIRI).add(NLNameIRI);
        } else {
            HashSet<IRI> NLNameIRIs = new HashSet<IRI>();
            NLNameIRIs.add(NLNameIRI);
            this.NLNameMappings.put(indivOrClassIRI, NLNameIRIs);
        }
    }

    public void setComparisonsAllowed(IRI propertyIRI, boolean allowed) {
        for (OWLOntology mainModel : this.getContainingOntologies(propertyIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion;
            if (allowed) {
                annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.comparisonsAllowed, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(allowed));
                AddAxiom addAxiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                continue;
            }
            annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.comparisonsAllowed, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(!allowed));
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        this.propertyComparisonsAllowed.put(propertyIRI, allowed);
    }

    public void removeSentencePlanMapping(IRI propertyIRI, IRI sentencePlanIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(propertyIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sentencePlanIRI);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        if (this.sentencePlanMappings.containsKey(propertyIRI)) {
            this.sentencePlanMappings.get(propertyIRI).remove(sentencePlanIRI);
        }
    }

    public void removeNLNameMapping(IRI indivOrClassIRI, IRI NLNameIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(indivOrClassIRI)) {
            OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)indivOrClassIRI, (OWLAnnotationValue)NLNameIRI);
            RemoveAxiom removeAxiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)removeAxiomChange);
        }
        if (this.NLNameMappings.containsKey(indivOrClassIRI)) {
            this.NLNameMappings.get(indivOrClassIRI).remove(NLNameIRI);
        }
    }

    public void renameClass(IRI oldClassIRI, IRI newClassIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(oldClassIRI)) {
            if (!this.NLNameMappings.containsKey(oldClassIRI)) continue;
            HashSet<IRI> NLNameIRIs = this.NLNameMappings.get(oldClassIRI);
            this.NLNameMappings.remove(oldClassIRI);
            this.NLNameMappings.put(newClassIRI, NLNameIRIs);
            for (IRI NLNameIRI : NLNameIRIs) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)oldClassIRI, (OWLAnnotationValue)NLNameIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)newClassIRI, (OWLAnnotationValue)NLNameIRI);
                axiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void renameInstance(IRI oldInstanceIRI, IRI newInstanceIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(oldInstanceIRI)) {
            if (!this.NLNameMappings.containsKey(oldInstanceIRI)) continue;
            HashSet<IRI> NLNameIRIs = this.NLNameMappings.get(oldInstanceIRI);
            this.NLNameMappings.remove(oldInstanceIRI);
            this.NLNameMappings.put(newInstanceIRI, NLNameIRIs);
            for (IRI NLNameIRI : NLNameIRIs) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)oldInstanceIRI, (OWLAnnotationValue)NLNameIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)newInstanceIRI, (OWLAnnotationValue)NLNameIRI);
                axiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void renameProperty(IRI oldPropertyIRI, IRI newPropertyIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(oldPropertyIRI)) {
            if (this.sentencePlanMappings.containsKey(oldPropertyIRI)) {
                HashSet<IRI> sentencePlanIRIs = this.sentencePlanMappings.get(oldPropertyIRI);
                this.sentencePlanMappings.remove(oldPropertyIRI);
                this.sentencePlanMappings.put(newPropertyIRI, sentencePlanIRIs);
                for (IRI sentencePlanIRI : sentencePlanIRIs) {
                    OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)oldPropertyIRI, (OWLAnnotationValue)sentencePlanIRI);
                    RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                    annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)newPropertyIRI, (OWLAnnotationValue)sentencePlanIRI);
                    axiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                }
            }
            if (!this.propertyComparisonsAllowed.containsKey(oldPropertyIRI)) continue;
            boolean allowed = this.propertyComparisonsAllowed.get(oldPropertyIRI);
            OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.comparisonsAllowed, (OWLAnnotationSubject)newPropertyIRI, (OWLAnnotationValue)mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(allowed));
            AddAxiom axiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.comparisonsAllowed, (OWLAnnotationSubject)oldPropertyIRI, (OWLAnnotationValue)mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(allowed));
            axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
    }

    public void renameNLName(IRI oldNLNameIRI, IRI newNLNameIRI) {
        for (IRI indivOrClassIRI : this.NLNameMappings.keySet()) {
            HashSet<IRI> NLNameIRIs = this.NLNameMappings.get(indivOrClassIRI);
            if (!NLNameIRIs.contains(oldNLNameIRI)) continue;
            NLNameIRIs.remove(oldNLNameIRI);
            NLNameIRIs.add(newNLNameIRI);
            for (OWLOntology mainModel : this.getContainingOntologies(indivOrClassIRI)) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)indivOrClassIRI, (OWLAnnotationValue)oldNLNameIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)indivOrClassIRI, (OWLAnnotationValue)newNLNameIRI);
                axiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void renameSentencePlan(IRI oldSentencePlanIRI, IRI newSentencePlanIRI) {
        for (IRI propertyIRI : this.sentencePlanMappings.keySet()) {
            HashSet<IRI> sentencePlanIRIs = this.sentencePlanMappings.get(propertyIRI);
            if (!sentencePlanIRIs.contains(oldSentencePlanIRI)) continue;
            sentencePlanIRIs.remove(oldSentencePlanIRI);
            sentencePlanIRIs.add(newSentencePlanIRI);
            for (OWLOntology mainModel : this.getContainingOntologies(propertyIRI)) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)oldSentencePlanIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)newSentencePlanIRI);
                axiomChange = new AddAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void deleteClass(IRI classIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(classIRI)) {
            if (!this.NLNameMappings.containsKey(classIRI)) continue;
            HashSet<IRI> NLNamesIRIs = this.NLNameMappings.get(classIRI);
            this.NLNameMappings.remove(classIRI);
            for (IRI NLName2 : NLNamesIRIs) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)classIRI, (OWLAnnotationValue)NLName2);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void deleteInstance(IRI instanceIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(instanceIRI)) {
            if (!this.NLNameMappings.containsKey(instanceIRI)) continue;
            HashSet<IRI> NLNamesIRIs = this.NLNameMappings.get(instanceIRI);
            this.NLNameMappings.remove(instanceIRI);
            for (IRI NLName2 : NLNamesIRIs) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)instanceIRI, (OWLAnnotationValue)NLName2);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void deleteProperty(IRI propertyIRI) {
        for (OWLOntology mainModel : this.getContainingOntologies(propertyIRI)) {
            if (this.sentencePlanMappings.containsKey(propertyIRI)) {
                HashSet<IRI> sentencePlanIRIs = this.sentencePlanMappings.get(propertyIRI);
                this.sentencePlanMappings.remove(propertyIRI);
                for (IRI sentencePlanIRI : sentencePlanIRIs) {
                    OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sentencePlanIRI);
                    RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                    mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
                }
            }
            if (!this.propertyComparisonsAllowed.containsKey(propertyIRI)) continue;
            boolean allowed = this.propertyComparisonsAllowed.get(propertyIRI);
            OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.comparisonsAllowed, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLLiteral(allowed));
            RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
            mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
        }
    }

    public void deleteNLName(IRI NLNameIRI) {
        for (IRI indivOrClassIRI : this.NLNameMappings.keySet()) {
            HashSet<IRI> NLNameIRIs = this.NLNameMappings.get(indivOrClassIRI);
            if (!NLNameIRIs.contains(NLNameIRI)) continue;
            NLNameIRIs.remove(NLNameIRI);
            for (OWLOntology mainModel : this.getContainingOntologies(indivOrClassIRI)) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasNLName, (OWLAnnotationSubject)indivOrClassIRI, (OWLAnnotationValue)NLNameIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void deleteSentencePlan(IRI sentencePlanIRI) {
        for (IRI propertyIRI : this.sentencePlanMappings.keySet()) {
            HashSet<IRI> sentencePlanIRIs = this.sentencePlanMappings.get(propertyIRI);
            if (!sentencePlanIRIs.contains(sentencePlanIRI)) continue;
            sentencePlanIRIs.remove(sentencePlanIRI);
            for (OWLOntology mainModel : this.getContainingOntologies(propertyIRI)) {
                OWLAnnotationAssertionAxiom annotationAssertion = mainModel.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationAssertionAxiom(NLResourceManager.hasSentencePlan, (OWLAnnotationSubject)propertyIRI, (OWLAnnotationValue)sentencePlanIRI);
                RemoveAxiom axiomChange = new RemoveAxiom(mainModel, (OWLAxiom)annotationAssertion);
                mainModel.getOWLOntologyManager().applyChange((OWLOntologyChange)axiomChange);
            }
        }
    }

    public void importMappings(OWLOntology mainModel) {
        HashSet<IRI> sentencePlanIRIs;
        IRI propertyIRI;
        HashSet<IRI> NLNameIRIs;
        IRI NLNameIRI;
        IRI indivOrClassIRI;
        this.mainModels.add(mainModel);
        for (OWLNamedIndividual individual : mainModel.getIndividualsInSignature(true)) {
            for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)individual.getIRI())) {
                if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.hasNLName) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
                indivOrClassIRI = (IRI)annotation.getSubject();
                NLNameIRI = (IRI)annotation.getAnnotation().getValue();
                if (this.NLNameMappings.containsKey(indivOrClassIRI)) {
                    this.NLNameMappings.get(indivOrClassIRI).add(NLNameIRI);
                    continue;
                }
                NLNameIRIs = new HashSet<IRI>();
                NLNameIRIs.add(NLNameIRI);
                this.NLNameMappings.put(indivOrClassIRI, NLNameIRIs);
            }
        }
        for (OWLClass owlClass : mainModel.getClassesInSignature(true)) {
            for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)owlClass.getIRI())) {
                if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.hasNLName) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof IRI)) continue;
                indivOrClassIRI = (IRI)annotation.getSubject();
                NLNameIRI = (IRI)annotation.getAnnotation().getValue();
                if (this.NLNameMappings.containsKey(indivOrClassIRI)) {
                    this.NLNameMappings.get(indivOrClassIRI).add(NLNameIRI);
                    continue;
                }
                NLNameIRIs = new HashSet();
                NLNameIRIs.add(NLNameIRI);
                this.NLNameMappings.put(indivOrClassIRI, NLNameIRIs);
            }
        }
        for (OWLDataProperty dataProperty : mainModel.getDataPropertiesInSignature(true)) {
            for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)dataProperty.getIRI())) {
                if (annotation.getAnnotation().getProperty().equals(NLResourceManager.hasSentencePlan) && annotation.getSubject() instanceof IRI && annotation.getAnnotation().getValue() instanceof IRI) {
                    propertyIRI = (IRI)annotation.getSubject();
                    IRI sentencePlanIRI = (IRI)annotation.getAnnotation().getValue();
                    if (this.sentencePlanMappings.containsKey(propertyIRI)) {
                        this.sentencePlanMappings.get(propertyIRI).add(sentencePlanIRI);
                    } else {
                        sentencePlanIRIs = new HashSet<IRI>();
                        sentencePlanIRIs.add(sentencePlanIRI);
                        this.sentencePlanMappings.put(propertyIRI, sentencePlanIRIs);
                    }
                }
                if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.comparisonsAllowed) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral) || !((OWLLiteral)annotation.getAnnotation().getValue()).isBoolean()) continue;
                propertyIRI = (IRI)annotation.getSubject();
                boolean allowed = ((OWLLiteral)annotation.getAnnotation().getValue()).parseBoolean();
                this.propertyComparisonsAllowed.put(propertyIRI, allowed);
            }
        }
        for (OWLObjectProperty objectProperty : mainModel.getObjectPropertiesInSignature(true)) {
            for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)objectProperty.getIRI())) {
                if (annotation.getAnnotation().getProperty().equals(NLResourceManager.hasSentencePlan) && annotation.getSubject() instanceof IRI && annotation.getAnnotation().getValue() instanceof IRI) {
                    propertyIRI = (IRI)annotation.getSubject();
                    IRI sentencePlanIRI = (IRI)annotation.getAnnotation().getValue();
                    if (this.sentencePlanMappings.containsKey(propertyIRI)) {
                        this.sentencePlanMappings.get(propertyIRI).add(sentencePlanIRI);
                    } else {
                        sentencePlanIRIs = new HashSet();
                        sentencePlanIRIs.add(sentencePlanIRI);
                        this.sentencePlanMappings.put(propertyIRI, sentencePlanIRIs);
                    }
                }
                if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.comparisonsAllowed) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral) || !((OWLLiteral)annotation.getAnnotation().getValue()).isBoolean()) continue;
                propertyIRI = (IRI)annotation.getSubject();
                boolean allowed = ((OWLLiteral)annotation.getAnnotation().getValue()).parseBoolean();
                this.propertyComparisonsAllowed.put(propertyIRI, allowed);
            }
        }
        for (OWLAnnotationAssertionAxiom annotation : mainModel.getAnnotationAssertionAxioms((OWLAnnotationSubject)NLResourceManager.isA.getIRI())) {
            if (!annotation.getAnnotation().getProperty().equals(NLResourceManager.comparisonsAllowed) || !(annotation.getSubject() instanceof IRI) || !(annotation.getAnnotation().getValue() instanceof OWLLiteral) || !((OWLLiteral)annotation.getAnnotation().getValue()).isBoolean()) continue;
            boolean allowed = ((OWLLiteral)annotation.getAnnotation().getValue()).parseBoolean();
            this.propertyComparisonsAllowed.put(NLResourceManager.isA.getIRI(), allowed);
        }
    }

    public HashSet<IRI> getSentencePlansSet(SentencePlanQueryManager SPQM, IRI propertyIRI) {
        HashSet<IRI> sentencePlans = new HashSet<IRI>();
        HashSet<IRI> candSentencePlans = this.sentencePlanMappings.get(propertyIRI);
        if (candSentencePlans != null) {
            for (IRI plan : candSentencePlans) {
                if (SPQM.getSentencePlan(plan) == null) continue;
                sentencePlans.add(plan);
            }
        }
        return sentencePlans;
    }

    public HashSet<IRI> getNLNamesSet(NLNameQueryManager NLNQM, IRI indivOrClassIRI) {
        HashSet<IRI> NLNames = new HashSet<IRI>();
        HashSet<IRI> candNLNames = this.NLNameMappings.get(indivOrClassIRI);
        if (candNLNames != null) {
            for (IRI name : candNLNames) {
                if (NLNQM.getNLName(name) == null) continue;
                NLNames.add(name);
            }
        }
        return NLNames;
    }

    public HashSet<IRI> getPropertiesSet(IRI sentencePlanIRI) {
        HashSet<IRI> propertiesSet = new HashSet<IRI>();
        for (IRI propertyIRI : this.sentencePlanMappings.keySet()) {
            if (!this.sentencePlanMappings.get(propertyIRI).contains(sentencePlanIRI)) continue;
            propertiesSet.add(propertyIRI);
        }
        return propertiesSet;
    }

    public HashSet<IRI> getPropertiesThatAllowComparisons() {
        HashSet<IRI> propertiesSet = new HashSet<IRI>();
        for (OWLOntology model : this.mainModels) {
            for (OWLDataProperty dataProperty : model.getDataPropertiesInSignature(true)) {
                if (!this.propertyComparisonsAllowed.containsKey(dataProperty.getIRI())) continue;
                propertiesSet.add(dataProperty.getIRI());
            }
            for (OWLObjectProperty objectProperty : model.getObjectPropertiesInSignature(true)) {
                if (!this.propertyComparisonsAllowed.containsKey(objectProperty.getIRI())) continue;
                propertiesSet.add(objectProperty.getIRI());
            }
        }
        if (this.propertyComparisonsAllowed.containsKey(NLResourceManager.isA.getIRI())) {
            propertiesSet.add(NLResourceManager.isA.getIRI());
        }
        return propertiesSet;
    }

    public Set<IRI> getPropertiesSet() {
        return this.sentencePlanMappings.keySet();
    }

    public HashSet<IRI> getIndividualOrClassSet(IRI NLNameIRI) {
        HashSet<IRI> individualOrClassSet = new HashSet<IRI>();
        for (IRI individualOrClasIRI : this.NLNameMappings.keySet()) {
            if (!this.NLNameMappings.get(individualOrClasIRI).contains(NLNameIRI)) continue;
            individualOrClassSet.add(individualOrClasIRI);
        }
        return individualOrClassSet;
    }

    public Set<IRI> getIndividualOrClassSet() {
        return this.NLNameMappings.keySet();
    }

    public boolean areComparisonsAllowed(IRI propertyIRI) {
        if (this.propertyComparisonsAllowed.containsKey(propertyIRI)) {
            return this.propertyComparisonsAllowed.get(propertyIRI);
        }
        return false;
    }

    public HashSet<OWLOntology> getContainingOntologies(IRI entryIRI) {
        HashSet<OWLOntology> containingOntologies = new HashSet<OWLOntology>();
        for (OWLOntology model : this.mainModels) {
            if (entryIRI.equals((Object)NLResourceManager.isA.getIRI())) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsObjectPropertyInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsDataPropertyInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsClassInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (model.containsEntityInSignature(entryIRI, true)) {
                containingOntologies.add(model);
                continue;
            }
            if (!model.containsIndividualInSignature(entryIRI, true)) continue;
            containingOntologies.add(model);
        }
        return containingOntologies;
    }

    public boolean isUseNLNames() {
        return this.useNLNames;
    }

    public void setUseNLNames(boolean useNLNames) {
        this.useNLNames = useNLNames;
    }

    public boolean isUseSentencePlans() {
        return this.useSentencePlans;
    }

    public void setUseSentencePlans(boolean useSentencePlans) {
        this.useSentencePlans = useSentencePlans;
    }
}

