/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.NLFiles.AdjectiveEntryList;
import gr.aueb.cs.nlg.NLFiles.DefaultResourcesManager;
import gr.aueb.cs.nlg.NLFiles.EntryList;
import gr.aueb.cs.nlg.NLFiles.LexEntry;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjective;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryNoun;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerb;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbGR;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.NounEntryList;
import gr.aueb.cs.nlg.NLFiles.VerbEntryList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class LexiconQueryManager {
    private HashMap<IRI, NounEntryList> lexiconNouns;
    private HashMap<IRI, VerbEntryList> lexiconVerbs;
    private HashMap<IRI, AdjectiveEntryList> lexiconAdjectives;
    private NLResourceManager NLResourcesManager;

    public NLResourceManager getNLResourcesManager() {
        return this.NLResourcesManager;
    }

    public LexiconQueryManager(NLResourceManager NLResourcesManager) {
        this.NLResourcesManager = NLResourcesManager;
        this.init();
    }

    private void init() {
        this.lexiconNouns = new HashMap();
        this.lexiconVerbs = new HashMap();
        this.lexiconAdjectives = new HashMap();
        HashMap<IRI, NounEntryList> defaultLexiconNouns = DefaultResourcesManager.generateDefaultNouns();
        for (IRI nounIRI : defaultLexiconNouns.keySet()) {
            this.lexiconNouns.put(nounIRI, defaultLexiconNouns.get(nounIRI));
        }
        HashMap<IRI, VerbEntryList> defaultLexiconVerbs = DefaultResourcesManager.generateDefaultVerbs();
        for (IRI verbIRI : defaultLexiconVerbs.keySet()) {
            this.lexiconVerbs.put(verbIRI, defaultLexiconVerbs.get(verbIRI));
        }
        HashMap<IRI, AdjectiveEntryList> defaultLexiconAdjectives = DefaultResourcesManager.generateDefaultAdjectives();
        for (IRI adjectiveIRI : defaultLexiconAdjectives.keySet()) {
            this.lexiconAdjectives.put(adjectiveIRI, defaultLexiconAdjectives.get(adjectiveIRI));
        }
    }

    public HashSet<IRI> getEntries() {
        HashSet<IRI> v = new HashSet<IRI>();
        for (IRI nounIRI : this.lexiconNouns.keySet()) {
            v.add(nounIRI);
        }
        for (IRI adjectiveIRI : this.lexiconAdjectives.keySet()) {
            v.add(adjectiveIRI);
        }
        for (IRI verbIRI : this.lexiconVerbs.keySet()) {
            v.add(verbIRI);
        }
        return v;
    }

    public Set<IRI> getNounEntries() {
        return this.lexiconNouns.keySet();
    }

    public Set<IRI> getVerbEntries() {
        return this.lexiconVerbs.keySet();
    }

    public Set<IRI> getAdjectiveEntries() {
        return this.lexiconAdjectives.keySet();
    }

    public LexEntryNoun getNounEntry(IRI nounIRI, String language) {
        return (LexEntryNoun)this.lexiconNouns.get(nounIRI).getEntry(language);
    }

    public LexEntryVerb getVerbEntry(IRI verbIRI, String language) {
        return (LexEntryVerb)this.lexiconVerbs.get(verbIRI).getEntry(language);
    }

    public LexEntryAdjective getAdjectiveEntry(IRI adjectiveIRI, String language) {
        return (LexEntryAdjective)this.lexiconAdjectives.get(adjectiveIRI).getEntry(language);
    }

    public ArrayList<HashSet<IRI>> importLexiconEntries(OWLOntology NLResourcesModel) {
        Set literals;
        ArrayList<HashSet<IRI>> loadedResources = new ArrayList<HashSet<IRI>>();
        HashSet<IRI> NLResourcesLoaded = new HashSet<IRI>();
        Set nounEntryAssertations = NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)NLResourceManager.NounLexiconEntry);
        for (OWLClassAssertionAxiom nounEntryAssertation : nounEntryAssertations) {
            Set individuals;
            OWLIndividual nounEntry = nounEntryAssertation.getIndividual();
            IRI NLResIRI = nounEntry.asOWLNamedIndividual().getIRI();
            NLResourcesLoaded.add(NLResIRI);
            Set nounEntriesEN = nounEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasEnglishEntry, NLResourcesModel);
            LexEntryNounEN LE_EN = new LexEntryNounEN();
            for (OWLIndividual nounEntryEN : nounEntriesEN) {
                individuals = nounEntryEN.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasGender, NLResourcesModel);
                for (OWLIndividual individual : individuals) {
                    if (individual.equals(NLResourceManager.masculineGender)) {
                        LE_EN.setGender("masculine");
                        continue;
                    }
                    if (individual.equals(NLResourceManager.feminineGender)) {
                        LE_EN.setGender("feminine");
                        continue;
                    }
                    if (individual.equals(NLResourceManager.neuterGender)) {
                        LE_EN.setGender("neuter");
                        continue;
                    }
                    if (!individual.equals(NLResourceManager.masculineOrFeminineGender)) continue;
                    LE_EN.setGender("masculineOrFeminine");
                }
                if (individuals.isEmpty()) {
                    LE_EN.setGender("masculineOrFeminine");
                }
                individuals = nounEntryEN.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasNumber, NLResourcesModel);
                for (OWLIndividual individual : individuals) {
                    if (individual.equals(NLResourceManager.singularNumber)) {
                        LE_EN.setNumber("singular");
                        continue;
                    }
                    if (individual.equals(NLResourceManager.pluralNumber)) {
                        LE_EN.setNumber("plural");
                        continue;
                    }
                    if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                    LE_EN.setNumber("both");
                }
                if (individuals.isEmpty()) {
                    LE_EN.setNumber("singular");
                }
                literals = nounEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularEnglish, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setSingular(literal.getLiteral());
                }
                literals = nounEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralEnglish, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setPlural(literal.getLiteral());
                }
            }
            Set nounEntriesGR = nounEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasGreekEntry, NLResourcesModel);
            LexEntryNounGR LE_GR = new LexEntryNounGR();
            for (OWLIndividual nounEntryGR : nounEntriesGR) {
                individuals = nounEntryGR.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasGender, NLResourcesModel);
                for (OWLIndividual individual : individuals) {
                    if (individual.equals(NLResourceManager.masculineGender)) {
                        LE_GR.setGender("masculine");
                        continue;
                    }
                    if (individual.equals(NLResourceManager.feminineGender)) {
                        LE_GR.setGender("feminine");
                        continue;
                    }
                    if (individual.equals(NLResourceManager.neuterGender)) {
                        LE_GR.setGender("neuter");
                        continue;
                    }
                    if (!individual.equals(NLResourceManager.masculineOrFeminineGender)) continue;
                    LE_GR.setGender("masculineOrFeminine");
                }
                if (individuals.isEmpty()) {
                    LE_GR.setGender("masculineOrFeminine");
                }
                individuals = nounEntryGR.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasNumber, NLResourcesModel);
                for (OWLIndividual individual : individuals) {
                    if (individual.equals(NLResourceManager.singularNumber)) {
                        LE_GR.setNumber("singular");
                        continue;
                    }
                    if (individual.equals(NLResourceManager.pluralNumber)) {
                        LE_GR.setNumber("plural");
                        continue;
                    }
                    if (!individual.equals(NLResourceManager.bothNumbers)) continue;
                    LE_GR.setNumber("both");
                }
                if (individuals.isEmpty()) {
                    LE_GR.setNumber("singular");
                }
                literals = nounEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularNominativeGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularNominative(literal.getLiteral());
                }
                literals = nounEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularGenitiveGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularGenitive(literal.getLiteral());
                }
                literals = nounEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularAccusativeGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularAccusative(literal.getLiteral());
                }
                literals = nounEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralNominativeGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralNominative(literal.getLiteral());
                }
                literals = nounEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralGenitiveGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralGenitive(literal.getLiteral());
                }
                literals = nounEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralAccusativeGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralAccusative(literal.getLiteral());
                }
            }
            NounEntryList npList = new NounEntryList(LE_EN, LE_GR);
            this.lexiconNouns.put(NLResIRI, npList);
        }
        Set adjectiveEntryAssertations = NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)NLResourceManager.AdjectiveLexiconEntry);
        for (OWLClassAssertionAxiom adjectiveEntryAssertation : adjectiveEntryAssertations) {
            OWLIndividual adjEntry = adjectiveEntryAssertation.getIndividual();
            IRI NLResIRI = adjEntry.asOWLNamedIndividual().getIRI();
            NLResourcesLoaded.add(NLResIRI);
            Set adjEntriesEN = adjEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasEnglishEntry, NLResourcesModel);
            LexEntryAdjectiveEN LE_EN = new LexEntryAdjectiveEN();
            for (OWLIndividual adjEntryEN : adjEntriesEN) {
                literals = adjEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasFormEnglish, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.set_form(literal.getLiteral());
                }
            }
            Set adjEntriesGR = adjEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasGreekEntry, NLResourcesModel);
            LexEntryAdjectiveGR LE_GR = new LexEntryAdjectiveGR();
            for (OWLIndividual adjEntryGR : adjEntriesGR) {
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularNominativeMasculineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularNominativeMasculine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularNominativeFeminineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularNominativeFeminine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularNominativeNeuterGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularNominativeNeuter(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralNominativeMasculineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralNominativeMasculine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralNominativeFeminineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralNominativeFeminine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralNominativeNeuterGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralNominativeNeuter(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularGenitiveMasculineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularGenitiveMasculine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularGenitiveFeminineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularGenitiveFeminine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularGenitiveNeuterGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularGenitiveNeuter(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralGenitiveMasculineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralGenitiveMasculine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralGenitiveFeminineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralGenitiveFeminine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralGenitiveNeuterGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralGenitiveNeuter(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularAccusativeMasculineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularAccusativeMasculine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularAccusativeFeminineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularAccusativeFeminine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasSingularAccusativeNeuterGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setSingularAccusativeNeuter(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralAccusativeMasculineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralAccusativeMasculine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralAccusativeFeminineGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralAccusativeFeminine(literal.getLiteral());
                }
                literals = adjEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.hasPluralAccusativeNeuterGreek, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.setPluralAccusativeNeuter(literal.getLiteral());
                }
            }
            AdjectiveEntryList npList = new AdjectiveEntryList(LE_EN, LE_GR);
            this.lexiconAdjectives.put(NLResIRI, npList);
        }
        Set verbEntryAssertations = NLResourcesModel.getClassAssertionAxioms((OWLClassExpression)NLResourceManager.VerbLexiconEntry);
        for (OWLClassAssertionAxiom verbEntryAssertation : verbEntryAssertations) {
            OWLIndividual verbEntry = verbEntryAssertation.getIndividual();
            IRI NLResIRI = verbEntry.asOWLNamedIndividual().getIRI();
            NLResourcesLoaded.add(NLResIRI);
            Set verbEntriesEN = verbEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasEnglishEntry, NLResourcesModel);
            LexEntryVerbEN LE_EN = new LexEntryVerbEN();
            for (OWLIndividual verbEntryEN : verbEntriesEN) {
                literals = verbEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.baseForm, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setBaseForm(literal.getLiteral());
                }
                literals = verbEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.simplePres3rdSing, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setSimplePresent3rdSingular(literal.getLiteral());
                }
                literals = verbEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.presParticiple, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setPresentParticiple(literal.getLiteral());
                }
                literals = verbEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.simplePast, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setSimplePast(literal.getLiteral());
                }
                literals = verbEntryEN.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.pastParticiple, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_EN.setPastParticiple(literal.getLiteral());
                }
            }
            Set verbEntriesGR = verbEntry.getObjectPropertyValues((OWLObjectPropertyExpression)NLResourceManager.hasGreekEntry, NLResourcesModel);
            LexEntryVerbGR LE_GR = new LexEntryVerbGR();
            for (OWLIndividual verbEntryGR : verbEntriesGR) {
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePresent1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple present", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePresent2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple present", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePresent3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple present", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePresent1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple present", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePresent2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple present", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePresent3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple present", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePast1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple past", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePast2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple past", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePast3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple past", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePast1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple past", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePast2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple past", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimplePast3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple past", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activePastContinuous1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "past continuous", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activePastContinuous2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "past continuous", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activePastContinuous3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "past continuous", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activePastContinuous1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "past continuous", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activePastContinuous2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "past continuous", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activePastContinuous3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "past continuous", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimpleFuture1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple future", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimpleFuture2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple future", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimpleFuture3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple future", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimpleFuture1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple future", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimpleFuture2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple future", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeSimpleFuture3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "simple future", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeInfinitive, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "infinitive", "", "", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.activeParticiple, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("active", "participle", "", "", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePresent1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple present", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePresent2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple present", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePresent3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple present", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePresent1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple present", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePresent2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple present", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePresent3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple present", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePast1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple past", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePast2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple past", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePast3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple past", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePast1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple past", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePast2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple past", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimplePast3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple past", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passivePastContinuous1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "past continuous", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passivePastContinuous2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "past continuous", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passivePastContinuous3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "past continuous", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passivePastContinuous1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "past continuous", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passivePastContinuous2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "past continuous", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passivePastContinuous3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "past continuous", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimpleFuture1stSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple future", "1st", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimpleFuture2ndSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple future", "2nd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimpleFuture3rdSingular, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple future", "3rd", "singular", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimpleFuture1stPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple future", "1st", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimpleFuture2ndPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple future", "2nd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveSimpleFuture3rdPlural, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "simple future", "3rd", "plural", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveInfinitive, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "infinitive", "", "", literal.getLiteral());
                }
                literals = verbEntryGR.getDataPropertyValues((OWLDataPropertyExpression)NLResourceManager.passiveParticiple, NLResourcesModel);
                for (OWLLiteral literal : literals) {
                    LE_GR.set("passive", "participle", "", "", literal.getLiteral());
                }
            }
            VerbEntryList npList = new VerbEntryList(LE_EN, LE_GR);
            this.lexiconVerbs.put(NLResIRI, npList);
        }
        loadedResources.add(NLResourcesLoaded);
        return loadedResources;
    }

    public Iterator<IRI> getNounsIRIs() {
        return this.lexiconNouns.keySet().iterator();
    }

    public Iterator<IRI> getAdjectivesIRIs() {
        return this.lexiconAdjectives.keySet().iterator();
    }

    public Iterator<IRI> getVerbsIRIs() {
        return this.lexiconVerbs.keySet().iterator();
    }

    public EntryList getEntryList(IRI entryIRI) {
        if (this.lexiconNouns.containsKey(entryIRI)) {
            return this.lexiconNouns.get(entryIRI);
        }
        if (this.lexiconAdjectives.containsKey(entryIRI)) {
            return this.lexiconAdjectives.get(entryIRI);
        }
        if (this.lexiconVerbs.containsKey(entryIRI)) {
            return this.lexiconVerbs.get(entryIRI);
        }
        return null;
    }

    public boolean isNoun(IRI entryIRI) {
        return this.lexiconNouns.containsKey(entryIRI);
    }

    public boolean isAdjective(IRI entryIRI) {
        return this.lexiconAdjectives.containsKey(entryIRI);
    }

    public boolean isVerb(IRI entryIRI) {
        return this.lexiconVerbs.containsKey(entryIRI);
    }

    public void deleteLexiconEntry(IRI nlResourceIRI) {
        if (this.lexiconNouns.containsKey(nlResourceIRI)) {
            this.lexiconNouns.remove(nlResourceIRI);
        }
        if (this.lexiconAdjectives.containsKey(nlResourceIRI)) {
            this.lexiconAdjectives.remove(nlResourceIRI);
        }
        if (this.lexiconVerbs.containsKey(nlResourceIRI)) {
            this.lexiconVerbs.remove(nlResourceIRI);
        }
    }

    public void addNounEntryToLexicon(IRI entryIRI) {
        LexEntryNounEN LE_EN = new LexEntryNounEN();
        LexEntryNounGR LE_GR = new LexEntryNounGR();
        NounEntryList npList = new NounEntryList(LE_EN, LE_GR);
        this.lexiconNouns.put(entryIRI, npList);
    }

    public void addVerbEntryToLexicon(IRI entryIRI) {
        LexEntryVerbEN LE_EN = new LexEntryVerbEN();
        LexEntryVerbGR LE_GR = new LexEntryVerbGR();
        VerbEntryList npList = new VerbEntryList(LE_EN, LE_GR);
        this.lexiconVerbs.put(entryIRI, npList);
    }

    public void addAdjectiveEntryToLexicon(IRI entryIRI) {
        LexEntryAdjectiveEN LE_EN = new LexEntryAdjectiveEN();
        LexEntryAdjectiveGR LE_GR = new LexEntryAdjectiveGR();
        AdjectiveEntryList npList = new AdjectiveEntryList(LE_EN, LE_GR);
        this.lexiconAdjectives.put(entryIRI, npList);
    }

    public void duplicateEntryInLexicon(IRI fromIRI, IRI toIRI) {
        EntryList npList;
        LexEntry LE_GR;
        LexEntry LE_EN;
        EntryList copyList = this.getEntryList(fromIRI);
        if (copyList instanceof NounEntryList) {
            LE_EN = new LexEntryNounEN((LexEntryNounEN)copyList.getEntry("en"));
            LE_GR = new LexEntryNounGR((LexEntryNounGR)copyList.getEntry("el"));
            npList = new NounEntryList((LexEntryNounEN)LE_EN, (LexEntryNounGR)LE_GR);
            this.lexiconNouns.put(toIRI, (NounEntryList)npList);
        }
        if (copyList instanceof VerbEntryList) {
            LE_EN = new LexEntryVerbEN((LexEntryVerbEN)copyList.getEntry("en"));
            LE_GR = new LexEntryVerbGR((LexEntryVerbGR)copyList.getEntry("el"));
            npList = new VerbEntryList((LexEntryVerbEN)LE_EN, (LexEntryVerbGR)LE_GR);
            this.lexiconVerbs.put(toIRI, (VerbEntryList)npList);
        }
        if (copyList instanceof AdjectiveEntryList) {
            LE_EN = new LexEntryAdjectiveEN((LexEntryAdjectiveEN)copyList.getEntry("en"));
            LE_GR = new LexEntryAdjectiveGR((LexEntryAdjectiveGR)copyList.getEntry("el"));
            npList = new AdjectiveEntryList((LexEntryAdjectiveEN)LE_EN, (LexEntryAdjectiveGR)LE_GR);
            this.lexiconAdjectives.put(toIRI, (AdjectiveEntryList)npList);
        }
    }

    public void exportLexiconEntries(OWLOntology resourceOntology) {
        OWLDataPropertyAssertionAxiom dataAssertion;
        OWLDataProperty dataProperty;
        AddAxiom addAxiomChange;
        Object objectAssertion;
        OWLObjectProperty objectProperty;
        OWLNamedIndividual entry;
        OWLClassAssertionAxiom classAssertion;
        OWLNamedIndividual indiv;
        OWLClass cls;
        EntryList currentNPList;
        OWLDataFactory factory = this.NLResourcesManager.getDataFactory();
        for (IRI NLResourceIRI : this.lexiconNouns.keySet()) {
            currentNPList = this.lexiconNouns.get(NLResourceIRI);
            cls = NLResourceManager.NounLexiconEntry;
            indiv = factory.getOWLNamedIndividual(NLResourceIRI);
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indiv);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            cls = NLResourceManager.GreekNounEntry;
            entry = factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(NLResourceIRI.toString()) + "_GreekNounEntry")));
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)entry);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            objectProperty = NLResourceManager.hasGreekEntry;
            objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indiv, (OWLIndividual)entry);
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            LexEntryNounGR lex_entry_noun_gr = (LexEntryNounGR)currentNPList.getEntry("el");
            if (lex_entry_noun_gr == null) {
                lex_entry_noun_gr = new LexEntryNounGR("neuter", "plural");
            }
            objectProperty = NLResourceManager.hasGender;
            objectAssertion = lex_entry_noun_gr.getGender().equals("masculine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.masculineGender) : (lex_entry_noun_gr.getGender().equals("feminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.feminineGender) : (lex_entry_noun_gr.getGender().equals("neuter") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.neuterGender) : (lex_entry_noun_gr.getGender().equals("masculineOrFeminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.masculineOrFeminineGender) : null)));
            if (objectAssertion != null) {
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            objectProperty = NLResourceManager.hasNumber;
            objectAssertion = lex_entry_noun_gr.getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.singularNumber) : (lex_entry_noun_gr.getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.pluralNumber) : (lex_entry_noun_gr.getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.bothNumbers) : null));
            if (objectAssertion != null) {
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            if (!(lex_entry_noun_gr.get("nominative", "singular").isEmpty() && lex_entry_noun_gr.get("genitive", "singular").isEmpty() && lex_entry_noun_gr.get("accusative", "singular").isEmpty())) {
                dataProperty = NLResourceManager.hasSingularNominativeGreek;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_noun_gr.get("nominative", "singular"));
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasSingularGenitiveGreek;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_noun_gr.get("genitive", "singular"));
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasSingularAccusativeGreek;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_noun_gr.get("accusative", "singular"));
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            if (!(lex_entry_noun_gr.get("nominative", "plural").isEmpty() && lex_entry_noun_gr.get("genitive", "plural").isEmpty() && lex_entry_noun_gr.get("accusative", "plural").isEmpty())) {
                dataProperty = NLResourceManager.hasPluralNominativeGreek;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_noun_gr.get("nominative", "plural"));
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasPluralGenitiveGreek;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_noun_gr.get("genitive", "plural"));
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
                dataProperty = NLResourceManager.hasPluralAccusativeGreek;
                dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_noun_gr.get("accusative", "plural"));
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            cls = NLResourceManager.EnglishNounEntry;
            entry = factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(NLResourceIRI.toString()) + "_EnglishNounEntry")));
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)entry);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            objectProperty = NLResourceManager.hasEnglishEntry;
            objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indiv, (OWLIndividual)entry);
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            LexEntryNounEN lex_entry_noun_en = (LexEntryNounEN)currentNPList.getEntry("en");
            if (lex_entry_noun_en == null) {
                lex_entry_noun_en = new LexEntryNounEN("masculineOrFeminine", "plural");
            }
            objectProperty = NLResourceManager.hasGender;
            objectAssertion = lex_entry_noun_en.getGender().equals("masculine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.masculineGender) : (lex_entry_noun_en.getGender().equals("feminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.feminineGender) : (lex_entry_noun_en.getGender().equals("neuter") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.neuterGender) : (lex_entry_noun_en.getGender().equals("masculineOrFeminine") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.masculineOrFeminineGender) : null)));
            if (objectAssertion != null) {
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            objectProperty = NLResourceManager.hasNumber;
            objectAssertion = lex_entry_noun_en.getNumber().equals("singular") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.singularNumber) : (lex_entry_noun_en.getNumber().equals("plural") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.pluralNumber) : (lex_entry_noun_en.getNumber().equals("both") ? factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)entry, (OWLIndividual)NLResourceManager.bothNumbers) : null));
            if (objectAssertion != null) {
                addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
                this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            }
            OWLDataProperty dataProperty2 = NLResourceManager.hasSingularEnglish;
            OWLDataPropertyAssertionAxiom dataAssertion2 = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty2, (OWLIndividual)entry, lex_entry_noun_en.getSingular());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion2);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty2 = NLResourceManager.hasPluralEnglish;
            dataAssertion2 = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty2, (OWLIndividual)entry, lex_entry_noun_en.getPlural());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion2);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
        for (IRI NLResourceIRI : this.lexiconAdjectives.keySet()) {
            currentNPList = this.lexiconAdjectives.get(NLResourceIRI);
            cls = NLResourceManager.AdjectiveLexiconEntry;
            indiv = factory.getOWLNamedIndividual(NLResourceIRI);
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indiv);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            cls = NLResourceManager.GreekAdjectiveEntry;
            entry = factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(NLResourceIRI.toString()) + "_GreekAdjectiveEntry")));
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)entry);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            objectProperty = NLResourceManager.hasGreekEntry;
            objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indiv, (OWLIndividual)entry);
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            LexEntryAdjectiveGR lex_entry_adjective_gr = (LexEntryAdjectiveGR)currentNPList.getEntry("el");
            if (lex_entry_adjective_gr == null) {
                lex_entry_adjective_gr = new LexEntryAdjectiveGR();
            }
            dataProperty = NLResourceManager.hasSingularNominativeMasculineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("masculine", "singular", "nominative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularNominativeFeminineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("feminine", "singular", "nominative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularNominativeNeuterGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("neuter", "singular", "nominative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralNominativeMasculineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("masculine", "plural", "nominative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralNominativeFeminineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("feminine", "plural", "nominative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralNominativeNeuterGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("neuter", "plural", "nominative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularGenitiveMasculineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("masculine", "singular", "genitive"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularGenitiveFeminineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("feminine", "singular", "genitive"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularGenitiveNeuterGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("neuter", "singular", "genitive"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralGenitiveMasculineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("masculine", "plural", "genitive"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralGenitiveFeminineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("feminine", "plural", "genitive"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralGenitiveNeuterGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("neuter", "plural", "genitive"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularAccusativeMasculineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("masculine", "singular", "accusative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularAccusativeFeminineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("feminine", "singular", "accusative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasSingularAccusativeNeuterGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("neuter", "singular", "accusative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralAccusativeMasculineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("masculine", "plural", "accusative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralAccusativeFeminineGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("feminine", "plural", "accusative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.hasPluralAccusativeNeuterGreek;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_gr.get("neuter", "plural", "accusative"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            cls = NLResourceManager.EnglishAdjectiveEntry;
            entry = factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(NLResourceIRI.toString()) + "_EnglishAdjectiveEntry")));
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)entry);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            objectProperty = NLResourceManager.hasEnglishEntry;
            objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indiv, (OWLIndividual)entry);
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            LexEntryAdjectiveEN lex_entry_adjective_en = (LexEntryAdjectiveEN)currentNPList.getEntry("en");
            if (lex_entry_adjective_en == null) {
                lex_entry_adjective_en = new LexEntryAdjectiveEN();
            }
            dataProperty = NLResourceManager.hasFormEnglish;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_adjective_en.get_form());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
        for (IRI NLResourceIRI : this.lexiconVerbs.keySet()) {
            currentNPList = this.lexiconVerbs.get(NLResourceIRI);
            cls = NLResourceManager.VerbLexiconEntry;
            indiv = factory.getOWLNamedIndividual(NLResourceIRI);
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)indiv);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            cls = NLResourceManager.GreekVerbEntry;
            entry = factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(NLResourceIRI.toString()) + "_GreekVerbEntry")));
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)entry);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            objectProperty = NLResourceManager.hasGreekEntry;
            objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indiv, (OWLIndividual)entry);
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            LexEntryVerbGR lex_entry_verb_gr = (LexEntryVerbGR)currentNPList.getEntry("el");
            if (lex_entry_verb_gr == null) {
                lex_entry_verb_gr = new LexEntryVerbGR();
            }
            dataProperty = NLResourceManager.activeSimplePresent1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple present", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePresent2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple present", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePresent3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple present", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePresent1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple present", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePresent2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple present", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePresent3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple present", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePast1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple past", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePast2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple past", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePast3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple past", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePast1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple past", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePast2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple past", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimplePast3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple past", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activePastContinuous1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "past continuous", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activePastContinuous2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "past continuous", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activePastContinuous3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "past continuous", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activePastContinuous1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "past continuous", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activePastContinuous2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "past continuous", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activePastContinuous3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "past continuous", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimpleFuture1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple future", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimpleFuture2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple future", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimpleFuture3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple future", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimpleFuture1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple future", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimpleFuture2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple future", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeSimpleFuture3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "simple future", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeInfinitive;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "infinitive", "", ""));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.activeParticiple;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("active", "participle", "", ""));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePresent1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple present", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePresent2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple present", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePresent3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple present", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePresent1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple present", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePresent2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple present", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePresent3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple present", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePast1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple past", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePast2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple past", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePast3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple past", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePast1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple past", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePast2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple past", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimplePast3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple past", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passivePastContinuous1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "past continuous", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passivePastContinuous2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "past continuous", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passivePastContinuous3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "past continuous", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passivePastContinuous1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "past continuous", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passivePastContinuous2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "past continuous", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passivePastContinuous3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "past continuous", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimpleFuture1stSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple future", "1st", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimpleFuture2ndSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple future", "2nd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimpleFuture3rdSingular;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple future", "3rd", "singular"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimpleFuture1stPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple future", "1st", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimpleFuture2ndPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple future", "2nd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveSimpleFuture3rdPlural;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "simple future", "3rd", "plural"));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveInfinitive;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "infinitive", "", ""));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.passiveParticiple;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_gr.get("passive", "participle", "", ""));
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            cls = NLResourceManager.EnglishVerbEntry;
            entry = factory.getOWLNamedIndividual(IRI.create((String)(String.valueOf(NLResourceIRI.toString()) + "_EnglishVerbEntry")));
            classAssertion = factory.getOWLClassAssertionAxiom((OWLClassExpression)cls, (OWLIndividual)entry);
            this.NLResourcesManager.getOntologyManager().addAxiom(resourceOntology, (OWLAxiom)classAssertion);
            objectProperty = NLResourceManager.hasEnglishEntry;
            objectAssertion = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)objectProperty, (OWLIndividual)indiv, (OWLIndividual)entry);
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)objectAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            LexEntryVerbEN lex_entry_verb_en = (LexEntryVerbEN)currentNPList.getEntry("en");
            if (lex_entry_verb_en == null) {
                lex_entry_verb_en = new LexEntryVerbEN();
            }
            dataProperty = NLResourceManager.baseForm;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_en.getBaseForm());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.simplePres3rdSing;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_en.getSimplePresent3rdSingular());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.presParticiple;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_en.getPresentParticiple());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.simplePast;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_en.getSimplePast());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
            dataProperty = NLResourceManager.pastParticiple;
            dataAssertion = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dataProperty, (OWLIndividual)entry, lex_entry_verb_en.getPastParticiple());
            addAxiomChange = new AddAxiom(resourceOntology, (OWLAxiom)dataAssertion);
            this.NLResourcesManager.getOntologyManager().applyChange((OWLOntologyChange)addAxiomChange);
        }
    }
}

