/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.NLFiles.LexEntryVerb;

public class LexEntryVerbEN
extends LexEntryVerb {
    private String baseForm;
    private String simplePres3rdSing;
    private String presParticiple;
    private String simplePast;
    private String pastParticiple;

    public LexEntryVerbEN(String bf, String s3rd, String prp, String sp, String pap) {
        this.baseForm = bf;
        this.simplePres3rdSing = s3rd;
        this.presParticiple = prp;
        this.simplePast = sp;
        this.pastParticiple = pap;
    }

    public LexEntryVerbEN(LexEntryVerbEN o) {
        this.baseForm = o.getBaseForm();
        this.simplePres3rdSing = o.getSimplePresent3rdSingular();
        this.presParticiple = o.getPresentParticiple();
        this.simplePast = o.getSimplePast();
        this.pastParticiple = o.getPastParticiple();
    }

    public LexEntryVerbEN() {
        this.baseForm = "";
        this.simplePres3rdSing = "";
        this.presParticiple = "";
        this.simplePast = "";
        this.pastParticiple = "";
    }

    public void setPresentForms(String bf, String s3rd, String prp) {
        this.baseForm = bf;
        this.simplePres3rdSing = s3rd;
        this.presParticiple = prp;
    }

    public void setBaseForm(String bf) {
        this.baseForm = bf;
    }

    public void setSimplePresent3rdSingular(String s3rd) {
        this.simplePres3rdSing = s3rd;
    }

    public void setPresentParticiple(String prp) {
        this.presParticiple = prp;
    }

    public void setPastForms(String sp, String pap) {
        this.simplePast = sp;
        this.pastParticiple = pap;
    }

    public void setSimplePast(String sp) {
        this.simplePast = sp;
    }

    public void setPastParticiple(String pap) {
        this.pastParticiple = pap;
    }

    public String getBaseForm() {
        return this.baseForm;
    }

    public String getSimplePresent3rdSingular() {
        return this.simplePres3rdSing;
    }

    public String getPresentParticiple() {
        return this.presParticiple;
    }

    public String getSimplePast() {
        return this.simplePast;
    }

    public String getPastParticiple() {
        return this.pastParticiple;
    }

    public boolean isVowel(char letter) {
        return letter == 'a' || letter == 'e' || letter == 'i' || letter == 'o' || letter == 'u';
    }

    public String addPrefixED(String verb) {
        if (verb.endsWith("e")) {
            return String.valueOf(verb) + "d";
        }
        if (verb.endsWith("l") && this.isVowel(verb.charAt(verb.length() - 2))) {
            return String.valueOf(verb) + "l" + "ed";
        }
        if (verb.endsWith("y") && !this.isVowel(verb.charAt(verb.length() - 2))) {
            return String.valueOf(verb.substring(0, verb.length() - 2)) + "i" + "ed";
        }
        return String.valueOf(verb) + "ed";
    }

    public String addPrefixING(String verb) {
        if (verb.endsWith("ee")) {
            return String.valueOf(verb) + "ing";
        }
        if (verb.endsWith("e")) {
            return String.valueOf(verb.substring(0, verb.length() - 2)) + "ing";
        }
        if (verb.endsWith("l") && this.isVowel(verb.charAt(verb.length() - 2))) {
            return String.valueOf(verb) + "l" + "ing";
        }
        if (verb.endsWith("ie")) {
            return String.valueOf(verb.substring(0, verb.length() - 3)) + "y" + "ing";
        }
        return String.valueOf(verb) + "ing";
    }

    public String get(String voice, String tense, String person, String number) {
        if (voice.equals("active")) {
            if (tense.equals("simple present")) {
                if (number.equals("singular")) {
                    if (person.equals("3rd")) {
                        return this.getSimplePresent3rdSingular();
                    }
                    return this.getBaseForm();
                }
                if (number.equals("plural")) {
                    return this.getBaseForm();
                }
            } else {
                if (tense.equals("present continuous")) {
                    return this.getPresentParticiple();
                }
                if (tense.equals("present perfect")) {
                    return this.getPastParticiple();
                }
                if (tense.equals("simple past")) {
                    return this.getPastParticiple();
                }
                if (tense.equals("past continuous")) {
                    return this.getPresentParticiple();
                }
                if (tense.equals("past perfect continuous")) {
                    return this.getPresentParticiple();
                }
                if (tense.equals("simple future")) {
                    return this.getBaseForm();
                }
                if (tense.equals("future continuous")) {
                    return this.getPresentParticiple();
                }
                if (tense.equals("future perfect")) {
                    return this.getPastParticiple();
                }
                if (tense.equals("future perfect continuous")) {
                    return this.getPresentParticiple();
                }
            }
        } else if (voice.equals("passive")) {
            return this.getPastParticiple();
        }
        return "";
    }
}

