/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.NLFiles.LexEntryNoun;

public class LexEntryNounGR
extends LexEntryNoun {
    private String singularNom;
    private String singularGen;
    private String singularAcc;
    private String pluralNom;
    private String pluralGen;
    private String pluralAcc;

    public LexEntryNounGR(String sn, String sg, String sa, String pn, String pg, String pa, String gender, String number) {
        this.singularNom = sn;
        this.singularGen = sg;
        this.singularAcc = sa;
        this.pluralNom = pn;
        this.pluralGen = pg;
        this.pluralAcc = pa;
        this.setGender(gender);
        this.setNumber(number);
    }

    public LexEntryNounGR(String gender, String number) {
        this.singularNom = "";
        this.singularGen = "";
        this.singularAcc = "";
        this.pluralNom = "";
        this.pluralGen = "";
        this.pluralAcc = "";
        this.setGender(gender);
        this.setNumber(number);
    }

    public LexEntryNounGR(LexEntryNounGR o) {
        this.singularNom = o.get("nominative", "singular");
        this.singularGen = o.get("genitive", "singular");
        this.singularAcc = o.get("accusative", "singular");
        this.pluralNom = o.get("nominative", "plural");
        this.pluralGen = o.get("genitive", "plural");
        this.pluralAcc = o.get("accusative", "plural");
        this.setGender(o.getGender());
        this.setNumber(o.getNumber());
    }

    public LexEntryNounGR() {
        this.singularNom = "";
        this.singularGen = "";
        this.singularAcc = "";
        this.pluralNom = "";
        this.pluralGen = "";
        this.pluralAcc = "";
        this.setGender("masculineOrFeminine");
        this.setNumber("both");
    }

    public void setSingularCases(String nom, String gen, String acc) {
        this.singularNom = nom;
        this.singularGen = gen;
        this.singularAcc = acc;
    }

    public void setSingularNominative(String nom) {
        this.singularNom = nom;
    }

    public void setSingularGenitive(String gen) {
        this.singularGen = gen;
    }

    public void setSingularAccusative(String acc) {
        this.singularAcc = acc;
    }

    public void setPluralCases(String nom, String gen, String acc) {
        this.pluralNom = nom;
        this.pluralGen = gen;
        this.pluralAcc = acc;
    }

    public void setPluralNominative(String nom) {
        this.pluralNom = nom;
    }

    public void setPluralGenitive(String gen) {
        this.pluralGen = gen;
    }

    public void setPluralAccusative(String acc) {
        this.pluralAcc = acc;
    }

    @Override
    public String get(String caseType, String numb) {
        if (numb.compareTo("singular") == 0) {
            if (caseType.compareTo("nominative") == 0) {
                return this.singularNom;
            }
            if (caseType.compareTo("genitive") == 0) {
                return this.singularGen;
            }
            if (caseType.compareTo("accusative") == 0) {
                return this.singularAcc;
            }
        } else if (numb.compareTo("plural") == 0) {
            if (caseType.compareTo("nominative") == 0) {
                return this.pluralNom;
            }
            if (caseType.compareTo("genitive") == 0) {
                return this.pluralGen;
            }
            if (caseType.compareTo("accusative") == 0) {
                return this.pluralAcc;
            }
        }
        return "";
    }
}

