/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.NLFiles;

import gr.aueb.cs.nlg.Comparisons.Comparison;
import gr.aueb.cs.nlg.Comparisons.ComparisonFullCollection;
import gr.aueb.cs.nlg.Languages.Languages;
import gr.aueb.cs.nlg.NLFiles.AdjectiveEntryList;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryAdjectiveGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryNounGR;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbEN;
import gr.aueb.cs.nlg.NLFiles.LexEntryVerbGR;
import gr.aueb.cs.nlg.NLFiles.NLNAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.NLNArticleSlot;
import gr.aueb.cs.nlg.NLFiles.NLNNounSlot;
import gr.aueb.cs.nlg.NLFiles.NLNPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.NLNSlot;
import gr.aueb.cs.nlg.NLFiles.NLNStringSlot;
import gr.aueb.cs.nlg.NLFiles.NLName;
import gr.aueb.cs.nlg.NLFiles.NLResourceManager;
import gr.aueb.cs.nlg.NLFiles.NounEntryList;
import gr.aueb.cs.nlg.NLFiles.SPAdjectiveSlot;
import gr.aueb.cs.nlg.NLFiles.SPComparatorFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPComparatorSlot;
import gr.aueb.cs.nlg.NLFiles.SPFillerSlot;
import gr.aueb.cs.nlg.NLFiles.SPNounSlot;
import gr.aueb.cs.nlg.NLFiles.SPOwnerSlot;
import gr.aueb.cs.nlg.NLFiles.SPPrepositionSlot;
import gr.aueb.cs.nlg.NLFiles.SPSlot;
import gr.aueb.cs.nlg.NLFiles.SPStringSlot;
import gr.aueb.cs.nlg.NLFiles.SPVerbSlot;
import gr.aueb.cs.nlg.NLFiles.SentencePlan;
import gr.aueb.cs.nlg.NLFiles.VerbEntryList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;

public class DefaultResourcesManager {
    public static IRI entityNLE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "entityNLE"));
    public static IRI toBeVLE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "toBeVLE"));
    public static IRI toHaveVLE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "toHaveVLE"));
    public static IRI identicalALE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "identicalALE"));
    public static IRI otherALE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "otherALE"));
    public static IRI onlyALE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "onlyALE"));
    public static IRI prevALE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "previousALE"));
    public static IRI mostALE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "mostALE"));
    public static IRI allALE_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "allALE"));
    public static IRI entityNLNEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "entityNLNEN"));
    public static IRI entityNLNGR_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "entityNLNGR"));
    public static IRI isASPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "isASPEN"));
    public static IRI isASPGR_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "isASPGR"));
    public static IRI sameIndividualSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "sameIndividualSPEN"));
    public static IRI sameIndividualSPGR_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "sameIndividualSPGR"));
    public static IRI kindOfSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "kindOfSPEN"));
    public static IRI kindOfSPGR_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "kindOfSPGR"));
    public static IRI oneOfSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "oneOfSPEN"));
    public static IRI oneOfSPGR_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + "oneOfSPGR"));

    public static boolean isDefaultResource(IRI resourceIRI) {
        if (resourceIRI.equals((Object)entityNLE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)toBeVLE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)toHaveVLE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)identicalALE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)onlyALE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)prevALE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)mostALE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)allALE_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)entityNLNEN_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)entityNLNGR_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)isASPEN_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)isASPGR_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)sameIndividualSPEN_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)sameIndividualSPGR_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)kindOfSPEN_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)kindOfSPGR_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)oneOfSPEN_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)oneOfSPGR_IRI)) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.anonymous.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.exactCardinality.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.minCardinality.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.maxCardinality.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.allValuesFrom.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.someValuesFrom.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.instanceOf.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.isA.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.oneOf.getIRI())) {
            return true;
        }
        if (resourceIRI.equals((Object)NLResourceManager.differentIndividuals.getIRI())) {
            return true;
        }
        return resourceIRI.equals((Object)NLResourceManager.sameIndividuals.getIRI());
    }

    public static boolean isModifier(IRI modifier) {
        if (modifier.equals((Object)NLResourceManager.exactCardinality.getIRI())) {
            return true;
        }
        if (modifier.equals((Object)NLResourceManager.minCardinality.getIRI())) {
            return true;
        }
        return modifier.equals((Object)NLResourceManager.maxCardinality.getIRI());
    }

    public static SentencePlan generateSentencePlanForComparison(SentencePlan sentencePlan, Comparison comparison) {
        String lang = "";
        if (Languages.isEnglish(sentencePlan.getLanguage())) {
            lang = "EN";
        } else if (Languages.isGreek(sentencePlan.getLanguage())) {
            lang = "GR";
        }
        int order = 0;
        ArrayList<SPSlot> slotsList = new ArrayList<SPSlot>();
        if (!comparison.getValueIRI().toString().isEmpty()) {
            boolean startAppending = false;
            Collections.sort(sentencePlan.getSlotsList());
            int i = 0;
            while (i < sentencePlan.getSlotsList().size()) {
                SPStringSlot stringSlot;
                SPSlot slot = sentencePlan.getSlotsList().get(i);
                if (slot instanceof SPOwnerSlot) {
                    SPComparatorSlot comparator;
                    if (!comparison.isSame()) {
                        startAppending = true;
                    }
                    if (comparison.isSame()) {
                        comparator = new SPComparatorSlot("nominative", comparison.isMany(), NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorSlot")), order);
                        slotsList.add(comparator);
                        ++order;
                    } else {
                        comparator = new SPComparatorSlot("accusative", comparison.isMany(), NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorSlot")), order);
                        slotsList.add(comparator);
                        ++order;
                    }
                    stringSlot = new SPStringSlot(comparison.getSuffix(), NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonCollectionSlot")), order);
                    slotsList.add(stringSlot);
                    stringSlot = new SPStringSlot(",", NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonCommaSlot" + "_" + 1)), ++order);
                    slotsList.add(stringSlot);
                    ++order;
                    if (!comparison.isSame()) {
                        stringSlot = new SPStringSlot(comparison.getReminderConnector(), NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonConnectorReminderSlot")), order);
                        slotsList.add(stringSlot);
                        ++order;
                    }
                } else if (slot instanceof SPFillerSlot && !comparison.isSame()) {
                    startAppending = false;
                    SPComparatorFillerSlot comparatorFiller = new SPComparatorFillerSlot("accusative", false, NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorFillerSlot")), order);
                    slotsList.add(comparatorFiller);
                    SPStringSlot stringSlot2 = new SPStringSlot(",", NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonCommaSlot" + "_" + 2)), ++order);
                    slotsList.add(stringSlot2);
                    ++order;
                } else if (startAppending) {
                    if (slot instanceof SPVerbSlot) {
                        SPVerbSlot verbSlot = new SPVerbSlot((SPVerbSlot)slot);
                        verbSlot.setId(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + verbSlot.getId().toString().substring(verbSlot.getId().toString().indexOf(58) + 1))));
                        verbSlot.setOrder(order);
                        if (verbSlot.getAgreesWithID() != null) {
                            for (SPSlot agreeWith : sentencePlan.getSlotsList()) {
                                if (!verbSlot.getAgreesWithID().equals(agreeWith.getId())) continue;
                                if (agreeWith instanceof SPOwnerSlot) {
                                    verbSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorSlot")));
                                    break;
                                }
                                if (agreeWith instanceof SPFillerSlot) {
                                    verbSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorFillerSlot")));
                                    break;
                                }
                                verbSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + agreeWith.getId().toString().substring(agreeWith.getId().toString().indexOf(58) + 1))));
                                break;
                            }
                        }
                        slotsList.add(verbSlot);
                        ++order;
                    } else if (slot instanceof SPNounSlot) {
                        SPNounSlot nounSlot = new SPNounSlot((SPNounSlot)slot);
                        nounSlot.setId(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + nounSlot.getId().toString().substring(nounSlot.getId().toString().indexOf(58) + 1))));
                        nounSlot.setOrder(order);
                        if (nounSlot.getAgreesWithID() != null) {
                            for (SPSlot agreeWith : sentencePlan.getSlotsList()) {
                                if (!nounSlot.getAgreesWithID().equals(agreeWith.getId())) continue;
                                if (agreeWith instanceof SPOwnerSlot) {
                                    nounSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorSlot")));
                                    break;
                                }
                                if (agreeWith instanceof SPFillerSlot) {
                                    nounSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorFillerSlot")));
                                    break;
                                }
                                nounSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + agreeWith.getId().toString().substring(agreeWith.getId().toString().indexOf(58) + 1))));
                                break;
                            }
                        }
                        slotsList.add(nounSlot);
                        ++order;
                    } else if (slot instanceof SPAdjectiveSlot) {
                        SPAdjectiveSlot adjectiveSlot = new SPAdjectiveSlot((SPAdjectiveSlot)slot);
                        adjectiveSlot.setId(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + adjectiveSlot.getId().toString().substring(adjectiveSlot.getId().toString().indexOf(58) + 1))));
                        adjectiveSlot.setOrder(order);
                        if (adjectiveSlot.getAgreesWithID() != null) {
                            for (SPSlot agreeWith : sentencePlan.getSlotsList()) {
                                if (!adjectiveSlot.getAgreesWithID().equals(agreeWith.getId())) continue;
                                if (agreeWith instanceof SPOwnerSlot) {
                                    adjectiveSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorSlot")));
                                    break;
                                }
                                if (agreeWith instanceof SPFillerSlot) {
                                    adjectiveSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonComparatorFillerSlot")));
                                    break;
                                }
                                adjectiveSlot.setAgreesWithID(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + agreeWith.getId().toString().substring(agreeWith.getId().toString().indexOf(58) + 1))));
                                break;
                            }
                        }
                        slotsList.add(adjectiveSlot);
                        ++order;
                    } else if (slot instanceof SPPrepositionSlot) {
                        SPPrepositionSlot prepSlot = new SPPrepositionSlot((SPPrepositionSlot)slot);
                        prepSlot.setId(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + prepSlot.getId().toString().substring(prepSlot.getId().toString().indexOf(58) + 1))));
                        prepSlot.setOrder(order);
                        slotsList.add(prepSlot);
                        ++order;
                    } else if (slot instanceof SPStringSlot) {
                        stringSlot = new SPStringSlot((SPStringSlot)slot);
                        stringSlot.setId(NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "-" + comparison.getType() + "_" + lang + "_" + "comparisonReminderSlot" + "_" + stringSlot.getId().toString().substring(stringSlot.getId().toString().indexOf(58) + 1))));
                        stringSlot.setOrder(order);
                        slotsList.add(stringSlot);
                        ++order;
                    }
                }
                ++i;
            }
        }
        Collections.sort(sentencePlan.getSlotsList());
        for (SPSlot slot : sentencePlan.getSlotsList()) {
            slot.setOrder(order);
            slotsList.add(slot);
            ++order;
        }
        IRI compSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + sentencePlan.getSentencePlanIRI().getFragment() + "-" + comparison.getType() + "_" + comparison.getValueIRI().getFragment() + "_" + lang));
        SentencePlan compSP = new SentencePlan(slotsList, compSPEN_IRI, false, sentencePlan.getLanguage(), true);
        return compSP;
    }

    public static SentencePlan generateSentencePlanForUniqueComparison(SentencePlan sentencePlan) {
        String lang = "";
        if (Languages.isEnglish(sentencePlan.getLanguage())) {
            lang = "EN";
        } else if (Languages.isGreek(sentencePlan.getLanguage())) {
            lang = "GR";
        }
        ArrayList<SPSlot> slotsList = new ArrayList<SPSlot>(sentencePlan.getSlotsList());
        SPStringSlot stringSlot = Languages.isEnglish(sentencePlan.getLanguage()) ? new SPStringSlot("of the collection", NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "_" + "UNIQUE" + "_" + lang + "_" + "comparisonCollectionSlot")), slotsList.size()) : new SPStringSlot("\u03c4\u03b7\u03c2 \u03c3\u03c5\u03bb\u03bb\u03bf\u03b3\u03ae\u03c2", NodeID.getNodeID((String)(String.valueOf(sentencePlan.getSentencePlanIRI().getFragment()) + "_" + "UNIQUE" + "_" + lang + "_" + "comparisonCollectionSlot")), slotsList.size());
        slotsList.add(stringSlot);
        IRI uniqueSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + sentencePlan.getSentencePlanIRI().getFragment() + "-" + "UNIQUE" + "SP" + lang));
        SentencePlan uniqueSP = new SentencePlan(slotsList, uniqueSPEN_IRI, false, sentencePlan.getLanguage(), true);
        return uniqueSP;
    }

    public static NLName generateNLNameForComparison(NLName name, Comparison comparison, boolean entityMentioned) {
        String lang = "";
        if (Languages.isEnglish(name.getLanguage())) {
            lang = "EN";
        } else if (Languages.isGreek(name.getLanguage())) {
            lang = "GR";
        }
        ArrayList<NLNSlot> slotsList = new ArrayList<NLNSlot>();
        for (NLNSlot slot : name.getSlotsList()) {
            if (slot instanceof NLNNounSlot) {
                slotsList.add(new NLNNounSlot((NLNNounSlot)slot));
                continue;
            }
            if (slot instanceof NLNPrepositionSlot) {
                slotsList.add(new NLNPrepositionSlot((NLNPrepositionSlot)slot));
                continue;
            }
            if (slot instanceof NLNStringSlot) {
                slotsList.add(new NLNStringSlot((NLNStringSlot)slot));
                continue;
            }
            if (slot instanceof NLNArticleSlot) {
                slotsList.add(new NLNArticleSlot((NLNArticleSlot)slot));
                continue;
            }
            if (slot instanceof NLNAdjectiveSlot) {
                slotsList.add(new NLNAdjectiveSlot((NLNAdjectiveSlot)slot));
                continue;
            }
            slotsList.add(new NLNSlot(slot));
        }
        Collections.sort(slotsList);
        String cas = "accusative";
        String gen = "masculineOrFeminine";
        String num = "singular";
        NodeID agreeID = null;
        for (NLNSlot slot : slotsList) {
            if (slot instanceof NLNArticleSlot) {
                gen = ((NLNArticleSlot)slotsList.get(0)).getGender();
            }
            if (slot instanceof NLNNounSlot) {
                if (!((NLNNounSlot)slot).isHead()) continue;
                cas = ((NLNNounSlot)slot).getCase();
                num = ((NLNNounSlot)slot).getNumber();
                agreeID = ((NLNNounSlot)slot).getId();
                continue;
            }
            if (!(slot instanceof NLNAdjectiveSlot) || !((NLNAdjectiveSlot)slot).isHead()) continue;
            cas = ((NLNNounSlot)slot).getCase();
            num = ((NLNNounSlot)slot).getNumber();
            agreeID = ((NLNAdjectiveSlot)slot).getId();
        }
        int slotsAdded = 0;
        if (!(comparison instanceof ComparisonFullCollection)) {
            NLNArticleSlot articleSlot;
            if (comparison.isMany()) {
                if (slotsList.get(0) instanceof NLNArticleSlot) {
                    ((NLNArticleSlot)slotsList.get(0)).setDefinite(true);
                    if (!comparison.isSame()) {
                        ((NLNArticleSlot)slotsList.get(0)).setCase("accusative");
                        if (entityMentioned) {
                            for (NLNSlot slot : slotsList) {
                                if (slot == slotsList.get(0)) continue;
                                slot.setOrder(slot.getOrder() + 1);
                            }
                            if (agreeID == null) {
                                slotsList.add(new NLNAdjectiveSlot(otherALE_IRI, cas, gen, num, false, false, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1));
                                ++slotsAdded;
                            } else {
                                slotsList.add(new NLNAdjectiveSlot(otherALE_IRI, "", "", "", false, false, agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1));
                                ++slotsAdded;
                            }
                        }
                    }
                } else {
                    if (!comparison.isSame()) {
                        cas = "accusative";
                        if (entityMentioned) {
                            if (agreeID == null) {
                                slotsList.add(new NLNAdjectiveSlot(otherALE_IRI, cas, gen, num, false, false, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1));
                                ++slotsAdded;
                            } else {
                                slotsList.add(new NLNAdjectiveSlot(otherALE_IRI, "", "", "", false, false, agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1));
                                ++slotsAdded;
                            }
                        }
                    }
                    articleSlot = agreeID == null ? new NLNArticleSlot(true, cas, gen, num, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), slotsList.get(0).getOrder()) : new NLNArticleSlot(true, "", "", "", agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), slotsList.get(0).getOrder());
                    for (NLNSlot slot : slotsList) {
                        slot.setOrder(slot.getOrder() + 2);
                    }
                    slotsList.add(articleSlot);
                    ++slotsAdded;
                }
            } else if (slotsList.get(0) instanceof NLNArticleSlot) {
                ((NLNArticleSlot)slotsList.get(0)).setDefinite(true);
            } else {
                articleSlot = agreeID == null ? new NLNArticleSlot(true, cas, gen, num, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), ((NLNSlot)slotsList.get(0)).getOrder()) : new NLNArticleSlot(true, "", "", "", agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), ((NLNSlot)slotsList.get(0)).getOrder());
                for (NLNSlot slot : slotsList) {
                    slot.setOrder(slot.getOrder() + 1);
                }
                slotsList.add(articleSlot);
                ++slotsAdded;
            }
        } else {
            NLNAdjectiveSlot adjectiveSlot;
            ComparisonFullCollection fullComparison = (ComparisonFullCollection)comparison;
            if (fullComparison.isAll()) {
                adjectiveSlot = agreeID == null ? new NLNAdjectiveSlot(allALE_IRI, cas, gen, num, false, false, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), ((NLNSlot)slotsList.get(0)).getOrder()) : new NLNAdjectiveSlot(allALE_IRI, "", "", "", false, false, agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), ((NLNSlot)slotsList.get(0)).getOrder());
                for (NLNSlot slot : slotsList) {
                    slot.setOrder(slot.getOrder() + 1);
                }
            } else {
                adjectiveSlot = agreeID == null ? new NLNAdjectiveSlot(mostALE_IRI, cas, gen, num, false, false, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), ((NLNSlot)slotsList.get(0)).getOrder()) : new NLNAdjectiveSlot(mostALE_IRI, "", "", "", false, false, agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-CompNLN" + "_" + lang + "_" + comparison.getType() + "_" + slotsAdded)), ((NLNSlot)slotsList.get(0)).getOrder());
                if (lang.equals("EN")) {
                    for (NLNSlot slot : slotsList) {
                        slot.setOrder(slot.getOrder() + 1);
                    }
                } else {
                    for (NLNSlot slot : slotsList) {
                        if (slot.getOrder() == slotsList.get(0).getOrder()) continue;
                        slot.setOrder(slot.getOrder() + 1);
                    }
                }
            }
            slotsList.add(adjectiveSlot);
            ++slotsAdded;
        }
        IRI compSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + name.getNLNameIRI().getFragment() + "-CompNLN" + "_" + comparison.getType() + lang));
        NLName compNLN = new NLName(slotsList, compSPEN_IRI, false, false, name.getLanguage());
        return compNLN;
    }

    /*
     * WARNING - void declaration
     */
    public static NLName generateNLNameForUniqueComparison(NLName name) {
        String lang = "";
        if (Languages.isEnglish(name.getLanguage())) {
            lang = "EN";
        } else if (Languages.isGreek(name.getLanguage())) {
            lang = "GR";
        }
        ArrayList<NLNSlot> slotsList = new ArrayList<NLNSlot>(name.getSlotsList());
        Collections.sort(slotsList);
        String cas = "nominative";
        String gen = "masculineOrFeminine";
        String num = "singular";
        NodeID agreeID = null;
        for (NLNSlot slot : slotsList) {
            if (slot instanceof NLNNounSlot) {
                if (!((NLNNounSlot)slot).isHead()) continue;
                agreeID = ((NLNNounSlot)slot).getId();
                continue;
            }
            if (!(slot instanceof NLNAdjectiveSlot) || !((NLNAdjectiveSlot)slot).isHead()) continue;
            agreeID = ((NLNAdjectiveSlot)slot).getId();
        }
        int slotsAdded = 0;
        if (slotsList.get(0) instanceof NLNArticleSlot) {
            ((NLNArticleSlot)slotsList.get(0)).setDefinite(true);
            NLNAdjectiveSlot adjectiveSlot = agreeID == null ? new NLNAdjectiveSlot(onlyALE_IRI, cas, gen, num, false, false, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-" + "UNIQUE" + "NLN" + "_" + lang + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1) : new NLNAdjectiveSlot(onlyALE_IRI, "", "", "", false, false, agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-" + "UNIQUE" + "NLN" + "_" + lang + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1);
            for (NLNSlot nLNSlot : slotsList) {
                if (nLNSlot.getOrder() == slotsList.get(0).getOrder()) continue;
                nLNSlot.setOrder(nLNSlot.getOrder() + 1);
            }
            slotsList.add(adjectiveSlot);
            ++slotsAdded;
        } else {
            void var9_15;
            for (NLNSlot slot : slotsList) {
                slot.setOrder(slot.getOrder() + 2);
            }
            NLNArticleSlot articleSlot = agreeID == null ? new NLNArticleSlot(true, cas, gen, num, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-" + "UNIQUE" + "NLN" + "_" + lang + "_" + slotsAdded)), slotsList.get(0).getOrder()) : new NLNArticleSlot(true, "", "", "", agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-" + "UNIQUE" + "NLN" + "_" + lang + "_" + slotsAdded)), slotsList.get(0).getOrder());
            slotsList.add(articleSlot);
            ++slotsAdded;
            if (agreeID == null) {
                NLNAdjectiveSlot nLNAdjectiveSlot = new NLNAdjectiveSlot(onlyALE_IRI, cas, gen, num, false, false, null, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-" + "UNIQUE" + "NLN" + "_" + lang + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1);
            } else {
                NLNAdjectiveSlot nLNAdjectiveSlot = new NLNAdjectiveSlot(onlyALE_IRI, "", "", "", false, false, agreeID, NodeID.getNodeID((String)(String.valueOf(name.getNLNameIRI().getFragment()) + "-" + "UNIQUE" + "NLN" + "_" + lang + "_" + slotsAdded)), slotsList.get(0).getOrder() + 1);
            }
            slotsList.add((NLNSlot)var9_15);
            ++slotsAdded;
        }
        IRI uniqueSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + name.getNLNameIRI().getFragment() + "-" + "UNIQUE" + "NLN" + lang));
        NLName nLName = new NLName(slotsList, uniqueSPEN_IRI, false, false, name.getLanguage());
        return nLName;
    }

    public static SentencePlan generateDefaultSentencePlanForProperty(IRI propertyIRI, OWLOntology ontology, String language) {
        String plan = "";
        for (OWLAnnotationAssertionAxiom annotation : ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)propertyIRI)) {
            if (!annotation.getProperty().isLabel() || !(annotation.getValue() instanceof OWLLiteral)) continue;
            if (Languages.isEnglish(language)) {
                if (((OWLLiteral)annotation.getValue()).hasLang("en")) {
                    plan = ((OWLLiteral)annotation.getValue()).getLiteral();
                    continue;
                }
                if (((OWLLiteral)annotation.getValue()).hasLang()) continue;
                plan = ((OWLLiteral)annotation.getValue()).getLiteral();
                continue;
            }
            if (!Languages.isGreek(language) || !((OWLLiteral)annotation.getValue()).hasLang("gr") && !((OWLLiteral)annotation.getValue()).hasLang("el")) continue;
            plan = ((OWLLiteral)annotation.getValue()).getLiteral();
        }
        if (plan.isEmpty()) {
            plan = DefaultResourcesManager.spaceString(propertyIRI.getFragment(), true);
        }
        String lang = "";
        if (Languages.isEnglish(language)) {
            lang = "EN";
        } else if (Languages.isGreek(language)) {
            lang = "GR";
        }
        SPOwnerSlot ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)(String.valueOf(propertyIRI.getFragment()) + "-DefaultSP" + lang + "1")), 1);
        SPStringSlot stringSlot = new SPStringSlot(plan, NodeID.getNodeID((String)(String.valueOf(propertyIRI.getFragment()) + "-DefaultSP" + lang + "2")), 2);
        SPFillerSlot fillerSlot = new SPFillerSlot("nominative", false, NodeID.getNodeID((String)(String.valueOf(propertyIRI.getFragment()) + "-DefaultSP" + lang + "3")), 3);
        ArrayList<SPSlot> planSlots = new ArrayList<SPSlot>();
        planSlots.add(ownerSlot);
        planSlots.add(stringSlot);
        planSlots.add(fillerSlot);
        IRI DefaultSPEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + propertyIRI.getFragment() + "-DefaultSP" + lang));
        if (Languages.isEnglish(language)) {
            return new SentencePlan(planSlots, DefaultSPEN_IRI, true, "en", true);
        }
        if (Languages.isGreek(language)) {
            return new SentencePlan(planSlots, DefaultSPEN_IRI, true, "el", true);
        }
        return null;
    }

    public static NLName generateDefaultNLNameForIndividual(IRI indivIRI, OWLOntology ontology, String language) {
        String name = "";
        for (OWLAnnotationAssertionAxiom annotation : ontology.getAnnotationAssertionAxioms((OWLAnnotationSubject)indivIRI)) {
            if (!annotation.getProperty().isLabel() || !(annotation.getValue() instanceof OWLLiteral)) continue;
            if (Languages.isGreek(language) && (((OWLLiteral)annotation.getValue()).hasLang("gr") || ((OWLLiteral)annotation.getValue()).hasLang("el"))) {
                name = ((OWLLiteral)annotation.getValue()).getLiteral();
            }
            if (!Languages.isEnglish(language) && !name.isEmpty()) continue;
            if (((OWLLiteral)annotation.getValue()).hasLang("en")) {
                name = ((OWLLiteral)annotation.getValue()).getLiteral();
                continue;
            }
            if (((OWLLiteral)annotation.getValue()).hasLang()) continue;
            name = ((OWLLiteral)annotation.getValue()).getLiteral();
        }
        String lang = "";
        if (Languages.isEnglish(language)) {
            lang = "EN";
        } else if (Languages.isGreek(language)) {
            lang = "GR";
        }
        if (name.isEmpty()) {
            name = indivIRI.getFragment() != null ? DefaultResourcesManager.spaceString(indivIRI.getFragment(), false) : DefaultResourcesManager.spaceString(indivIRI.toString().substring(indivIRI.toString().lastIndexOf(47) + 1), false);
        }
        NLNStringSlot stringSlot = new NLNStringSlot(name, NodeID.getNodeID((String)(String.valueOf(indivIRI.getFragment()) + "-DefaultNLN" + lang + "1")), 1);
        ArrayList<NLNSlot> nameSlots = new ArrayList<NLNSlot>();
        nameSlots.add(stringSlot);
        IRI DefaultNLNEN_IRI = IRI.create((String)(String.valueOf(NLResourceManager.nlowlNS) + indivIRI.getFragment() + "-DefaultNLN" + lang));
        if (Languages.isEnglish(language)) {
            return new NLName(nameSlots, DefaultNLNEN_IRI, true, false, "en", true);
        }
        if (Languages.isGreek(language)) {
            return new NLName(nameSlots, DefaultNLNEN_IRI, true, false, "el", true);
        }
        return null;
    }

    public static String spaceString(String str, boolean toLowerCase) {
        StringBuilder ret = new StringBuilder(str.replaceAll("_", " ").replaceAll("-", " "));
        boolean previousDigit = false;
        boolean previousUpperCase = false;
        int i = 0;
        while (i < ret.length()) {
            if (Character.isUpperCase(ret.charAt(i))) {
                if (!previousUpperCase) {
                    ret.insert(i, " ");
                    ++i;
                }
                previousDigit = false;
                previousUpperCase = true;
            } else if (Character.isDigit(ret.charAt(i))) {
                if (!previousDigit) {
                    ret.insert(i, " ");
                    ++i;
                }
                previousDigit = true;
                previousUpperCase = false;
            } else if (ret.charAt(i) == '.') {
                if (!previousDigit && !previousUpperCase) {
                    ret.insert(i, " ");
                    ++i;
                }
            } else {
                if (previousDigit) {
                    ret.insert(i, " ");
                    ++i;
                }
                previousDigit = false;
                previousUpperCase = false;
            }
            ++i;
        }
        if (toLowerCase) {
            return ret.toString().toLowerCase().replaceAll("\\s+", " ").trim();
        }
        return ret.toString().replaceAll("\\s+", " ").trim();
    }

    public static HashMap<IRI, VerbEntryList> generateDefaultVerbs() {
        HashMap<IRI, VerbEntryList> list = new HashMap<IRI, VerbEntryList>();
        LexEntryVerbEN verbEN = new LexEntryVerbEN("be", "is", "are", "was", "were");
        LexEntryVerbGR verbGR = new LexEntryVerbGR();
        verbGR.set("active", "simple present", "1st", "singular", "\u03b5\u03af\u03bc\u03b1\u03b9");
        verbGR.set("active", "simple present", "2nd", "singular", "\u03b5\u03af\u03c3\u03b1\u03b9");
        verbGR.set("active", "simple present", "3rd", "singular", "\u03b5\u03af\u03bd\u03b1\u03b9");
        verbGR.set("active", "simple present", "1st", "plural", "\u03b5\u03af\u03bc\u03b1\u03c3\u03c4\u03b5");
        verbGR.set("active", "simple present", "2nd", "plural", "\u03b5\u03af\u03c3\u03b1\u03c3\u03c4\u03b5");
        verbGR.set("active", "simple present", "3rd", "plural", "\u03b5\u03af\u03bd\u03b1\u03b9");
        verbGR.set("active", "past continuous", "1st", "singular", "\u03ae\u03bc\u03bf\u03c5\u03bd");
        verbGR.set("active", "past continuous", "2nd", "singular", "\u03ae\u03c3\u03bf\u03c5\u03bd");
        verbGR.set("active", "past continuous", "3rd", "singular", "\u03ae\u03c4\u03b1\u03bd");
        verbGR.set("active", "past continuous", "1st", "plural", "\u03ae\u03bc\u03b1\u03c3\u03c4\u03b1\u03bd");
        verbGR.set("active", "past continuous", "2nd", "plural", "\u03ae\u03c3\u03b1\u03c3\u03c4\u03b1\u03bd");
        verbGR.set("active", "past continuous", "3rd", "plural", "\u03ae\u03c4\u03b1\u03bd");
        verbGR.set("active", "simple future", "1st", "singular", "\u03b5\u03af\u03bc\u03b1\u03b9");
        verbGR.set("active", "simple future", "2nd", "singular", "\u03b5\u03af\u03c3\u03b1\u03b9");
        verbGR.set("active", "simple future", "3rd", "singular", "\u03b5\u03af\u03bd\u03b1\u03b9");
        verbGR.set("active", "simple future", "1st", "plural", "\u03b5\u03af\u03bc\u03b1\u03c3\u03c4\u03b5");
        verbGR.set("active", "simple future", "2nd", "plural", "\u03b5\u03af\u03c3\u03b1\u03c3\u03c4\u03b5");
        verbGR.set("active", "simple future", "3rd", "plural", "\u03b5\u03af\u03bd\u03b1\u03b9");
        VerbEntryList entryList = new VerbEntryList(verbEN, verbGR);
        list.put(toBeVLE_IRI, entryList);
        verbEN = new LexEntryVerbEN("have", "has", "having", "had", "had");
        verbGR = new LexEntryVerbGR();
        verbGR.set("active", "simple present", "1st", "singular", "\u03ad\u03c7\u03c9");
        verbGR.set("active", "simple present", "2nd", "singular", "\u03ad\u03c7\u03b5\u03b9\u03c2");
        verbGR.set("active", "simple present", "3rd", "singular", "\u03ad\u03c7\u03b5\u03b9");
        verbGR.set("active", "simple present", "1st", "plural", "\u03ad\u03c7\u03bf\u03c5\u03bc\u03b5");
        verbGR.set("active", "simple present", "2nd", "plural", "\u03ad\u03c7\u03b5\u03c4\u03b5");
        verbGR.set("active", "simple present", "3rd", "plural", "\u03ad\u03c7\u03bf\u03c5\u03bd");
        verbGR.set("active", "past continuous", "1st", "singular", "\u03b5\u03af\u03c7\u03b1");
        verbGR.set("active", "past continuous", "2nd", "singular", "\u03b5\u03af\u03c7\u03b5\u03c2");
        verbGR.set("active", "past continuous", "3rd", "singular", "\u03b5\u03af\u03c7\u03b5");
        verbGR.set("active", "past continuous", "1st", "plural", "\u03b5\u03af\u03c7\u03b1\u03bc\u03b5");
        verbGR.set("active", "past continuous", "2nd", "plural", "\u03b5\u03af\u03c7\u03b1\u03c4\u03b5");
        verbGR.set("active", "past continuous", "3rd", "plural", "\u03b5\u03af\u03c7\u03b1\u03bd");
        verbGR.set("active", "simple future", "1st", "singular", "\u03ad\u03c7\u03c9");
        verbGR.set("active", "simple future", "2nd", "singular", "\u03ad\u03c7\u03b5\u03b9\u03c2");
        verbGR.set("active", "simple future", "3rd", "singular", "\u03ad\u03c7\u03b5\u03b9");
        verbGR.set("active", "simple future", "1st", "plural", "\u03ad\u03c7\u03bf\u03c5\u03bc\u03b5");
        verbGR.set("active", "simple future", "2nd", "plural", "\u03ad\u03c7\u03b5\u03c4\u03b5");
        verbGR.set("active", "simple future", "3rd", "plural", "\u03ad\u03c7\u03bf\u03c5\u03bd");
        entryList = new VerbEntryList(verbEN, verbGR);
        list.put(toHaveVLE_IRI, entryList);
        return list;
    }

    public static HashMap<IRI, AdjectiveEntryList> generateDefaultAdjectives() {
        HashMap<IRI, AdjectiveEntryList> list = new HashMap<IRI, AdjectiveEntryList>();
        LexEntryAdjectiveEN adjectiveEN = new LexEntryAdjectiveEN();
        adjectiveEN.set_form("identical");
        LexEntryAdjectiveGR adjectiveGR = new LexEntryAdjectiveGR();
        adjectiveGR.setSingularNominativeMasculine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf\u03c2");
        adjectiveGR.setSingularNominativeFeminine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b7");
        adjectiveGR.setSingularNominativeNeuter("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf");
        adjectiveGR.setPluralNominativeMasculine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf\u03b9");
        adjectiveGR.setPluralNominativeFeminine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b5\u03c2");
        adjectiveGR.setPluralNominativeNeuter("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b1");
        adjectiveGR.setSingularGenitiveMasculine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf\u03c5");
        adjectiveGR.setSingularGenitiveFeminine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b7\u03c2");
        adjectiveGR.setSingularGenitiveNeuter("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf\u03c5");
        adjectiveGR.setPluralGenitiveMasculine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveFeminine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveNeuter("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03c9\u03bd");
        adjectiveGR.setSingularAccusativeMasculine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf");
        adjectiveGR.setSingularAccusativeFeminine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b7");
        adjectiveGR.setSingularAccusativeNeuter("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf");
        adjectiveGR.setPluralAccusativeMasculine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03bf\u03c5\u03c2");
        adjectiveGR.setPluralAccusativeFeminine("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b5\u03c2");
        adjectiveGR.setPluralAccusativeNeuter("\u03c0\u03b1\u03bd\u03bf\u03bc\u03bf\u03b9\u03cc\u03c4\u03c5\u03c0\u03b1");
        AdjectiveEntryList entryList = new AdjectiveEntryList(adjectiveEN, adjectiveGR);
        list.put(identicalALE_IRI, entryList);
        adjectiveEN = new LexEntryAdjectiveEN();
        adjectiveEN.set_form("most");
        adjectiveGR = new LexEntryAdjectiveGR();
        adjectiveGR.setSingularNominativeMasculine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf\u03c2");
        adjectiveGR.setSingularNominativeFeminine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b7");
        adjectiveGR.setSingularNominativeNeuter("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf");
        adjectiveGR.setPluralNominativeMasculine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf\u03b9");
        adjectiveGR.setPluralNominativeFeminine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b5\u03c2");
        adjectiveGR.setPluralNominativeNeuter("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b1");
        adjectiveGR.setSingularGenitiveMasculine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf\u03c5");
        adjectiveGR.setSingularGenitiveFeminine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b7\u03c2");
        adjectiveGR.setSingularGenitiveNeuter("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf\u03c5");
        adjectiveGR.setPluralGenitiveMasculine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03c9\u03bd");
        adjectiveGR.setSingularAccusativeMasculine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf");
        adjectiveGR.setSingularAccusativeFeminine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b7");
        adjectiveGR.setSingularAccusativeNeuter("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf");
        adjectiveGR.setPluralAccusativeMasculine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03bf\u03c5\u03c2");
        adjectiveGR.setPluralAccusativeFeminine("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b5\u03c2");
        adjectiveGR.setPluralAccusativeNeuter("\u03c0\u03b5\u03c1\u03b9\u03c3\u03c3\u03cc\u03c4\u03b5\u03c1\u03b1");
        entryList = new AdjectiveEntryList(adjectiveEN, adjectiveGR);
        list.put(mostALE_IRI, entryList);
        adjectiveEN = new LexEntryAdjectiveEN();
        adjectiveEN.set_form("all");
        adjectiveGR = new LexEntryAdjectiveGR();
        adjectiveGR.setPluralNominativeMasculine("\u03cc\u03bb\u03bf\u03b9");
        adjectiveGR.setPluralNominativeFeminine("\u03cc\u03bb\u03b5\u03c2");
        adjectiveGR.setPluralNominativeNeuter("\u03cc\u03bb\u03b1");
        adjectiveGR.setPluralGenitiveMasculine("\u03cc\u03bb\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveFeminine("\u03cc\u03bb\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveNeuter("\u03cc\u03bb\u03c9\u03bd");
        adjectiveGR.setPluralAccusativeMasculine("\u03cc\u03bb\u03bf\u03c5\u03c2");
        adjectiveGR.setPluralAccusativeFeminine("\u03cc\u03bb\u03b5\u03c2");
        adjectiveGR.setPluralAccusativeNeuter("\u03cc\u03bb\u03b1");
        entryList = new AdjectiveEntryList(adjectiveEN, adjectiveGR);
        list.put(allALE_IRI, entryList);
        adjectiveEN = new LexEntryAdjectiveEN();
        adjectiveEN.set_form("previous");
        adjectiveGR = new LexEntryAdjectiveGR();
        adjectiveGR.setSingularNominativeMasculine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c2");
        adjectiveGR.setSingularNominativeFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b7");
        adjectiveGR.setSingularNominativeNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf");
        adjectiveGR.setPluralNominativeMasculine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03b9");
        adjectiveGR.setPluralNominativeFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b5\u03c2");
        adjectiveGR.setPluralNominativeNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b1");
        adjectiveGR.setSingularGenitiveMasculine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c5");
        adjectiveGR.setSingularGenitiveFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b7\u03c2");
        adjectiveGR.setSingularGenitiveNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c5");
        adjectiveGR.setPluralGenitiveMasculine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03c9\u03bd");
        adjectiveGR.setSingularAccusativeMasculine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf");
        adjectiveGR.setSingularAccusativeFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b7");
        adjectiveGR.setSingularAccusativeNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf");
        adjectiveGR.setPluralAccusativeMasculine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03bf\u03c5\u03c2");
        adjectiveGR.setPluralAccusativeFeminine("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b5\u03c2");
        adjectiveGR.setPluralAccusativeNeuter("\u03c0\u03c1\u03bf\u03b7\u03b3\u03bf\u03cd\u03bc\u03b5\u03bd\u03b1");
        entryList = new AdjectiveEntryList(adjectiveEN, adjectiveGR);
        list.put(prevALE_IRI, entryList);
        adjectiveEN = new LexEntryAdjectiveEN();
        adjectiveEN.set_form("other");
        adjectiveGR = new LexEntryAdjectiveGR();
        adjectiveGR.setSingularNominativeMasculine("\u03ac\u03bb\u03bb\u03bf\u03c2");
        adjectiveGR.setSingularNominativeFeminine("\u03ac\u03bb\u03bb\u03b7");
        adjectiveGR.setSingularNominativeNeuter("\u03ac\u03bb\u03bb\u03bf");
        adjectiveGR.setPluralNominativeMasculine("\u03ac\u03bb\u03bb\u03bf\u03b9");
        adjectiveGR.setPluralNominativeFeminine("\u03ac\u03bb\u03bb\u03b5\u03c2\u03b5\u03c2");
        adjectiveGR.setPluralNominativeNeuter("\u03ac\u03bb\u03bb\u03b1");
        adjectiveGR.setSingularGenitiveMasculine("\u03ac\u03bb\u03bb\u03bf\u03c5");
        adjectiveGR.setSingularGenitiveFeminine("\u03ac\u03bb\u03bb\u03b7\u03c2");
        adjectiveGR.setSingularGenitiveNeuter("\u03ac\u03bb\u03bb\u03bf\u03c5");
        adjectiveGR.setPluralGenitiveMasculine("\u03ac\u03bb\u03bb\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveFeminine("\u03ac\u03bb\u03bb\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveNeuter("\u03ac\u03bb\u03bb\u03c9\u03bd");
        adjectiveGR.setSingularAccusativeMasculine("\u03ac\u03bb\u03bb\u03bf");
        adjectiveGR.setSingularAccusativeFeminine("\u03ac\u03bb\u03bb\u03b7");
        adjectiveGR.setSingularAccusativeNeuter("\u03ac\u03bb\u03bb\u03bf");
        adjectiveGR.setPluralAccusativeMasculine("\u03ac\u03bb\u03bb\u03bf\u03c5\u03c2");
        adjectiveGR.setPluralAccusativeFeminine("\u03ac\u03bb\u03bb\u03b5\u03c2");
        adjectiveGR.setPluralAccusativeNeuter("\u03ac\u03bb\u03bb\u03b1");
        entryList = new AdjectiveEntryList(adjectiveEN, adjectiveGR);
        list.put(otherALE_IRI, entryList);
        adjectiveEN = new LexEntryAdjectiveEN();
        adjectiveEN.set_form("only");
        adjectiveGR = new LexEntryAdjectiveGR();
        adjectiveGR.setSingularNominativeMasculine("\u03bc\u03cc\u03bd\u03bf\u03c2");
        adjectiveGR.setSingularNominativeFeminine("\u03bc\u03cc\u03bd\u03b7");
        adjectiveGR.setSingularNominativeNeuter("\u03bc\u03cc\u03bd\u03bf");
        adjectiveGR.setPluralNominativeMasculine("\u03bc\u03cc\u03bd\u03bf\u03b9");
        adjectiveGR.setPluralNominativeFeminine("\u03bc\u03cc\u03bd\u03b5\u03c2");
        adjectiveGR.setPluralNominativeNeuter("\u03bc\u03cc\u03bd\u03b1");
        adjectiveGR.setSingularGenitiveMasculine("\u03bc\u03cc\u03bd\u03bf\u03c5");
        adjectiveGR.setSingularGenitiveFeminine("\u03bc\u03cc\u03bd\u03b7\u03c2");
        adjectiveGR.setSingularGenitiveNeuter("\u03bc\u03cc\u03bd\u03bf\u03c5");
        adjectiveGR.setPluralGenitiveMasculine("\u03bc\u03cc\u03bd\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveFeminine("\u03bc\u03cc\u03bd\u03c9\u03bd");
        adjectiveGR.setPluralGenitiveNeuter("\u03bc\u03cc\u03bd\u03c9\u03bd");
        adjectiveGR.setSingularAccusativeMasculine("\u03bc\u03cc\u03bd\u03bf");
        adjectiveGR.setSingularAccusativeFeminine("\u03bc\u03cc\u03bd\u03b7");
        adjectiveGR.setSingularAccusativeNeuter("\u03bc\u03cc\u03bd\u03bf");
        adjectiveGR.setPluralAccusativeMasculine("\u03bc\u03cc\u03bd\u03bf\u03c5\u03c2");
        adjectiveGR.setPluralAccusativeFeminine("\u03bc\u03cc\u03bd\u03b5\u03c2");
        adjectiveGR.setPluralAccusativeNeuter("\u03bc\u03cc\u03bd\u03b1");
        entryList = new AdjectiveEntryList(adjectiveEN, adjectiveGR);
        list.put(onlyALE_IRI, entryList);
        return list;
    }

    public static HashMap<IRI, NounEntryList> generateDefaultNouns() {
        HashMap<IRI, NounEntryList> list = new HashMap<IRI, NounEntryList>();
        LexEntryNounEN nounEN = new LexEntryNounEN();
        nounEN.setGender("neuter");
        nounEN.setNumber("both");
        nounEN.setSingular("entity");
        nounEN.setPlural("entities");
        LexEntryNounGR nounGR = new LexEntryNounGR();
        nounGR.setGender("feminine");
        nounGR.setNumber("both");
        nounGR.setSingularNominative("\u03bf\u03bd\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1");
        nounGR.setSingularGenitive("\u03bf\u03bd\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\u03c2");
        nounGR.setSingularAccusative("\u03bf\u03bd\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1");
        nounGR.setPluralNominative("\u03bf\u03bd\u03c4\u03cc\u03c4\u03b7\u03c4\u03b5\u03c2");
        nounGR.setPluralGenitive("\u03bf\u03bd\u03c4\u03bf\u03c4\u03ae\u03c4\u03c9\u03bd");
        nounGR.setPluralAccusative("\u03bf\u03bd\u03c4\u03cc\u03c4\u03b7\u03c4\u03b5\u03c2");
        NounEntryList entryList = new NounEntryList(nounEN, nounGR);
        list.put(entityNLE_IRI, entryList);
        return list;
    }

    public static ArrayList<NLName> generateDefaultNLNames(String language) {
        ArrayList<NLName> list = new ArrayList<NLName>();
        if (Languages.isEnglish(language)) {
            NLNNounSlot nounSlot = new NLNNounSlot(entityNLE_IRI, "nominative", "singular", true, false, null, NodeID.getNodeID((String)"entityNLNEN1"), 1);
            ArrayList<NLNSlot> nameSlots = new ArrayList<NLNSlot>();
            nameSlots.add(nounSlot);
            NLName name = new NLName(nameSlots, entityNLNEN_IRI, true, false, "en");
            list.add(name);
        } else if (Languages.isGreek(language)) {
            NLNNounSlot nounSlot = new NLNNounSlot(entityNLE_IRI, "nominative", "singular", true, false, null, NodeID.getNodeID((String)"entityNLNGR1"), 1);
            ArrayList<NLNSlot> nameSlots = new ArrayList<NLNSlot>();
            nameSlots.add(nounSlot);
            NLName name = new NLName(nameSlots, entityNLNGR_IRI, true, false, "el");
            list.add(name);
        }
        return list;
    }

    public static ArrayList<SentencePlan> generateDefaultSentencePlans(String language) {
        ArrayList<SentencePlan> list = new ArrayList<SentencePlan>();
        if (Languages.isEnglish(language)) {
            SPOwnerSlot ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)"isASPEN1"), 1);
            SPVerbSlot verbSlot = new SPVerbSlot(toBeVLE_IRI, "simple present", "active", "true", "", "", NodeID.getNodeID((String)"isASPEN1"), NodeID.getNodeID((String)"isASPEN2"), 2);
            SPFillerSlot fillerSlot = new SPFillerSlot("nominative", false, NodeID.getNodeID((String)"isASPEN3"), 3);
            ArrayList<SPSlot> planSlots = new ArrayList<SPSlot>();
            planSlots.add(ownerSlot);
            planSlots.add(verbSlot);
            planSlots.add(fillerSlot);
            SentencePlan plan = new SentencePlan(planSlots, isASPEN_IRI, true, "en");
            plan.setAggAllowed(true);
            list.add(plan);
            ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)"sameIndividualSPEN1"), 1);
            verbSlot = new SPVerbSlot(toBeVLE_IRI, "simple present", "active", "true", "", "", NodeID.getNodeID((String)"sameIndividualSPEN1"), NodeID.getNodeID((String)"sameIndividualSPEN2"), 2);
            SPAdjectiveSlot adjectiveSlot = new SPAdjectiveSlot(identicalALE_IRI, "", "", "", NodeID.getNodeID((String)"sameIndividualSPEN1"), NodeID.getNodeID((String)"sameIndividualSPEN3"), 3);
            SPPrepositionSlot prepSlot = new SPPrepositionSlot("to", NodeID.getNodeID((String)"sameIndividualSPEN4"), 4);
            fillerSlot = new SPFillerSlot("nominative", false, NodeID.getNodeID((String)"sameIndividualSPEN5"), 5);
            planSlots = new ArrayList();
            planSlots.add(ownerSlot);
            planSlots.add(verbSlot);
            planSlots.add(adjectiveSlot);
            planSlots.add(prepSlot);
            planSlots.add(fillerSlot);
            plan = new SentencePlan(planSlots, sameIndividualSPEN_IRI, true, "en");
            plan.setAggAllowed(true);
            list.add(plan);
            ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)"kindOfSPEN1"), 1);
            verbSlot = new SPVerbSlot(toBeVLE_IRI, "simple present", "active", "true", "", "", NodeID.getNodeID((String)"kindOfSPEN1"), NodeID.getNodeID((String)"kindOfSPEN2"), 2);
            SPStringSlot stringSlot = new SPStringSlot("a kind", NodeID.getNodeID((String)"differentIndividualSPEN3"), 3);
            prepSlot = new SPPrepositionSlot("of", NodeID.getNodeID((String)"kindOfSPEN4"), 4);
            fillerSlot = new SPFillerSlot("nominative", false, NodeID.getNodeID((String)"kindOfSPEN5"), 5);
            planSlots = new ArrayList();
            planSlots.add(ownerSlot);
            planSlots.add(verbSlot);
            planSlots.add(stringSlot);
            planSlots.add(prepSlot);
            planSlots.add(fillerSlot);
            plan = new SentencePlan(planSlots, kindOfSPEN_IRI, true, "en");
            plan.setAggAllowed(true);
            list.add(plan);
        } else if (Languages.isGreek(language)) {
            SPOwnerSlot ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)"isASPGR1"), 1);
            SPVerbSlot verbSlot = new SPVerbSlot(toBeVLE_IRI, "simple present", "active", "true", "", "", NodeID.getNodeID((String)"isASPGR1"), NodeID.getNodeID((String)"isASPGR2"), 2);
            SPFillerSlot fillerSlot = new SPFillerSlot("nominative", false, NodeID.getNodeID((String)"isASPGR3"), 3);
            ArrayList<SPSlot> planSlots = new ArrayList<SPSlot>();
            planSlots.add(ownerSlot);
            planSlots.add(verbSlot);
            planSlots.add(fillerSlot);
            SentencePlan plan = new SentencePlan(planSlots, isASPGR_IRI, true, "el");
            plan.setAggAllowed(true);
            list.add(plan);
            ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)"sameIndividualSPGR1"), 1);
            verbSlot = new SPVerbSlot(toBeVLE_IRI, "simple present", "active", "true", "", "", NodeID.getNodeID((String)"sameIndividualSPGR1"), NodeID.getNodeID((String)"sameIndividualSPGR2"), 2);
            SPAdjectiveSlot adjectiveSlot = new SPAdjectiveSlot(identicalALE_IRI, "", "", "", NodeID.getNodeID((String)"sameIndividualSPEN1"), NodeID.getNodeID((String)"sameIndividualSPEN3"), 3);
            SPPrepositionSlot prepSlot = new SPPrepositionSlot("\u03bc\u03b5", NodeID.getNodeID((String)"sameIndividualSPGR4"), 4);
            fillerSlot = new SPFillerSlot("nominative", false, NodeID.getNodeID((String)"sameIndividualSPGR5"), 5);
            planSlots = new ArrayList();
            planSlots.add(ownerSlot);
            planSlots.add(verbSlot);
            planSlots.add(adjectiveSlot);
            planSlots.add(prepSlot);
            planSlots.add(fillerSlot);
            plan = new SentencePlan(planSlots, sameIndividualSPGR_IRI, true, "el");
            plan.setAggAllowed(true);
            list.add(plan);
            ownerSlot = new SPOwnerSlot("nominative", "auto", NodeID.getNodeID((String)"kindOfSPGR1"), 1);
            verbSlot = new SPVerbSlot(toBeVLE_IRI, "simple present", "active", "true", "", "", NodeID.getNodeID((String)"kindOfSPGR1"), NodeID.getNodeID((String)"kindOfSPGR2"), 2);
            SPStringSlot stringSlot = new SPStringSlot("\u03ad\u03bd\u03b1 \u03b5\u03af\u03b4\u03bf\u03c2", NodeID.getNodeID((String)"kindOfSPGR3"), 3);
            fillerSlot = new SPFillerSlot("genitive", false, NodeID.getNodeID((String)"kindOfSPGR4"), 4);
            planSlots = new ArrayList();
            planSlots.add(ownerSlot);
            planSlots.add(verbSlot);
            planSlots.add(stringSlot);
            planSlots.add(fillerSlot);
            plan = new SentencePlan(planSlots, kindOfSPGR_IRI, true, "el");
            plan.setAggAllowed(true);
            list.add(plan);
        }
        return list;
    }
}

