/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Comparisons;

import gr.aueb.cs.nlg.Comparisons.Comparison;
import gr.aueb.cs.nlg.Comparisons.ComparisonFullCollection;
import gr.aueb.cs.nlg.Comparisons.ComparisonNode;
import gr.aueb.cs.nlg.Comparisons.ComparisonTree;
import gr.aueb.cs.nlg.Utils.XmlMsgs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.semanticweb.owlapi.model.IRI;

public class MelegkoglouAlgorithm {
    private ComparisonTree tree;
    public static HashMap<String, ArrayList<String>> mentioned = new HashMap();

    public MelegkoglouAlgorithm(ComparisonTree comparisonTree) {
        this.tree = comparisonTree;
    }

    private void step1(ComparisonNode describing) {
        for (ComparisonNode node : this.tree.getNodes()) {
            int i = 0;
            while (i < node.getProperties().size()) {
                String property = node.getProperties().get(i);
                if (!describing.getProperties().contains(property)) {
                    node.removeProperty(property);
                    --i;
                } else {
                    int index = describing.getProperties().indexOf(property);
                    String value = "";
                    Iterator<String> iterator = describing.getValueCardinality(index).keySet().iterator();
                    while (iterator.hasNext()) {
                        String val;
                        value = val = iterator.next();
                    }
                    index = node.getProperties().indexOf(property);
                    HashSet<String> values = new HashSet<String>(node.getValueCardinality(index).keySet());
                    for (String val : values) {
                        if (value.equals(val) || node.getValueCardinality(index).get(val) != 1) continue;
                        node.removeValue(property, val);
                    }
                }
                ++i;
            }
        }
    }

    private void step2Child(ComparisonNode start, ComparisonNode describing) {
        int index = 0;
        while (index < start.getProperties().size()) {
            HashSet<String> values = new HashSet<String>(start.getValueCardinality(index).keySet());
            for (String val : values) {
                if (start.getCardinality() == start.getValueCardinality(index).get(val).intValue()) {
                    for (ComparisonNode node : start.getChildren()) {
                        int valueCardinality;
                        int childIndex = node.getProperties().indexOf(start.getProperties().get(index));
                        if (childIndex < 0 || !node.getValueCardinality(childIndex).containsKey(val) || (valueCardinality = node.getValueCardinality(childIndex).get(val).intValue()) != start.getValueCardinality(index).get(val)) continue;
                        start.removeValue(start.getProperties().get(index), val);
                        this.step2Child(node, describing);
                        break;
                    }
                    if (!start.getValueCardinality(index).containsKey(val)) continue;
                    for (ComparisonNode node : start.getChildren()) {
                        node.removeValue(start.getProperties().get(index), val);
                    }
                    continue;
                }
                if (!start.getProperties().isEmpty()) {
                    start.removeValue(start.getProperties().get(index), val);
                }
                if (start.getChildren().isEmpty()) continue;
                for (ComparisonNode node : start.getChildren()) {
                    this.step2Child(node, describing);
                }
            }
            ++index;
        }
    }

    private void step2(ComparisonNode start, ComparisonNode describing) {
        int index = 0;
        while (index < start.getProperties().size()) {
            HashSet<String> values = new HashSet<String>(start.getValueCardinality(index).keySet());
            for (String val : values) {
                if (start.getCardinality() == start.getValueCardinality(index).get(val).intValue()) {
                    for (ComparisonNode node : start.getChildren()) {
                        int valueCardinality;
                        int childIndex = node.getProperties().indexOf(start.getProperties().get(index));
                        if (childIndex < 0 || !node.getValueCardinality(childIndex).containsKey(val) || (valueCardinality = node.getValueCardinality(childIndex).get(val).intValue()) != start.getValueCardinality(index).get(val)) continue;
                        start.removeValue(start.getProperties().get(index), val);
                        this.step2Child(node, describing);
                        break;
                    }
                    if (!start.getValueCardinality(index).containsKey(val)) continue;
                    for (ComparisonNode node : start.getChildren()) {
                        node.removeValue(start.getProperties().get(index), val);
                    }
                    continue;
                }
                if (!start.getProperties().isEmpty()) {
                    start.removeValue(start.getProperties().get(index), val);
                }
                if (start.getChildren().isEmpty()) continue;
                for (ComparisonNode node : start.getChildren()) {
                    this.step2Child(node, describing);
                }
            }
            ++index;
        }
        if (start.getParent() != null) {
            this.step2(start.getParent(), describing);
        }
    }

    private void step2ChildBlur(ComparisonNode start, ComparisonNode describing) {
        int index = 0;
        while (index < start.getProperties().size()) {
            HashSet<String> values = new HashSet<String>(start.getValueCardinality(index).keySet());
            for (String val : values) {
                if (start.getCardinality() == start.getValueCardinality(index).get(val).intValue()) {
                    for (ComparisonNode node : start.getChildren()) {
                        int valueCardinality;
                        int childIndex = node.getProperties().indexOf(start.getProperties().get(index));
                        if (childIndex < 0 || !node.getValueCardinality(childIndex).containsKey(val) || (valueCardinality = node.getValueCardinality(childIndex).get(val).intValue()) != start.getValueCardinality(index).get(val)) continue;
                        start.removeValue(start.getProperties().get(index), val);
                        this.step2Child(node, describing);
                        break;
                    }
                    if (!start.getValueCardinality(index).containsKey(val)) continue;
                    for (ComparisonNode node : start.getChildren()) {
                        node.removeValue(start.getProperties().get(index), val);
                    }
                    continue;
                }
                if (!start.getProperties().isEmpty()) {
                    start.removeValue(start.getProperties().get(index), val);
                }
                if (start.getChildren().isEmpty()) continue;
                for (ComparisonNode node : start.getChildren()) {
                    this.step2Child(node, describing);
                }
            }
            ++index;
        }
    }

    private void step2Blur(ComparisonNode start, ComparisonNode describing) {
        int index = 0;
        while (index < start.getProperties().size()) {
            HashSet<String> values = new HashSet<String>(start.getValueCardinality(index).keySet());
            for (String val : values) {
                if ((double)start.getValueCardinality(index).get(val).intValue() >= 0.8 * (double)start.getCardinality()) {
                    for (ComparisonNode node : start.getChildren()) {
                        int valueCardinality;
                        int childIndex = node.getProperties().indexOf(start.getProperties().get(index));
                        if (childIndex < 0 || !node.getValueCardinality(childIndex).containsKey(val) || (valueCardinality = node.getValueCardinality(childIndex).get(val).intValue()) != start.getValueCardinality(index).get(val)) continue;
                        start.removeValue(start.getProperties().get(index), val);
                        this.step2ChildBlur(node, describing);
                        break;
                    }
                    if (!start.getValueCardinality(index).containsKey(val)) continue;
                    for (ComparisonNode node : start.getChildren()) {
                        node.removeValue(start.getProperties().get(index), val);
                    }
                    continue;
                }
                if (!start.getProperties().isEmpty()) {
                    start.removeValue(start.getProperties().get(index), val);
                }
                if (start.getChildren().isEmpty()) continue;
                for (ComparisonNode node : start.getChildren()) {
                    this.step2ChildBlur(node, describing);
                }
            }
            ++index;
        }
        if (start.getParent() != null) {
            this.step2(start.getParent(), describing);
        }
    }

    private ComparisonNode step3(ComparisonNode start) {
        if (start.getAge() > 10) {
            ArrayList<String> properties = new ArrayList<String>(start.getProperties());
            for (String property : properties) {
                start.removeProperty(property);
            }
            start.clear();
        }
        if (mentioned.containsKey(start.getType())) {
            for (String property : mentioned.get(start.getType())) {
                start.removeProperty(property);
            }
            start.clear();
        }
        if (!start.getProperties().isEmpty() && !start.getType().equals("owl:Thing")) {
            return start;
        }
        if (start.getParent() != null) {
            for (ComparisonNode node : start.getParent().getChildren()) {
                node.clear();
                if (node.getProperties().isEmpty() || node.getType().equals("owl:Thing") || node.getType().equals(start.getType())) continue;
                return this.step3(node);
            }
        }
        for (ComparisonNode node : start.getChildren()) {
            node.clear();
            if (node.getProperties().isEmpty() || node.getType().equals("owl:Thing")) continue;
            return this.step3(node);
        }
        for (ComparisonNode node : this.tree.getNodes()) {
            node.clear();
            if (node.getProperties().isEmpty() || node.getType().equals("owl:Thing")) continue;
            return this.step3(node);
        }
        return null;
    }

    public Comparison compareBlur(ComparisonNode describing) {
        if (this.tree.getRoot() == null || this.tree.getNodes().size() < 5) {
            return null;
        }
        String name = describing.getType();
        ComparisonNode start = this.tree.find(name);
        this.step1(describing);
        this.step2Blur(start, describing);
        start.clear();
        ComparisonNode comparator = this.step3(start);
        if (comparator != null) {
            Random r = new Random();
            boolean same = false;
            int choice = r.nextInt(comparator.getProperties().size());
            String property = comparator.getProperties().get(choice);
            for (String value : describing.getValueCardinality(describing.getProperties().indexOf(property)).keySet()) {
                if (!comparator.getValueCardinality(choice).containsKey(value)) continue;
                same = true;
            }
            Comparison comparison = new Comparison(same, comparator.getType(), property, false, comparator.getCardinality() > 1, start.getValue(property));
            return comparison;
        }
        return null;
    }

    public Comparison compare(ComparisonNode describing) {
        if (this.tree.getRoot() == null) {
            return null;
        }
        String name = describing.getType();
        ComparisonNode start = this.tree.find(name);
        this.step1(describing);
        this.step2(start, describing);
        start.clear();
        ComparisonNode comparator = this.step3(start);
        if (comparator != null) {
            Random r = new Random();
            boolean same = false;
            int choice = r.nextInt(comparator.getProperties().size());
            String property = comparator.getProperties().get(choice);
            for (String value : describing.getValueCardinality(describing.getProperties().indexOf(property)).keySet()) {
                if (!comparator.getValueCardinality(choice).containsKey(value)) continue;
                same = true;
            }
            Comparison comparison = new Comparison(same, comparator.getType(), property, true, comparator.getCardinality() > 1, comparator.getValue(property));
            if (!comparison.isSame()) {
                ArrayList<String> propertiesMentioned = mentioned.get(comparison.getComparator());
                if (propertiesMentioned == null) {
                    propertiesMentioned = new ArrayList();
                }
                propertiesMentioned.add(property);
                mentioned.put(comparison.getComparator(), propertiesMentioned);
            }
            return comparison;
        }
        return null;
    }

    public Comparison detectUnique(ComparisonNode describing) {
        String name = describing.getType();
        ComparisonNode start = this.tree.find(name);
        if (start.getCardinality() == 1 && (this.tree.areComparisonsAllowed(IRI.create((String)(String.valueOf(XmlMsgs.prefix) + ":" + "isA"))) || this.tree.areComparisonsAllowed(IRI.create((String)(String.valueOf(XmlMsgs.prefix) + ":instanceOf"))))) {
            return new Comparison(true, start.getType(), "#" + XmlMsgs.prefix + ":" + "isA", true, false, start.getValue(String.valueOf(XmlMsgs.prefix) + ":" + "isA"));
        }
        return null;
    }

    public ComparisonFullCollection compareFullCollection(ComparisonNode describing) {
        String name = describing.getType();
        ComparisonNode start = this.tree.find(name);
        if (start.getCardinality() < 2) {
            return null;
        }
        int i = 0;
        while (i < this.tree.getNodes().size()) {
            if (this.tree.getNodes().get(i).getCardinality() == 1) {
                this.tree.remove(this.tree.getNodes().get(i));
            }
            ++i;
        }
        i = 0;
        while (i < start.getProperties().size()) {
            String property = start.getProperties().get(i);
            HashSet<String> values = new HashSet<String>(start.getValueCardinality(i).keySet());
            for (String value : values) {
                if (start.getValueCardinality(i).get(value).intValue() == start.getCardinality()) continue;
                start.removeValue(property, value);
            }
            ++i;
        }
        start.clear();
        if (!start.getProperties().isEmpty()) {
            ArrayList<String> newList;
            Random r = new Random();
            int choice = r.nextInt(start.getProperties().size());
            String property = start.getProperties().get(choice);
            if (!mentioned.containsKey(start.getType())) {
                newList = mentioned.get(start.getType());
                if (newList == null) {
                    newList = new ArrayList();
                }
                newList.add(property);
                mentioned.put(start.getType(), newList);
                return new ComparisonFullCollection(true, start.getType(), property, true, true, start.getValue(property));
            }
            if (!mentioned.get(start.getType()).contains(property)) {
                newList = mentioned.get(start.getType());
                if (newList == null) {
                    newList = new ArrayList();
                }
                newList.add(property);
                mentioned.put(start.getType(), newList);
                return new ComparisonFullCollection(true, start.getType(), property, true, true, start.getValue(property));
            }
        }
        return null;
    }

    public ComparisonFullCollection compareFullCollectionBlur(ComparisonNode describing) {
        String name = describing.getType();
        ComparisonNode start = this.tree.find(name);
        if (start.getCardinality() < 5) {
            return null;
        }
        int i = 0;
        while (i < this.tree.getNodes().size()) {
            if (this.tree.getNodes().get(i).getCardinality() == 1) {
                this.tree.remove(this.tree.getNodes().get(i));
            }
            ++i;
        }
        i = 0;
        while (i < start.getProperties().size()) {
            String property = start.getProperties().get(i);
            ArrayList<String> values = new ArrayList<String>(start.getValueCardinality(i).keySet());
            for (String value : values) {
                if (!((double)start.getValueCardinality(i).get(value).intValue() < 0.8 * (double)start.getCardinality())) continue;
                start.removeValue(property, value);
            }
            ++i;
        }
        start.clear();
        while (!start.getProperties().isEmpty()) {
            ArrayList<String> newList;
            Random r = new Random();
            int choice = r.nextInt(start.getProperties().size());
            String property = start.getProperties().get(choice);
            if (!mentioned.containsKey(start.getType())) {
                newList = mentioned.get(start.getType());
                if (newList == null) {
                    newList = new ArrayList();
                }
                newList.add(property);
                mentioned.put(start.getType(), newList);
                boolean same = false;
                for (String value : describing.getValueCardinality(describing.getProperties().indexOf(property)).keySet()) {
                    if (!start.getValueCardinality(choice).keySet().contains(value)) continue;
                    same = true;
                }
                return new ComparisonFullCollection(same, start.getType(), property, false, true, start.getValue(property));
            }
            if (!mentioned.get(start.getType()).contains(property)) {
                newList = mentioned.get(start.getType());
                if (newList == null) {
                    newList = new ArrayList();
                }
                newList.add(property);
                mentioned.put(start.getType(), newList);
                boolean same = false;
                for (String value : describing.getValueCardinality(describing.getProperties().indexOf(property)).keySet()) {
                    if (!start.getValueCardinality(choice).keySet().contains(value)) continue;
                    same = true;
                }
                return new ComparisonFullCollection(same, start.getType(), property, false, true, start.getValue(property));
            }
            start.removeProperty(property);
            start.clear();
        }
        return null;
    }
}

