/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Comparisons;

import gr.aueb.cs.nlg.Comparisons.ComparisonNode;
import gr.aueb.cs.nlg.NLFiles.MappingQueryManager;
import gr.aueb.cs.nlg.NLGEngine.NLGEngine;
import gr.aueb.cs.nlg.Utils.Fact;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class ComparisonTree
implements Cloneable {
    private static final String lt_OR_gt_regex = "[<>]";
    private static final String Thing = "owl:Thing";
    private ComparisonNode root;
    private ArrayList<ComparisonNode> nodes;
    private OWLOntologyManager manager;
    private ArrayList<String> entities;
    private MappingQueryManager MQM;

    public ComparisonTree(OWLOntologyManager manager, MappingQueryManager MQM) {
        this.MQM = MQM;
        this.manager = manager;
        this.entities = new ArrayList();
        this.nodes = new ArrayList();
        this.root = null;
    }

    public ComparisonTree(ComparisonTree oldTree) {
        this.MQM = oldTree.MQM;
        this.manager = oldTree.manager;
        this.root = null;
        this.nodes = new ArrayList();
        this.entities = new ArrayList<String>(oldTree.entities);
        int i = 0;
        while (i < oldTree.nodes.size()) {
            this.nodes.add(new ComparisonNode(oldTree.nodes.get(i)));
            if (oldTree.getRoot().getType().equals(oldTree.nodes.get(i).getType())) {
                this.root = this.nodes.get(i);
            }
            ++i;
        }
        i = 0;
        while (i < oldTree.nodes.size()) {
            if (oldTree.nodes.get(i).getParent() != null) {
                int parentIndex = oldTree.nodes.indexOf(oldTree.nodes.get(i).getParent());
                this.nodes.get(i).setParent(this.nodes.get(parentIndex));
            }
            ++i;
        }
    }

    public boolean contains(String entity) {
        return this.entities.contains(entity);
    }

    public boolean comparatorIncludes(String entity, String comparator) {
        ArrayList<String> entityParents = new ArrayList<String>();
        String parent = this.findParent(IRI.create((String)entity));
        while (!parent.equals(Thing)) {
            entityParents.add(parent);
            parent = this.findParent(IRI.create((String)parent));
        }
        entityParents.add(Thing);
        return entityParents.contains(comparator);
    }

    public boolean areComparisonsAllowed(IRI iri) {
        return this.MQM.areComparisonsAllowed(iri);
    }

    public void removeEntity(IRI iri) {
        ArrayList<Fact> temp = this.getFacts(iri);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Fact fact : temp) {
            if (!this.MQM.areComparisonsAllowed(fact.getPredicate())) continue;
            facts.add(fact);
        }
        String parentName = this.findParent(iri);
        for (ComparisonNode node : this.nodes) {
            String value;
            String property;
            if (!node.getType().equals(parentName)) continue;
            for (Fact fact : facts) {
                property = fact.getPredicate().toString();
                if (property.equalsIgnoreCase("isA")) continue;
                value = fact.getObject();
                node.decreaceCardinality(property, value);
            }
            node.setCardinality(node.getCardinality() - 1);
            node.clear();
            while (node.getParent() != null) {
                node = node.getParent();
                for (Fact fact : facts) {
                    property = fact.getPredicate().toString();
                    if (property.equalsIgnoreCase("isA")) continue;
                    value = fact.getObject();
                    node.decreaceCardinality(property, value);
                }
                node.setCardinality(node.getCardinality() - 1);
                node.clear();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void add(IRI iri) {
        String name;
        if (this.entities.contains(iri.toString())) {
            String parent = this.findParent(iri);
            for (ComparisonNode node : this.nodes) {
                if (!node.getType().equals(parent)) continue;
                node.setAge(1);
                while (node.getParent() != null) {
                    node = node.getParent();
                    node.setAge(1);
                }
            }
            return;
        }
        this.entities.add(iri.toString());
        ArrayList<Fact> temp = this.getFacts(iri);
        ArrayList<Fact> facts = new ArrayList<Fact>();
        for (Fact fact : temp) {
            if (!this.MQM.areComparisonsAllowed(fact.getPredicate())) continue;
            facts.add(fact);
        }
        if (this.nodes.isEmpty()) {
            if (NLGEngine.isClass(this.manager.getOntologies(), iri)) {
                name = iri.toString();
                String string = this.findParent(iri);
                ComparisonNode node = new ComparisonNode(name);
                if (!string.isEmpty()) {
                    this.root = new ComparisonNode(string);
                    node.setParent(this.root);
                    this.nodes.add(this.root);
                } else {
                    this.root = node;
                }
                this.nodes.add(node);
                for (Fact fact : facts) {
                    String property = fact.getPredicate().toString();
                    if (property.equalsIgnoreCase("isA")) continue;
                    node.addProperty(property, fact.getObject());
                    if (this.root == node) continue;
                    this.root.addProperty(property, fact.getObject());
                }
            } else {
                name = this.findParent(iri);
                if (name.isEmpty()) {
                    return;
                }
                this.root = new ComparisonNode(name);
                for (Fact fact : facts) {
                    String property = fact.getPredicate().toString();
                    if (property.equalsIgnoreCase("isA")) continue;
                    String value = fact.getObject();
                    this.root.addProperty(property, value);
                }
                this.nodes.add(this.root);
            }
        } else {
            for (ComparisonNode node : this.nodes) {
                node.setAge(node.getAge() + 1);
            }
            for (ComparisonNode node : this.nodes) {
                String value;
                String property;
                if (!node.getType().equals(iri.toString())) continue;
                node.increaseCardinality();
                for (Fact fact : facts) {
                    property = fact.getPredicate().toString();
                    if (property.equalsIgnoreCase("isA")) continue;
                    value = fact.getObject();
                    node.addProperty(property, value);
                }
                while (node != this.root) {
                    node = node.getParent();
                    node.increaseCardinality();
                    for (Fact fact : facts) {
                        property = fact.getPredicate().toString();
                        if (property.equalsIgnoreCase("isA")) continue;
                        value = fact.getObject();
                        node.addProperty(property, value);
                    }
                }
                return;
            }
            name = this.findParent(iri);
            for (ComparisonNode comparisonNode : this.nodes) {
                void var5_18;
                String value;
                String property;
                if (!comparisonNode.getType().equals(name)) continue;
                if (NLGEngine.isClass(this.manager.getOntologies(), iri)) {
                    void var5_16;
                    comparisonNode.increaseCardinality();
                    ComparisonNode child = new ComparisonNode(iri.toString());
                    for (Fact fact : facts) {
                        String property2 = fact.getPredicate().toString();
                        if (property2.equalsIgnoreCase("isA")) continue;
                        String value2 = fact.getObject();
                        child.addProperty(property2, value2);
                        comparisonNode.addProperty(property2, value2);
                    }
                    child.setParent(comparisonNode);
                    while (var5_16 != this.root) {
                        ComparisonNode comparisonNode2 = var5_16.getParent();
                        comparisonNode2.increaseCardinality();
                        for (Fact fact : facts) {
                            String property2 = fact.getPredicate().toString();
                            if (property2.equalsIgnoreCase("isA")) continue;
                            String value2 = fact.getObject();
                            comparisonNode2.addProperty(property2, value2);
                        }
                    }
                    this.nodes.add(child);
                    return;
                }
                comparisonNode.increaseCardinality();
                for (Fact fact : facts) {
                    property = fact.getPredicate().toString();
                    if (property.equalsIgnoreCase("isA")) continue;
                    value = fact.getObject();
                    comparisonNode.addProperty(property, value);
                }
                while (var5_18 != this.root) {
                    ComparisonNode comparisonNode3 = var5_18.getParent();
                    comparisonNode3.increaseCardinality();
                    for (Fact fact : facts) {
                        property = fact.getPredicate().toString();
                        if (property.equalsIgnoreCase("isA")) continue;
                        value = fact.getObject();
                        comparisonNode3.addProperty(property, value);
                    }
                }
                return;
            }
            if (NLGEngine.isClass(this.manager.getOntologies(), iri)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(iri.toString());
                String parent = this.findParent(iri);
                while (!parent.equals(Thing)) {
                    arrayList.add(parent);
                    parent = this.findParent(IRI.create((String)parent));
                }
                arrayList.add(Thing);
                ArrayList<String> rootSuperClasses = new ArrayList<String>();
                rootSuperClasses.add(this.root.getType());
                parent = this.findParent(IRI.create((String)this.root.getType()));
                while (!parent.equals(Thing)) {
                    rootSuperClasses.add(parent);
                    parent = this.findParent(IRI.create((String)parent));
                }
                rootSuperClasses.add(Thing);
                if (!((String)rootSuperClasses.get(rootSuperClasses.size() - 1)).equals(this.root.getType())) {
                    int i = 0;
                    while (i < rootSuperClasses.size()) {
                        if (!this.root.getType().equals(rootSuperClasses.get(i))) {
                            this.newRoot(new ComparisonNode((String)rootSuperClasses.get(i)));
                        }
                        ++i;
                    }
                }
                if (rootSuperClasses.contains(iri.toString())) {
                    this.add(iri);
                } else {
                    HashSet<String> iris = new HashSet<String>();
                    for (ComparisonNode node : this.nodes) {
                        iris.add(node.getType());
                    }
                    int i = arrayList.size() - 1;
                    while (i > 0) {
                        if (!iris.contains(arrayList.get(i))) {
                            this.addEmptyNode(IRI.create((String)((String)arrayList.get(i))));
                        }
                        --i;
                    }
                    this.add(iri);
                }
            } else {
                String string = this.findParent(iri);
                ArrayList<String> subjectSuperClasses = new ArrayList<String>();
                subjectSuperClasses.add(iri.toString());
                String parent = this.findParent(iri);
                while (!parent.equals(Thing)) {
                    if (!subjectSuperClasses.contains(parent)) {
                        subjectSuperClasses.add(parent);
                        parent = this.findParent(IRI.create((String)parent));
                        continue;
                    }
                    parent = Thing;
                }
                subjectSuperClasses.add(Thing);
                ArrayList<String> rootSuperClasses = new ArrayList<String>();
                rootSuperClasses.add(this.root.getType());
                parent = this.findParent(IRI.create((String)this.root.getType()));
                while (!parent.equals(Thing)) {
                    rootSuperClasses.add(parent);
                    parent = this.findParent(IRI.create((String)parent));
                }
                rootSuperClasses.add(Thing);
                if (!((String)rootSuperClasses.get(rootSuperClasses.size() - 1)).equals(this.root.getType())) {
                    int i = 0;
                    while (i < rootSuperClasses.size()) {
                        if (!this.root.getType().equals(rootSuperClasses.get(i))) {
                            this.newRoot(new ComparisonNode((String)rootSuperClasses.get(i)));
                        }
                        ++i;
                    }
                }
                HashSet<String> iris = new HashSet<String>();
                for (ComparisonNode node : this.nodes) {
                    iris.add(node.getType());
                }
                int i = subjectSuperClasses.size() - 1;
                while (i > 0) {
                    if (!iris.contains(subjectSuperClasses.get(i))) {
                        this.addEmptyNode(IRI.create((String)((String)subjectSuperClasses.get(i))));
                    }
                    --i;
                }
                for (ComparisonNode node : this.nodes) {
                    String value;
                    String property;
                    if (!node.getType().equals(string)) continue;
                    node.increaseCardinality();
                    for (Fact fact : facts) {
                        property = fact.getPredicate().toString();
                        if (property.equalsIgnoreCase("isA")) continue;
                        value = fact.getObject();
                        node.addProperty(property, value);
                    }
                    while (node != this.root) {
                        node = node.getParent();
                        node.increaseCardinality();
                        for (Fact fact : facts) {
                            property = fact.getPredicate().toString();
                            if (property.equalsIgnoreCase("isA")) continue;
                            value = fact.getObject();
                            node.addProperty(property, value);
                        }
                    }
                }
            }
        }
    }

    private ArrayList<Fact> getFacts(IRI iri) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (!NLGEngine.isClass(this.manager.getOntologies(), iri)) {
            HashSet ent = new HashSet();
            HashSet axioms = new HashSet();
            for (OWLOntology model : this.manager.getOntologies()) {
                ent.addAll(model.getEntitiesInSignature(iri));
                for (OWLEntity entity : ent) {
                    axioms.addAll(entity.getReferencingAxioms(model));
                    for (OWLAxiom axiom : axioms) {
                        if (axiom.getAxiomType().equals(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
                            Set properties = axiom.getObjectPropertiesInSignature();
                            String property = "";
                            for (OWLObjectProperty prop : properties) {
                                property = prop.toString().replaceAll(lt_OR_gt_regex, "");
                            }
                            Set objs = axiom.getIndividualsInSignature();
                            String object = "";
                            for (OWLNamedIndividual obj : objs) {
                                if (obj.toString().replaceAll(lt_OR_gt_regex, "").equals(iri.toString())) continue;
                                object = obj.toString().replaceAll(lt_OR_gt_regex, "");
                            }
                            Fact fact = new Fact(iri, IRI.create((String)property), object);
                            if (facts.contains(fact)) continue;
                            facts.add(fact);
                            continue;
                        }
                        if (!axiom.getAxiomType().equals(AxiomType.CLASS_ASSERTION)) continue;
                        Set classes = axiom.getClassesInSignature();
                        String parent = "";
                        for (OWLClass clas : classes) {
                            parent = clas.toString().replaceAll(lt_OR_gt_regex, "");
                        }
                        Fact fact = new Fact(iri, IRI.create((String)"isA"), parent);
                        if (facts.contains(fact)) continue;
                        facts.add(fact);
                    }
                }
            }
        } else {
            for (OWLOntology model : this.manager.getOntologies()) {
                for (OWLEntity cls : model.getEntitiesInSignature(iri)) {
                    for (OWLAxiom axiom : model.getAxioms((OWLClass)cls)) {
                        String property = "";
                        if (axiom.getObjectPropertiesInSignature().isEmpty()) continue;
                        for (OWLObjectProperty prop : axiom.getObjectPropertiesInSignature()) {
                            property = prop.toString();
                            property = property.substring(1, property.length() - 1);
                        }
                        for (OWLNamedIndividual indiv : axiom.getIndividualsInSignature()) {
                            Fact fact;
                            String individual = indiv.toString();
                            individual = individual.substring(1, individual.length() - 1);
                            if (property.isEmpty() || facts.contains(fact = new Fact(iri, IRI.create((String)property), individual))) continue;
                            facts.add(fact);
                        }
                    }
                }
            }
        }
        return facts;
    }

    private void addEmptyNode(IRI iri) {
        ComparisonNode newNode = new ComparisonNode(iri.toString());
        newNode.setCardinality(0);
        String name = this.findParent(iri);
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i).getType().equals(name)) {
                this.nodes.add(newNode);
                newNode.setParent(this.nodes.get(i));
            }
            ++i;
        }
    }

    public String findParent(IRI iri) {
        if (!NLGEngine.isClass(this.manager.getOntologies(), iri)) {
            for (OWLOntology model : this.manager.getOntologies()) {
                for (OWLEntity individual : model.getEntitiesInSignature(iri)) {
                    Set axioms = individual.getReferencingAxioms(model);
                    for (OWLAxiom axiom : axioms) {
                        Iterator iterator;
                        if (!axiom.getAxiomType().equals(AxiomType.CLASS_ASSERTION) || !(iterator = axiom.getClassesInSignature().iterator()).hasNext()) continue;
                        OWLClass clas = (OWLClass)iterator.next();
                        return clas.toString().replaceAll(lt_OR_gt_regex, "");
                    }
                }
            }
        } else {
            HashSet classes = new HashSet();
            for (OWLOntology model : this.manager.getOntologies()) {
                classes.addAll(model.getEntitiesInSignature(iri));
            }
            for (OWLEntity owlClass : classes) {
                if (!owlClass.isOWLClass()) continue;
                Set superClasses = new HashSet();
                for (OWLOntology model : this.manager.getOntologies()) {
                    superClasses.addAll(owlClass.asOWLClass().getSuperClasses(model));
                }
                HashSet superClassesCopy = new HashSet(superClasses);
                for (OWLClassExpression expr : superClassesCopy) {
                    if (expr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) {
                        return expr.toString().replaceAll(lt_OR_gt_regex, "");
                    }
                    if (expr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) {
                        for (OWLEntity clas : expr.getClassesInSignature()) {
                            if (clas.toString().replaceAll(lt_OR_gt_regex, "").equals(Thing)) continue;
                            return clas.toString().replaceAll(lt_OR_gt_regex, "");
                        }
                        continue;
                    }
                    superClasses.remove(expr);
                }
                if (superClasses.isEmpty()) {
                    for (OWLOntology model : this.manager.getOntologies()) {
                        superClasses = owlClass.asOWLClass().getEquivalentClasses(model);
                    }
                }
                if (superClasses.isEmpty()) {
                    OWLEntity clas;
                    HashSet superClasses2 = new HashSet();
                    for (OWLOntology model : this.manager.getOntologies()) {
                        superClasses2.addAll(owlClass.asOWLClass().getReferencingAxioms(model, true));
                    }
                    clas = superClasses2.iterator();
                    while (clas.hasNext()) {
                        String[] referingclasses;
                        OWLAxiom axiom = (OWLAxiom)clas.next();
                        if (axiom.getAxiomType().equals(AxiomType.SUBCLASS_OF) && (referingclasses = axiom.toString().substring(11, axiom.toString().length() - 1).replaceAll(lt_OR_gt_regex, "").split(" "))[0].equals(iri.toString()) && NLGEngine.isClass(this.manager.getOntologies(), IRI.create((String)referingclasses[1]))) {
                            return referingclasses[1];
                        }
                        if (!axiom.getAxiomType().equals(AxiomType.EQUIVALENT_CLASSES)) continue;
                        referingclasses = axiom.toString().substring(18, axiom.toString().length() - 1).replaceAll(lt_OR_gt_regex, "").split(" ");
                        if (!NLGEngine.isClass(this.manager.getOntologies(), IRI.create((String)referingclasses[0])) || !iri.toString().equals(referingclasses[0]) || !referingclasses[1].startsWith("ObjectIntersectionOf")) continue;
                        return referingclasses[1].split("[(]")[1];
                    }
                }
                for (OWLClassExpression expr : superClasses) {
                    if (expr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) {
                        return expr.toString().replaceAll(lt_OR_gt_regex, "");
                    }
                    if (!expr.getClassExpressionType().equals((Object)ClassExpressionType.OBJECT_INTERSECTION_OF)) continue;
                    for (OWLEntity clas : expr.getClassesInSignature()) {
                        if (clas.toString().replaceAll(lt_OR_gt_regex, "").equals(Thing)) continue;
                        return clas.toString().replaceAll(lt_OR_gt_regex, "");
                    }
                }
            }
        }
        return Thing;
    }

    public ComparisonNode find(String iri) {
        for (ComparisonNode node : this.nodes) {
            if (!node.getType().equals(iri)) continue;
            return node;
        }
        if (!iri.equals(Thing)) {
            iri = this.findParent(IRI.create((String)iri));
            return this.find(iri);
        }
        return this.root;
    }

    public ComparisonNode getRoot() {
        return this.root;
    }

    public void newRoot(ComparisonNode rootParent) {
        String rootParentType = rootParent.getType();
        for (ComparisonNode node : this.nodes) {
            if (!node.getType().equals(rootParentType)) continue;
            return;
        }
        rootParent = new ComparisonNode(this.root);
        rootParent.setType(rootParentType);
        rootParent.setChildren(new ArrayList<ComparisonNode>());
        this.root.setParent(rootParent);
        this.root = rootParent;
        this.nodes.add(this.root);
    }

    public void printTree(ComparisonNode node) {
        if (node == null) {
            return;
        }
        node.clear();
        System.err.println(String.valueOf(node.getType()) + "\t" + node.getCardinality());
        System.err.println("Properties");
        int index = 0;
        for (String pred : node.getProperties()) {
            System.err.println(String.valueOf(pred) + "\t" + node.getValueCardinality(index));
            ++index;
        }
        if (!node.getChildren().isEmpty()) {
            for (ComparisonNode temp : node.getChildren()) {
                this.printTree(temp);
            }
        }
    }

    public ComparisonNode create(IRI iri) {
        ArrayList<Object> facts = new ArrayList();
        ComparisonNode ret = new ComparisonNode(iri.toString());
        for (ComparisonNode node : this.nodes) {
            if (node.getType().equals(iri.toString())) {
                Iterator<Object> iterator;
                if (!NLGEngine.isClass(this.manager.getOntologies(), iri) || !(iterator = this.manager.getOntologies().iterator()).hasNext()) continue;
                OWLOntology oWLOntology = (OWLOntology)iterator.next();
                for (OWLEntity oWLEntity : oWLOntology.getEntitiesInSignature(iri)) {
                    for (OWLAxiom oWLAxiom : oWLOntology.getAxioms((OWLClass)oWLEntity)) {
                        String property = "";
                        if (oWLAxiom.getObjectPropertiesInSignature().isEmpty()) continue;
                        for (OWLObjectProperty prop : oWLAxiom.getObjectPropertiesInSignature()) {
                            property = prop.toString();
                            property = property.substring(1, property.length() - 1);
                        }
                        for (OWLNamedIndividual indiv : oWLAxiom.getIndividualsInSignature()) {
                            String individual = indiv.toString();
                            individual = individual.substring(1, individual.length() - 1);
                            if (property.isEmpty()) continue;
                            Fact fact = new Fact(iri, IRI.create((String)property), individual);
                            facts.add(fact);
                        }
                    }
                }
                for (Fact fact : facts) {
                    String string = fact.getPredicate().toString();
                    if (string.equalsIgnoreCase("isA")) continue;
                    ret.addProperty(string, fact.getObject());
                }
                return ret;
            }
            if (NLGEngine.isClass(this.manager.getOntologies(), iri)) {
                Iterator<Object> iterator = this.manager.getOntologies().iterator();
                if (!iterator.hasNext()) continue;
                OWLOntology oWLOntology = (OWLOntology)iterator.next();
                block6: for (OWLEntity oWLEntity : oWLOntology.getEntitiesInSignature(iri)) {
                    if (!oWLEntity.isOWLClass()) continue;
                    OWLClass oWLClass = oWLEntity.asOWLClass();
                    Set superClasses = oWLClass.getSuperClasses(oWLOntology);
                    for (OWLClassExpression expr : superClasses) {
                        if (expr.getClassExpressionType().equals((Object)ClassExpressionType.OWL_CLASS)) continue block6;
                    }
                }
                for (OWLEntity oWLEntity : oWLOntology.getEntitiesInSignature(iri)) {
                    for (OWLAxiom axiom : oWLOntology.getAxioms((OWLClass)oWLEntity)) {
                        String property = "";
                        if (axiom.getObjectPropertiesInSignature().isEmpty()) continue;
                        for (OWLObjectProperty prop : axiom.getObjectPropertiesInSignature()) {
                            property = prop.toString();
                            property = property.substring(1, property.length() - 1);
                        }
                        for (OWLNamedIndividual indiv : axiom.getIndividualsInSignature()) {
                            String individual = indiv.toString();
                            individual = individual.substring(1, individual.length() - 1);
                            if (property.isEmpty()) continue;
                            Fact fact = new Fact(iri, IRI.create((String)property), individual);
                            facts.add(fact);
                        }
                    }
                }
                for (Fact fact : facts) {
                    String property = fact.getPredicate().toString();
                    if (property.equalsIgnoreCase("isA")) continue;
                    String value = fact.getObject();
                    ret.addProperty(property, value);
                }
                return ret;
            }
            facts = this.getFacts(iri);
            for (Fact fact : facts) {
                String string = fact.getPredicate().toString();
                if (string.equalsIgnoreCase("isA")) continue;
                String value = fact.getObject();
                ret.addProperty(string, value);
            }
            return ret;
        }
        return new ComparisonNode(this.root);
    }

    public void remove(ComparisonNode node) {
        int i = 0;
        while (i < this.nodes.size()) {
            if (this.nodes.get(i).equals(node)) {
                if (this.nodes.get(i).getChildren().isEmpty()) {
                    this.nodes.remove(this.nodes.get(i));
                } else {
                    int j = 0;
                    while (j < this.nodes.get(i).getChildren().size()) {
                        this.remove(this.nodes.get(i).getChildren().get(j));
                        ++j;
                    }
                    this.nodes.remove(this.nodes.get(i));
                }
            }
            ++i;
        }
    }

    public ArrayList<ComparisonNode> getNodes() {
        return this.nodes;
    }
}

