/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Comparisons;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class ComparisonNode {
    private String name;
    private int cardinality;
    private ComparisonNode parent;
    private ArrayList<String> properties;
    private ArrayList<ComparisonNode> children;
    private ArrayList<HashMap<String, Integer>> values_cardinality;
    private int age;

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public void setChildren(ArrayList<ComparisonNode> children) {
        this.children = children;
    }

    public ArrayList<HashMap<String, Integer>> getValues_cardinality() {
        return this.values_cardinality;
    }

    public void setProperties(ArrayList<String> properties) {
        this.properties = properties;
    }

    public void setValues_cardinality(ArrayList<HashMap<String, Integer>> values_cardinality) {
        this.values_cardinality = values_cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public ComparisonNode(String uri) {
        this.age = 1;
        this.name = uri;
        this.cardinality = 1;
        this.parent = null;
        this.properties = new ArrayList();
        this.children = new ArrayList();
        this.values_cardinality = new ArrayList();
    }

    public ComparisonNode(ComparisonNode oldNode) {
        this.age = oldNode.getAge();
        this.name = oldNode.getType().toString();
        this.cardinality = oldNode.getCardinality();
        this.parent = null;
        this.properties = new ArrayList();
        this.children = new ArrayList();
        this.values_cardinality = new ArrayList();
        for (String property : oldNode.getProperties()) {
            this.properties.add(property);
        }
        int i = 0;
        while (i < this.properties.size()) {
            this.values_cardinality.add(new HashMap());
            for (String value : oldNode.values_cardinality.get(i).keySet()) {
                this.values_cardinality.get(i).put(value, oldNode.values_cardinality.get(i).get(value));
            }
            ++i;
        }
    }

    public void increaseCardinality() {
        this.age = 1;
        ++this.cardinality;
    }

    public ArrayList<ComparisonNode> getChildren() {
        return this.children;
    }

    public String getValue(String property) {
        this.clear();
        String value = "";
        int index = this.properties.indexOf(property);
        if (index >= 0) {
            Set<String> values = this.values_cardinality.get(index).keySet();
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String val;
                value = val = iterator.next();
            }
        }
        return value;
    }

    private void addChild(ComparisonNode child) {
        this.children.add(child);
    }

    public ComparisonNode getParent() {
        return this.parent;
    }

    public void setParent(ComparisonNode parent) {
        if (parent != null) {
            parent.addChild(this);
            this.parent = parent;
        }
    }

    public String getType() {
        return this.name;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setType(String name) {
        this.name = name;
    }

    public ArrayList<String> getProperties() {
        return this.properties;
    }

    public HashMap<String, Integer> getValueCardinality(int index) {
        return this.values_cardinality.get(index);
    }

    public void removeProperty(String property) {
        int index = this.properties.indexOf(property);
        if (index >= 0) {
            this.properties.remove(index);
            this.values_cardinality.remove(index);
        }
    }

    public void decreaceCardinality(String property, String value) {
        int index = this.properties.indexOf(property);
        if (index >= 0) {
            int valueCardinality = this.values_cardinality.get(index).get(value);
            if (valueCardinality > 1) {
                this.values_cardinality.get(index).put(value, valueCardinality - 1);
            } else {
                this.removeValue(property, value);
            }
        }
    }

    public void removeValue(String property, String value) {
        int index = this.properties.indexOf(property);
        if (index >= 0) {
            this.values_cardinality.get(index).remove(value);
        }
    }

    public void addProperty(String pname, String pvalue) {
        if (this.properties.contains(pname)) {
            int index = this.properties.indexOf(pname);
            if (this.values_cardinality.get(index).keySet().contains(pvalue)) {
                this.values_cardinality.get(index).put(pvalue, this.values_cardinality.get(index).get(pvalue) + 1);
            } else {
                this.values_cardinality.get(index).put(pvalue, 1);
            }
        } else {
            this.properties.add(pname);
            int index = this.properties.indexOf(pname);
            this.values_cardinality.add(new HashMap());
            this.values_cardinality.get(index).put(pvalue, 1);
        }
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.cardinality + "\n" + this.values_cardinality;
    }

    public boolean equals(ComparisonNode node) {
        return this.getType().equals(node.getType());
    }

    public void clear() {
        int i = this.properties.size() - 1;
        while (i >= 0) {
            if (this.values_cardinality.get(i).isEmpty()) {
                this.removeProperty(this.properties.get(i));
            }
            --i;
        }
    }
}

