/*
 * Decompiled with CFR 0.152.
 */
package gr.aueb.cs.nlg.Comparisons;

import gr.aueb.cs.nlg.Languages.Languages;
import org.semanticweb.owlapi.model.IRI;

public class Comparison {
    protected String lang;
    protected boolean same;
    protected boolean many;
    protected String comparator;
    protected String property;
    protected boolean all;
    protected String type;
    protected IRI valueIRI;
    protected String value;

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public boolean isMany() {
        return this.many;
    }

    public void setMany(boolean many) {
        this.many = many;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public String getComparator() {
        return this.comparator;
    }

    public void setComparator(String comparator) {
        this.comparator = comparator;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isSame() {
        return this.same;
    }

    public void setSame(boolean same) {
        this.same = same;
    }

    public String getText() {
        if (Languages.isEnglish(this.lang)) {
            return this.getTextEng();
        }
        return this.getTextGR();
    }

    public String getSuffix() {
        if (Languages.isEnglish(this.lang)) {
            return "that you saw earlier";
        }
        return "\u03c0\u03bf\u03c5 \u03b5\u03af\u03b4\u03b1\u03c4\u03b5 \u03bd\u03c9\u03c1\u03af\u03c4\u03b5\u03c1\u03b1";
    }

    public String getTextEng() {
        if (this.same) {
            return "like";
        }
        return "unlike";
    }

    public String getTextGR() {
        if (this.same) {
            return "\u03cc\u03c0\u03c9\u03c2";
        }
        return "\u03b1\u03bd\u03c4\u03af\u03b8\u03b5\u03c4\u03b1 \u03bc\u03b5";
    }

    public String getReminderConnector() {
        if (Languages.isEnglish(this.lang)) {
            return "which";
        }
        return "\u03c0\u03bf\u03c5";
    }

    public IRI getValueIRI() {
        return this.valueIRI;
    }

    public void setValueIRI(IRI valueIRI) {
        this.valueIRI = valueIRI;
    }

    public Comparison(boolean same, String comparator, String property, boolean all, boolean many, String value) {
        this.valueIRI = IRI.create((String)value);
        this.same = same;
        this.comparator = comparator;
        this.property = property.split("#")[1];
        this.all = all;
        this.many = many;
        this.lang = "";
        if (all) {
            this.type = many ? (same ? "PMAS" : "PMAD") : "POAS";
        } else if (many) {
            this.type = same ? "PMMS" : "PMMD";
        }
    }
}

