/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.testqc;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import fr.inrialpes.tyrexmo.testqc.ContainmentSolver;
import fr.inrialpes.tyrexmo.testqc.ContainmentTestException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestContain {
    static final Logger logger = LoggerFactory.getLogger(TestContain.class);
    private String axiom;
    private Collection<String> axioms;
    private boolean test_under_axioms = false;
    protected Class<?> solverClass = null;
    protected Constructor solverConstructor = null;
    protected Options options = new Options();
    protected String testDir = null;
    protected String schemaFile = null;
    protected String testSuiteFile = null;
    protected String testName = null;
    protected boolean warmup = false;
    protected int timeOut = 5000;
    protected String outputType = "asc";
    protected String outputFile = null;
    protected PrintStream stream = null;
    protected ContainmentSolver solver = null;
    private ExecutorService executor = null;

    public TestContain() {
        this.options.addOption("h", "help", false, "Print this page");
        this.options.addOption("w", "warmup", false, "Run the test with a warmup test");
        OptionBuilder.withLongOpt((String)"directory");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Use the content of the DIRectory as test suite");
        OptionBuilder.withArgName((String)"DIR");
        this.options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"schema");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"RDF Schema FILE");
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withLongOpt((String)"test-suite");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Test suite description FILE");
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((char)'x'));
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Result FILE");
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"test-name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"One test to evaluate");
        OptionBuilder.withArgName((String)"NAME");
        this.options.addOption(OptionBuilder.create((char)'n'));
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output format");
        OptionBuilder.withArgName((String)"TYPE (asc|plot)");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withLongOpt((String)"timeout");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Timeout");
        OptionBuilder.withArgName((String)"MILLISECONDS");
        this.options.addOption(OptionBuilder.create((char)'t'));
    }

    public static void main(String[] stringArray) throws Exception {
        new TestContain().run(stringArray);
    }

    public void run(String[] stringArray) throws Exception, IOException {
        Object object;
        PosixParser posixParser;
        String[] stringArray2 = null;
        try {
            posixParser = new PosixParser();
            object = posixParser.parse(this.options, stringArray);
            if (object.hasOption('h')) {
                this.usage();
                System.exit(0);
            }
            if (object.hasOption('w')) {
                this.warmup = true;
            }
            if (object.hasOption('d')) {
                this.testDir = object.getOptionValue('d');
            }
            if (object.hasOption('s')) {
                this.schemaFile = object.getOptionValue('s');
            }
            if (object.hasOption('x')) {
                this.testSuiteFile = object.getOptionValue('x');
            }
            if (object.hasOption('n')) {
                this.testName = object.getOptionValue('n');
            }
            if (object.hasOption('f')) {
                this.outputType = object.getOptionValue('f');
            }
            if (object.hasOption('o')) {
                this.outputFile = object.getOptionValue('o');
            }
            if (object.hasOption('t')) {
                this.timeOut = Integer.parseInt(object.getOptionValue('t'));
            }
            if ((stringArray2 = object.getArgs()).length < 3 && this.testSuiteFile == null || stringArray2.length < 1) {
                logger.error("Usage: TestContain SolverClass Q1 Q2");
                this.usage();
                System.exit(-1);
            }
        }
        catch (ParseException parseException) {
            logger.error(parseException.getMessage());
            this.usage();
            System.exit(-1);
        }
        posixParser = stringArray2[0];
        this.solverClass = Class.forName((String)posixParser);
        object = new Class[]{};
        this.solverConstructor = this.solverClass.getConstructor((Class<?>)object);
        this.stream = this.outputFile == null ? System.out : new PrintStream(new FileOutputStream(this.outputFile, true));
        if (this.testSuiteFile != null && this.outputType.equals("shell")) {
            this.generateShell(this.testSuiteFile, (String)posixParser);
            return;
        }
        object = null;
        if (this.testSuiteFile != null) {
            object = this.testSuite(this.testSuiteFile);
            this.displayResults((Vector<Result>)object);
        } else if (stringArray2.length > 2) {
            String string = stringArray2[1];
            String string2 = stringArray2[2];
            Result result = this.testOneContainment(null, string, string2);
            logger.debug("Answer : {} [Time: {}ms]", (Object)result.answer, (Object)result.time);
            if (result.status == 0) {
                if (result.answer) {
                    System.err.println("    CONTAINED [" + result.time + "ms]");
                } else {
                    System.err.println("NON CONTAINED [" + result.time + "ms]");
                }
            } else if (result.status == -2) {
                System.err.println("** TIMEOUT **");
                System.exit(-1);
            } else {
                System.err.println("** ERROR **");
            }
        } else {
            logger.warn("Something went wrong");
        }
        System.exit(0);
    }

    public void usage() {
        Package package_ = this.getClass().getPackage();
        new HelpFormatter().printHelp(80, package_ + " [options] solverClass query1 query2\nTests query containment", "\nOptions:", this.options, "");
    }

    public Vector<Result> testSuite(String string) throws Exception {
        Resource resource;
        RDFNode rDFNode;
        String string2 = null;
        File file = new File(string).getParentFile();
        Vector<Result> vector = new Vector<Result>();
        Model model = ModelFactory.createDefaultModel();
        Resource resource2 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#TestSuite");
        Property property = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#sourceDir");
        Property property2 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#hasTest");
        Resource resource3 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#ContainmentTest");
        Resource resource4 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#WarmupContainmentTest");
        Property property3 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#sourceQuery");
        Property property4 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#targetQuery");
        Property property5 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#rdfSchema");
        Property property6 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#result");
        try {
            model.read((InputStream)new FileInputStream(string), null);
        }
        catch (Exception exception) {
            throw new Exception("Cannot parse suite file", exception);
        }
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)resource2);
        if (!stmtIterator.hasNext()) {
            throw new Exception("Bad test suite specification");
        }
        Resource resource5 = stmtIterator.nextStatement().getSubject();
        if (resource5.hasProperty(property)) {
            rDFNode = resource5.getProperty(property).getObject();
            if (!rDFNode.isLiteral()) {
                throw new Exception("Source directory must be a directory");
            }
            string2 = new File(file, ((Literal)rDFNode).getString()).toString() + File.separator;
        }
        if (resource5.hasProperty(property2) && (rDFNode = resource5.getProperty(property2).getObject()) instanceof Resource && (resource = (Resource)rDFNode) != null) {
            while (!RDF.nil.getURI().equals(resource.getURI())) {
                Resource resource6 = resource.getProperty(RDF.first).getResource();
                if (resource4.equals(resource6.getProperty(RDF.type).getResource()) || this.testName == null || resource6.getURI().toString().endsWith(this.testName)) {
                    try {
                        Statement statement = resource6.getProperty(property3);
                        if (statement == null) {
                            throw new Exception("Test must contain a source query");
                        }
                        String string3 = string2 + statement.getString();
                        statement = resource6.getProperty(property4);
                        if (statement == null) {
                            throw new Exception("Test must contain a target query");
                        }
                        String string4 = string2 + statement.getString();
                        statement = resource6.getProperty(property5);
                        String string5 = null;
                        if (statement != null) {
                            string5 = string2 + statement.getString();
                        }
                        if ((statement = resource6.getProperty(property6)) == null) {
                            throw new Exception("Test must contain an expected result");
                        }
                        boolean bl = Boolean.parseBoolean(statement.getString());
                        logger.info("Test : " + string3 + " < " + string4 + " (" + bl + ")");
                        Result result = this.testOneContainment(string5, string3, string4);
                        result.name = resource6.toString();
                        result.expected = bl;
                        logger.info("Answer({}) : {} [Time: {}ms]", new Object[]{result.status, result.answer, result.time});
                        Resource resource7 = resource6.getProperty(RDF.type).getResource();
                        if (resource3.equals(resource6.getProperty(RDF.type).getResource())) {
                            vector.add(result);
                        }
                    }
                    catch (Exception exception) {
                        logger.debug("IGNORED Exception", (Throwable)exception);
                    }
                }
                resource = resource.getProperty(RDF.rest).getResource();
            }
        }
        model.close();
        return vector;
    }

    public Result testOneContainment(String string, String string2, String string3) throws Exception {
        if (string2 != null && string3 != null) {
            try {
                Query query = QueryFactory.read((String)string2);
                Query query2 = QueryFactory.read((String)string3);
                System.gc();
                this.executor = Executors.newFixedThreadPool(1);
                long l = System.currentTimeMillis();
                Result result = this.testContainmentWithTimeOut(string, query, query2, this.timeOut);
                long l2 = System.currentTimeMillis();
                result.time = l2 - l;
                return result;
            }
            catch (Exception exception) {
                logger.warn("Incorrect execution", (Throwable)exception);
                return new Result(-1);
            }
        }
        throw new Exception("Need two queries to test");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Result testContainmentWithTimeOut(final String string, final Query query, final Query query2, int n) {
        Future<Result> future = this.executor.submit(new Callable<Result>(){

            public void interrupt() {
            }

            @Override
            public Result call() {
                return TestContain.this.testContainment(string, query, query2);
            }
        });
        try {
            Result result = future.get(n, TimeUnit.MILLISECONDS);
            return result;
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
            this.executor.shutdownNow();
            Result result = new Result(-2);
            return result;
        }
        catch (Throwable throwable) {
            logger.warn("Incorrect execution", throwable);
            future.cancel(true);
            this.executor.shutdownNow();
            Result result = new Result(-1);
            this.executor.shutdownNow();
            try {
                this.solver.cleanup();
            }
            catch (ContainmentTestException containmentTestException) {
                // empty catch block
            }
            return result;
        }
        finally {
            this.executor.shutdownNow();
            try {
                this.solver.cleanup();
            }
            catch (ContainmentTestException containmentTestException) {}
        }
    }

    public Result testContainment(String string, Query query, Query query2) {
        try {
            Object[] objectArray = new Object[]{};
            this.solver = (ContainmentSolver)this.solverConstructor.newInstance(objectArray);
            logger.info("Solver created: {}", (Object)this.solver);
            if (string != null) {
                return new Result(this.solver.entailedUnderSchema(string, query, query2), 0.0);
            }
            return new Result(this.solver.entailed(query, query2), 0.0);
        }
        catch (InstantiationException instantiationException) {
            return new Result(-1);
        }
        catch (IllegalAccessException illegalAccessException) {
            return new Result(-1);
        }
        catch (InvocationTargetException invocationTargetException) {
            return new Result(-1);
        }
        catch (ContainmentTestException containmentTestException) {
            logger.debug("Raised CTEX", (Throwable)containmentTestException);
            return new Result(-1);
        }
        catch (Throwable throwable) {
            logger.error("Got that error", throwable);
            return new Result(-1);
        }
    }

    public void displayResults(Vector<Result> vector) {
        if (this.outputType.equals("asc")) {
            this.displayResultsAsc(vector);
        } else if (this.outputType.equals("plot")) {
            this.displayResultsPlot(vector);
        }
    }

    public void displayResultsAsc(Vector<Result> vector) {
        double d = 0.0;
        int n = 0;
        for (Result result : vector) {
            String string = result.name.substring(result.name.lastIndexOf(35) + 1) + "\t";
            if (result.status == 0) {
                d += result.time;
                if (result.expected == result.answer) {
                    ++n;
                    string = string + "CORRECT";
                } else {
                    string = string + "INCORRECT";
                }
                string = string + "\t" + result.time;
            } else if (result.status == -1) {
                string = string + "*ERROR*";
            } else if (result.status == -2) {
                string = string + "*TIMEOUT (" + this.timeOut + "ms)*";
            }
            this.stream.println(string);
        }
        System.out.println("Total score : " + n + "/" + vector.size());
        System.out.println("Total time : " + d + "ms");
    }

    public void displayResultsPlot(Vector<Result> vector) {
        for (Result result : vector) {
            String string = result.name.substring(result.name.lastIndexOf(35) + 1) + "\t";
            if (result.status == 0) {
                string = string + result.time;
            }
            this.stream.println(string);
        }
    }

    public void generateShell(String string, String string2) throws Exception {
        Resource resource;
        RDFNode rDFNode;
        String string3 = "java -Xms1512m -Xmx2024m -Djava.library.path=lib -jar lib/containmenttester.jar " + string2 + " ";
        if (this.warmup) {
            string3 = string3 + "-w ";
        }
        String string4 = null;
        File file = new File(string).getParentFile();
        Vector vector = new Vector();
        Model model = ModelFactory.createDefaultModel();
        Resource resource2 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#TestSuite");
        Property property = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#sourceDir");
        Property property2 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#hasTest");
        Resource resource3 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#ContainmentTest");
        Resource resource4 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#WarmupContainmentTest");
        Property property3 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#sourceQuery");
        Property property4 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#targetQuery");
        Property property5 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#result");
        try {
            model.read((InputStream)new FileInputStream(string), null);
        }
        catch (Exception exception) {
            throw new Exception("Cannot parse suite file", exception);
        }
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)resource2);
        if (!stmtIterator.hasNext()) {
            throw new Exception("Bad test suite specification");
        }
        Resource resource5 = stmtIterator.nextStatement().getSubject();
        if (resource5.hasProperty(property)) {
            rDFNode = resource5.getProperty(property).getObject();
            if (!rDFNode.isLiteral()) {
                throw new Exception("Source directory must be a directory");
            }
            string4 = new File(file, ((Literal)rDFNode).getString()).toString() + File.separator;
        }
        if (resource5.hasProperty(property2) && (rDFNode = resource5.getProperty(property2).getObject()) instanceof Resource && (resource = (Resource)rDFNode) != null) {
            while (!RDF.nil.getURI().equals(resource.getURI())) {
                Resource resource6 = resource.getProperty(RDF.first).getResource();
                if (!resource4.equals(resource6.getProperty(RDF.type).getResource())) {
                    try {
                        Statement statement = resource6.getProperty(property3);
                        if (statement == null) {
                            throw new Exception("Test must contain a source query");
                        }
                        String string5 = string4 + statement.getString();
                        statement = resource6.getProperty(property4);
                        if (statement == null) {
                            throw new Exception("Test must contain a target query");
                        }
                        String string6 = string4 + statement.getString();
                        statement = resource6.getProperty(property5);
                        if (statement == null) {
                            throw new Exception("Test must contain an expected result");
                        }
                        boolean bl = Boolean.parseBoolean(statement.getString());
                        this.stream.println("echo '--------------------------------------------'");
                        this.stream.println("echo " + resource6.toString());
                        this.stream.println("echo 'Test : " + string5 + " < " + string6 + " =======> " + bl + "'");
                        String string7 = resource6.toString();
                        this.stream.println(string3 + "-x " + string + " -n " + string7.substring(string7.lastIndexOf(35) + 1) + " -f plot -o results.tsv");
                    }
                    catch (Exception exception) {
                        logger.debug("IGNORED Exception", (Throwable)exception);
                    }
                }
                resource = resource.getProperty(RDF.rest).getResource();
            }
        }
        this.stream.println("echo 'Results are in results.tsv'");
        model.close();
    }

    class Result {
        public String name;
        public int status = -1;
        public double time;
        public boolean answer;
        public boolean expected;

        public Result(int n) {
            this.status = n;
        }

        public Result(boolean bl, double d) {
            this.answer = bl;
            this.time = d;
            this.status = 0;
        }
    }
}

