/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.testqc;

import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiteTool {
    static final Logger logger = LoggerFactory.getLogger(SuiteTool.class);
    protected Options options = new Options();
    protected String testSuiteFile = null;
    protected String outputType = "html";
    protected String outputFile = null;
    protected PrintStream stream = null;
    File directory = null;

    public SuiteTool() {
        this.options.addOption("h", "help", false, "Print this page");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Result FILE");
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output format [NIY]");
        OptionBuilder.withArgName((String)"TYPE (asc|plot)");
        this.options.addOption(OptionBuilder.create((char)'f'));
    }

    public static void main(String[] stringArray) throws Exception {
        new SuiteTool().run(stringArray);
    }

    public void run(String[] stringArray) throws Exception, IOException {
        String[] stringArray2 = null;
        try {
            PosixParser posixParser = new PosixParser();
            CommandLine commandLine = posixParser.parse(this.options, stringArray);
            if (commandLine.hasOption('h')) {
                this.usage();
                System.exit(0);
            }
            if (commandLine.hasOption('f')) {
                this.outputType = commandLine.getOptionValue('f');
            }
            if (commandLine.hasOption('o')) {
                this.outputFile = commandLine.getOptionValue('o');
            }
            if ((stringArray2 = commandLine.getArgs()).length < 1) {
                logger.error("Usage: TestContain SolverClass Q1 Q2");
                this.usage();
                System.exit(-1);
            }
        }
        catch (ParseException parseException) {
            logger.error(parseException.getMessage());
            this.usage();
            System.exit(-1);
        }
        this.testSuiteFile = stringArray2[0];
        this.stream = this.outputFile == null ? System.out : new PrintStream(new FileOutputStream(this.outputFile));
        this.render(this.testSuiteFile);
    }

    public void usage() {
        Package package_ = this.getClass().getPackage();
        new HelpFormatter().printHelp(80, package_ + " [options] testSuiteFile\nRenders a test suite", "\nOptions:", this.options, "");
    }

    public void render(String string) throws Exception {
        this.directory = new File(string).getParentFile();
        Model model = ModelFactory.createDefaultModel();
        try {
            model.read((InputStream)new FileInputStream(string), null);
        }
        catch (Exception exception) {
            throw new Exception("Cannot parse suite file", exception);
        }
        this.printHTMLHeader();
        this.printHTMLContent(model);
        this.printHTMLFooter();
        model.close();
    }

    public void printHTMLHeader() {
        this.stream.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        this.stream.println("<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">");
        this.stream.println("<head>");
        this.stream.println("<title>SPARQL Containment Benchmark</title>");
        this.stream.println("<meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />");
        this.stream.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"style.css\" media=\"screen\" />");
        this.stream.println();
        this.stream.println("    <link href=\"bootstrap/css/bootstrap.css\" rel=\"stylesheet\">");
        this.stream.println("    <link href=\"bootstrap/css/bootstrap-responsive.css\" rel=\"stylesheet\">");
        this.stream.println("    <link href=\"bootstrap/css/prettify.css\" rel=\"stylesheet\">");
        this.stream.println("    <link href=\"bootstrap/css/docs.css\" rel=\"stylesheet\">");
        this.stream.println();
        this.stream.println("</head>");
        this.stream.println("<body>");
        this.stream.println("<div id=\"centerColumn\">");
        this.stream.println("  <div id=\"header\">");
        this.stream.println("    <h1>SPARQL Query Containment Benchmark</h1>");
        this.stream.println("        <h2><a href=\"http://exmo.inrialpes.fr/\">Exmo</a> &#38; <a href=\"http://tyrex.inria.fr/\">Tyrex</a>, <a href=\"http://www.inria.fr\">INRIA</a></h2>");
        this.stream.println("  </div>");
        this.stream.println("  <br />");
        this.stream.println();
        this.stream.println("  <hr />");
        this.stream.println("  <div id=\"nav\">");
        this.stream.println("    <ul>");
        this.stream.println("      <li><a href=\"index.html\"><b>Home</b></a></li>");
        this.stream.println("      <li><a href=\"benchmark.html\"><b>Benchmark</b></a></li>");
        this.stream.println("      <li><a href=\"download.html\"><b>Download</b></a></li>");
        this.stream.println("      <li><a href=\"about.html\"><b>About</b></a></li>");
        this.stream.println("    </ul>");
        this.stream.println("  </div>");
        this.stream.println("  <hr/>");
        this.stream.println();
    }

    public void printHTMLContent(Model model) throws Exception {
        Resource resource;
        RDFNode rDFNode;
        String string;
        Resource resource2 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#TestSuite");
        Property property = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#sourceDir");
        Property property2 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#hasTest");
        Resource resource3 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#ContainmentTest");
        Resource resource4 = model.createResource("http://sparql-qc-bench.inrialpes.fr/testsuite#WarmupContainmentTest");
        Property property3 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#sourceQuery");
        Property property4 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#targetQuery");
        Property property5 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#rdfSchema");
        Property property6 = model.createProperty("http://sparql-qc-bench.inrialpes.fr/testsuite#result");
        StmtIterator stmtIterator = model.listStatements(null, RDF.type, (RDFNode)resource2);
        if (!stmtIterator.hasNext()) {
            throw new Exception("Bad test suite specification");
        }
        Resource resource5 = stmtIterator.nextStatement().getSubject();
        String string2 = this.directory.toString() + File.separator;
        if (resource5.hasProperty(property)) {
            string = resource5.getProperty(property).getObject();
            if (!string.isLiteral()) {
                throw new Exception("Source directory must be a directory");
            }
            string2 = string2 + ((Literal)string).getString() + File.separator;
        }
        string = resource5.getLocalName();
        String string3 = resource5.getProperty(RDFS.label).getString();
        String string4 = resource5.getProperty(RDFS.comment).getString();
        this.stream.println("  <h2>" + string + " : " + string3 + "</h2>");
        this.stream.println("  <p>" + string4 + "</p>");
        this.stream.println("  <div class=\"accordion\" id=\"accordion2\">");
        if (resource5.hasProperty(property2) && (rDFNode = resource5.getProperty(property2).getObject()) instanceof Resource && (resource = (Resource)rDFNode) != null) {
            while (!RDF.nil.getURI().equals(resource.getURI())) {
                Resource resource6 = resource.getProperty(RDF.first).getResource();
                if (!resource4.equals(resource6.getProperty(RDF.type).getResource())) {
                    try {
                        String string5 = resource6.getURI().toString();
                        string5 = string5.substring(string5.lastIndexOf(35) + 1);
                        Statement statement = resource6.getProperty(property3);
                        if (statement == null) {
                            throw new Exception("Test must contain a source query");
                        }
                        String string6 = statement.getString();
                        String string7 = string2 + string6;
                        statement = resource6.getProperty(property4);
                        if (statement == null) {
                            throw new Exception("Test must contain a target query");
                        }
                        String string8 = statement.getString();
                        String string9 = string2 + string8;
                        statement = resource6.getProperty(property5);
                        String string10 = null;
                        String string11 = null;
                        if (statement != null) {
                            string11 = statement.getString();
                            string10 = string2 + string11 + ".rdfs";
                        }
                        if ((statement = resource6.getProperty(property6)) == null) {
                            throw new Exception("Test must contain an expected result");
                        }
                        String string12 = statement.getString();
                        this.stream.println("            <div class=\"accordion-group\">");
                        this.stream.println("              <div class=\"accordion-heading\">");
                        this.stream.println("                <a class=\"accordion-toggle\" data-toggle=\"collapse\" data-parent=\"#accordion2\" href=\"#" + string5 + "\">");
                        this.stream.print("                  " + string5 + " : ");
                        if (string10 != null) {
                            this.stream.print(string11 + " &models; ");
                        } else {
                            this.stream.print("&nbsp;&nbsp;&nbsp;&nbsp; ");
                        }
                        this.stream.println(string6 + " &sqsube;  " + string8 + " : " + string12 + "</a><br />");
                        this.stream.println("        </div>");
                        this.stream.println("        <div id=\"" + string5 + "\" class=\"accordion-body in collapse\" style=\"height: auto;\">");
                        this.stream.println("          <div class=\"accordion-inner\">");
                        if (string10 != null) {
                            this.stream.print("<center><a href=\"" + string10 + "\">" + string11 + "</a> &models;</center>");
                        }
                        this.stream.println("            <table>");
                        this.stream.println("              <thead>");
                        this.stream.println("                <tr>");
                        this.stream.println("                  <th style=\"width: 400px;\">" + string6 + "</th>");
                        this.stream.println("                  <th></th>");
                        this.stream.println("                  <th style=\"width: 400px;\">" + string8 + "</th>");
                        this.stream.println("                </tr>");
                        this.stream.println("              </thead>");
                        this.stream.println("              <tbody>");
                        this.stream.println("                <tr>");
                        this.stream.println("                  <td>");
                        this.printHTMLQuery(string7);
                        this.stream.println("                  </td>");
                        this.stream.println("                  <td></td>");
                        this.stream.println("                  <td>");
                        this.printHTMLQuery(string9);
                        this.stream.println("                  </td>");
                        this.stream.println("                </tr>");
                        this.stream.println("              </tbody>");
                        this.stream.println("            </table>");
                        this.stream.println("          </div>");
                        this.stream.println("        </div>");
                        this.stream.println("      </div>");
                    }
                    catch (Exception exception) {
                        logger.debug("IGNORED Exception", (Throwable)exception);
                    }
                }
                resource = resource.getProperty(RDF.rest).getResource();
            }
            this.stream.println("    </div>");
        }
    }

    public void printHTMLQuery(String string) {
        this.stream.println("                        <pre>");
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                this.stream.println(string2);
            }
        }
        catch (IOException iOException) {
            this.stream.println("Cannot open query " + string);
            logger.warn("Cannot open file", (Throwable)iOException);
        }
        this.stream.println("                        </pre>");
    }

    public void printHTMLFooter() {
        this.stream.println("    <!-- footer -->");
        this.stream.println("   <div id=\"footer\" style=\"font-size: +2\"></div>");
        this.stream.println();
        this.stream.println("   Generated on " + new Date().toString() + " with SuiteTool.");
        this.stream.println("    <script src=\"bootstrap/js/jquery.js\" type=\"text/javascript\"></script>");
        this.stream.println("    <script src=\"bootstrap/js/bootstrap-collapse.js\" type=\"text/javascript\"></script>");
        this.stream.println("    <script src=\"bootstrap/js/bootstrap.min.js\" type=\"text/javascript\"></script>");
        this.stream.println("    <script type=\"text/javascript\">");
        this.stream.println("       $(document).ready(function() {");
        this.stream.println("          // popover demo");
        this.stream.println("        $(\"a[rel=popover]\")");
        this.stream.println("                .popover()");
        this.stream.println("                .click(function(e) {");
        this.stream.println("                e.preventDefault()");
        this.stream.println("        });");
        this.stream.println("        });");
        this.stream.println("    </script>");
        this.stream.println();
        this.stream.println("</body></html>");
    }
}

